source stooop.tcl
namespace import stooop::*

### check various virtual procedures configurations in a 3 level deep class hierarchy
# (see 75.tcl for nested class version)

# expected output:

## c::f 1 x y z
## c::g 1 x y z
## b::h 1 x y z
## b::i 1 x y z
## c::k 1 x y z
## c::l 1 x y z

## C::f 2 x y z
## C::g 2 x y z
## B::h 2 x y z
## B::i 2 x y z
## C::k 2 x y z
## C::l 2 x y z

class a {}
proc a::a {this} {}
proc a::~a {this} {}
virtual proc a::f {this p q} {}
virtual proc a::g {this p q}
virtual proc a::h {this p q} {
    puts "a::h $this $p $q"
}
virtual proc a::i {this p q} {
    puts "a::i $this $p $q"
}
virtual proc a::k {this p q}
virtual proc a::l {this p q} {
    puts "a::l $this $p $q"
}
class b {}
proc b::b {this} a {} {}
proc b::~b {this} {}
virtual proc b::f {this p q} {
    puts "b::f $this $p $q"
}
virtual proc b::g {this p q}
virtual proc b::h {this p q} {
    puts "b::h $this $p $q"
}
proc b::i {this p q} {
    puts "b::i $this $p $q"
}
virtual proc b::k {this p q} {
    puts "b::k $this $p $q"
}
virtual proc b::l {this p q}
class c {}
proc c::c {this} b {} {}
proc c::~c {this} {}
proc c::f {this p q} {
    puts "c::f $this $p $q"
}
proc c::g {this p q} {
    puts "c::g $this $p $q"
}
proc c::i {this p q} {
    puts "c::i $this $p $q"
}
proc c::k {this p q} {
    puts "c::k $this $p $q"
}
proc c::l {this p q} {
    puts "c::l $this $p $q"
}
set o [new c]
a::f $o x {y z}
a::g $o x {y z}
a::h $o x {y z}
a::i $o x {y z}
a::k $o x {y z}
a::l $o x {y z}

class A {
    proc A {this} {}
    proc ~A {this} {}
    virtual proc f {this p q} {}
    virtual proc g {this p q}
    virtual proc h {this p q} {
        puts "A::h $this $p $q"
    }
    virtual proc i {this p q} {
        puts "A::i $this $p $q"
    }
    virtual proc k {this p q}
    virtual proc l {this p q} {
        puts "A::l $this $p $q"
    }
}
class B {
    proc B {this} A {} {}
    proc ~B {this} {}
    virtual proc f {this p q} {
        puts "B::f $this $p $q"
    }
    virtual proc g {this p q}
    virtual proc h {this p q} {
        puts "B::h $this $p $q"
    }
    proc i {this p q} {
        puts "B::i $this $p $q"
    }
    virtual proc k {this p q} {
        puts "B::k $this $p $q"
    }
    virtual proc l {this p q}
}
class C {
    proc C {this} B {} {}
    proc ~C {this} {}
    proc f {this p q} {
        puts "C::f $this $p $q"
    }
    proc g {this p q} {
        puts "C::g $this $p $q"
    }
    proc i {this p q} {
        puts "C::i $this $p $q"
    }
    proc k {this p q} {
        puts "C::k $this $p $q"
    }
    proc l {this p q} {
        puts "C::l $this $p $q"
    }
}
set o [new C]
A::f $o x {y z}
A::g $o x {y z}
A::h $o x {y z}
A::i $o x {y z}
A::k $o x {y z}
A::l $o x {y z}
