source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that class constructor with multiple base classes allows new lines within base class constructors arguments

# expected output:
## a::a 1
## b::b 1
## c::c 1
## a::(1,_derived) = ::c
## a::(1,m) = x y
## b::(1,_derived) = ::c
## b::(1,n) = z
## c::(1,o) = 1 2

## A::A 2
## B::B 2
## C::C 2
## A::(2,_derived) = ::C
## A::(2,m) = x y
## B::(2,_derived) = ::C
## B::(2,n) = z
## C::(2,o) = 1 2

## e::e 3
## f::f 3
## g::g 3
## d::e::(3,_derived) = ::d::g
## d::e::(3,m) = x y
## d::f::(3,_derived) = ::d::g
## d::f::(3,n) = z
## d::g::(3,o) = 1 2

## E::E 4
## F::F 4
## G::G 4
## E::(4,_derived) = ::D::G
## E::(4,m) = x y
## F::(4,_derived) = ::D::G
## F::(4,n) = z
## G::(4,o) = 1 2

## E::E 5
## F::F 5
## G::G 5
## D::E::(4,_derived) = ::D::G
## D::E::(4,m) = x y
## D::E::(5,_derived) = ::D::G
## D::E::(5,m) = x y
## D::F::(4,_derived) = ::D::G
## D::F::(4,n) = z
## D::F::(5,_derived) = ::D::G
## D::F::(5,n) = z
## D::G::(4,o) = 1 2
## D::G::(5,o) = 1 2

class a {}
proc a::a {this p} {
    puts "a::a $this"
    set ($this,m) $p
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this p} {
    puts "b::b $this"
    set ($this,n) $p
}
proc b::~b {this} {
    puts "b::~b $this"
}
class c {}
proc c::c {this p q r} a {
    $p
} b {
    $q
} {
    puts "c::c $this"
    set ($this,o) $r
}
proc c::~c {this} {
    puts "c::~c $this"
}
new c {x y} z {1 2}
printArrays a:: b:: c::

class A {
    proc A {this p} {
        puts "A::A $this"
        set ($this,m) $p
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this p} {
        puts "B::B $this"
        set ($this,n) $p
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
class C {
    proc C {this p q r} A {
        $p
    } B {
        $q
    } {
        puts "C::C $this"
        set ($this,o) $r
    }
    proc ~C {this} {
        puts "C::~C $this"
    }
}
new C {x y} z {1 2}
printArrays A:: B:: C::

class d {}
class d::e {}
proc d::e::e {this p} {
    puts "e::e $this"
    set ($this,m) $p
}
proc d::e::~e {this} {
    puts "e::~e $this"
}
class d::f {}
proc d::f::f {this p} {
    puts "f::f $this"
    set ($this,n) $p
}
proc d::f::~f {this} {
    puts "f::~f $this"
}
class d::g {}
proc d::g::g {this p q r} d::e {
    $p
} d::f {
    $q
} {
    puts "g::g $this"
    set ($this,o) $r
}
proc d::g::~g {this} {
    puts "g::~g $this"
}
new d::g {x y} z {1 2}
printArrays d::e:: d::f:: d::g::

class D {
    class E {
        proc E {this p} {
            puts "E::E $this"
            set ($this,m) $p
        }
        proc ~E {this} {
            puts "E::~E $this"
        }
    }
    class F {
        proc F {this p} {
            puts "F::F $this"
            set ($this,n) $p
        }
        proc ~F {this} {
            puts "F::~F $this"
        }
    }
    class G {
        proc G {this p q r} D::E {
            $p
        } D::F {
            $q
        } {
            puts "G::G $this"
            set ($this,o) $r
        }
        proc ~G {this} {
            puts "G::~G $this"
        }
    }
    new G {x y} z {1 2}
    printArrays E:: F:: G::
}
new D::G {x y} z {1 2}
printArrays D::E:: D::F:: D::G::
