source stooop.tcl
namespace import stooop::*

### check that a direct base class is not specified more than once in a class constructor declaration

# expected output:
## class ::c directly inherits from class ::a more than once
## class ::C directly inherits from class ::A more than once
## class ::d::g directly inherits from class ::d::e more than once
## class ::D::G directly inherits from class ::D::E more than once

catch {
    class a {}
    proc a::a {this} {}
    class c {}
    proc c::c {this} a {} a {} {}
} message
puts $message

catch {
    class A {
        proc A {this} {}
    }
    class C {
        proc C {this} A {} A {} {}
    }
} message
puts $message

catch {
    class d {}
    class d::e {}
    proc d::e::e {this} {}
    class d::g {}
    proc d::g::g {this} d::e {} d::e {} {}
} message
puts $message

catch {
    class D {
        class E {
            proc E {this} {}
        }
        class G {
            proc G {this} D::E {} D::E {} {}
        }
    }
} message
puts $message
