source stooop.tcl
namespace import stooop::*

### check that base class of class with multiple base classes is defined

# expected output:
## class ::c constructor defined before base class b constructor
## class ::C constructor defined before base class B constructor
## class ::d::g constructor defined before base class d::f constructor
## class ::C::G constructor defined before base class C::F constructor

catch {
    class a {}
    proc a::a {this} {}
    class b {}
    class c {}
    proc c::c {this} a {} b {} {}
} message
puts $message

catch {
    class A {
        proc A {this} {}
    }
    class B {}
    class C {
        proc C {this} A {} B {} {}
    }
} message
puts $message

catch {
    class d {}
    class d::e {}
    proc d::e::e {this} {}
    class d::f {}
    class d::g {}
    proc d::g::g {this} d::e {} d::f {} {}
} message
puts $message

catch {
    class C {
        class E {
            proc E {this} {}
        }
        class F {}
        class G {
            proc G {this} C::E {} C::F {} {}
        }
    }
} message
puts $message
