source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## b::b 1
## b::f 1 x y z
## a::h 1 x y z
## b::g 1 x y {1 2} 3 {4 5}
## a::g 1 x y {1 2} 3 {4 5}

## A::A 2
## B::B 2
## B::f 2 x y z
## A::h 2 x y z
## B::g 2 x y {1 2} 3 {4 5}
## A::g 2 x y {1 2} 3 {4 5}

## d::d 3
## e::e 3
## e::f 3 x y z
## d::h 3 x y z
## e::g 3 x y {1 2} 3 {4 5}
## d::g 3 x y {1 2} 3 {4 5}

## D::D 4
## E::E 4
## E::f 4 x y z
## D::h 4 x y z
## E::g 4 x y {1 2} 3 {4 5}
## D::g 4 x y {1 2} 3 {4 5}

## D::D 5
## E::E 5
## E::f 5 x y z
## D::h 5 x y z
## E::g 5 x y {1 2} 3 {4 5}
## D::g 5 x y {1 2} 3 {4 5}

class a {}
proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {
    puts "a::~a $this"
}
virtual proc a::f {this p q} {
    puts "a::h $this $p $q"
}
virtual proc a::g {this p args} {
    puts "a::g $this $p $args"
}
class b {}
proc b::b {this} a {} {
    puts "b::b $this"
}
proc b::~b {this} {
    puts "b::~b $this"
}
proc b::f {this p q} {
    puts "b::f $this $p $q"
    a::_f $this $p $q
}
proc b::g {this p args} {
    puts "b::g $this $p $args"
    eval a::_g $this $p $args
}
set o [new b]
a::f $o x {y z}
a::g $o {x y} {1 2} 3 {4 5}

class A {
    proc A {this} {
        puts "A::A $this"
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
    virtual proc f {this p q} {
        puts "A::h $this $p $q"
    }
    virtual proc g {this p args} {
        puts "A::g $this $p $args"
    }
}
class B {
    proc B {this} A {} {
        puts "B::B $this"
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
    proc f {this p q} {
        puts "B::f $this $p $q"
        A::_f $this $p $q
    }
    proc g {this p args} {
        puts "B::g $this $p $args"
        eval A::_g $this $p $args
    }
}
set o [new B]
A::f $o x {y z}
A::g $o {x y} {1 2} 3 {4 5}

class c {}
class c::d {}
proc c::d::d {this} {
    puts "d::d $this"
}
proc c::d::~d {this} {
    puts "d::~d $this"
}
virtual proc c::d::f {this p q} {
    puts "d::h $this $p $q"
}
virtual proc c::d::g {this p args} {
    puts "d::g $this $p $args"
}
class c::e {}
proc c::e::e {this} c::d {} {
    puts "e::e $this"
}
proc c::e::~e {this} {
    puts "e::~e $this"
}
proc c::e::f {this p q} {
    puts "e::f $this $p $q"
    c::d::_f $this $p $q
}
proc c::e::g {this p args} {
    puts "e::g $this $p $args"
    eval c::d::_g $this $p $args
}
set o [new c::e]
c::d::f $o x {y z}
c::d::g $o {x y} {1 2} 3 {4 5}

class C {
    class D {
        proc D {this} {
            puts "D::D $this"
        }
        proc ~D {this} {
            puts "D::~D $this"
        }
        virtual proc f {this p q} {
            puts "D::h $this $p $q"
        }
        virtual proc g {this p args} {
            puts "D::g $this $p $args"
        }
    }
    class E {
        proc E {this} C::D {} {
            puts "E::E $this"
        }
        proc ~E {this} {
            puts "E::~E $this"
        }
        proc f {this p q} {
            puts "E::f $this $p $q"
            C::D::_f $this $p $q
        }
        proc g {this p args} {
            puts "E::g $this $p $args"
            eval C::D::_g $this $p $args
        }
    }
    set o [new E]
    D::f $o x {y z}
    D::g $o {x y} {1 2} 3 {4 5}
}
set o [new C::E]
C::D::f $o x {y z}
C::D::g $o {x y} {1 2} 3 {4 5}
