source parray.tcl
source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1 {1 2} 3
## b::b 1 {1 2} 3
## a::(1,_derived) = ::b
## a::(1,m) = 1 2
## b::(1,n) = 1 2

## A::A 2 {1 2} 3
## B::B 2 {1 2} 3
## A::(2,_derived) = ::B
## A::(2,m) = 1 2
## B::(2,n) = 1 2

## d::d 3 {1 2} 3
## e::e 3 {1 2} 3
## c::d::(3,_derived) = ::c::e
## c::d::(3,m) = 1 2
## c::e::(3,n) = 1 2

## D::D 4 {1 2} 3
## E::E 4 {1 2} 3
## D::(4,_derived) = ::C::E
## D::(4,m) = 1 2
## E::(4,n) = 1 2

## D::D 5 {1 2} 3
## E::E 5 {1 2} 3
## C::D::(4,_derived) = ::C::E
## C::D::(4,m) = 1 2
## C::D::(5,_derived) = ::C::E
## C::D::(5,m) = 1 2
## C::E::(4,n) = 1 2
## C::E::(5,n) = 1 2

class a {}
proc a::a {this args} {
    puts "a::a $this $args"
    set ($this,m) [lindex $args 0]
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this args} a {$args} {
    puts "b::b $this $args"
    set ($this,n) [lindex $args 0]
}
proc b::~b {this} {
    puts "b::~b $this"
}
new b {1 2} 3
printArrays a:: b::

class A {
    proc A {this args} {
        puts "A::A $this $args"
        set ($this,m) [lindex $args 0]
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this args} A {$args} {
        puts "B::B $this $args"
        set ($this,n) [lindex $args 0]
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
new B {1 2} 3
printArrays A:: B::

class c {}
class c::d {}
proc c::d::d {this args} {
    puts "d::d $this $args"
    set ($this,m) [lindex $args 0]
}
proc c::d::~d {this} {
    puts "d::~d $this"
}
class c::e {}
proc c::e::e {this args} c::d {$args} {
    puts "e::e $this $args"
    set ($this,n) [lindex $args 0]
}
proc c::e::~e {this} {
    puts "e::~e $this"
}
new c::e {1 2} 3
printArrays c::d:: c::e::

class C {
    class D {
        proc D {this args} {
            puts "D::D $this $args"
            set ($this,m) [lindex $args 0]
        }
        proc ~D {this} {
            puts "D::~D $this"
        }
    }
    class E {
        proc E {this args} C::D {$args} {
            puts "E::E $this $args"
            set ($this,n) [lindex $args 0]
        }
        proc ~E {this} {
            puts "E::~E $this"
        }
    }
    new E {1 2} 3
    printArrays D:: E::
}
new C::E {1 2} 3
printArrays C::D:: C::E::
