source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## invalid command name "::a::~a"
## A::A 2
## invalid command name "::A::~A"
## c::c 3
## invalid command name "::b::c::~c"
## C::C 4
## invalid command name "::B::C::~C"
## C::C 5
## invalid command name "::B::C::~C"

class a {}
proc a::a {this} {
    puts "a::a $this"
}
catch {delete [new a]} message
puts $message

class A {
    proc A {this} {
        puts "A::A $this"
    }
}
catch {delete [new A]} message
puts $message

class b::c {}
proc b::c::c {this} {
    puts "c::c $this"
}
catch {delete [new b::c]} message
puts $message

class B {
    class C {
        proc C {this} {
            puts "C::C $this"
        }
    }
    catch {delete [new C]} message
    puts $message
}
catch {delete [new B::C]} message
puts $message
