foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKOBJECTS) 1
source stooop.tcl
namespace import stooop::*

### objects checking pattern matching

# expected output:
## stooop::record invoked from main script
## stooop::printObjects invoked from main script:
## ::aa(1) created in main script
## ::ab(2) created in main script
## stooop::printObjects invoked from main script:
## ::ab(2) created in main script
## ::bb(3) created in main script
## stooop::report invoked from main script:
## + ::aa(1) created in main script
## + ::ab(2) created in main script
## stooop::report invoked from main script:
## + ::ab(2) created in main script
## + ::bb(3) created in main script
## stooop::record invoked from main script
## stooop::report invoked from main script:
## - ::aa(1) created in main script
## - ::ab(2) created in main script
## stooop::report invoked from main script:
## - ::ab(2) created in main script
## - ::bb(3) created in main script

class aa {
    proc aa {this} {}
    proc ~aa {this} {}
}
class ab {
    proc ab {this} {}
    proc ~ab {this} {}
}
class bb {
    proc bb {this} {}
    proc ~bb {this} {}
}
stooop::record
new aa
new ab
new bb
stooop::printObjects ::a*
stooop::printObjects ::*b
stooop::report ::a*
stooop::report ::*b
stooop::record
delete 1 2 3
stooop::report ::a*
stooop::report ::*b
