/*
 * SPCA500 chip based cameras initialization data
 *
 */
#ifndef SPCA500_INIT_H
#define SPCA500_INIT_H
/* Frame packet header offsets for the spca500 */
#define SPCA500_OFFSET_PADDINGLB 2
#define SPCA500_OFFSET_PADDINGHB 3
#define SPCA500_OFFSET_MODE      4
#define SPCA500_OFFSET_IMGWIDTH  5
#define SPCA500_OFFSET_IMGHEIGHT 6
#define SPCA500_OFFSET_IMGMODE   7
#define SPCA500_OFFSET_QTBLINDEX 8
#define SPCA500_OFFSET_FRAMSEQ   9
#define SPCA500_OFFSET_CDSPINFO  10
#define SPCA500_OFFSET_GPIO      11
#define SPCA500_OFFSET_AUGPIO    12
#define SPCA500_OFFSET_DATA      16
static void spca500_clksmart310_init(struct usb_spca50x *spca50x);
void spca500_reinit(struct usb_spca50x *spca50x);
static int spca500_initialise(struct usb_spca50x *spca50x);
static int spca500_full_reset(struct usb_spca50x *spca50x);


#if 0
static __u16 spca500_read_stats[][3] = {
    {0x0c, 0x0000, 0x0000},
    {0x30, 0x03fd, 0x0001},
    /* possible values for following call: 0x01b3, 0x01e6, 0x01f7, 0x0218 */
    {0x30, 0x01b3, 0x0002},
    /* possible values for following call: 0x0000, 0x0001, 0x0002 */
    {0x30, 0x0000, 0x0003},
    {0x30, 0x003b, 0x0004},
    /* possible values for following call: 0x00aa, 0x00e0 */
    {0x30, 0x00e0, 0x0005},
    {0x30, 0x0001, 0x0006},
    {0x30, 0x0080, 0x0007},
    {0x30, 0x0004, 0x0000},
    {0, 0, 0}
};
#endif

static __u16 spca500_visual_defaults[][3] = {
    {0x00, 0x0003, 0x816b},	/* SSI not active sync with vsync,
				 * hue (H byte) = 0,
				 * saturation/hue enable,
				 * brightness/contrast enable.
				 */
    {0x00, 0x0000, 0x8167},	/* brightness = 0 */
    {0x00, 0x0020, 0x8168},	/* contrast = 0 */
    {0x00, 0x0003, 0x816b},	/* SSI not active sync with vsync,
				 * hue (H byte) = 0, saturation/hue enable,
				 * brightness/contrast enable.
				 * was 0x0003, now 0x0000.
				 */
    {0x00, 0x0000, 0x816a},	/* hue (L byte) = 0 */
    {0x00, 0x0020, 0x8169},	/* saturation = 0x20 */
    {0x00, 0x0050, 0x8157},	/* edge gain high threshold */
    {0x00, 0x0030, 0x8158},	/* edge gain low threshold */
    {0x00, 0x0028, 0x8159},	/* edge bandwidth high threshold */
    {0x00, 0x000a, 0x815a},	/* edge bandwidth low threshold */
    {0x00, 0x0001, 0x8202},	/* clock rate compensation = 1/25 sec/frame */
    {0x0c, 0x0004, 0x0000},
    /* set interface */

    {0, 0, 0}
};
static __u16 Clicksmart510_defaults[][3] = {
    {0x00, 0x00, 0x8211},
    {0x00, 0x01, 0x82c0},
    {0x00, 0x10, 0x82cb},
    {0x00, 0x0f, 0x800d},
    {0x00, 0x82, 0x8225},
    {0x00, 0x21, 0x8228},
    {0x00, 0x00, 0x8203},
    {0x00, 0x00, 0x8204},
    {0x00, 0x08, 0x8205},
    {0x00, 0xf8, 0x8206},
    {0x00, 0x28, 0x8207},
    {0x00, 0xa0, 0x8208},
    {0x00, 0x08, 0x824a},
    {0x00, 0x08, 0x8214},
    {0x00, 0x80, 0x82c1},
    {0x00, 0x00, 0x82c2},
    {0x00, 0x00, 0x82ca},
    {0x00, 0x80, 0x82c1},
    {0x00, 0x04, 0x82c2},
    {0x00, 0x00, 0x82ca},
    {0x00, 0xfc, 0x8100},
    {0x00, 0xfc, 0x8105},
    {0x00, 0x30, 0x8101},
    {0x00, 0x00, 0x8102},
    {0x00, 0x00, 0x8103},
    {0x00, 0x66, 0x8107},
    {0x00, 0x00, 0x816b},
    {0x00, 0x00, 0x8155},
    {0x00, 0x01, 0x8156},
    {0x00, 0x60, 0x8157},
    {0x00, 0x40, 0x8158},
    {0x00, 0x0a, 0x8159},
    {0x00, 0x06, 0x815a},
    {0x00, 0x00, 0x813f},
    {0x00, 0x00, 0x8200},
    {0x00, 0x19, 0x8201},
    {0x00, 0x00, 0x82c1},
    {0x00, 0xa0, 0x82c2},
    {0x00, 0x00, 0x82ca},
    {0x00, 0x00, 0x8117},
    {0x00, 0x00, 0x8118},
    {0x00, 0x65, 0x8119},
    {0x00, 0x00, 0x811a},
    {0x00, 0x00, 0x811b},
    {0x00, 0x55, 0x811c},
    {0x00, 0x65, 0x811d},
    {0x00, 0x55, 0x811e},
    {0x00, 0x16, 0x811f},
    {0x00, 0x19, 0x8120},
    {0x00, 0x80, 0x8103},
    {0x00, 0x83, 0x816b},
    {0x00, 0x25, 0x8168},
    {0x00, 0x01, 0x820f},
    {0x00, 0xff, 0x8115},
    {0x00, 0x48, 0x8116},
    {0x00, 0x50, 0x8151},
    {0x00, 0x40, 0x8152},
    {0x00, 0x78, 0x8153},
    {0x00, 0x40, 0x8154},
    {0x00, 0x00, 0x8167},
    {0x00, 0x20, 0x8168},
    {0x00, 0x00, 0x816a},
    {0x00, 0x03, 0x816b},
    {0x00, 0x20, 0x8169},
    {0x00, 0x60, 0x8157},
    {0x00, 0x00, 0x8190},
    {0x00, 0x00, 0x81a1},
    {0x00, 0x00, 0x81b2},
    {0x00, 0x27, 0x8191},
    {0x00, 0x27, 0x81a2},
    {0x00, 0x27, 0x81b3},
    {0x00, 0x4b, 0x8192},
    {0x00, 0x4b, 0x81a3},
    {0x00, 0x4b, 0x81b4},
    {0x00, 0x66, 0x8193},
    {0x00, 0x66, 0x81a4},
    {0x00, 0x66, 0x81b5},
    {0x00, 0x79, 0x8194},
    {0x00, 0x79, 0x81a5},
    {0x00, 0x79, 0x81b6},
    {0x00, 0x8a, 0x8195},
    {0x00, 0x8a, 0x81a6},
    {0x00, 0x8a, 0x81b7},
    {0x00, 0x9b, 0x8196},
    {0x00, 0x9b, 0x81a7},
    {0x00, 0x9b, 0x81b8},
    {0x00, 0xa6, 0x8197},
    {0x00, 0xa6, 0x81a8},
    {0x00, 0xa6, 0x81b9},
    {0x00, 0xb2, 0x8198},
    {0x00, 0xb2, 0x81a9},
    {0x00, 0xb2, 0x81ba},
    {0x00, 0xbe, 0x8199},
    {0x00, 0xbe, 0x81aa},
    {0x00, 0xbe, 0x81bb},
    {0x00, 0xc8, 0x819a},
    {0x00, 0xc8, 0x81ab},
    {0x00, 0xc8, 0x81bc},
    {0x00, 0xd2, 0x819b},
    {0x00, 0xd2, 0x81ac},
    {0x00, 0xd2, 0x81bd},
    {0x00, 0xdb, 0x819c},
    {0x00, 0xdb, 0x81ad},
    {0x00, 0xdb, 0x81be},
    {0x00, 0xe4, 0x819d},
    {0x00, 0xe4, 0x81ae},
    {0x00, 0xe4, 0x81bf},
    {0x00, 0xed, 0x819e},
    {0x00, 0xed, 0x81af},
    {0x00, 0xed, 0x81c0},
    {0x00, 0xf7, 0x819f},
    {0x00, 0xf7, 0x81b0},
    {0x00, 0xf7, 0x81c1},
    {0x00, 0xff, 0x81a0},
    {0x00, 0xff, 0x81b1},
    {0x00, 0xff, 0x81c2},
    {0x00, 0x03, 0x8156},
    {0x00, 0x00, 0x8211},
    {0x00, 0x20, 0x8168},
    {0x00, 0x01, 0x8202},
    {0x00, 0x30, 0x8101},
    {0x00, 0x00, 0x8111},
    {0x00, 0x00, 0x8112},
    {0x00, 0x00, 0x8113},
    {0x00, 0x00, 0x8114},
    {0, 0, 0}
};


#endif				/* SPCA500_INIT_H */
