/* The Sound Management with the SDL library. It uses thread functions.
   There are some functions to drive it.
*/


#include "stk_sound.h"



Stk_Sound::Stk_Sound()
{
    mpeg=0;
}

Stk_Sound::~Stk_Sound()
{
    if(mpeg!=0)
        SMPEG_delete(mpeg);
    mpeg=0;
}



int Stk_Sound::LoadMP3(char *filename)
{
        /// we destroy the old structure
    if(mpeg!=0){
        SMPEG_stop(mpeg);
        SMPEG_delete(mpeg);
        mpeg=0;
    }
        // We look into the data dir
    char *tmpfilename;
        // do some filetype-magic
    if((tmpfilename=(char *)malloc(strlen(filename)+strlen(DATADIR)+2))==NULL){
        printf("Not enought memory\n");
        return 0;
    }
    sprintf(tmpfilename,"%s/%s",DATADIR,filename);
        // Test if the file exists
    FILE *file;
    file=fopen(tmpfilename,"r");
    if(file==0)
        return 0;
        // we create the new structure
    mpeg = SMPEG_new(tmpfilename, &info, 1);
    if ( SMPEG_error(mpeg) ) {
        fprintf(stderr, "%s: %s\n", tmpfilename , SMPEG_error(mpeg));
        SMPEG_delete(mpeg);
        return 0;
        throw Ex_Sound();
    }
    return 1;
}


void Stk_Sound::SoundOn()
{
    SMPEG_enableaudio(mpeg, 1);
}


void Stk_Sound::SoundOff()
{
    SMPEG_enableaudio(mpeg, 0);
}

void Stk_Sound::LoopOn()
{
    SMPEG_loop(mpeg, 1);
}

void Stk_Sound::LoopOff()
{
    SMPEG_loop(mpeg, 0);
}


void Stk_Sound::Play()
{
    SMPEG_play(mpeg);
}

void Stk_Sound::Stop()
{
    SMPEG_stop(mpeg);
}

void Stk_Sound::Pause()
{
    SMPEG_pause(mpeg);
}


int Stk_Sound::Status()
{
    if(mpeg){
        int status=SMPEG_status(mpeg);
        switch(status){
            case SMPEG_PLAYING:
                return STK_MP3_PLAYING;
            case SMPEG_ERROR:
                return STK_MP3_ERROR;
            case SMPEG_STOPPED:
                return STK_MP3_STOPPED;
            default:
                return STK_MP3_UNKOWN;
        }
    }
    return STK_MP3_UNKOWN;
}






/* ------------------- New version --------------- */

/* Message play */
Stk_MessagePlay::Stk_MessagePlay(char *filename)
        :Stk2_Message(1)
{
    Mp3Filename=new char[strlen(filename)+2];
    Mp3Filename=strcpy(Mp3Filename,filename);
}

Stk_MessagePlay::~Stk_MessagePlay()
{
    delete Mp3Filename;
    Mp3Filename=0;
}


/* Client class */
void Stk_CSound::Play(char *filename)
{
        // we create the message
    Stk_MessagePlay *msg=new Stk_MessagePlay(filename);
        // we send the message
    server->SendMessage(msg);
}




/* Server class */
Stk_PSound::Stk_PSound(int freq=25)
        :Stk2_Looper(freq)
{
        // no last sing
    lastsing=new char[100];
    lastsing[0]=0;
        // we create the sound
    sound=new Stk_Sound();
        // launch the thread
    Start();
}



Stk_PSound::~Stk_PSound()
{}


void Stk_PSound::Loop()
{
    Stk2_Message *msg;
        // look over the messages
    while(PollMessage(msg)){
        switch(msg->what){
            case 1: 
            {    /* Play */
                Stk_MessagePlay *tmp=(Stk_MessagePlay *)msg;
                Play(tmp->Mp3Filename);
                delete msg;
                break;
            }
            
            case 2: /* Stop */
                break;
            default:
                printf("des messages\n");
                break;
        }
    }
}

void Stk_PSound::Play(char *filename)
{
    printf("joue %s\n",filename);
    if(strcmp(filename,lastsing)==0){
        return;
    }
    if(sound->LoadMP3(filename)){
        sound->Play();
    }
    lastsing=strcpy(lastsing,filename);
}

