#include <stdio.h>
#include <stdlib.h>
#include "stk_message.h"
#include "stk_debug.h"

/* ------------------------------------- Message ---------------------------------- */



/* ------------------ a field ----------------- */
Stk_Field::Stk_Field(const char *nom)
        :name(nom)
{
    value=0;
}

Stk_Field::Stk_Field(const Stk_Field &f)
        :name(f.name)
{
    STK_ERROR(1,"erreur");
}


Stk_Field::~Stk_Field()
{
    if(value!=0){
        delete value;
        value=0;
    }
}


const Stk_Field &Stk_Field::operator=(const Stk_Field &f)
{
    name=f.name;
    STK_ERROR(1,"erreur");
}



Stk_Message::Stk_Message()
{}

Stk_Message::Stk_Message(int t)
{
    what=t;
}




int Stk_Message::AddInt(const char *name,int anInt)
{
    Stk_Field *field=new Stk_Field(name);
    field->value=new int(anInt);
    fields.push_back(field);
    return 0;
}


int Stk_Message::AddFloat(const char *name,float aFloat)
{
    Stk_Field *field=new Stk_Field(name);
    field->value=new float(aFloat);
    fields.push_back(field);
    return 0;
}


int Stk_Message::FindInt(const char *nom,int *&val)
{
        // we look trough the fields
    typedef list<Stk_Field *>::iterator iter_field;
    for(iter_field i=fields.begin();i!=fields.end();i++){
            // if we found it
        if((*i)->name.compare(nom)==0){
            val=(int *)(*i)->value;
            return 1;
        }
    }
    val=0;
    return 0;
}


int Stk_Message::FindFloat(const char *nom,float *&val)
{
        // we look trough the fields
    typedef list<Stk_Field *>::iterator iter_field;
    for(iter_field i=fields.begin();i!=fields.end();i++){
            // if we found it
        if((*i)->name.compare(nom)==0){
            val=(float *)(*i)->value;
            return 1;
        }
    }
    val=0;
    return 0;
}

Stk_Message::~Stk_Message()
{
        // we look trough the fields
    typedef list<Stk_Field *>::iterator iter_field;
    for(iter_field i=fields.begin();i!=fields.end();i++){
        delete (*i);
    }
}






/* -------------------- template of queue --------------------- */


template <class T>
Stk_Queue<T>::Stk_Queue()
{}

template <class T>
Stk_Queue<T>::~Stk_Queue()
{}


template <class T>
void Stk_Queue<T>::AddElement(T el)
{
    a_elements.push_back(el);
}

template <class T>
void Stk_Queue<T>::RemElement(T el)
{
    r_elements.push_back(el);
}

template <class T>
void Stk_Queue<T>::Sync()
{
        // we remove elements
    while(r_elements.size()!=0){
        r_elements.back()->LooseFocus();
        elements.remove(r_elements.back());
        if(elements.size()!=0)
            elements.back()->GetFocus();
        delete r_elements.back();
        r_elements.pop_back();
    }
        // we add elements
    while(a_elements.size()!=0){
        if(elements.size()!=0)
            elements.back()->LooseFocus();
        a_elements.back()->GetFocus();
        elements.push_back(a_elements.back());
        a_elements.pop_back();
    }
    
}


/* ----------------------------------------------------------- */
/* --------------------------- Looper ------------------------ */
/* ----------------------------------------------------------- */
Stk_Looper::Stk_Looper()
{
}


void Stk_Looper::Dispatch()
{
    typedef list<Stk_Prog *>::iterator iter_progs;
    while(messages.size()!=0){
            // we send messages
        progs.elements.back()->Dispatch(messages.front());   
            // we remove it
        delete messages.front();
        messages.pop_front();
    }
}

    



void Stk_Looper::StkPostMessage(Stk_Message *msg)
{
        // add message in the queue
    messages.push_back(msg);
}



int Stk_Looper::Loop()
{
    passivesenders.Sync();
    progs.Sync();

        // first we generate events for passive event sender
    typedef list<Stk_PassiveSender *>::iterator iter_sender;
    for(iter_sender i=passivesenders.elements.begin();i!=passivesenders.elements.end();i++){
        if((*i)->Loop()==0){
            delete (*i);
            passivesenders.RemElement(*i);            
        }
    }
        // second we dispatch messages received
    Dispatch();


        // then we run the active prog & delete it if we need
    if(progs.elements.size()!=0){
        if(progs.elements.back()->Loop()==0){
            RemProg(progs.elements.back());
        }
    }
    return 1;
}


void Stk_Looper::AddProg(Stk_Prog *prg)
{
    progs.AddElement(prg);
}

void Stk_Looper::RemProg(Stk_Prog *prg)
{
    progs.RemElement(prg);
}


void Stk_Looper::AddPassiveSender(Stk_PassiveSender *ps)
{
    passivesenders.AddElement(ps);
}


void Stk_Looper::RemPassiveSender(Stk_PassiveSender *ps)
{
	passivesenders.RemElement(ps);
}


/* ---------------------------------------------------------- */
/* ------------------------- Handler ------------------------ */
/* ---------------------------------------------------------- */
Stk_Handler::Stk_Handler()
{
    looper=0;
    father=0;
}


/* usefull for stk_prog */
Stk_Handler::Stk_Handler(Stk_Looper *l)
{
    looper=l;
    father=0;
}

Stk_Handler::Stk_Handler(Stk_Handler *h)
{
    looper=h->looper;
    father=h;
}

Stk_Handler::~Stk_Handler()
{
}

void Stk_Handler::Dispatch(Stk_Message *msg)
{
    MessageReceived(msg);
    typedef list<Stk_Handler *>::iterator iter_handlers;
    for(iter_handlers i=handlers.begin();i!=handlers.end();i++){
        (*i)->Dispatch(msg);
    }
}


void Stk_Handler::MessageReceived(Stk_Message *msg)
{

}


void Stk_Handler::StkPostMessage(Stk_Message *msg)
{
        // if the handler is active we send it the message
    MessageReceived(msg);
    delete msg;
}

void Stk_Handler::AddHandler(Stk_Handler *son)
{
    son->father=this;
    if(looper!=0)
        son->looper=looper;
    handlers.push_back(son);
}

void Stk_Handler::RemHandler(Stk_Handler *son)
{
    son->father=0;
    son->looper=0;
    handlers.remove(son);
}

/*
void Stk_Handler::GetFocus()
{}

void Stk_Handler::LooseFocus()
{}
*/

/* ----------------------------------------------------------- */
/* ----------------- The code for the Stk_prog  -------------- */
/* ----------------------------------------------------------- */
Stk_Prog::Stk_Prog(Stk_Looper *l)
        :Stk_Handler(l)
{
    looper->AddProg(this);
}

Stk_Prog::Stk_Prog(Stk_Prog *h)
        :Stk_Handler(h->looper)
{
    looper->AddProg(this);
}

void Stk_Prog::GetFocus()
{}

void Stk_Prog::LooseFocus()
{}

void Stk_Prog::MessageReceived(Stk_Message *)
{}

Stk_Prog::~Stk_Prog()
{}

int Stk_Prog::Loop()
{
    return 1;
}








/* ************************** the code for Stk_PassiveSender *********** */
Stk_PassiveSender::Stk_PassiveSender()
{}


Stk_PassiveSender::Stk_PassiveSender(Stk_Looper *l)
{
    l->AddPassiveSender(this);
    looper=l;
}

int Stk_PassiveSender::Loop()
{
    return 1;
}
void Stk_PassiveSender::StkPostMessage(Stk_Message *msg)
{
    looper->StkPostMessage(msg);
}


void Stk_PassiveSender::GetFocus()
{}

void Stk_PassiveSender::LooseFocus()
{}

