// classic headers
#include <stdio.h>
#include <stdlib.h>

// my header
#include "stk_keyboard.h"



/* ******************* Common Code ***************** */



void Stk_Keyboard::Print() const
{
    printf("Information about the keyboard control\n");
    printf("  axe X:%f\n",getPositionAxeX());
    printf("  axe Y:%f\n",getPositionAxeY());
    printf("  button 1:%f\n",getButton1());
    printf("  button 2:%f\n",getButton2());
    printf("  button 3:%f\n",getButton3());
    printf("  button 4:%f\n",getButton4());
}





/* ****************** X11 Keybooard ***************** */ 
#ifdef X11_KEYBOARD

// X11 headers
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>


#define K_B1       8
#define K_B2       9
#define K_B3       10
#define K_B4       11
#define K_SPACE    41
#define K_QUIT     42

// intern functions
char TestKey(KeyCode test);




char XKeys[256];
Display *display;
KeyCode KK_SPACE,KK_FRONT,KK_REAR,KK_LEFT,KK_RIGHT,KK_ENTER,KK_B1,KK_B2,KK_B3,KK_B4,KK_QUIT;






Stk_Keyboard::Stk_Keyboard(Stk_Looper *l)
        :Stk_PassiveSender(l)
{
    display=XOpenDisplay(NULL);
        // we define the KeyCode for control
    KK_FRONT=XKeysymToKeycode(display,XK_Up);
    KK_REAR=XKeysymToKeycode(display,XK_Down);
    KK_LEFT=XKeysymToKeycode(display,XK_Left);
    KK_RIGHT=XKeysymToKeycode(display,XK_Right);
    KK_B1=XKeysymToKeycode(display,XK_A);
    KK_B2=XKeysymToKeycode(display,XK_Z);
    KK_B3=XKeysymToKeycode(display,XK_Q);
    KK_B4=XKeysymToKeycode(display,XK_S);
        // general
    KK_ENTER=XKeysymToKeycode(display,XK_Return);
    KK_SPACE=XKeysymToKeycode(display,XK_space);
    KK_QUIT=XKeysymToKeycode(display,XK_Escape);
}

// Is XQueryKeymap present on this sytem ?
int Stk_Keyboard::IsPresent() const
{
    return 1;
}


void DoMsg(Stk_Keyboard *k,int K_KEY,KeyCode key);



// Read the state of keyboard
void Stk_Keyboard::ReadState()
{
    XQueryKeymap(display,XKeys);
    DoMsg(this,STK_K_LEFT,KK_LEFT);
    DoMsg(this,STK_K_RIGHT,KK_RIGHT);
    DoMsg(this,STK_K_UP,KK_FRONT);
    DoMsg(this,STK_K_DOWN,KK_REAR);
    DoMsg(this,STK_K_ESCAPE,KK_QUIT);
    DoMsg(this,STK_K_SPACE,KK_SPACE);
    DoMsg(this,STK_K_ENTER,KK_ENTER);
    DoMsg(this,K_B1,KK_B1);
    DoMsg(this,K_B2,KK_B2);
    DoMsg(this,K_B3,KK_B3);
    DoMsg(this,K_B4,KK_B4);
}

void DoMsg(Stk_Keyboard *k,int K_KEY,KeyCode keyc)
{
/*    if(k->key[K_KEY]!=TestKey(keyc)){
        Stk_Message *msg=new Stk_Message(STK_KEY_EVENT);
        msg->AddInt("keys",K_KEY);
        if(k->key[K_KEY]==0){
            msg->AddInt("pressed",1);
        } else {
            msg->AddInt("pressed",0);
        }
        k->StkPostMessage(msg);
        }*/
    k->key[K_KEY]=TestKey(keyc);
}





float Stk_Keyboard::getPositionAxeX() const
{
    float tmp=0;
    if(key[STK_K_LEFT]!=0)
        tmp-=1;
    if(key[STK_K_RIGHT]!=0)
        tmp+=1;
    return tmp;
}

float Stk_Keyboard::getPositionAxeY() const
{
    float tmp=0;
    if(key[STK_K_DOWN]!=0)
        tmp-=1;
    if(key[STK_K_UP]!=0)
        tmp+=1;
    return tmp;
}

float Stk_Keyboard::getButton1() const
{
    if(key[K_B1]!=0)
        return 1;
    else
        return 0;
}

float Stk_Keyboard::getButton2() const
{
    if(key[K_B2]!=0)
        return 1;
    else
        return 0;
}

float Stk_Keyboard::getButton3() const
{
    if(key[K_B3]!=0)
        return 1;
    else
        return 0;
}

float Stk_Keyboard::getButton4() const
{
    if(key[K_B4]!=0)
        return 1;
    else
        return 0;
}


Stk_Keyboard::~Stk_Keyboard()
{
    XCloseDisplay(display);
}





// Intern function
char TestKey(KeyCode test)
{
    return (XKeys[test>>3]&(1<<(test&7)));
}


int Stk_Keyboard::Loop()
{
    ReadState();
    return 1;
}







#endif

/* ****************** WIN32 Keybooard ***************** */ 
#ifdef WIN32
extern char keys_win32[256];

Stk_Keyboard::Stk_Keyboard(Stk_Looper *l)
{   

}

int Stk_Keyboard::IsPresent() const
{
    return 1;
}

void Stk_Keyboard::ReadState()
{}

float Stk_Keyboard::getPositionAxeX() const
{
	int tmp=0;
    if(keys_win32[K_LEFT]!=0)
        tmp-=1;
    if(keys_win32[K_RIGHT]!=0)
        tmp+=1;
    return tmp;
}

float Stk_Keyboard::getPositionAxeY() const
{
	int tmp=0;
    if(keys_win32[K_DOWN]!=0)
        tmp-=1;
    if(keys_win32[K_UP]!=0)
        tmp+=1;
    return tmp;
}

float Stk_Keyboard::getButton1() const
{
     return 0;
}

float Stk_Keyboard::getButton2() const
{
     return 0;
}

float Stk_Keyboard::getButton3() const
{
     return 0;
}

float Stk_Keyboard::getButton4() const
{
    return 0;
}

Stk_Keyboard::~Stk_Keyboard()
{}


int Stk_Keyboard::Loop()
{
    return 1;
}
#endif


#if !defined(X11_KEYBOARD) && !defined(WIN32)
/* ****************** Non X11 Keybooard ***************** */ 
Stk_Keyboard::Stk_Keyboard(Stk_Looper *l)
{   
}

int Stk_Keyboard::IsPresent() const
{
    return 0;
}

void Stk_Keyboard::ReadState()
{}

float Stk_Keyboard::getPositionAxeX() const
{
    return 0;
}

float Stk_Keyboard::getPositionAxeY() const
{
     return 0;
}

float Stk_Keyboard::getButton1() const
{
     return 0;
}

float Stk_Keyboard::getButton2() const
{
     return 0;
}

float Stk_Keyboard::getButton3() const
{
     return 0;
}

float Stk_Keyboard::getButton4() const
{
    return 0;
}

Stk_Keyboard::~Stk_Keyboard()
{}


int Stk_Keyboard::Loop()
{
    return 1;
}

#endif
