#ifndef __SP_JOY
#define __SP_JOY

#include "../../../config.h"
#include "stk_control.h"
#include "../kernel/stk_message.h"

/* This code is used to determine if this is the old or new version
   of the joystick drivers */

#ifdef LINUX_JOYSTICK
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/joystick.h>
# if JS_VERSION >= 0x010000
#    define LINUX_JOYSTICK_NEW
# elif
#    define LINUX_JOYSTICK_OLD
# endif
#endif

class Stk_Joy;
class Stk_Axe;

#define J_UP     100
#define J_DOWN   101
#define J_RIGHT  102
#define J_LEFT   103
#define J_B1     110
#define J_B2     111
#define J_B3     112
#define J_B4     113

/** The class Stk_Joy is used to read joystick information
 This class allows joystick to send Messages too.
 message button has two fields:  \\
 - button : axe or buttons \\
 - pressed:  active or not  \\
 Let explain the protocol:  \\
 UP       100 \\
 DOWN     101 \\
 RIGHT    102 \\
 LEFT     103 \\
 B1       110 \\
 B2       111 \\
 B3       112 \\
 B4       113 \\
 */
class Stk_Joy: public Stk_Control,public Stk_PassiveSender
{
public:
        /// constructor: Warning if you choose to have default joystick give a null pointer 
    Stk_Joy(char *,Stk_Looper *);
        /// destructor
    virtual ~Stk_Joy();
        /// Is the joy present ?
    int IsPresent() const;
        /// Read the state of joystick
    void ReadState();
        /// Print information about this joystick
    void Print() const;

        /// Get the position af axe X
    float getPositionAxeX() const;
        /// Get the position of axe Y
    float getPositionAxeY() const;
        /// Get State of button 1
    float getButton1() const;
        /// Get State of button 2
    float getButton2() const;
        /// Get State of button 3
    float getButton3() const;
        /// Get State of button 4
    float getButton4() const;
    
        /// loop: functions wich generates events
    virtual int Loop();


private:
        // array of buttons
    int *array_buttons;
        // array of axes
    Stk_Axe *array_axes;
        // nb buttons
    int nb_buttons;
        // nb axes
    int nb_axes;
        // a flag to indicate if we have a joy
    int present;
        // a file descriptor for the joy
    int fd;

};


/** This class represents an axe of a joy */
/* It gives informations like an unified joystick with an interval -1 to 1
   with a center in 0 */
class Stk_Axe
{
    friend class Stk_Joy;
public:
        /// give the position of the cursor belonging to this axe
    float getPosition() const;
        /// Print information about this axe
    void Print() const;
private:
    float position;
    float min;
    float max;
    float center;
};

#endif
