#ifdef WIN32
#include <windows.h> 
#endif
#include <GL/gl.h>
#include <GL/glu.h>
#include "stk_text.h"

#include "../input/stk_keyboard.h"



/* -----------------------  Text  ------------------------- */

Stk_Gui_Text::Stk_Gui_Text(char *txt,char md)
        :Stk_Gui_Widget(),text(txt)
{
        // we create a default font
    font=new Stk_FontTXF("default.txf");
    allocate_font=1;
        // save the mode
    mode=md;
}

Stk_Gui_Text::Stk_Gui_Text(Stk_Font *f,char *txt,char md)
        :Stk_Gui_Widget(Stk_Gui_Rect(0,0,30,30)),text(txt)
{
        // we create a default font
    font=f;
    allocate_font=0;
        // save the mode
    mode=md;
    
}


void Stk_Gui_Text::Draw()
{
    glPushMatrix();
    float decalage;
    float sz=font->GetSize();
    unsigned int i=0;
    float dy=(GetHeight()/2)-(sz/2);
    STK_ERROR((dy<0),"This STK_GUI_TEXT IS TOO SMALL !!!");
    glTranslatef(GetX(),GetY()+dy,0);
    switch(mode){
        case 0:
                // right mode
            decalage=(GetWidth()-sz*text.size());
            while(i<text.size()){
                font->DrawChar(text[i],decalage,0,0);
                decalage+=sz;
                i++;
            }
            break;
        case 1:
                // left mode
            decalage=0;
            while(i<text.size()){
                font->DrawChar(text[i],decalage,0,0);
                decalage+=sz;
                i++;
            }
            break;
        case 2:
                // center mode
            decalage=(GetWidth()-sz*text.size())/2;
            while(i<text.size()){
                font->DrawChar(text[i],decalage,0,0);
                decalage+=sz;
                i++;
            }
    }
    glPopMatrix();
}


Stk_Gui_Text::~Stk_Gui_Text()
{
    if(allocate_font!=0){
        delete font;
    }
    
}


void Stk_Gui_Text::SetFontSize(float sz)
{
    font->SetSize(sz);
}

float Stk_Gui_Text::GetFontSize()
{
    return font->GetSize();
}




Stk_Gui_EditLine::Stk_Gui_EditLine(Stk_Font *f, char md)
        :Stk_Gui_Text(f,"",md)
{
    active=1;
}

void Stk_Gui_EditLine::MessageReceived(Stk_Message *msg)
{
    int *valeur;
        // we have interest only in mouse event
    if(msg->what==STK_MOU_EVENT){
            // we have interest in type 1 message
        msg->FindInt("type",valeur);
        if(*valeur!=1)
            return;
            // we have interest in keypressed message
        msg->FindInt("pressed",valeur);
        if(*valeur==0)
            return;
            // we are interesting by click left
        msg->FindInt("button",valeur);
        if(*valeur!=STK_GUI_LEFT)
            return;
        int *x,*y;
        msg->FindInt("x",x);
        msg->FindInt("y",y);
        if( ((*x)>=GetX()) && ((*x)<GetX()+GetWidth()) &&
            ((*y)>=GetY()) && ((*y)<GetY()+GetHeight()) ){
            Click();
        }
    }
    
        // we have interest only in key event
    if((msg->what==STK_KEY_EVENT)&&(active)){
            // we have interest in pressed message
        msg->FindInt("pressed",valeur);
        if(*valeur==0)
            return;
            // two cases: messages
        int *key;
        msg->FindInt("key",key);
        msg->FindInt("type",valeur);
        if(*valeur==1){
            text+=*key;
        }else if (*valeur==2){
            if( (((*key)==STK_K_BACKSPACE) || ((*key)==STK_K_DELETE))
                && (!text.empty()) ){
                text.resize(text.size()-1);
            } else if( (*key)==STK_K_ENTER ) {
                Enter();
            }
        }
    }
}


int Stk_Gui_EditLine::IsActive() const
{
    return active;
}

void Stk_Gui_EditLine::SetActive(int ac)
{
    active=ac;
}


void Stk_Gui_EditLine::Enter()
{}

void Stk_Gui_EditLine::Click()
{}

