/*****************************************************************
 * Space Racer 3.0    in OpenGl       By Ellis                   *
 * By Ellis & Gollum     Thunder Folks 1997 for version 1 and 2  *
 * last Version: 11/11/1999                                      *
 * Version         Linux                                         *
 *****************************************************************/

/* News:
   February 00:
   SDL port with smpeg port. We can play mp3 file.

   December 99:
   Win32 (window & Fullscreen) port.
   Good Bye Glut... This librarie is excellent to begin projects. But now,
   there are too many limitations ( above all the event loop).
   
   October 99:
   The Keyboard control is managed by the Sp_AdmCtrl. This class don't use
   the GLUT primitives but these of X11. And To pilot a car,now we attache
   it a control.
   Today, we need X11 but it is possible to write some portable code for WIN32.
   
   November 99:
   We develop a prog class and message class. 
*/



// in config.h: we have a flag to know if we have X11
#if defined(WIN32)
#include <windows.h>
#pragma warning (disable:4244)		/* disable bogus conversion warnings */
#endif


#include <GL/gl.h>
#include <stdio.h>
#include "../config.h"

// My includes
#include "stk/stk.h"
#include "sp_menu.h"
#include "stk/input/stk_admctrl.h"


// Les variables globales
// La taille de la fenetre
int  Sp_width,Sp_height;



// the control variable
Stk_AdmCtrl *admctrl;
int player1;
// the prog variable
Stk_Prog *admprog;
Stk_Looper *looper=0;

// the sound machine
Stk_PSound *canalsound;









/* *********************** Main function ******************************* */


#ifdef WIN32
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstace,LPSTR lpCmdLine,int nShowCmd)
#else if
int main(int argc, char **argv)
#endif
{

	
#ifdef WIN32
	Stk_InitWGL(hInstance,nShowCmd,640,480);
#else if
    Stk_InitGL(640,480);
#endif
    canalsound=new Stk_PSound();
    
        // on met la couleur du buffer apres effacement au noir
    glClearColor(0, 0, 0, 0);
    
        // we spawn the looper
    looper=new Stk_Looper();
        // and the main prog
    admprog= new Sp_MenuPrincipal(looper);
        // and the controler
    admctrl=new Stk_AdmCtrl(looper);
        // and we ask a player
    player1=admctrl->Ask();
//    admctrl->Switch(player1);
    while(1){
        Stk_EventLoop(looper);
        looper->Loop();
    }
    delete canalsound;
    return 0;      
}



