#include "stk/stk.h"
#include <stdio.h>
#include <stdlib.h>


#include "./graphics/ImageBuffer.h"

#include "sp_menu.h"
#include "sp_newgame.h"
#include "sp_about.h"



extern int Sp_width;
extern int Sp_height;
extern Stk_Prog *admprog;
// the sound machine
extern Stk_PSound *canalsound;


Sp_BPlanet::Sp_BPlanet(char *tex_name)
        :Stk_Gui_Button(Stk_Gui_Rect(0,0,0,100))
{
        // we load the texture
    ImageBuffer img(tex_name);
    img.toRGBA();
        // we create one quadric
    obj = gluNewQuadric();
        // with texture
    gluQuadricTexture(obj,GL_TRUE);
    gluSphere( obj,PLANETRADIUS, PLANETSLICES, PLANETSTACKS);
    glGenTextures(1,(GLuint *)&num_tex);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, num_tex);
    gluBuild2DMipmaps(GL_TEXTURE_2D,4,
                      img.getWidth(),
                      img.getHeight(),GL_RGBA,GL_UNSIGNED_BYTE,(unsigned char *)img.getData());
        // not active
    active=0;
    angle=0.0;
}



void Sp_BPlanet::DrawButton()
{
    if(active){
        angle+=3.0;
        if(angle>360)
            angle-=360;
    }
    glPushMatrix();
    glTranslatef(GetWidth()/2,GetHeight()/2,0);
    glScalef(40.0,40.0,1.0);
    glPushAttrib(GL_TEXTURE_BIT);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, num_tex);
/*    glRotatef(90,1,0,0);*/
    glRotatef(90,1,0,0);
    glRotatef(angle,1,0,0);
    gluSphere( obj,PLANETRADIUS, PLANETSLICES, PLANETSTACKS);
    glPopAttrib();
    glPopMatrix();
}

Sp_Choice::Sp_Choice(Stk_Font *fnt)
        :Stk_Gui_VBox(STK_GUI_SIZE_NOAUTO)
{
    font=fnt;
}


/* -------------------- New Game ------------------ */
Sp_Menu_NewGame::Sp_Menu_NewGame()
        :Sp_BPlanet("mars.png")
{}

void Sp_Menu_NewGame::Click()
{
    Sp_NewGame *myprog;
    myprog=new Sp_NewGame(admprog);
}



Sp_Choice_NewGame::Sp_Choice_NewGame(Stk_Font *fnt)
        :Sp_Choice(fnt)
{
    button=new Sp_Menu_NewGame();
    Attach(button);
    text=new Stk_Gui_Text(fnt,"New Game",STK_GUI_CENTER);
    Attach(text);
}

/* --------------------  High Scores  ------------------ */
Sp_Menu_HighScores::Sp_Menu_HighScores()
        :Sp_BPlanet("jupiter.png")
{}

void Sp_Menu_HighScores::Click()
{
}



Sp_Choice_HighScores::Sp_Choice_HighScores(Stk_Font *fnt)
         :Sp_Choice(fnt)
{
    button=new Sp_Menu_HighScores();
    Attach(button);
        text=new Stk_Gui_Text(fnt,"High Scores",STK_GUI_CENTER);
    Attach(text);
}


/* --------------------  Quit  ------------------ */
Sp_Menu_Quit::Sp_Menu_Quit()
        :Sp_BPlanet("uranus.png")
{}

void Sp_Menu_Quit::Click()
{
    Stk_QuitGL();
    exit(0);
}



Sp_Choice_Quit::Sp_Choice_Quit(Stk_Font *fnt)
        :Sp_Choice(fnt)
{
    button=new Sp_Menu_Quit();
    Attach(button);
    text=new Stk_Gui_Text(fnt,"Quit",STK_GUI_CENTER);
    Attach(text);
}


/* ------------------- Player ------------------------ */
Sp_Menu_Player::Sp_Menu_Player()
        :Sp_BPlanet("mercury.png")
{}

void Sp_Menu_Player::Click()
{

}

Sp_Choice_Player::Sp_Choice_Player(Stk_Font *fnt)
        :Sp_Choice(fnt)
{
    button=new Sp_Menu_Player();
    Attach(button);
    text=new Stk_Gui_Text(fnt,"Player",STK_GUI_CENTER);
    Attach(text);
}

/* ------------------- Options ------------------------ */
Sp_Menu_Options::Sp_Menu_Options()
        :Sp_BPlanet("earth.png")
{}

void Sp_Menu_Options::Click()
{

}

Sp_Choice_Options::Sp_Choice_Options(Stk_Font *fnt)
        :Sp_Choice(fnt)
{
    button=new Sp_Menu_Options();
    Attach(button);
    text=new Stk_Gui_Text(fnt,"Options",STK_GUI_CENTER);
    Attach(text);
}


/* ------------------- About ------------------------ */
Sp_Menu_About::Sp_Menu_About()
        :Sp_BPlanet("saturn.png")
{}

void Sp_Menu_About::Click()
{
    Sp_About *about;
    about=new Sp_About(admprog);
}

Sp_Choice_About::Sp_Choice_About(Stk_Font *fnt)
        :Sp_Choice(fnt)
{
    button=new Sp_Menu_About();
    Attach(button);
    text=new Stk_Gui_Text(fnt,"About",STK_GUI_CENTER);
    Attach(text);
}













/*
  GLuint PlanetObj[MENUPLANETS];

// Color vectors
GLfloat grey[4] = {0.2f, 0.2f, 0.2f, 1.0f};
GLfloat white[4] = {1.0f, 1.0f, 1.0f, 1.0f};
GLfloat red[4] = { 1.0f, 0.0f, 0.0f, 1.0f };
GLfloat blue[4] = { 0.0f, 0.0f, 1.0f, 1.0f };
GLfloat teal[4] = { 0.0f, 1.0f, 0.8f, 1.0f };

// Menu planets (buttons) struct and data
struct menuplanet_struct {
float x_center;
float y_center;
float z_center;
float radius;
int rotation;
char* texture;
GLubyte active;
char* menutext;
float x;
float y;
};

menuplanet_struct menuplanet[MENUPLANETS] = {
{-0.5f,  0.5f,  0, 0.1f, 0,"mercury.png",0, "Player"    ,100  ,120},
{ 0.5f,  0.5f,  0, 0.1f, 0,"mars.png"   ,1, "New Game"  ,435 ,120},
{-0.7f,  0.0f,  0, 0.1f, 0,"earth.png"  ,0, "Options"   ,25 ,260},
{ 0.7f,  0.0f,  0, 0.1f, 0,"jupiter.png",0, "High Score",490 ,260},
{-0.5f, -0.5f,  0, 0.1f, 0,"saturn.png" ,1, "About"     ,110  ,380},
{ 0.5f, -0.5f,  0, 0.1f, 0,"uranus.png" ,1, "Quit"      ,460 ,380},
    };
*/



Sp_MenuPrincipal::Sp_MenuPrincipal(Stk_Looper *l)
        :Stk_Prog(l)
{
        // On definit la projection
        // On utilise une projection perspective
    glMatrixMode(GL_PROJECTION);
    gluPerspective(/* angle de vue en degree */ 40.0,
                       /* coef de zoom */ 1.0,
                       /* Z near */ 1.0, /* Z far */ 10000.0);
        // On definit le placement de la camera
    glMatrixMode(GL_MODELVIEW);
    gluLookAt(0.0, 0.0, 2.5,      /* oeil a (0,0,5) */
              0.0, 0.0, -2.5,      /* centre  a (0,0,0) */
              0.0, 1.0, 0.);      /* le haut correspond au Y positif  */

        //InitPlanets();
    Sp_width=640;
    Sp_height=480;
    menuchoice=0;
        // The font
    font=new Stk_FontTXF("default.txf");
    font->SetSize(15);
        // the interface
    window=new Stk_Gui_Window(this,Stk_Gui_Rect(0,0,Sp_width,Sp_height));
        // one hbox
    Stk_Gui_HBox *hbox;
    hbox=new Stk_Gui_HBox();
    window->Attach(hbox);
    
        // two vbox
        // box 1
    Stk_Gui_VBox *vbox1;
    vbox1=new Stk_Gui_VBox();
    hbox->Attach(vbox1);
        
    Sp_Choice_Player *mercure;
    mercure=new Sp_Choice_Player(font);
    vbox1->Attach(mercure);
    
    Sp_Choice_Options *earth;
    earth=new Sp_Choice_Options(font);
    vbox1->Attach(earth);

    
    Sp_Choice_About *saturne;
    saturne=new Sp_Choice_About(font);
    vbox1->Attach(saturne);

        // box 2
    Stk_Gui_VBox *vbox2;
    vbox2=new Stk_Gui_VBox();
    hbox->Attach(vbox2);        

    Sp_Choice_NewGame *mars;
    mars=new Sp_Choice_NewGame(font);
    vbox2->Attach(mars);

    Sp_Choice_HighScores *jupiter;
    jupiter=new Sp_Choice_HighScores(font);
    vbox2->Attach(jupiter);

    Sp_Choice_Quit *quit;
    quit=new Sp_Choice_Quit(font);
    vbox2->Attach(quit);

        // our planets
    choice[0]=mercure;
    choice[2]=earth;
    choice[4]=saturne;
    choice[1]=mars;
    choice[3]=jupiter;
    choice[5]=quit;
    
        // sound
    clientsound=new Stk_CSound(canalsound);
}

void Sp_MenuPrincipal::GetFocus()
{
 /*   Stk_Sound *sound =new Stk_Sound();
    sound->LoadMP3("orion-enter_the_trance.mp3");*/
   clientsound->Play("orion-enter_the_trance.mp3");
  
}


Sp_MenuPrincipal::~Sp_MenuPrincipal()
{
    delete window;
    delete font;
}


void Sp_MenuPrincipal::MessageReceived(Stk_Message *msg)
{
    int *valeur;
        // we have interest only in keyboard clavier
    if(msg->what!=STK_KEY_EVENT){
        return;
    }
        // we have interest in keypressed message
    msg->FindInt("pressed",valeur);
    if(*valeur==0)
        return;
    msg->FindInt("key",valeur);
    if(valeur==0)
        return;
    switch(*valeur){
        case STK_K_UP:
            menuchoice -= 2;
            if (menuchoice < 0) {
                menuchoice = MENUPLANETS+menuchoice;
            }
            break;
        case STK_K_DOWN:
            menuchoice+=2;
            if (menuchoice >= MENUPLANETS) {
                menuchoice = -MENUPLANETS+menuchoice;
            }
            break;
        case STK_K_LEFT:
            menuchoice-=1;
            if (menuchoice < 0) {
                menuchoice = MENUPLANETS-1;
            }
            break;
        case STK_K_RIGHT:
            menuchoice+=1;
            if (menuchoice >= MENUPLANETS) {
                menuchoice = 0;
            }
            break;
        case STK_K_ENTER:
                // we analyze the choice
            choice[menuchoice]->button->Click();
            break;
        case STK_K_ESCAPE: // Quit game
            Stk_QuitGL();
            exit(0);
            break;
    }
}

int Sp_MenuPrincipal::Loop()
{
    int i;
        // On efface le color buffer
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        // only the planet menuchoice is active
    for(i=0;i<MENUPLANETS;i++){
        choice[i]->button->active=0;
    }
    choice[menuchoice]->button->active=1;

    glPushMatrix();


    glDisable(GL_LIGHTING);
    window->Draw();
    glEnable(GL_LIGHTING);
    glPopMatrix();

        // on flipe
    Stk_SwapBuffers();
    return 1;
}

