#ifndef __SP_CAR_H
#define __SP_CAR_H

#include "sp_player.h"
#include "sp_circuit.h"
#include "../motor3d/sp_obj.h"
#include "../stk/stk.h"





/** This class represents a Point and its directional vector
    on a circuit */
class Sp_RepereOnCircuit: public Sp_Player
{
public:
// Members Functions
        /// the constructor
    Sp_RepereOnCircuit();

        /// Init the car on the circuit with a point
    void Init(Sp_CircuitC *,Sp_Point &,Sp_Vecteur &direction);

    
        /// Compute the next position
    void Compute_Next_Position(const Sp_Vecteur &displacement);

    
    
// Members Data
// Position and direction
        /// this point is the origin
    Sp_Point O;
        // Two direction vector for the front point
        /// the primary direction
    Sp_Vecteur I;
        /// the normal direction
    Sp_Vecteur K;
    
// Link with the circuit
        /// A pointer on the current circuit
    Sp_CircuitC *circuit;
        /// A pointer on the current face
    Sp_FaceC *face;

};








/** The class to conduct a car */
/* The Point O is the center of front wheels */
class Sp_Car: public Sp_View,public Sp_RepereOnCircuit, public Sp_Client_Time
{
public:
// The members functions
        /// the constructor
    Sp_Car(char *name,Sp_Adm *adm3d,Sp_Obj *father,Stk_Control *control);
        /// its destructor
    virtual ~Sp_Car();
        /// The Init function
    void Init(Sp_CircuitC *,Sp_Point &,Sp_Vecteur &direction);

    
// functions to dirige car (** interface functions **)
        /// Turn front wheels to the Right or Left
    void TurnRL(float angle);
        /// Accelerate or slacken
    void Accelerate(float val);

// this function is called at each frame
    virtual void DrawObj();

    
private:
        // we construct position with O,I,K
    void SetPosition(Sp_Vecteur &,Sp_Vecteur &);

        /// Compute the next position of car
    void ComputeNextPosition(float time_elapsed);

        /// Rotation's immediate Center
    Sp_Vecteur CIR(float time_elapsed);
    
private:
        /// a controler (keyboard, joystick)
    Stk_Control *controler;

        /// the event function is attached to the management of controler (called  in Work)
    void Event();
    
// Typical constants wich describes the car
        /// Distance Beetween Front and Rear wheels
    float distance_FR;
        /// Angle Beetween O (Center of front wheels) and Rear wheels 
    float angle_FR;


// Typical value of car
        /// Speed of car
    float speed;
        /// Angle of front wheels
    float angle;



  
    
// Others
        /// The matrix which correspond to (O,I,K)
    Sp_Trans *position;
    
        // private functions
        // Find the position of the rear wheels if it found it
    int FindRearPoint(float,float,Sp_Point &);

};



class Sp_CameraCar: public Sp_View
{
public:
// The members functions
        /// the constructor
    Sp_CameraCar(char *name,Sp_Adm *adm3d,Sp_Obj *father);
private:
        /// The matrix which correspond to (O,I,K)
    Sp_Trans *position;

};




#endif

