#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <list>
using namespace std;

#include "../stk/stk.h"
#include "stars.h"

// inferieur a 3100 
#define NUM_STARS 3100
#define RAYON 1000


Sp_Obj_stars::Sp_Obj_stars(char *filename,Sp_Adm *adm3d,Sp_Obj *ton_pere,int priority):Sp_Obj(filename,adm3d,ton_pere,priority)
{
  // pas de transformation
  Sp_Trans *tr;
  tr=new Sp_Trans(adm3d);
  tr->Id();
  trans.Add_Trans(tr);


  FILE *File;

  // Ouverture du fichier
  char *tmpfilename;
  if ((tmpfilename=(char *)malloc(strlen(filename)+strlen(DATADIR)+2))==NULL)
   {
     printf("Not enought memory\n");
     return;
   }
  sprintf(tmpfilename,"%s/%s",DATADIR,filename);
  File=fopen(tmpfilename,"rt");
  free(tmpfilename);

  char line[100],*tmp;
  float ascention,declination,magnitude;
  int i;
  float *stars;
  
  stars=new float[NUM_STARS*4];
  for (i=0;i<NUM_STARS;i++) {
    fgets(line,100,File);
    if (feof(File))
      break;
    while (line[0]=='#')
      fgets(line,100,File);
    tmp=line;
    sscanf(tmp,"%f,%f,%f\n",&ascention,&declination,&magnitude);
    /* use ascention & decl. to compute x,y,z */
    /* note: stars are plotted on a sphere around the camera */
	stars[4*i+0]= RAYON*cos(-ascention)*cos(declination);
	stars[4*i+1]= RAYON*sin(declination);
	stars[4*i+2]= RAYON*sin(-ascention)*cos(declination);
	magnitude=2*2.42/((2.46+magnitude)*2.42);
	stars[4*i+3]=magnitude; /* how bright / what color : grey->white */
  }
  fclose(File);
  


  // On cree une Sp_Entity
  Sp_Entity *entity=new Sp_Entity(this);

  entity->Init_Data(NUM_STARS,0,0);
  
  // On remplit ces tableaux
  for (i=0;i<NUM_STARS;i++)
    {
      entity->tab_points[i*4]=stars[4*i];
      entity->tab_points[i*4+1]=stars[4*i+1];
      entity->tab_points[i*4+2]=stars[4*i+2];
    }
  

  // on a un objet en point
  Sp_GEntityPoints *current;
  current=new Sp_GEntityPoints(NUM_STARS,entity);
  current->taille=1.0;
  for(i=0;i<NUM_STARS;i++)
        {
          current->color[4*i+0]=stars[4*i+3]; current->color[4*i+1]=stars[4*i+3];
          current->color[4*i+2]=stars[4*i+3]; current->color[4*i+3]=1.0;
          current->pt[i]=i;
        }
  entity->Add_GEntity(current);
  
  Add_Entity(entity);  
}


void Sp_Obj_stars::Draw()
{
  typedef list<Sp_EntityBase *>::iterator iter;
  typedef list<Sp_GEntityBase *>::iterator iter2;
  
  for(iter i=entities.begin();i!=entities.end();i++)
    {
      (*i)->DrawEntity();
    }
}

void Sp_Obj_stars::DrawObj()
{
    glDisable(GL_DEPTH_TEST);
    Draw();
    glEnable(GL_DEPTH_TEST);    
}
