#ifndef __sp_obj
#define __sp_obj


#include <string>
#include <list>
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
using namespace std;


class Sp_Obj;
class Sp_Adm;


#include "../util/sp_time.h" 
#include "../math/sp_matrice.h"
#include "sp_face.h"
#include "sp_trans.h"
#include "sp_box.h"



/* News:

   December 99:
   Modifications to manage bounding box & creation of
   sp_obj.*
*/



/* ------------------------------------------------------ */
/* ------------------ Sp_Obj ---------------------------- */
/* ------------------------------------------------------ */
/** The Base Class of all object.*/
class Sp_Obj
{
public:
  
        /* ---------- The members functions  ----------- */
    
        /// default constructor Don't use it !!!
    Sp_Obj();
        /// the real constructor 
    Sp_Obj(char *name,Sp_Adm *adm3d,Sp_Obj *your_father,int prio);
        /// The destructor
    virtual ~Sp_Obj();

        /// Add a son
    virtual void Add_Obj(Sp_Obj *);
        /// Remove a son
    virtual void Rem_Obj(Sp_Obj *);
    
        /// Add an Entity
    void Add_Entity(Sp_EntityBase *);
        /// Rem an Entity
    void Rem_Entity(Sp_EntityBase *);

        /// Print information about Sp_Obj
    virtual void Print() const;

        /// Projection * Matrix View
    virtual Sp_Mat4 GetProjection() const;
    
    
        /// Essential function: This is called each frame (used to draw)
    virtual void DrawObj();
  
   
        /* ---------- the members data ----------- */
public:

        /// the name of the object
    string Name;
        /// The father of  object
    Sp_Obj *father;
        /// The Adm 3d
    Sp_Adm *adm;
        /// his priority: This is a static value !!!
    int priority;
    
        /// Sons
    list<Sp_Obj *> sons;

        /// his entities
    list<Sp_EntityBase *> entities;
  
        /// The transformations 
    Sp_LTrans trans;
        /// The coordinates compared to the active camera
    Sp_Mat4 coord_camera;
private:
    friend class Sp_Adm ;
    void ComputeTrans();
    void ComputeTrans2();
};



/* ------------------------------------------------------ */
/* ------------------ Sp_View   ------------------------- */
/* ------------------------------------------------------ */
/** This class allows to render a view of scene */
class Sp_View: public Sp_Obj
{
public:
        /// Constructor
    Sp_View(char *name,Sp_Adm *adm3d,Sp_Obj *your_father);
        /// Destructor
    ~Sp_View();
};



/* ------------------------------------------------------ */
/* ------------------ Sp_Light  ------------------------- */
/* ------------------------------------------------------ */
/** This class represent a light */
class Sp_Light: public Sp_Obj
{
public:
        /// Constructor
    Sp_Light(char *name,Sp_Adm *adm3d,Sp_Obj *your_father);
        /// Destructor
    ~Sp_Light();

        /// Light
    virtual void Light();
        /// Active a light
    virtual void Enable();
        /// Unactive a light
    virtual void Disable();
        /// State of light
    int IsEnabled();
    
    
private:
    int active;
    friend class Sp_Adm;
    int  num_light;
};






/* ------------------------------------------------------ */
/* ------------------- Sp_Adm --------------------------- */
/* ------------------------------------------------------ */
/** The Administrator of all object. To manage time, it derivates
    from Sp_Adm_Time.
 */
class Sp_Adm : public Sp_Obj, public Sp_Adm_Time
{
public:

        /// The constructor
    Sp_Adm(char *name);
        /// His destructor
    ~Sp_Adm();

        /// Add an obj in the scene
    void Add_Obj(Sp_Obj *);
        /// Remove an obj of the scene
    void Rem_Obj(Sp_Obj *);

        /// Add a View of scene
    void Add_View(Sp_View *);
        /// Rem a view of scene
    void Rem_View(Sp_View *);
        /// Active a view
    void Active_View(Sp_View *);

        /// Add a Light
    void Add_Light(Sp_Light *);
        /// Rem a Light
    void Rem_Light(Sp_Light *);
    
            /// Load a texture
    static int Load_texture(char *filename);
        /// Delete a texture
    static void Delete_texture(int );

    
        /// It draws the scene
    void DrawScene();


 
private:
        /** list of objects in the scene classified by croissant priority.
            First we draw low priority... then bigger priority objects */
    list<Sp_Obj *> objs;
        /// List of view
    list<Sp_View *> views;
        /// Array of Light
    list<Sp_Light *> lights;
        /// Active view
    Sp_View *current_view;
    
        /// Compute the Transformations % adm
    void Transformations();
        /// Compute the Transformations % view
    void Transformations2();
        /// Light
    void LightScene();
};



#endif




