#ifndef __SP_JOURNEY
#define __SP_JOURNEY

#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <list>
#include <vector>
using namespace std;


/** CheckPoint: this class allows to know what are the journey of car
    This surface must be traversed to be validated. Some Face of a
    circuit points on it.
    Each player is represented by an unique int.
 */
class Sp_CheckPoint
{
    friend class Sp_Journey;
public:
        /// constructor
    Sp_CheckPoint();
        /// destructor
    virtual ~Sp_CheckPoint();
    
        /// Add a player 
    virtual void AddPlayer(int player);
    
        /// this function is called when a player is on a checkpoint
    virtual void On(int player,long temps);

protected:
        /// last time for each player 
    vector<long> time;
};





/** Journey: it is an ensemble of CheckPoints ordered.
    And it is a particular checkpoint: the finish.
    Rem: we could not add dynamically checkpoints.
*/
class Sp_Journey: public Sp_CheckPoint
{
public:
        /// constructor
    Sp_Journey();
        /// destructor
    virtual ~Sp_Journey();

        /// add a player to the journey
    int AddPlayer();

        /// add a player to finish
    void AddPlayer(int);

        /// give the bestlap of a player
    long BestLap(int player);
    
        /// this function is called when a player is on arrival
    virtual void On(int player,long temps);

protected:
        /// add checkpoint (only use in constructor of derivated class)
    void AddCheckPoint(Sp_CheckPoint *);

private:
        /// list of best lap for each player
    vector<long> bestlap;
    
        /// list ordered of checkpoints
    list<Sp_CheckPoint *> checkpoints;

        /// number of players
    int nbplayers;
};







#endif
