#include "sp_journey.h"
#include "../util/sp_debug.h"


/* --------------------------- Sp_CheckPoint ----------------------- */

Sp_CheckPoint::Sp_CheckPoint()
{}

Sp_CheckPoint::~Sp_CheckPoint()
{}

void Sp_CheckPoint::AddPlayer(int player)
{
        // we add a place for time player
    time.push_back(0);
    SP_ERROR((int)time.size()!=(player+1),"the track is not well constructed");

}

void Sp_CheckPoint::On(int player,long temps)
{
    time[player]=temps;
//    printf("un checkpoint");
//    printf("time %d\n",temps);
}




/* --------------------------- Sp_Journey ------------------------- */
Sp_Journey::Sp_Journey()
        :Sp_CheckPoint()
{
        // we have no players
    nbplayers=0;
        // this is a checkpoint
    checkpoints.push_back(this);
    
}


Sp_Journey::~Sp_Journey()
{
}


void Sp_Journey::AddCheckPoint(Sp_CheckPoint *ch)
{
    checkpoints.push_back(ch);
}


int Sp_Journey::AddPlayer()
{
    nbplayers+=1;
        // add a player for each checkpoint
    typedef list<Sp_CheckPoint *>::iterator iter;
    for(iter i=checkpoints.begin();i!=checkpoints.end();i++){
        (*i)->AddPlayer(nbplayers-1);
    }
    return nbplayers-1;
}


void Sp_Journey::AddPlayer(int player)
{
    Sp_CheckPoint::AddPlayer(player);
        // we add a place for bestlap player
    bestlap.push_back(-1);
    SP_ERROR((int)bestlap.size()!=(player+1),"the track is not well constructed");
}

void Sp_Journey::On(int player,long temps)
{
//  printf("un checkpoint finish %d\n",time[player]);
        // first we verify that times of checkpoint are growing
    typedef list<Sp_CheckPoint *>::iterator iter;
    long tempo=-1;
    for(iter i=checkpoints.begin();i!=checkpoints.end();i++){
//        printf("temps intermedaire %d \n", (*i)->time[player]);
        if( (*i)->time[player] > tempo ){
            tempo=(*i)->time[player];
        } else {
            return;
        }
    }
        // compute the time lap of this player
    long timelap=temps-time[player];
//    printf("timelap %d\n",timelap);
        // save it, if it is better
    if(bestlap[player]<=0){
        bestlap[player]=timelap;
        time[player]=temps;
    }
    if((bestlap[player]>0)&&(bestlap[player]>timelap)){
        bestlap[player]=timelap;
        time[player]=temps;
    }
}

long Sp_Journey::BestLap(int player)
{
    return bestlap[player];
}
