#ifndef __LOADGL_H
#define __LOADGL_H

#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <list>
#include <vector>
using namespace std;






// include necessary to 3D
#include "sp_obj.h"
#include "face.h"

// include necessary to physics
#include "../physique/sp_circuit.h"



template <class T>
class Stk_Array
{
public:
        /// Constructor
    Stk_Array(int sz_max);
        /// Destructor
    ~Stk_Array();
        /// Put an element (it is a copy of element)
    void put(const T &el);
    
    T *array;
    int size_max;
    int nb_elements;
};


/* Its class allows to choice faces belonging to indices */
class sp_indice_list:public Stk_Array<unsigned int>
{
public:
        // constructor
    sp_indice_list(int sz_max,int nb);

        // add an indice
    void Add_Indice(const unsigned int &ind);
    
        // Is this indice in the list
    int isIndiceInList(const unsigned int &ind);

        // select triangles in
    unsigned int *select_face_in(unsigned int *data,int nb_faces,int *nb_trouve);

        // select triangles out
    unsigned int *select_face_out(unsigned int *data,int nb_faces,int *nb_trouve);  
 
private:
        // number of points of shape of circuit
    int nb_points_on_shape;
};







/*
class sp__indice_list
{
public:
        // constructor
    sp__indice_list(int nb);
        // add indice 
    void Add_Indice(unsigned int ind);
        // Remove indice
        // void Rem_Indice(unsigned int ind);
        // L indice est il dans la liste ?
    int isIndiceInList(unsigned int ind);
        // select triangles in
    unsigned int *select_face_in(unsigned int *data,int nb_faces,int *nb_trouve);
        // select triangles out
    unsigned int *select_face_out(unsigned int *data,int nb_faces,int *nb_trouve);  
        // les indices
    vector<unsigned int> liste_indices;
        // le nombre de points de la shape
    int nb_points;
};
*/






class Sp_Obj_gl: public Sp_Obj
{
  public:
    Sp_Obj_gl(char *filename,Sp_Adm *adm3d,Sp_Obj *ton_pere,int priority);
    virtual void Draw();
    virtual void DrawObj();
};










class Sp_Load_CircuitC: public Sp_CircuitC
{
  public:
        //the constructors
    Sp_Load_CircuitC(char *filename);
    
};





#endif




