#include "../stk/stk.h"
#include "face.h"
#include "sp_box.h"
#include "../math/sp_math.h"

/* -------------------------------------------------------------- */
/*                              Sp_Entity                         */
/* -------------------------------------------------------------- */
Sp_Entity::Sp_Entity(Sp_Obj *maitre):Sp_EntityBase(maitre)
{
}

void Sp_Entity::Init_Data(int nbpt,int nbnor,int nbtex)
{
  tab_points=new float[4*nbpt];
  tab_normales=new float[4*nbnor];
  tab_textures=new float[2*nbtex];
}

void Sp_Entity::Del_Data()
{
  delete[] tab_points;
  delete[] tab_normales;
  delete[] tab_textures;
}

void Sp_Entity::Draw()
{
  typedef list<Sp_GEntityBase *>::iterator iter2;
  for(iter2 j=gentities.begin();j!=gentities.end();j++)
    (*j)->DrawGEntity();
}

/* -------------------------------------------------------------- */
/*                    Sp_EntityMultiplexe                         */
/* -------------------------------------------------------------- */
Sp_EntityMultiplexe::Sp_EntityMultiplexe(Sp_Obj *maitre):Sp_EntityBase(maitre)
{
}

void Sp_EntityMultiplexe::Init_Data(int nbpt,GLenum mode)
{
  format=mode;
  switch(format)
    {
    case GL_T2F_V3F:
      data=new float[nbpt*5];
      break;
    case GL_T2F_N3F_V3F:
      data=new float[nbpt*8];
      break;
    default:
      printf("format non supportes pour les tab multiplexes\n");
      break;
    }
}

void Sp_EntityMultiplexe::Del_Data()
{
  delete[] data;
}

void Sp_EntityMultiplexe::Draw()
{
  typedef list<Sp_GEntityBase *>::iterator iter2;
  glEnableClientState(GL_VERTEX_ARRAY);
  glEnableClientState(GL_TEXTURE_COORD_ARRAY);

  glInterleavedArrays(format,0,data);
  for(iter2 j=gentities.begin();j!=gentities.end();j++)
    (*j)->DrawGEntity();
}







/* -------------------------------------------------------------- */
/*                         Sp_GEntityPoints                       */
/*                         pour Sp_Entity                         */
/* -------------------------------------------------------------- */
Sp_GEntityPoints::Sp_GEntityPoints(int nbpts,Sp_Entity *maitre)
        :Sp_GEntityBase(maitre)
{
  master=maitre;
  nb=nbpts;
  pt=new int[nb];
  color=new float[nb*4];
}

void Sp_GEntityPoints::Draw()
{
  float *tpt=master->tab_points;

  glPointSize(taille);
  glEnable(GL_POINT_SMOOTH);
  glDisable(GL_LIGHTING);
  glDisable(GL_TEXTURE_2D);
  glBegin(GL_POINTS);
  for(int i=0;i<nb;i++)
    {
      glColor4fv(&color[i<<2]);
      glVertex3fv(&tpt[pt[i]<<2]);
    }
  glEnd();
  glColor4f(1.0,1.0,1.0,1.0);
}

/* -------------------------------------------------------------- */
/*                              Sp_GEntity1                       */
/*                             pour Sp_Entity                     */
/* -------------------------------------------------------------- */
Sp_GEntity1::Sp_GEntity1(Sp_Entity *maitre)
     :Sp_GEntityBase(maitre)
{
  master=maitre;
}

void Sp_GEntity1::Draw()
{
  float *tpt=master->tab_points;
  float *tnor=master->tab_normales;

  glPointSize(1.0);
  glBegin(GL_POINTS);
  glNormal3fv(&tnor[norm[0]<<2]);
  glVertex3fv(&tpt[pt[0]<<2]);
  glEnd();

}

/* -------------------------------------------------------------- */
/*                              Sp_GEntity4                       */
/*                            pour Sp_Entity                      */
/* -------------------------------------------------------------- */
Sp_GEntity4::Sp_GEntity4(Sp_Entity *maitre)
     :Sp_GEntityBase(maitre)
{
  master=maitre;
}


#define POINTGL(nb)                 \
  glNormal3fv(&tnor[norm[nb]<<2]);  \
  glTexCoord2fv(&ttex[tex[nb]<<1]); \
  glVertex3fv(&tpt[pt[nb]<<2])      \

void Sp_GEntity4::Draw()
{
  float *tpt=master->tab_points;
  float *tnor=master->tab_normales;
  float *ttex=master->tab_textures;

  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, num_tex);
  glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

  glBegin(GL_QUADS);
  POINTGL(0);
  POINTGL(1);
  POINTGL(2);
  POINTGL(3);
  glEnd();

  glDisable(GL_TEXTURE_2D);
}

/* -------------------------------------------------------------- */
/*                              Sp_GEntitySphere                  */
/*                            pour Sp_Entity                      */
/* -------------------------------------------------------------- */
Sp_GEntitySphere::Sp_GEntitySphere(Sp_Entity *maitre,float r)
     :Sp_GEntityBase(maitre)
{
  master=maitre;
  radius=r;
  
  Sp_Box boundingbox(Sp_Point(-r,-r,-r));
  boundingbox.Add_Point(Sp_Point(r,r,r));
  bounding_box=boundingbox;
  IsBounding=1;
  // on cree une quadric
  obj = gluNewQuadric();
  // on la texture
  gluQuadricTexture(obj,GL_TRUE);
}

void Sp_GEntitySphere::Draw()
{
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, num_tex);
        /*glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT); 
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);*/
    gluSphere( obj, radius, slices, stacks );
    glDisable(GL_TEXTURE_2D);
}

/* -------------------------------------------------------------- */
/* ------------------   Sp_GEntityMulti      -------------------- */
/* ----------------   pour Sp_EntityMultiplexe   ---------------- */
/* -------------------------------------------------------------- */
Sp_GEntityMulti::Sp_GEntityMulti(Sp_EntityMultiplexe *maitre)
        :Sp_GEntityBase(maitre)
{
  master=maitre;
}

void Sp_GEntityMulti::ComputeBox()
{
    int i;
    float *data2=master->data;
    unsigned int *data3=data;
    Sp_Point  Pt(  data2[((*data3)<<3)+5],
            data2[((*data3)<<3)+6],
            data2[((*data3)<<3)+7]);
    Sp_Box b(Pt);
    for(i=0;i<nb;i++){
        b.Add_Point(
            Sp_Point(data2[((*data3)<<3)+5],data2[((*data3)<<3)+6],data2[((*data3)<<3)+7])
            );
        data3++;
    }
    bounding_box=b;
    IsBounding=1;
}


void Sp_GEntityMulti::Draw()
{
    glEnable(GL_CULL_FACE);
    glEnable(GL_TEXTURE_2D);
        //glEnable(GL_LIGHTING);
    
    glBindTexture(GL_TEXTURE_2D, num_tex);
#ifdef SP_OPENGL_1_1
    printf("OpenGL 1.1\n");
    glDrawElements(type,nb,GL_UNSIGNED_INT,data);
#endif
#ifndef SP_OPENGL_1_1
    int i;
    float *data2=master->data;
    unsigned int *data3=data;
    glBegin(GL_TRIANGLES);
    for(i=0;i<nb;i++){
        glTexCoord2fv(&data2[(*data3)<<3]     );
        glNormal3fv(  &data2[((*data3)<<3)+2] );
        glVertex3fv(  &data2[((*data3)<<3)+5] );
        data3++;
    }
    glEnd();
#endif
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_CULL_FACE);
}


