#ifndef SP_MATHLIN_H
#define SP_MATHLIN_H

/* the module wich find solution to equation systeme */
#include <vector>
#include <list>
using namespace std;

class Sp_Vector_lin;
class Sp_System_lin;

#include <math.h>
#include "sp_math.h"




/* This class was first implemented with the STL vector class
   But it was too slow. So i decided to use normal array */
/** The line vector for linear system */
class Sp_Vector_lin{
    friend class Sp_System_lin;
  public:
    
        // The constructors
        /// constructor with 4 float 
    Sp_Vector_lin(float a,float b,float c,float d);
        /// constrcutor with Sp_Plan
    Sp_Vector_lin(const Sp_Plan &p);
        /// copy constructor
    Sp_Vector_lin(const Sp_Vector_lin &);
        /// destructor
    ~Sp_Vector_lin();
    
    
    
        /// Print information
    void Print() const;

        /// Size of vector
    int Size() const;

    
  private:
        /// the vector is reduced with v[i]=1
        // Warning v[i] must be different to 0
    void Reduce(int i);
    
        /// Is v[i] null ?
    int IsCoefNull(int i) const;

    
  private:
        /// the data of vector
    float *v;
        /// the size
    int size;
};


/** the class to solve a linear system */
class Sp_System_lin {
  public:
        /// constructors
    Sp_System_lin();

        /// Print solution
    void Print() const;
  
        /// Add a line to the system
    void Add(Sp_Vector_lin *);

        /// Give the sol by his coord
        // To have x, you do i=0 ...
    int GetSol(float &x,int col);



  private:
    
        /// Exchange lignes
    void ExchangeLines(int j,int k);

        /// Find a line (in line lig to the last) with a column not null 
    int FindLine(int col,int lig);

        /// the coord col_i from line_i is set to 0 whith the line lig_j 
    void MakeNullCoef(int lig_i,int col_i,int lig_j);

        // A step into the resolution
    int DiagLine(int col,int lig);
    
        // the resolution
    void Diagonalise();
    
        // the size of system
    int Size() const;
        // Number of lines
    int NumberOfLines() const;
    
        // les variables
    vector<Sp_Vector_lin *> lines;

        // a flag to know if the function Diagonalise has been called
    int flag;
};





/** The Class to solve 2nd degree equations */
class Sp_Eq2dg
{
public:
    
        // members functions
        /// The Constructor: a1X^2+b1X+c1=0
    Sp_Eq2dg(float a1,float b1,float c1);
        /// find Solution
    void Solution();
        /// Add a value in the solution list (it is a hack)
    void Add(float);
        /// Print solutions
    void Print();

        // les variables membres
        /// list of solutions
    list<float> solution;
       
private:
        // les coefs ax2+bx+c=0
    float a;
    float b;
    float c;  
};



// Les intersections
class Intersection
{
public:
  // le constructeur
  Intersection(const Sp_Droite &,const Sp_Sphere &);
  Intersection(const Sp_Plan &,const Sp_Plan &);
  Intersection(const Sp_Plan &p1,const Sp_Plan &p2,const Sp_Point &p);
  Intersection(const Sp_Droite &,const Sp_Plan &);
  // une fonction utile
  void function1(Sp_Plan &plan1,Sp_Plan &plan2,Sp_Vecteur &,const Sp_Point &);
  
  void Init(const Sp_Droite &d,const Sp_Sphere &s);
  

 
  // Les donnees membres
  list<Sp_Point> liste_points;
  list<Sp_Droite> liste_droites;
};

#endif
