#ifndef _IMAGEBUFFER_H
#define _IMAGEBUFFER_H
#include "ImageFormat.h"
#include <stdlib.h>

class ImageBuffer {
protected:
public:  
  ImageFormat *image;
public:
  unsigned char *getData(void)
	 {
		 if(image){
				return image->data();
		 }
		 else
			 return NULL;
	 }
  int getWidth(void)
    {
      if(image){
      return image->width();
      }
			else
				return -1;
    }
  int getHeight(void)
    {
      if(image){
	return image->height();
      }
			else
				return -1;
    }
  
	int isRGBA(void){
		 if(image){
				if(image->format()==FORM_RGBA)
					return 1;
				else
					return 0;
		 }
		 else
			 return 0;
	}
  
  int isRGB(void){
    if(image){
      if(image->format()==FORM_RGB)
	return 1;
      else
	return 0;
    }
		else
			return 0;
  }
  
  void toRGB(void){
    if(image){
      image->convert(FORM_RGB);
    }
  }
  
  void toRGBA(void){
    if(image){
      image->convert(FORM_RGBA);
    }
  }
   
  ImageBuffer(char * filename);
  ImageBuffer(ImageFormat *newim)
    {
      if(image)delete(image);
      image=newim;
    }
}; 



#endif
		
	    
