/*
  This file uses the WGL protocol to link WIN32 & OpenGL.
*/


#include "../input/stk_keyboard.h"
#include "stk_w32.h"




// global variable
HWND	ghWnd;
HDC		ghDC;
HGLRC	ghRC;
extern Stk_Looper *looper;

CHAR szAppName[]="Space Racer 3.0";


char keys_win32[256];


BOOL bSetupPixelFormat(HDC hdc)
{
	int pixelformat;
	PIXELFORMATDESCRIPTOR pfd= {
		sizeof(PIXELFORMATDESCRIPTOR),
		1,
		PFD_DRAW_TO_WINDOW |
		PFD_SUPPORT_OPENGL |
		PFD_DOUBLEBUFFER,
		PFD_TYPE_RGBA,
		16,
		0,0,0,0,0,0,
		0,
		0,
		0,
		0,0,0,0,
		24,
		0,
		0,
		PFD_MAIN_PLANE,
		0,
		0,0,0
	};
	pixelformat = ChoosePixelFormat(hdc,&pfd);
	if ( (pixelformat = ChoosePixelFormat (hdc, &pfd) ) ==0 ){
		MessageBox(NULL,"ChoosePixelFormat failed","Error",MB_OK);
		return FALSE;
	}
	if (SetPixelFormat(hdc,pixelformat,&pfd)==FALSE){
		MessageBox(NULL,"SetPixelFormat failed","Error",MB_OK);
		return FALSE;
	}
	return TRUE;
}


LONG	WINAPI	MainWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{

	LONG lRet;
//	PAINTSTRUCT ps;
	RECT rect;


	switch(uMsg) {

	case WM_CREATE:
		ghDC = GetDC(hWnd);
		if(!bSetupPixelFormat(ghDC))
			PostQuitMessage(0);
		ghRC = wglCreateContext(ghDC);
		wglMakeCurrent(ghDC,ghRC);
		GetClientRect(hWnd,&rect);
		break;

	case WM_DESTROY:

		if(ghRC)
			wglDeleteContext(ghRC);
		if(ghDC)
			ReleaseDC(hWnd,ghDC);
		PostQuitMessage(0);
		exit(0);
		break;

	case WM_KEYDOWN:
		if((lParam&(1<<30))==0){
		switch(wParam){
		
		case VK_ESCAPE:
			{
		    Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",1);
			msg2->AddInt("keys",K_QUIT);
			keys_win32[K_QUIT]=1;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_LEFT:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",1);
			msg2->AddInt("keys",K_LEFT);
			keys_win32[K_LEFT]=1;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_RIGHT:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",1);
			msg2->AddInt("keys",K_RIGHT);
			keys_win32[K_RIGHT]=1;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_UP:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",1);
			msg2->AddInt("keys",K_UP);
			keys_win32[K_UP]=1;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_DOWN:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",1);
			msg2->AddInt("keys",K_DOWN);
			keys_win32[K_DOWN]=1;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_RETURN:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",1);
			msg2->AddInt("keys",K_ENTER);
			keys_win32[K_ENTER]=1;
			looper->StkPostMessage(msg2);			
			}
			break;
		}
		}
		break;
	case WM_KEYUP:
//		printf("lolo\n");
		switch(wParam){
		
		case VK_ESCAPE:
			{
		    Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",0);
			msg2->AddInt("keys",K_QUIT);
			keys_win32[K_QUIT]=0;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_LEFT:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",0);
			msg2->AddInt("keys",K_LEFT);
			keys_win32[K_LEFT]=0;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_RIGHT:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",0);
			msg2->AddInt("keys",K_RIGHT);
			keys_win32[K_RIGHT]=0;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_UP:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",0);
			msg2->AddInt("keys",K_UP);
			keys_win32[K_UP]=0;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_DOWN:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",0);
			msg2->AddInt("keys",K_DOWN);
			keys_win32[K_DOWN]=0;
			looper->StkPostMessage(msg2);
			}
			break;
		
		case VK_RETURN:
			{
			Stk_Message *msg2=new Stk_Message(KEY_EVENT);
			msg2->AddInt("pressed",0);
			msg2->AddInt("keys",K_ENTER);
			keys_win32[K_ENTER]=0;
			looper->StkPostMessage(msg2);			
			}
			break;
		}
	break;
	default:
		lRet = DefWindowProc(hWnd,uMsg,wParam,lParam);
	}
	return lRet;
}












int Stk_SwapBuffers()
{
	SwapBuffers(ghDC);
	return 0;
}



int Stk_EventLoop()
{
 	MSG	msg;
	PeekMessage(&msg,NULL,0,0,PM_REMOVE);
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	return 0;
}




int Stk_InitWGL(HINSTANCE hInstance,int nCmdShow,int size_x,int size_y)
{

	WNDCLASS wndclass;;
	RECT rect;

	wndclass.style			= 0;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;
	wndclass.hInstance		= hInstance;
	wndclass.hIcon			= LoadIcon(hInstance,szAppName);
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground	= (HBRUSH) (COLOR_WINDOW+1);
	wndclass.lpszMenuName	= szAppName;
	wndclass.lpszClassName	= szAppName;
	
	if(!RegisterClass (&wndclass) )
		return FALSE;
	
	// specify exact client size
	rect.left = rect.top = 0;
	rect.right = size_x;
	rect.bottom = size_y;
	AdjustWindowRect(&rect,WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN,FALSE);
	// create the Frame
	ghWnd= CreateWindow(szAppName,szAppName,WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN,
						CW_USEDEFAULT,
						CW_USEDEFAULT,
						size_x,
						size_y,
						NULL,
						NULL,
						hInstance,
						NULL);
	// make sure window was created
	if(!ghWnd)
		return FALSE;
	// init tab keys
	for(int i=0;i<256;i++){
		keys_win32[i]=0;
	}
	// show window
	ShowWindow(ghWnd,nCmdShow);
	UpdateWindow(ghWnd);
	return 0;
}

	
int Stk_QuitGL()
{
	return 0;
}
