/*
  This file uses the sdl library
 */

#include "stk_sdl.h"
#include "stk_message.h"
#include "../sound/stk_sound.h"
#include "../input/stk_keyboard.h"

int HandleEvent(SDL_Event *event,Stk_Looper *looper);


int Stk_SwapBuffers()
{
    SDL_GL_SwapBuffers( );
    return 0;
}

int Stk_EventLoop(Stk_Looper *looper)
{
    int done;
    SDL_Event event;
    while( SDL_PollEvent( &event ) ) {
        done = HandleEvent(&event,looper);
    }
    return 0;
}


void Stk_QuitGL()
{
        /* Destroy our GL context, etc. */
    SDL_Quit();
}


#define KEYB_MACRO(key,type,pressed)                  \
{                                                     \
     Stk_Message *msg=new Stk_Message(STK_KEY_EVENT); \
     msg->AddInt("type",type);                        \
     msg->AddInt("key",key);                          \
     msg->AddInt("pressed",pressed);                  \
     looper->StkPostMessage(msg);                     \
}



int HandleEvent(SDL_Event *event,Stk_Looper *looper)
{
	int done;

	done = 0;
	switch( event->type ) {
	    case SDL_ACTIVEEVENT:
            break;
                /* See what happened */
            printf( "app %s ", event->active.gain ? "gained" : "lost" );
            if ( event->active.state & SDL_APPACTIVE ) {
                printf( "active " );
            } else if ( event->active.state & SDL_APPMOUSEFOCUS ) {
                printf( "mouse " );
            } else if ( event->active.state & SDL_APPINPUTFOCUS ) {
                printf( "input " );
            }
            printf( "focus\n" );
            break;

	    case SDL_KEYDOWN:
        {
            switch(event->key.keysym.sym){
                case SDLK_RETURN:
                    KEYB_MACRO(STK_K_ENTER,2,1);
                    break;
                case SDLK_BACKSPACE:
                   KEYB_MACRO(STK_K_BACKSPACE,2,1);
                   break;
                case SDLK_DELETE:
                    KEYB_MACRO(STK_K_DELETE,2,1);
                    break;
                case SDLK_ESCAPE:
                    KEYB_MACRO(STK_K_ESCAPE,2,1);
                    break;
                case SDLK_UP:
                   KEYB_MACRO(STK_K_UP,2,1);
                   break;
                case SDLK_DOWN:
                   KEYB_MACRO(STK_K_DOWN,2,1);
                   break;
               case SDLK_RIGHT:
                   KEYB_MACRO(STK_K_RIGHT,2,1);
                   break;
               case SDLK_LEFT:
                   KEYB_MACRO(STK_K_LEFT,2,1);
                   break;
                case SDLK_SPACE:
                    KEYB_MACRO(' ',1,1);
                    break;
                case SDLK_F12:
                    printf("f12\n");
                    exit(0);
                    break;
                default:
                    KEYB_MACRO(*SDL_GetKeyName(event->key.keysym.sym),1,1);
    
            }
                //   printf("key '%s' pressed\n", 
                //          SDL_GetKeyName(event->key.keysym.sym));
        }
        break;

        case SDL_MOUSEBUTTONUP:
        {          
            Stk_Message *msg=new Stk_Message(STK_MOU_EVENT);
            msg->AddInt("type",1);
            msg->AddInt("button",event->button.button);
            msg->AddInt("pressed",0);
            msg->AddInt("x",event->button.x);
            msg->AddInt("y",event->button.y);
            looper->StkPostMessage(msg);
        }
        break;
        
        case SDL_MOUSEBUTTONDOWN:
        {          
            Stk_Message *msg=new Stk_Message(STK_MOU_EVENT);
            msg->AddInt("type",1);
            msg->AddInt("button",event->button.button);
            msg->AddInt("pressed",1);
            msg->AddInt("x",event->button.x);
            msg->AddInt("y",event->button.y);
            looper->StkPostMessage(msg);
        }
        break;
        
        case SDL_MOUSEMOTION:
        {          
            Stk_Message *msg=new Stk_Message(STK_MOU_EVENT);
            msg->AddInt("type",2);
            msg->AddInt("x",event->motion.x);
            msg->AddInt("y",event->motion.y);
            looper->StkPostMessage(msg);
        }   
        break;
        
	    case SDL_QUIT:
            exit(0);
            break;
	}
	return(done);
}
  

int Stk_InitGL(int size_x,int size_y)
{
    Uint32 video_flags;
    int bpp = 16;
  
        // Test if we could init SDL video
    if( SDL_Init( SDL_INIT_VIDEO ) < 0 ) {
        fprintf(stderr,"Couldn't initialize SDL video %s",SDL_GetError());
        exit( 1 );
    }
        // Test if we could init the SDL audio
    if(SDL_Init( SDL_INIT_AUDIO) < 0 ){
        fprintf(stderr,"Couldn't initialize SDL audio %s",SDL_GetError());
        exit( 1 );
    }
    
    atexit(Stk_QuitGL);
  
        /* Set the flags we want to use for setting the video mode */
    video_flags = SDL_OPENGL;

        /* Don't show the cursor */
    SDL_ShowCursor(0);
  
        /* Initialize the display */
    SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );

    if (SDL_SetVideoMode( size_x, size_y, bpp, video_flags ) == NULL ) {
        fprintf(stderr, "Couldn't set GL mode: %s\n", SDL_GetError());
        SDL_Quit();
        exit(1);
    }

    
    int value;
    SDL_GL_GetAttribute( SDL_GL_RED_SIZE, &value );
    printf( "SDL_GL_RED_SIZE: requetsed 5, got %d\n", value );
    SDL_GL_GetAttribute( SDL_GL_GREEN_SIZE, &value );
    printf( "SDL_GL_GREEN_SIZE: requested 5, got %d\n", value);
    SDL_GL_GetAttribute( SDL_GL_BLUE_SIZE, &value );
    printf( "SDL_GL_BLUE_SIZE: requested 5, got %d\n", value );
    SDL_GL_GetAttribute( SDL_GL_DEPTH_SIZE, &value );
    printf( "SDL_GL_DEPTH_SIZE: requested 16, got %d\n", value );
    SDL_GL_GetAttribute( SDL_GL_DOUBLEBUFFER, &value );
    printf( "SDL_GL_DOUBLEBUFFER: requested 1, got %d\n", value );

        /* Set the window manager title bar */
    SDL_WM_SetCaption( "Space Racer GL", "Space Racer" );


/*    
    Stk_PSound *canal=new Stk_PSound(2);
    Stk_Message *msg=new Stk_Message(10);
    printf("on envoie le message\n");
    canal->SendMsg(msg);
  */  
    /*canal->function();
    */
    return 0;
}
