#include "SDL/SDL.h"

#include "stk_looper.h"


/* ------------- Message ----------------- */
Stk2_Message::Stk2_Message(int w)
{
    what=w;
}



/* ---------------------- List of messages -------------------- */
Stk2_Messages::Stk2_Messages()
{}

Stk2_Messages::~Stk2_Messages()
{}

void Stk2_Messages::AddMessage(Stk2_Message *msg)
{
    P();
    push_back(msg);
    V();
}

int Stk2_Messages::PollMessage(Stk2_Message *&msg)
{
    if(size()==0)
        return 0;
    P();
    msg=back();
    pop_back();
    V();
    return 1;
}


/* ---------------------- Looper ----------------------------- */

Stk2_Looper::Stk2_Looper(int freq=25)
        :Stk_Thread()
{
    frequency=freq;
    end=0;
    ended=0;
}

void Stk2_Looper::Quit()
{
    end=1;
}


Stk2_Looper::~Stk2_Looper()
{
    Quit();
    while(ended==0)
        SDL_Delay(10);
}


int Stk2_Looper::function()
{
    while(!end){
        Loop();
        SDL_Delay((int)(1000.0f/frequency));
    }
    ended=1;
    return 0;
}


void Stk2_Looper::SendMessage(Stk2_Message *msg)
{
    AddMessage(msg);
}



void Stk2_Looper::Loop()
{}
