/* the sex of machine is known with config.h...
 there is a WORDS_BIGENDIAN */

#include <string.h>
#include "stk_file.h"

Stk_File::Stk_File(char *filename) throw (xFileError)
{
        // init the file descriptor
    fd=0;
        // verify that we have a file name
    if(filename==0){
        throw xFileError();
    }
        // We look into the data dir
    char *tmpfilename;
        // do some filetype-magic
    if((tmpfilename=(char *)malloc(strlen(filename)+strlen(DATADIR)+2))==NULL)
    {
        printf("Not enought memory\n");
        return;
    }
    sprintf(tmpfilename,"%s/%s",DATADIR,filename);
        // open the file
    if( (fd=fopen(tmpfilename,"rb"))==NULL){
        printf("file %s not found\n",filename);
        throw xFileError();
        return;
    }
    free(tmpfilename);
}

Stk_File::~Stk_File()
{
    if(fd){
        fclose(fd);
    }
}

long Stk_File::Size()
{
    long size;
    fseek(fd,0,SEEK_END);  
    size=ftell(fd);  
    fseek(fd,0,SEEK_SET);
    return size;
}



int Stk_File::LoadInt()
{
    int result;
    fread ( & result , 4 , 1, fd ) ;
    SexInt(result);
    return result;
}

short Stk_File::LoadShort()
{
    short result;
    fread ( & result , 2 , 1, fd ) ;
    SexShort(result);
    return result;
}


char Stk_File::LoadChar()
{
    char result;
    fread ( & result , 1 , 1, fd ) ;
    return result;
}

float Stk_File::LoadFloat()
{
    float result;
    fread ( & result, 4 , 1, fd );
    SexFloat(result);
    return result;
}



int Stk_File::SexInt(int a)
{
    int b;
#ifndef WORDS_BIGENDIAN
    char *pa=(char *)&a;
    char *pb=(char *)&b;
    pb[0]=pa[3]; pb[1]=pa[2];
    pb[2]=pa[1]; pb[3]=pa[0];
#endif
    return b;
}

short Stk_File::SexShort(short a)
{
    short b;
#ifndef WORDS_BIGENDIAN
    char *pa=(char *)&a;
    char *pb=(char *)&b;
    pb[0]=pa[1]; pb[1]=pa[0];
#endif
    return b;
}

float Stk_File::SexFloat(float a)
{
    float b;
#ifndef WORDS_BIGENDIAN
    char *pa=(char *)&a;
    char *pb=(char *)&b;
    pb[0]=pa[3]; pb[1]=pa[2];
    pb[2]=pa[1]; pb[3]=pa[0];
#endif
    return b;
}









