#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include "../stk.h"



/* The joystick class code common on every plateforme */
int Stk_Joy::IsPresent() const
{
    return present;
}

void Stk_Joy::Print() const
{
    if(present){
        int i;
        printf("information about the joystick\n");
        printf("state of buttons:\n");
        for(i=0;i<nb_buttons;i++){
            printf("  state of buttons %d %d:\n",i,array_buttons[i]);
        }
        printf("state of axes:\n");
        for(i=0;i<nb_axes;i++){
            printf("  state of axe %d ",i);
            array_axes[i].Print();
        }
    }else {
        printf("pas de joy disponible\n");
    }
}




float Stk_Joy::getPositionAxeX() const
{
    return array_axes[0].getPosition();
}

float Stk_Joy::getPositionAxeY() const
{
    return array_axes[1].getPosition();
}

float Stk_Joy::getButton1() const
{
    return (float)array_buttons[0];
}

float Stk_Joy::getButton2() const
{
    return (float)array_buttons[0];
}

float Stk_Joy::getButton3() const
{
    return (float)array_buttons[0];
}

float Stk_Joy::getButton4() const
{
    return (float)array_buttons[0];
}


int Stk_Joy::Loop()
{
    ReadState();
    return 1;
}


void Stk_Axe::Print() const
{
    printf("position:%f\n",position);
}



float Stk_Axe::getPosition() const
{
    return position;
}







/* ************** Specific Code ********************/


/* New driver version availbale on kernel linux > 2.2.x */
#ifdef LINUX_JOYSTICK_NEW

// variables for the modules
// the state of joy
js_event js;

// the constructor 
Stk_Joy::Stk_Joy(char *filename,Stk_Looper *l)
     :Stk_PassiveSender(l)
{
        // the default name
    char *devname="/dev/js0";
        // we try to open this file
    if(filename) {
        devname=filename;
    }
    fd= open(devname, O_RDONLY);

        // check
    if(fd<0) {
        STK_WARNING((errno == ENODEV),"Joystick not configured - did you load the module?\n");
        char text[128];
        sprintf(text,"Couldn't open '%s'\n", devname);
        STK_WARNING((errno != ENODEV),text);
            // no joystick found
        present=0;
        return;
    }
    
        // we search information: number of axes and buttons
    fcntl(fd, F_SETFL, O_NONBLOCK);
    int version=0;
    ioctl(fd, JSIOCGVERSION, &version);
    nb_axes=0;
    ioctl(fd, JSIOCGAXES, &nb_axes);
    nb_buttons=0;
    ioctl(fd, JSIOCGBUTTONS, &nb_buttons);
    char name[128] = "Unknown";
    ioctl(fd, JSIOCGNAME(128), name);
        // we print information
    char text[200];
    STK_INFORMATION("we load joystick caracteristics");
    sprintf(text,"%s:%d",name,version);
    STK_INFORMATION(text);
    sprintf(text,"nb axes:%d",nb_axes);
    STK_INFORMATION(text);
    sprintf(text,"nb buttons:%d",nb_buttons);
    STK_INFORMATION(text);
    
        // we create buttons
    array_buttons=new int[nb_buttons];
        // we create axes
    array_axes=new Stk_Axe[nb_axes];
    present=1;
}

Stk_Joy::~Stk_Joy()
{
    if(present){
        close(fd);
    }
}

void Stk_Joy::ReadState()
{
    if (read(fd, &js, sizeof(struct js_event))==sizeof(struct js_event)){
        switch ((js.type&3)) {
            case JS_EVENT_BUTTON:
                if ( js.number < nb_buttons ) {
                        // event button
                    if(array_buttons[js.number]!=js.value){
                        Stk_Message *msg=new Stk_Message(STK_JOY_EVENT);
                        msg->AddInt("button",J_B1+js.number);
                        msg->AddInt("pressed",js.value);
                        StkPostMessage(msg);
                        array_buttons[js.number]=js.value;
                    }
                }
                
                break;
            case JS_EVENT_AXIS:
                if ( js.number < nb_axes ) {
                    float value=((float)js.value)/32768.0;
                    switch(js.number) {
                        case 0:
                                // UP ?
                            if( (array_axes[js.number].position<0.5) &&
                                (value>0.5)) {
                                  Stk_Message *msg=new Stk_Message(STK_JOY_EVENT);
                                  msg->AddInt("button",J_UP);
                                  msg->AddInt("pressed",1);
                                  StkPostMessage(msg);
                            }
                            if( (array_axes[js.number].position>0.5) &&
                                (value<0.5)) {
                                  Stk_Message *msg=new Stk_Message(STK_JOY_EVENT);
                                  msg->AddInt("button",J_UP);
                                  msg->AddInt("pressed",0);
                                  StkPostMessage(msg);
                            }
                                // DOWN ?
                            if( (array_axes[js.number].position>-0.5) &&
                                (value<-0.5)) {
                                  Stk_Message *msg=new Stk_Message(STK_JOY_EVENT);
                                  msg->AddInt("button",J_DOWN);
                                  msg->AddInt("pressed",1);
                                  StkPostMessage(msg);
                            }
                            if( (array_axes[js.number].position<-0.5) &&
                                (value>-0.5)) {
                                  Stk_Message *msg=new Stk_Message(STK_JOY_EVENT);
                                  msg->AddInt("button",J_DOWN);
                                  msg->AddInt("pressed",0);
                                  StkPostMessage(msg);
                            }
                               
                            array_axes[js.number].position=value;
                            break;
                        case 1:
                                // LEFT ?
                            if( (array_axes[js.number].position<0.5) &&
                                (value>0.5)) {
                                  Stk_Message *msg=new Stk_Message(STK_JOY_EVENT);
                                  msg->AddInt("button",J_LEFT);
                                  msg->AddInt("pressed",1);
                                  StkPostMessage(msg);
                            }
                            if( (array_axes[js.number].position>0.5) &&
                                (value<0.5)) {
                                  Stk_Message *msg=new Stk_Message(STK_JOY_EVENT);
                                  msg->AddInt("button",J_LEFT);
                                  msg->AddInt("pressed",0);
                                  StkPostMessage(msg);
                            }
                                // RIGHT ?
                            if( (array_axes[js.number].position>-0.5) &&
                                (value<-0.5)) {
                                  Stk_Message *msg=new Stk_Message(STK_JOY_EVENT);
                                  msg->AddInt("button",J_RIGHT);
                                  msg->AddInt("pressed",1);
                                  StkPostMessage(msg);
                            }
                            if( (array_axes[js.number].position<-0.5) &&
                                (value>-0.5)) {
                                  Stk_Message *msg=new Stk_Message(STK_JOY_EVENT);
                                  msg->AddInt("button",J_RIGHT);
                                  msg->AddInt("pressed",0);
                                  StkPostMessage(msg);
                            }
 
                            array_axes[js.number].position=-value;  
                            break;
                    }
                }
                break;
        }
    }
}
#endif







/* old driver version */
#ifdef LINUX_JOYSTICK_OLD
Stk_Joy::Stk_Joy(char *filename,Stk_Looper *l)
     :Stk_PassiveSender(l)	

{
    present=0;
}

void Stk_Joy::ReadState()
{
}

Stk_Joy::~Stk_Joy()
{
}
#endif


#ifndef LINUX_JOYSTICK
/* no joystick */

Stk_Joy::Stk_Joy(char *filename,Stk_Looper *l)
	:Stk_PassiveSender(l)
{
    present=0;
}

void Stk_Joy::ReadState()
{
}

Stk_Joy::~Stk_Joy()
{
}

#endif



