#include "stk_admctrl.h"
#include "stdio.h"
#include "stdlib.h"


Stk_AdmCtrl::Stk_AdmCtrl(Stk_Looper *l)
{
// we are looking for and building control list
        // keyboard ctrl
    Stk_Keyboard *keyb=new Stk_Keyboard(l);
    if(!keyb->IsPresent()){
        //delete keyb;
    }else{
        tab_ctrl.push_back(keyb);
    }
        // joystick ctrl
    Stk_Joy *joy1=new Stk_Joy(0,l);
    if(!joy1->IsPresent()){
		//delete joy1;
    }else{
        tab_ctrl.push_back(joy1);
    }
        // controler null
    Stk_Control *ctrl=new Stk_Control();
    tab_ctrl.push_back(ctrl);
    
// we are building the player list
    tab_player=new int[Stk_MAX_PLAYERS];
    nb_players=0;
}

int Stk_AdmCtrl::Ask()
{
    if(nb_players>=Stk_MAX_PLAYERS){
        printf("Nb player too important\n");
        exit(0);
    }
    nb_players++;
    tab_player[nb_players]=0;
    return nb_players;
}

void Stk_AdmCtrl::Switch(int player)
{
    tab_player[player]=(tab_player[player]+1)%(tab_ctrl.size());
}

Stk_Control *Stk_AdmCtrl::GiveControl(int player)
{
    return tab_ctrl[tab_player[player]];
}



Stk_AdmCtrl::~Stk_AdmCtrl()
{
    typedef vector<Stk_Control *>::iterator iter_Stk_control;
    for(iter_Stk_control i=tab_ctrl.begin();i!=tab_ctrl.end();i++){
        delete (*i);
    }
    delete[] tab_player;
}





