#include "sp_newgame.h"
#include "stk/stk.h"


extern int Sp_width;
extern int Sp_height;

extern Stk_AdmCtrl *admctrl;
extern int player1;


// the sound machine
extern Stk_PSound *canalsound;













Sp_NewGame::Sp_NewGame(Stk_Prog *p)
        :Stk_Prog(p)
{
 
    gest3d=new Sp_Adm("Gestionnaire 3d");
    etoiles=new Sp_Obj_stars("stars.dat",gest3d,gest3d,0);
    gest3d->Add_Obj(etoiles);
    
    Sp_Load_Planetes(gest3d,gest3d);

        //objf=new Sp_Camera("la camera du circuit",gest3d,circuit);
        //objf2=new Sp_View("la camera du gest",gest3d);
    objf3=new Sp_Car("la voiture",gest3d,gest3d,admctrl->GiveControl(player1));
    gest3d->Add_Obj(objf3);

    cam_car=new Sp_CameraCar("la camera de la voiture",gest3d,objf3);
    objf3->Add_Obj(cam_car);
    
    gest3d->Add_View(cam_car);
    gest3d->Active_View(cam_car);
                         
    circuitnew=new Sp_Obj_gl("sracer2006.gl",gest3d,gest3d,10);
    gest3d->Add_Obj(circuitnew);
    
    light0=new Light0("lumiere 1",gest3d,gest3d);
    light0->Enable();
    gest3d->Add_Obj(light0);
    gest3d->Add_Light(light0);
    
    circuitphy=new Sp_Load_CircuitC("sracer2006.gl");
    circuitphy->Print();


        // we attaches car & circuit
    objf3->PlayOnCircuit(circuitphy);
    
    
    Sp_Point dep(5,0,0.0);
    Sp_Vecteur dir(0,0,1);
    objf3->Init(circuitphy,dep,dir);
    quit=1;
    
    start=GetTime();
    last=current=start;
    font=new Stk_FontTXF("default.txf");
    font->SetSize(10);

    window=new Stk_Gui_Window(this,Stk_Gui_Rect(0,0,640,480));
    widget_static=new Stk_Gui_Static();
    window->Attach(widget_static);
        // sound
    clientsound=new Stk_CSound(canalsound);
}

void Sp_NewGame::GetFocus()
{
    clientsound->Play("orion-a_taste_of_ecstacy.mp3");
    
    glEnable(GL_TEXTURE_2D);
    glDisable(GL_LIGHTING);
    glEnable(GL_DEPTH_TEST);
//    glDisable(GL_LIGHT0);
//    glDisable(GL_LIGHT1);
}



void Sp_NewGame::MessageReceived(Stk_Message *msg)
{
    int *valeur;
        // we have interest only in keyboard clavier
    if(msg->what!=STK_KEY_EVENT)
        return;
        // we have interest in keypressed message
    msg->FindInt("pressed",valeur);
     if(*valeur==0)
        return;
    msg->FindInt("key",valeur);
    switch(*valeur){
    case STK_K_ENTER:
      quit=0;
      break;
    case STK_K_ESCAPE:
      quit=0;
      break;
    }
}





int Sp_NewGame::Loop()
{
        // On efface le color buffer
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glDisable(GL_LIGHTING);
    
    gest3d->DrawScene();

        // time print
    char text[100];
    last=current;
    current=GetTime();
    sprintf(text," %d,%d",(int)(current-start)/1000,(int)(current-start)%1000);

        // time elapsed
    Stk_Gui_Text *t1;
    t1=new Stk_Gui_Text(font,text,STK_GUI_LEFT);
    t1->Resize(Stk_Gui_Rect(0,0,640,20));
    widget_static->Attach(t1);

        // frame counter
	if(current!=last)
    sprintf(text," fps: %d",(int)(1000/(current-last)));    
    Stk_Gui_Text *t3;
    t3=new Stk_Gui_Text(font,text,STK_GUI_LEFT);
    t3->Resize(Stk_Gui_Rect(0,450,640,20));
    widget_static->Attach(t3);
    
    
        // best print
    long bestlap=circuitphy->BestLap(objf3->id_journey);
    if(bestlap<0){
        sprintf(text," best ---,--");
    } else {
        sprintf(text,"best %d,%d",(int)(bestlap)/1000,(int)(bestlap)%1000);
    }

    Stk_Gui_Text *t2;
    t2=new Stk_Gui_Text(font,text,STK_GUI_LEFT);
    t2->Resize(Stk_Gui_Rect(0,20,640,20));
    widget_static->Attach(t2);

    window->Draw();
    
    Stk_SwapBuffers();

    widget_static->Unfasten(t1);
    widget_static->Unfasten(t2);    
    widget_static->Unfasten(t3);
    delete t1;
    delete t2;
    delete t3;
    return quit;
}


Sp_NewGame::~Sp_NewGame()
{
    glDisable(GL_TEXTURE_2D);
    Sp_Delete_Planetes();
    delete window;
    delete gest3d;
    delete font;
    delete clientsound;
    clientsound=0;
}


// ------------------------
// -------- A Light -------
// ------------------------
Light0::Light0(char *name, Sp_Adm *adm, Sp_Obj *obj)
        :Sp_Light(name,adm,obj)
{
    ambient[0]= 0.1f; ambient[1]= 0.1f; ambient[2]= 0.1f; ambient[3]= 1.0f;
    diffuse[0]= 0.5f; diffuse[1]= 1.0f; diffuse[2]= 1.0f; diffuse[3]= 1.0f;
    position0[0]= -10.0f; position0[1]= 10.0f; position0[2]= 20.0f; position0[3]= 0.0f;
    front_mat_shininess[0] = 60.0f;
    front_mat_specular[0] = 0.2f;front_mat_specular[1] = 0.2f;
    front_mat_specular[2] = 0.2f;front_mat_specular[3] = 1.0f;
    front_mat_diffuse[0] =0.5f;front_mat_diffuse[1] =0.28f;
    front_mat_diffuse[2] =0.38f;front_mat_diffuse[3] =1.0f;
    lmodel_ambient[0]=1.0f;lmodel_ambient[1]=1.0f;
    lmodel_ambient[2]=1.0f;
    lmodel_twoside[0] = GL_FALSE;
    
    glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
    glLightfv(GL_LIGHT0, GL_POSITION, position0);
    glEnable(GL_LIGHT0);

    glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);
    glLightModelfv(GL_LIGHT_MODEL_TWO_SIDE, lmodel_twoside);
    glEnable(GL_LIGHTING);
  
    glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, front_mat_shininess);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, front_mat_specular);
    glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, front_mat_diffuse);

        // pas de transformation
    Sp_Trans *tr;
    tr=new Sp_Trans(adm);
    tr->Id();
    trans.Add_Trans(tr);

}

void Light0::Light()
{
    Sp_Point pos=GetProjection()*Sp_Point(0,0,0,0);
    position0[0]=pos.x; position0[1]=pos.y;
    position0[2]=pos.z; position0[3]=1;
    glLightfv(GL_LIGHT0, GL_POSITION, position0);
    float direction[4];
    direction[0]=1; direction[1]=0; direction[2]=0;
    glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION,direction);
    
}
