#include "../stk/stk.h"
#include "sp_circuit.h"
#include "../util/sp_debug.h"




// ************************************************************
// ********************* MBox *********************************
// ************************************************************
Sp_MBox::Sp_MBox(int nb_step)
{
    nbstep=nb_step;
}

Sp_MBox::Sp_MBox(float xmi,float xma,float ymi,float yma,float zmi,float zma,int nb_step)
        :Sp_Box(xmi,xma,ymi,yma,zmi,zma)
{
    nbstep=nb_step;
}

Sp_MBox::Sp_MBox(const Sp_Box &b,int nb_step)
        :Sp_Box(b)
{
    nbstep=nb_step;
}

void Sp_MBox::Set(const Sp_Box &b,int nb)
{
    nbstep=nb;
    Pmin=b.Pmin;
    Pmax=b.Pmax;
}


int Sp_MBox::MinI(const Sp_Box &b)
{
    int i=(int)((b.Pmin.x-Pmin.x)*nbstep/WidthX());
    if(i<0)
        return 0;
    if(i>=nbstep)
        return nbstep;
    return i;
}

int Sp_MBox::MaxI(const Sp_Box &b)
{
    int i=(int)((Pmax.x-b.Pmax.x)*nbstep/WidthX());
    if(i<0)
        return 0;
    if(i>=nbstep)
        return nbstep;
    return i;
}

int Sp_MBox::MinJ(const Sp_Box &b)
{
    int j=(int)((b.Pmin.y-Pmin.y)*nbstep/WidthY());
    if(j<0)
        return 0;
    if(j>=nbstep)
        return nbstep;
    return j;
}

int Sp_MBox::MaxJ(const Sp_Box &b)
{
    int j=(int)((Pmax.y-b.Pmax.y)*nbstep/WidthY());
    if(j<0)
        return 0;
    if(j>=nbstep)
        return nbstep;
    return j;
}

int Sp_MBox::MinK(const Sp_Box &b)
{
    int k=(int)((b.Pmin.z-Pmin.z)*nbstep/WidthZ());
    if(k<0)
        return 0;
    if(k>=nbstep)
        return  nbstep;
    return k;
}

int Sp_MBox::MaxK(const Sp_Box &b)
{
    int k=(int)((Pmax.z-b.Pmax.z)*nbstep/WidthZ());
    if(k<0)
        return 0;
    if(k>=nbstep)
        return  nbstep;
    return k;
}




// *************************************************************
// ****************** the OctoTree  ****************************
// *************************************************************

template <class T>
OctoTree<T>::OctoTree(Sp_Box &b,int preci): box(b)
{
  precision=preci;
  tab=new list<T>[(preci+1)*(preci+1)*(preci+1)];
}

template <class T>
OctoTree<T>::OctoTree()
{
}

template <class T>
void OctoTree<T>::Init(const Sp_Box &b,int preci)
{
  box=b;
  precision=preci;
  tab=new list<T>[(preci+1)*(preci+1)*(preci+1)];
}


template <class T>
void OctoTree<T>::FindCoord(const Sp_Point &p,int &x,int &y,int &z) const
{
  float kx=((p.x-box.Pmin.x)*(float)precision)/(box.Pmax.x - box.Pmin.x);
  x=(int)kx;
  float ky=((p.y-box.Pmin.y)*precision)/(box.Pmax.y - box.Pmin.y);
  y=(int)ky;
  float kz=((p.z-box.Pmin.z)*precision)/(box.Pmax.z - box.Pmin.z);
  z=(int)kz;
}

template <class T>
void OctoTree<T>::Insert(const T &element,const Sp_Box &b)
{
        // first we determine the sub boxes which contain this element
    int x1,y1,z1;
    FindCoord(b.Pmin,x1,y1,z1);
    int x2,y2,z2;
    FindCoord(b.Pmax,x2,y2,z2);
  // insert the element
    int x,y,z;
    for(x=x1;x<=x2;x++)
    {
        for(y=y1;y<=y2;y++)
        {
            for(z=z1;z<=z2;z++)
            {
                tab[( ((z*precision)+y) *precision)+x].push_back(element);
            }
        }
    }
}




template<class T>
void OctoTree<T>::FindList(list<T> &l,const Sp_Point &p)
{
    int x,y,z;
    FindCoord(p,x,y,z);
    l=tab[( ((z*precision)+y) *precision)+x];
}


template<class T>
void OctoTree<T>::Add_Liste(list<T> &l,list<T> &l2)
{
    typedef list<T>::iterator iter;
    for(iter i=l2.begin();i!=l2.end();i++){
            l.push_back(*i);
    }
}



template<class T>
void OctoTree<T>::FindList(list<T> &l,const Sp_Box &b)
{
    int x1,x2,y1,y2,z1,z2;
    FindCoord(b.Pmin,x1,y1,z1);
    FindCoord(b.Pmax,x2,y2,z2);
    int x,y,z;
    for(x=x1;x<=x2;x++){
        for(y=y1;y<=y2;y++){
            for(z=z1;z<=z2;z++){
                Add_Liste(l,tab[( ((z*precision)+y) *precision)+x]);
            }
        }
    }
}

template<class T>
void OctoTree<T>::FindList(list<T> &l,const Sp_Sphere &s)
{
        // not the best solution !!!
        // We Transform the sphere into a box
    Sp_Box b(s.xo-s.r,s.xo+s.r,s.yo-s.r,s.yo+s.r,s.zo-s.r,s.zo+s.r);
    FindList(l,b);
}


/* ***************************************************************
***************************** Tree World *************************
*************************************************************** */
// nb max of elements
const int density_max = 100;
// depth max of tree
const int depth_max = 4;
// granularity of cube



/* We build an empty tree */
//template <class T>
Sp_Tree::Sp_Tree(Sp_Box &b,int granu,int dp)
        :Sp_MBox(b,granu)
{
        // It is by defalut a node
    depth=dp;
    node=1;
}

//template<class T>
Sp_Tree::Sp_Tree()
        :Sp_MBox()
{
    node=1;
}

//template<class T>
void Sp_Tree::Init(const Sp_Box &b,int granu,int dp)
{
    Set(b,granu);
    depth=dp;
    node=1;
}


//template <class T>
void Sp_Tree::Insert(Sp_FaceC *el,const Sp_Box &b)
{
    int i,j,k;
        // It is a node
    if(node==1){
        if( ((int)elements.size()<density_max)||(depth>=depth_max) ){
            elements.push_back(el);
        } else {
                // density is too high: we create new trees
            printf("dp %d contient %d \n",depth,elements.size());
            elements.push_back(el);
            CreateDepth();
            printf("dp %d contient %d apres\n",depth,elements.size());
        }
    }
    if(node==0){
        printf("indirection\n");
            // It is a branch
        for(i=MinI(b);i<MaxI(b);i++){
            for(j=MinJ(b);j<MaxJ(b);j++){
                for(k=MinK(b);k<MaxK(b);k++){
                    b.Print();
                    printf("i:%d ",i);
                    printf("j:%d ",j);
                    printf("k:%d\n",k);
                    indirection[(k*nbstep+j)*nbstep+i].Insert(el,b);
                }   
            }   
        }
    }
}

//template <class T>
void Sp_Tree::CreateDepth()
{
    int i,j,k;
    float dx=WidthX()/((float)nbstep);
    float dy=WidthY()/((float)nbstep);
    float dz=WidthZ()/((float)nbstep);
    printf("dx %f dy %f dz %f\n",dx,dy,dz);
    SP_ERROR( (dx==0)|| (dy==0) || (dz==0), "PB GRAVE\n");
    node=0;
    indirection=new Sp_Tree[nbstep*nbstep*nbstep];
    float z=Pmin.z;
        // we create the next step
    for(k=0;k<nbstep;k++){
        float y=Pmin.y;
        for(j=0;j<nbstep;j++){
            float x=Pmin.x;
            for(i=0;i<nbstep;i++){
                Sp_Box b(x,x+dx,y,y+dy,z,z+dz);
                indirection[(k*nbstep+j)*nbstep+i].Init(b,nbstep,depth+1);
                x+=dx;
            }
            y+=dy;
        }
        z+=dz;
    }
        // and we insert faces
    typedef list<Sp_FaceC *>::iterator iter;
/*
    for(iter i1=elements.begin();i1!=elements.end();i1++){
        Sp_Box b((*i1)->box);
        for(i=MinI(b);i<MaxI(b);i++){        //printf("i:%d\n ",i);
            for(j=MinJ(b);j<MaxJ(b);j++){// printf("j:%d\n ",j);
                for(k=MinK(b);k<MaxK(b);k++){//printf("k:%d\n",k);
                    indirection[(k*nbstep+j)*nbstep+i].elements.push_back(*i1);
                }   
            }   
        }
    }
*/
    elements.clear();
}








//template<class T>
void Sp_Tree::FindList(list<Sp_FaceC *> &l,const Sp_Point &p)
{
/*    int x,y,z;
    FindCoord(p,x,y,z);
    l=tab[( ((z*precision)+y) *precision)+x];*/
}


//template<class T>
void Sp_Tree::Add_Liste(list<Sp_FaceC *> &l,list<Sp_FaceC *> &l2)
{
/*    typedef list<T>::iterator iter;
    for(iter i=l2.begin();i!=l2.end();i++){
            l.push_back(*i);
            }*/
}



//template<class T>
void Sp_Tree::FindList(list<Sp_FaceC *> &l,const Sp_Box &b)
{
/*    int x1,x2,y1,y2,z1,z2;
    FindCoord(b.Pmin,x1,y1,z1);
    FindCoord(b.Pmax,x2,y2,z2);
    int x,y,z;
    for(x=x1;x<=x2;x++){
        for(y=y1;y<=y2;y++){
            for(z=z1;z<=z2;z++){
                Add_Liste(l,tab[( ((z*precision)+y) *precision)+x]);
            }
        }
        }*/
}

//template<class T>
void Sp_Tree::FindList(list<Sp_FaceC *> &l,const Sp_Sphere &s)
{
/*        // not the best solution !!!
        // We Transform the sphere into a box
    Sp_Box b(s.xo-s.r,s.xo+s.r,s.yo-s.r,s.yo+s.r,s.zo-s.r,s.zo+s.r);
    FindList(l,b);*/
}








/* *************************************************************
*********** helpfull class ************************************ */

Sp_PointOnFace::Sp_PointOnFace()
{}

Sp_PointOnFace::Sp_PointOnFace(const Sp_Point &p1,Sp_FaceC *f1)
        :p(p1)
{
    face=f1;
}










/* *****************************************************************
****************  A CIRCUIT ****************************************
****************************************************************** */
Sp_CircuitC::Sp_CircuitC()
        :Sp_Journey()
{
    size_min=1e10;
    size_average=0;
    size_max=0;
}

void Sp_CircuitC::Add_Face(Sp_FaceC *face)
{
    list_faces.push_back(face);
}



void Sp_CircuitC::PreCompute()
{
    typedef vector<Sp_FaceC *>::iterator iter;
        // i am searching the size of box which contain circuit
        //printf("nb de sp faces %d \n",list_faces.size());
    iter ifa=list_faces.begin();
    Sp_Box b((*ifa)->box);
    for(;ifa!=list_faces.end();ifa++)
    {
        b.Add_Box((*ifa)->box);
    }
    b.Print();
    octotree_faces.Init(b,20);
        // we add the face into the octree
    for(ifa=list_faces.begin();ifa!=list_faces.end();ifa++){
        Sp_Box &b=(*ifa)->box;
        if(b.Width()<size_min){
            size_min=b.Width();
        }
        if(b.Width()>size_max){
            size_max=b.Width();
        }
        size_average+=b.Width();
            //(*ifa)->Print2();
        octotree_faces.Insert(*ifa,b);
    }
}





int Sp_CircuitC::FindLocation(list<Sp_PointOnFace> &l,const Sp_Sphere &s,const Sp_Plan &p)
{
        // first we find the list of faces which intersect the sphere
    list<Sp_FaceC *>  l1;
    FindList(l1,s);
    typedef list<Sp_FaceC *>::iterator iter;

        //printf("Intersection d'une  droite et de cette sphere\n");
        //s.Print();
    
        // we try all the face we have found
    for(iter i=l1.begin();i!=l1.end();i++){
            // we compute the straight line
        Intersection I(p,(*i)->Plan(),(*i)->Center());
        if(I.liste_droites.size()==0)
            continue;
        Sp_Droite d=*I.liste_droites.begin();
        d.v.Norme();
            // the intersection between the straight line and sphere
        Intersection I2(d,s);
            
            // printf("droite:\n");
            //d.Print();
        
        
        

            // printf("points trouves:%d\n",I2.liste_points.size());
            // we have found 0 or 2 points
        typedef list<Sp_Point>::iterator iter2;
        for(iter2 j=I2.liste_points.begin();j!=I2.liste_points.end();j++){
            if( (*i)->IsIn(*j,(*i)->Normale()) ){
                    //(*j).Print();
                    // this point is in, so we add in l
                Sp_PointOnFace pt;
                pt.p=*j;
                pt.face=*i;
                l.push_back(pt);
                    //printf("yahoo\n");
            }
        }
    }
    if(l.size()==0){
        return 0;
    }
    return 1;
}


/* Essential function:
   We have a point P on the circuit which is situated on face f with coordinates c.
   And we have a displacement vector V. This functions return the new coordinates  
   on the circuit.
 */
int Sp_CircuitC::FindLocationOn(Sp_PointOnFace &P,const Sp_Vecteur &displacement,
                                Sp_PointOnFace &init)
{
        // if no displacement we don't move !!!
    if(displacement.Compute_norme()==0){
        P=init;
        return 1;
    }
    
        // Project the direction vector
    float distance_to_do=displacement.Compute_norme();
    Sp_Vecteur direction(displacement);
    direction=init.face->Project(direction);
    direction.Norme();
    direction=direction*distance_to_do;
    
        //printf("b1\n");
    
    
        // Compute Next Point
    Sp_Point P1;
    P1=init.p+direction;
    
        // We are testing if the face on which we are contain the current point 
    SP_ERROR((init.face->IsIn(init.p,init.face->Normale())==0),
        "heavy problem... we don't know where is the car. So we replace it on the last face\n");

        //printf("b2\n");
    
        // Is P1 on the same face as O
    if(init.face->IsIn(P1,init.face->Normale())!=0){
        P.p=P1;
        P.face=init.face;
        return 1;
    }

        //printf("b3\n");
     
        // We are changing face... So we compute the point where we quit the current face
    Sp_Point intersection(0,0,0);
    Sp_Segment seg(init.p,P1);
    if(!init.face->FindIntersection(seg,intersection)){
        printf("la c est sur y a comme un pb\n");
        exit(0);
    }
    
        //printf("b4\n");
    
        // we are searching the next face
    typedef list<Sp_FaceC *>::iterator iter;
    list<Sp_FaceC *> list_faces2;
    Sp_FaceC *new_face=0;

        // attention magouille !!!
    #define SP_MAGIC_ERROR 0.1
    #define SP_BCL_ERROR 4

    int found=0;
    int i=0;
    while((!found)&&(i<SP_BCL_ERROR)){
            // we go to the point to find the next face
        intersection=intersection+direction*SP_MAGIC_ERROR;
            // search the face with octotree
        FindList(list_faces2,P1);
        for(iter ifa=list_faces2.begin();ifa!=list_faces2.end();ifa++){
                // is intersection in this face
            if((*ifa)->IsIn(P1/*intersection*/,init.face->Normale())/*&&(init.face!=*ifa)*/){
                    // the point is in !!!
                new_face=*ifa;
                found=1;
                break;
            }
        }
        i++;
    } 
    
        // We are computing the next position     
    if(found){
        P1=new_face->Project(P1,init.face->Normale());
        Sp_PointOnFace Init2;
            //intersection=new_face->Project(intersection);
        direction=new_face->Project(direction);
        Init2.face=new_face;
        Init2.p=intersection;
        P.face=new_face;
        P.p=P1/*intersection*/;

        SP_ERROR((P.face->IsIn(P.p,init.face->Normale())==0),
                 "ERROR:heavy problem ... we don't know where is the car. So we replace it on the last face\n");

        
        return 1;
            // we are computing the distance to do 
        float distance_todo;
        float distance_done=(init.p-intersection).Compute_norme();

        distance_todo=displacement.Compute_norme()+distance_done;
        if(distance_todo<0){
                //printf("b6\n");
            return 1;
        }
        
        direction=P.face->Project(direction);
        direction.Norme();
            //FindLocationOn(P,direction,distance_todo,Init2);
            //printf("b5\n");
        return 1;
    } else {
        printf("face non trouvee !\n");
        return 0;
    } 
}





void Sp_CircuitC::FindList(list<Sp_FaceC *> &l,const Sp_Point &p)
{
    octotree_faces.FindList(l,p);
}


void Sp_CircuitC::FindList(list<Sp_FaceC *> &l,const Sp_Box &b)
{
    octotree_faces.FindList(l,b);
}

void Sp_CircuitC::FindList(list<Sp_FaceC *> &l,const Sp_Sphere &s)
{
    octotree_faces.FindList(l,s);
}

void Sp_CircuitC::Print() const
{
    printf("size min of face:%f\n",size_min);
    printf("size max of face:%f\n",size_max);
    printf("size average of face:%f\n",size_average/list_faces.size());
    
}





/* *******************************************
*****************  A  FACE  ******************
******************************************* */
Sp_FaceC::Sp_FaceC(float *p1,float *p2,float *p3)
        :Po1(p1[0],p1[1],p1[2]),Po2(p2[0],p2[1],p2[2]),
         Po3(p3[0],p3[1],p3[2])
{
    P1=p1; P2=p2; P3=p3;
    
        // we are building the box
    Sp_Box tmpbox(Po1);
    tmpbox.Add_Point(Po2);
    tmpbox.Add_Point(Po3);
    box=tmpbox;

        // compute intern variables
    ReCompute();
    checkpoint=0;
}



void Sp_FaceC::ReCompute()
{
        // we give to the Poi the news values
    Po1.x=P1[0]; Po1.y=P1[1]; Po1.z=P1[2];
    Po2.x=P2[0]; Po2.y=P2[1]; Po2.z=P2[2];
    Po3.x=P3[0]; Po3.y=P3[1]; Po3.z=P3[2];
        // we recompute segment
    seg[0]=Sp_Segment(Po1,Po2);
    seg[1]=Sp_Segment(Po2,Po3);
    seg[2]=Sp_Segment(Po3,Po1);
        // we recompute center, normale and plan
    Calc_Normale();
    Calc_Center();
    Calc_Plan();
}





int Sp_FaceC::IsIn(const Sp_Point &p,const Sp_Vecteur &direction) const
{
    int i;
    Sp_Point P=Center();
    for(i=0;i<3;i++)
    {
        if(seg[i].SameSide(P,p,direction)<0){            
            return 0;
        }
        
    }
    return 1;
}




Sp_Point Sp_FaceC::Project(const Sp_Point &p,const Sp_Vecteur &direction) const
{
    return plan.Project(p,direction);
}



Sp_Vecteur Sp_FaceC::Project(const Sp_Vecteur &v1) const
{
    return plan.Project(v1);
}



int Sp_FaceC::FindIntersection(const Sp_Segment &segment,Sp_Point &P) const
{
    int i;
    for(i=0;i<3;i++){
        if(seg[i].intersection(segment,Normale(),P)){
            return 1;
        }
    }
        // An assert test
    if( (!IsIn(*(segment.p1),Normale())) || (!IsIn(*(segment.p2),Normale())) ){
        printf(" il devrait y avoir une intersection !\n");
        exit(0);
    }
    return 0;
    
}





void Sp_FaceC::Print() const
{
        // les segments
    printf("A Sp_FaceC\n");   
    Po1.Print();
    Po2.Print();
    Po3.Print();
}


/* Intern functions to compute intern variable */
void Sp_FaceC::Calc_Normale()
{
  Sp_Vecteur u,v;  
  u=Po2-Po1;
  v=Po3-Po1;
  norm=u^v;
  SP_ERROR(norm.IsNull(),"a face can not have a null normal");
}


void Sp_FaceC::Calc_Center()
{    
    SP_ERROR( (Po1==Po2) && (Po2==Po3),
        "impossible: on a une face reduite a un point !!!\n");
    Sp_Point result;
    result.x=Po1.x+Po2.x+Po3.x;
    result.y=Po1.y+Po2.y+Po3.y;
    result.z=Po1.z+Po2.z+Po3.z;
    result.x/=3; result.y/=3; result.z/=3;
    center=result;
}

/* Warning this function must be called next Calc_Center and Calc_Norm */
void Sp_FaceC::Calc_Plan()
{
    plan=Sp_Plan(center,norm);
}


void Sp_FaceC::AttachToCheckPoint(Sp_CheckPoint *ch)
{
    checkpoint=ch;
}


void Sp_FaceC::Touch(int player, long time)
{
    if(checkpoint!=0){
        checkpoint->On(player,time);
    }
}
