#ifndef __SP_FACE_H
#define __SP_FACE_H


class Sp_EntityBase;
class Sp_GEntityBase;

#include "sp_obj.h"
#include "sp_box.h"


/* ------------------------------------------------------ */
/* ------------------ Sp_Entity ------------------------- */
/* ------------------------------------------------------ */
/** This class is used to stock datas usefull GEntity ( the drawing
 entity ) */
class Sp_EntityBase
{
public:
// functions members
        /// the constructor
    Sp_EntityBase(Sp_Obj *);
        /// its destructor
    virtual ~Sp_EntityBase();

        /// Add a graphic entity
    virtual void Add_GEntity(Sp_GEntityBase *);
        /// Rem a graphic entity
    virtual void Rem_GEntity(Sp_GEntityBase *);
        /// This function is used by Sp_Obj and call Draw
    void DrawEntity();
        /// The master Sp_Obj
    Sp_Obj *obj;
        /// list of graphical entities
    list<Sp_GEntityBase *> gentities;
protected:
    /* ------- data Members --------- */
        /// Bounding Box
    Sp_Box bounding_box;
        /// Is bounding box working ?
    char IsBounding;


protected:
        /// virtual function: draw it. Don't call it. Overload it only!
    virtual void Draw() {};

};


/* --------------------------------------------------------- */
/* -------------------- Sp_EntityLOD ----------------------- */
/* --------------------------------------------------------- */
/** This class is a special version of Sp_EntityBase written to
    manage Level of Detail. The Entity has different images of
    the same object. It must have a bounding box. */
class Sp_EntityLOD: public Sp_EntityBase
{
public:
// functions members
        /// The constructor
    Sp_EntityLOD(Sp_Obj *);
private:
        /// Choose a Gentity to draw
    virtual void Choose(const Sp_Point &viewpoint);
    
};




/* ------------------------------------------------------ */
/* ------------------ Sp_GEntity ------------------------ */
/* ------------------------------------------------------ */
/** This class represents the drawable part of object
 */
class Sp_GEntityBase
{
public:
// Functions members

        /// constructor
    Sp_GEntityBase(Sp_EntityBase *);
        /// This function is used by Sp_Entity and call Draw
    void DrawGEntity();


/* ------- data Members --------- */
        /// Bounding Box
    Sp_Box bounding_box;
        /// Is bounding box working ?
    char IsBounding;

        /// the Entity master
    Sp_EntityBase *entity;
protected:
        /// virtual function: draw it. Don't call it. Overload it only!
    virtual void Draw() {};

};




#endif
