#ifndef __SP_BOX_H
#define __SP_BOX_H

#include "../math/sp_matrice.h"

/** A box: It is deliminited by two points */
class Sp_Box
{
  public:
        /// default constructor
    Sp_Box() {};
        /// A box wich is a point too
    Sp_Box(const Sp_Point &);
        /// the classic constructor
    Sp_Box(float xmi,float xma,float ymi,float yma,float zmi,float zma);
        /// the copy constructor
    Sp_Box(const Sp_Box &b);
        /// is this point in the box ?
    int IsIn(const Sp_Point &) const;
        /// is this box in the box ?
    int IsIn(const Sp_Box &) const;
        /// Is there any intersection between this two box ?
    int IsIntersection(const Sp_Box &) const;
        /// Is this box visible ?
    int IsVisible(const Sp_Mat4 &) const;
        /// Transform the box to contain this point
    void Add_Point(const Sp_Point &);
        /// Transform the box to contain this box too
    void Add_Box(const Sp_Box &);
        /// Print information about this box
    void Print() const;
        /// width X
    float WidthX() const;
        /// width Y
    float WidthY() const;
        /// width Z
    float WidthZ() const ;
        /// Distance between Pmin & Pmax
    float Width() const;
        /// Center of Box
    Sp_Point Center() const;
    
    
        // limits of the box
        /// Pmin
    Sp_Point Pmin;
        /// Pmax
    Sp_Point Pmax;
};




#endif
