#define HAVE_CONFIG_H
#define HAVE_ZLIB_H
#define HAVE_PNG_H

#ifdef HAVE_CONFIG_H
//#include <config.h>
#endif

#ifdef HAVE_ZLIB_H
#include <zlib.h>
#endif

#ifdef HAVE_PNG_H
#include <png.h>
#endif

#include "PNGImage.h"
#include  <stdlib.h>

PNGImage::PNGImage(char *filename)
{
  //FIXME     This is just cut&paste from the libpng-readme
  //          so. should do a more sophisticated implementation 
#ifdef HAVE_PNG_H
  FILE *fp = fopen(filename, "rb");
  if (!fp)
    {
      perror("PNGImage::PNGImage: error opening file:");
      return;
    }
  
  png_structp png_ptr = png_create_read_struct
    (PNG_LIBPNG_VER_STRING, (png_voidp)NULL,
     NULL, NULL);
  if (!png_ptr)
    return;

  png_infop info_ptr = png_create_info_struct(png_ptr);
  if (!info_ptr)
    {
      png_destroy_read_struct(&png_ptr,
			      (png_infopp)NULL, (png_infopp)NULL);
      return;
    }

  png_infop end_info = png_create_info_struct(png_ptr);
  if (!end_info)
    {
      png_destroy_read_struct(&png_ptr, &info_ptr,
			      (png_infopp)NULL);
      return;
    }

  
  png_init_io(png_ptr, fp);
    
  png_read_info(png_ptr, info_ptr);

  i_width=png_get_image_width(png_ptr,info_ptr);
  i_height=png_get_image_height(png_ptr,info_ptr);
  switch(png_get_channels(png_ptr,info_ptr)){
  case 3:
    i_format=FORM_RGB;
    break;
  case 4:
    i_format=FORM_RGBA;
    break;
  default:
    fprintf(stderr,"PNGImage::PNGImage warning, unsupported channel-type\n");
  }
  png_bytep *row_pointers=new png_bytep[i_height];
  
  for (int row = 0; row < i_height; row++)
    {
      row_pointers[row] = new png_byte[png_get_rowbytes(png_ptr, info_ptr)];
    }
  png_read_image(png_ptr, row_pointers);
  png_read_end(png_ptr, info_ptr);

  int bytes_per_line=png_get_rowbytes(png_ptr,info_ptr);

  png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
  fclose(fp);

  cp_data=new unsigned char[bytes_per_line*i_height];
  long adr=0;
  for(int i=0;i<i_height;i++){
    memcpy(&cp_data[adr],row_pointers[i],bytes_per_line);
    adr+=bytes_per_line;
  }
    for (int row2 = 0; row2 < i_height; row2++)
    {
        delete[] row_pointers[row2];
    }

    free(end_info);
    
        //png_destroy_read_struct(&png_ptr, &end_info,
        //                  (png_infopp)NULL);
    
#endif
}



