#include  "ImageFormat.h"

#include <stdio.h>

void
ImageFormat::convert(int form)
{
  
  if(form==i_format)return;
  switch(form){
  case FORM_RGBA:
    if(i_format==FORM_RGB){
      unsigned char *data=new unsigned char[i_width*i_height*4];
      long lcount=0,rcount=0;
      for(int y=0;y<i_height;y++)
	for(int x=0;x<i_width;x++){
	  data[lcount++]=cp_data[rcount++];
	  data[lcount++]=cp_data[rcount++];
	  data[lcount++]=cp_data[rcount++];
	  data[lcount++]=255;
	}
      delete[] cp_data;
      cp_data=data;
      i_format=FORM_RGBA;
    }
    break;
  case FORM_RGB:
    unsigned char *data=new unsigned char[i_width*i_height*3];
    long lcount=0,rcount=0;
    if(i_format==FORM_RGBA){
      for(int y=0;y<i_height;y++)
	for(int x=0;x<i_width;x++){
	  data[lcount++]=cp_data[rcount++];
	  data[lcount++]=cp_data[rcount++];
	  data[lcount++]=cp_data[rcount++];
	  rcount++;
	}
      delete[] cp_data;
      cp_data=data;
      i_format=FORM_RGB;
    }
    break;
  }

}




	  
void
ImageFormat::write(char *filename)
{
  FILE *f=fopen(filename,"w");
  fprintf(f,"P6\n%d %d \n255\n",i_width,i_height);
  fwrite(cp_data,i_width*i_height*3,1,f);
  fclose(f);
}
  

	  
	  
