
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ImageBuffer.h"
#include "ImageFormats.h"

#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#include "../stk/stk.h"

ImageBuffer::ImageBuffer(char *filename)
{
  char *tmpfilename;
  // do some filetype-magic

  


  if(filename)
   {
     if ((tmpfilename=(char *)malloc(strlen(filename)+strlen(DATADIR)+2))==NULL)
      {
	printf("Not enought memory\n");
	return;
      }
     sprintf(tmpfilename,"%s/%s",DATADIR,filename);

     // first filename matching
#ifdef HAVE_PNG_H    
     if(strstr(filename,".png"))
      {
	image=new PNGImage(tmpfilename);
      }
     else 
#endif
       if(strstr(filename,".ppm"))
	{
	  image=new PPMImage(tmpfilename);
	}
       else
	 image=NULL;
       //more to follow

     free(tmpfilename);
   }
}
