\ spectr.fs -- spectr.cl --> spectr.fs -*- snd-forth -*-


\ Translator: Michael Scholz <mi-scholz@users.sourceforge.net>
\ Created: Thu Nov 18 15:26:46 CET 2004
\ Changed: Thu Nov 23 23:29:51 CET 2006

\ Commentary:

\ Original comment in spectr.cl:
\ 
\ "Spectra courtesy J.A. Moorer
\
\ "I removed phase information, since the psychoacousticians tell us
\ that these normally don't matter.  Also, I omitted any partials with
\ amplitude below 0.0001, although this may have thrown away good
\ data, because the original data was not normalized in any way."

\ contents:
\ 
\ bass clarinet (bc)
\ bassoon       (bsn)
\ cello         (c)
\ clarinet      (cl)
\ french horn   (fh)
\               (fhf)
\ flute         (fl)
\ oboe          (ob)
\ piano         (p)
\ saxophone     (sax)
\ soprano sax   (ssax)
\               (tbf)
\               (tbp)
\ trumpet       (trp)
\               (trpf)
\ violin        (vl)
\               (almf)

\ **********************************************************
\ bass clarinet
\ **********************************************************

'( 1.00 0.0370 1.98 0.0037 2.99 0.0862 3.98 0.0011 4.97 0.0270
   5.98 0.0030 6.97 0.0586 7.95 0.0031 8.96 0.0363 9.95 0.0076
   10.93 0.0310 11.95 0.0097 12.93 0.0206 13.92 0.0045 14.93 0.0044
   15.91 0.0021 16.90 0.0220 17.91 0.0082 18.90 0.0227 19.88 0.0049
   20.90 0.0090 21.87 0.0004 22.87 0.0051 23.88 0.0010 24.86 0.0072
   25.85 0.0026 26.86 0.0044 27.84 0.0035 28.85 0.0031 29.84 0.0025
   30.83 0.0042 31.84 0.0024 32.83 0.0022 33.81 0.0021 34.82 0.0011
   35.81 0.0008 36.79 0.0013 37.80 0.0024 38.78 0.0028 39.78 0.0016
   40.79 0.0024 41.77 0.0005 42.76 0.0005 43.77 0.0003 44.76 0.0002
   45.74 0.0005 46.75 0.0003 47.74 0.0006 48.73 0.0003 49.74 0.0009
   50.72 0.0002 51.71 0.0007 52.72 0.0004 53.70 0.0005 54.70 0.0004
   55.71 0.0005 56.69 0.0002 57.68 0.0003 58.69 0.0002 59.68 0.0002
   60.68 0.0003 61.68 0.0002 62.66 0.0002 63.66 0.0002 65.65 0.0001
   67.64 0.0002 69.63 0.0002 70.63 0.0002 71.60 0.0002 72.62 0.0002
   73.60 0.0002 75.59 0.0002 76.59 0.0002 77.58 0.0001 78.59 0.0001
   79.57 0.0002 80.57 0.0002 81.57 0.0002 82.54 0.0001 83.56 0.0002
   84.54 0.0001 85.53 0.0001 87.53 0.0002 89.53 0.0002 ) constant bc-c2

'( 1.02 0.0306 2.00 0.0016 2.99 0.0926 4.00 0.0027 5.01 0.0305
   5.99 0.0006 6.99 0.0158 8.00 0.0025 9.01 0.0072 10.01 0.0057
   10.99 0.0203 12.00 0.0078 13.01 0.0147 14.02 0.0036 15.00 0.0103
   16.07 0.0007 17.01 0.0070 18.01 0.0053 19.00 0.0049 20.02 0.0027
   21.01 0.0024 22.01 0.0014 23.00 0.0011 24.02 0.0023 25.00 0.0031
   26.01 0.0021 27.00 0.0029 28.02 0.0010 29.02 0.0026 30.04 0.0011
   31.00 0.0019 32.01 0.0010 33.03 0.0004 34.02 0.0002 36.02 0.0004
   37.05 0.0002 38.04 0.0004 39.00 0.0003 40.02 0.0002 41.01 0.0002
   42.01 0.0002 43.00 0.0001 44.02 0.0001 45.01 0.0002 47.01 0.0002
   48.03 0.0001 49.00 0.0002 50.03 0.0001 51.02 0.0001 55.00 0.0001
   56.99 0.0002 73.98 0.0001 75.02 0.0001 75.98 0.0001 ) constant bc-cs2

'( 1.01 0.1419 1.97 0.0009 3.00 0.0865 4.01 0.0008 5.00 0.0059
   6.00 0.0009 7.00 0.0110 8.00 0.0014 9.00 0.0050 10.00 0.0057
   11.01 0.0267 12.01 0.0091 13.00 0.0238 14.02 0.0023 15.01 0.0069
   16.01 0.0033 17.00 0.0064 18.01 0.0036 18.99 0.0067 20.01 0.0026
   21.01 0.0047 22.01 0.0037 22.99 0.0040 24.00 0.0038 25.01 0.0036
   26.01 0.0032 27.00 0.0036 27.99 0.0019 29.00 0.0034 30.00 0.0014
   31.00 0.0007 31.98 0.0003 33.04 0.0002 34.05 0.0003 35.04 0.0003
   35.95 0.0002 37.05 0.0003 37.98 0.0002 39.07 0.0002 40.02 0.0002
   40.95 0.0001 42.01 0.0003 42.98 0.0002 44.02 0.0004 44.99 0.0002
   46.03 0.0002 46.98 0.0002 48.04 0.0001 49.01 0.0001 51.02 0.0002
   52.03 0.0002 53.01 0.0002 54.01 0.0001 55.01 0.0002 56.02 0.0001
   65.00 0.0002 66.99 0.0001 69.01 0.0001 71.00 0.0002 73.00 0.0001
   74.99 0.0001 ) constant bc-d2

'( 1.01 0.2718 2.01 0.0016 3.01 0.0476 4.01 0.0022 5.01 0.0228
   6.00 0.0005 7.01 0.0466 8.01 0.0014 9.00 0.0179 10.01 0.0059
   11.00 0.0254 12.01 0.0099 13.00 0.0176 14.01 0.0031 15.02 0.0109
   16.00 0.0007 17.02 0.0090 18.03 0.0038 19.02 0.0036 20.02 0.0029
   21.02 0.0045 22.02 0.0026 23.02 0.0060 24.02 0.0031 25.02 0.0023
   26.02 0.0033 27.02 0.0041 28.02 0.0033 29.02 0.0034 30.03 0.0007
   31.04 0.0005 32.03 0.0005 33.05 0.0005 34.03 0.0006 35.05 0.0002
   36.04 0.0004 37.03 0.0002 38.03 0.0003 39.03 0.0004 40.03 0.0002
   41.03 0.0004 42.03 0.0003 43.03 0.0006 44.04 0.0002 45.05 0.0005
   46.04 0.0001 47.05 0.0003 48.04 0.0002 49.05 0.0003 50.04 0.0001
   51.04 0.0003 52.04 0.0002 53.04 0.0001 55.04 0.0002 57.05 0.0002
   59.06 0.0002 61.07 0.0002 62.06 0.0001 63.06 0.0002 64.05 0.0001
   65.06 0.0001 66.06 0.0002 67.06 0.0002 68.06 0.0002 70.06 0.0002
   72.06 0.0001 74.08 0.0001 ) constant bc-ds2

'( 1.01 0.1365 2.01 0.0009 3.03 0.0219 3.99 0.0004 5.04 0.0239
   6.03 0.0013 7.02 0.0284 8.04 0.0029 9.03 0.0167 10.06 0.0042
   11.05 0.0059 12.03 0.0012 13.07 0.0095 14.07 0.0013 15.08 0.0109
   16.06 0.0038 17.06 0.0042 18.09 0.0006 19.07 0.0034 20.10 0.0036
   21.09 0.0018 22.08 0.0025 23.11 0.0054 24.08 0.0008 25.12 0.0035
   26.09 0.0013 27.13 0.0022 28.13 0.0009 29.12 0.0006 30.14 0.0004
   31.13 0.0005 32.15 0.0003 33.15 0.0003 35.15 0.0002 36.13 0.0001
   37.17 0.0003 38.19 0.0002 39.16 0.0006 40.21 0.0001 41.17 0.0005
   42.18 0.0002 43.19 0.0003 44.18 0.0001 45.21 0.0002 46.19 0.0002
   47.22 0.0004 48.22 0.0002 49.20 0.0002 50.23 0.0001 55.24 0.0001
   56.23 0.0001 57.26 0.0002 59.26 0.0001 61.25 0.0002 62.29 0.0002
   64.27 0.0001 ) constant bc-e2

'( 0.99 0.1014 2.00 0.0021 3.02 0.0301 4.02 0.0012 5.00 0.0893
   6.02 0.0028 7.03 0.0333 8.04 0.0046 9.05 0.0109 10.03 0.0033
   11.03 0.0174 12.05 0.0075 13.06 0.0085 14.06 0.0037 15.04 0.0133
   16.08 0.0021 17.07 0.0017 18.07 0.0009 19.05 0.0015 20.07 0.0002
   21.08 0.0068 22.09 0.0033 23.10 0.0060 24.07 0.0031 25.08 0.0036
   26.10 0.0009 27.11 0.0001 28.11 0.0010 29.10 0.0007 30.10 0.0004
   31.12 0.0005 32.13 0.0002 33.11 0.0005 34.11 0.0003 35.12 0.0004
   36.13 0.0002 37.14 0.0005 38.12 0.0001 39.14 0.0005 40.14 0.0002
   41.16 0.0002 43.14 0.0003 45.17 0.0004 46.18 0.0002 47.16 0.0002
   49.18 0.0002 51.18 0.0001 53.19 0.0002 55.22 0.0001 56.19 0.0002
   57.21 0.0001 58.22 0.0002 60.23 0.0002 62.22 0.0001 ) constant bc-f2

'( 1.01 0.0724 2.02 0.0045 3.01 0.0626 4.01 0.0014 5.00 0.1104
   6.00 0.0041 7.00 0.0216 8.03 0.0017 9.03 0.0255 10.02 0.0011
   11.02 0.0152 12.02 0.0019 13.01 0.0061 14.02 0.0018 15.04 0.0077
   16.05 0.0009 17.04 0.0031 18.04 0.0014 19.02 0.0058 20.04 0.0005
   21.03 0.0030 22.03 0.0030 23.05 0.0048 24.06 0.0013 25.04 0.0009
   26.04 0.0002 27.03 0.0008 28.05 0.0005 29.05 0.0003 30.06 0.0002
   31.06 0.0004 32.05 0.0005 33.05 0.0003 34.04 0.0002 35.05 0.0004
   37.08 0.0006 38.06 0.0002 39.07 0.0003 41.06 0.0003 42.07 0.0001
   43.07 0.0003 44.09 0.0002 45.10 0.0001 47.07 0.0001 51.10 0.0002
   53.10 0.0002 54.10 0.0001 56.09 0.0002 57.09 0.0001 58.12 0.0001
   62.11 0.0001 64.11 0.0001 ) constant bc-fs2

'( 1.00 0.0567 1.99 0.0037 3.00 0.1114 3.98 0.0030 4.99 0.1112
   5.98 0.0041 6.99 0.0195 7.99 0.0061 8.98 0.0081 9.97 0.0084
   10.98 0.0139 11.98 0.0038 12.98 0.0092 13.97 0.0038 14.97 0.0042
   15.97 0.0003 16.97 0.0012 17.96 0.0019 18.97 0.0040 19.95 0.0032
   20.97 0.0088 21.95 0.0022 22.96 0.0025 23.94 0.0004 24.94 0.0003
   25.92 0.0005 26.95 0.0005 27.91 0.0003 28.95 0.0003 29.90 0.0002
   30.94 0.0006 31.89 0.0001 32.93 0.0007 34.92 0.0005 35.89 0.0002
   36.92 0.0003 37.89 0.0001 38.91 0.0002 39.88 0.0002 40.90 0.0004
   41.88 0.0002 43.88 0.0002 50.90 0.0001 51.89 0.0002 52.93 0.0001
   53.89 0.0003 55.87 0.0002 ) constant bc-g2

'( 0.99 0.0794 2.00 0.0021 3.00 0.1294 3.98 0.0015 4.98 0.0849
   5.98 0.0058 6.99 0.0389 7.97 0.0113 8.97 0.0154 9.98 0.0026
   10.98 0.0172 11.95 0.0048 12.95 0.0099 13.98 0.0011 14.97 0.0029
   15.95 0.0013 16.95 0.0055 17.97 0.0014 18.96 0.0052 19.94 0.0040
   20.94 0.0038 21.96 0.0006 22.94 0.0003 23.92 0.0005 24.93 0.0005
   25.93 0.0002 26.94 0.0006 27.92 0.0003 28.91 0.0007 29.91 0.0004
   30.93 0.0006 31.90 0.0003 32.90 0.0006 33.90 0.0003 34.91 0.0004
   35.89 0.0001 36.89 0.0003 37.90 0.0003 38.90 0.0003 40.88 0.0002
   42.89 0.0001 45.89 0.0002 47.87 0.0001 49.87 0.0003 50.86 0.0002
   51.85 0.0002 53.86 0.0001 ) constant bc-gs2

'( 0.99 0.1177 1.99 0.0047 2.99 0.2346 3.99 0.0023 4.98 0.0538
   5.99 0.0060 6.98 0.0493 7.99 0.0062 8.99 0.0103 9.99 0.0030
   10.99 0.0146 11.99 0.0126 12.99 0.0042 13.99 0.0016 14.99 0.0060
   15.98 0.0034 16.96 0.0039 17.96 0.0036 18.96 0.0076 19.96 0.0018
   20.96 0.0025 22.95 0.0018 23.95 0.0005 24.94 0.0003 25.95 0.0005
   26.95 0.0006 27.95 0.0008 28.96 0.0005 29.96 0.0005 30.96 0.0007
   31.95 0.0005 32.95 0.0005 33.95 0.0001 34.95 0.0003 35.93 0.0002
   36.94 0.0003 38.92 0.0002 42.93 0.0001 44.93 0.0001 46.93 0.0002
   47.92 0.0001 ) constant bc-a2

'( 1.00 0.1279 1.99 0.0028 2.99 0.1611 3.98 0.0034 4.97 0.0322
   5.97 0.0085 6.98 0.0274 7.97 0.0068 8.96 0.0245 9.97 0.0022
   10.94 0.0254 11.93 0.0010 12.93 0.0078 13.95 0.0022 14.94 0.0035
   15.92 0.0022 16.92 0.0033 17.91 0.0039 18.90 0.0037 19.92 0.0012
   20.92 0.0003 21.91 0.0008 22.89 0.0005 23.88 0.0007 24.87 0.0007
   25.87 0.0005 26.88 0.0007 27.86 0.0001 28.86 0.0014 29.84 0.0004
   30.85 0.0005 31.85 0.0001 32.85 0.0004 33.84 0.0004 34.84 0.0003
   36.82 0.0003 40.81 0.0003 42.80 0.0001 43.79 0.0002 44.79 0.0002
   45.79 0.0003 46.79 0.0001 47.79 0.0002 49.77 0.0001 ) constant bc-as2

'( 1.00 0.1161 1.98 0.0036 2.97 0.1813 3.98 0.0038 4.96 0.0298
   5.95 0.0073 6.95 0.0125 7.95 0.0064 8.92 0.0175 9.94 0.0087
   10.91 0.0117 11.91 0.0025 12.91 0.0055 13.92 0.0027 14.88 0.0069
   15.88 0.0034 16.88 0.0052 17.85 0.0038 18.88 0.0003 19.83 0.0005
   20.83 0.0005 21.78 0.0002 22.82 0.0004 23.74 0.0002 24.81 0.0008
   25.76 0.0003 26.78 0.0005 27.78 0.0006 28.78 0.0005 29.74 0.0002
   30.75 0.0001 31.75 0.0004 32.72 0.0002 33.73 0.0002 34.73 0.0002
   41.69 0.0002 42.68 0.0002 43.67 0.0002 44.68 0.0002 45.67 0.0001 ) constant bc-b2

'( 1.00 0.1579 1.99 0.0068 2.99 0.1885 3.99 0.0022 4.97 0.0384
   5.96 0.0054 6.97 0.0247 7.97 0.0023 8.96 0.0114 9.95 0.0096
   10.93 0.0054 11.95 0.0030 12.94 0.0036 13.92 0.0075 14.93 0.0033
   15.92 0.0052 16.91 0.0010 17.91 0.0011 18.90 0.0004 19.89 0.0006
   20.90 0.0005 21.89 0.0003 22.87 0.0004 23.88 0.0004 24.87 0.0005
   25.86 0.0008 26.87 0.0005 27.85 0.0002 28.84 0.0002 29.85 0.0003
   30.83 0.0002 31.84 0.0002 32.83 0.0002 35.83 0.0001 36.80 0.0002
   38.81 0.0002 39.78 0.0002 40.78 0.0003 41.79 0.0001 ) constant bc-c3

'( 1.00 0.2106 1.98 0.0073 2.99 0.1027 3.98 0.0038 4.97 0.0191
   5.98 0.0036 6.97 0.0256 7.95 0.0035 8.97 0.0347 9.95 0.0039
   10.94 0.0048 11.95 0.0026 12.94 0.0089 13.93 0.0011 14.93 0.0052
   15.93 0.0033 16.96 0.0002 17.93 0.0003 18.94 0.0001 19.92 0.0002
   20.91 0.0007 21.91 0.0006 22.89 0.0005 23.90 0.0005 24.90 0.0005
   25.87 0.0005 26.89 0.0003 27.88 0.0005 28.87 0.0003 29.87 0.0003
   31.85 0.0002 33.84 0.0001 34.84 0.0001 36.82 0.0003 37.83 0.0001
   38.83 0.0003 ) constant bc-cs3

'( 1.01 0.2039 2.00 0.0041 3.00 0.0640 3.99 0.0062 5.00 0.0192
   6.00 0.0013 7.01 0.0225 8.00 0.0034 9.01 0.0245 10.00 0.0038
   11.02 0.0028 12.01 0.0030 13.02 0.0042 14.00 0.0021 15.01 0.0049
   16.02 0.0006 17.02 0.0003 18.02 0.0007 19.00 0.0001 20.03 0.0005
   21.02 0.0010 22.05 0.0002 23.04 0.0012 24.05 0.0003 25.02 0.0002
   26.03 0.0003 27.02 0.0004 28.03 0.0001 29.05 0.0002 30.05 0.0001
   33.03 0.0001 34.04 0.0001 35.04 0.0001 36.04 0.0003 38.05 0.0001
   40.04 0.0001 ) constant bc-d3

'( 1.01 0.1501 2.00 0.0036 3.00 0.0682 4.00 0.0069 4.99 0.0142
   5.98 0.0017 6.99 0.0322 7.99 0.0063 8.98 0.0019 10.00 0.0010
   11.00 0.0046 11.99 0.0023 12.99 0.0035 13.98 0.0041 14.98 0.0020
   15.97 0.0001 16.98 0.0003 17.98 0.0008 18.98 0.0009 20.03 0.0002
   21.00 0.0007 21.99 0.0006 22.99 0.0006 23.99 0.0003 24.98 0.0004
   25.98 0.0003 26.97 0.0001 27.98 0.0001 29.97 0.0001 30.98 0.0002
   32.96 0.0003 33.97 0.0003 34.95 0.0002 35.96 0.0002 36.97 0.0001 ) constant bc-ds3

'( 0.99 0.1413 1.99 0.0047 3.00 0.0710 4.01 0.0016 5.01 0.0154
   6.01 0.0063 7.01 0.0122 8.02 0.0179 9.00 0.0044 10.00 0.0082
   11.01 0.0058 12.01 0.0031 13.02 0.0045 14.02 0.0027 15.02 0.0004
   16.03 0.0010 17.01 0.0008 18.04 0.0002 19.04 0.0004 20.03 0.0006
   21.04 0.0004 22.03 0.0003 23.04 0.0004 24.04 0.0002 25.04 0.0003
   26.06 0.0001 27.04 0.0003 28.03 0.0002 29.02 0.0003 30.99 0.0002
   32.04 0.0006 33.03 0.0002 34.04 0.0003 36.04 0.0001 ) constant bc-e3

'( 0.99 0.2534 1.99 0.0057 3.00 0.0476 3.98 0.0101 4.98 0.0334
   5.97 0.0066 6.98 0.0489 7.96 0.0038 8.96 0.0096 9.95 0.0008
   10.96 0.0056 11.95 0.0049 12.95 0.0029 13.95 0.0002 14.95 0.0006
   15.96 0.0002 16.96 0.0008 17.94 0.0004 18.93 0.0002 19.94 0.0009
   20.94 0.0002 21.93 0.0004 22.94 0.0004 23.93 0.0004 25.90 0.0004
   26.90 0.0003 27.89 0.0001 28.91 0.0004 29.87 0.0001 30.89 0.0005
   32.89 0.0002 33.87 0.0001 ) constant bc-f3

'( 1.00 0.3131 1.99 0.0095 3.00 0.0885 3.99 0.0194 4.98 0.0653
   5.99 0.0049 6.98 0.0528 7.99 0.0038 8.98 0.0129 9.97 0.0042
   10.98 0.0063 11.97 0.0023 12.97 0.0016 13.98 0.0002 14.97 0.0004
   15.97 0.0005 16.97 0.0006 17.96 0.0001 18.96 0.0008 20.95 0.0007
   21.96 0.0001 22.95 0.0001 23.94 0.0003 25.94 0.0004 26.95 0.0004
   27.94 0.0005 28.93 0.0003 29.94 0.0003 31.93 0.0002 33.92 0.0002 ) constant bc-fs3

'( 1.00 0.2177 2.01 0.0024 3.01 0.0126 4.02 0.0067 5.02 0.0577
   6.02 0.0083 7.02 0.0215 8.03 0.0034 9.03 0.0047 10.04 0.0046
   11.05 0.0143 12.04 0.0037 13.04 0.0010 14.05 0.0005 15.06 0.0005
   16.06 0.0003 17.06 0.0002 18.06 0.0004 19.09 0.0001 20.08 0.0003
   21.08 0.0002 23.08 0.0003 24.08 0.0003 25.08 0.0001 26.10 0.0010
   27.11 0.0002 28.10 0.0004 30.12 0.0003 32.13 0.0003 ) constant bc-g3

'( 1.01 0.1420 2.01 0.0026 3.01 0.0289 4.03 0.0162 5.03 0.0373
   6.02 0.0015 7.03 0.0112 8.05 0.0068 9.05 0.0063 10.04 0.0027
   11.06 0.0022 12.07 0.0004 13.06 0.0008 14.07 0.0011 15.08 0.0003
   16.08 0.0002 17.09 0.0005 19.11 0.0003 23.12 0.0004 24.12 0.0003
   25.14 0.0002 26.14 0.0003 27.14 0.0002 28.14 0.0002 29.16 0.0002
   30.16 0.0001 34.18 0.0002 ) constant bc-gs3

'( 1.01 0.2365 2.02 0.0034 3.03 0.0242 4.04 0.0251 5.04 0.0203
   6.06 0.0078 7.06 0.0213 8.08 0.0162 9.09 0.0121 10.10 0.0053
   11.11 0.0024 12.12 0.0028 13.14 0.0010 14.13 0.0006 15.15 0.0009
   16.16 0.0008 17.17 0.0009 18.18 0.0006 19.19 0.0003 20.20 0.0003
   21.20 0.0003 22.22 0.0004 23.22 0.0002 24.24 0.0007 26.26 0.0003
   27.26 0.0001 29.29 0.0003 ) constant bc-a3

'( 1.00 0.1078 2.01 0.0072 3.02 0.0487 4.04 0.0332 5.05 0.0329
   6.06 0.0069 7.07 0.0153 8.08 0.0061 9.08 0.0082 10.09 0.0023
   11.10 0.0003 12.11 0.0009 13.12 0.0008 14.13 0.0007 15.15 0.0003
   16.16 0.0006 17.16 0.0007 18.16 0.0003 19.17 0.0003 20.18 0.0005
   21.19 0.0005 22.20 0.0005 23.22 0.0004 24.23 0.0001 26.25 0.0001
   27.25 0.0001 28.26 0.0001 ) constant bc-as3

'( 1.01 0.0572 2.02 0.0086 3.03 0.0724 4.04 0.0057 5.04 0.0365
   6.05 0.0058 7.06 0.0083 8.07 0.0113 9.08 0.0102 10.09 0.0022
   11.10 0.0012 12.11 0.0005 13.11 0.0014 14.12 0.0003 15.13 0.0008
   16.14 0.0009 17.15 0.0003 18.16 0.0002 19.17 0.0006 20.18 0.0009
   21.19 0.0002 22.19 0.0006 23.20 0.0004 24.21 0.0004 25.22 0.0001 ) constant bc-b3

'( 1.01 0.0509 2.02 0.0146 3.02 0.0344 4.03 0.0126 5.04 0.0254
   6.05 0.0004 7.05 0.0134 8.06 0.0069 9.08 0.0007 10.09 0.0005
   11.09 0.0006 12.09 0.0004 13.11 0.0010 14.12 0.0001 15.12 0.0008
   16.13 0.0001 17.14 0.0003 18.15 0.0002 19.17 0.0001 20.16 0.0004
   21.17 0.0002 ) constant bc-c4

'( 1.00 0.1853 2.00 0.0169 3.01 0.0922 4.01 0.0035 5.01 0.0204
   6.01 0.0046 7.02 0.0077 8.02 0.0085 9.02 0.0028 10.05 0.0002
   11.02 0.0003 12.03 0.0006 13.05 0.0002 14.03 0.0006 15.04 0.0006
   16.04 0.0004 17.02 0.0003 18.04 0.0006 19.04 0.0004 20.04 0.0003
   21.06 0.0001 22.04 0.0001 23.06 0.0002 ) constant bc-cs4

'( 1.00 0.3391 2.00 0.0134 2.99 0.0186 3.99 0.0424 4.98 0.0122
   5.98 0.0055 6.97 0.0197 7.98 0.0034 8.97 0.0017 9.98 0.0004
   10.96 0.0008 11.96 0.0009 12.96 0.0003 13.96 0.0007 14.95 0.0004
   15.94 0.0002 16.95 0.0003 17.94 0.0008 18.93 0.0002 19.93 0.0001 ) constant bc-d4

'( 0.99 0.3684 1.98 0.0187 2.98 0.0647 3.97 0.0186 4.97 0.0070
   5.96 0.0127 6.95 0.0173 7.94 0.0011 8.94 0.0011 9.93 0.0014
   10.92 0.0013 11.90 0.0001 12.90 0.0006 13.91 0.0003 14.89 0.0003
   15.89 0.0001 16.88 0.0010 17.88 0.0004 18.86 0.0001 19.86 0.0002
   20.85 0.0001 ) constant bc-ds4

'( 1.00 0.5390 3.01 0.0188 4.00 0.0247 5.00 0.0129 6.01 0.0050
   7.01 0.0014 8.01 0.0012 9.01 0.0012 10.01 0.0010 11.02 0.0005
   12.02 0.0002 13.03 0.0004 ) constant bc-e4

'( 1.01 0.5398 2.01 0.0309 3.01 0.0727 4.01 0.0062 5.01 0.0041
   6.02 0.0280 7.02 0.0005 8.02 0.0014 9.02 0.0013 10.02 0.0030
   11.03 0.0006 12.03 0.0004 14.03 0.0003 15.04 0.0003 16.04 0.0007 ) constant bc-f4

'( 1.00 0.6398 2.01 0.0314 3.01 0.0423 4.01 0.0292 5.01 0.0093
   6.02 0.0088 7.02 0.0010 8.03 0.0043 9.02 0.0004 10.03 0.0013
   11.03 0.0003 12.04 0.0003 13.02 0.0002 14.04 0.0010 15.04 0.0006
   16.05 0.0001 17.04 0.0003 ) constant bc-fs4

'( 1.00 0.5985 1.99 0.0192 2.99 0.0346 3.99 0.0257 4.98 0.0082
   5.98 0.0037 6.98 0.0008 7.99 0.0013 8.97 0.0014 9.98 0.0016
   10.98 0.0010 11.98 0.0005 12.97 0.0005 13.97 0.0008 14.95 0.0002
   15.96 0.0003 ) constant bc-g4

'( 1.00 0.2635 1.99 0.0230 2.99 0.0936 3.99 0.0214 4.99 0.0320
   5.99 0.0013 6.99 0.0020 7.99 0.0004 8.99 0.0014 9.99 0.0003
   10.99 0.0003 11.98 0.0005 12.98 0.0015 13.98 0.0005 14.98 0.0003
   15.98 0.0003 18.98 0.0001 ) constant bc-gs4

'( 1.00 0.1539 2.00 0.0355 3.00 0.0834 4.01 0.0210 5.01 0.0103
   6.00 0.0035 7.02 0.0004 8.01 0.0008 9.00 0.0002 10.01 0.0001
   11.01 0.0005 12.01 0.0007 13.02 0.0011 14.01 0.0003 15.02 0.0003
   18.02 0.0002 ) constant bc-a4

'( 1.00 0.1843 2.01 0.0229 3.00 0.0348 4.01 0.0157 5.01 0.0170
   6.01 0.0037 7.02 0.0012 8.02 0.0027 9.02 0.0003 10.02 0.0011
   11.03 0.0010 12.03 0.0007 13.03 0.0004 14.03 0.0002 15.03 0.0002
   17.04 0.0002 ) constant bc-as4

'( 1.00 0.5063 2.01 0.0563 3.01 0.0376 4.01 0.0383 5.01 0.0135
   6.02 0.0081 7.02 0.0011 8.02 0.0049 9.03 0.0007 10.03 0.0006
   11.04 0.0013 12.04 0.0007 13.04 0.0004 14.05 0.0002 15.05 0.0002
   17.05 0.0002 19.06 0.0001 ) constant bc-b4

'( 1.00 0.5459 2.00 0.0278 3.01 0.0456 4.01 0.0648 5.02 0.0035
   6.02 0.0050 7.02 0.0025 8.02 0.0021 9.02 0.0005 10.03 0.0007
   11.03 0.0016 12.03 0.0007 13.04 0.0001 14.03 0.0002 15.04 0.0002
   18.05 0.0002 19.05 0.0001 20.05 0.0002 ) constant bc-c5

'( 1.00 0.2584 2.01 0.0583 3.02 0.1090 4.02 0.0290 5.02 0.0020
   6.03 0.0018 7.03 0.0016 8.03 0.0001 9.04 0.0005 10.05 0.0017
   11.05 0.0010 12.05 0.0002 13.06 0.0001 14.06 0.0001 17.08 0.0002
   18.08 0.0001 19.08 0.0001 ) constant bc-cs5

'( 1.00 0.1626 2.00 0.0485 3.01 0.0856 4.00 0.0023 5.01 0.0096
   6.01 0.0042 7.01 0.0015 8.01 0.0004 9.02 0.0019 10.02 0.0016
   11.02 0.0003 12.02 0.0002 13.02 0.0002 16.03 0.0001 17.03 0.0001
   18.03 0.0002 19.03 0.0001 ) constant bc-d5

'( 1.00 0.1756 1.99 0.1645 2.99 0.0381 3.98 0.0028 4.98 0.0042
   5.98 0.0004 6.97 0.0025 7.97 0.0006 8.96 0.0022 9.96 0.0011
   10.96 0.0002 13.94 0.0002 14.94 0.0002 15.94 0.0001 16.93 0.0001
   17.93 0.0001 ) constant bc-ds5

'( 0.99 0.2661 1.99 0.1398 2.99 0.0589 3.99 0.0048 4.98 0.0022
   5.98 0.0015 6.97 0.0021 7.97 0.0008 8.96 0.0011 9.96 0.0009
   10.95 0.0004 11.94 0.0001 13.94 0.0001 14.94 0.0001 15.94 0.0001 ) constant bc-e5

'( 1.00 0.1378 2.00 0.0654 3.00 0.1301 4.00 0.0049 5.00 0.0030
   6.01 0.0018 7.01 0.0030 8.01 0.0015 9.01 0.0008 10.01 0.0001
   11.01 0.0003 12.01 0.0002 13.01 0.0001 14.01 0.0002 15.01 0.0002
   16.02 0.0001 ) constant bc-f5

'( 1.00 0.3952 2.01 0.1124 3.01 0.0326 4.02 0.0104 5.03 0.0013
   6.03 0.0010 7.03 0.0009 8.04 0.0009 9.05 0.0002 10.05 0.0003
   11.05 0.0001 13.06 0.0002 14.07 0.0003 15.08 0.0002 ) constant bc-fs5

'( 1.01 0.3434 2.01 0.0390 3.02 0.0051 4.03 0.0057 5.04 0.0042
   6.05 0.0017 7.06 0.0022 8.06 0.0012 9.07 0.0002 10.07 0.0001
   11.08 0.0002 12.09 0.0002 13.10 0.0002 14.11 0.0002 15.12 0.0001 ) constant bc-g5

'( 1.00 0.1109 1.99 0.0911 2.98 0.0061 3.98 0.0062 4.98 0.0020
   5.97 0.0006 6.96 0.0008 7.96 0.0013 8.95 0.0002 10.94 0.0002
   11.94 0.0002 12.93 0.0002 13.93 0.0001 ) constant bc-gs5

'( 1.00 0.1585 2.00 0.0562 3.00 0.0039 4.00 0.0064 5.00 0.0016
   6.00 0.0022 7.00 0.0009 8.00 0.0004 9.00 0.0002 11.00 0.0003
   12.00 0.0003 13.00 0.0002 14.00 0.0002 ) constant bc-a5

'( 0.99 0.1211 1.98 0.0394 2.97 0.0093 3.96 0.0024 4.95 0.0030
   5.94 0.0027 6.93 0.0006 8.92 0.0002 10.90 0.0001 12.88 0.0001 ) constant bc-as5

\ **********************************************************
\ bassoon
\ **********************************************************

'( 1.00 0.0038 2.02 0.0235 3.04 0.0511 4.06 0.0348 5.07 0.0491
   6.09 0.0518 7.11 0.0184 8.12 0.0381 9.11 0.1027 10.13 0.0412
   11.15 0.0112 12.17 0.0144 13.18 0.0097 14.20 0.0074 15.21 0.0081
   16.23 0.0067 17.22 0.0108 18.24 0.0113 19.25 0.0114 20.28 0.0066
   21.30 0.0065 22.32 0.0035 23.33 0.0041 24.33 0.0036 25.34 0.0025
   26.35 0.0010 27.37 0.0021 28.39 0.0007 29.42 0.0006 30.42 0.0009
   31.43 0.0005 32.43 0.0003 33.46 0.0005 34.46 0.0002 35.48 0.0002
   36.48 0.0004 37.52 0.0003 38.53 0.0003 39.55 0.0002 40.56 0.0002
   51.69 0.0001 54.72 0.0002 ) constant bsn-as1

'( 1.01 0.0039 2.02 0.0230 3.02 0.0517 4.03 0.0473 5.03 0.0443
   6.03 0.0691 7.03 0.0664 8.04 0.0408 9.04 0.1283 10.06 0.0429
   11.07 0.0339 12.08 0.0223 13.08 0.0207 14.08 0.0256 15.08 0.0171
   16.09 0.0106 17.09 0.0136 18.09 0.0082 19.12 0.0052 20.12 0.0041
   21.13 0.0015 22.13 0.0023 23.12 0.0021 24.12 0.0009 25.13 0.0029
   26.14 0.0014 27.15 0.0003 28.15 0.0010 29.17 0.0013 30.18 0.0003
   31.19 0.0005 32.19 0.0007 33.19 0.0004 34.20 0.0005 35.19 0.0005
   36.19 0.0003 37.21 0.0003 38.23 0.0002 39.23 0.0001 40.23 0.0001
   43.23 0.0001 46.26 0.0002 49.27 0.0002 51.27 0.0003 52.27 0.0002
   53.28 0.0002 ) constant bsn-b1

'( 1.01 0.0047 2.03 0.0390 3.04 0.0460 4.04 0.0217 5.05 0.0464
   6.05 0.0631 7.06 0.0874 8.07 0.1167 9.08 0.0339 10.09 0.0209
   11.11 0.0133 12.12 0.0088 13.11 0.0092 14.14 0.0032 15.15 0.0026
   16.16 0.0061 17.17 0.0019 18.17 0.0051 19.18 0.0161 20.18 0.0048
   21.20 0.0044 22.21 0.0035 23.23 0.0010 24.24 0.0028 25.25 0.0006
   26.26 0.0013 27.27 0.0016 28.26 0.0002 29.28 0.0006 30.28 0.0006
   31.30 0.0004 32.32 0.0012 33.33 0.0003 34.34 0.0003 35.35 0.0002
   36.34 0.0001 43.41 0.0001 46.43 0.0001 48.44 0.0001 51.48 0.0001 ) constant bsn-c2

'( 1.01 0.0090 2.02 0.0531 3.01 0.0318 4.01 0.0199 5.02 0.0211
   6.04 0.0629 7.04 0.1340 8.05 0.0925 9.04 0.0206 10.04 0.0584
   11.05 0.0140 12.07 0.0066 13.08 0.0068 14.08 0.0011 15.07 0.0028
   16.07 0.0015 17.08 0.0041 18.10 0.0106 19.10 0.0034 20.10 0.0033
   21.10 0.0020 22.10 0.0021 23.11 0.0040 24.13 0.0001 25.12 0.0004
   26.13 0.0003 28.13 0.0004 29.14 0.0002 30.16 0.0001 31.17 0.0001
   43.20 0.0001 46.22 0.0002 ) constant bsn-cs2

'( 1.01 0.0616 2.00 0.0436 3.00 0.0430 3.99 0.0491 5.01 0.0358
   6.01 0.1695 7.00 0.1562 7.99 0.0174 8.99 0.0062 10.01 0.0054
   11.00 0.0104 12.00 0.0055 12.99 0.0052 13.99 0.0018 15.00 0.0021
   16.00 0.0019 16.99 0.0087 17.98 0.0025 18.99 0.0027 20.00 0.0015
   21.00 0.0024 21.98 0.0015 22.99 0.0002 24.00 0.0006 25.99 0.0001
   26.95 0.0001 28.00 0.0001 28.94 0.0001 30.01 0.0002 ) constant bsn-d2

'( 1.01 0.0769 2.01 0.0341 3.00 0.0240 4.00 0.0633 5.00 0.0124
   5.99 0.0850 6.99 0.1044 7.99 0.0115 8.99 0.0046 10.00 0.0048
   11.00 0.0054 12.00 0.0082 13.00 0.0033 14.00 0.0080 15.00 0.0022
   15.99 0.0081 16.99 0.0028 17.98 0.0038 18.98 0.0028 19.99 0.0032
   20.99 0.0007 22.00 0.0003 22.98 0.0004 23.99 0.0001 24.98 0.0005
   25.98 0.0002 26.97 0.0003 28.98 0.0001 38.97 0.0001 40.97 0.0001 ) constant bsn-ds2

'( 1.00 0.0369 1.98 0.0190 3.00 0.0291 3.98 0.0844 5.00 0.0730
   5.98 0.0856 7.00 0.0563 7.98 0.0792 9.00 0.0139 9.97 0.0127
   10.99 0.0046 11.96 0.0052 12.99 0.0043 13.97 0.0030 14.99 0.0102
   15.98 0.0020 16.97 0.0029 17.98 0.0010 18.96 0.0040 19.98 0.0008
   20.97 0.0004 21.99 0.0001 23.98 0.0004 25.96 0.0002 26.93 0.0001
   36.94 0.0001 ) constant bsn-e2

'( 0.99 0.0208 2.00 0.0164 3.01 0.0576 4.02 0.0547 5.02 0.0965
   5.99 0.1701 7.00 0.0206 8.01 0.0040 9.02 0.0075 10.02 0.0033
   11.00 0.0067 12.00 0.0021 13.01 0.0010 14.02 0.0072 15.03 0.0014
   16.01 0.0028 17.01 0.0034 18.02 0.0026 19.03 0.0007 20.05 0.0004
   20.43 0.0001 22.02 0.0001 24.01 0.0003 26.03 0.0001 ) constant bsn-f2

'( 1.00 0.0112 1.99 0.0211 2.98 0.0379 3.97 0.0630 4.98 0.0727
   5.97 0.1555 6.95 0.0348 7.94 0.0362 8.96 0.0083 9.94 0.0145
   10.92 0.0070 11.91 0.0031 12.93 0.0059 13.92 0.0054 14.91 0.0024
   15.89 0.0024 16.88 0.0045 17.90 0.0013 18.91 0.0007 19.87 0.0005
   20.87 0.0004 21.88 0.0002 22.85 0.0007 23.84 0.0003 24.83 0.0002
   26.84 0.0001 28.80 0.0002 29.80 0.0001 30.81 0.0003 31.81 0.0001
   32.78 0.0003 33.77 0.0001 34.79 0.0002 ) constant bsn-fs2

'( 0.98 0.0330 1.99 0.0314 2.95 0.0487 3.95 0.0272 4.95 0.2864
   5.91 0.0849 6.92 0.0047 7.89 0.0049 8.88 0.0015 9.88 0.0060
   10.85 0.0051 11.85 0.0013 12.83 0.0083 13.82 0.0018 14.82 0.0010
   15.78 0.0032 16.79 0.0007 17.77 0.0004 18.76 0.0005 19.76 0.0008
   20.72 0.0004 21.72 0.0009 22.72 0.0003 23.69 0.0002 ) constant bsn-g2

'( 0.98 0.0321 1.98 0.0281 2.99 0.0196 3.99 0.0683 4.96 0.2698
   5.95 0.0125 6.95 0.0153 7.96 0.0034 8.96 0.0050 9.93 0.0056
   10.92 0.0049 11.92 0.0160 12.92 0.0072 13.91 0.0013 14.89 0.0028
   15.91 0.0005 16.86 0.0004 17.89 0.0006 18.89 0.0009 19.87 0.0005
   20.85 0.0001 21.87 0.0003 27.83 0.0001 28.82 0.0002 ) constant bsn-gs2

'( 0.99 0.0170 2.00 0.0296 3.00 0.0324 4.01 0.1542 5.02 0.1393
   6.02 0.0249 7.03 0.0041 8.03 0.0022 9.01 0.0043 10.02 0.0077
   11.03 0.0092 12.04 0.0021 13.04 0.0027 14.05 0.0026 15.06 0.0007
   16.05 0.0001 17.05 0.0003 18.04 0.0006 19.04 0.0004 20.05 0.0002
   26.06 0.0003 27.06 0.0002 29.07 0.0001 ) constant bsn-a2

'( 1.01 0.0153 2.00 0.0261 3.00 0.0305 3.99 0.1573 4.97 0.0908
   5.98 0.0053 6.97 0.0054 7.98 0.0159 8.99 0.0031 9.99 0.0015
   10.96 0.0124 11.96 0.0020 12.95 0.0026 13.94 0.0034 14.94 0.0005
   16.95 0.0007 17.93 0.0002 18.94 0.0003 24.92 0.0002 25.91 0.0002
   27.89 0.0002 28.89 0.0001 ) constant bsn-as2

'( 1.01 0.0061 2.00 0.0199 2.99 0.0393 3.98 0.2060 5.00 0.0178
   5.99 0.0340 6.98 0.0029 7.98 0.0065 8.99 0.0102 9.99 0.0271
   10.98 0.0068 11.97 0.0032 12.97 0.0060 13.99 0.0002 14.98 0.0005
   15.96 0.0008 16.96 0.0008 17.98 0.0006 18.98 0.0001 21.96 0.0001
   22.96 0.0002 23.95 0.0002 24.94 0.0002 25.94 0.0001 26.95 0.0001 28.95 0.0001 ) constant bsn-b2

'( 1.00 0.0082 1.98 0.0489 2.99 0.1248 3.98 0.1892 4.97 0.0149
   5.98 0.0017 6.96 0.0172 7.95 0.0072 8.96 0.0028 9.95 0.0114
   10.93 0.0055 11.94 0.0029 12.96 0.0005 13.92 0.0017 14.93 0.0008
   15.91 0.0012 16.90 0.0005 17.91 0.0001 20.90 0.0001 21.88 0.0003
   22.87 0.0001 24.85 0.0002 28.85 0.0001 ) constant bsn-c3

'( 1.01 0.0191 2.00 0.0451 2.99 0.2847 4.00 0.0925 5.00 0.0143
   5.99 0.0024 7.00 0.0055 8.00 0.0131 8.99 0.0286 9.98 0.0021
   10.99 0.0020 11.99 0.0010 12.96 0.0003 13.97 0.0005 14.98 0.0009
   15.97 0.0005 20.97 0.0003 21.97 0.0003 ) constant bsn-cs3

'( 1.01 0.0218 2.01 0.0560 3.01 0.1696 4.01 0.0504 5.00 0.0268
   6.02 0.0018 7.03 0.0081 8.03 0.0035 9.04 0.0026 10.04 0.0023
   11.02 0.0045 12.04 0.0002 13.04 0.0004 14.04 0.0007 15.05 0.0004
   16.06 0.0001 21.06 0.0001 22.07 0.0003 ) constant bsn-d3

'( 1.00 0.0185 1.99 0.0627 2.98 0.2037 3.97 0.0211 4.98 0.0204
   5.97 0.0434 6.95 0.0056 7.94 0.0171 8.95 0.0014 9.94 0.0062
   10.93 0.0007 11.91 0.0006 12.91 0.0004 13.90 0.0004 14.90 0.0003
   16.88 0.0001 17.89 0.0002 18.88 0.0002 20.86 0.0004 21.84 0.0002
   22.85 0.0001 ) constant bsn-ds3

'( 1.00 0.0167 2.00 0.0801 3.01 0.2223 4.02 0.0252 5.02 0.0098
   6.01 0.0058 7.02 0.0073 8.03 0.0032 9.03 0.0066 10.04 0.0011
   10.66 0.0001 12.04 0.0013 13.04 0.0013 14.05 0.0010 15.05 0.0004
   18.07 0.0002 20.06 0.0003 23.07 0.0001 ) constant bsn-e3

'( 1.00 0.0152 2.01 0.0471 3.00 0.1985 4.00 0.0345 5.01 0.0136
   6.00 0.0064 7.01 0.0153 8.00 0.0011 9.00 0.0093 10.02 0.0006
   11.01 0.0006 12.00 0.0001 13.01 0.0008 14.01 0.0006 16.02 0.0001
   17.01 0.0003 19.01 0.0002 22.01 0.0001 23.02 0.0002 ) constant bsn-f3

'( 1.01 0.0363 2.01 0.1019 3.01 0.3226 4.01 0.1274 5.03 0.0397
   6.03 0.0061 7.02 0.0117 8.03 0.0099 9.04 0.0006 10.04 0.0026
   11.04 0.0020 12.04 0.0008 13.05 0.0001 14.06 0.0002 15.05 0.0002
   19.07 0.0002 ) constant bsn-fs3

'( 0.99 0.0358 1.99 0.0535 2.99 0.1072 3.99 0.0270 4.99 0.0106
   5.98 0.0010 6.97 0.0007 7.97 0.0041 8.95 0.0002 9.94 0.0002
   10.97 0.0002 12.96 0.0001 ) constant bsn-g3

'( 1.00 0.0382 1.99 0.0923 2.99 0.0199 3.99 0.0156 4.96 0.0044
   5.98 0.0130 6.97 0.0020 7.97 0.0033 8.97 0.0007 9.95 0.0002
   10.95 0.0001 12.95 0.0001 ) constant bsn-gs3

'( 1.00 0.0469 2.00 0.2187 3.00 0.0287 4.01 0.0121 5.01 0.0114
   6.01 0.0022 7.01 0.0044 8.02 0.0008 9.02 0.0004 10.01 0.0003
   13.02 0.0001 ) constant bsn-a3

'( 1.01 0.0298 2.01 0.2016 3.02 0.0058 4.00 0.0258 5.00 0.0008
   6.00 0.0029 7.00 0.0031 8.01 0.0010 9.01 0.0004 10.00 0.0001
   13.01 0.0001 ) constant bsn-as3

'( 1.01 0.0341 2.01 0.2100 3.01 0.0390 4.02 0.0044 5.02 0.0213
   6.02 0.0044 7.02 0.0006 8.03 0.0012 9.04 0.0002 12.05 0.0002
   13.05 0.0002 ) constant bsn-b3

'( 1.00 0.0684 2.00 0.2934 3.00 0.0096 4.00 0.0084 5.00 0.0039
   6.00 0.0059 7.00 0.0010 8.00 0.0006 ) constant bsn-c4

'( 1.01 0.0848 2.01 0.3334 3.02 0.0152 4.03 0.0032 5.03 0.0059
   6.03 0.0032 7.05 0.0013 8.05 0.0007 9.05 0.0001 10.06 0.0001
   11.06 0.0002 ) constant bsn-cs4

'( 1.00 0.1020 2.00 0.1065 3.00 0.0086 3.99 0.0013 5.00 0.0038
   6.00 0.0011 7.00 0.0003 8.00 0.0002 11.01 0.0003 ) constant bsn-d4

'( 1.00 0.0469 1.99 0.0248 2.96 0.0045 3.99 0.0163 4.99 0.0042
   6.00 0.0004 6.98 0.0003 ) constant bsn-ds4

'( 1.00 0.0389 2.01 0.0439 3.01 0.0110 4.01 0.0072 5.02 0.0041
   6.02 0.0005 7.02 0.0006 9.03 0.0003 ) constant bsn-e4

'( 1.00 0.0229 2.00 0.0331 2.99 0.0138 4.00 0.0008 4.99 0.0010
   5.99 0.0004 ) constant bsn-f4

'( 1.00 0.1522 1.99 0.0563 3.00 0.0126 3.99 0.0035 4.28 0.0002
   4.35 0.0002 4.43 0.0001 4.98 0.0001 5.99 0.0001 6.98 0.0002 ) constant bsn-fs4

'( 1.00 0.0415 2.00 0.0486 3.00 0.0068 4.00 0.0148 5.00 0.0016
   6.00 0.0001 ) constant bsn-g4

'( 1.01 0.0811 2.01 0.0402 3.03 0.0114 4.04 0.0044 5.03 0.0004 ) constant bsn-gs4

'( 1.00 0.0399 2.01 0.0195 3.00 0.0069 4.01 0.0005 5.01 0.0009
   6.01 0.0002 7.01 0.0003 ) constant bsn-a4

'( 1.01 0.1259 2.01 0.0811 3.01 0.0051 4.01 0.0027 5.01 0.0008
   6.02 0.0002 7.02 0.0003 ) constant bsn-as4

'( 1.01 0.1159 2.02 0.0380 3.03 0.0089 4.04 0.0038 5.05 0.0006
   6.05 0.0002 ) constant bsn-b4

'( 1.02 0.0871 2.03 0.0356 3.04 0.0192 4.06 0.0063 6.09 0.0003
   7.11 0.0002 ) constant bsn-c5

'( 1.01 0.2418 2.02 0.0674 3.02 0.0067 4.03 0.0021 5.03 0.0004
   6.05 0.0003 7.05 0.0005 8.06 0.0001 ) constant bsn-cs5

'( 1.01 0.1931 2.01 0.0462 3.02 0.0118 4.02 0.0014 5.03 0.0006
   6.03 0.0008 8.04 0.0001 ) constant bsn-d5

\ **********************************************************
\ cello
\ **********************************************************

'( 1.00 0.0047 1.99 0.0251 2.99 0.0546 4.01 0.1041 4.99 0.0279
   5.97 0.0219 6.93 0.0137 7.94 0.0349 8.91 0.0151 10.04 0.0565
   11.00 0.0458 12.00 0.0216 12.97 0.0151 14.52 0.0025 14.95 0.0088
   16.03 0.0103 17.02 0.0027 17.98 0.0089 19.00 0.0052 20.03 0.0048
   20.93 0.0051 22.04 0.0023 23.01 0.0072 24.01 0.0022 24.99 0.0027
   26.03 0.0036 27.47 0.0011 27.99 0.0011 29.02 0.0012 29.86 0.0005
   30.97 0.0020 31.88 0.0006 33.02 0.0021 33.98 0.0011 35.02 0.0010
   36.01 0.0028 37.00 0.0022 37.99 0.0014 39.00 0.0014 40.01 0.0022
   41.04 0.0021 42.02 0.0008 43.01 0.0024 44.02 0.0007 45.01 0.0003
   46.00 0.0002 48.03 0.0002 48.85 0.0002 51.01 0.0001 51.98 0.0001
   54.89 0.0002 55.39 0.0002 56.38 0.0001 58.02 0.0002 58.98 0.0002
   62.00 0.0001 64.09 0.0001 65.02 0.0002 ) constant c-c2

'( 1.01 0.0160 2.02 0.0737 3.02 0.0287 4.02 0.0183 5.02 0.0669
   6.04 0.0520 7.05 0.0043 8.06 0.0066 9.06 0.0194 10.05 0.0193
   11.05 0.0254 12.06 0.0153 13.08 0.0041 14.11 0.0037 15.09 0.0098
   16.09 0.0022 17.09 0.0053 18.10 0.0135 19.12 0.0118 20.13 0.0057
   21.15 0.0039 22.14 0.0023 23.14 0.0027 24.15 0.0026 25.16 0.0012
   26.16 0.0011 27.17 0.0020 28.17 0.0015 29.14 0.0020 30.19 0.0013
   31.19 0.0019 32.20 0.0007 33.21 0.0005 34.22 0.0004 35.19 0.0012
   36.20 0.0005 37.25 0.0015 38.25 0.0018 39.26 0.0014 40.40 0.0007
   41.25 0.0010 42.24 0.0009 43.28 0.0003 44.31 0.0002 45.28 0.0002
   46.30 0.0001 48.29 0.0002 49.31 0.0004 50.34 0.0001 51.35 0.0002
   52.32 0.0003 53.50 0.0001 54.28 0.0001 57.34 0.0001 58.35 0.0002 ) constant c-cs2

'( 1.00 0.0368 2.02 0.1070 3.03 0.0107 4.04 0.0445 5.04 0.0477
   6.04 0.0281 7.07 0.0191 8.06 0.0205 9.06 0.0456 10.07 0.0283
   11.07 0.0320 12.08 0.0094 13.35 0.0009 14.11 0.0042 15.11 0.0066
   16.12 0.0075 17.13 0.0117 18.14 0.0043 19.16 0.0067 20.14 0.0020
   21.16 0.0046 22.16 0.0011 23.17 0.0029 24.17 0.0010 25.18 0.0011
   26.19 0.0013 27.18 0.0029 28.20 0.0039 29.21 0.0048 30.23 0.0020
   31.23 0.0006 32.25 0.0018 33.23 0.0009 34.24 0.0012 35.28 0.0016
   36.27 0.0018 37.28 0.0019 38.28 0.0031 39.28 0.0008 40.25 0.0001
   41.30 0.0002 42.31 0.0002 43.32 0.0001 44.32 0.0002 45.33 0.0002
   46.34 0.0004 48.37 0.0002 49.37 0.0006 50.37 0.0004 51.35 0.0001
   52.35 0.0001 53.40 0.0001 54.39 0.0002 55.41 0.0003 56.43 0.0002
   57.41 0.0001 64.49 0.0001 65.50 0.0001 ) constant c-d2

'( 1.01 0.0485 2.01 0.1800 3.01 0.0143 4.02 0.1265 5.03 0.1372
   6.03 0.0102 7.02 0.0261 8.03 0.0216 9.02 0.0145 10.04 0.0292
   11.05 0.0133 12.06 0.0038 13.06 0.0026 14.04 0.0041 15.06 0.0053
   16.06 0.0014 17.08 0.0051 18.06 0.0048 19.07 0.0026 20.07 0.0025
   21.09 0.0039 22.08 0.0018 23.08 0.0031 24.11 0.0023 25.10 0.0035
   26.10 0.0037 27.10 0.0019 28.10 0.0030 29.11 0.0020 30.10 0.0036
   31.13 0.0020 32.10 0.0011 33.13 0.0013 34.12 0.0027 35.11 0.0022
   36.13 0.0018 37.15 0.0005 38.13 0.0002 39.17 0.0002 40.16 0.0006
   41.13 0.0002 43.16 0.0002 44.16 0.0002 45.15 0.0002 46.18 0.0003
   47.17 0.0001 48.18 0.0001 49.16 0.0002 50.19 0.0001 58.35 0.0001 ) constant c-ds2

'( 1.02 0.0293 2.00 0.1425 3.04 0.0549 4.03 0.0364 5.03 0.1171
   6.07 0.0100 7.04 0.0253 8.06 0.0448 9.08 0.0115 10.06 0.0116
   11.08 0.0048 12.09 0.0174 13.09 0.0037 14.11 0.0029 15.11 0.0104
   16.12 0.0036 17.14 0.0046 18.13 0.0016 19.16 0.0027 20.13 0.0036
   21.14 0.0012 22.18 0.0027 23.17 0.0011 24.18 0.0033 25.20 0.0019
   26.20 0.0016 26.99 0.0005 28.22 0.0009 29.19 0.0052 30.23 0.0021
   31.21 0.0015 32.24 0.0014 33.23 0.0019 34.22 0.0033 35.27 0.0009
   36.27 0.0002 38.30 0.0004 39.27 0.0005 40.26 0.0004 41.25 0.0003
   42.31 0.0002 43.34 0.0007 44.32 0.0006 45.32 0.0003 46.36 0.0002
   47.36 0.0001 48.34 0.0002 49.37 0.0002 54.40 0.0002 55.40 0.0001 ) constant c-e2

'( 0.99 0.0765 2.00 0.0311 3.02 0.0635 4.02 0.0223 5.15 0.0022
   6.01 0.0457 7.03 0.0278 8.04 0.0188 9.04 0.0344 10.02 0.0093
   11.00 0.0034 12.05 0.0172 13.06 0.0106 14.07 0.0020 15.02 0.0011
   16.06 0.0022 17.08 0.0027 18.08 0.0007 19.05 0.0016 20.07 0.0015
   21.07 0.0057 22.10 0.0010 23.07 0.0030 24.07 0.0013 25.07 0.0019
   26.09 0.0018 27.10 0.0042 28.10 0.0020 29.09 0.0015 30.12 0.0027
   31.11 0.0021 32.13 0.0035 33.08 0.0003 34.12 0.0005 35.12 0.0004
   36.15 0.0008 37.15 0.0003 39.14 0.0005 40.17 0.0003 41.15 0.0003
   42.14 0.0002 43.14 0.0001 44.17 0.0002 51.84 0.0001 53.18 0.0001
   54.22 0.0001 ) constant c-f2

'( 1.02 0.0680 2.02 0.0790 3.03 0.0722 4.03 0.0851 5.03 0.0169
   6.03 0.0073 7.02 0.0859 8.02 0.0250 9.04 0.0073 10.07 0.0037
   11.04 0.0035 12.01 0.0009 13.09 0.0056 14.05 0.0059 15.05 0.0031
   16.07 0.0050 17.07 0.0034 18.07 0.0010 19.47 0.0004 20.10 0.0045
   21.10 0.0028 22.09 0.0039 23.10 0.0032 24.11 0.0007 25.09 0.0017
   26.10 0.0041 27.16 0.0006 28.12 0.0021 29.13 0.0021 30.39 0.0004
   31.11 0.0013 32.17 0.0004 33.13 0.0005 34.14 0.0014 35.07 0.0002
   36.06 0.0001 37.16 0.0002 39.18 0.0007 40.18 0.0002 41.22 0.0001
   42.21 0.0002 43.24 0.0003 49.15 0.0001 51.22 0.0001 52.23 0.0002 ) constant c-fs2

'( 1.00 0.0434 2.00 0.0983 2.99 0.0548 3.98 0.0364 4.98 0.0228
   5.97 0.0390 6.97 0.0091 7.96 0.0154 9.03 0.0078 9.96 0.0174
   10.98 0.0110 11.96 0.0125 12.97 0.0039 13.94 0.0028 14.95 0.0057
   15.94 0.0020 16.95 0.0046 17.94 0.0011 18.97 0.0017 19.94 0.0010
   20.98 0.0025 21.94 0.0040 22.94 0.0030 23.91 0.0064 24.95 0.0013
   25.96 0.0009 26.94 0.0015 27.92 0.0014 28.93 0.0017 29.91 0.0015
   30.92 0.0010 31.49 0.0002 32.83 0.0002 33.89 0.0003 34.92 0.0002
   36.91 0.0003 37.91 0.0002 40.84 0.0002 41.87 0.0002 42.89 0.0002 ) constant c-g2

'( 0.98 0.0579 1.97 0.0445 2.97 0.1178 3.97 0.0806 4.96 0.1095
   5.94 0.0245 6.92 0.0203 7.91 0.0153 8.92 0.0186 9.93 0.0129
   10.92 0.0154 11.89 0.0040 12.87 0.0036 13.88 0.0033 14.74 0.0006
   15.85 0.0011 16.86 0.0020 17.85 0.0026 18.84 0.0040 19.84 0.0022
   20.83 0.0022 21.82 0.0020 22.80 0.0060 23.79 0.0073 24.81 0.0023
   25.80 0.0030 26.79 0.0008 27.77 0.0005 28.75 0.0012 29.73 0.0017
   30.75 0.0003 31.74 0.0005 32.74 0.0003 33.71 0.0003 34.70 0.0005
   35.72 0.0002 36.67 0.0003 38.69 0.0002 39.71 0.0002 40.65 0.0001 ) constant c-gs2

'( 0.99 0.0612 1.98 0.0094 2.98 0.0435 3.98 0.0098 4.97 0.0550
   5.97 0.0775 6.96 0.0337 7.96 0.0330 8.97 0.0137 9.95 0.0122
   10.95 0.0080 11.94 0.0082 13.00 0.0009 13.95 0.0034 14.96 0.0029
   15.94 0.0011 16.94 0.0041 17.95 0.0060 18.92 0.0008 19.97 0.0026
   20.94 0.0009 21.94 0.0041 22.92 0.0050 23.92 0.0056 24.93 0.0030
   25.92 0.0015 26.22 0.0002 27.90 0.0011 28.90 0.0004 29.89 0.0007
   30.89 0.0009 31.90 0.0004 32.91 0.0002 33.88 0.0005 34.86 0.0001
   35.89 0.0003 36.87 0.0006 37.89 0.0003 38.93 0.0002 46.84 0.0001
   54.82 0.0001 ) constant c-a2

'( 1.00 0.0401 1.99 0.0101 2.98 0.0769 3.96 0.0345 4.96 0.0696
   5.97 0.0342 6.95 0.0413 7.95 0.0130 8.92 0.0147 9.93 0.0034
   10.94 0.0135 11.94 0.0007 12.92 0.0013 13.91 0.0017 14.89 0.0026
   15.88 0.0019 16.89 0.0039 17.88 0.0034 18.86 0.0037 19.84 0.0009
   20.85 0.0021 21.86 0.0021 22.85 0.0049 23.82 0.0042 24.82 0.0007
   25.80 0.0007 26.82 0.0003 27.81 0.0004 28.79 0.0009 29.79 0.0007
   30.77 0.0005 31.18 0.0001 31.66 0.0001 32.76 0.0002 33.78 0.0002
   34.76 0.0004 35.75 0.0002 36.74 0.0002 ) constant c-as2

'( 1.00 0.0486 1.99 0.0621 2.98 0.0627 3.98 0.0145 4.98 0.0494
   5.97 0.0353 6.96 0.0287 7.96 0.0169 8.95 0.0167 9.95 0.0039
   10.94 0.0075 11.94 0.0043 12.95 0.0018 13.92 0.0040 14.94 0.0054
   15.93 0.0046 16.93 0.0035 17.92 0.0037 18.93 0.0036 19.91 0.0055
   20.89 0.0055 21.89 0.0058 22.89 0.0039 23.88 0.0005 24.87 0.0009
   25.87 0.0003 26.87 0.0007 27.78 0.0002 28.86 0.0004 29.86 0.0004
   30.85 0.0004 31.86 0.0001 32.83 0.0009 33.83 0.0003 34.82 0.0001
   37.81 0.0002 43.79 0.0001 48.71 0.0001 ) constant c-b2

'( 0.99 0.0486 1.98 0.1268 2.99 0.0920 3.98 0.0752 4.96 0.1515
   5.95 0.0086 6.97 0.0102 7.95 0.0108 8.95 0.0120 9.94 0.0034
   10.95 0.0029 11.94 0.0007 12.91 0.0029 13.92 0.0077 14.90 0.0028
   15.89 0.0027 16.90 0.0038 17.92 0.0034 18.87 0.0115 19.89 0.0039
   20.89 0.0023 21.86 0.0023 22.88 0.0008 23.88 0.0006 24.86 0.0004
   26.05 0.0002 26.84 0.0003 27.84 0.0005 28.84 0.0003 29.80 0.0004
   30.82 0.0007 31.58 0.0001 31.79 0.0001 32.52 0.0001 33.80 0.0001
   34.80 0.0001 39.78 0.0002 ) constant c-c3

'( 1.01 0.0839 1.99 0.0414 2.99 0.1265 4.00 0.0196 5.00 0.0377
   6.00 0.0117 6.99 0.0111 8.00 0.0151 9.00 0.0207 9.98 0.0033
   10.99 0.0090 11.99 0.0039 13.00 0.0039 14.01 0.0031 14.99 0.0038
   16.02 0.0023 17.00 0.0026 17.98 0.0069 19.00 0.0020 20.01 0.0017
   21.02 0.0007 22.02 0.0006 22.22 0.0002 22.93 0.0001 24.05 0.0003
   25.04 0.0002 25.99 0.0003 27.00 0.0003 29.03 0.0003 ) constant c-cs3

'( 1.01 0.1033 2.00 0.0588 3.00 0.0184 4.00 0.0725 5.00 0.0720
   6.01 0.0251 7.01 0.0292 8.02 0.0069 9.00 0.0094 10.00 0.0159
   11.02 0.0134 12.00 0.0008 13.01 0.0053 14.01 0.0204 15.01 0.0122
   16.02 0.0024 17.03 0.0044 18.02 0.0069 19.03 0.0043 20.01 0.0024
   21.02 0.0020 22.03 0.0006 23.03 0.0005 24.02 0.0006 25.01 0.0011
   26.01 0.0006 27.03 0.0007 28.04 0.0005 29.04 0.0003 30.02 0.0001
   31.03 0.0002 32.04 0.0003 36.02 0.0002 38.03 0.0001 39.06 0.0002
   40.01 0.0002 42.09 0.0001 43.08 0.0001 44.05 0.0002 ) constant c-d3

'( 1.01 0.1622 2.01 0.1721 3.02 0.0068 4.02 0.0256 5.03 0.0568
   6.02 0.0438 7.03 0.0061 8.04 0.0086 9.04 0.0050 10.06 0.0045
   11.07 0.0012 12.10 0.0025 13.08 0.0028 14.11 0.0014 15.07 0.0060
   16.07 0.0014 17.13 0.0026 18.08 0.0015 19.13 0.0007 20.13 0.0003
   21.15 0.0003 22.06 0.0004 23.10 0.0002 24.15 0.0001 25.12 0.0001
   26.16 0.0002 27.20 0.0001 ) constant c-ds3

'( 1.00 0.1620 2.01 0.0201 3.01 0.0224 4.02 0.0903 5.03 0.0425
   6.01 0.0323 7.02 0.0089 8.11 0.0023 9.02 0.0050 10.03 0.0055
   11.05 0.0038 12.04 0.0099 13.04 0.0062 14.03 0.0027 15.06 0.0040
   16.07 0.0035 17.07 0.0089 18.06 0.0013 19.05 0.0012 20.08 0.0004
   21.06 0.0008 22.09 0.0002 23.08 0.0008 24.09 0.0005 25.08 0.0006
   26.65 0.0001 27.13 0.0001 29.10 0.0002 30.10 0.0001 31.10 0.0002
   32.11 0.0001 35.12 0.0003 36.10 0.0002 37.15 0.0003 38.17 0.0001 ) constant c-e3

'( 0.99 0.0412 1.99 0.0398 2.99 0.1009 3.99 0.0605 4.97 0.0481
   5.96 0.0358 6.96 0.0065 7.83 0.0052 7.97 0.0050 8.95 0.0042
   9.94 0.0038 10.95 0.0044 11.94 0.0120 12.93 0.0044 13.92 0.0074
   14.92 0.0037 15.92 0.0030 16.92 0.0017 17.90 0.0021 18.90 0.0016
   19.89 0.0016 20.89 0.0002 22.86 0.0013 23.87 0.0014 24.87 0.0006
   25.86 0.0003 26.88 0.0001 29.84 0.0004 30.83 0.0002 31.82 0.0001
   32.83 0.0001 33.81 0.0001 34.81 0.0002 35.82 0.0003 37.80 0.0002 ) constant c-f3

'( 1.00 0.0386 2.00 0.0915 3.00 0.0406 4.01 0.0601 5.00 0.0460
   5.99 0.0213 7.01 0.0148 8.00 0.0085 9.00 0.0073 10.00 0.0017
   11.01 0.0191 12.00 0.0069 13.00 0.0057 14.02 0.0023 15.01 0.0059
   16.00 0.0010 17.02 0.0006 18.01 0.0019 19.00 0.0012 20.02 0.0002
   20.99 0.0004 22.01 0.0013 23.02 0.0007 24.02 0.0002 24.94 0.0001
   27.03 0.0001 28.02 0.0002 29.00 0.0001 31.01 0.0001 32.01 0.0001
   33.02 0.0003 34.03 0.0002 ) constant c-fs3

'( 1.01 0.0124 1.99 0.0359 2.98 0.0602 3.98 0.0390 4.98 0.0496
   5.98 0.0070 6.98 0.0121 7.97 0.0089 8.97 0.0044 9.97 0.0068
   10.97 0.0085 11.96 0.0110 12.95 0.0034 13.95 0.0099 14.95 0.0059
   15.95 0.0003 16.94 0.0014 17.94 0.0005 18.94 0.0008 19.95 0.0004
   20.94 0.0007 21.39 0.0001 22.95 0.0002 24.93 0.0001 25.92 0.0002
   27.91 0.0001 29.91 0.0005 30.94 0.0001 31.93 0.0002 33.90 0.0001 ) constant c-g3

'( 1.00 0.0509 1.99 0.1477 3.00 0.0407 4.00 0.0514 5.00 0.0367
   6.00 0.0032 7.02 0.0097 8.00 0.0090 9.07 0.0009 10.03 0.0069
   10.99 0.0020 12.03 0.0010 13.02 0.0019 14.06 0.0010 15.02 0.0010
   16.03 0.0008 17.03 0.0003 18.05 0.0002 18.98 0.0004 20.09 0.0002
   21.03 0.0001 28.01 0.0001 ) constant c-gs3

'( 1.00 0.0110 2.01 0.0315 3.02 0.1476 4.03 0.0358 5.01 0.0391
   6.02 0.0638 7.03 0.0692 8.02 0.0039 9.04 0.0218 10.04 0.0342
   11.05 0.0335 12.04 0.0187 13.05 0.0167 14.06 0.0168 15.06 0.0035
   16.07 0.0019 17.07 0.0014 18.08 0.0040 19.07 0.0070 20.08 0.0014
   21.09 0.0015 22.08 0.0003 23.10 0.0003 24.08 0.0011 25.10 0.0003
   26.12 0.0013 27.13 0.0009 28.13 0.0006 29.12 0.0003 30.11 0.0002
   31.13 0.0002 33.15 0.0002 34.13 0.0001 36.15 0.0001 41.16 0.0002
   44.18 0.0001 47.17 0.0001 ) constant c-a3

'( 1.00 0.0140 2.00 0.0411 3.00 0.0723 4.00 0.1057 5.00 0.0044
   6.00 0.0248 6.98 0.0048 8.00 0.0014 9.00 0.0304 9.99 0.0184
   10.99 0.0130 12.00 0.0159 13.00 0.0107 13.99 0.0021 15.00 0.0015
   15.99 0.0020 17.00 0.0028 18.00 0.0067 19.00 0.0005 20.04 0.0003
   21.00 0.0003 22.02 0.0001 23.98 0.0003 25.01 0.0007 26.01 0.0009
   27.00 0.0003 28.02 0.0002 28.98 0.0002 30.00 0.0002 31.01 0.0002
   32.01 0.0002 32.99 0.0003 33.99 0.0001 35.02 0.0002 37.00 0.0002
   38.98 0.0003 43.98 0.0001 44.99 0.0001 ) constant c-as3

'( 1.00 0.0648 2.00 0.0397 3.00 0.0872 4.01 0.0429 5.00 0.0213
   6.01 0.0524 7.00 0.0064 8.03 0.0162 9.02 0.0212 10.01 0.0175
   11.02 0.0256 12.03 0.0038 13.03 0.0039 14.04 0.0056 15.03 0.0008
   16.08 0.0005 17.03 0.0032 18.04 0.0010 19.04 0.0011 20.04 0.0002
   21.06 0.0010 22.05 0.0002 23.08 0.0011 24.09 0.0005 25.12 0.0003
   26.07 0.0002 27.03 0.0001 39.10 0.0002 ) constant c-b3

'( 1.00 0.0472 2.00 0.1961 3.00 0.1030 4.00 0.0974 5.00 0.0183
   6.00 0.0397 7.00 0.0158 8.00 0.0170 8.99 0.0253 10.00 0.0129
   10.99 0.0121 11.99 0.0103 12.98 0.0055 14.03 0.0004 14.99 0.0012
   15.99 0.0051 16.99 0.0009 17.99 0.0012 19.00 0.0004 19.98 0.0015
   21.02 0.0002 22.00 0.0009 22.99 0.0007 24.01 0.0004 25.00 0.0002
   26.00 0.0003 28.00 0.0002 28.97 0.0002 31.00 0.0002 32.98 0.0003
   33.98 0.0001 34.97 0.0001 35.98 0.0002 37.97 0.0002 38.97 0.0001 ) constant c-c4

'( 1.00 0.1199 2.00 0.0345 3.01 0.0978 4.00 0.0466 5.02 0.0070
   6.01 0.0258 7.02 0.0241 8.01 0.0070 9.02 0.0161 10.02 0.0124
   11.02 0.0145 12.02 0.0101 13.02 0.0026 14.03 0.0011 15.02 0.0028
   16.03 0.0011 17.04 0.0005 18.02 0.0003 19.05 0.0012 20.07 0.0004
   21.06 0.0011 22.06 0.0007 23.04 0.0007 24.05 0.0005 26.07 0.0003
   27.04 0.0002 28.05 0.0002 29.06 0.0001 32.05 0.0001 33.06 0.0002
   35.07 0.0002 36.07 0.0001 37.07 0.0002 ) constant c-cs4

'( 1.00 0.0657 2.00 0.0681 3.00 0.1031 3.99 0.0157 4.99 0.0570
   5.98 0.0160 6.99 0.0236 7.98 0.0259 8.99 0.0144 9.98 0.0154
   10.98 0.0046 11.97 0.0104 12.98 0.0024 13.97 0.0020 14.97 0.0012
   15.97 0.0010 16.97 0.0004 17.95 0.0008 18.97 0.0005 19.98 0.0007
   20.98 0.0009 21.93 0.0004 22.00 0.0003 22.94 0.0002 23.95 0.0002
   24.98 0.0001 25.97 0.0002 26.96 0.0001 28.94 0.0002 29.94 0.0002
   30.94 0.0002 32.97 0.0001 33.97 0.0001 34.95 0.0001 36.93 0.0001 ) constant c-d4

'( 1.00 0.3562 1.99 0.0664 2.99 0.1446 3.98 0.0393 4.97 0.0363
   5.97 0.0237 6.96 0.0366 7.95 0.0079 8.96 0.0127 9.95 0.0148
   10.95 0.0143 11.94 0.0031 12.96 0.0022 13.94 0.0032 14.92 0.0004
   15.92 0.0007 16.90 0.0007 17.92 0.0007 18.92 0.0012 19.94 0.0005
   20.89 0.0003 21.88 0.0001 22.89 0.0005 23.87 0.0004 24.87 0.0001
   25.89 0.0007 26.87 0.0001 29.85 0.0001 30.83 0.0001 31.82 0.0001
   32.82 0.0002 33.82 0.0001 ) constant c-ds4

'( 1.00 0.0390 2.01 0.1863 3.02 0.0265 4.02 0.0184 5.02 0.0319
   6.03 0.0456 7.04 0.0122 8.04 0.0149 9.05 0.0159 10.05 0.0067
   11.06 0.0044 12.06 0.0053 13.08 0.0012 14.08 0.0008 15.08 0.0007
   16.09 0.0021 17.09 0.0005 18.09 0.0021 19.13 0.0016 20.12 0.0004
   21.12 0.0003 22.14 0.0003 23.12 0.0003 24.13 0.0003 25.14 0.0005
   26.14 0.0002 27.15 0.0002 28.16 0.0002 29.18 0.0002 30.17 0.0002
   31.16 0.0002 36.21 0.0001 ) constant c-e4

'( 1.00 0.1183 1.99 0.1142 2.99 0.1085 3.98 0.0306 4.99 0.0252
   5.97 0.0272 6.97 0.0290 7.97 0.0142 8.97 0.0112 9.96 0.0079
   10.96 0.0038 11.97 0.0026 12.96 0.0014 13.95 0.0007 14.94 0.0011
   15.95 0.0008 16.94 0.0011 17.03 0.0001 17.94 0.0001 18.95 0.0004
   19.94 0.0003 20.94 0.0007 21.92 0.0002 23.92 0.0002 24.92 0.0002
   25.90 0.0002 26.90 0.0002 27.89 0.0001 28.89 0.0002 30.89 0.0001 ) constant c-f4

'( 1.00 0.1140 2.00 0.0935 3.00 0.0504 3.99 0.0715 4.99 0.0063
   6.00 0.0808 6.99 0.0099 8.00 0.0093 9.00 0.0093 9.99 0.0019
   10.99 0.0050 11.99 0.0017 12.99 0.0021 14.00 0.0003 14.99 0.0010
   16.00 0.0015 17.00 0.0019 17.95 0.0002 18.00 0.0002 18.99 0.0002
   19.99 0.0003 21.00 0.0002 21.99 0.0003 23.99 0.0001 24.98 0.0001
   26.02 0.0001 27.01 0.0001 28.00 0.0002 ) constant c-fs4

'( 1.00 0.0809 1.99 0.1377 2.99 0.0348 3.99 0.0337 4.98 0.0177
   5.98 0.0295 6.98 0.0266 7.98 0.0063 8.98 0.0105 9.97 0.0016
   10.97 0.0022 11.98 0.0029 12.97 0.0018 13.96 0.0008 14.99 0.0023
   15.97 0.0012 16.96 0.0009 17.97 0.0002 18.95 0.0006 20.94 0.0002
   20.99 0.0002 22.95 0.0002 23.94 0.0002 24.94 0.0003 25.97 0.0003
   26.95 0.0002 ) constant c-g4

'( 1.00 0.2601 1.99 0.1726 2.99 0.0722 3.99 0.0276 4.99 0.0535
   5.99 0.0103 6.99 0.0244 7.99 0.0046 8.98 0.0035 9.99 0.0088
   10.98 0.0038 11.98 0.0008 12.96 0.0006 13.98 0.0020 14.98 0.0016
   15.98 0.0008 16.97 0.0003 17.97 0.0005 18.98 0.0006 19.96 0.0005
   20.96 0.0001 21.96 0.0003 23.96 0.0002 24.96 0.0003 25.96 0.0002 ) constant c-gs4

'( 0.99 0.0363 1.98 0.2481 2.98 0.0514 3.97 0.0365 4.97 0.0468
   5.95 0.0182 6.95 0.0333 7.94 0.0106 8.93 0.0048 9.92 0.0048
   10.92 0.0016 11.90 0.0010 12.89 0.0011 13.92 0.0023 14.90 0.0014
   15.88 0.0007 16.87 0.0002 17.89 0.0001 18.85 0.0004 19.84 0.0002
   20.84 0.0003 21.84 0.0004 22.83 0.0003 23.86 0.0002 24.84 0.0002
   26.82 0.0001 ) constant c-a4

'( 0.99 0.0564 1.99 0.1983 2.98 0.0520 3.97 0.0442 4.97 0.0260
   5.96 0.0139 6.96 0.0099 7.94 0.0046 8.94 0.0178 9.94 0.0032
   10.93 0.0021 11.00 0.0002 11.93 0.0001 12.92 0.0038 13.91 0.0011
   14.90 0.0006 15.92 0.0004 16.89 0.0004 17.89 0.0002 18.87 0.0005
   19.87 0.0003 20.86 0.0003 21.85 0.0003 22.85 0.0001 23.85 0.0001
   24.85 0.0001 25.85 0.0002 26.84 0.0002 ) constant c-as4

'( 0.99 0.0774 1.98 0.1289 2.96 0.1071 3.95 0.0216 4.94 0.0346
   5.93 0.0108 6.91 0.0239 7.90 0.0056 8.88 0.0045 9.88 0.0014
   10.87 0.0057 11.85 0.0018 12.85 0.0035 13.83 0.0007 14.84 0.0003
   15.80 0.0003 16.79 0.0008 17.78 0.0003 18.78 0.0002 19.76 0.0004
   20.75 0.0005 21.73 0.0002 23.71 0.0001 24.68 0.0001 ) constant c-b4

'( 0.99 0.4933 1.97 0.1293 2.95 0.0971 4.92 0.0189 5.91 0.0031
   6.88 0.0093 7.87 0.0143 8.85 0.0063 9.84 0.0010 10.82 0.0023
   11.81 0.0015 12.79 0.0006 13.78 0.0009 14.76 0.0007 15.75 0.0004
   16.72 0.0007 17.71 0.0002 18.68 0.0008 19.67 0.0004 20.66 0.0003 ) constant c-c5

'( 0.99 0.1576 1.99 0.0760 2.98 0.0560 3.97 0.1172 4.96 0.0433
   5.96 0.0029 6.95 0.0079 7.95 0.0058 8.93 0.0025 9.93 0.0014
   10.93 0.0054 11.92 0.0005 12.92 0.0004 13.90 0.0009 14.90 0.0015
   15.89 0.0003 16.87 0.0002 17.87 0.0004 18.87 0.0002 19.86 0.0002
   20.86 0.0002 21.86 0.0003 22.85 0.0002 ) constant c-cs5

'( 1.01 0.1243 2.02 0.0648 3.03 0.0586 4.04 0.0543 5.05 0.0183
   6.07 0.0046 7.08 0.0080 8.09 0.0027 9.10 0.0053 10.12 0.0036
   11.14 0.0014 12.14 0.0004 13.16 0.0004 14.15 0.0007 15.17 0.0005
   17.20 0.0006 18.22 0.0002 19.22 0.0002 21.24 0.0001 ) constant c-d5

'( 1.01 0.1367 2.02 0.0170 3.02 0.0192 4.03 0.0425 5.04 0.0143
   6.05 0.0064 7.06 0.0057 8.06 0.0028 9.08 0.0027 10.09 0.0051
   11.09 0.0009 12.09 0.0001 13.10 0.0014 14.11 0.0005 15.13 0.0003
   16.13 0.0003 17.14 0.0002 19.15 0.0003 20.17 0.0004 21.17 0.0001 ) constant c-ds5

'( 1.02 0.2402 2.03 0.0419 3.05 0.1068 5.08 0.0164 6.10 0.0019
   7.11 0.0044 8.13 0.0018 9.15 0.0044 10.17 0.0021 11.18 0.0003
   12.20 0.0007 13.21 0.0011 14.24 0.0003 15.24 0.0008 16.27 0.0001
   17.28 0.0001 18.31 0.0001 ) constant c-e5

'( 1.01 0.1166 2.03 0.0750 3.04 0.0532 4.05 0.0620 5.06 0.0054
   6.07 0.0141 7.08 0.0027 8.10 0.0015 9.09 0.0021 10.13 0.0006
   11.13 0.0009 12.14 0.0004 13.15 0.0008 14.17 0.0003 15.18 0.0002
   17.19 0.0003 18.20 0.0002 ) constant c-f5

'( 1.00 0.1595 2.00 0.0985 3.01 0.1045 4.01 0.0147 5.01 0.0078
   6.01 0.0016 7.01 0.0020 8.02 0.0007 9.02 0.0015 10.03 0.0008
   11.03 0.0006 12.02 0.0004 13.02 0.0009 14.03 0.0006 15.02 0.0005
   16.03 0.0002 17.04 0.0001 ) constant c-fs5

'( 1.00 0.1740 1.99 0.0431 2.99 0.1899 3.99 0.0201 4.98 0.0009
   5.98 0.0031 6.98 0.0055 7.97 0.0051 8.97 0.0007 9.96 0.0007
   10.95 0.0006 11.95 0.0009 12.95 0.0008 13.96 0.0002 14.94 0.0001
   15.95 0.0002 ) constant c-g5

'( 1.00 0.1902 1.99 0.0327 2.98 0.0551 3.98 0.0157 4.97 0.0078
   5.97 0.0030 6.96 0.0035 7.96 0.0020 8.95 0.0017 9.94 0.0011
   10.94 0.0005 11.93 0.0007 12.93 0.0004 13.92 0.0002 14.93 0.0003 ) constant c-gs5

'( 0.99 0.4175 1.99 0.0209 2.98 0.0274 3.97 0.0220 4.96 0.0061
   5.96 0.0020 6.96 0.0038 7.95 0.0009 8.95 0.0014 9.93 0.0005
   10.93 0.0005 11.91 0.0007 12.91 0.0002 13.91 0.0001 14.91 0.0001 ) constant c-a5

'( 1.00 0.4648 2.00 0.0475 3.01 0.1268 4.01 0.0164 5.02 0.0035
   6.02 0.0018 7.02 0.0033 8.03 0.0028 9.03 0.0008 10.03 0.0006
   11.03 0.0005 12.04 0.0006 13.05 0.0003 14.04 0.0001 ) constant c-as5

'( 1.01 0.2812 2.02 0.1380 3.02 0.0722 4.03 0.0215 5.04 0.0036
   6.06 0.0018 7.05 0.0005 8.07 0.0015 9.08 0.0013 10.08 0.0003
   11.10 0.0002 12.11 0.0003 13.11 0.0002 ) constant c-b5

'( 1.01 0.2553 2.01 0.1160 3.02 0.0171 4.02 0.0272 5.02 0.0020
   6.03 0.0062 7.03 0.0012 8.04 0.0011 9.05 0.0007 10.05 0.0007
   11.06 0.0002 12.06 0.0001 12.08 0.0001 ) constant c-c6

'( 1.01 0.1045 2.02 0.1220 3.04 0.0220 4.05 0.0094 5.06 0.0021
   6.07 0.0031 7.09 0.0018 8.10 0.0020 9.11 0.0014 10.12 0.0003
   11.13 0.0006 ) constant c-cs6

'( 1.00 0.0653 1.99 0.2499 2.99 0.0334 3.98 0.0098 4.98 0.0091
   5.98 0.0007 6.97 0.0011 7.97 0.0008 8.96 0.0042 9.96 0.0003
   10.95 0.0004 ) constant c-d6

'( 0.99 0.0485 1.99 0.1325 2.98 0.0152 3.98 0.0064 4.97 0.0043
   5.97 0.0007 6.96 0.0007 7.97 0.0006 8.96 0.0003 9.95 0.0004 ) constant c-ds6

'( 1.01 0.1797 2.01 0.0750 4.03 0.0065 5.04 0.0018 6.04 0.0012
   7.04 0.0004 8.06 0.0003 9.06 0.0003 ) constant c-e6

\ **********************************************************
\ clarinet
\ **********************************************************

'( 1.01 0.1722 2.00 0.0056 2.99 0.1609 3.99 0.0333 5.00 0.1157
   5.99 0.1149 6.98 0.0079 7.98 0.0620 8.99 0.0601 9.99 0.0104
   10.98 0.0134 11.97 0.0122 12.99 0.0058 13.98 0.0110 14.98 0.0029
   15.97 0.0045 16.98 0.0023 17.98 0.0010 18.97 0.0016 19.96 0.0021
   20.96 0.0008 21.97 0.0021 22.96 0.0001 23.96 0.0012 24.95 0.0003
   25.97 0.0002 26.96 0.0003 27.95 0.0002 30.96 0.0002 32.94 0.0002
   34.96 0.0001 35.95 0.0002 37.93 0.0001 ) constant cl-d3

'( 0.99 0.1038 1.98 0.0043 2.96 0.0953 3.97 0.0013 4.94 0.1057
   5.93 0.0145 6.93 0.0787 7.91 0.0328 8.89 0.0086 9.90 0.0088
   10.88 0.0128 11.86 0.0005 12.86 0.0085 13.84 0.0026 14.83 0.0051
   15.81 0.0030 16.82 0.0008 17.79 0.0026 18.78 0.0013 19.78 0.0015
   20.76 0.0011 22.74 0.0012 23.72 0.0002 24.71 0.0006 25.70 0.0003
   26.70 0.0002 28.67 0.0002 30.64 0.0002 31.64 0.0001 32.63 0.0001
   33.61 0.0003 35.59 0.0002 ) constant cl-ds3

'( 1.00 0.0825 1.99 0.0024 2.97 0.0406 3.96 0.0042 4.94 0.0683
   6.40 0.0010 6.92 0.0709 7.92 0.0099 8.91 0.0059 9.89 0.0055
   10.88 0.0111 11.90 0.0009 12.86 0.0126 13.87 0.0021 14.84 0.0110
   15.83 0.0010 16.83 0.0057 17.81 0.0007 18.80 0.0037 19.78 0.0008
   20.78 0.0016 21.75 0.0006 22.75 0.0008 23.73 0.0005 24.74 0.0007
   26.72 0.0004 27.68 0.0002 29.67 0.0003 31.66 0.0003 33.64 0.0002 ) constant cl-e3

'( 0.99 0.0685 1.98 0.0012 2.98 0.0854 3.98 0.0029 4.96 0.0507
   5.97 0.0017 6.96 0.0507 7.94 0.0027 8.94 0.0092 9.94 0.0084
   10.92 0.0116 11.91 0.0018 12.92 0.0039 13.92 0.0003 14.89 0.0013
   15.88 0.0019 16.87 0.0012 17.86 0.0010 18.87 0.0011 19.86 0.0008
   20.85 0.0008 21.83 0.0002 23.81 0.0004 24.83 0.0002 25.80 0.0003
   27.78 0.0002 29.78 0.0001 ) constant cl-f3

'( 1.00 0.1546 1.99 0.0015 2.99 0.0594 4.00 0.0014 5.00 0.0268
   6.00 0.0019 7.00 0.0170 7.97 0.0005 9.00 0.0110 9.99 0.0006
   10.99 0.0077 11.99 0.0013 12.99 0.0025 14.01 0.0004 14.99 0.0018
   15.98 0.0001 16.98 0.0013 17.97 0.0003 18.98 0.0013 20.97 0.0001
   21.97 0.0004 22.96 0.0002 23.98 0.0002 25.99 0.0001 ) constant cl-fs3

'( 0.99 0.1660 2.00 0.0016 2.99 0.0889 3.99 0.0017 4.99 0.0430
   6.00 0.0009 6.98 0.0128 8.00 0.0040 8.98 0.0077 9.99 0.0017
   10.98 0.0052 11.98 0.0011 12.98 0.0012 13.97 0.0008 14.98 0.0010
   15.97 0.0005 16.98 0.0005 17.96 0.0007 18.97 0.0002 19.96 0.0004
   20.96 0.0003 22.94 0.0003 23.95 0.0002 24.96 0.0002 25.93 0.0001
   26.94 0.0002 27.95 0.0001 ) constant cl-g3

'( 1.00 0.1107 2.00 0.0016 2.99 0.0872 3.99 0.0028 4.98 0.0293
   5.97 0.0020 6.96 0.0202 7.99 0.0019 8.95 0.0118 9.94 0.0028
   10.95 0.0040 11.92 0.0006 12.95 0.0030 13.92 0.0002 14.92 0.0010
   15.91 0.0005 16.91 0.0015 18.90 0.0004 19.89 0.0004 20.89 0.0002
   21.88 0.0004 22.87 0.0002 23.88 0.0001 24.87 0.0001 ) constant cl-gs3

'( 1.00 0.0842 2.01 0.0017 3.00 0.0420 4.01 0.0029 5.00 0.0251
   6.02 0.0041 6.99 0.0115 7.96 0.0006 8.99 0.0032 9.98 0.0003
   11.00 0.0018 11.96 0.0003 12.96 0.0006 14.00 0.0001 14.97 0.0001
   15.97 0.0005 17.95 0.0002 18.96 0.0001 19.07 0.0001 22.06 0.0001 ) constant cl-a3

'( 1.00 0.1118 1.99 0.0006 2.98 0.0383 3.98 0.0019 4.98 0.0335
   5.98 0.0034 6.97 0.0131 7.94 0.0005 8.95 0.0024 9.96 0.0028
   10.96 0.0019 11.94 0.0012 12.94 0.0012 13.93 0.0003 14.94 0.0007
   16.92 0.0004 17.90 0.0003 18.93 0.0002 20.89 0.0002 21.90 0.0001 ) constant cl-as3

'( 1.00 0.1324 1.99 0.0011 3.00 0.0693 4.01 0.0012 4.99 0.0279
   5.98 0.0044 6.98 0.0149 7.97 0.0009 8.97 0.0028 9.97 0.0009
   10.98 0.0026 11.96 0.0003 12.96 0.0006 13.95 0.0003 15.95 0.0001
   16.94 0.0001 ) constant cl-b3

'( 1.00 0.2335 1.99 0.0017 2.99 0.1253 4.01 0.0023 4.99 0.0343
   6.01 0.0028 6.98 0.0023 7.98 0.0014 8.98 0.0041 10.01 0.0003
   10.96 0.0004 11.94 0.0008 12.94 0.0002 14.94 0.0003 15.94 0.0004
   16.93 0.0002 17.91 0.0002 18.91 0.0002 19.91 0.0001 20.90 0.0001 ) constant cl-c4

'( 0.99 0.2609 2.00 0.0016 2.99 0.1469 3.99 0.0040 4.99 0.0143
   5.97 0.0091 6.97 0.0055 7.97 0.0024 8.96 0.0041 9.96 0.0015
   10.96 0.0021 11.95 0.0005 12.94 0.0011 13.93 0.0004 14.94 0.0006
   15.94 0.0004 16.92 0.0004 17.93 0.0002 18.93 0.0001 19.91 0.0001
   20.91 0.0001 21.90 0.0002 22.91 0.0001 ) constant cl-cs4

'( 1.00 0.2056 1.99 0.0006 2.99 0.1715 3.99 0.0010 4.98 0.0194
   5.99 0.0028 6.98 0.0106 7.98 0.0007 8.97 0.0022 9.97 0.0005
   10.96 0.0011 11.97 0.0006 12.96 0.0006 13.96 0.0003 14.95 0.0005
   15.95 0.0003 17.95 0.0002 18.94 0.0002 20.94 0.0001 ) constant cl-d4

'( 1.00 0.2590 1.98 0.0019 2.99 0.1336 3.97 0.0034 4.97 0.0442
   5.97 0.0017 6.96 0.0108 7.96 0.0006 8.95 0.0031 9.94 0.0003
   11.93 0.0003 12.93 0.0004 13.93 0.0005 14.92 0.0001 15.91 0.0003
   16.90 0.0004 17.90 0.0002 18.89 0.0001 ) constant cl-ds4

'( 1.00 0.2560 2.00 0.0013 3.00 0.0878 4.00 0.0053 5.00 0.0304
   6.00 0.0009 7.00 0.0060 7.99 0.0007 9.00 0.0011 9.99 0.0006
   10.99 0.0006 11.98 0.0001 13.99 0.0001 ) constant cl-e4

'( 0.99 0.1966 1.99 0.0021 2.98 0.0812 3.96 0.0018 4.97 0.0248
   5.96 0.0032 6.96 0.0060 7.95 0.0024 8.95 0.0019 9.94 0.0008
   10.94 0.0007 11.92 0.0005 12.91 0.0002 13.94 0.0001 14.90 0.0002
   15.91 0.0002 ) constant cl-f4

'( 1.00 0.1555 2.01 0.0022 3.01 0.1755 4.01 0.0005 5.01 0.0127
   6.02 0.0004 7.02 0.0031 8.02 0.0007 9.02 0.0005 10.02 0.0002
   11.03 0.0003 12.02 0.0002 14.02 0.0001 15.03 0.0001 16.04 0.0001 ) constant cl-fs4

'( 1.00 0.0470 2.00 0.0016 3.00 0.0787 4.00 0.0041 5.00 0.0046
   6.00 0.0010 7.00 0.0036 8.00 0.0011 9.00 0.0012 10.00 0.0002
   11.00 0.0003 13.00 0.0001 ) constant cl-g4

'( 1.00 0.1205 1.99 0.0014 2.99 0.0145 3.99 0.0015 4.99 0.0030
   5.99 0.0005 6.98 0.0006 9.00 0.0001 9.98 0.0001 ) constant cl-gs4

'( 1.00 0.2677 2.00 0.0592 3.01 0.0961 4.01 0.0083 5.02 0.0075
   6.02 0.0027 7.03 0.0048 8.03 0.0031 9.02 0.0007 10.03 0.0003
   11.03 0.0001 ) constant cl-a4

'( 1.00 0.1363 2.01 0.0056 3.00 0.0168 4.01 0.0026 5.01 0.0112
   6.00 0.0011 7.01 0.0011 8.01 0.0003 10.00 0.0002 12.02 0.0001 ) constant cl-as4

'( 1.01 0.0312 2.01 0.0042 3.02 0.0061 4.02 0.0127 5.03 0.0090
   6.04 0.0002 7.04 0.0021 8.05 0.0008 11.06 0.0001 ) constant cl-b4

'( 1.00 0.2597 2.00 0.0052 3.00 0.0337 4.00 0.0012 5.00 0.0025
   6.00 0.0014 7.00 0.0007 7.99 0.0004 8.99 0.0003 10.00 0.0004 ) constant cl-c5

'( 1.00 0.1894 2.00 0.0060 3.00 0.0250 4.01 0.0022 5.01 0.0048
   6.00 0.0004 8.01 0.0001 10.01 0.0001 ) constant cl-cs5

'( 1.00 0.1727 2.01 0.0013 3.00 0.0066 4.01 0.0011 5.00 0.0013
   5.99 0.0008 8.02 0.0001 ) constant cl-d5

'( 1.00 0.3538 2.00 0.0053 3.01 0.0757 4.01 0.0009 5.01 0.0045
   6.02 0.0008 7.02 0.0011 8.01 0.0003 9.02 0.0005 10.01 0.0002
   11.02 0.0001 12.02 0.0002 ) constant cl-ds5

'( 1.00 0.1647 2.00 0.0048 3.00 0.0524 3.99 0.0055 4.99 0.0030
   5.98 0.0011 6.99 0.0004 7.99 0.0003 ) constant cl-e5

'( 0.99 0.1880 1.99 0.0126 2.99 0.0222 3.98 0.0070 4.98 0.0135
   5.97 0.0020 6.97 0.0012 7.96 0.0001 8.96 0.0007 9.95 0.0003 ) constant cl-f5

'( 1.00 0.3103 2.00 0.0104 3.00 0.0335 4.00 0.0078 5.00 0.0026
   6.01 0.0005 7.01 0.0006 8.00 0.0003 ) constant cl-fs5

'( 1.01 0.4163 2.01 0.0446 3.02 0.0290 4.03 0.0031 5.02 0.0004
   6.03 0.0002 7.05 0.0001 8.05 0.0001 ) constant cl-g5

'( 1.01 0.2150 2.00 0.0334 3.00 0.0012 4.02 0.0003 5.02 0.0002 ) constant cl-gs5

'( 1.01 0.5463 2.01 0.0429 3.02 0.0317 4.02 0.0159 5.03 0.0012
   6.04 0.0005 7.04 0.0005 8.05 0.0002 ) constant cl-a5

'( 1.00 0.3802 2.00 0.0397 3.01 0.0186 4.01 0.0102 5.01 0.0020
   6.01 0.0001 7.01 0.0002 8.02 0.0003 9.02 0.0002 10.02 0.0001
   11.02 0.0001 12.02 0.0002 ) constant cl-as5

'( 1.00 0.0896 2.00 0.0851 3.00 0.0081 4.00 0.0024 5.00 0.0010
   6.00 0.0001 7.00 0.0002 ) constant cl-b5

'( 1.00 0.1740 2.00 0.0081 3.01 0.0111 4.01 0.0087 5.01 0.0005
   6.01 0.0007 7.01 0.0001 9.01 0.0002 10.02 0.0002 ) constant cl-c6

'( 1.00 0.1295 1.99 0.0270 2.99 0.0012 3.99 0.0004 ) constant cl-cs6

'( 1.00 0.1700 2.01 0.0603 3.01 0.0169 4.01 0.0031 5.01 0.0007
   6.01 0.0002 ) constant cl-d6

'( 1.01 0.2624 2.02 0.0042 3.03 0.0049 4.03 0.0015 5.04 0.0001 ) constant cl-ds6

'( 1.02 0.0632 2.03 0.0115 3.04 0.0011 4.06 0.0006 ) constant cl-e6

'( 1.02 0.0748 2.03 0.0535 3.05 0.0044 4.07 0.0009 5.08 0.0001
   7.12 0.0001 8.13 0.0001 ) constant cl-f6

'( 1.02 0.0305 2.03 0.0175 3.04 0.0005 4.05 0.0002 ) constant cl-fs6

'( 1.03 0.0026 2.04 0.0008 ) constant cl-g6

'( 1.03 0.0015 2.00 0.0002 ) constant cl-gs6

'( 1.03 0.0043 2.05 0.0010 ) constant cl-a6

'( 1.05 0.0008 2.00 0.0001 ) constant cl-as6

\ **********************************************************
\ french horn
\ **********************************************************

'( 1.01 0.0041 2.00 0.0015 3.01 0.0121 4.02 0.0111 5.02 0.0343
   6.03 0.0165 7.04 0.0066 8.03 0.0064 9.05 0.0049 10.06 0.0012
   11.05 0.0093 12.07 0.0029 13.07 0.0042 14.08 0.0040 15.08 0.0019
   16.09 0.0013 17.10 0.0009 18.04 0.0002 19.03 0.0002 20.12 0.0003
   21.13 0.0003 22.13 0.0002 23.13 0.0002 ) constant fh-as1

'( 1.01 0.0035 2.03 0.0064 3.04 0.0087 4.08 0.0087 5.12 0.0049
   6.08 0.0189 7.10 0.0304 8.12 0.0205 9.16 0.0026 10.18 0.0039
   11.20 0.0006 12.11 0.0029 13.15 0.0037 14.24 0.0014 15.26 0.0010
   16.29 0.0005 17.19 0.0003 18.21 0.0007 19.23 0.0005 20.25 0.0004
   21.33 0.0003 22.36 0.0001 23.32 0.0002 24.33 0.0002 25.33 0.0001
   26.39 0.0002 27.42 0.0002 ) constant fh-b1

'( 1.02 0.0034 2.02 0.0059 3.01 0.0083 4.02 0.0274 5.03 0.0206
   6.03 0.0155 7.04 0.0131 8.03 0.0073 9.05 0.0014 10.03 0.0064
   11.05 0.0055 12.06 0.0109 13.08 0.0037 14.10 0.0012 15.10 0.0010
   16.01 0.0004 17.05 0.0009 18.06 0.0008 19.06 0.0006 20.09 0.0004
   21.11 0.0002 22.14 0.0002 23.09 0.0002 24.08 0.0001 25.08 0.0002
   26.07 0.0002 27.12 0.0002 28.16 0.0001 32.11 0.0001 ) constant fh-c2

'( 1.01 0.0038 1.99 0.0124 2.98 0.0065 4.00 0.0260 5.00 0.0138
   5.99 0.0093 6.97 0.0077 7.95 0.0055 8.97 0.0061 9.97 0.0016
   10.95 0.0034 11.96 0.0036 12.14 0.0010 12.94 0.0009 13.97 0.0008
   14.86 0.0004 15.89 0.0006 16.91 0.0007 17.93 0.0004 18.94 0.0002
   19.95 0.0001 20.77 0.0001 21.78 0.0002 22.86 0.0001 23.89 0.0002 ) constant fh-cs2

'( 1.01 0.0153 2.01 0.0192 3.01 0.0216 4.01 0.0371 5.01 0.0259
   6.02 0.0188 7.02 0.0076 8.04 0.0009 9.03 0.0038 10.03 0.0065
   11.03 0.0075 12.03 0.0026 13.03 0.0005 14.04 0.0009 15.06 0.0008
   16.04 0.0006 17.03 0.0004 18.03 0.0003 19.04 0.0002 23.03 0.0002 ) constant fh-d2

'( 1.00 0.0234 1.98 0.0227 2.96 0.0129 3.97 0.0333 4.96 0.0315
   5.95 0.0252 6.93 0.0076 7.94 0.0061 8.91 0.0028 9.89 0.0096
   10.90 0.0089 11.89 0.0024 12.88 0.0022 13.88 0.0019 14.87 0.0010
   15.79 0.0006 16.79 0.0003 17.79 0.0002 18.69 0.0002 19.68 0.0003
   20.70 0.0002 21.70 0.0002 ) constant fh-ds2

'( 1.00 0.0150 1.99 0.0230 3.01 0.0204 4.00 0.0298 5.02 0.0112
   6.03 0.0135 7.02 0.0019 8.03 0.0061 9.01 0.0099 10.04 0.0053
   11.03 0.0006 12.04 0.0028 13.04 0.0016 14.04 0.0015 15.03 0.0009
   16.02 0.0005 17.05 0.0002 20.02 0.0002 21.02 0.0001 24.00 0.0002
   25.03 0.0001 ) constant fh-e2

'( 0.97 0.0088 1.96 0.0127 2.97 0.0179 3.96 0.0163 4.94 0.0421
   5.91 0.0165 6.96 0.0019 7.93 0.0020 8.91 0.0112 9.85 0.0035
   10.91 0.0017 12.02 0.0004 12.83 0.0014 13.79 0.0010 14.79 0.0007
   15.75 0.0002 16.73 0.0003 17.74 0.0007 18.74 0.0005 19.73 0.0001
   20.68 0.0002 21.66 0.0002 22.65 0.0002 23.63 0.0001 24.65 0.0001 ) constant fh-f2

'( 1.00 0.0035 1.99 0.0136 2.97 0.0394 3.96 0.0379 4.98 0.0330
   5.97 0.0111 6.94 0.0156 7.94 0.0108 8.96 0.0076 9.95 0.0025
   10.95 0.0021 11.93 0.0026 12.93 0.0014 13.89 0.0008 14.87 0.0006
   15.78 0.0001 16.94 0.0001 17.93 0.0001 18.93 0.0001 19.89 0.0001 ) constant fh-fs2

'( 1.01 0.0150 2.01 0.0182 3.04 0.1047 4.04 0.0662 5.03 0.0448
   6.06 0.0018 7.06 0.0034 8.06 0.0202 9.09 0.0051 10.09 0.0070
   11.08 0.0060 12.11 0.0022 13.12 0.0011 14.13 0.0005 15.20 0.0001
   16.09 0.0002 17.14 0.0002 18.14 0.0002 19.14 0.0002 20.16 0.0002
   21.15 0.0001 22.15 0.0001 ) constant fh-g2

'( 0.99 0.0092 2.00 0.0177 3.00 0.0664 3.98 0.0447 4.99 0.0223
   5.99 0.0144 7.00 0.0124 7.97 0.0096 8.97 0.0046 9.96 0.0011
   10.99 0.0021 12.00 0.0010 12.99 0.0007 13.93 0.0007 14.92 0.0007
   15.94 0.0005 16.94 0.0003 17.90 0.0002 18.88 0.0001 19.87 0.0002
   20.86 0.0002 21.86 0.0001 ) constant fh-gs2

'( 1.00 0.0063 2.01 0.0609 3.03 0.0699 4.05 0.1365 5.04 0.0249
   6.05 0.0103 7.07 0.0200 8.08 0.0059 9.10 0.0063 10.09 0.0046
   11.10 0.0015 12.13 0.0008 13.14 0.0006 14.07 0.0004 15.05 0.0004
   16.08 0.0004 17.10 0.0002 18.12 0.0002 19.10 0.0001 ) constant fh-a2

'( 1.00 0.0026 2.02 0.0329 3.03 0.0926 4.04 0.0530 5.07 0.0041
   6.07 0.0072 7.09 0.0076 8.10 0.0053 9.11 0.0057 10.13 0.0017
   11.16 0.0005 12.21 0.0001 13.09 0.0003 14.11 0.0003 15.18 0.0003
   16.17 0.0001 ) constant fh-as2

'( 1.01 0.0154 2.02 0.0506 3.05 0.1042 4.05 0.0643 5.06 0.0151
   6.08 0.0102 7.09 0.0045 8.11 0.0040 9.12 0.0033 10.12 0.0015
   11.13 0.0006 12.16 0.0004 13.18 0.0003 14.95 0.0001 15.98 0.0001
   16.99 0.0001 18.02 0.0001 ) constant fh-b2

'( 1.01 0.0147 2.02 0.0897 3.01 0.1180 4.01 0.0323 5.02 0.0133
   6.04 0.0226 7.04 0.0033 8.06 0.0023 9.02 0.0019 10.03 0.0010
   11.04 0.0009 12.06 0.0003 13.04 0.0002 14.05 0.0002 15.05 0.0002
   16.01 0.0002 16.94 0.0001 ) constant fh-c3

'( 1.01 0.0345 2.00 0.1083 2.99 0.0911 4.01 0.0280 5.01 0.0071
   6.00 0.0123 7.00 0.0043 8.01 0.0034 9.01 0.0014 10.02 0.0004
   10.94 0.0003 11.96 0.0003 12.96 0.0002 14.89 0.0001 15.92 0.0001 ) constant fh-cs3

'( 1.01 0.0488 2.02 0.1313 3.03 0.1606 4.03 0.0029 5.04 0.0187
   6.05 0.0059 7.05 0.0018 8.05 0.0023 9.05 0.0007 10.06 0.0003
   11.07 0.0001 12.08 0.0002 ) constant fh-d3

'( 1.00 0.0619 2.00 0.1230 3.01 0.0981 4.02 0.0299 5.02 0.0210
   6.03 0.0054 7.03 0.0023 8.04 0.0010 9.04 0.0005 10.06 0.0002 ) constant fh-ds3

'( 1.00 0.0500 2.01 0.1076 3.03 0.1077 4.04 0.0167 5.03 0.0138
   6.06 0.0058 7.07 0.0036 8.06 0.0007 9.09 0.0004 10.07 0.0002
   11.03 0.0001 12.05 0.0002 ) constant fh-e3

'( 1.01 0.0368 2.02 0.1311 3.02 0.0405 4.03 0.0139 5.03 0.0080
   6.04 0.0052 7.05 0.0015 8.04 0.0004 9.06 0.0002 10.06 0.0002
   12.08 0.0001 ) constant fh-f3

'( 1.01 0.0430 2.02 0.1877 3.05 0.0299 4.05 0.0218 5.07 0.0067
   6.08 0.0054 7.10 0.0012 8.11 0.0010 9.12 0.0004 10.13 0.0002
   11.15 0.0001 ) constant fh-fs3

'( 1.01 0.0339 2.04 0.1965 4.07 0.0541 5.08 0.0113 6.10 0.0049
   7.10 0.0022 8.13 0.0014 9.14 0.0008 10.16 0.0005 ) constant fh-g3

'( 1.02 0.0596 2.02 0.1865 3.03 0.0629 4.04 0.0304 5.05 0.0087
   6.05 0.0035 7.07 0.0008 8.09 0.0004 9.09 0.0005 10.10 0.0005
   11.11 0.0002 12.12 0.0001 ) constant fh-gs3

'( 1.00 0.1160 2.02 0.2642 3.02 0.0259 4.02 0.0127 5.04 0.0095
   6.04 0.0022 7.04 0.0013 8.06 0.0008 9.04 0.0003 10.01 0.0001 ) constant fh-a3

'( 1.01 0.0585 2.01 0.1648 3.02 0.0229 4.02 0.0150 5.03 0.0084
   6.03 0.0016 7.06 0.0003 9.01 0.0002 ) constant fh-as3

'( 1.01 0.0741 2.00 0.1581 3.00 0.0490 4.01 0.0133 5.01 0.0045
   6.02 0.0013 7.03 0.0002 8.00 0.0001 ) constant fh-b3

'( 0.99 0.1378 2.00 0.0872 2.99 0.0736 3.99 0.0065 4.99 0.0025
   5.97 0.0009 6.98 0.0002 7.98 0.0005 8.98 0.0002 ) constant fh-c4

'( 1.01 0.2826 2.02 0.0676 3.02 0.0523 4.03 0.0208 5.04 0.0069
   6.04 0.0009 7.05 0.0009 8.06 0.0011 9.07 0.0004 10.07 0.0001
   11.08 0.0002 12.09 0.0001 ) constant fh-cs4

'( 1.01 0.2849 2.02 0.0068 3.03 0.0144 4.04 0.0066 5.05 0.0032
   6.07 0.0007 7.07 0.0003 8.09 0.0003 ) constant fh-d4

'( 1.00 0.2321 2.01 0.0612 3.02 0.0150 4.03 0.0042 5.03 0.0007
   6.04 0.0005 7.05 0.0002 8.06 0.0001 ) constant fh-ds4

'( 1.01 0.1701 2.01 0.0303 3.02 0.0156 4.03 0.0021 5.04 0.0009
   6.04 0.0003 7.04 0.0001 ) constant fh-e4

'( 1.01 0.1957 2.01 0.0196 3.01 0.0087 4.01 0.0022 5.01 0.0006
   6.02 0.0002 ) constant fh-f4

'( 1.01 0.3622 2.02 0.0601 3.03 0.0187 4.04 0.0043 5.05 0.0011
   6.06 0.0005 ) constant fh-fs4

'( 1.00 0.2782 2.01 0.0918 3.01 0.0080 4.03 0.0013 5.03 0.0010
   6.03 0.0003 ) constant fh-g4

'( 1.01 0.2703 2.02 0.0548 3.02 0.0083 4.03 0.0011 5.03 0.0009
   6.04 0.0003 ) constant fh-gs4

'( 1.01 0.4575 2.02 0.0245 3.03 0.0049 4.04 0.0019 5.05 0.0008
   6.06 0.0002 ) constant fh-a4

'( 1.00 0.2524 2.01 0.0291 3.02 0.0022 4.03 0.0011 5.03 0.0003 ) constant fh-as4

'( 1.00 0.3254 2.00 0.0428 3.00 0.0026 4.00 0.0006 ) constant fh-b4

'( 1.00 0.1672 2.00 0.0223 3.00 0.0010 4.00 0.0005 ) constant fh-c5

'( 1.00 0.1209 2.00 0.0340 3.00 0.0014 4.01 0.0004 ) constant fh-cs5

'( 1.01 0.0150 2.01 0.0313 3.02 0.0023 4.03 0.0007 ) constant fh-d5

'( 1.00 0.1633 2.00 0.0260 3.00 0.0012 4.00 0.0002 ) constant fh-ds5

'( 1.00 0.1001 2.00 0.0146 3.00 0.0019 4.00 0.0001 ) constant fh-e5

'( 1.01 0.0944 2.01 0.0114 3.02 0.0016 4.02 0.0002 ) constant fh-f5

'( 1.01 0.1904 2.02 0.0076 3.02 0.0025 4.03 0.0003 ) constant fh-fs5

'( 1.00 0.2511 2.00 0.0017 3.01 0.0010 4.01 0.0004 ) constant fh-g5

'( 1.00 0.1029 1.99 0.0050 2.99 0.0007 3.99 0.0002 ) constant fh-gs5

\ **********************************************************
\ 
\ **********************************************************

'( 1.01 0.0025 1.99 0.0008 3.01 0.0057 4.02 0.0063 5.03 0.0268
   6.04 0.0198 7.04 0.0157 8.03 0.0160 9.05 0.0056 10.05 0.0016
   11.06 0.0059 12.09 0.0009 13.10 0.0023 14.08 0.0022 15.09 0.0011
   16.10 0.0011 17.11 0.0012 18.16 0.0009 19.16 0.0008 20.15 0.0005
   21.16 0.0002 22.15 0.0001 23.15 0.0001 ) constant fhf-as1

'( 1.03 0.0025 2.07 0.0054 5.15 0.0276 6.18 0.0379 7.21 0.0389
   8.23 0.0176 9.26 0.0020 10.29 0.0039 11.24 0.0002 12.26 0.0010
   13.28 0.0015 14.34 0.0010 15.37 0.0009 16.42 0.0010 17.47 0.0027
   18.49 0.0015 19.52 0.0010 20.56 0.0005 21.57 0.0004 22.59 0.0004
   23.60 0.0003 24.61 0.0003 25.65 0.0002 26.67 0.0002 27.66 0.0001
   28.71 0.0002 29.75 0.0001 ) constant fhf-b1

'( 1.02 0.0023 2.03 0.0041 3.03 0.0059 4.05 0.0291 5.05 0.0280
   6.06 0.0396 7.06 0.0428 8.07 0.0111 9.08 0.0018 10.10 0.0049
   11.12 0.0052 12.12 0.0075 13.12 0.0021 14.15 0.0009 15.18 0.0008
   16.21 0.0009 17.22 0.0012 18.23 0.0008 19.23 0.0003 20.24 0.0003
   21.23 0.0002 22.22 0.0002 23.22 0.0002 24.25 0.0001 25.27 0.0002
   26.27 0.0001 28.25 0.0001 30.29 0.0001 32.31 0.0001 ) constant fhf-c2

'( 1.03 0.0031 2.02 0.0111 3.02 0.0074 4.01 0.0370 5.01 0.0307
   6.03 0.0330 7.03 0.0281 8.02 0.0089 9.02 0.0097 9.21 0.0016
   10.03 0.0014 11.04 0.0044 12.03 0.0039 12.96 0.0004 14.09 0.0011
   15.10 0.0006 16.10 0.0014 17.09 0.0011 18.09 0.0006 19.10 0.0005
   20.10 0.0004 21.08 0.0002 22.10 0.0003 22.28 0.0002 23.07 0.0001
   24.04 0.0002 25.09 0.0001 26.10 0.0001 27.10 0.0001 32.10 0.0001 ) constant fhf-cs2

'( 1.00 0.0154 2.01 0.0193 3.01 0.0257 4.00 0.0566 5.00 0.0570
   6.01 0.0680 7.01 0.0222 8.03 0.0023 9.02 0.0036 10.05 0.0043
   11.07 0.0037 12.07 0.0010 12.97 0.0005 13.99 0.0014 14.99 0.0022
   15.98 0.0023 16.97 0.0011 17.96 0.0007 18.95 0.0004 19.12 0.0003
   19.89 0.0002 20.92 0.0003 21.11 0.0002 21.92 0.0002 22.91 0.0002
   23.88 0.0002 24.92 0.0002 25.89 0.0003 26.88 0.0003 27.84 0.0001 ) constant fhf-d2

'( 1.00 0.0204 2.02 0.0234 3.03 0.0132 4.04 0.0416 5.05 0.0425
   6.04 0.0258 7.06 0.0086 8.07 0.0067 9.14 0.0009 10.17 0.0030
   11.20 0.0008 12.09 0.0016 13.11 0.0015 14.12 0.0029 15.11 0.0028
   16.11 0.0011 17.11 0.0006 18.09 0.0003 19.13 0.0004 19.29 0.0002
   20.10 0.0002 21.13 0.0002 21.29 0.0002 22.26 0.0001 23.11 0.0003
   24.11 0.0003 25.08 0.0002 26.10 0.0002 27.08 0.0002 28.10 0.0001
   28.28 0.0001 ) constant fhf-ds2

'( 1.00 0.0097 1.99 0.0146 3.00 0.0159 4.00 0.0246 5.02 0.0137
   6.06 0.0177 7.02 0.0017 8.05 0.0029 9.04 0.0058 10.06 0.0041
   10.96 0.0009 12.03 0.0029 13.08 0.0021 14.12 0.0008 15.14 0.0002
   16.11 0.0002 26.90 0.0001 ) constant fhf-e2

'( 1.00 0.0039 2.02 0.0070 3.04 0.0156 4.06 0.0113 5.08 0.0222
   6.07 0.0065 7.07 0.0046 8.12 0.0018 9.13 0.0081 10.13 0.0014
   11.17 0.0012 12.17 0.0014 13.21 0.0007 13.98 0.0005 14.24 0.0003
   14.98 0.0003 15.96 0.0002 17.21 0.0001 18.97 0.0002 20.02 0.0001
   21.05 0.0001 ) constant fhf-f2

'( 1.02 0.0030 2.03 0.0096 3.04 0.0372 4.06 0.0225 5.09 0.0048
   6.17 0.0019 7.19 0.0014 8.20 0.0014 9.19 0.0023 10.22 0.0008
   11.09 0.0003 12.23 0.0006 13.25 0.0004 14.25 0.0002 15.14 0.0001
   16.19 0.0002 17.20 0.0002 18.24 0.0002 19.23 0.0001 20.27 0.0001
   21.29 0.0001 23.26 0.0001 ) constant fhf-fs2

'( 1.03 0.0067 2.02 0.0055 3.06 0.0282 5.01 0.0043 5.20 0.0033
   6.05 0.0006 7.09 0.0009 8.13 0.0070 9.17 0.0006 10.20 0.0010
   11.23 0.0007 12.28 0.0002 13.16 0.0001 14.23 0.0001 ) constant fhf-g2

'( 0.99 0.0029 2.02 0.0054 3.01 0.0149 4.03 0.0101 5.03 0.0047
   6.02 0.0035 7.02 0.0028 8.04 0.0026 9.03 0.0010 10.03 0.0003
   11.07 0.0004 11.89 0.0001 12.98 0.0001 13.99 0.0002 ) constant fhf-gs2

'( 0.99 0.0020 2.00 0.0131 3.00 0.0085 4.01 0.0199 4.99 0.0044
   5.98 0.0020 7.00 0.0029 8.01 0.0009 9.02 0.0010 9.99 0.0007
   10.94 0.0003 ) constant fhf-a2

'( 1.00 0.0013 2.01 0.0042 3.01 0.0101 3.99 0.0132 4.98 0.0011
   5.97 0.0007 6.96 0.0031 7.99 0.0009 9.10 0.0003 9.99 0.0003
   10.92 0.0002 11.88 0.0002 12.85 0.0001 ) constant fhf-as2

'( 1.01 0.0038 2.00 0.0081 2.98 0.0138 3.96 0.0105 4.96 0.0021
   5.95 0.0034 6.89 0.0013 7.91 0.0006 8.86 0.0005 9.87 0.0001 ) constant fhf-b2

'( 1.00 0.0033 2.01 0.0162 3.00 0.0168 4.00 0.0069 5.00 0.0033
   6.01 0.0061 7.01 0.0006 8.01 0.0003 8.98 0.0003 9.97 0.0002
   10.98 0.0001 ) constant fhf-c3

'( 1.01 0.0161 2.01 0.0404 3.01 0.0208 4.02 0.0039 5.02 0.0013
   6.02 0.0041 7.02 0.0019 8.01 0.0011 9.01 0.0003 ) constant fhf-cs3

'( 1.01 0.0238 2.01 0.0582 3.02 0.0679 4.02 0.0022 5.03 0.0081
   6.03 0.0024 7.03 0.0012 8.05 0.0010 9.05 0.0001 10.08 0.0001 ) constant fhf-d3

'( 1.00 0.0295 2.01 0.0519 3.02 0.0343 4.04 0.0119 5.05 0.0067
   6.07 0.0011 7.08 0.0013 8.09 0.0004 ) constant fhf-ds3 

'( 1.01 0.0251 2.04 0.0479 3.03 0.0741 4.04 0.0054 5.05 0.0049
   6.04 0.0029 7.06 0.0021 8.10 0.0006 9.11 0.0004 10.10 0.0002
   11.13 0.0002 ) constant fhf-e3

'( 1.02 0.0143 2.02 0.0453 3.04 0.0115 4.05 0.0021 5.08 0.0007
   6.10 0.0007 7.07 0.0006 8.04 0.0001 ) constant fhf-f3

'( 1.01 0.0220 2.03 0.0843 3.04 0.0119 4.06 0.0062 5.09 0.0022
   6.12 0.0016 7.14 0.0003 9.13 0.0001 ) constant fhf-fs3

'( 1.02 0.0145 2.03 0.0700 3.03 0.0010 5.13 0.0013 6.14 0.0007
   7.14 0.0002 ) constant fhf-g3

'( 1.02 0.0273 2.03 0.0703 3.04 0.0176 4.07 0.0073 5.08 0.0021
   6.09 0.0004 7.09 0.0002 8.09 0.0001 ) constant fhf-gs3

'( 1.00 0.0529 2.02 0.0982 3.02 0.0066 4.04 0.0034 5.05 0.0029
   6.04 0.0003 7.03 0.0002 ) constant fhf-a3a

'( 1.01 0.0274 2.01 0.0613 3.02 0.0056 4.03 0.0056 5.03 0.0024
   6.03 0.0003 ) constant fhf-as3

'( 1.01 0.0468 2.01 0.0884 3.01 0.0246 4.02 0.0058 5.03 0.0016
   6.03 0.0005 7.02 0.0002 8.01 0.0001 ) constant fhf-b3

'( 1.01 0.0972 2.01 0.0455 3.02 0.0442 4.03 0.0073 5.03 0.0017
   6.03 0.0005 7.04 0.0008 8.05 0.0003 9.05 0.0001 ) constant fhf-c4

'( 1.01 0.1452 2.01 0.0382 3.02 0.0285 4.02 0.0080 5.02 0.0019
   6.01 0.0002 7.03 0.0003 8.04 0.0002 ) constant fhf-cs4

'( 1.01 0.1930 2.02 0.0066 3.03 0.0070 4.05 0.0041 5.05 0.0016
   6.07 0.0003 ) constant fhf-d4

'( 1.00 0.1433 2.01 0.0414 3.02 0.0101 4.03 0.0020 5.02 0.0002
   6.03 0.0003 7.06 0.0001 ) constant fhf-ds4

'( 1.00 0.1373 2.01 0.0256 3.01 0.0164 4.02 0.0026 5.02 0.0014
   6.02 0.0004 7.03 0.0002 ) constant fhf-e4

'( 1.01 0.1930 2.01 0.0192 3.02 0.0124 4.02 0.0030 5.03 0.0013
   6.03 0.0006 7.03 0.0002 ) constant fhf-f4

'( 1.01 0.2352 2.01 0.0485 3.02 0.0135 4.03 0.0035 5.03 0.0010
   6.04 0.0004 ) constant fhf-fs4

'( 1.01 0.1991 2.03 0.0655 3.04 0.0065 4.04 0.0015 5.06 0.0006
   6.07 0.0002 ) constant fhf-g4

'( 1.01 0.2177 2.02 0.0422 3.03 0.0038 4.05 0.0014 5.06 0.0006 ) constant fhf-gs4

'( 1.01 0.3779 2.02 0.0161 3.03 0.0026 4.04 0.0009 5.05 0.0005 ) constant fhf-a4

'( 1.00 0.1879 2.01 0.0205 3.02 0.0006 4.03 0.0006 ) constant fhf-as4

'( 0.99 0.2910 1.99 0.0363 2.99 0.0019 3.99 0.0001 4.98 0.0001 ) constant fhf-b4

'( 1.00 0.0690 2.01 0.0086 3.01 0.0002 4.00 0.0002 ) constant fhf-c5

'( 1.01 0.0872 2.02 0.0247 3.03 0.0008 4.05 0.0002 ) constant fhf-cs5

'( 1.01 0.0213 2.02 0.0275 3.03 0.0031 4.04 0.0008 5.05 0.0002
   6.07 0.0001 ) constant fhf-d5

'( 1.01 0.1852 2.01 0.0224 3.01 0.0043 4.02 0.0006 5.03 0.0001 ) constant fhf-ds5

'( 1.01 0.1063 2.02 0.0144 3.03 0.0018 4.04 0.0006 5.05 0.0001 ) constant fhf-e5

'( 1.02 0.1058 2.04 0.0062 3.06 0.0023 4.08 0.0005 ) constant fhf-f5

'( 1.01 0.1683 2.03 0.0099 3.04 0.0026 4.05 0.0004 5.07 0.0003 ) constant fhf-fs5

'( 1.01 0.3271 2.02 0.0090 3.03 0.0022 4.04 0.0007 ) constant fhf-g5

\ **********************************************************
\ flute
\ **********************************************************

'( 1.01 0.0602 2.02 0.0954 3.03 0.0270 4.03 0.0199 5.05 0.0177
   6.06 0.0104 7.07 0.0040 8.08 0.0040 9.08 0.0035 10.10 0.0017
   11.10 0.0009 12.12 0.0004 13.11 0.0002 14.13 0.0006 15.14 0.0003
   17.15 0.0002 18.16 0.0001 ) constant fl-c4

'( 1.01 0.0672 2.01 0.0689 3.02 0.0604 4.02 0.0410 5.02 0.0130
   6.03 0.0040 7.03 0.0210 8.03 0.0078 9.04 0.0010 10.07 0.0002
   11.05 0.0005 12.05 0.0008 13.05 0.0004 14.06 0.0002 15.07 0.0001
   19.08 0.0001 ) constant fl-cs4

'( 1.01 0.0747 2.01 0.2106 3.01 0.0522 4.02 0.0208 5.01 0.0138
   6.02 0.0024 7.03 0.0071 8.03 0.0038 8.17 0.0002 8.74 0.0001
   10.03 0.0004 11.04 0.0014 12.03 0.0001 13.06 0.0002 14.05 0.0003
   15.06 0.0001 16.07 0.0001 17.06 0.0002 18.06 0.0002 ) constant fl-d4

'( 1.00 0.0256 2.00 0.1167 3.00 0.0241 4.01 0.0159 5.01 0.0200
   6.00 0.0167 7.01 0.0069 8.04 0.0004 9.00 0.0009 10.01 0.0010
   11.00 0.0004 12.00 0.0003 13.00 0.0002 14.01 0.0002 16.00 0.0002
   17.01 0.0002 ) constant fl-ds4

'( 1.00 0.0572 2.01 0.1769 3.01 0.0622 4.00 0.0323 5.01 0.0210
   6.01 0.0163 7.02 0.0068 8.01 0.0007 8.13 0.0002 8.39 0.0001
   10.02 0.0011 11.02 0.0004 12.02 0.0003 15.03 0.0002 16.03 0.0001
   17.04 0.0001 18.04 0.0001 ) constant fl-e4

'( 1.01 0.0438 2.01 0.0964 3.01 0.0569 4.01 0.0096 5.01 0.0164
   6.01 0.0194 7.02 0.0024 8.01 0.0005 9.03 0.0007 10.04 0.0005
   12.05 0.0002 13.04 0.0001 14.05 0.0002 ) constant fl-f4

'( 1.00 0.0952 2.00 0.1432 3.01 0.0299 4.01 0.0371 5.02 0.0189
   6.02 0.0092 7.03 0.0060 8.03 0.0003 9.04 0.0025 10.04 0.0006
   11.04 0.0003 13.05 0.0002 14.06 0.0002 ) constant fl-fs4

'( 1.00 0.2831 2.01 0.1781 3.01 0.0370 4.02 0.0191 5.02 0.0313
   6.02 0.0048 7.04 0.0007 8.03 0.0022 9.04 0.0015 9.13 0.0001
   10.04 0.0001 11.05 0.0002 12.05 0.0002 14.07 0.0001 15.06 0.0001 ) constant fl-g4

'( 1.00 0.2598 2.00 0.2241 3.01 0.0407 4.01 0.0354 5.01 0.0398
   6.01 0.0111 7.03 0.0007 8.01 0.0030 9.01 0.0018 10.02 0.0002
   12.02 0.0004 13.02 0.0001 14.03 0.0002 15.03 0.0001 ) constant fl-gs4

'( 1.00 0.2580 2.01 0.1605 3.00 0.0236 4.01 0.0281 5.02 0.0047
   6.02 0.0024 7.02 0.0010 8.02 0.0027 9.02 0.0004 10.03 0.0002
   11.03 0.0003 12.04 0.0001 13.04 0.0002 14.04 0.0002 ) constant fl-a4

'( 1.01 0.1855 2.01 0.1041 3.01 0.0480 4.02 0.0416 5.02 0.0059
   6.02 0.0016 7.03 0.0004 8.03 0.0016 9.03 0.0003 10.04 0.0004
   11.05 0.0003 16.07 0.0002 ) constant fl-as4

'( 1.01 0.0564 2.01 0.1996 3.02 0.0219 4.02 0.0108 5.03 0.0183
   6.04 0.0005 7.04 0.0009 8.05 0.0014 10.06 0.0006 11.07 0.0003 ) constant fl-b4

'( 1.01 0.0245 2.02 0.1674 3.04 0.0228 4.05 0.0229 5.06 0.0087
   6.09 0.0004 7.09 0.0004 8.10 0.0003 9.11 0.0002 10.14 0.0002
   11.15 0.0001 ) constant fl-c5

'( 1.00 0.0885 2.01 0.0661 3.01 0.0281 4.02 0.0068 5.02 0.0038
   6.02 0.0010 7.02 0.0008 8.03 0.0007 9.03 0.0005 10.04 0.0002
   11.04 0.0003 ) constant fl-cs5

'( 1.01 0.3830 2.01 0.1043 3.01 0.0372 4.02 0.0175 5.03 0.0035
   6.03 0.0011 7.04 0.0010 8.04 0.0004 9.04 0.0002 10.05 0.0001 ) constant fl-d5

'( 1.00 0.2294 2.01 0.0606 3.01 0.0238 4.01 0.0050 5.01 0.0041
   6.02 0.0007 7.02 0.0007 8.02 0.0006 10.03 0.0002 12.03 0.0001 ) constant fl-ds5

'( 1.01 0.3759 2.03 0.0529 3.03 0.0595 4.05 0.0010 5.06 0.0077
   6.07 0.0008 7.09 0.0007 8.09 0.0005 9.11 0.0001 10.12 0.0002
   12.14 0.0001 ) constant fl-e5

'( 1.01 0.1982 2.02 0.0204 3.02 0.0554 4.03 0.0064 5.04 0.0040
   6.05 0.0016 7.06 0.0007 8.07 0.0006 9.07 0.0001 10.08 0.0001
   12.10 0.0001 ) constant fl-f5

'( 1.01 0.3241 2.02 0.0548 3.03 0.0082 4.04 0.0022 5.05 0.0038
   6.06 0.0004 7.07 0.0009 8.09 0.0001 9.09 0.0003 10.10 0.0001 ) constant fl-fs5

'( 1.01 0.4049 2.01 0.0301 3.02 0.0229 4.03 0.0047 5.04 0.0029
   6.05 0.0014 7.05 0.0009 8.06 0.0003 9.07 0.0002 10.07 0.0002
   11.09 0.0001 12.09 0.0001 ) constant fl-g5

'( 1.00 0.5433 2.01 0.0536 3.01 0.0411 4.02 0.0074 5.02 0.0014
   6.02 0.0011 7.03 0.0004 8.03 0.0003 9.04 0.0001 ) constant fl-gs5

'( 1.01 0.3063 2.01 0.0346 3.02 0.0102 4.03 0.0031 5.03 0.0007
   6.04 0.0010 7.03 0.0003 8.06 0.0001 9.05 0.0002 11.06 0.0002 ) constant fl-a5

'( 1.01 0.1962 2.03 0.0355 3.04 0.0128 4.06 0.0020 5.07 0.0021
   6.08 0.0003 7.10 0.0003 8.11 0.0002 ) constant fl-as5

'( 1.01 0.3829 2.02 0.0120 3.03 0.0037 4.04 0.0030 5.05 0.0016
   6.06 0.0006 7.07 0.0002 8.08 0.0004 9.09 0.0001 ) constant fl-b5

'( 1.01 0.3072 2.02 0.0248 3.04 0.0012 4.05 0.0006 5.06 0.0011
   6.07 0.0009 7.08 0.0003 8.10 0.0001 10.12 0.0001 ) constant fl-c6

'( 1.01 0.1262 2.02 0.0030 3.03 0.0012 4.04 0.0005 5.06 0.0010
   6.07 0.0002 7.08 0.0004 8.09 0.0002 ) constant fl-cs6

'( 1.01 0.3050 2.03 0.0071 3.04 0.0107 4.06 0.0005 5.07 0.0015
   6.08 0.0002 7.10 0.0003 8.11 0.0002 9.13 0.0001 ) constant fl-d6

'( 1.02 0.0954 2.05 0.0025 3.06 0.0047 4.09 0.0007 5.11 0.0017
   6.13 0.0001 7.15 0.0002 ) constant fl-ds6

'( 1.02 0.2864 2.05 0.0057 3.08 0.0023 5.13 0.0007 6.16 0.0001
   8.21 0.0001 ) constant fl-e6

'( 1.03 0.0675 2.05 0.0049 3.08 0.0024 5.13 0.0008 6.16 0.0002
   7.18 0.0002 8.21 0.0001 ) constant fl-f6

'( 1.02 0.2553 2.05 0.0044 3.07 0.0032 5.12 0.0007 6.14 0.0002
   8.19 0.0001 ) constant fl-fs6

'( 1.02 0.1190 2.05 0.0069 3.07 0.0046 5.12 0.0010 6.14 0.0001
   7.17 0.0007 7.26 0.0001 ) constant fl-g6

'( 1.02 0.3872 2.05 0.0093 3.07 0.0051 5.12 0.0008 6.15 0.0001
   7.17 0.0002 7.18 0.0001 ) constant fl-gs6

'( 1.02 0.2920 2.04 0.0122 3.06 0.0052 4.08 0.0007 5.10 0.0003
   6.31 0.0002 7.15 0.0003 ) constant fl-a6

'( 1.02 0.5687 2.04 0.0090 3.06 0.0075 4.08 0.0007 5.10 0.0010
   6.15 0.0002 6.21 0.0002 6.40 0.0001 6.47 0.0001 ) constant fl-as6

'( 1.03 0.2752 2.06 0.0061 3.09 0.0039 5.14 0.0002 5.86 0.0002
   6.18 0.0001 6.24 0.0001 6.45 0.0001 ) constant fl-b6

'( 1.04 0.2720 2.07 0.0046 5.18 0.0003 5.40 0.0002 6.02 0.0002 ) constant fl-c7

'( 1.03 0.3752 2.06 0.0156 5.16 0.0007 5.20 0.0003 5.40 0.0001
   5.41 0.0001 5.57 0.0001 ) constant fl-cs7

'( 1.04 0.2861 2.07 0.0147 5.18 0.0012 5.27 0.0002 5.30 0.0001 ) constant fl-d7

\ **********************************************************
\ oboe
\ **********************************************************

'( 1.00 0.0504 2.00 0.0724 2.99 0.1036 3.99 0.1215 4.99 0.1360
   5.99 0.0852 6.98 0.0593 7.97 0.0230 8.98 0.0077 9.97 0.0063
   10.97 0.0016 11.96 0.0008 12.97 0.0017 13.97 0.0017 14.96 0.0020
   15.96 0.0007 16.96 0.0006 17.96 0.0002 21.95 0.0001 22.95 0.0001
   23.94 0.0002 24.94 0.0002 25.94 0.0001 ) constant ob-as3

'( 0.99 0.0587 1.99 0.0820 2.98 0.0673 3.98 0.1069 4.97 0.1336
   5.97 0.0948 6.96 0.0455 7.96 0.0070 8.95 0.0017 9.95 0.0023
   10.95 0.0063 11.93 0.0031 12.93 0.0021 13.92 0.0009 14.92 0.0005
   15.92 0.0003 16.89 0.0001 21.88 0.0001 23.88 0.0001 ) constant ob-b3

'( 1.00 0.0784 2.00 0.0494 2.99 0.0668 3.99 0.0785 4.99 0.1406
   5.99 0.0747 6.99 0.0460 7.98 0.0147 8.98 0.0115 9.97 0.0083
   10.98 0.0058 11.98 0.0059 12.97 0.0027 13.98 0.0010 14.96 0.0006
   15.97 0.0002 16.96 0.0001 17.96 0.0002 19.95 0.0001 20.96 0.0002
   21.95 0.0001 ) constant ob-c4

'( 1.00 0.0801 2.00 0.0526 2.99 0.0568 3.99 0.0713 4.99 0.1811
   5.99 0.0721 6.99 0.0491 7.98 0.0201 8.98 0.0128 9.98 0.0132
   10.98 0.0104 11.98 0.0081 12.97 0.0055 13.97 0.0026 14.97 0.0010
   15.97 0.0003 16.97 0.0004 17.96 0.0003 18.97 0.0004 19.95 0.0006
   20.96 0.0003 21.96 0.0002 ) constant ob-cs4

'( 1.00 0.0775 2.00 0.0853 3.01 0.0538 4.01 0.0600 5.00 0.1853
   6.01 0.0714 7.01 0.0247 8.01 0.0265 9.01 0.0028 10.01 0.0116
   11.02 0.0078 12.02 0.0060 13.01 0.0036 14.02 0.0010 15.03 0.0005
   16.01 0.0002 17.02 0.0002 18.01 0.0004 19.02 0.0004 20.02 0.0002
   21.02 0.0001 ) constant ob-d4

'( 1.00 0.0922 1.99 0.0922 2.99 0.0912 3.99 0.0337 4.98 0.1696
   5.97 0.0481 6.98 0.0184 7.97 0.0104 8.96 0.0185 9.96 0.0147
   10.96 0.0057 11.95 0.0039 12.95 0.0012 13.94 0.0006 14.94 0.0009
   15.94 0.0005 16.93 0.0005 17.93 0.0003 18.93 0.0001 19.92 0.0001 ) constant ob-ds4

'( 1.00 0.0970 2.01 0.0554 3.01 0.0624 4.02 0.1806 5.02 0.1392
   6.02 0.0367 7.03 0.0165 8.04 0.0102 9.04 0.0159 10.04 0.0077
   11.04 0.0092 12.05 0.0027 13.06 0.0004 14.06 0.0007 15.06 0.0003
   16.07 0.0006 17.07 0.0003 18.08 0.0003 19.08 0.0001 20.09 0.0002 ) constant ob-e4

'( 1.00 0.0988 2.01 0.0364 3.00 0.0573 4.01 0.2291 5.01 0.0802
   6.02 0.0188 7.02 0.0160 8.02 0.0143 9.02 0.0152 10.02 0.0140
   11.03 0.0054 12.01 0.0003 13.03 0.0012 14.03 0.0008 15.04 0.0008
   16.04 0.0006 17.04 0.0006 18.04 0.0003 19.05 0.0001 ) constant ob-f4

'( 1.01 0.0340 2.01 0.0618 3.02 0.0923 4.03 0.1479 5.03 0.1058
   6.04 0.0281 7.05 0.0071 8.05 0.0157 9.06 0.0018 10.07 0.0014
   11.07 0.0005 12.08 0.0013 13.09 0.0012 14.10 0.0005 15.10 0.0003
   16.11 0.0005 17.12 0.0002 ) constant ob-fs4

'( 1.01 0.0606 2.01 0.0774 3.02 0.0552 4.03 0.0700 5.04 0.0194
   6.04 0.0066 7.05 0.0147 8.06 0.0134 9.07 0.0055 10.08 0.0035
   11.08 0.0004 12.10 0.0004 13.10 0.0008 14.11 0.0011 15.10 0.0004 ) constant ob-g4

'( 1.01 0.0573 2.01 0.0346 3.03 0.0608 4.03 0.0675 5.04 0.0643
   6.05 0.0193 7.06 0.0125 8.07 0.0109 9.07 0.0010 10.09 0.0003
   11.09 0.0016 12.10 0.0015 13.11 0.0006 14.11 0.0003 15.13 0.0002
   16.13 0.0002 ) constant ob-gs4

'( 1.00 0.0923 2.00 0.0358 3.00 0.0726 4.00 0.2111 5.00 0.0316
   5.99 0.0016 7.00 0.0080 8.00 0.0075 9.00 0.0031 10.01 0.0007
   11.01 0.0008 12.00 0.0005 13.00 0.0003 14.01 0.0005 15.01 0.0001 ) constant ob-a4

'( 1.00 0.0753 2.00 0.0693 3.00 0.3731 4.01 0.0810 5.01 0.0245
   6.00 0.0142 7.00 0.0061 8.01 0.0025 9.01 0.0004 10.01 0.0005
   11.01 0.0005 12.02 0.0005 13.02 0.0003 ) constant ob-as4

'( 1.00 0.0618 2.01 0.0377 3.02 0.0642 4.02 0.0401 5.02 0.0165
   6.03 0.0176 7.03 0.0079 8.04 0.0016 9.04 0.0003 10.06 0.0003
   11.05 0.0006 12.06 0.0003 13.06 0.0001 ) constant ob-b4

'( 1.01 0.0484 2.02 0.0490 3.02 0.0364 4.03 0.0166 5.03 0.0172
   6.04 0.0261 7.05 0.0120 8.06 0.0021 9.06 0.0035 10.07 0.0021
   11.08 0.0008 12.08 0.0003 ) constant ob-c5

'( 1.01 0.1071 2.02 0.0487 3.03 0.1175 4.04 0.0329 5.05 0.0231
   6.06 0.0136 7.07 0.0047 8.07 0.0009 9.09 0.0011 10.10 0.0016
   11.10 0.0010 12.12 0.0002 ) constant ob-cs5

'( 1.01 0.1893 2.01 0.0986 3.02 0.1665 4.02 0.0326 5.03 0.0275
   6.04 0.0155 7.04 0.0029 8.05 0.0013 9.06 0.0016 10.07 0.0010
   11.07 0.0004 12.08 0.0001 ) constant ob-d5

'( 1.00 0.2003 2.00 0.0265 3.00 0.1047 4.00 0.0138 5.00 0.0391
   6.00 0.0094 6.99 0.0023 8.00 0.0018 8.99 0.0011 9.99 0.0006
   10.99 0.0002 11.99 0.0001 ) constant ob-ds5

'( 1.00 0.0906 2.00 0.4215 3.00 0.1046 3.99 0.0081 4.99 0.0118
   5.99 0.0054 6.99 0.0005 7.99 0.0014 8.99 0.0005 9.99 0.0002 ) constant ob-e5

'( 1.00 0.0657 2.00 0.4134 2.99 0.0463 3.99 0.0144 4.99 0.0277
   5.99 0.0047 6.98 0.0005 7.98 0.0004 8.98 0.0003 ) constant ob-f5

'( 1.01 0.0957 2.03 0.2943 3.04 0.0855 4.06 0.0568 5.07 0.0247
   6.08 0.0013 7.10 0.0024 8.12 0.0011 9.13 0.0006 10.15 0.0002
   11.16 0.0001 12.17 0.0001 ) constant ob-fs5

'( 1.01 0.0975 2.02 0.1012 3.04 0.0543 4.05 0.0298 5.06 0.0083
   6.07 0.0026 7.08 0.0017 8.09 0.0003 9.11 0.0001 ) constant ob-g5

'( 1.01 0.0400 2.01 0.0481 3.02 0.0403 4.02 0.0169 5.03 0.0002
   6.04 0.0030 7.04 0.0008 ) constant ob-gs5

'( 1.01 0.0725 2.02 0.1474 3.03 0.0327 4.04 0.0281 5.05 0.0013
   6.06 0.0028 7.07 0.0004 ) constant ob-a5

'( 1.00 0.0837 2.00 0.1039 3.00 0.0366 4.01 0.0118 5.01 0.0021
   6.01 0.0012 ) constant ob-as5

'( 1.02 0.0812 2.04 0.0709 3.06 0.0658 4.08 0.0099 5.10 0.0069
   6.12 0.0007 7.14 0.0001 8.16 0.0001 ) constant ob-b5

'( 1.01 0.0799 2.02 0.0161 3.02 0.0476 4.03 0.0084 5.04 0.0029
   6.05 0.0002 ) constant ob-c6

'( 1.01 0.2331 2.02 0.1151 3.03 0.0163 4.04 0.0013 5.05 0.0004
   6.07 0.0003 ) constant ob-cs6

'( 1.02 0.2469 2.03 0.0288 3.05 0.0144 4.06 0.0012 5.08 0.0008 ) constant ob-d6

'( 1.00 0.2770 2.00 0.0028 3.00 0.0095 4.00 0.0042 5.00 0.0006
   5.99 0.0002 ) constant ob-ds6

'( 1.00 0.3019 2.01 0.0125 3.01 0.0049 4.02 0.0008 5.02 0.0001
   6.02 0.0001 ) constant ob-e6

'( 1.01 0.0898 2.01 0.0089 3.02 0.0067 4.02 0.0010 5.03 0.0002
   6.03 0.0001 ) constant ob-f6

'( 1.01 0.1330 2.03 0.0090 3.05 0.0031 4.06 0.0001 ) constant ob-fs6

'( 1.00 0.1046 1.99 0.0228 2.99 0.0004 3.98 0.0001 ) constant ob-g6

\ **********************************************************
\ piano
\ **********************************************************

'( 1.97 0.0326 2.99 0.0086 3.95 0.0163 4.97 0.0178 5.98 0.0177
   6.95 0.0315 8.02 0.0001 8.94 0.0076 9.96 0.0134 10.99 0.0284
   11.98 0.0229 13.02 0.0229 13.89 0.0010 15.06 0.0090 16.00 0.0003
   17.08 0.0078 18.16 0.0064 19.18 0.0129 20.21 0.0085 21.27 0.0225
   22.32 0.0061 23.41 0.0102 24.48 0.0005 25.56 0.0016 26.64 0.0018
   27.70 0.0113 28.80 0.0111 29.91 0.0158 31.06 0.0093 32.17 0.0017
   33.32 0.0002 34.42 0.0018 35.59 0.0027 36.74 0.0055 37.90 0.0037
   39.06 0.0064 40.25 0.0033 41.47 0.0014 42.53 0.0004 43.89 0.0010
   45.12 0.0039 46.33 0.0039 47.64 0.0009 48.88 0.0016 50.13 0.0006
   51.37 0.0010 52.70 0.0002 54.00 0.0004 55.30 0.0008 56.60 0.0025
   57.96 0.0010 59.30 0.0012 60.67 0.0011 61.99 0.0003 62.86 0.0001
   64.36 0.0005 64.86 0.0001 66.26 0.0004 67.70 0.0006 68.94 0.0002
   70.10 0.0001 70.58 0.0002 72.01 0.0007 73.53 0.0006 75.00 0.0002
   77.03 0.0005 78.00 0.0002 79.57 0.0006 81.16 0.0005 82.70 0.0005
   84.22 0.0003 85.41 0.0002 87.46 0.0001 90.30 0.0001 94.02 0.0001
   95.26 0.0002 109.39 0.0003 ) constant p-c1

'( 1.98 0.0194 2.99 0.0210 3.97 0.0276 4.96 0.0297 5.96 0.0158
   6.99 0.0207 8.01 0.0009 9.00 0.0101 10.00 0.0297 11.01 0.0289
   12.02 0.0211 13.04 0.0127 14.07 0.0061 15.08 0.0174 16.13 0.0009
   17.12 0.0093 18.16 0.0117 19.21 0.0122 20.29 0.0108 21.30 0.0077
   22.38 0.0132 23.46 0.0073 24.14 0.0002 25.58 0.0026 26.69 0.0035
   27.77 0.0053 28.88 0.0024 30.08 0.0027 31.13 0.0075 32.24 0.0027
   33.36 0.0004 34.42 0.0004 35.64 0.0019 36.78 0.0037 38.10 0.0009
   39.11 0.0027 40.32 0.0010 41.51 0.0013 42.66 0.0019 43.87 0.0007
   45.13 0.0017 46.35 0.0019 47.65 0.0021 48.89 0.0014 50.18 0.0023
   51.42 0.0015 52.73 0.0002 54.00 0.0005 55.34 0.0006 56.60 0.0010
   57.96 0.0016 58.86 0.0005 59.30 0.0004 60.75 0.0005 62.22 0.0003
   63.55 0.0005 64.82 0.0003 66.24 0.0003 67.63 0.0011 69.09 0.0007
   70.52 0.0004 72.00 0.0005 73.50 0.0008 74.95 0.0003 77.13 0.0013
   78.02 0.0002 79.48 0.0004 82.59 0.0004 84.10 0.0003 ) constant p-cs1

'( 2.00 0.0313 2.99 0.0109 4.00 0.0215 5.00 0.0242 5.98 0.0355
   7.01 0.0132 8.01 0.0009 9.01 0.0071 10.00 0.0258 11.03 0.0221
   12.02 0.0056 13.06 0.0196 14.05 0.0160 15.11 0.0107 16.11 0.0003
   17.14 0.0111 18.21 0.0085 19.23 0.0010 20.28 0.0048 21.31 0.0128
   22.36 0.0051 23.41 0.0041 24.05 0.0006 25.54 0.0019 26.62 0.0028
   27.72 0.0034 28.82 0.0062 29.89 0.0039 30.98 0.0058 32.08 0.0011
   33.21 0.0002 34.37 0.0008 35.46 0.0018 36.62 0.0036 37.77 0.0018
   38.92 0.0042 40.07 0.0037 41.23 0.0011 42.67 0.0003 43.65 0.0018
   44.68 0.0025 45.99 0.0044 47.21 0.0051 48.40 0.0044 49.67 0.0005
   50.88 0.0019 52.15 0.0003 53.42 0.0008 54.69 0.0010 55.98 0.0005
   57.26 0.0013 58.53 0.0027 59.83 0.0011 61.21 0.0027 62.54 0.0003
   63.78 0.0003 65.20 0.0001 66.60 0.0006 67.98 0.0008 69.37 0.0019
   70.73 0.0007 72.14 0.0004 73.62 0.0002 74.40 0.0003 76.52 0.0006
   77.97 0.0002 79.49 0.0004 80.77 0.0003 81.00 0.0001 82.47 0.0005
   83.97 0.0001 87.27 0.0002 ) constant p-d1

'( 2.00 0.0257 2.99 0.0142 3.97 0.0202 4.95 0.0148 5.95 0.0420
   6.95 0.0037 7.94 0.0004 8.94 0.0172 9.95 0.0191 10.96 0.0115
   11.97 0.0059 12.98 0.0140 14.00 0.0178 15.03 0.0121 16.09 0.0002
   17.07 0.0066 18.08 0.0033 19.15 0.0022 20.18 0.0057 21.22 0.0077
   22.29 0.0037 23.33 0.0066 24.97 0.0002 25.49 0.0019 26.55 0.0042
   27.61 0.0043 28.73 0.0038 29.81 0.0084 30.91 0.0040 32.03 0.0025
   33.14 0.0005 34.26 0.0003 35.38 0.0019 36.56 0.0037 37.68 0.0049
   38.86 0.0036 40.11 0.0011 41.28 0.0008 42.50 0.0004 43.60 0.0002
   44.74 0.0022 45.99 0.0050 47.20 0.0009 48.40 0.0036 49.68 0.0004
   50.92 0.0009 52.17 0.0005 53.46 0.0007 54.76 0.0006 56.06 0.0005
   57.34 0.0011 58.67 0.0005 59.95 0.0015 61.37 0.0008 62.72 0.0004
   65.42 0.0009 66.96 0.0003 68.18 0.0003 69.78 0.0003 71.21 0.0004
   72.45 0.0002 74.22 0.0003 75.44 0.0001 76.53 0.0003 78.31 0.0004
   79.83 0.0003 80.16 0.0001 81.33 0.0003 82.44 0.0001 83.17 0.0002
   84.81 0.0003 85.97 0.0003 89.08 0.0001 90.70 0.0002 92.30 0.0002
   95.59 0.0002 97.22 0.0003 98.86 0.0001 108.37 0.0001 125.54 0.0001 ) constant p-ds1

'( 1.99 0.0650 3.03 0.0040 4.03 0.0059 5.02 0.0090 5.97 0.0227
   6.98 0.0050 8.04 0.0020 9.00 0.0082 9.96 0.0078 11.01 0.0056
   12.01 0.0095 13.02 0.0050 14.04 0.0093 15.08 0.0064 16.14 0.0017
   17.06 0.0020 18.10 0.0025 19.14 0.0023 20.18 0.0015 21.24 0.0032
   22.29 0.0029 23.32 0.0014 24.37 0.0005 25.43 0.0030 26.50 0.0022
   27.60 0.0027 28.64 0.0024 29.76 0.0035 30.81 0.0136 31.96 0.0025
   33.02 0.0003 34.13 0.0005 35.25 0.0007 36.40 0.0014 37.51 0.0020
   38.64 0.0012 39.80 0.0019 40.97 0.0004 42.09 0.0003 43.24 0.0003
   44.48 0.0002 45.65 0.0024 46.86 0.0005 48.07 0.0013 49.27 0.0008
   50.49 0.0006 52.95 0.0001 54.23 0.0005 55.45 0.0004 56.73 0.0001
   58.03 0.0003 59.29 0.0002 60.59 0.0003 62.04 0.0002 65.89 0.0002
   67.23 0.0002 68.61 0.0002 69.97 0.0004 71.36 0.0005 85.42 0.0001 ) constant p-e1

'( 1.98 0.0256 2.96 0.0158 3.95 0.0310 4.94 0.0411 5.95 0.0238
   6.94 0.0152 7.93 0.0011 8.95 0.0185 9.92 0.0166 10.93 0.0306
   11.94 0.0258 12.96 0.0202 13.97 0.0403 14.95 0.0228 15.93 0.0005
   17.01 0.0072 18.02 0.0034 19.06 0.0028 20.08 0.0124 21.13 0.0137
   22.16 0.0102 23.19 0.0058 23.90 0.0013 25.30 0.0039 26.36 0.0039
   27.41 0.0025 28.47 0.0071 29.64 0.0031 30.60 0.0027 31.71 0.0021
   32.84 0.0003 33.82 0.0002 35.07 0.0019 36.09 0.0054 37.20 0.0038
   38.33 0.0024 39.47 0.0055 40.55 0.0016 41.77 0.0006 42.95 0.0002
   43.27 0.0018 44.03 0.0006 45.25 0.0019 46.36 0.0033 47.50 0.0024
   48.87 0.0012 50.03 0.0016 51.09 0.0004 53.52 0.0017 54.74 0.0012
   56.17 0.0003 57.40 0.0011 58.42 0.0020 59.70 0.0007 61.29 0.0008
   62.56 0.0003 63.48 0.0002 64.83 0.0002 66.12 0.0012 67.46 0.0017
   68.81 0.0003 69.13 0.0003 70.53 0.0002 71.84 0.0001 73.28 0.0002
   75.52 0.0010 76.96 0.0005 77.93 0.0003 78.32 0.0003 79.73 0.0003
   81.69 0.0002 82.52 0.0001 84.01 0.0001 84.61 0.0002 86.88 0.0001
   88.36 0.0002 89.85 0.0002 91.35 0.0003 92.86 0.0002 93.40 0.0001
   105.28 0.0002 106.22 0.0002 107.45 0.0001 108.70 0.0003 122.08 0.0002 ) constant p-f1

'( 1.97 0.0264 2.97 0.0211 3.98 0.0234 4.98 0.0307 5.96 0.0085
   6.94 0.0140 7.93 0.0005 8.96 0.0112 9.96 0.0209 10.98 0.0194
   11.98 0.0154 12.99 0.0274 13.99 0.0127 15.01 0.0101 15.99 0.0002
   17.04 0.0011 18.08 0.0032 19.14 0.0028 20.12 0.0054 21.20 0.0053
   22.13 0.0028 23.22 0.0030 24.32 0.0006 25.24 0.0004 26.43 0.0028
   27.53 0.0048 28.52 0.0039 29.54 0.0047 30.73 0.0044 31.82 0.0007
   32.94 0.0008 34.04 0.0012 35.13 0.0018 36.29 0.0007 37.35 0.0075
   38.51 0.0045 39.66 0.0014 40.90 0.0004 41.90 0.0002 43.08 0.0002
   44.24 0.0017 45.36 0.0013 46.68 0.0020 47.79 0.0015 48.98 0.0010
   50.21 0.0012 51.34 0.0001 53.82 0.0003 55.09 0.0004 56.23 0.0005
   57.53 0.0004 58.79 0.0005 59.30 0.0002 60.03 0.0002 61.40 0.0003
   62.84 0.0001 66.64 0.0001 67.97 0.0001 69.33 0.0001 70.68 0.0001
   73.57 0.0002 75.76 0.0002 76.45 0.0001 79.27 0.0001 80.44 0.0002
   81.87 0.0002 ) constant p-fs1

'( 2.00 0.0311 2.99 0.0086 3.99 0.0266 4.97 0.0123 5.98 0.0235
   6.97 0.0161 7.97 0.0008 8.96 0.0088 9.96 0.0621 10.99 0.0080
   11.99 0.0034 12.99 0.0300 14.03 0.0228 15.04 0.0105 16.03 0.0004
   17.06 0.0036 18.09 0.0094 18.95 0.0009 20.17 0.0071 21.21 0.0161
   22.25 0.0106 23.28 0.0104 24.33 0.0008 25.38 0.0030 26.46 0.0035
   27.50 0.0026 28.59 0.0028 29.66 0.0128 30.75 0.0139 31.81 0.0038
   32.93 0.0006 34.04 0.0004 35.16 0.0005 36.25 0.0023 37.35 0.0012
   38.46 0.0021 39.59 0.0035 40.71 0.0006 41.86 0.0007 42.42 0.0001
   43.46 0.0003 44.17 0.0032 45.29 0.0013 46.57 0.0004 47.72 0.0011
   48.79 0.0005 50.11 0.0005 51.29 0.0003 52.47 0.0002 53.68 0.0004
   55.02 0.0005 56.18 0.0003 57.41 0.0003 58.75 0.0007 59.33 0.0009
   60.00 0.0004 61.34 0.0001 64.97 0.0003 65.20 0.0002 66.48 0.0002
   67.83 0.0002 68.90 0.0003 70.25 0.0003 71.59 0.0002 73.68 0.0001
   75.92 0.0001 77.08 0.0002 78.45 0.0002 81.56 0.0002 82.99 0.0001
   88.39 0.0001 ) constant p-g1

'( 0.97 0.0059 1.98 0.0212 2.99 0.0153 3.99 0.0227 4.96 0.0215
   5.97 0.0153 6.98 0.0085 7.98 0.0007 8.97 0.0179 9.98 0.0512
   10.98 0.0322 12.00 0.0098 13.02 0.0186 14.00 0.0099 15.05 0.0109
   15.88 0.0011 17.07 0.0076 18.11 0.0071 19.12 0.0045 20.16 0.0038
   21.23 0.0213 22.27 0.0332 23.34 0.0082 24.34 0.0014 25.42 0.0024
   26.47 0.0012 27.54 0.0014 28.60 0.0024 29.72 0.0026 30.10 0.0008
   31.91 0.0021 32.13 0.0011 33.02 0.0007 34.09 0.0014 35.17 0.0007
   36.27 0.0024 37.39 0.0029 38.58 0.0014 39.65 0.0017 40.95 0.0012
   41.97 0.0004 42.43 0.0002 43.49 0.0001 44.31 0.0012 45.42 0.0031
   46.62 0.0017 47.82 0.0013 49.14 0.0013 50.18 0.0010 51.54 0.0003
   53.90 0.0006 55.06 0.0010 56.31 0.0003 57.63 0.0001 59.02 0.0003
   60.09 0.0004 60.35 0.0004 61.62 0.0009 63.97 0.0001 65.19 0.0001
   65.54 0.0002 66.92 0.0002 67.94 0.0002 69.17 0.0003 69.60 0.0004
   70.88 0.0002 72.24 0.0002 76.12 0.0001 78.94 0.0001 81.75 0.0001
   82.06 0.0001 83.53 0.0001 90.29 0.0002 91.75 0.0001 92.09 0.0002
   93.28 0.0001 97.07 0.0001 ) constant p-gs1

'( 1.98 0.0159 2.98 0.1008 3.98 0.0365 4.98 0.0133 5.97 0.0101
   6.97 0.0115 7.97 0.0007 8.99 0.0349 10.01 0.0342 11.01 0.0236
   12.00 0.0041 13.02 0.0114 14.05 0.0137 15.06 0.0100 16.05 0.0007
   17.04 0.0009 18.12 0.0077 19.15 0.0023 20.12 0.0017 21.24 0.0113
   22.26 0.0126 23.30 0.0093 24.36 0.0007 25.43 0.0007 26.47 0.0009
   27.55 0.0013 28.59 0.0025 29.61 0.0010 30.77 0.0021 31.86 0.0023
   32.96 0.0003 34.03 0.0007 35.06 0.0005 36.20 0.0006 37.34 0.0006
   38.36 0.0009 39.60 0.0016 40.69 0.0005 41.77 0.0002 42.92 0.0002
   44.02 0.0003 45.24 0.0006 46.33 0.0004 47.50 0.0007 48.71 0.0007
   49.87 0.0002 51.27 0.0002 53.42 0.0003 55.88 0.0003 57.10 0.0004
   58.34 0.0002 59.86 0.0003 61.13 0.0003 67.18 0.0001 68.50 0.0001
   71.17 0.0001 83.91 0.0001 90.55 0.0001 ) constant p-a1

'( 0.98 0.0099 2.00 0.0181 2.99 0.0353 3.98 0.0285 4.97 0.0514
   5.96 0.0402 6.96 0.0015 7.98 0.0012 8.98 0.0175 9.98 0.0264
   10.98 0.0392 11.98 0.0236 13.00 0.0153 14.04 0.0049 15.00 0.0089
   16.01 0.0001 17.03 0.0106 18.03 0.0028 19.05 0.0024 20.08 0.0040
   21.11 0.0103 22.12 0.0104 23.20 0.0017 24.19 0.0008 25.20 0.0007
   26.24 0.0011 27.36 0.0009 27.97 0.0030 29.40 0.0044 30.37 0.0019
   31.59 0.0017 32.65 0.0008 33.59 0.0005 34.79 0.0009 35.75 0.0027
   36.88 0.0035 37.93 0.0039 39.00 0.0031 40.08 0.0025 41.16 0.0010
   43.25 0.0004 44.52 0.0012 45.62 0.0023 45.85 0.0012 47.00 0.0006
   47.87 0.0008 48.99 0.0003 50.48 0.0003 51.62 0.0001 52.43 0.0001
   53.56 0.0002 54.76 0.0002 56.04 0.0002 56.68 0.0006 57.10 0.0003
   58.28 0.0005 59.47 0.0003 59.96 0.0002 60.67 0.0001 63.08 0.0002
   64.29 0.0002 66.72 0.0001 67.97 0.0001 68.65 0.0001 70.43 0.0001
   79.38 0.0001 80.39 0.0001 82.39 0.0001 ) constant p-as1

'( 1.00 0.0765 1.99 0.0151 2.99 0.0500 3.99 0.0197 5.00 0.0260
   6.00 0.0145 6.98 0.0128 7.97 0.0004 8.98 0.0158 9.99 0.0265
   11.02 0.0290 12.02 0.0053 13.03 0.0242 14.03 0.0103 15.06 0.0054
   16.04 0.0006 17.08 0.0008 18.10 0.0058 19.16 0.0011 20.16 0.0055
   21.18 0.0040 22.20 0.0019 23.22 0.0014 24.05 0.0005 25.31 0.0019
   26.38 0.0018 27.44 0.0022 28.45 0.0024 29.57 0.0073 30.58 0.0032
   31.66 0.0071 32.73 0.0015 33.85 0.0005 34.96 0.0003 36.00 0.0020
   37.11 0.0018 38.18 0.0055 39.23 0.0006 40.33 0.0004 41.52 0.0003
   43.41 0.0028 45.05 0.0003 45.99 0.0002 47.07 0.0003 48.52 0.0002
   49.48 0.0003 50.63 0.0003 51.81 0.0002 54.05 0.0002 55.24 0.0001
   56.62 0.0001 57.81 0.0004 59.16 0.0013 60.23 0.0003 66.44 0.0001
   68.99 0.0004 75.49 0.0001 87.56 0.0004 ) constant p-b1

'( 0.98 0.0629 1.99 0.0232 2.98 0.0217 4.00 0.0396 4.98 0.0171
   5.97 0.0098 6.99 0.0167 7.99 0.0003 8.98 0.0192 9.98 0.0266
   10.99 0.0256 12.01 0.0061 13.02 0.0135 14.02 0.0062 15.05 0.0158
   16.06 0.0018 17.08 0.0101 18.09 0.0053 19.11 0.0074 20.13 0.0020
   21.17 0.0052 22.22 0.0077 23.24 0.0035 24.00 0.0009 25.32 0.0016
   26.40 0.0022 27.43 0.0005 28.55 0.0026 29.60 0.0026 30.65 0.0010
   31.67 0.0019 32.77 0.0008 33.81 0.0003 34.91 0.0003 36.01 0.0005
   37.11 0.0010 38.20 0.0014 39.29 0.0039 40.43 0.0012 41.50 0.0006
   43.38 0.0017 43.75 0.0002 44.94 0.0005 46.13 0.0002 47.11 0.0003
   48.28 0.0005 48.42 0.0005 49.44 0.0003 50.76 0.0004 51.93 0.0002
   54.15 0.0003 55.31 0.0005 55.50 0.0003 56.98 0.0003 57.90 0.0004
   60.33 0.0002 61.39 0.0001 61.59 0.0001 65.09 0.0002 66.34 0.0001
   68.85 0.0001 70.42 0.0002 71.72 0.0001 73.05 0.0003 79.65 0.0001
   85.28 0.0002 93.52 0.0001 ) constant p-c2

'( 1.02 0.0185 1.99 0.0525 2.98 0.0613 3.99 0.0415 4.98 0.0109
   5.97 0.0248 6.99 0.0102 7.98 0.0005 8.98 0.0124 9.99 0.0103
   10.99 0.0124 12.00 0.0016 13.01 0.0029 14.03 0.0211 15.04 0.0128
   16.07 0.0021 17.09 0.0009 18.09 0.0043 19.14 0.0022 20.13 0.0016
   21.20 0.0045 22.21 0.0088 23.26 0.0046 24.29 0.0013 25.35 0.0009
   26.39 0.0028 27.49 0.0009 28.51 0.0006 29.58 0.0012 30.70 0.0010
   31.74 0.0019 32.75 0.0002 33.85 0.0001 34.95 0.0005 36.02 0.0003
   37.16 0.0009 38.25 0.0018 39.35 0.0008 40.54 0.0004 41.61 0.0002
   43.40 0.0004 43.74 0.0003 45.05 0.0001 46.11 0.0003 47.40 0.0002
   48.36 0.0004 49.55 0.0004 50.72 0.0002 52.00 0.0001 55.58 0.0002
   57.02 0.0001 57.98 0.0002 59.13 0.0003 61.56 0.0001 66.56 0.0001
   87.65 0.0002 ) constant p-cs2

'( 1.00 0.0473 1.99 0.0506 2.99 0.0982 3.99 0.0654 5.00 0.0196
   5.99 0.0094 6.99 0.0118 7.93 0.0001 8.99 0.0057 10.01 0.0285
   11.01 0.0142 12.03 0.0032 13.03 0.0056 14.06 0.0064 15.06 0.0059
   16.11 0.0005 17.09 0.0033 18.14 0.0027 19.15 0.0014 20.17 0.0010
   21.21 0.0059 22.26 0.0043 23.31 0.0031 24.31 0.0018 25.33 0.0009
   26.41 0.0005 27.47 0.0015 28.53 0.0015 29.58 0.0041 30.65 0.0025
   31.73 0.0011 32.83 0.0010 34.98 0.0003 36.07 0.0009 37.23 0.0001
   38.26 0.0020 39.41 0.0014 40.53 0.0005 41.40 0.0003 42.80 0.0002
   43.48 0.0028 43.93 0.0001 45.03 0.0003 46.18 0.0007 47.41 0.0001
   48.57 0.0002 49.67 0.0001 50.83 0.0002 54.39 0.0001 55.58 0.0002
   57.97 0.0005 58.11 0.0002 59.21 0.0001 60.42 0.0002 61.66 0.0001 ) constant p-d2

'( 1.00 0.0503 2.00 0.0963 2.99 0.1304 3.99 0.0218 4.98 0.0041
   5.98 0.0292 6.98 0.0482 7.99 0.0005 8.99 0.0280 10.00 0.0237
   11.00 0.0152 12.02 0.0036 12.95 0.0022 14.06 0.0111 15.07 0.0196
   16.08 0.0016 17.11 0.0044 18.13 0.0073 19.17 0.0055 20.19 0.0028
   21.20 0.0012 22.27 0.0068 23.30 0.0036 24.35 0.0012 25.35 0.0002
   26.46 0.0005 27.47 0.0005 28.59 0.0009 29.65 0.0021 30.70 0.0020
   31.78 0.0012 32.89 0.0010 35.06 0.0005 36.16 0.0008 37.27 0.0010
   38.36 0.0010 39.47 0.0014 40.58 0.0004 41.43 0.0007 41.82 0.0003
   43.48 0.0008 44.53 0.0001 45.25 0.0003 46.43 0.0002 47.46 0.0002
   48.76 0.0005 49.95 0.0004 50.96 0.0002 51.12 0.0002 52.33 0.0001
   54.75 0.0001 55.75 0.0002 56.90 0.0002 58.17 0.0002 59.40 0.0004
   60.62 0.0002 65.65 0.0001 66.91 0.0002 69.91 0.0001 71.25 0.0002 ) constant p-ds2

'( 1.00 0.1243 1.98 0.1611 3.00 0.0698 3.98 0.0390 5.00 0.0138
   5.99 0.0154 7.01 0.0287 8.01 0.0014 9.01 0.0049 10.00 0.0144
   11.01 0.0055 12.05 0.0052 13.01 0.0011 14.05 0.0118 15.07 0.0154
   16.12 0.0028 17.14 0.0061 18.25 0.0007 19.22 0.0020 20.24 0.0011
   21.27 0.0029 22.30 0.0046 23.34 0.0049 24.35 0.0004 25.45 0.0003
   26.47 0.0007 27.59 0.0008 28.16 0.0009 29.12 0.0002 29.81 0.0006
   30.81 0.0009 31.95 0.0004 33.00 0.0011 34.12 0.0005 35.18 0.0003
   36.30 0.0008 37.38 0.0003 38.55 0.0003 39.64 0.0006 40.77 0.0007
   41.52 0.0006 41.89 0.0006 43.04 0.0011 43.60 0.0009 44.31 0.0002
   45.68 0.0002 46.56 0.0003 47.60 0.0001 48.83 0.0006 50.01 0.0003
   51.27 0.0003 56.04 0.0005 57.21 0.0003 58.56 0.0004 59.83 0.0003
   61.05 0.0001 62.20 0.0001 67.37 0.0002 76.53 0.0001 ) constant p-e2

'( 0.99 0.0222 1.99 0.0678 2.99 0.0683 4.00 0.0191 5.00 0.0119
   6.01 0.0232 6.98 0.0336 7.99 0.0082 9.01 0.0201 10.01 0.0189
   11.01 0.0041 12.01 0.0053 13.05 0.0154 14.04 0.0159 15.06 0.0092
   16.11 0.0038 17.12 0.0014 18.15 0.0091 19.16 0.0006 20.30 0.0012
   21.25 0.0061 22.28 0.0099 23.34 0.0028 24.38 0.0012 25.43 0.0016
   26.49 0.0048 27.55 0.0025 28.62 0.0015 29.71 0.0032 30.78 0.0077
   31.88 0.0011 32.97 0.0007 34.08 0.0006 35.16 0.0008 36.28 0.0004
   37.41 0.0006 38.54 0.0005 39.62 0.0002 40.80 0.0003 41.93 0.0001
   43.06 0.0002 44.21 0.0003 45.38 0.0002 46.54 0.0007 47.78 0.0003
   48.95 0.0004 50.10 0.0003 51.37 0.0002 53.79 0.0003 56.20 0.0001
   58.71 0.0002 66.47 0.0003 ) constant p-f2

'( 1.01 0.0241 1.99 0.1011 2.98 0.0938 3.98 0.0081 4.99 0.0062
   5.99 0.0291 6.99 0.0676 7.59 0.0004 8.98 0.0127 9.99 0.0112
   10.99 0.0142 12.00 0.0029 13.02 0.0071 14.02 0.0184 15.03 0.0064
   16.07 0.0010 17.09 0.0011 18.11 0.0010 19.15 0.0060 20.19 0.0019
   21.24 0.0025 22.29 0.0013 23.31 0.0050 25.41 0.0030 26.50 0.0018
   27.53 0.0006 28.63 0.0012 29.66 0.0013 30.77 0.0020 31.84 0.0006
   34.04 0.0001 35.14 0.0001 36.32 0.0004 37.41 0.0007 38.53 0.0007
   39.67 0.0009 40.85 0.0003 45.49 0.0002 46.65 0.0001 47.81 0.0004
   49.01 0.0002 53.91 0.0002 55.14 0.0002 57.69 0.0002 ) constant p-fs2

'( 1.00 0.0326 2.00 0.1066 2.99 0.1015 4.00 0.0210 4.97 0.0170
   5.99 0.0813 6.98 0.0820 7.96 0.0011 8.99 0.0248 10.03 0.0107
   11.01 0.0126 12.01 0.0027 13.01 0.0233 14.04 0.0151 15.05 0.0071
   16.04 0.0002 17.10 0.0061 18.12 0.0059 19.15 0.0087 20.23 0.0005
   21.25 0.0040 22.30 0.0032 23.35 0.0004 24.40 0.0001 25.45 0.0030
   26.54 0.0022 27.60 0.0003 28.70 0.0009 29.80 0.0029 30.85 0.0006
   31.97 0.0006 34.19 0.0004 35.30 0.0003 36.43 0.0007 37.56 0.0005
   38.68 0.0019 39.88 0.0013 41.00 0.0003 43.35 0.0003 44.51 0.0002
   45.68 0.0006 46.93 0.0010 48.11 0.0006 49.29 0.0003 55.58 0.0002 ) constant p-g2

'( 0.98 0.0113 1.99 0.0967 3.00 0.0719 3.98 0.0345 4.98 0.0121
   6.00 0.0621 7.00 0.0137 7.98 0.0006 9.01 0.0314 10.01 0.0171
   11.02 0.0060 12.03 0.0024 13.05 0.0077 14.07 0.0040 15.12 0.0032
   16.13 0.0004 17.15 0.0011 18.20 0.0028 19.18 0.0003 20.26 0.0003
   21.31 0.0025 22.35 0.0021 23.39 0.0005 25.55 0.0002 26.62 0.0014
   27.70 0.0003 28.78 0.0005 29.90 0.0030 31.01 0.0011 32.12 0.0005
   34.31 0.0001 35.50 0.0002 36.62 0.0002 37.76 0.0005 38.85 0.0002
   40.09 0.0004 43.60 0.0001 44.73 0.0002 46.02 0.0002 47.25 0.0004
   48.44 0.0004 ) constant p-gs2

'( 0.99 0.0156 1.98 0.0846 2.98 0.0178 3.98 0.0367 4.98 0.0448
   5.98 0.0113 6.99 0.0189 8.00 0.0011 9.01 0.0247 10.02 0.0089
   11.01 0.0184 12.03 0.0105 13.00 0.0039 14.07 0.0116 15.09 0.0078
   16.13 0.0008 17.14 0.0064 18.19 0.0029 19.22 0.0028 20.25 0.0017
   21.32 0.0043 22.37 0.0055 23.42 0.0034 24.48 0.0004 25.54 0.0002
   26.61 0.0017 27.70 0.0011 28.80 0.0002 29.89 0.0019 30.97 0.0028
   32.09 0.0007 34.30 0.0002 35.44 0.0003 36.55 0.0001 37.69 0.0004
   38.93 0.0002 40.05 0.0005 41.20 0.0005 42.37 0.0002 43.54 0.0003
   44.73 0.0001 45.95 0.0002 47.16 0.0001 48.43 0.0005 49.65 0.0004
   55.90 0.0002 59.81 0.0004 ) constant p-a2

'( 1.01 0.0280 2.00 0.0708 2.99 0.0182 3.99 0.0248 4.98 0.0245
   5.98 0.0279 6.98 0.0437 7.99 0.0065 8.99 0.0299 10.00 0.0073
   10.99 0.0011 12.03 0.0122 13.03 0.0028 14.08 0.0044 15.11 0.0097
   16.15 0.0010 17.17 0.0025 18.19 0.0017 19.24 0.0008 20.28 0.0040
   21.32 0.0024 22.38 0.0008 23.46 0.0032 24.52 0.0010 25.59 0.0008
   26.68 0.0009 27.76 0.0012 28.88 0.0003 29.95 0.0005 31.05 0.0017
   32.14 0.0002 33.29 0.0003 37.88 0.0002 39.03 0.0002 40.19 0.0004
   41.37 0.0003 43.74 0.0002 46.20 0.0001 48.68 0.0001 49.93 0.0001
   51.19 0.0002 ) constant p-as2

'( 1.00 0.0225 1.99 0.0921 2.98 0.0933 3.99 0.0365 4.99 0.0100
   5.98 0.0213 6.98 0.0049 7.98 0.0041 8.98 0.0090 9.99 0.0068
   11.01 0.0040 12.03 0.0086 13.02 0.0015 14.04 0.0071 15.09 0.0082
   16.14 0.0011 17.15 0.0014 18.18 0.0010 19.26 0.0013 20.26 0.0005
   21.33 0.0006 22.36 0.0011 23.46 0.0016 24.52 0.0004 25.59 0.0002
   26.70 0.0006 27.78 0.0007 28.87 0.0002 30.03 0.0008 31.14 0.0010
   32.24 0.0006 33.37 0.0002 35.67 0.0003 37.99 0.0004 39.17 0.0004
   40.35 0.0005 41.53 0.0001 46.42 0.0001 ) constant p-b2

'( 1.00 0.0465 1.99 0.0976 2.98 0.0678 4.00 0.0727 4.99 0.0305
   5.98 0.0210 6.98 0.0227 8.00 0.0085 9.01 0.0183 10.02 0.0258
   11.05 0.0003 12.06 0.0061 13.05 0.0021 14.10 0.0089 15.12 0.0077
   16.16 0.0016 17.21 0.0061 18.23 0.0011 19.29 0.0031 20.36 0.0031
   21.41 0.0007 22.48 0.0013 23.55 0.0020 24.64 0.0004 25.74 0.0005
   26.81 0.0006 27.95 0.0006 29.03 0.0001 30.22 0.0010 31.30 0.0004
   32.48 0.0001 33.60 0.0002 38.30 0.0003 ) constant p-c3

'( 1.00 0.0674 1.99 0.0841 2.98 0.0920 3.99 0.0328 4.99 0.0368
   5.98 0.0206 6.99 0.0246 8.01 0.0048 9.01 0.0218 10.03 0.0155
   11.05 0.0048 12.06 0.0077 13.00 0.0020 14.10 0.0083 15.15 0.0084
   16.18 0.0015 17.22 0.0039 18.27 0.0032 19.34 0.0026 20.40 0.0012
   21.47 0.0009 22.54 0.0008 23.62 0.0016 24.71 0.0005 25.82 0.0004
   26.91 0.0002 28.03 0.0008 29.17 0.0002 30.32 0.0028 31.45 0.0004
   32.61 0.0005 33.77 0.0001 36.14 0.0003 37.32 0.0002 38.54 0.0005
   39.75 0.0002 42.23 0.0002 48.65 0.0001 ) constant p-cs3

'( 1.01 0.0423 1.99 0.0240 2.98 0.0517 4.00 0.0493 5.00 0.0324
   6.00 0.0094 6.99 0.0449 7.99 0.0050 9.00 0.0197 10.03 0.0132
   11.03 0.0009 12.07 0.0017 13.08 0.0023 14.12 0.0094 15.16 0.0071
   16.21 0.0020 17.25 0.0005 18.30 0.0027 19.04 0.0004 20.43 0.0022
   21.51 0.0002 22.59 0.0006 23.72 0.0018 24.80 0.0002 25.88 0.0002
   27.03 0.0002 28.09 0.0006 29.31 0.0002 30.46 0.0004 31.61 0.0007
   32.78 0.0005 33.95 0.0001 36.34 0.0002 37.56 0.0001 38.80 0.0001
   40.02 0.0001 44.14 0.0001 ) constant p-d3

'( 1.00 0.0669 1.99 0.0909 2.99 0.0410 3.98 0.0292 4.98 0.0259
   5.98 0.0148 6.98 0.0319 7.99 0.0076 9.01 0.0056 10.02 0.0206
   11.04 0.0032 12.05 0.0085 13.08 0.0040 14.12 0.0037 15.16 0.0030
   16.20 0.0013 17.24 0.0021 18.30 0.0010 19.36 0.0015 20.44 0.0013
   21.50 0.0009 22.60 0.0015 23.69 0.0014 24.80 0.0006 25.87 0.0002
   27.02 0.0006 28.12 0.0002 29.28 0.0003 30.43 0.0002 31.59 0.0007
   32.79 0.0001 35.14 0.0001 37.57 0.0001 40.03 0.0002 41.28 0.0004
   44.10 0.0001 ) constant p-ds3

'( 0.99 0.0421 1.99 0.1541 2.98 0.0596 3.98 0.0309 4.98 0.0301
   5.99 0.0103 7.00 0.0240 8.01 0.0073 9.01 0.0222 10.04 0.0140
   11.05 0.0033 12.08 0.0045 13.13 0.0009 14.13 0.0015 15.21 0.0026
   16.24 0.0003 17.30 0.0004 18.35 0.0010 19.39 0.0003 20.50 0.0015
   21.57 0.0003 22.68 0.0011 23.80 0.0005 24.90 0.0008 26.02 0.0002
   27.16 0.0001 28.30 0.0006 29.48 0.0002 31.81 0.0005 33.00 0.0003
   34.21 0.0001 37.89 0.0001 ) constant p-e3

'( 0.99 0.0389 2.00 0.2095 3.00 0.0835 3.99 0.0289 5.00 0.0578
   5.99 0.0363 7.01 0.0387 8.01 0.0056 9.04 0.0173 10.05 0.0175
   11.08 0.0053 12.10 0.0056 13.15 0.0064 14.19 0.0036 15.22 0.0019
   16.29 0.0010 17.36 0.0017 18.43 0.0018 19.51 0.0004 20.60 0.0011
   21.70 0.0003 22.82 0.0003 23.95 0.0001 25.05 0.0004 26.17 0.0001
   28.50 0.0003 29.68 0.0001 32.07 0.0003 33.28 0.0004 34.52 0.0001 ) constant p-f3

'( 1.00 0.1238 1.99 0.2270 3.00 0.0102 3.99 0.0181 4.98 0.0415
   6.00 0.0165 7.01 0.0314 8.02 0.0148 9.04 0.0203 10.05 0.0088
   11.07 0.0062 12.11 0.0070 13.14 0.0054 14.19 0.0028 15.24 0.0044
   16.30 0.0029 17.38 0.0009 18.45 0.0026 19.56 0.0003 20.65 0.0025
   21.74 0.0014 22.87 0.0013 23.99 0.0007 25.15 0.0002 27.46 0.0004
   28.39 0.0006 28.65 0.0004 29.85 0.0001 31.05 0.0002 32.27 0.0003
   33.52 0.0002 34.76 0.0003 ) constant p-fs3

'( 1.00 0.1054 2.00 0.2598 2.99 0.0369 3.98 0.0523 4.99 0.0020
   5.99 0.0051 7.00 0.0268 8.01 0.0027 9.04 0.0029 10.05 0.0081
   11.08 0.0047 12.12 0.0051 13.16 0.0091 14.19 0.0015 15.27 0.0030
   16.34 0.0017 17.42 0.0006 18.51 0.0003 19.61 0.0007 20.72 0.0003
   21.84 0.0001 22.99 0.0010 24.13 0.0001 28.44 0.0001 30.09 0.0001 ) constant p-g3

'( 0.99 0.0919 2.00 0.0418 2.99 0.0498 3.99 0.0135 4.99 0.0026
   6.00 0.0155 7.01 0.0340 8.02 0.0033 9.04 0.0218 10.08 0.0084
   11.11 0.0057 12.15 0.0051 13.21 0.0043 14.25 0.0015 15.31 0.0023
   16.40 0.0008 17.48 0.0004 18.59 0.0016 19.71 0.0010 20.84 0.0018
   21.98 0.0002 23.11 0.0013 24.26 0.0003 26.67 0.0002 29.12 0.0002
   30.37 0.0002 31.62 0.0003 32.92 0.0001 ) constant p-gs3

'( 0.99 0.1174 1.99 0.1126 2.99 0.0370 3.99 0.0159 5.01 0.0472
   6.01 0.0091 7.03 0.0211 8.05 0.0015 9.07 0.0098 10.11 0.0038
   11.15 0.0042 12.20 0.0018 13.24 0.0041 14.32 0.0033 15.41 0.0052
   16.49 0.0001 17.61 0.0004 18.71 0.0004 19.84 0.0004 20.99 0.0002
   22.14 0.0006 23.31 0.0006 24.50 0.0004 25.70 0.0002 28.09 0.0002
   28.66 0.0002 32.00 0.0001 ) constant p-a3

'( 1.00 0.1085 2.00 0.1400 2.99 0.0173 3.99 0.0229 5.00 0.0272
   6.02 0.0077 7.03 0.0069 8.04 0.0017 9.08 0.0045 10.10 0.0030
   11.15 0.0040 12.20 0.0007 13.25 0.0019 14.32 0.0008 15.42 0.0024
   16.50 0.0002 17.59 0.0005 18.71 0.0003 19.83 0.0002 20.98 0.0005
   23.29 0.0008 ) constant p-as3

'( 1.00 0.0985 2.00 0.1440 2.99 0.0364 3.99 0.0425 5.00 0.0190
   6.01 0.0089 7.03 0.0278 8.04 0.0006 9.07 0.0083 10.10 0.0021
   11.14 0.0050 12.18 0.0005 13.26 0.0036 14.33 0.0005 15.41 0.0026
   17.62 0.0004 18.75 0.0004 19.89 0.0003 21.04 0.0012 22.21 0.0002
   23.38 0.0004 27.04 0.0001 ) constant p-b3

'( 0.99 0.1273 2.00 0.1311 2.99 0.0120 4.00 0.0099 5.00 0.0235
   6.02 0.0068 7.03 0.0162 8.06 0.0009 9.08 0.0083 10.12 0.0014
   11.17 0.0050 12.24 0.0010 13.29 0.0013 14.39 0.0022 15.48 0.0011
   16.59 0.0002 17.70 0.0003 18.84 0.0010 20.00 0.0003 21.17 0.0003
   23.56 0.0004 28.79 0.0003 ) constant p-c4

'( 1.00 0.1018 2.00 0.1486 3.00 0.0165 4.00 0.0186 5.01 0.0194
   6.02 0.0045 7.04 0.0083 8.06 0.0012 9.10 0.0066 10.15 0.0009
   11.19 0.0008 12.26 0.0011 13.34 0.0028 14.45 0.0006 15.53 0.0009
   16.66 0.0002 17.79 0.0006 18.94 0.0005 20.11 0.0003 21.29 0.0005
   22.49 0.0003 23.73 0.0005 26.22 0.0001 27.52 0.0001 28.88 0.0002 ) constant p-cs4

'( 1.00 0.1889 1.99 0.1822 3.00 0.0363 4.00 0.0047 5.01 0.0202
   6.03 0.0053 7.05 0.0114 8.01 0.0002 9.13 0.0048 10.17 0.0010
   11.23 0.0033 12.30 0.0010 13.38 0.0006 14.50 0.0002 15.62 0.0010
   20.27 0.0001 21.47 0.0001 ) constant p-d4

'( 1.00 0.0522 1.99 0.0763 2.99 0.0404 4.00 0.0139 5.01 0.0185
   6.01 0.0021 7.06 0.0045 8.09 0.0002 9.11 0.0003 10.17 0.0006
   11.25 0.0004 12.32 0.0005 13.40 0.0003 14.53 0.0003 15.65 0.0007
   16.80 0.0001 17.95 0.0002 19.14 0.0006 20.34 0.0002 21.56 0.0003 ) constant p-ds4

'( 0.99 0.1821 1.99 0.0773 3.00 0.0125 4.01 0.0065 5.01 0.0202
   6.03 0.0071 7.05 0.0090 8.08 0.0006 9.13 0.0008 10.18 0.0013
   11.25 0.0010 12.33 0.0012 13.42 0.0006 14.54 0.0005 15.65 0.0004
   17.97 0.0002 19.15 0.0001 ) constant p-e4

'( 1.00 0.1868 2.00 0.0951 3.00 0.0147 4.01 0.0134 5.02 0.0184
   6.04 0.0132 7.06 0.0011 8.11 0.0008 9.15 0.0010 10.22 0.0012
   11.30 0.0011 12.40 0.0003 13.11 0.0004 13.49 0.0002 14.62 0.0003
   15.77 0.0001 ) constant p-f4

'( 1.00 0.1933 2.00 0.0714 3.00 0.0373 4.00 0.0108 5.02 0.0094
   6.02 0.0010 7.07 0.0022 8.11 0.0002 9.16 0.0065 10.23 0.0015
   11.31 0.0023 12.40 0.0003 13.53 0.0014 14.66 0.0002 15.81 0.0011
   18.20 0.0002 19.41 0.0001 ) constant p-fs4

'( 0.99 0.2113 1.99 0.0877 3.00 0.0492 4.01 0.0094 5.02 0.0144
   6.04 0.0103 7.07 0.0117 8.12 0.0006 9.19 0.0019 10.25 0.0007
   11.35 0.0017 12.45 0.0010 13.58 0.0003 14.74 0.0003 15.91 0.0003
   19.57 0.0002 ) constant p-g4

'( 0.99 0.2455 1.99 0.0161 3.00 0.0215 4.01 0.0036 5.03 0.0049
   6.04 0.0012 7.09 0.0036 8.14 0.0011 9.21 0.0009 10.30 0.0001
   11.40 0.0012 12.50 0.0001 13.66 0.0005 14.84 0.0001 ) constant p-gs4

'( 1.00 0.1132 2.00 0.0252 3.00 0.0292 4.01 0.0136 5.03 0.0045
   6.06 0.0022 7.11 0.0101 8.17 0.0004 9.23 0.0010 10.33 0.0012
   11.44 0.0013 12.58 0.0011 13.75 0.0002 14.93 0.0005 16.14 0.0002 ) constant p-a4

'( 1.00 0.1655 2.00 0.0445 3.00 0.0120 4.00 0.0038 5.02 0.0015
   6.07 0.0038 7.11 0.0003 8.19 0.0002 9.25 0.0010 10.36 0.0011
   11.48 0.0005 12.63 0.0002 13.79 0.0003 16.24 0.0002 ) constant p-as4

'( 0.99 0.3637 1.99 0.0259 3.01 0.0038 4.01 0.0057 5.03 0.0040
   6.07 0.0067 7.12 0.0014 8.19 0.0004 9.27 0.0003 10.38 0.0002
   12.67 0.0001 ) constant p-b4

'( 1.00 0.1193 2.00 0.0230 3.00 0.0104 4.01 0.0084 5.04 0.0047
   6.08 0.0035 7.13 0.0041 8.20 0.0002 9.29 0.0005 10.40 0.0005
   11.53 0.0003 12.70 0.0002 13.91 0.0002 ) constant p-c5

'( 1.00 0.0752 2.00 0.0497 3.00 0.0074 4.02 0.0076 5.05 0.0053
   6.09 0.0043 7.15 0.0024 8.22 0.0001 9.32 0.0006 10.45 0.0002
   11.58 0.0001 12.78 0.0001 15.22 0.0001 ) constant p-cs5

'( 1.00 0.2388 2.00 0.0629 3.01 0.0159 4.04 0.0063 5.07 0.0051
   6.12 0.0045 7.19 0.0026 8.29 0.0015 9.43 0.0001 11.75 0.0002 ) constant p-d5

'( 1.00 0.1919 2.01 0.0116 3.01 0.0031 4.03 0.0090 5.07 0.0061
   6.13 0.0036 7.19 0.0013 8.30 0.0016 9.13 0.0001 10.59 0.0002
   11.78 0.0002 ) constant p-ds5

'( 1.00 0.1296 2.00 0.0135 3.01 0.0041 4.04 0.0045 5.09 0.0028
   6.14 0.0046 7.23 0.0007 8.32 0.0007 9.50 0.0001 ) constant p-e5

'( 1.00 0.0692 2.00 0.0209 3.02 0.0025 4.05 0.0030 5.09 0.0047
   6.17 0.0022 7.25 0.0015 8.36 0.0015 9.53 0.0010 10.69 0.0001
   13.40 0.0001 ) constant p-f5

'( 1.00 0.1715 2.00 0.0142 3.01 0.0024 4.03 0.0015 5.07 0.0017
   6.13 0.0018 7.22 0.0009 8.33 0.0014 9.51 0.0007 10.69 0.0002 ) constant p-fs5

'( 1.00 0.1555 2.01 0.0148 3.02 0.0007 4.06 0.0006 5.10 0.0005
   6.16 0.0008 7.26 0.0009 8.39 0.0008 9.58 0.0002 ) constant p-g5

'( 1.00 0.1357 2.00 0.0116 3.02 0.0026 4.04 0.0009 5.09 0.0004
   6.17 0.0005 7.27 0.0002 8.40 0.0001 ) constant p-gs5

'( 1.00 0.2185 2.01 0.0087 3.03 0.0018 4.06 0.0025 5.11 0.0020
   6.20 0.0012 7.32 0.0005 8.46 0.0001 9.66 0.0003 ) constant p-a5

'( 1.00 0.2735 2.00 0.0038 3.02 0.0008 4.06 0.0012 5.12 0.0008
   6.22 0.0011 7.35 0.0003 8.50 0.0002 ) constant p-as5

'( 1.00 0.1441 1.99 0.0062 3.01 0.0023 4.05 0.0011 5.11 0.0012
   6.20 0.0003 7.33 0.0004 8.50 0.0001 ) constant p-b5

'( 1.00 0.0726 2.01 0.0293 3.03 0.0022 5.14 0.0005 6.26 0.0011
   7.41 0.0002 8.63 0.0002 ) constant p-c6

'( 1.00 0.0516 2.00 0.0104 3.02 0.0029 5.15 0.0002 6.27 0.0001 ) constant p-cs6

'( 1.00 0.0329 2.00 0.0033 3.03 0.0013 4.10 0.0005 5.19 0.0004
   6.32 0.0002 ) constant p-d6

'( 1.00 0.0179 1.99 0.0012 3.04 0.0005 4.10 0.0017 5.20 0.0005
   6.35 0.0001 ) constant p-ds6

'( 1.00 0.0334 2.01 0.0033 3.04 0.0011 4.13 0.0003 5.22 0.0003 ) constant p-e6

'( 0.99 0.0161 2.01 0.0100 3.04 0.0020 4.13 0.0003 ) constant p-f6

'( 1.00 0.0475 1.99 0.0045 3.03 0.0035 4.12 0.0011 ) constant p-fs6

'( 1.00 0.0593 2.00 0.0014 4.17 0.0002 ) constant p-g6

'( 1.00 0.0249 2.01 0.0016 ) constant p-gs6

'( 1.00 0.0242 2.00 0.0038 4.19 0.0002 ) constant p-a6

'( 1.00 0.0170 2.02 0.0030 ) constant p-as6

'( 1.00 0.0381 2.00 0.0017 3.09 0.0002 ) constant p-b6

'( 1.00 0.0141 2.03 0.0005 3.11 0.0003 4.26 0.0001 ) constant p-c7

'( 1.00 0.0122 2.03 0.0024 ) constant p-cs7

'( 1.00 0.0107 2.07 0.0007 3.12 0.0004 ) constant p-d7

'( 1.00 0.0250 2.02 0.0026 3.15 0.0002 ) constant p-ds7

'( 1.01 0.0092 ) constant p-e7

'( 1.01 0.0102 2.09 0.0005 ) constant p-f7

'( 1.00 0.0080 2.00 0.0005 3.19 0.0001 ) constant p-fs7

'( 1.01 0.0298 2.01 0.0005 ) constant p-g7

\ **********************************************************
\ sax
\ **********************************************************

'( 1.01 0.0565 2.01 0.0374 3.00 0.0377 4.00 0.0498 5.02 0.0907
   6.02 0.0361 7.02 0.0250 8.01 0.0036 9.02 0.0181 10.03 0.0319
   11.03 0.0075 12.03 0.0068 13.03 0.0037 14.03 0.0015 15.05 0.0021
   16.04 0.0034 17.04 0.0076 18.04 0.0101 19.06 0.0056 20.06 0.0051
   21.05 0.0046 22.05 0.0029 23.05 0.0015 24.07 0.0026 25.07 0.0023
   26.06 0.0025 27.06 0.0010 28.08 0.0011 29.08 0.0005 30.07 0.0017
   31.07 0.0025 32.07 0.0032 33.09 0.0026 34.09 0.0023 35.09 0.0038
   36.09 0.0023 37.09 0.0018 38.11 0.0023 39.11 0.0017 40.10 0.0015
   41.10 0.0010 42.10 0.0008 43.13 0.0004 45.13 0.0001 46.11 0.0005
   47.12 0.0004 48.12 0.0006 49.11 0.0004 50.12 0.0008 51.13 0.0006
   52.14 0.0009 53.13 0.0006 54.13 0.0008 55.13 0.0007 56.15 0.0005
   57.16 0.0002 58.13 0.0001 59.17 0.0001 61.15 0.0001 62.15 0.0002
   63.16 0.0002 65.17 0.0004 66.18 0.0005 67.18 0.0003 68.17 0.0002
   69.17 0.0005 70.18 0.0003 71.18 0.0002 72.18 0.0005 73.18 0.0003
   74.18 0.0003 75.20 0.0003 76.19 0.0003 77.19 0.0002 78.19 0.0004
   80.20 0.0002 81.19 0.0001 82.21 0.0001 89.23 0.0002 90.23 0.0002
   91.23 0.0003 92.22 0.0001 ) constant sax-cs3

'( 1.00 0.0423 1.99 0.0487 2.98 0.0259 3.99 0.0630 4.99 0.1026
   5.97 0.0532 6.97 0.0259 7.98 0.0110 8.97 0.0076 9.96 0.0123
   10.97 0.0162 11.96 0.0128 12.95 0.0178 13.94 0.0114 14.96 0.0134
   15.95 0.0186 16.94 0.0180 17.93 0.0087 18.94 0.0084 19.93 0.0064
   20.92 0.0033 21.93 0.0025 22.93 0.0041 23.91 0.0041 24.90 0.0034
   25.91 0.0012 26.90 0.0013 27.90 0.0020 28.89 0.0036 29.90 0.0054
   30.89 0.0054 31.88 0.0038 32.89 0.0059 33.89 0.0037 34.88 0.0024
   35.86 0.0024 36.87 0.0023 37.87 0.0017 38.86 0.0020 39.85 0.0019
   40.86 0.0021 41.86 0.0007 42.84 0.0012 43.84 0.0007 44.84 0.0010
   45.85 0.0005 46.82 0.0006 47.84 0.0009 48.82 0.0009 49.82 0.0006
   50.81 0.0008 51.82 0.0012 52.80 0.0012 54.81 0.0005 55.78 0.0003
   56.79 0.0003 57.78 0.0003 58.79 0.0003 59.80 0.0004 60.77 0.0003
   61.78 0.0004 62.77 0.0005 63.77 0.0001 64.75 0.0004 65.76 0.0003
   66.77 0.0003 67.76 0.0006 68.75 0.0006 69.75 0.0007 70.74 0.0004
   71.74 0.0010 72.73 0.0008 73.74 0.0007 75.74 0.0002 76.72 0.0004
   77.72 0.0002 78.71 0.0004 79.70 0.0001 80.71 0.0001 81.70 0.0002
   82.70 0.0001 83.70 0.0004 84.69 0.0003 85.68 0.0008 86.68 0.0003
   87.69 0.0001 88.69 0.0002 90.66 0.0001 ) constant sax-d3

'( 1.00 0.0338 1.99 0.0765 2.97 0.0602 3.96 0.0870 4.97 0.1666
   5.96 0.0394 6.95 0.0067 7.94 0.0199 8.94 0.0418 9.93 0.0110
   10.92 0.0101 11.91 0.0077 12.90 0.0052 13.91 0.0148 14.90 0.0172
   15.88 0.0218 16.87 0.0110 17.88 0.0086 18.87 0.0045 19.86 0.0009
   20.85 0.0014 21.85 0.0045 22.84 0.0037 23.83 0.0010 24.82 0.0028
   25.81 0.0013 26.82 0.0032 27.81 0.0040 28.79 0.0067 29.78 0.0035
   30.79 0.0041 31.78 0.0028 32.76 0.0017 33.75 0.0011 34.76 0.0015
   35.75 0.0018 36.73 0.0021 37.72 0.0017 38.71 0.0019 39.72 0.0014
   40.71 0.0015 41.70 0.0016 42.69 0.0006 43.69 0.0021 44.69 0.0024
   45.67 0.0003 46.66 0.0014 47.66 0.0002 48.66 0.0011 49.65 0.0010
   50.63 0.0002 51.62 0.0008 52.63 0.0007 53.62 0.0008 54.60 0.0004
   56.59 0.0005 57.59 0.0003 58.58 0.0007 60.56 0.0004 61.56 0.0002
   62.55 0.0004 63.54 0.0004 64.53 0.0008 65.54 0.0011 66.53 0.0003
   67.52 0.0009 68.51 0.0008 69.51 0.0013 70.50 0.0002 71.49 0.0004
   72.47 0.0004 73.47 0.0002 74.48 0.0002 75.46 0.0002 76.45 0.0005
   77.45 0.0003 78.45 0.0008 79.44 0.0003 80.42 0.0008 81.41 0.0005
   82.41 0.0001 83.42 0.0001 ) constant sax-ds3

'( 1.00 0.0225 1.99 0.0627 2.99 0.0834 3.98 0.0804 4.98 0.0984
   5.97 0.0393 6.96 0.0345 7.96 0.0102 8.95 0.0084 9.94 0.0129
   10.93 0.0214 11.93 0.0154 12.92 0.0184 13.91 0.0167 14.91 0.0213
   15.90 0.0116 16.89 0.0090 17.88 0.0045 18.88 0.0008 19.87 0.0024
   20.86 0.0045 21.86 0.0058 22.85 0.0012 23.84 0.0012 24.84 0.0030
   25.83 0.0035 26.82 0.0067 27.83 0.0048 28.82 0.0016 29.82 0.0012
   30.81 0.0015 31.81 0.0032 32.80 0.0033 33.80 0.0038 34.79 0.0032
   35.78 0.0025 36.78 0.0008 37.77 0.0007 38.76 0.0020 39.75 0.0009
   40.75 0.0007 41.74 0.0018 42.73 0.0024 43.72 0.0012 44.72 0.0016
   45.71 0.0015 46.70 0.0019 47.69 0.0005 48.69 0.0007 49.68 0.0006
   50.67 0.0003 51.68 0.0006 52.67 0.0002 53.66 0.0004 54.65 0.0004
   55.65 0.0005 56.64 0.0004 57.64 0.0006 58.64 0.0004 59.64 0.0004
   60.63 0.0011 61.62 0.0004 62.62 0.0003 63.61 0.0005 64.60 0.0011
   65.60 0.0010 65.74 0.0001 66.59 0.0001 67.58 0.0006 68.57 0.0007
   69.56 0.0003 70.56 0.0002 71.56 0.0002 72.55 0.0007 73.54 0.0009
   74.53 0.0008 75.52 0.0007 76.52 0.0006 77.51 0.0002 79.50 0.0002 ) constant sax-e3

'( 0.98 0.0394 1.98 0.0562 2.97 0.0897 3.96 0.0683 4.96 0.0231
   5.95 0.0309 6.94 0.0308 7.91 0.0176 8.91 0.0089 9.90 0.0084
   10.89 0.0141 11.89 0.0045 12.88 0.0070 13.87 0.0083 14.85 0.0142
   15.84 0.0089 16.83 0.0048 17.82 0.0015 18.82 0.0028 19.82 0.0027
   20.81 0.0015 21.79 0.0012 22.77 0.0015 23.76 0.0050 24.76 0.0041
   25.75 0.0048 26.75 0.0015 27.74 0.0007 28.73 0.0011 29.71 0.0016
   30.70 0.0020 31.69 0.0019 32.68 0.0032 33.68 0.0026 34.67 0.0014
   35.66 0.0013 36.64 0.0009 37.63 0.0014 38.62 0.0009 39.61 0.0018
   40.61 0.0008 41.60 0.0013 42.59 0.0007 43.57 0.0010 44.56 0.0006
   45.57 0.0002 46.54 0.0009 47.53 0.0005 48.51 0.0002 49.53 0.0001
   50.52 0.0005 51.49 0.0002 52.49 0.0006 53.47 0.0001 54.48 0.0002
   55.46 0.0003 56.47 0.0002 57.45 0.0006 58.43 0.0004 59.42 0.0003
   60.41 0.0006 61.41 0.0005 62.40 0.0005 63.40 0.0002 64.38 0.0003
   65.37 0.0001 66.35 0.0002 68.34 0.0005 69.33 0.0003 70.33 0.0005
   71.32 0.0001 72.30 0.0002 75.27 0.0001 ) constant sax-f3

'( 0.99 0.0784 1.99 0.0550 2.97 0.0439 3.97 0.0998 4.95 0.0679
   5.95 0.0244 6.93 0.0178 7.94 0.0130 8.92 0.0186 9.92 0.0204
   10.90 0.0091 11.90 0.0102 12.88 0.0166 13.88 0.0130 14.86 0.0079
   15.86 0.0039 16.86 0.0023 17.84 0.0052 18.84 0.0049 19.82 0.0042
   20.82 0.0027 21.81 0.0027 22.80 0.0057 23.78 0.0042 24.79 0.0042
   25.77 0.0015 26.77 0.0008 27.75 0.0020 28.75 0.0021 29.73 0.0032
   30.73 0.0036 31.71 0.0022 32.71 0.0011 33.71 0.0015 34.69 0.0011
   35.69 0.0012 36.67 0.0013 37.67 0.0014 38.65 0.0006 39.65 0.0013
   40.64 0.0004 41.63 0.0010 42.62 0.0002 43.62 0.0010 44.60 0.0003
   45.59 0.0003 46.58 0.0004 47.59 0.0005 48.57 0.0002 49.55 0.0005
   50.55 0.0002 51.54 0.0002 52.53 0.0005 53.53 0.0006 54.52 0.0006
   55.51 0.0002 56.50 0.0008 57.47 0.0003 58.48 0.0007 59.47 0.0003
   60.46 0.0002 61.44 0.0002 62.45 0.0002 63.43 0.0001 64.43 0.0004
   65.42 0.0005 66.41 0.0007 67.40 0.0002 68.39 0.0002 69.39 0.0002
   70.37 0.0001 ) constant sax-fs3

'( 1.00 0.1076 1.99 0.0463 2.98 0.1092 3.97 0.0816 4.95 0.0831
   5.94 0.0118 6.93 0.0095 7.94 0.0104 8.93 0.0148 9.92 0.0144
   10.91 0.0117 11.90 0.0196 12.89 0.0153 13.88 0.0107 14.87 0.0052
   15.86 0.0033 16.86 0.0058 17.85 0.0042 18.83 0.0013 19.83 0.0029
   20.82 0.0067 21.81 0.0040 22.80 0.0057 23.79 0.0022 24.79 0.0019
   25.78 0.0009 26.78 0.0017 27.76 0.0025 28.76 0.0024 29.74 0.0020
   30.73 0.0011 31.72 0.0010 32.73 0.0007 33.72 0.0013 34.70 0.0019
   35.69 0.0017 36.69 0.0011 37.67 0.0006 38.67 0.0008 39.67 0.0005
   40.66 0.0005 41.65 0.0011 42.64 0.0003 43.63 0.0004 44.62 0.0007
   45.60 0.0007 46.60 0.0006 47.59 0.0006 48.59 0.0003 49.59 0.0007
   50.57 0.0006 51.57 0.0007 52.55 0.0003 53.54 0.0008 54.53 0.0005
   55.53 0.0005 56.51 0.0003 57.52 0.0005 59.50 0.0001 60.48 0.0002
   61.47 0.0006 62.46 0.0005 63.46 0.0003 64.46 0.0002 65.45 0.0002 ) constant sax-g3

'( 0.98 0.0781 1.97 0.0393 2.96 0.0842 3.94 0.0434 4.93 0.0378
   5.91 0.0141 6.89 0.0201 7.87 0.0294 8.86 0.0169 9.85 0.0124
   10.84 0.0137 11.81 0.0238 12.80 0.0172 13.78 0.0094 14.77 0.0040
   15.76 0.0036 16.74 0.0061 17.72 0.0032 18.70 0.0035 19.69 0.0086
   20.68 0.0065 21.66 0.0097 22.65 0.0036 23.63 0.0010 24.62 0.0006
   25.61 0.0018 26.59 0.0026 27.58 0.0023 28.56 0.0017 29.54 0.0010
   30.52 0.0012 31.50 0.0018 32.50 0.0021 33.48 0.0025 34.46 0.0010
   35.45 0.0028 36.42 0.0018 37.41 0.0009 38.41 0.0007 39.38 0.0006
   40.37 0.0004 41.36 0.0005 42.34 0.0007 43.31 0.0001 44.29 0.0002
   45.29 0.0006 46.28 0.0005 47.26 0.0005 48.25 0.0006 49.22 0.0006
   50.21 0.0003 51.20 0.0007 52.18 0.0004 53.16 0.0003 54.15 0.0004
   55.14 0.0001 56.10 0.0001 57.11 0.0005 58.09 0.0007 59.07 0.0005
   59.22 0.0001 61.04 0.0004 63.02 0.0002 ) constant sax-gs3

'( 0.99 0.0950 1.97 0.0374 2.95 0.0738 3.94 0.0772 4.93 0.0103
   5.92 0.0135 6.90 0.0099 7.88 0.0088 8.88 0.0151 9.86 0.0150
   10.84 0.0177 11.83 0.0121 12.82 0.0071 13.81 0.0049 14.79 0.0025
   15.77 0.0046 16.77 0.0023 17.75 0.0020 18.73 0.0079 19.71 0.0057
   20.70 0.0068 21.69 0.0036 22.67 0.0007 23.65 0.0003 24.65 0.0006
   25.64 0.0016 26.62 0.0013 27.60 0.0006 28.59 0.0005 29.59 0.0005
   30.56 0.0013 31.55 0.0015 32.53 0.0013 33.52 0.0009 34.51 0.0016
   35.48 0.0002 36.47 0.0007 37.46 0.0002 38.46 0.0003 39.43 0.0002
   40.42 0.0003 41.40 0.0006 42.40 0.0006 43.39 0.0002 44.36 0.0009
   45.35 0.0008 46.34 0.0010 47.32 0.0003 48.30 0.0009 49.29 0.0006
   50.28 0.0002 51.27 0.0004 52.25 0.0002 54.23 0.0003 55.21 0.0001
   56.19 0.0002 58.17 0.0002 ) constant sax-a3

'( 0.99 0.0856 1.98 0.0365 2.97 0.0409 3.96 0.0666 4.94 0.0192
   5.94 0.0263 6.92 0.0311 7.91 0.0175 8.90 0.0203 9.89 0.0358
   10.87 0.0214 11.87 0.0177 12.85 0.0068 13.84 0.0071 14.83 0.0068
   15.82 0.0040 16.80 0.0040 17.80 0.0126 18.78 0.0101 19.77 0.0086
   20.75 0.0053 21.75 0.0012 22.73 0.0026 23.73 0.0019 24.71 0.0018
   25.71 0.0026 26.68 0.0023 27.68 0.0022 28.66 0.0015 29.66 0.0031
   30.64 0.0008 31.63 0.0023 32.61 0.0029 33.61 0.0007 34.59 0.0016
   35.59 0.0009 36.57 0.0006 37.56 0.0012 38.54 0.0004 39.53 0.0005
   40.52 0.0007 41.52 0.0006 42.50 0.0009 43.50 0.0015 44.48 0.0005
   45.47 0.0012 46.46 0.0007 47.45 0.0003 48.44 0.0007 49.41 0.0003
   50.41 0.0003 51.40 0.0011 52.39 0.0007 53.37 0.0005 54.36 0.0005
   55.34 0.0002 56.34 0.0002 ) constant sax-as3

'( 0.99 0.1015 1.99 0.0817 2.98 0.0315 3.98 0.0386 4.97 0.0424
   5.96 0.0104 6.96 0.0144 7.94 0.0361 8.94 0.0182 9.93 0.0238
   10.93 0.0139 11.93 0.0063 12.91 0.0058 13.91 0.0071 14.91 0.0051
   15.89 0.0035 16.90 0.0114 17.88 0.0097 18.88 0.0081 19.87 0.0043
   20.86 0.0014 21.86 0.0009 22.85 0.0012 23.86 0.0006 24.84 0.0013
   25.83 0.0006 26.83 0.0010 27.82 0.0015 28.80 0.0008 29.80 0.0012
   30.80 0.0017 31.77 0.0002 32.78 0.0016 33.78 0.0006 34.77 0.0003
   35.77 0.0009 36.76 0.0006 37.75 0.0011 38.75 0.0006 39.74 0.0011
   40.74 0.0011 41.73 0.0006 42.72 0.0015 43.72 0.0008 44.70 0.0002
   45.71 0.0005 46.70 0.0004 47.69 0.0003 48.69 0.0005 49.67 0.0005
   50.64 0.0001 51.66 0.0003 ) constant sax-b3

'( 0.99 0.1462 1.98 0.0760 2.98 0.0464 3.97 0.0292 4.95 0.0393
   5.95 0.0117 6.94 0.0150 7.93 0.0251 8.93 0.0238 9.92 0.0182
   10.90 0.0142 11.89 0.0100 12.89 0.0108 13.88 0.0029 14.87 0.0060
   15.86 0.0116 16.85 0.0066 17.84 0.0072 18.84 0.0034 19.83 0.0010
   20.82 0.0013 21.81 0.0015 22.80 0.0012 23.80 0.0011 24.79 0.0004
   25.77 0.0027 26.76 0.0021 27.75 0.0018 28.75 0.0013 29.74 0.0015
   30.73 0.0008 31.72 0.0004 32.71 0.0007 33.71 0.0011 34.70 0.0002
   35.68 0.0010 36.67 0.0002 37.66 0.0003 38.67 0.0010 39.66 0.0008
   40.64 0.0019 41.64 0.0005 42.62 0.0010 43.62 0.0003 45.60 0.0005
   46.59 0.0002 47.59 0.0002 48.58 0.0002 49.57 0.0002 50.55 0.0001 ) constant sax-c4

'( 0.99 0.0832 1.97 0.0162 2.96 0.0337 3.95 0.0272 4.94 0.0264
   5.93 0.0256 6.93 0.0180 7.92 0.0206 8.90 0.0167 9.89 0.0172
   10.88 0.0075 11.86 0.0087 12.85 0.0048 13.85 0.0051 14.83 0.0134
   15.83 0.0091 16.82 0.0065 17.80 0.0008 18.80 0.0018 19.78 0.0023
   20.77 0.0025 21.76 0.0021 22.74 0.0013 23.74 0.0011 24.72 0.0032
   25.72 0.0006 26.72 0.0005 27.69 0.0026 28.69 0.0009 29.68 0.0006
   30.66 0.0003 31.65 0.0007 32.64 0.0003 33.62 0.0014 34.61 0.0007
   35.60 0.0007 36.59 0.0005 37.60 0.0004 38.56 0.0006 39.54 0.0004
   40.55 0.0004 41.55 0.0003 42.50 0.0002 43.51 0.0005 44.50 0.0003
   45.50 0.0002 46.48 0.0002 47.48 0.0002 ) constant sax-cs4

'( 0.98 0.0860 1.97 0.0143 2.95 0.0061 3.94 0.0407 4.93 0.0204
   5.91 0.0066 6.90 0.0372 7.89 0.0217 8.87 0.0220 9.86 0.0147
   10.85 0.0042 11.83 0.0072 12.82 0.0023 13.81 0.0074 14.79 0.0104
   15.78 0.0050 16.76 0.0005 17.74 0.0036 18.73 0.0056 19.71 0.0022
   20.70 0.0040 21.69 0.0021 22.68 0.0018 23.66 0.0026 24.65 0.0035
   25.64 0.0021 26.62 0.0011 27.61 0.0013 28.59 0.0006 29.58 0.0002
   30.57 0.0010 31.69 0.0001 32.54 0.0004 33.52 0.0009 34.50 0.0005
   35.49 0.0004 36.47 0.0013 37.46 0.0015 38.45 0.0009 39.43 0.0003
   40.42 0.0004 41.41 0.0008 42.40 0.0005 43.38 0.0004 44.37 0.0006 ) constant sax-d4

'( 0.98 0.0870 1.97 0.0204 2.96 0.0184 3.94 0.0494 4.92 0.0500
   5.91 0.0163 6.90 0.0267 7.88 0.0158 8.86 0.0159 9.85 0.0095
   10.84 0.0095 11.82 0.0039 12.81 0.0053 13.79 0.0074 14.78 0.0054
   15.77 0.0004 16.75 0.0027 17.73 0.0034 18.71 0.0035 19.70 0.0019
   20.69 0.0028 21.67 0.0032 22.65 0.0016 23.64 0.0018 24.63 0.0033
   25.61 0.0006 26.59 0.0015 27.58 0.0005 28.57 0.0010 29.56 0.0006
   30.54 0.0010 31.52 0.0009 32.51 0.0004 33.50 0.0012 34.47 0.0006
   35.46 0.0009 36.45 0.0007 37.44 0.0002 38.42 0.0006 39.41 0.0003
   40.38 0.0003 41.38 0.0005 42.36 0.0003 ) constant sax-ds4

'( 0.99 0.0111 1.97 0.0520 2.96 0.0287 3.94 0.0704 4.93 0.0240
   5.91 0.0286 6.89 0.0516 7.89 0.0184 8.87 0.0076 9.86 0.0113
   10.84 0.0049 11.83 0.0044 12.81 0.0111 13.79 0.0080 14.78 0.0008
   15.76 0.0031 16.76 0.0042 17.74 0.0016 18.73 0.0021 19.71 0.0010
   20.69 0.0048 21.68 0.0014 22.66 0.0020 23.66 0.0016 24.64 0.0011
   25.62 0.0011 26.61 0.0001 27.59 0.0011 28.58 0.0013 29.56 0.0011
   30.55 0.0004 31.54 0.0015 32.52 0.0023 33.51 0.0015 34.49 0.0004
   35.48 0.0003 36.46 0.0007 37.45 0.0003 38.43 0.0003 39.42 0.0009 ) constant sax-e4

'( 1.00 0.0896 2.00 0.1802 3.00 0.0636 4.00 0.0344 5.01 0.0214
   6.01 0.0196 7.01 0.0241 8.01 0.0118 9.01 0.0057 10.01 0.0060
   11.01 0.0059 12.01 0.0032 13.02 0.0055 14.02 0.0023 15.01 0.0020
   16.02 0.0027 17.02 0.0022 18.02 0.0017 19.02 0.0015 20.02 0.0020
   21.03 0.0014 22.03 0.0010 23.02 0.0006 24.03 0.0007 25.03 0.0005
   27.03 0.0006 28.03 0.0005 29.04 0.0003 30.04 0.0009 31.03 0.0006
   32.04 0.0003 33.04 0.0002 34.04 0.0003 35.04 0.0001 36.04 0.0002
   37.05 0.0003 ) constant sax-f4

'( 0.99 0.0786 1.99 0.1613 2.99 0.0550 3.98 0.0380 4.98 0.0201
   5.98 0.0245 6.97 0.0212 7.96 0.0069 8.96 0.0130 9.96 0.0029
   10.95 0.0084 11.95 0.0093 12.94 0.0026 13.94 0.0015 14.93 0.0022
   15.93 0.0025 16.93 0.0022 17.92 0.0015 18.91 0.0011 19.91 0.0011
   20.91 0.0006 21.90 0.0010 22.89 0.0003 23.89 0.0003 24.89 0.0004
   25.89 0.0003 26.88 0.0011 26.95 0.0003 27.87 0.0003 28.87 0.0012
   29.87 0.0002 30.86 0.0004 31.85 0.0003 32.85 0.0005 33.84 0.0006
   34.84 0.0002 34.90 0.0001 ) constant sax-fs4

'( 1.00 0.0747 2.00 0.1351 3.00 0.0384 4.00 0.0519 5.00 0.0376
   6.00 0.0323 7.00 0.0212 8.00 0.0091 9.00 0.0086 10.00 0.0060
   11.00 0.0132 12.00 0.0038 13.00 0.0016 14.00 0.0044 15.00 0.0023
   16.00 0.0029 17.00 0.0031 18.00 0.0011 19.00 0.0008 20.00 0.0006
   21.01 0.0005 22.00 0.0006 23.00 0.0007 24.00 0.0008 25.01 0.0003
   26.01 0.0017 27.00 0.0012 28.00 0.0005 29.03 0.0001 30.00 0.0004
   31.00 0.0005 32.00 0.0001 33.00 0.0003 34.00 0.0001 ) constant sax-g4

'( 1.00 0.0671 1.99 0.0676 2.98 0.0664 3.97 0.0207 4.97 0.0170
   5.96 0.0406 6.96 0.0157 7.95 0.0093 8.94 0.0032 9.93 0.0117
   10.93 0.0059 11.93 0.0034 12.92 0.0052 13.91 0.0036 14.90 0.0010
   15.89 0.0023 16.89 0.0019 17.89 0.0011 18.88 0.0013 19.87 0.0009
   20.86 0.0005 21.86 0.0006 22.86 0.0011 23.85 0.0006 24.85 0.0008
   25.83 0.0010 26.83 0.0010 27.82 0.0007 28.80 0.0002 29.82 0.0006
   31.80 0.0001 ) constant sax-gs4

'( 0.99 0.0707 1.99 0.1376 2.99 0.0767 3.98 0.0191 4.98 0.0316
   5.97 0.0241 6.97 0.0070 7.97 0.0095 8.96 0.0085 9.96 0.0109
   10.96 0.0012 11.95 0.0047 12.94 0.0051 13.94 0.0022 14.93 0.0020
   15.93 0.0007 16.93 0.0016 17.92 0.0014 18.92 0.0008 19.92 0.0005
   20.91 0.0008 21.91 0.0005 22.91 0.0002 23.90 0.0008 24.89 0.0015
   25.89 0.0004 26.89 0.0003 27.88 0.0002 28.88 0.0002 29.88 0.0002 ) constant sax-a4

'( 0.99 0.0652 1.98 0.0768 2.97 0.0399 3.96 0.0314 4.95 0.0539
   5.94 0.0282 6.93 0.0048 7.93 0.0059 8.91 0.0163 9.90 0.0039
   10.89 0.0052 11.88 0.0086 12.87 0.0025 13.86 0.0011 14.85 0.0069
   15.84 0.0006 16.84 0.0018 17.82 0.0008 18.80 0.0004 19.81 0.0004
   20.78 0.0002 21.79 0.0010 22.78 0.0038 23.76 0.0018 24.75 0.0010
   25.74 0.0002 26.73 0.0005 27.72 0.0006 28.71 0.0003 ) constant sax-as4

'( 1.00 0.1365 1.99 0.0773 2.98 0.0370 3.97 0.0399 4.97 0.0441
   5.96 0.0193 6.95 0.0055 7.95 0.0036 8.94 0.0106 9.93 0.0050
   10.93 0.0075 11.92 0.0047 12.91 0.0013 13.90 0.0034 14.90 0.0024
   15.89 0.0018 16.89 0.0005 17.87 0.0006 18.87 0.0014 19.87 0.0011
   20.86 0.0017 21.84 0.0018 22.84 0.0007 23.83 0.0003 24.82 0.0006
   25.83 0.0002 26.81 0.0002 ) constant sax-b4

'( 0.99 0.1197 1.98 0.0661 2.97 0.0448 3.96 0.0398 4.96 0.0311
   5.95 0.0167 6.93 0.0068 7.93 0.0249 8.92 0.0065 9.91 0.0104
   10.90 0.0081 11.89 0.0032 12.88 0.0060 13.87 0.0037 14.86 0.0020
   15.86 0.0008 16.84 0.0005 17.84 0.0025 18.83 0.0010 19.81 0.0020
   20.81 0.0017 21.80 0.0013 22.79 0.0016 23.78 0.0009 24.77 0.0006
   25.76 0.0002 ) constant sax-c5

'( 0.98 0.0251 1.97 0.0316 2.95 0.0599 3.93 0.0403 4.92 0.0418
   5.90 0.0065 6.89 0.0047 7.86 0.0085 8.85 0.0061 9.84 0.0097
   10.82 0.0033 10.87 0.0006 12.26 0.0004 12.78 0.0040 13.77 0.0023
   14.75 0.0020 15.73 0.0003 16.72 0.0011 17.71 0.0012 18.69 0.0013
   19.67 0.0008 20.66 0.0013 21.64 0.0005 22.62 0.0004 23.60 0.0005 ) constant sax-cs5

'( 0.99 0.0055 1.97 0.0823 2.95 0.0106 3.94 0.0646 4.93 0.0345
   5.91 0.0069 6.90 0.0201 7.89 0.0165 8.87 0.0171 9.86 0.0114
   10.85 0.0050 11.82 0.0053 12.82 0.0107 13.81 0.0033 14.78 0.0026
   15.78 0.0016 16.76 0.0019 17.74 0.0011 18.72 0.0030 19.73 0.0009
   20.70 0.0021 21.67 0.0003 22.67 0.0003 23.65 0.0001 ) constant sax-d5

'( 0.98 0.0699 1.97 0.0761 2.95 0.0777 3.93 0.0573 4.92 0.0236
   5.90 0.0082 6.88 0.0195 7.87 0.0108 8.85 0.0205 9.83 0.0042
   10.82 0.0112 11.80 0.0039 12.78 0.0018 13.77 0.0027 14.75 0.0017
   15.73 0.0015 16.72 0.0019 17.70 0.0047 18.68 0.0011 19.67 0.0020
   20.65 0.0027 21.63 0.0002 ) constant sax-ds5

'( 0.99 0.1082 1.99 0.1222 2.99 0.0874 3.98 0.0436 4.98 0.0208
   5.98 0.0141 6.97 0.0193 7.97 0.0172 8.97 0.0118 9.96 0.0082
   10.96 0.0133 11.96 0.0062 12.95 0.0058 13.95 0.0013 14.94 0.0017
   15.94 0.0029 16.94 0.0032 17.93 0.0006 18.93 0.0028 19.92 0.0004 ) constant sax-e5

'( 1.00 0.1462 2.00 0.0665 3.01 0.0741 4.01 0.0382 5.01 0.0262
   6.02 0.0172 7.02 0.0168 8.02 0.0172 9.02 0.0087 10.02 0.0145
   11.03 0.0046 12.03 0.0033 13.03 0.0032 14.03 0.0030 15.03 0.0040
   16.04 0.0059 17.04 0.0026 18.04 0.0005 19.05 0.0009 ) constant sax-f5

'( 1.00 0.0652 2.00 0.0563 3.00 0.0939 3.99 0.0334 5.00 0.0109
   5.99 0.0258 6.99 0.0213 7.99 0.0135 8.99 0.0018 9.99 0.0205
   10.99 0.0043 11.99 0.0004 12.99 0.0037 13.98 0.0017 14.98 0.0071
   15.98 0.0035 16.98 0.0029 17.98 0.0005 ) constant sax-fs5

'( 1.00 0.0918 1.99 0.0493 2.99 0.0565 3.98 0.0225 4.98 0.0118
   5.98 0.0184 6.97 0.0138 7.99 0.0042 8.98 0.0077 9.95 0.0104
   10.96 0.0018 11.94 0.0022 12.98 0.0061 13.96 0.0032 14.96 0.0023
   15.96 0.0016 16.90 0.0008 ) constant sax-g5

'( 0.99 0.1447 1.98 0.0908 2.97 0.0522 3.96 0.0607 4.96 0.0316
   5.95 0.0115 6.94 0.0147 7.93 0.0148 8.92 0.0221 9.91 0.0097
   10.90 0.0087 11.90 0.0078 12.89 0.0127 13.88 0.0042 14.87 0.0007
   15.86 0.0012 ) constant sax-gs5

'( 0.97 0.1089 1.94 0.0491 4.85 0.0162 5.82 0.0156 6.78 0.0130
   7.75 0.0174 8.72 0.0104 8.75 0.0087 8.77 0.0024 8.80 0.0019
   8.82 0.0014 9.72 0.0010 10.66 0.0033 11.63 0.0092 11.66 0.0045
   12.59 0.0028 12.65 0.0015 12.67 0.0011 13.64 0.0007 14.56 0.0017
   14.59 0.0017 14.61 0.0010 14.62 0.0008 14.64 0.0005 15.50 0.0003
   15.53 0.0002 15.56 0.0002 15.58 0.0001 ) constant sax-a5

\ **********************************************************
\ soprano sax
\ **********************************************************

'( 1.01 0.0846 2.02 0.0851 3.03 0.0782 4.03 0.0250 5.04 0.0513
   6.05 0.0121 7.07 0.0065 8.08 0.0409 9.09 0.0134 10.09 0.0032
   11.10 0.0168 12.12 0.0076 13.13 0.0054 14.13 0.0091 15.14 0.0078
   16.15 0.0029 17.16 0.0103 18.18 0.0103 19.18 0.0071 20.19 0.0105
   21.20 0.0063 22.20 0.0054 23.21 0.0011 24.22 0.0008 25.24 0.0003
   26.23 0.0001 27.26 0.0002 28.25 0.0006 29.27 0.0004 30.29 0.0008
   31.29 0.0004 32.31 0.0002 33.32 0.0003 34.32 0.0003 35.33 0.0001
   36.34 0.0002 37.35 0.0005 38.36 0.0003 39.37 0.0003 40.37 0.0002
   41.39 0.0002 42.40 0.0002 43.41 0.0002 44.43 0.0001 45.43 0.0007
   46.43 0.0004 47.44 0.0002 48.46 0.0001 49.48 0.0001 50.48 0.0002
   51.49 0.0002 52.49 0.0002 53.50 0.0002 54.51 0.0002 55.53 0.0003
   56.54 0.0003 57.54 0.0002 58.55 0.0002 59.55 0.0001 ) constant ssax-gs3

'( 0.99 0.1143 1.99 0.0599 2.99 0.0780 3.99 0.0629 4.99 0.0063
   5.99 0.0066 6.99 0.0283 7.99 0.0134 8.98 0.0083 9.97 0.0114
   10.97 0.0087 11.97 0.0171 12.97 0.0109 13.97 0.0149 14.97 0.0075
   15.97 0.0164 16.97 0.0174 17.94 0.0021 18.97 0.0139 19.96 0.0073
   20.95 0.0122 21.95 0.0018 22.95 0.0022 23.94 0.0002 24.95 0.0014
   25.94 0.0006 26.95 0.0007 27.94 0.0012 28.94 0.0013 29.93 0.0009
   30.94 0.0014 31.92 0.0012 32.93 0.0008 33.93 0.0015 34.93 0.0021
   35.92 0.0009 36.93 0.0011 37.93 0.0011 38.94 0.0005 39.92 0.0008
   41.93 0.0004 42.91 0.0012 43.87 0.0002 44.93 0.0006 45.92 0.0006
   46.91 0.0002 47.92 0.0002 48.91 0.0004 49.89 0.0004 50.89 0.0003
   51.89 0.0003 52.90 0.0003 53.90 0.0003 54.91 0.0003 55.90 0.0003
   56.89 0.0002 ) constant ssax-a3

'( 1.00 0.0772 1.99 0.0797 2.98 0.0350 3.99 0.1086 4.98 0.0418
   5.97 0.0170 6.98 0.0247 7.97 0.0288 8.96 0.0041 9.95 0.0047
   10.95 0.0120 11.95 0.0176 12.93 0.0128 13.95 0.0151 14.94 0.0162
   15.92 0.0152 16.93 0.0077 17.93 0.0111 18.92 0.0092 19.91 0.0079
   20.91 0.0053 21.89 0.0009 22.90 0.0008 24.88 0.0004 25.88 0.0009
   26.88 0.0009 27.87 0.0014 28.87 0.0008 29.87 0.0023 30.87 0.0013
   31.85 0.0012 32.87 0.0015 33.85 0.0011 34.85 0.0024 35.84 0.0021
   36.86 0.0024 37.87 0.0008 38.82 0.0007 39.85 0.0009 40.79 0.0007
   41.83 0.0009 42.84 0.0007 43.84 0.0006 44.82 0.0001 46.83 0.0004
   47.83 0.0003 48.81 0.0003 49.82 0.0002 50.82 0.0001 51.82 0.0002
   52.81 0.0002 54.81 0.0004 55.80 0.0002 ) constant ssax-as3

'( 0.99 0.0413 1.98 0.0949 2.98 0.0746 3.96 0.0636 4.96 0.0383
   5.95 0.0300 6.93 0.0190 7.93 0.0159 8.92 0.0172 9.90 0.0159
   10.90 0.0047 11.89 0.0087 12.88 0.0153 13.87 0.0129 14.87 0.0112
   15.85 0.0054 16.84 0.0076 17.84 0.0060 18.82 0.0064 19.81 0.0050
   20.81 0.0009 21.80 0.0013 22.78 0.0003 23.79 0.0005 24.78 0.0005
   25.76 0.0020 26.75 0.0020 27.75 0.0016 28.73 0.0012 29.72 0.0009
   30.72 0.0017 31.70 0.0018 32.69 0.0012 33.69 0.0022 34.67 0.0014
   35.67 0.0015 36.66 0.0009 37.65 0.0013 38.64 0.0019 39.63 0.0010
   40.62 0.0012 41.61 0.0003 42.61 0.0003 43.60 0.0003 44.58 0.0004
   45.58 0.0003 47.55 0.0004 48.54 0.0002 49.54 0.0003 50.53 0.0002
   51.52 0.0002 ) constant ssax-b3

'( 0.99 0.1251 1.98 0.0932 2.97 0.1614 3.97 0.0801 4.96 0.0100
   5.94 0.0183 6.94 0.0221 7.93 0.0060 8.92 0.0055 9.91 0.0162
   10.90 0.0171 11.89 0.0181 12.88 0.0135 13.88 0.0102 14.87 0.0071
   15.86 0.0066 16.84 0.0071 17.83 0.0057 18.83 0.0027 19.82 0.0006
   20.82 0.0008 21.80 0.0003 22.78 0.0007 23.78 0.0011 24.77 0.0019
   25.77 0.0010 26.76 0.0016 27.74 0.0008 28.74 0.0013 29.73 0.0025
   30.72 0.0019 31.71 0.0029 32.70 0.0022 33.69 0.0011 34.68 0.0014
   35.68 0.0010 36.67 0.0014 37.65 0.0007 38.64 0.0005 39.62 0.0001
   40.63 0.0004 41.62 0.0006 42.61 0.0005 43.60 0.0003 44.58 0.0003
   45.58 0.0003 46.58 0.0006 47.57 0.0003 48.56 0.0002 ) constant ssax-c4

'( 0.98 0.0809 1.97 0.0745 2.96 0.1141 3.95 0.0537 4.95 0.0028
   5.92 0.0112 6.93 0.0029 7.90 0.0117 8.89 0.0101 9.89 0.0091
   10.87 0.0113 11.86 0.0048 12.85 0.0076 13.84 0.0054 14.82 0.0089
   15.81 0.0068 16.80 0.0065 17.79 0.0031 18.77 0.0009 19.76 0.0007
   20.75 0.0005 21.73 0.0010 22.72 0.0016 23.71 0.0009 24.70 0.0016
   25.68 0.0010 26.68 0.0018 27.66 0.0018 28.65 0.0009 29.64 0.0012
   30.63 0.0017 31.61 0.0016 32.60 0.0008 33.59 0.0012 34.58 0.0014
   35.57 0.0005 36.56 0.0006 37.54 0.0008 38.53 0.0005 39.52 0.0004
   40.50 0.0004 41.49 0.0001 42.47 0.0004 43.46 0.0002 ) constant ssax-cs4

'( 0.99 0.0919 1.98 0.0711 2.98 0.0924 3.97 0.0396 4.95 0.0407
   5.94 0.0357 6.93 0.0035 7.93 0.0079 8.91 0.0110 9.90 0.0191
   10.89 0.0103 11.89 0.0134 12.88 0.0025 13.86 0.0014 14.86 0.0082
   15.85 0.0084 16.84 0.0024 17.82 0.0011 18.82 0.0011 19.81 0.0010
   20.80 0.0002 21.79 0.0015 22.78 0.0011 23.76 0.0025 24.77 0.0018
   25.75 0.0027 26.74 0.0036 27.73 0.0023 28.73 0.0034 29.72 0.0032
   30.70 0.0011 31.70 0.0017 32.69 0.0014 33.68 0.0013 34.66 0.0004
   35.65 0.0003 36.64 0.0002 37.63 0.0002 38.62 0.0004 39.62 0.0008
   40.61 0.0004 41.60 0.0005 42.59 0.0005 43.59 0.0003 44.56 0.0002 ) constant ssax-d4

'( 0.99 0.0684 1.98 0.0744 2.97 0.1315 3.96 0.0137 4.94 0.0352
   5.94 0.0195 6.93 0.0148 7.91 0.0275 8.91 0.0191 9.90 0.0268
   10.88 0.0194 11.86 0.0044 12.86 0.0046 13.85 0.0090 14.84 0.0072
   15.83 0.0049 16.82 0.0015 17.80 0.0017 18.80 0.0006 19.79 0.0008
   20.77 0.0020 21.76 0.0010 22.75 0.0025 23.74 0.0033 24.73 0.0023
   25.72 0.0041 26.71 0.0051 27.70 0.0043 28.69 0.0033 29.68 0.0010
   30.66 0.0013 31.65 0.0013 32.64 0.0013 33.63 0.0008 34.64 0.0001
   35.61 0.0002 36.60 0.0003 37.62 0.0002 38.58 0.0006 39.57 0.0005
   40.58 0.0001 41.55 0.0002 ) constant ssax-ds4

'( 1.00 0.0363 1.98 0.1101 2.98 0.1009 3.96 0.0168 4.95 0.0610
   5.95 0.0099 6.94 0.0066 7.93 0.0157 8.92 0.0162 9.91 0.0154
   10.90 0.0131 11.89 0.0061 12.88 0.0029 13.87 0.0058 14.86 0.0040
   15.85 0.0015 16.84 0.0012 17.84 0.0005 18.82 0.0005 19.81 0.0008
   20.85 0.0007 21.80 0.0005 22.78 0.0016 23.77 0.0017 24.76 0.0022
   25.76 0.0010 26.80 0.0006 27.74 0.0012 28.72 0.0007 29.71 0.0004
   30.70 0.0004 31.69 0.0001 32.68 0.0001 33.67 0.0003 34.65 0.0004
   35.65 0.0003 36.64 0.0003 37.63 0.0002 38.61 0.0002 ) constant ssax-e4

'( 1.00 0.0607 1.99 0.1291 3.00 0.0576 3.99 0.0530 4.99 0.0330
   5.98 0.0364 6.98 0.0116 7.98 0.0252 8.97 0.0175 9.97 0.0166
   10.97 0.0147 11.97 0.0096 12.96 0.0060 13.96 0.0022 14.95 0.0018
   15.95 0.0018 16.96 0.0003 17.94 0.0012 18.94 0.0021 19.94 0.0051
   20.94 0.0018 21.93 0.0034 22.93 0.0038 23.93 0.0035 24.92 0.0041
   25.92 0.0015 26.91 0.0024 27.92 0.0019 28.92 0.0008 29.91 0.0005
   30.92 0.0003 31.91 0.0005 32.91 0.0006 33.90 0.0003 34.89 0.0002
   35.89 0.0005 36.89 0.0002 ) constant ssax-f4

'( 0.99 0.0502 1.98 0.0678 2.96 0.0319 3.95 0.0589 4.93 0.0093
   5.93 0.0072 6.91 0.0063 7.89 0.0224 8.88 0.0185 9.87 0.0096
   10.86 0.0046 11.84 0.0060 12.83 0.0052 13.82 0.0008 14.80 0.0022
   15.79 0.0009 16.79 0.0008 17.76 0.0011 18.75 0.0024 19.74 0.0013
   20.71 0.0009 21.71 0.0038 22.70 0.0037 23.68 0.0023 24.66 0.0010
   25.66 0.0007 26.64 0.0009 27.64 0.0007 28.61 0.0002 29.61 0.0006
   30.60 0.0004 31.58 0.0008 32.56 0.0004 33.55 0.0005 35.53 0.0002 ) constant ssax-fs4

'( 1.00 0.0253 1.99 0.0803 2.98 0.0107 3.97 0.0688 4.96 0.0361
   5.96 0.0208 6.96 0.0172 7.95 0.0172 8.94 0.0189 9.93 0.0080
   10.92 0.0114 11.92 0.0059 12.91 0.0058 13.90 0.0007 14.89 0.0011
   15.89 0.0011 16.88 0.0023 17.87 0.0046 18.87 0.0024 19.85 0.0043
   20.86 0.0087 21.83 0.0023 22.84 0.0043 23.84 0.0039 24.83 0.0020
   25.81 0.0017 26.81 0.0009 27.82 0.0006 28.80 0.0004 29.79 0.0007
   30.80 0.0005 31.78 0.0011 32.78 0.0004 33.76 0.0001 ) constant ssax-g4

'( 1.00 0.0453 2.00 0.1198 2.99 0.0370 3.99 0.1319 4.98 0.0327
   5.97 0.0018 6.98 0.0199 7.97 0.0362 8.97 0.0196 9.96 0.0065
   10.96 0.0061 11.96 0.0025 12.95 0.0026 13.95 0.0010 14.94 0.0005
   15.94 0.0027 16.94 0.0031 17.93 0.0037 18.92 0.0019 19.92 0.0034
   20.92 0.0087 21.92 0.0034 22.91 0.0029 23.91 0.0024 24.90 0.0006
   25.90 0.0002 26.90 0.0009 27.90 0.0003 28.90 0.0015 29.89 0.0011
   30.89 0.0004 31.88 0.0001 ) constant ssax-gs4

'( 1.00 0.0568 1.99 0.1275 2.98 0.0496 3.98 0.0504 4.97 0.0277
   5.96 0.0064 6.95 0.0205 7.95 0.0244 8.94 0.0067 9.93 0.0133
   10.92 0.0045 11.92 0.0035 12.91 0.0028 13.90 0.0010 14.90 0.0011
   15.89 0.0035 16.89 0.0034 17.88 0.0037 18.87 0.0052 19.86 0.0027
   20.86 0.0028 21.86 0.0003 22.84 0.0011 23.84 0.0005 24.83 0.0010
   25.82 0.0005 26.81 0.0003 27.81 0.0007 28.80 0.0005 29.79 0.0004 ) constant ssax-a4

'( 0.99 0.0497 1.98 0.0814 2.97 0.0351 3.96 0.0207 4.95 0.0068
   5.93 0.0241 6.92 0.0219 7.91 0.0187 8.90 0.0053 9.88 0.0026
   10.88 0.0026 11.87 0.0027 12.85 0.0011 13.85 0.0018 14.84 0.0029
   15.84 0.0013 16.83 0.0014 17.81 0.0036 18.80 0.0042 19.79 0.0015
   20.78 0.0021 21.77 0.0018 22.76 0.0011 23.75 0.0004 24.66 0.0003
   25.73 0.0006 26.72 0.0005 27.71 0.0002 ) constant ssax-as4

'( 0.99 0.0161 1.98 0.0825 2.96 0.0846 3.95 0.0304 4.94 0.0112
   5.93 0.0158 6.91 0.0362 7.90 0.0085 8.89 0.0147 9.87 0.0047
   10.85 0.0016 11.85 0.0044 12.84 0.0024 13.83 0.0044 14.82 0.0015
   15.80 0.0066 16.79 0.0061 17.78 0.0135 18.77 0.0107 19.75 0.0020
   20.75 0.0008 21.73 0.0010 22.71 0.0014 23.70 0.0007 24.69 0.0009
   25.68 0.0008 26.67 0.0002 ) constant ssax-b4

'( 1.00 0.1378 1.99 0.1932 2.99 0.0181 3.98 0.0213 4.97 0.0472
   5.97 0.0302 6.97 0.0099 7.96 0.0039 8.96 0.0052 9.95 0.0031
   10.95 0.0007 11.94 0.0010 12.93 0.0015 13.93 0.0009 14.93 0.0013
   15.92 0.0018 16.92 0.0015 17.91 0.0030 18.91 0.0013 19.90 0.0008
   20.90 0.0008 21.89 0.0006 22.89 0.0006 23.89 0.0003 ) constant ssax-c5

'( 0.99 0.1332 1.97 0.2232 2.96 0.1240 3.95 0.0080 4.94 0.0398
   5.93 0.0194 6.92 0.0059 7.90 0.0022 8.91 0.0008 9.88 0.0017
   10.87 0.0005 11.85 0.0004 12.84 0.0008 13.83 0.0009 14.82 0.0032
   15.81 0.0009 16.81 0.0017 17.78 0.0009 18.77 0.0003 19.76 0.0002
   20.75 0.0006 21.74 0.0004 22.73 0.0002 ) constant ssax-cs5

'( 0.99 0.1242 1.98 0.0414 2.97 0.0487 3.96 0.0182 4.95 0.0225
   5.94 0.0112 6.93 0.0012 7.92 0.0035 8.87 0.0004 9.90 0.0011
   10.89 0.0006 11.88 0.0004 12.81 0.0008 13.87 0.0011 14.86 0.0015
   15.84 0.0005 16.83 0.0002 17.82 0.0005 18.46 0.0002 19.82 0.0002
   20.81 0.0002 21.66 0.0001 ) constant ssax-d5

'( 0.99 0.1419 1.98 0.0180 2.98 0.0683 3.96 0.0172 4.95 0.0329
   5.94 0.0093 6.93 0.0017 7.91 0.0014 8.91 0.0022 9.90 0.0018
   10.88 0.0004 11.89 0.0011 12.88 0.0009 13.87 0.0010 14.83 0.0007
   15.85 0.0004 16.85 0.0002 17.85 0.0003 18.85 0.0003 20.81 0.0001 ) constant ssax-ds5

'( 1.00 0.2435 1.99 0.0422 2.99 0.0422 3.98 0.0137 4.97 0.0155
   5.97 0.0127 6.96 0.0024 7.96 0.0014 8.95 0.0017 9.95 0.0011
   10.94 0.0006 11.94 0.0009 12.93 0.0022 13.92 0.0048 14.92 0.0004
   15.91 0.0006 16.91 0.0003 17.90 0.0002 18.89 0.0002 19.89 0.0002 ) constant ssax-e5

'( 1.00 0.2095 2.00 0.0502 3.01 0.0783 4.01 0.0216 5.01 0.0293
   6.01 0.0080 7.01 0.0043 8.02 0.0036 9.02 0.0019 10.02 0.0002
   11.02 0.0013 12.02 0.0010 13.02 0.0007 14.03 0.0010 15.03 0.0003
   16.03 0.0013 17.04 0.0009 18.04 0.0005 ) constant ssax-f5

'( 0.99 0.1379 1.98 0.0339 2.98 0.0480 3.97 0.0340 4.96 0.0264
   5.95 0.0126 6.94 0.0046 7.93 0.0030 8.92 0.0013 9.91 0.0010
   10.90 0.0009 11.89 0.0007 12.88 0.0007 13.88 0.0018 14.87 0.0012
   15.86 0.0006 16.85 0.0004 17.84 0.0007 ) constant ssax-fs5

'( 0.99 0.0699 1.98 0.0273 2.96 0.0227 3.95 0.0133 4.94 0.0151
   5.92 0.0023 6.92 0.0024 7.91 0.0011 8.90 0.0009 9.89 0.0018
   10.87 0.0009 11.88 0.0016 12.86 0.0007 13.84 0.0008 14.83 0.0007
   15.82 0.0005 16.81 0.0003 ) constant ssax-g5

'( 1.00 0.1830 1.99 0.0897 2.99 0.0456 3.99 0.0296 4.99 0.0125
   5.98 0.0059 6.98 0.0105 7.98 0.0027 8.97 0.0044 9.97 0.0096
   10.97 0.0011 11.97 0.0027 12.97 0.0006 13.97 0.0024 14.96 0.0014
   15.95 0.0002 ) constant ssax-gs5

'( 0.99 0.2010 1.98 0.0677 2.97 0.0195 3.97 0.0363 4.96 0.0191
   5.95 0.0092 6.94 0.0047 7.93 0.0021 7.96 0.0004 8.91 0.0004
   9.92 0.0039 10.90 0.0023 11.91 0.0005 12.88 0.0008 12.91 0.0002
   13.86 0.0002 14.87 0.0007 ) constant ssax-a5

'( 1.00 0.1011 1.99 0.0696 2.99 0.0359 3.98 0.0008 4.99 0.0111
   5.98 0.0027 6.98 0.0005 7.98 0.0038 8.98 0.0032 9.98 0.0037
   10.97 0.0024 11.97 0.0012 12.97 0.0009 13.97 0.0004 ) constant ssax-as5

'( 0.98 0.0933 1.95 0.0632 2.93 0.0226 4.89 0.0036 5.86 0.0133
   6.84 0.0018 7.82 0.0036 8.79 0.0037 9.77 0.0111 10.75 0.0011
   11.72 0.0009 12.70 0.0013 ) constant ssax-b5

'( 1.01 0.0218 1.98 0.0033 3.00 0.0037 3.99 0.0010 4.03 0.0009
   4.77 0.0002 4.95 0.0002 6.01 0.0001 7.00 0.0002 8.02 0.0004
   9.03 0.0004 10.03 0.0003 12.03 0.0001 ) constant ssax-c6

'( 0.99 0.1143 1.99 0.0478 2.99 0.0259 3.97 0.0101 4.97 0.0058
   5.96 0.0010 6.95 0.0012 7.98 0.0017 8.95 0.0024 8.98 0.0016
   9.96 0.0007 10.93 0.0019 10.96 0.0010 11.90 0.0003 11.95 0.0002 ) constant ssax-cs6

'( 1.01 0.0247 2.02 0.0062 3.02 0.0036 4.03 0.0052 5.05 0.0006
   6.07 0.0004 7.06 0.0013 8.07 0.0027 11.11 0.0001 ) constant ssax-d6

\ **********************************************************
\
\ **********************************************************

'( 1.01 0.0028 2.00 0.0192 3.04 0.0188 4.02 0.0134 5.02 0.0319
   6.05 0.0335 7.04 0.0136 8.06 0.0074 9.07 0.0527 10.06 0.0217
   11.05 0.0025 12.09 0.0068 13.08 0.0278 14.10 0.0125 15.09 0.0152
   16.13 0.0101 17.13 0.0088 18.11 0.0094 19.14 0.0084 20.20 0.0008
   21.13 0.0031 22.16 0.0097 23.14 0.0053 24.17 0.0030 25.20 0.0013
   26.17 0.0055 27.20 0.0049 28.19 0.0040 29.21 0.0010 30.21 0.0030
   31.20 0.0032 32.24 0.0031 33.21 0.0006 34.23 0.0015 35.25 0.0020
   36.23 0.0012 37.25 0.0010 38.29 0.0007 39.26 0.0017 40.29 0.0014
   41.27 0.0015 42.29 0.0005 43.32 0.0012 44.30 0.0014 45.32 0.0010
   46.32 0.0005 47.31 0.0003 48.34 0.0009 49.32 0.0005 50.34 0.0005
   51.35 0.0001 52.35 0.0005 53.37 0.0006 54.37 0.0006 55.38 0.0001
   56.38 0.0002 57.39 0.0006 58.41 0.0005 59.42 0.0004 60.42 0.0001
   61.43 0.0004 62.41 0.0004 63.42 0.0003 64.45 0.0002 65.46 0.0001
   66.45 0.0003 67.48 0.0003 68.46 0.0001 69.50 0.0001 70.49 0.0004
   71.48 0.0002 72.47 0.0001 74.52 0.0002 75.51 0.0002 76.51 0.0002
   79.55 0.0002 80.56 0.0002 81.55 0.0001 83.58 0.0002 84.57 0.0001
   85.59 0.0002 87.60 0.0002 88.59 0.0001 89.61 0.0002 92.62 0.0001
   93.64 0.0001 96.67 0.0001 98.69 0.0001 ) constant tbf-e2

'( 0.99 0.0062 2.00 0.0189 3.01 0.0059 4.03 0.0167 5.01 0.0454
   6.01 0.0190 7.03 0.0261 8.04 0.0495 9.04 0.0195 10.01 0.0059
   11.02 0.0030 12.05 0.0247 13.04 0.0097 14.05 0.0122 15.04 0.0076
   16.03 0.0044 17.05 0.0063 18.06 0.0045 19.06 0.0011 20.05 0.0028
   21.07 0.0056 22.07 0.0019 22.55 0.0004 23.17 0.0001 24.07 0.0026
   25.08 0.0016 26.10 0.0017 27.11 0.0006 28.09 0.0011 29.10 0.0014
   30.10 0.0011 31.13 0.0007 32.12 0.0006 33.11 0.0009 34.10 0.0004
   35.15 0.0002 36.15 0.0004 37.13 0.0006 38.11 0.0004 39.11 0.0002
   40.15 0.0003 41.13 0.0004 42.13 0.0003 43.17 0.0002 44.20 0.0002
   45.16 0.0002 46.18 0.0003 48.16 0.0001 49.20 0.0002 50.20 0.0002
   51.21 0.0001 54.20 0.0001 ) constant tbf-f2

'( 1.02 0.0056 2.01 0.0355 3.01 0.0221 3.99 0.0130 4.99 0.0606
   6.00 0.0189 7.01 0.0127 8.02 0.0612 9.01 0.0211 10.01 0.0079
   10.99 0.0134 11.99 0.0205 13.00 0.0282 14.03 0.0114 15.02 0.0079
   16.01 0.0116 17.00 0.0082 18.02 0.0015 19.00 0.0052 20.03 0.0082
   21.03 0.0057 22.05 0.0011 23.02 0.0048 24.01 0.0035 25.01 0.0032
   26.02 0.0012 27.04 0.0033 28.01 0.0015 29.03 0.0013 30.05 0.0008
   31.03 0.0024 32.02 0.0010 33.02 0.0007 34.05 0.0007 35.05 0.0013
   36.04 0.0008 37.03 0.0004 38.02 0.0004 39.03 0.0008 40.03 0.0005
   42.07 0.0005 43.05 0.0006 44.05 0.0003 45.10 0.0002 46.05 0.0003
   47.05 0.0003 48.05 0.0002 50.08 0.0003 51.07 0.0003 52.06 0.0002
   53.09 0.0001 54.00 0.0001 55.06 0.0002 56.09 0.0002 57.10 0.0001
   58.08 0.0001 59.05 0.0001 60.09 0.0001 62.09 0.0001 63.06 0.0001
   66.13 0.0001 ) constant tbf-fs2

'( 0.99 0.0059 1.98 0.0515 2.98 0.0305 3.98 0.0081 4.97 0.0448
   5.98 0.0160 6.97 0.0397 7.97 0.0418 8.93 0.0079 9.96 0.0086
   10.95 0.0358 11.96 0.0207 12.94 0.0116 13.94 0.0070 14.93 0.0156
   15.94 0.0120 16.98 0.0013 17.94 0.0060 18.91 0.0074 19.94 0.0070
   20.94 0.0013 21.92 0.0060 22.91 0.0043 23.89 0.0014 24.95 0.0017
   25.91 0.0031 26.90 0.0022 27.90 0.0009 28.91 0.0017 29.89 0.0016
   30.88 0.0012 31.86 0.0004 32.88 0.0013 33.89 0.0008 34.85 0.0005
   35.83 0.0005 36.85 0.0008 37.87 0.0006 38.87 0.0001 39.86 0.0004
   40.90 0.0008 41.86 0.0005 42.88 0.0003 43.86 0.0005 44.84 0.0005
   45.89 0.0003 46.92 0.0002 47.86 0.0003 48.77 0.0002 49.85 0.0002
   50.86 0.0002 51.81 0.0003 52.88 0.0001 53.87 0.0001 54.80 0.0002
   55.77 0.0001 56.88 0.0002 58.76 0.0001 59.82 0.0001 62.83 0.0001
   63.88 0.0001 73.81 0.0001 ) constant tbf-g2

'( 0.99 0.0058 1.98 0.0327 2.99 0.0282 3.99 0.0353 4.98 0.0348
   5.96 0.0451 6.97 0.0549 7.97 0.0183 8.96 0.0096 9.94 0.0221
   10.94 0.0110 11.93 0.0102 12.92 0.0074 13.92 0.0109 14.91 0.0080
   15.15 0.0013 15.91 0.0003 16.90 0.0034 17.88 0.0030 18.88 0.0036
   19.14 0.0004 20.05 0.0003 20.86 0.0029 21.87 0.0014 22.84 0.0008
   23.85 0.0021 24.83 0.0011 25.81 0.0007 26.80 0.0003 27.81 0.0010
   28.82 0.0003 29.84 0.0003 30.77 0.0006 31.75 0.0002 32.78 0.0005
   33.79 0.0003 34.77 0.0003 35.78 0.0003 37.75 0.0002 38.72 0.0002
   41.75 0.0001 42.73 0.0001 45.69 0.0001 ) constant tbf-gs2

'( 1.00 0.0085 1.99 0.0291 2.99 0.0151 4.00 0.0554 5.00 0.0164
   6.02 0.0087 7.00 0.0365 8.06 0.0023 9.02 0.0098 9.98 0.0165
   10.97 0.0176 11.97 0.0107 12.98 0.0081 13.97 0.0077 14.97 0.0012
   15.99 0.0038 16.98 0.0028 17.97 0.0017 18.97 0.0024 19.98 0.0014
   20.95 0.0017 21.92 0.0009 23.01 0.0009 23.98 0.0006 24.94 0.0004
   25.95 0.0013 26.95 0.0003 27.99 0.0002 28.97 0.0006 29.96 0.0002
   30.90 0.0003 31.89 0.0003 32.83 0.0002 33.02 0.0001 33.78 0.0001
   34.94 0.0001 35.94 0.0002 38.91 0.0002 39.88 0.0001 ) constant tbf-a2

'( 1.00 0.0251 2.05 0.0009 3.02 0.0385 4.03 0.0997 5.03 0.0337
   6.04 0.1061 7.04 0.0539 8.05 0.0357 9.06 0.0635 10.06 0.0233
   11.05 0.0153 12.07 0.0218 13.07 0.0235 14.08 0.0092 15.08 0.0135
   16.09 0.0104 17.09 0.0055 18.10 0.0130 19.11 0.0059 20.12 0.0030
   21.12 0.0060 22.12 0.0029 23.12 0.0032 24.13 0.0022 25.14 0.0016
   26.14 0.0007 27.15 0.0032 28.15 0.0014 29.16 0.0012 30.15 0.0015
   31.18 0.0011 32.19 0.0008 33.18 0.0014 34.19 0.0007 35.19 0.0003
   36.18 0.0009 37.16 0.0004 39.21 0.0007 40.22 0.0006 41.23 0.0001
   42.20 0.0004 43.24 0.0007 45.25 0.0007 46.26 0.0004 47.32 0.0001
   48.26 0.0004 49.26 0.0003 51.29 0.0003 52.28 0.0002 54.30 0.0003
   55.32 0.0002 57.31 0.0002 58.32 0.0001 60.31 0.0002 61.30 0.0001
   63.35 0.0001 64.34 0.0001 66.37 0.0001 ) constant tbf-as2

'( 1.02 0.0294 2.03 0.0276 3.03 0.0170 4.05 0.0409 5.06 0.0434
   6.06 0.0552 7.06 0.0128 8.08 0.0076 9.07 0.0216 10.08 0.0169
   11.07 0.0035 12.09 0.0094 13.10 0.0046 14.12 0.0021 15.12 0.0059
   16.13 0.0023 17.15 0.0039 18.16 0.0035 19.17 0.0015 20.18 0.0020
   21.19 0.0023 22.19 0.0005 23.22 0.0022 24.24 0.0010 25.27 0.0006
   26.26 0.0008 27.27 0.0010 28.28 0.0003 29.28 0.0006 30.27 0.0005
   31.32 0.0003 32.30 0.0004 33.29 0.0004 35.37 0.0004 36.34 0.0002
   37.38 0.0002 38.38 0.0003 39.48 0.0002 41.43 0.0003 42.40 0.0001
   44.50 0.0001 45.47 0.0001 47.46 0.0001 ) constant tbf-b2

'( 1.01 0.0167 2.00 0.0116 3.00 0.0033 3.99 0.0432 5.01 0.0116
   6.00 0.0573 7.00 0.0128 8.00 0.0582 9.02 0.0354 10.01 0.0203
   11.00 0.0226 12.00 0.0167 13.03 0.0055 14.02 0.0174 15.01 0.0088
   16.01 0.0083 17.03 0.0066 18.03 0.0022 19.01 0.0058 20.01 0.0049
   21.03 0.0016 22.03 0.0053 23.03 0.0028 24.01 0.0013 25.03 0.0028
   26.03 0.0015 27.00 0.0003 28.02 0.0026 28.39 0.0002 29.70 0.0002
   30.03 0.0014 31.03 0.0010 32.04 0.0007 33.03 0.0010 34.03 0.0007
   35.04 0.0004 36.03 0.0009 37.03 0.0004 38.05 0.0006 39.04 0.0008
   40.03 0.0003 41.04 0.0004 42.04 0.0005 43.06 0.0003 44.02 0.0004
   45.03 0.0002 46.08 0.0001 47.05 0.0004 48.03 0.0002 49.06 0.0001
   50.05 0.0003 51.06 0.0002 52.07 0.0002 53.04 0.0002 54.05 0.0001
   55.05 0.0002 56.05 0.0001 58.05 0.0002 59.06 0.0001 61.05 0.0002 ) constant tbf-c3

'( 1.00 0.0192 1.98 0.0300 2.99 0.0565 3.98 0.0329 4.97 0.0791
   5.98 0.0457 6.96 0.0053 7.95 0.0405 8.96 0.0260 9.95 0.0146
   10.93 0.0283 11.95 0.0038 12.93 0.0205 13.92 0.0086 14.93 0.0028
   15.91 0.0069 16.91 0.0030 17.91 0.0095 18.89 0.0058 19.90 0.0023
   20.89 0.0048 21.87 0.0015 22.89 0.0033 23.88 0.0021 24.87 0.0003
   25.87 0.0030 26.86 0.0014 27.85 0.0016 28.86 0.0021 29.85 0.0005
   30.83 0.0019 31.84 0.0014 32.83 0.0005 33.82 0.0012 34.82 0.0006
   35.81 0.0008 36.82 0.0011 37.81 0.0004 38.78 0.0004 39.80 0.0005
   40.79 0.0004 41.77 0.0007 42.77 0.0002 43.78 0.0004 44.76 0.0005
   45.77 0.0003 46.76 0.0003 47.75 0.0002 48.75 0.0002 49.75 0.0005
   50.74 0.0002 51.73 0.0002 52.73 0.0002 53.72 0.0002 54.73 0.0003
   55.70 0.0001 56.70 0.0001 57.71 0.0003 58.71 0.0001 59.70 0.0002
   60.70 0.0001 61.69 0.0002 62.69 0.0003 64.67 0.0001 65.67 0.0001
   67.64 0.0001 69.65 0.0001 70.63 0.0001 75.62 0.0001 ) constant tbf-cs3

'( 1.01 0.0462 2.01 0.0592 3.00 0.1127 3.99 0.0398 5.00 0.1221
   6.02 0.0099 7.01 0.0396 8.01 0.0429 9.00 0.0249 10.00 0.0223
   10.27 0.0015 11.03 0.0010 12.01 0.0146 13.01 0.0097 14.00 0.0008
   15.00 0.0064 16.01 0.0020 17.02 0.0066 18.02 0.0043 19.02 0.0021
   20.01 0.0035 21.02 0.0009 22.02 0.0022 23.03 0.0022 24.00 0.0007
   25.02 0.0025 26.02 0.0002 27.03 0.0017 27.30 0.0003 28.73 0.0002
   29.03 0.0016 30.02 0.0012 31.02 0.0006 32.04 0.0013 33.04 0.0005
   34.02 0.0006 35.01 0.0004 36.03 0.0007 37.03 0.0009 38.05 0.0003
   39.05 0.0006 40.04 0.0003 41.04 0.0003 42.04 0.0005 43.05 0.0002
   44.06 0.0003 45.05 0.0001 46.05 0.0002 47.04 0.0003 48.06 0.0002
   49.06 0.0003 50.06 0.0001 51.06 0.0001 52.04 0.0001 53.06 0.0001
   54.06 0.0002 57.06 0.0001 58.07 0.0001 59.06 0.0002 66.09 0.0001 ) constant tbf-d3

'( 1.00 0.0462 2.01 0.0546 3.03 0.1220 4.04 0.0672 5.06 0.0575
   6.07 0.0310 7.08 0.0402 8.09 0.0228 9.09 0.0345 10.10 0.0204
   11.11 0.0134 12.12 0.0171 13.13 0.0056 14.15 0.0087 15.16 0.0035
   16.17 0.0068 17.18 0.0027 18.18 0.0061 19.20 0.0018 20.20 0.0037
   21.22 0.0030 22.24 0.0013 23.24 0.0028 23.58 0.0004 24.91 0.0002
   25.26 0.0031 26.26 0.0008 27.27 0.0022 28.28 0.0021 29.29 0.0013
   30.31 0.0017 31.31 0.0006 32.34 0.0015 33.34 0.0008 34.35 0.0012
   35.36 0.0012 36.36 0.0008 37.37 0.0012 38.38 0.0006 39.40 0.0008
   40.39 0.0002 41.43 0.0004 42.44 0.0003 43.45 0.0004 44.45 0.0004
   45.45 0.0004 46.46 0.0006 47.46 0.0002 48.48 0.0004 49.47 0.0002
   50.52 0.0003 51.52 0.0002 52.53 0.0003 53.53 0.0003 54.54 0.0002
   55.55 0.0003 57.58 0.0002 58.58 0.0001 59.60 0.0002 60.60 0.0002
   61.62 0.0002 62.63 0.0002 63.62 0.0001 64.64 0.0002 66.67 0.0001
   68.68 0.0001 69.70 0.0001 71.70 0.0001 ) constant tbf-ds3

'( 1.00 0.0427 2.02 0.0329 3.03 0.0739 4.03 0.0442 5.05 0.0547
   6.06 0.0547 7.06 0.0357 8.07 0.0307 9.09 0.0344 10.10 0.0088
   11.10 0.0255 12.12 0.0049 13.13 0.0161 14.13 0.0032 15.14 0.0087
   16.16 0.0028 17.15 0.0054 18.17 0.0018 19.18 0.0048 20.20 0.0025
   21.19 0.0033 22.21 0.0032 23.22 0.0009 24.22 0.0017 25.25 0.0004
   26.24 0.0011 26.54 0.0002 27.27 0.0002 28.26 0.0012 28.54 0.0002
   29.26 0.0001 30.29 0.0009 31.29 0.0003 32.30 0.0007 33.32 0.0005
   34.32 0.0007 35.32 0.0005 36.35 0.0004 37.36 0.0004 38.38 0.0002
   39.37 0.0004 41.39 0.0004 42.42 0.0001 43.40 0.0002 45.43 0.0002
   47.45 0.0002 48.45 0.0001 49.46 0.0001 50.48 0.0002 51.49 0.0001
   52.49 0.0001 54.52 0.0001 56.54 0.0001 ) constant tbf-e3

'( 1.01 0.0430 2.02 0.0658 3.02 0.0533 4.02 0.1351 5.04 0.0653
   6.03 0.0900 7.05 0.0410 8.05 0.0344 9.07 0.0169 10.07 0.0220
   11.08 0.0159 12.08 0.0180 13.08 0.0045 14.09 0.0098 15.08 0.0023
   16.10 0.0022 17.12 0.0040 18.12 0.0030 19.13 0.0031 20.14 0.0014
   21.14 0.0019 22.15 0.0012 23.16 0.0015 24.16 0.0007 25.16 0.0010
   26.17 0.0009 27.19 0.0009 28.19 0.0004 29.20 0.0009 30.19 0.0002
   31.21 0.0007 32.23 0.0003 33.23 0.0005 35.24 0.0004 36.33 0.0001
   37.25 0.0003 38.26 0.0002 39.27 0.0003 41.29 0.0002 42.29 0.0001
   43.30 0.0002 45.31 0.0001 46.33 0.0001 ) constant tbf-f3

'( 1.00 0.0676 1.99 0.0337 3.00 0.0651 4.00 0.0928 4.99 0.0773
   6.00 0.0359 6.99 0.0266 7.99 0.0183 9.00 0.0246 9.99 0.0092
   10.98 0.0144 11.99 0.0027 12.98 0.0112 13.98 0.0019 14.99 0.0058
   15.97 0.0010 16.97 0.0024 17.98 0.0033 18.97 0.0025 19.97 0.0024
   20.98 0.0018 21.97 0.0030 22.98 0.0013 23.97 0.0026 24.19 0.0004
   24.97 0.0003 25.97 0.0026 26.96 0.0003 27.96 0.0018 28.97 0.0006
   29.96 0.0012 30.96 0.0012 31.97 0.0011 32.96 0.0012 33.95 0.0006
   34.96 0.0008 35.95 0.0003 36.95 0.0009 37.95 0.0002 38.95 0.0005
   39.95 0.0002 40.95 0.0005 41.95 0.0003 42.95 0.0005 43.95 0.0002
   44.94 0.0003 45.95 0.0003 46.94 0.0001 47.94 0.0002 49.94 0.0003
   50.94 0.0001 51.94 0.0003 53.93 0.0002 55.93 0.0002 56.93 0.0001
   57.93 0.0002 58.93 0.0001 59.93 0.0001 60.93 0.0001 62.93 0.0001
   64.91 0.0001 ) constant tbf-fs3

'( 1.01 0.1108 2.02 0.0159 3.03 0.0749 4.03 0.0774 5.05 0.0554
   6.06 0.0287 7.06 0.0529 8.08 0.0167 9.09 0.0172 10.09 0.0181
   11.10 0.0072 12.12 0.0148 13.11 0.0028 14.13 0.0060 15.14 0.0012
   16.14 0.0047 17.15 0.0034 18.17 0.0009 19.17 0.0041 20.18 0.0007
   21.20 0.0016 22.20 0.0011 23.21 0.0022 24.23 0.0010 25.24 0.0008
   26.24 0.0015 27.25 0.0003 28.26 0.0011 29.26 0.0009 30.28 0.0009
   31.29 0.0007 32.29 0.0002 33.31 0.0005 34.32 0.0001 35.32 0.0006
   36.33 0.0002 37.35 0.0003 38.34 0.0004 40.37 0.0003 42.39 0.0002
   43.40 0.0002 44.40 0.0001 45.41 0.0002 47.44 0.0002 50.47 0.0001
   52.48 0.0001 54.49 0.0001 ) constant tbf-g3

'( 1.01 0.0962 2.01 0.0925 3.01 0.0770 4.03 0.0479 5.03 0.1190
   6.03 0.0237 7.03 0.0168 8.05 0.0283 9.05 0.0100 10.05 0.0292
   11.06 0.0097 12.07 0.0103 13.07 0.0121 14.07 0.0042 15.08 0.0012
   16.09 0.0051 17.09 0.0023 18.09 0.0058 19.11 0.0009 20.11 0.0029
   21.11 0.0028 22.12 0.0011 23.13 0.0028 24.12 0.0013 25.13 0.0016
   26.14 0.0014 27.14 0.0009 28.15 0.0016 29.16 0.0007 30.16 0.0007
   31.16 0.0010 32.17 0.0004 33.18 0.0006 34.18 0.0005 35.18 0.0003
   36.19 0.0006 37.20 0.0003 38.20 0.0003 39.21 0.0004 40.22 0.0002
   41.22 0.0004 42.23 0.0001 43.23 0.0002 44.24 0.0002 46.25 0.0003
   47.25 0.0001 48.26 0.0002 49.26 0.0001 51.28 0.0001 54.29 0.0001 ) constant tbf-gs3

'( 0.99 0.0880 1.99 0.1784 2.99 0.0966 3.99 0.0789 4.99 0.0440
   5.99 0.0574 6.99 0.0067 7.99 0.0384 8.98 0.0270 9.98 0.0089
   10.97 0.0152 11.97 0.0039 12.97 0.0092 13.97 0.0081 14.97 0.0020
   15.97 0.0030 16.96 0.0051 17.96 0.0014 18.96 0.0031 19.96 0.0026
   20.95 0.0004 21.95 0.0028 22.95 0.0006 23.94 0.0012 24.94 0.0021
   25.94 0.0009 26.94 0.0010 27.94 0.0010 28.94 0.0006 29.94 0.0008
   30.93 0.0009 31.93 0.0001 32.92 0.0007 33.92 0.0005 34.91 0.0002
   35.92 0.0005 36.91 0.0003 37.92 0.0002 38.92 0.0004 40.91 0.0002
   41.90 0.0002 43.89 0.0002 44.89 0.0002 46.89 0.0001 49.89 0.0001
   52.88 0.0001 ) constant tbf-a3

'( 1.00 0.0084 2.02 0.2204 3.02 0.1914 4.03 0.0999 5.03 0.0302
   6.04 0.0574 7.04 0.0432 8.05 0.0168 9.05 0.0414 10.06 0.0213
   11.06 0.0024 12.07 0.0063 13.08 0.0058 14.08 0.0014 15.09 0.0031
   16.09 0.0067 17.10 0.0026 18.10 0.0026 19.11 0.0039 20.11 0.0016
   21.12 0.0015 22.12 0.0032 23.13 0.0017 24.13 0.0010 25.14 0.0020
   26.14 0.0016 27.15 0.0002 28.16 0.0013 29.16 0.0009 31.17 0.0009
   32.18 0.0008 33.18 0.0004 34.19 0.0005 35.19 0.0008 36.20 0.0002
   37.20 0.0004 38.21 0.0005 39.21 0.0002 40.22 0.0002 41.22 0.0003
   42.23 0.0002 43.23 0.0001 44.24 0.0002 45.25 0.0001 47.26 0.0002
   48.26 0.0001 50.28 0.0001 51.28 0.0001 ) constant tbf-as3

'( 1.00 0.0475 2.00 0.1146 3.01 0.1513 4.01 0.0759 5.00 0.0441
   6.01 0.0348 7.01 0.0462 8.01 0.0291 9.02 0.0056 10.02 0.0281
   11.01 0.0178 12.02 0.0016 13.02 0.0054 14.02 0.0082 15.03 0.0051
   16.02 0.0014 17.02 0.0053 18.03 0.0050 19.03 0.0017 20.03 0.0024
   21.04 0.0037 22.03 0.0025 23.03 0.0008 24.04 0.0028 25.04 0.0023
   26.04 0.0007 27.04 0.0007 28.04 0.0018 29.04 0.0017 30.05 0.0003
   31.04 0.0011 32.04 0.0013 33.05 0.0004 34.05 0.0005 35.05 0.0009
   36.06 0.0007 37.05 0.0002 38.06 0.0004 39.06 0.0006 40.06 0.0004
   41.07 0.0003 42.06 0.0005 43.06 0.0004 44.07 0.0001 45.07 0.0003
   46.07 0.0003 47.08 0.0001 48.07 0.0001 49.07 0.0003 50.08 0.0002
   52.08 0.0001 53.08 0.0001 ) constant tbf-b3

'( 1.01 0.0092 2.01 0.0918 3.01 0.1218 4.03 0.1524 5.03 0.0561
   6.03 0.0196 7.05 0.0312 8.05 0.0481 9.05 0.0292 10.07 0.0048
   11.07 0.0035 12.07 0.0096 13.08 0.0079 14.09 0.0040 15.09 0.0017
   16.09 0.0054 17.11 0.0080 18.11 0.0039 19.11 0.0010 20.13 0.0034
   21.13 0.0028 22.13 0.0027 23.14 0.0004 24.15 0.0015 25.15 0.0024
   26.16 0.0021 27.17 0.0006 28.17 0.0008 29.17 0.0013 30.19 0.0015
   31.19 0.0005 32.19 0.0002 33.21 0.0009 34.21 0.0010 35.21 0.0006
   36.23 0.0003 37.23 0.0005 38.23 0.0009 39.24 0.0007 40.25 0.0002
   41.25 0.0004 42.26 0.0006 43.27 0.0004 44.27 0.0002 45.27 0.0003
   46.29 0.0004 47.29 0.0003 48.29 0.0001 ) constant tbf-c4

'( 1.00 0.0881 2.00 0.1170 3.00 0.0852 4.00 0.0643 5.00 0.0778
   6.00 0.0489 6.99 0.0269 8.00 0.0107 8.99 0.0292 10.00 0.0159
   10.99 0.0082 12.00 0.0066 12.99 0.0009 14.00 0.0050 14.99 0.0064
   15.99 0.0059 17.00 0.0044 17.99 0.0024 19.00 0.0042 19.99 0.0040
   21.00 0.0027 21.99 0.0023 22.99 0.0018 23.99 0.0024 24.99 0.0025
   25.99 0.0019 26.99 0.0007 27.99 0.0004 28.99 0.0012 29.99 0.0014
   30.99 0.0012 31.99 0.0004 32.99 0.0002 33.99 0.0007 34.98 0.0009
   35.99 0.0008 36.98 0.0005 37.99 0.0002 38.98 0.0005 39.99 0.0007
   40.98 0.0007 41.98 0.0004 42.98 0.0001 43.98 0.0003 44.99 0.0004
   45.98 0.0003 ) constant tbf-cs4

'( 1.01 0.1228 2.02 0.1247 3.02 0.1142 4.03 0.0474 5.04 0.0335
   6.04 0.0332 7.05 0.0302 8.06 0.0222 9.07 0.0090 10.08 0.0030
   11.09 0.0027 12.09 0.0054 13.10 0.0059 14.10 0.0040 15.11 0.0038
   16.12 0.0029 17.13 0.0011 18.14 0.0020 19.15 0.0021 20.15 0.0023
   21.16 0.0016 22.17 0.0012 23.17 0.0008 24.18 0.0003 25.19 0.0006
   26.20 0.0008 27.21 0.0008 28.22 0.0008 29.22 0.0004 30.23 0.0002
   31.23 0.0002 32.24 0.0003 33.26 0.0004 34.26 0.0004 35.27 0.0004
   36.28 0.0002 39.29 0.0002 40.30 0.0002 41.32 0.0001 ) constant tbf-d4

'( 1.01 0.1133 2.01 0.1562 3.02 0.1429 4.02 0.0366 5.02 0.0219
   6.03 0.0212 7.03 0.0142 8.04 0.0216 9.04 0.0101 10.04 0.0063
   11.05 0.0076 12.05 0.0081 13.06 0.0050 14.06 0.0030 15.07 0.0010
   16.07 0.0011 17.07 0.0019 18.08 0.0022 19.08 0.0029 20.09 0.0028
   21.09 0.0021 22.09 0.0016 23.10 0.0016 24.10 0.0010 25.11 0.0005
   26.11 0.0003 27.11 0.0002 28.12 0.0006 29.12 0.0004 30.13 0.0005
   31.13 0.0004 32.13 0.0006 33.14 0.0003 34.14 0.0003 35.15 0.0002
   37.15 0.0002 38.15 0.0001 39.16 0.0002 40.16 0.0002 41.17 0.0002 ) constant tbf-ds4

'( 0.99 0.0906 1.99 0.1338 2.99 0.1235 3.98 0.0833 4.98 0.0601
   5.98 0.0264 6.98 0.0126 7.97 0.0051 8.97 0.0026 9.97 0.0014
   10.96 0.0018 11.96 0.0025 12.96 0.0031 13.96 0.0021 14.95 0.0034
   15.95 0.0035 16.95 0.0037 17.94 0.0031 18.94 0.0021 19.93 0.0021
   20.93 0.0016 21.92 0.0010 22.92 0.0012 23.92 0.0011 24.91 0.0007
   25.91 0.0004 26.91 0.0002 28.91 0.0001 30.89 0.0001 31.90 0.0002
   32.90 0.0002 33.89 0.0002 34.89 0.0002 35.88 0.0002 36.88 0.0002
   37.88 0.0002 38.87 0.0001 ) constant tbf-e4

'( 1.01 0.1228 2.01 0.3008 3.01 0.1922 4.01 0.0927 5.01 0.0581
   6.02 0.0447 7.02 0.0207 8.03 0.0106 9.02 0.0057 10.02 0.0018
   11.03 0.0040 12.03 0.0041 13.04 0.0040 14.04 0.0039 15.04 0.0042
   16.04 0.0034 17.05 0.0035 18.05 0.0038 19.06 0.0033 20.06 0.0029
   21.06 0.0024 22.06 0.0020 23.07 0.0018 24.07 0.0015 25.07 0.0012
   26.07 0.0009 27.07 0.0006 28.08 0.0005 29.08 0.0003 30.09 0.0003
   31.10 0.0003 32.10 0.0004 33.11 0.0004 34.11 0.0004 35.10 0.0004
   36.10 0.0004 37.11 0.0003 38.11 0.0002 ) constant tbf-f4

'( 1.01 0.0765 2.01 0.2561 3.02 0.0803 4.03 0.0653 5.03 0.0230
   6.04 0.0093 7.05 0.0035 8.05 0.0042 9.06 0.0040 10.07 0.0052
   11.07 0.0056 12.08 0.0049 13.09 0.0039 14.09 0.0035 15.10 0.0031
   16.10 0.0021 17.11 0.0012 18.12 0.0010 19.12 0.0005 20.13 0.0003
   21.14 0.0001 22.14 0.0001 23.15 0.0003 24.16 0.0002 25.16 0.0003
   26.17 0.0003 27.18 0.0003 28.18 0.0003 29.19 0.0003 30.20 0.0002
   31.20 0.0001 ) constant tbf-fs4

'( 1.01 0.0092 2.02 0.2167 3.02 0.0668 4.02 0.0254 5.03 0.0210
   6.04 0.0282 7.04 0.0151 8.05 0.0130 9.05 0.0054 10.06 0.0031
   11.07 0.0014 12.08 0.0020 13.08 0.0020 14.09 0.0020 15.09 0.0021
   16.10 0.0015 17.10 0.0007 18.11 0.0003 19.13 0.0002 20.13 0.0004
   21.13 0.0005 22.14 0.0004 23.14 0.0003 24.15 0.0003 25.15 0.0001
   29.18 0.0001 30.19 0.0001 ) constant tbf-g4

'( 1.00 0.1758 2.01 0.1249 3.01 0.0253 4.02 0.0471 5.02 0.0478
   6.03 0.0217 7.03 0.0025 8.04 0.0044 9.05 0.0066 10.05 0.0060
   11.05 0.0030 12.06 0.0021 13.09 0.0005 14.07 0.0008 15.07 0.0014
   16.08 0.0010 17.08 0.0005 18.10 0.0002 19.09 0.0003 20.10 0.0003
   21.10 0.0003 22.10 0.0001 24.13 0.0001 25.13 0.0001 26.13 0.0001 ) constant tbf-gs4

'( 1.00 0.3944 2.01 0.1441 3.00 0.0979 4.01 0.0595 5.01 0.0218
   6.01 0.0057 7.01 0.0131 8.01 0.0053 9.01 0.0018 10.02 0.0029
   11.01 0.0042 12.02 0.0032 13.01 0.0001 14.02 0.0014 15.02 0.0017
   16.02 0.0006 17.03 0.0003 18.02 0.0006 19.03 0.0009 20.03 0.0003
   21.04 0.0002 22.03 0.0004 23.03 0.0004 25.04 0.0002 26.04 0.0003
   27.04 0.0001 ) constant tbf-a4

'( 1.01 0.3895 2.03 0.1550 3.03 0.0985 4.05 0.0153 5.06 0.0280
   6.07 0.0103 7.08 0.0028 8.10 0.0069 9.10 0.0023 10.12 0.0025
   11.13 0.0029 12.14 0.0011 13.15 0.0011 14.16 0.0009 15.17 0.0002
   16.19 0.0007 17.20 0.0004 18.22 0.0002 19.22 0.0003 20.23 0.0001
   22.26 0.0001 ) constant tbf-as4

'( 1.00 0.2165 2.01 0.1597 3.00 0.0717 4.01 0.0353 5.01 0.0332
   6.01 0.0024 7.01 0.0088 8.02 0.0009 9.02 0.0039 10.02 0.0016
   11.02 0.0015 12.02 0.0014 13.03 0.0003 14.03 0.0007 16.03 0.0004
   17.04 0.0002 18.03 0.0002 19.04 0.0001 ) constant tbf-b4

'( 1.01 0.1699 2.01 0.2670 3.03 0.0349 4.03 0.0454 5.05 0.0024
   6.05 0.0069 7.06 0.0021 8.07 0.0015 9.08 0.0011 10.09 0.0007
   11.09 0.0007 12.10 0.0001 13.11 0.0004 15.13 0.0002 ) constant tbf-c5

'( 1.00 0.2017 2.00 0.0920 3.00 0.0598 3.99 0.0086 4.99 0.0120
   5.99 0.0063 6.99 0.0034 7.99 0.0029 8.99 0.0008 9.99 0.0014
   10.98 0.0008 11.97 0.0007 12.98 0.0006 13.96 0.0001 14.97 0.0003
   15.97 0.0001 ) constant tbf-cs5

\ **********************************************************
\
\ **********************************************************

'( 1.00 0.0179 2.00 0.0770 2.99 0.0532 3.99 0.0183 4.97 0.0494
   5.98 0.0137 6.95 0.0121 7.97 0.0153 8.94 0.0012 9.96 0.0040
   10.97 0.0030 11.93 0.0021 12.93 0.0034 13.94 0.0007 14.91 0.0004
   16.01 0.0002 16.93 0.0003 17.92 0.0008 18.94 0.0004 19.96 0.0002
   21.00 0.0001 22.95 0.0001 25.89 0.0001 ) constant tbp-e2

'( 0.99 0.0137 2.01 0.0473 3.03 0.0362 4.01 0.0117 5.02 0.0565
   6.04 0.0247 7.06 0.0348 8.04 0.0251 9.05 0.0143 10.07 0.0146
   11.09 0.0020 12.07 0.0048 13.09 0.0013 14.12 0.0012 15.12 0.0009
   16.12 0.0004 17.10 0.0010 18.11 0.0003 19.13 0.0004 20.13 0.0001
   22.14 0.0001 24.17 0.0001 ) constant tbp-f2

'( 1.02 0.0110 2.02 0.0470 3.02 0.0038 4.02 0.0343 5.01 0.0442
   6.02 0.0198 7.01 0.0600 8.02 0.0144 9.05 0.0468 10.05 0.0112
   11.05 0.0137 12.05 0.0078 13.05 0.0041 14.05 0.0040 15.05 0.0012
   16.05 0.0018 17.05 0.0007 18.08 0.0011 19.08 0.0003 20.09 0.0005
   21.08 0.0004 22.08 0.0002 23.07 0.0003 25.07 0.0001 ) constant tbp-fs2

'( 1.01 0.0148 2.00 0.0544 3.02 0.0144 4.01 0.0848 5.03 0.0334
   6.02 0.0703 7.01 0.0546 8.03 0.0242 9.02 0.0235 10.04 0.0054
   11.02 0.0079 12.04 0.0009 13.03 0.0032 14.02 0.0011 15.04 0.0013
   16.02 0.0005 17.06 0.0005 18.01 0.0001 19.01 0.0002 20.07 0.0002
   21.08 0.0001 ) constant tbp-g2

'( 0.99 0.0357 2.00 0.0505 3.00 0.0158 3.99 0.0999 4.99 0.0473
   6.00 0.0633 7.00 0.0187 7.98 0.0536 8.99 0.0153 9.99 0.0238
   10.98 0.0049 11.98 0.0045 12.99 0.0018 13.98 0.0031 14.97 0.0011
   15.97 0.0009 16.98 0.0005 17.97 0.0007 18.97 0.0006 19.95 0.0003
   20.96 0.0001 ) constant tbp-gs2

'( 1.00 0.0295 1.99 0.1044 2.98 0.0380 3.96 0.1223 4.95 0.0652
   5.93 0.0906 6.93 0.0212 7.91 0.0492 8.91 0.0034 9.88 0.0180
   10.87 0.0036 11.86 0.0050 12.85 0.0005 13.85 0.0016 14.84 0.0009
   15.81 0.0014 16.80 0.0002 17.77 0.0003 20.73 0.0001 21.73 0.0002
   22.73 0.0002 24.70 0.0001 ) constant tbp-a2

'( 1.00 0.0228 2.01 0.0987 3.02 0.0160 4.03 0.0517 5.03 0.0818
   6.04 0.0522 7.06 0.0447 8.06 0.0171 9.07 0.0228 10.06 0.0032
   11.08 0.0065 12.06 0.0008 13.09 0.0023 14.11 0.0008 15.09 0.0004
   16.11 0.0004 17.10 0.0003 18.13 0.0002 20.07 0.0001 ) constant tbp-as2

'( 1.01 0.0076 1.99 0.0810 2.98 0.0345 3.98 0.0341 4.99 0.0653
   5.99 0.0085 6.96 0.0538 7.97 0.0030 8.97 0.0204 9.96 0.0059
   10.95 0.0026 11.96 0.0028 12.96 0.0006 13.94 0.0014 14.92 0.0002
   15.94 0.0007 16.95 0.0002 ) constant tbp-b2

'( 1.02 0.0300 2.02 0.0703 3.03 0.1222 4.04 0.0495 5.04 0.0810
   6.04 0.0372 7.05 0.0371 8.06 0.0353 9.08 0.0026 10.09 0.0078
   11.10 0.0065 12.11 0.0027 13.11 0.0030 14.12 0.0006 15.12 0.0013
   16.13 0.0006 17.14 0.0002 18.16 0.0002 19.18 0.0001 20.19 0.0001
   21.19 0.0001 ) constant tbp-c3

'( 0.99 0.0466 1.97 0.0094 2.97 0.0953 3.95 0.0427 4.96 0.0520
   5.94 0.0187 6.94 0.0127 7.92 0.0075 8.90 0.0015 9.90 0.0017
   10.88 0.0009 11.89 0.0002 12.85 0.0002 ) constant tbp-cs3

'( 1.01 0.0634 2.02 0.0187 3.02 0.0987 4.02 0.0742 5.02 0.0182
   6.03 0.0331 7.03 0.0132 8.03 0.0025 9.04 0.0026 10.06 0.0016
   11.07 0.0002 12.08 0.0001 ) constant tbp-d3

'( 1.01 0.1106 2.01 0.0100 3.00 0.0866 4.00 0.0859 5.00 0.0217
   6.00 0.0251 6.99 0.0134 7.99 0.0022 8.99 0.0026 9.99 0.0021
   11.00 0.0005 14.99 0.0001 16.99 0.0001 ) constant tbp-ds3

'( 1.00 0.1452 1.99 0.0464 2.98 0.0553 3.97 0.1114 4.96 0.0181
   5.95 0.0077 6.94 0.0033 7.93 0.0043 8.92 0.0023 9.92 0.0003
   10.90 0.0006 11.89 0.0003 14.88 0.0001 15.87 0.0002 19.83 0.0001 ) constant tbp-e3

'( 0.99 0.0923 2.00 0.0191 3.00 0.0745 3.99 0.1014 5.00 0.0547
   6.00 0.0129 6.99 0.0032 8.00 0.0023 9.00 0.0018 9.98 0.0007
   10.38 0.0001 12.98 0.0001 ) constant tbp-f3

'( 1.01 0.0781 2.00 0.0346 2.99 0.0441 4.01 0.0196 5.00 0.0310
   5.99 0.0213 7.00 0.0062 7.99 0.0021 9.00 0.0003 9.99 0.0002 ) constant tbp-fs3

'( 1.01 0.0733 2.03 0.0883 3.03 0.0772 4.05 0.0148 5.06 0.0055
   6.06 0.0033 7.09 0.0026 8.09 0.0015 9.11 0.0003 10.12 0.0002 ) constant tbp-g3

'( 1.02 0.0885 2.03 0.1115 3.05 0.0480 4.06 0.0466 5.07 0.0106
   6.09 0.0018 7.10 0.0009 ) constant tbp-gs3

'( 1.01 0.1416 2.02 0.1418 3.02 0.0683 4.03 0.0464 5.04 0.0178
   6.04 0.0037 7.06 0.0018 8.07 0.0006 9.05 0.0004 ) constant tbp-a3

'( 1.01 0.1361 2.01 0.0839 3.00 0.0761 4.00 0.0211 5.00 0.0045
   6.00 0.0018 7.00 0.0004 ) constant tbp-as3

'( 1.01 0.0960 2.01 0.0594 3.01 0.0315 4.01 0.0078 5.01 0.0021
   6.01 0.0009 7.02 0.0005 8.03 0.0003 ) constant tbp-b3

'( 1.00 0.0855 2.00 0.1172 3.00 0.0276 4.00 0.0135 5.00 0.0053
   6.00 0.0021 6.99 0.0003 ) constant tbp-c4

'( 1.01 0.0033 2.00 0.0982 2.99 0.0491 3.99 0.0185 4.99 0.0043
   5.98 0.0004 6.99 0.0001 ) constant tbp-cs4

'( 1.01 0.0485 2.01 0.1552 3.01 0.0547 4.01 0.0136 5.03 0.0026
   6.04 0.0010 7.05 0.0001 ) constant tbp-d4

'( 1.01 0.0030 2.01 0.1892 3.01 0.0563 4.01 0.0025 5.02 0.0034
   5.97 0.0001 7.03 0.0003 ) constant tbp-ds4

'( 1.01 0.0508 2.02 0.0934 3.02 0.0147 4.03 0.0111 5.05 0.0014
   6.06 0.0014 8.08 0.0001 ) constant tbp-e4

'( 1.00 0.0260 2.02 0.2047 3.02 0.0550 4.03 0.0165 5.04 0.0051
   6.04 0.0005 7.05 0.0002 ) constant tbp-f4

'( 1.02 0.0971 2.03 0.0635 3.04 0.0254 4.05 0.0023 5.07 0.0002
   6.08 0.0003 7.09 0.0001 ) constant tbp-fs4

'( 1.02 0.3176 2.03 0.0734 3.04 0.0332 4.05 0.0152 5.06 0.0048
   6.08 0.0007 ) constant tbp-g4

'( 1.01 0.3321 2.01 0.1320 3.01 0.0072 4.02 0.0028 5.03 0.0009
   6.04 0.0002 7.04 0.0002 ) constant tbp-gs4

'( 1.00 0.5149 2.00 0.2025 3.00 0.0392 3.99 0.0117 4.99 0.0035
   5.99 0.0008 6.99 0.0002 7.98 0.0001 ) constant tbp-a4

'( 1.01 0.3188 2.01 0.2130 3.02 0.0427 4.03 0.0024 5.05 0.0004
   6.05 0.0007 7.06 0.0002 8.06 0.0002 ) constant tbp-as4

'( 1.00 0.1685 1.99 0.0732 2.99 0.0056 3.99 0.0042 4.99 0.0009
   5.99 0.0005 ) constant tbp-b4

'( 1.01 0.3386 2.02 0.0634 3.02 0.0212 4.03 0.0019 5.04 0.0004 ) constant tbp-c5

'( 1.00 0.2958 2.00 0.0843 3.01 0.0058 4.01 0.0027 5.01 0.0003 ) constant tbp-cs5

'( 1.00 0.4237 2.01 0.0453 3.01 0.0045 4.02 0.0007 5.02 0.0004 ) constant tbp-d5

\ **********************************************************
\ trumpet
\ **********************************************************

'( 1.01 0.0533 2.03 0.0559 3.05 0.0505 4.06 0.0542 5.08 0.0382
   6.10 0.0570 7.12 0.0321 8.14 0.0393 9.15 0.0277 10.17 0.0157
   11.19 0.0165 12.20 0.0152 13.22 0.0081 14.23 0.0089 15.24 0.0035
   16.26 0.0045 17.28 0.0052 18.29 0.0020 19.31 0.0021 20.33 0.0017
   21.35 0.0014 22.37 0.0010 23.38 0.0009 24.40 0.0004 25.42 0.0005
   26.44 0.0004 27.45 0.0004 28.46 0.0004 29.48 0.0002 30.49 0.0002
   31.51 0.0002 32.53 0.0001 33.55 0.0001 ) constant trp-fs3

'( 0.99 0.0459 1.99 0.0931 3.00 0.0517 4.00 0.0496 5.00 0.0576
   6.00 0.0452 7.00 0.0263 8.00 0.0125 9.01 0.0131 10.01 0.0136
   11.00 0.0066 12.00 0.0081 13.00 0.0032 14.00 0.0039 14.99 0.0026
   16.00 0.0017 16.99 0.0017 17.99 0.0009 19.01 0.0013 20.01 0.0008
   21.01 0.0006 22.00 0.0006 23.00 0.0003 24.01 0.0004 25.01 0.0003
   26.01 0.0002 27.02 0.0002 28.02 0.0001 29.02 0.0001 31.04 0.0001 ) constant trp-g3

'( 0.99 0.0455 1.99 0.0969 2.97 0.0487 3.97 0.0296 4.97 0.0186
   5.95 0.0219 6.95 0.0075 7.94 0.0176 8.93 0.0202 9.93 0.0175
   10.91 0.0156 11.91 0.0097 12.91 0.0066 13.89 0.0065 14.89 0.0051
   15.88 0.0037 16.86 0.0015 17.87 0.0016 18.85 0.0010 19.85 0.0006
   20.84 0.0006 21.84 0.0006 22.84 0.0005 23.82 0.0003 24.82 0.0003
   25.80 0.0002 26.79 0.0002 27.79 0.0001 28.79 0.0001 ) constant trp-gs3

'( 0.99 0.0420 1.99 0.0954 2.99 0.0579 3.99 0.0722 4.98 0.0813
   5.98 0.0399 6.98 0.0379 7.98 0.0181 8.98 0.0188 9.98 0.0147
   10.97 0.0100 11.97 0.0091 12.96 0.0048 13.96 0.0091 14.96 0.0048
   15.96 0.0016 16.96 0.0027 17.97 0.0020 18.96 0.0014 19.96 0.0007
   20.95 0.0007 21.95 0.0006 22.94 0.0003 23.95 0.0005 24.95 0.0002
   25.95 0.0002 26.95 0.0002 27.96 0.0002 28.95 0.0002 29.94 0.0001 ) constant trp-a3

'( 1.01 0.0487 2.01 0.0236 3.01 0.0599 4.01 0.0397 5.01 0.0525
   6.01 0.0426 7.00 0.0144 8.01 0.0134 9.01 0.0274 10.01 0.0087
   11.01 0.0041 12.00 0.0052 13.01 0.0080 14.01 0.0028 15.02 0.0022
   16.01 0.0014 17.04 0.0005 18.04 0.0003 19.03 0.0005 20.02 0.0003
   21.02 0.0003 22.02 0.0003 23.03 0.0002 24.03 0.0002 25.02 0.0001 ) constant trp-as3

'( 1.00 0.0534 2.00 0.0362 3.00 0.0698 4.00 0.0793 4.99 0.0301
   6.00 0.0216 7.00 0.0130 8.00 0.0151 9.00 0.0172 10.00 0.0062
   11.00 0.0041 11.99 0.0022 13.00 0.0017 14.00 0.0012 14.99 0.0013
   15.95 0.0002 16.99 0.0001 18.00 0.0003 19.00 0.0003 20.00 0.0003
   21.01 0.0001 ) constant trp-b3

'( 1.01 0.0410 2.03 0.0543 3.03 0.0487 4.04 0.0354 5.05 0.0408
   6.06 0.0221 7.08 0.0099 8.09 0.0248 9.09 0.0107 10.11 0.0037
   11.11 0.0087 12.13 0.0035 13.14 0.0012 14.16 0.0013 15.17 0.0002
   16.18 0.0002 17.19 0.0003 18.20 0.0002 19.21 0.0002 20.22 0.0002
   21.23 0.0001 22.24 0.0001 ) constant trp-c4

'( 1.01 0.0199 2.03 0.0437 3.03 0.0142 4.04 0.0534 5.04 0.0310
   6.06 0.0194 7.06 0.0124 8.06 0.0071 9.07 0.0061 10.06 0.0037
   11.09 0.0022 12.12 0.0007 13.11 0.0005 14.12 0.0003 15.10 0.0002
   16.12 0.0002 17.13 0.0001 18.13 0.0001 ) constant trp-cs4

'( 1.01 0.0320 2.02 0.0510 3.04 0.0747 4.05 0.0619 5.06 0.0404
   6.07 0.0195 7.08 0.0221 8.09 0.0112 9.11 0.0073 10.13 0.0031
   11.13 0.0026 12.15 0.0017 13.16 0.0013 14.17 0.0009 15.18 0.0007
   16.18 0.0004 17.19 0.0003 18.22 0.0002 19.23 0.0002 20.23 0.0002
   21.25 0.0001 ) constant trp-d4

'( 1.00 0.0471 2.01 0.0466 3.02 0.0304 4.02 0.0166 5.02 0.0187
   6.02 0.0086 7.03 0.0064 8.03 0.0067 9.03 0.0033 10.02 0.0016
   11.05 0.0013 12.06 0.0008 13.06 0.0005 14.05 0.0002 15.04 0.0002
   16.05 0.0002 17.05 0.0001 ) constant trp-ds4

'( 1.01 0.0365 2.01 0.0352 3.02 0.0462 4.02 0.0230 5.02 0.0092
   6.02 0.0078 7.02 0.0059 8.04 0.0034 9.04 0.0011 10.05 0.0010
   11.07 0.0003 12.07 0.0003 13.06 0.0002 14.06 0.0001 15.07 0.0001 ) constant trp-e4

'( 1.00 0.0412 2.00 0.0621 3.00 0.0180 3.99 0.0631 4.99 0.0245
   5.99 0.0369 6.99 0.0093 7.99 0.0126 8.99 0.0027 9.99 0.0035
   10.99 0.0021 11.99 0.0016 12.99 0.0010 13.98 0.0009 14.98 0.0006
   15.98 0.0004 16.98 0.0002 ) constant trp-f4

'( 0.99 0.0581 1.98 0.0494 2.98 0.0614 3.97 0.0316 4.96 0.0151
   5.96 0.0095 6.95 0.0022 7.93 0.0022 8.93 0.0013 9.94 0.0008
   10.93 0.0003 11.92 0.0002 12.92 0.0001 13.93 0.0001 ) constant trp-fs4

'( 1.00 0.0979 1.99 0.0344 2.99 0.0374 3.99 0.0179 4.98 0.0148
   5.98 0.0059 6.98 0.0029 7.95 0.0005 8.97 0.0004 9.97 0.0002
   10.96 0.0002 ) constant trp-g4

'( 1.00 0.0670 2.00 0.0138 3.00 0.0100 4.01 0.0076 4.99 0.0070
   5.99 0.0037 6.97 0.0023 7.97 0.0007 8.97 0.0002 9.98 0.0001
   10.97 0.0002 ) constant trp-gs4

'( 1.00 0.0403 2.01 0.0211 3.00 0.0107 4.00 0.0052 4.99 0.0022
   6.00 0.0013 7.00 0.0006 8.01 0.0002 9.02 0.0001 10.03 0.0001 ) constant trp-a4

'( 1.00 0.0128 2.01 0.0154 3.00 0.0269 3.99 0.0098 4.99 0.0021
   5.98 0.0016 6.99 0.0004 8.00 0.0003 9.02 0.0002 ) constant trp-as4

'( 1.01 0.0287 2.01 0.0583 3.01 0.0386 4.00 0.0098 5.01 0.0068
   6.02 0.0012 7.02 0.0012 8.03 0.0003 9.02 0.0003 10.01 0.0001 ) constant trp-b4

'( 1.01 0.0190 2.01 0.0057 3.01 0.0039 4.01 0.0051 5.03 0.0005
   6.02 0.0002 7.03 0.0001 ) constant trp-c5

'( 1.01 0.0087 2.01 0.0050 3.01 0.0011 4.01 0.0002 ) constant trp-cs5

'( 1.01 0.0145 2.01 0.0098 3.01 0.0013 4.01 0.0003 ) constant trp-d5

'( 1.00 0.0231 2.00 0.0053 2.98 0.0077 3.97 0.0021 4.96 0.0003
   6.98 0.0001 ) constant trp-ds5

'( 1.01 0.0520 2.02 0.0187 3.00 0.0009 4.04 0.0011 5.02 0.0001 ) constant trp-e5

'( 1.02 0.0332 2.02 0.0074 3.03 0.0031 ) constant trp-f5

'( 1.01 0.1718 2.02 0.1098 3.02 0.0288 4.02 0.0047 5.04 0.0026
   6.04 0.0008 7.06 0.0004 8.06 0.0002 ) constant trp-fs5

'( 1.02 0.0825 2.03 0.0364 3.04 0.0160 4.06 0.0045 5.07 0.0011
   6.09 0.0005 7.10 0.0002 ) constant trp-g5

'( 1.02 0.0114 2.02 0.0346 3.02 0.0045 4.04 0.0013 5.06 0.0002 ) constant trp-gs5

'( 1.02 0.0821 2.03 0.0089 3.04 0.0023 4.06 0.0003 5.05 0.0001 ) constant trp-a5

'( 1.01 0.1554 2.01 0.0287 3.02 0.0084 4.02 0.0035 5.03 0.0007
   6.04 0.0002 7.04 0.0001 ) constant trp-as5

'( 1.01 0.0559 2.01 0.0017 3.01 0.0013 4.02 0.0001 ) constant trp-b5

'( 1.01 0.0291 2.00 0.0150 3.01 0.0032 4.02 0.0004 5.02 0.0002 ) constant trp-c6

\ **********************************************************
\
\ **********************************************************

'( 1.00 0.0292 1.99 0.0424 3.00 0.0242 4.00 0.0413 4.99 0.0315
   6.00 0.0454 7.00 0.0143 7.98 0.0108 8.99 0.0077 9.99 0.0084
   10.99 0.0071 11.98 0.0078 12.97 0.0085 13.98 0.0032 14.97 0.0035
   15.97 0.0052 16.96 0.0021 17.96 0.0033 18.96 0.0024 19.97 0.0016
   20.95 0.0015 21.95 0.0011 22.95 0.0006 23.95 0.0007 24.94 0.0006
   25.94 0.0004 26.94 0.0003 27.93 0.0004 28.93 0.0003 29.93 0.0002
   30.92 0.0003 31.92 0.0001 32.93 0.0001 33.91 0.0002 ) constant trpf-fs3

'( 0.99 0.0286 1.97 0.0669 2.95 0.0456 3.95 0.0345 4.94 0.0617
   5.91 0.0341 6.90 0.0225 7.89 0.0264 8.88 0.0155 9.86 0.0160
   10.84 0.0150 11.83 0.0085 12.82 0.0112 13.80 0.0054 14.78 0.0042
   15.77 0.0056 16.76 0.0023 17.73 0.0027 18.71 0.0010 19.73 0.0014
   20.69 0.0014 21.68 0.0007 22.67 0.0007 23.64 0.0007 24.63 0.0004
   25.62 0.0005 26.59 0.0003 27.62 0.0002 28.56 0.0003 29.55 0.0001
   30.53 0.0002 31.51 0.0002 32.50 0.0001 33.48 0.0002 35.47 0.0001 ) constant trpf-g3

'( 0.99 0.0306 1.99 0.0608 2.97 0.0495 3.97 0.0557 4.97 0.0228
   5.95 0.0337 6.95 0.0177 7.94 0.0112 8.92 0.0146 9.93 0.0022
   10.91 0.0069 11.89 0.0053 12.89 0.0047 13.88 0.0031 14.87 0.0063
   15.87 0.0042 16.86 0.0033 17.84 0.0031 18.84 0.0028 19.83 0.0018
   20.83 0.0015 21.82 0.0010 22.80 0.0010 23.80 0.0005 24.79 0.0007
   25.77 0.0004 26.77 0.0005 27.76 0.0003 28.75 0.0003 29.74 0.0002
   30.74 0.0002 32.73 0.0001 ) constant trpf-gs3

'( 0.99 0.0331 2.00 0.0607 3.00 0.0463 4.00 0.0350 5.00 0.0480
   6.00 0.0294 7.00 0.0318 7.99 0.0150 8.98 0.0166 9.98 0.0148
   10.98 0.0109 11.99 0.0052 13.02 0.0012 13.99 0.0070 14.98 0.0054
   15.98 0.0035 16.97 0.0035 17.96 0.0021 18.96 0.0019 19.96 0.0008
   20.96 0.0010 21.97 0.0006 22.96 0.0005 23.96 0.0007 24.96 0.0004
   25.95 0.0006 26.95 0.0004 27.94 0.0003 28.94 0.0002 29.94 0.0001
   30.94 0.0002 31.93 0.0002 32.93 0.0001 ) constant trpf-a3

'( 1.00 0.0250 2.00 0.0182 2.99 0.0170 3.97 0.0199 4.97 0.0223
   5.97 0.0224 6.95 0.0094 7.95 0.0070 8.94 0.0069 9.92 0.0064
   10.91 0.0030 11.92 0.0028 12.90 0.0024 13.01 0.0007 14.00 0.0003
   14.89 0.0008 15.89 0.0007 16.91 0.0002 17.88 0.0002 18.86 0.0001
   20.83 0.0001 ) constant trpf-as3

'( 1.00 0.0379 1.99 0.0221 2.99 0.0480 3.99 0.0721 4.97 0.0322
   5.98 0.0203 6.97 0.0220 7.97 0.0170 8.96 0.0150 9.96 0.0042
   10.95 0.0040 11.93 0.0049 12.94 0.0038 14.00 0.0011 14.95 0.0021
   15.95 0.0008 16.93 0.0004 16.98 0.0004 17.90 0.0004 18.00 0.0003
   18.99 0.0003 19.89 0.0003 20.88 0.0003 21.89 0.0002 22.97 0.0002
   23.97 0.0002 ) constant trpf-b3

'( 1.01 0.0330 2.02 0.0365 3.02 0.0430 4.03 0.0164 5.05 0.0234
   6.04 0.0138 7.05 0.0110 8.06 0.0202 9.07 0.0098 10.08 0.0030
   11.09 0.0065 12.11 0.0027 13.11 0.0009 14.13 0.0014 15.15 0.0003
   16.12 0.0002 17.13 0.0002 18.12 0.0002 19.14 0.0002 20.13 0.0002
   21.14 0.0001 ) constant trpf-c4

'( 1.01 0.0082 2.02 0.0191 3.02 0.0152 4.01 0.0324 5.02 0.0129
   6.03 0.0050 7.01 0.0093 8.01 0.0031 9.01 0.0036 10.00 0.0017
   11.01 0.0010 12.00 0.0004 13.02 0.0004 14.03 0.0003 15.02 0.0002
   16.03 0.0001 ) constant trpf-cs4

'( 1.01 0.0190 2.03 0.0431 3.04 0.0481 4.05 0.0399 5.07 0.0179
   6.08 0.0198 7.09 0.0136 8.10 0.0081 9.12 0.0041 10.10 0.0011
   11.15 0.0016 12.16 0.0014 13.17 0.0007 14.18 0.0005 15.20 0.0003
   16.20 0.0002 17.22 0.0002 19.24 0.0001 ) constant trpf-d4

'( 1.00 0.0239 2.01 0.0207 3.02 0.0113 4.00 0.0083 5.00 0.0145
   5.97 0.0054 6.99 0.0031 7.98 0.0026 8.97 0.0027 9.98 0.0010
   11.01 0.0004 11.99 0.0004 13.00 0.0003 13.97 0.0002 14.98 0.0002
   15.97 0.0002 ) constant trpf-ds4

'( 1.02 0.0134 2.03 0.0124 3.04 0.0117 4.05 0.0041 5.08 0.0007
   6.06 0.0009 7.08 0.0006 8.06 0.0002 9.11 0.0002 ) constant trpf-e4

'( 1.03 0.0045 2.03 0.0019 3.03 0.0006 4.04 0.0012 5.02 0.0004
   6.08 0.0001 ) constant trpf-f4

'( 1.00 0.0501 2.00 0.0385 3.00 0.0509 3.99 0.0156 4.98 0.0099
   5.98 0.0063 6.99 0.0017 7.97 0.0020 8.97 0.0017 9.96 0.0012
   10.96 0.0004 11.95 0.0004 12.97 0.0001 13.94 0.0002 ) constant trpf-fs4

'( 1.00 0.0998 2.00 0.0632 3.01 0.0506 4.01 0.0395 5.00 0.0265
   6.01 0.0137 7.01 0.0058 8.01 0.0017 9.02 0.0010 10.02 0.0007
   11.02 0.0007 12.03 0.0004 13.03 0.0004 14.03 0.0002 15.05 0.0001 ) constant trpf-g4

'( 1.00 0.0589 2.00 0.0237 2.99 0.0208 3.98 0.0103 4.98 0.0087
   5.98 0.0053 6.97 0.0039 7.98 0.0017 8.98 0.0006 10.00 0.0003
   10.97 0.0002 12.00 0.0001 ) constant trpf-gs4

'( 1.01 0.0482 2.01 0.0264 3.02 0.0127 4.01 0.0108 5.01 0.0039
   6.01 0.0012 7.00 0.0012 8.01 0.0004 9.02 0.0002 10.02 0.0002
   11.00 0.0001 ) constant trpf-a4

'( 1.00 0.0176 2.01 0.0156 3.00 0.0312 3.99 0.0057 5.00 0.0055
   5.99 0.0036 6.99 0.0007 7.99 0.0005 8.99 0.0003 9.99 0.0001
   10.99 0.0001 ) constant trpf-as4

'( 1.01 0.0051 1.99 0.0340 2.98 0.0087 3.97 0.0121 4.97 0.0018
   5.94 0.0018 6.95 0.0005 7.93 0.0002 8.94 0.0004 ) constant trpf-b4

'( 1.01 0.0110 1.99 0.0059 3.00 0.0200 3.99 0.0059 5.00 0.0016
   5.99 0.0005 6.98 0.0002 7.96 0.0002 8.99 0.0002 ) constant trpf-c5

'( 1.01 0.0257 2.01 0.0215 3.02 0.0022 4.00 0.0027 5.01 0.0007
   6.00 0.0007 7.02 0.0002 ) constant trpf-cs5

'( 1.01 0.0616 2.01 0.0423 3.01 0.0140 4.01 0.0061 4.99 0.0034
   5.99 0.0008 6.98 0.0006 8.00 0.0003 8.97 0.0002 ) constant trpf-d5

'( 0.99 0.0763 1.99 0.0800 2.98 0.0329 3.97 0.0255 4.96 0.0110
   5.95 0.0041 6.95 0.0018 7.94 0.0006 8.93 0.0005 9.90 0.0002
   9.93 0.0002 10.91 0.0002 ) constant trpf-ds5

'( 1.01 0.0196 2.00 0.0085 2.98 0.0039 3.97 0.0007 4.98 0.0003 ) constant trpf-e5

'( 1.02 0.0735 2.03 0.0526 3.04 0.0168 4.05 0.0064 5.07 0.0009
   6.07 0.0008 7.09 0.0002 8.09 0.0001 9.12 0.0001 ) constant trpf-f5

'( 1.01 0.1101 2.02 0.0477 3.03 0.0090 4.04 0.0024 5.05 0.0012
   6.06 0.0015 7.07 0.0004 8.08 0.0002 ) constant trpf-fs5

'( 1.02 0.1148 2.03 0.0215 3.04 0.0185 4.06 0.0077 5.07 0.0023
   6.08 0.0007 7.09 0.0004 8.12 0.0002 ) constant trpf-g5

'( 1.01 0.0538 2.02 0.0584 3.03 0.0156 4.04 0.0028 5.06 0.0009
   6.07 0.0006 7.07 0.0002 ) constant trpf-gs5

'( 1.01 0.1885 2.02 0.0789 3.04 0.0214 4.05 0.0086 5.06 0.0049
   6.07 0.0010 7.08 0.0007 8.10 0.0003 9.11 0.0003 10.12 0.0001
   11.13 0.0001 ) constant trpf-a5

'( 1.01 0.0233 2.02 0.0033 3.01 0.0008 4.03 0.0002 ) constant trpf-as5

'( 1.00 0.1077 2.01 0.0158 3.01 0.0039 4.01 0.0011 5.01 0.0003
   6.02 0.0002 7.02 0.0001 ) constant trpf-b5

'( 1.01 0.0873 2.02 0.0519 3.03 0.0156 4.04 0.0042 5.04 0.0019
   6.05 0.0006 7.06 0.0004 8.07 0.0002 ) constant trpf-c6

'( 1.01 0.0852 2.02 0.0049 3.03 0.0007 4.05 0.0001 ) constant trpf-cs6

\ **********************************************************
\ violin
\ **********************************************************

'( 0.99 0.0159 1.99 0.1898 3.00 0.0499 3.99 0.0352 5.00 0.0192
   6.00 0.0100 7.00 0.0173 8.00 0.0142 8.99 0.0045 10.01 0.0178
   11.00 0.0108 12.00 0.0081 12.99 0.0254 13.99 0.0074 14.99 0.0062
   16.00 0.0122 17.00 0.0049 17.99 0.0022 19.01 0.0041 20.01 0.0048
   21.01 0.0037 22.01 0.0016 23.01 0.0001 24.00 0.0002 25.00 0.0006
   26.00 0.0010 27.00 0.0015 28.03 0.0004 29.02 0.0007 30.01 0.0006
   32.00 0.0002 33.01 0.0001 34.00 0.0001 35.01 0.0004 36.02 0.0003
   37.02 0.0001 40.02 0.0001 40.99 0.0002 42.01 0.0003 48.01 0.0001
   51.01 0.0001 ) constant vl-g3

'( 0.99 0.0185 1.99 0.1881 2.97 0.0463 3.97 0.0528 4.97 0.0309
   5.95 0.0316 6.95 0.0104 7.93 0.0422 8.94 0.0114 9.90 0.0018
   10.92 0.0088 11.89 0.0021 12.90 0.0077 13.91 0.0044 14.86 0.0029
   14.93 0.0028 15.91 0.0011 16.88 0.0082 17.89 0.0022 18.88 0.0043
   19.86 0.0024 20.84 0.0012 21.84 0.0007 22.87 0.0008 23.85 0.0006
   24.84 0.0004 25.82 0.0010 26.81 0.0006 27.81 0.0012 28.79 0.0002
   29.78 0.0002 30.77 0.0001 31.78 0.0003 33.75 0.0001 34.76 0.0002
   35.75 0.0002 36.75 0.0002 37.77 0.0001 40.74 0.0001 ) constant vl-gs3

'( 0.99 0.0215 2.00 0.1550 2.99 0.0293 4.00 0.0298 5.00 0.0211
   6.00 0.0389 7.00 0.0057 7.99 0.0235 8.99 0.0172 9.99 0.0040
   11.00 0.0026 12.00 0.0074 12.99 0.0065 13.99 0.0192 14.99 0.0026
   15.98 0.0063 16.99 0.0045 18.01 0.0036 18.99 0.0050 20.00 0.0012
   20.98 0.0011 21.99 0.0007 22.99 0.0014 23.99 0.0003 25.00 0.0011
   26.00 0.0008 26.99 0.0007 27.98 0.0002 28.99 0.0001 29.97 0.0004
   31.00 0.0002 31.99 0.0002 32.99 0.0002 33.98 0.0001 35.03 0.0001
   36.00 0.0002 36.98 0.0003 37.99 0.0002 38.99 0.0001 39.99 0.0002
   41.01 0.0001 41.99 0.0001 43.04 0.0001 43.99 0.0001 ) constant vl-a3

'( 1.00 0.0210 2.00 0.1015 3.00 0.0450 3.99 0.0210 4.99 0.0266
   6.00 0.0143 7.00 0.0661 7.99 0.0367 8.99 0.0149 9.99 0.0037
   10.99 0.0344 11.99 0.0069 12.99 0.0110 13.98 0.0088 14.98 0.0052
   15.98 0.0066 16.99 0.0038 17.98 0.0027 18.98 0.0007 19.98 0.0018
   20.98 0.0009 21.99 0.0011 22.99 0.0013 23.99 0.0006 24.97 0.0004
   25.98 0.0001 26.98 0.0003 27.97 0.0002 28.99 0.0002 29.97 0.0002
   31.00 0.0002 31.97 0.0004 32.97 0.0001 33.99 0.0003 34.97 0.0002
   35.97 0.0003 36.94 0.0001 37.99 0.0001 38.96 0.0001 41.97 0.0001 ) constant vl-as3

'( 1.00 0.0532 1.99 0.0205 3.00 0.0342 3.99 0.0312 5.00 0.0493
   5.99 0.0062 6.99 0.0103 7.99 0.0240 8.99 0.0134 9.99 0.0046
   10.98 0.0154 11.99 0.0077 12.98 0.0084 13.99 0.0028 14.99 0.0026
   15.98 0.0054 16.98 0.0031 17.99 0.0004 18.98 0.0009 19.99 0.0005
   20.52 0.0001 21.98 0.0011 22.97 0.0010 23.99 0.0004 24.96 0.0003
   26.00 0.0001 27.99 0.0006 28.99 0.0001 30.97 0.0003 32.00 0.0002
   32.99 0.0001 33.97 0.0002 36.99 0.0001 ) constant vl-b3

'( 0.99 0.1156 2.00 0.0827 3.00 0.0458 4.00 0.0163 5.00 0.0256
   6.01 0.0103 7.02 0.0032 8.00 0.0025 8.98 0.0056 10.00 0.0072
   10.98 0.0016 11.98 0.0036 13.02 0.0013 14.00 0.0021 15.00 0.0024
   15.99 0.0013 16.99 0.0003 18.01 0.0001 19.01 0.0003 19.99 0.0001
   21.02 0.0001 22.03 0.0002 29.00 0.0001 ) constant vl-c4

'( 1.00 0.3269 2.00 0.0869 2.99 0.0386 4.00 0.0117 4.99 0.0062
   6.00 0.0264 7.00 0.0099 8.00 0.0038 9.01 0.0040 10.00 0.0057
   11.03 0.0040 12.02 0.0017 13.00 0.0009 14.02 0.0026 15.02 0.0009
   15.95 0.0002 16.99 0.0002 18.01 0.0001 19.01 0.0005 20.00 0.0001
   21.03 0.0002 22.03 0.0001 ) constant vl-cs4

'( 1.00 0.2473 2.00 0.0621 2.98 0.0073 3.99 0.0178 5.00 0.0070
   5.98 0.0041 7.02 0.0054 8.01 0.0114 9.05 0.0034 10.05 0.0024
   10.93 0.0003 11.99 0.0011 13.00 0.0011 14.03 0.0010 15.01 0.0002
   15.96 0.0001 17.02 0.0001 18.01 0.0005 21.00 0.0001 22.00 0.0002 ) constant vl-d4

'( 1.00 0.0394 2.00 0.0358 2.99 0.0119 3.99 0.0208 4.99 0.0064
   5.98 0.0126 6.96 0.0028 7.03 0.0017 8.01 0.0006 8.92 0.0005
   9.97 0.0048 10.97 0.0004 11.99 0.0005 12.97 0.0005 13.96 0.0002
   14.92 0.0001 15.92 0.0001 19.93 0.0001 22.92 0.0001 23.96 0.0001 ) constant vl-ds4

'( 1.00 0.0649 2.00 0.0412 3.01 0.0315 4.00 0.0446 5.01 0.0414
   6.01 0.0209 7.02 0.0189 8.01 0.0101 9.03 0.0012 10.03 0.0029
   11.02 0.0041 12.00 0.0012 13.04 0.0004 14.05 0.0005 15.03 0.0009
   16.06 0.0005 17.09 0.0004 18.07 0.0006 19.08 0.0004 20.10 0.0001
   21.09 0.0001 22.09 0.0004 23.11 0.0002 24.06 0.0002 25.07 0.0002
   26.07 0.0002 27.08 0.0002 30.10 0.0001 ) constant vl-e4

'( 1.00 0.0700 2.00 0.0235 3.00 0.0294 4.00 0.0101 4.99 0.0173
   5.99 0.0081 6.99 0.0023 7.99 0.0006 8.97 0.0101 9.98 0.0060
   11.00 0.0063 11.99 0.0038 13.00 0.0011 13.98 0.0003 15.01 0.0009
   16.02 0.0005 17.01 0.0004 18.06 0.0002 19.01 0.0004 20.01 0.0004
   21.03 0.0005 22.04 0.0002 23.00 0.0003 24.00 0.0001 25.99 0.0001
   29.04 0.0001 31.04 0.0001 ) constant vl-f4

'( 1.01 0.1897 2.02 0.0152 3.02 0.0312 4.03 0.0224 5.03 0.0483
   6.04 0.0217 7.05 0.0184 8.07 0.0051 9.06 0.0031 10.08 0.0047
   11.09 0.0040 12.10 0.0021 13.10 0.0006 14.11 0.0010 15.14 0.0012
   16.14 0.0009 17.15 0.0004 18.16 0.0010 19.18 0.0003 20.19 0.0005
   21.14 0.0002 22.17 0.0002 23.18 0.0002 24.18 0.0002 26.22 0.0001
   29.25 0.0002 30.26 0.0002 ) constant vl-fs4

'( 1.01 0.0788 2.01 0.0144 2.99 0.0064 3.99 0.0078 5.02 0.0053
   6.00 0.0045 7.01 0.0011 7.98 0.0025 9.03 0.0010 10.02 0.0014
   11.02 0.0002 12.02 0.0001 13.02 0.0003 14.05 0.0002 15.07 0.0002
   17.05 0.0001 18.02 0.0002 19.07 0.0001 ) constant vl-g4

'( 1.00 0.2902 2.01 0.0644 3.01 0.0378 4.02 0.0473 5.02 0.0027
   6.03 0.0278 7.04 0.0077 8.04 0.0105 9.04 0.0026 10.04 0.0106
   11.05 0.0011 12.05 0.0014 13.06 0.0045 14.09 0.0015 15.09 0.0010
   16.09 0.0008 17.09 0.0011 18.10 0.0010 19.09 0.0011 20.09 0.0004
   21.10 0.0010 22.10 0.0006 23.11 0.0003 24.10 0.0002 24.14 0.0002
   25.15 0.0002 26.14 0.0005 27.14 0.0003 30.13 0.0002 31.14 0.0001 ) constant vl-gs4

'( 1.00 0.3420 2.02 0.0045 3.00 0.0160 4.00 0.0105 5.01 0.0370
   6.02 0.0193 7.01 0.0342 8.02 0.0178 9.02 0.0146 10.04 0.0025
   11.03 0.0011 12.02 0.0010 13.03 0.0009 14.03 0.0003 15.05 0.0031
   16.04 0.0009 17.04 0.0004 18.04 0.0004 19.03 0.0004 20.06 0.0005
   21.05 0.0001 22.04 0.0001 24.06 0.0001 25.07 0.0002 26.08 0.0001 ) constant vl-a4

'( 1.00 0.1478 2.00 0.0159 3.00 0.0033 3.99 0.0600 5.00 0.0291
   5.99 0.0028 7.01 0.0118 8.00 0.0115 8.99 0.0039 9.99 0.0020
   10.99 0.0024 11.99 0.0012 12.99 0.0009 14.01 0.0011 15.00 0.0015
   16.01 0.0004 17.02 0.0001 18.01 0.0001 19.01 0.0002 20.00 0.0002
   20.98 0.0001 22.00 0.0001 24.02 0.0002 25.00 0.0002 ) constant vl-as4

'( 1.00 0.0247 2.01 0.0570 3.01 0.0115 4.02 0.0167 5.02 0.0162
   6.02 0.0154 7.02 0.0056 8.04 0.0021 9.04 0.0003 10.04 0.0023
   11.04 0.0003 12.07 0.0005 13.09 0.0005 14.06 0.0003 15.06 0.0004
   16.09 0.0003 17.07 0.0002 18.10 0.0003 19.10 0.0002 ) constant vl-b4

'( 1.00 0.0690 1.99 0.0372 2.99 0.0326 3.99 0.0222 4.99 0.0107
   5.97 0.0033 6.99 0.0029 7.98 0.0013 8.97 0.0005 9.98 0.0008
   10.97 0.0004 11.97 0.0006 12.99 0.0003 13.99 0.0002 14.97 0.0001
   16.95 0.0001 16.98 0.0001 17.97 0.0001 19.96 0.0001 ) constant vl-c5

'( 1.00 0.1446 2.01 0.0499 3.01 0.0768 4.02 0.0436 5.02 0.0287
   6.03 0.0204 7.03 0.0301 7.11 0.0011 8.04 0.0010 9.04 0.0036
   10.05 0.0030 11.05 0.0023 12.06 0.0008 13.06 0.0005 14.07 0.0009
   15.08 0.0005 16.09 0.0009 17.08 0.0003 18.10 0.0006 19.09 0.0008
   20.13 0.0002 21.11 0.0001 22.14 0.0001 23.11 0.0002 ) constant vl-cs5

'( 1.00 0.0614 1.99 0.0194 2.99 0.0196 3.99 0.0159 5.00 0.0057
   6.00 0.0031 7.01 0.0024 8.00 0.0004 9.00 0.0003 9.98 0.0003
   11.01 0.0005 11.99 0.0003 12.99 0.0002 16.99 0.0001 17.98 0.0001 ) constant vl-d5

'( 0.99 0.1393 1.99 0.0875 2.99 0.1163 3.98 0.0152 4.98 0.0551
   5.97 0.0214 6.97 0.0072 7.96 0.0017 8.95 0.0028 9.96 0.0034
   10.95 0.0015 11.94 0.0010 12.95 0.0009 13.91 0.0008 14.94 0.0011
   15.93 0.0005 16.93 0.0007 17.92 0.0004 17.97 0.0002 18.94 0.0002
   19.93 0.0003 20.92 0.0004 21.90 0.0001 ) constant vl-ds5

'( 1.00 0.1926 2.00 0.0731 3.00 0.0543 4.00 0.0258 5.02 0.0238
   6.02 0.0177 7.03 0.0206 8.03 0.0081 9.03 0.0030 10.05 0.0043
   11.03 0.0011 12.06 0.0007 13.08 0.0013 14.10 0.0007 15.11 0.0004
   16.14 0.0002 ) constant vl-e5

'( 1.00 0.0684 2.00 0.0409 3.00 0.0344 4.00 0.0439 5.00 0.0686
   6.00 0.0504 7.00 0.0045 8.00 0.0056 9.00 0.0094 10.00 0.0028
   11.00 0.0015 11.99 0.0010 13.00 0.0032 14.00 0.0017 15.00 0.0010
   16.01 0.0011 16.99 0.0003 18.01 0.0006 19.00 0.0003 ) constant vl-f5

'( 1.00 0.0291 2.01 0.0323 3.01 0.0110 4.02 0.0071 5.04 0.0028
   6.04 0.0010 7.08 0.0007 8.08 0.0003 9.09 0.0004 10.12 0.0002
   11.06 0.0003 ) constant vl-fs5

'( 1.00 0.0980 1.99 0.0303 3.00 0.0044 4.01 0.0107 5.03 0.0027
   6.03 0.0011 7.00 0.0010 8.02 0.0011 8.06 0.0004 9.04 0.0003
   10.04 0.0001 ) constant vl-g5

'( 1.01 0.1116 2.01 0.0200 3.03 0.0147 4.03 0.0034 5.08 0.0061
   6.10 0.0012 7.06 0.0005 8.14 0.0005 9.14 0.0004 ) constant vl-gs5

'( 1.00 0.0211 2.01 0.0180 3.01 0.0158 4.02 0.0057 5.03 0.0013
   6.03 0.0006 7.02 0.0001 ) constant vl-a5

'( 1.00 0.0442 2.01 0.0922 3.01 0.0102 4.00 0.0031 5.03 0.0053
   6.01 0.0004 7.04 0.0018 7.08 0.0009 8.06 0.0004 9.06 0.0006
   10.06 0.0003 11.06 0.0003 12.09 0.0002 13.09 0.0002 ) constant vl-as5

'( 1.01 0.0061 2.01 0.0016 3.01 0.0014 4.03 0.0005 5.04 0.0005
   5.06 0.0001 ) constant vl-b5

'( 1.01 0.0039 2.00 0.0005 3.02 0.0006 4.03 0.0001 ) constant vl-c6

'( 1.00 0.0754 2.00 0.1620 3.00 0.1551 4.00 0.0277 5.00 0.0466
   6.00 0.0408 7.00 0.0025 8.00 0.0055 9.00 0.0048 9.99 0.0034
   10.99 0.0039 11.99 0.0005 ) constant vl-cs6

'( 1.00 0.0905 2.00 0.0808 3.00 0.0909 4.00 0.0616 5.00 0.0172
   5.99 0.0043 7.01 0.0044 8.00 0.0036 9.00 0.0043 10.01 0.0015
   11.03 0.0014 ) constant vl-d6

'( 1.00 0.1772 2.00 0.1029 3.00 0.0398 4.01 0.0602 5.00 0.0222
   6.01 0.0073 7.01 0.0037 8.01 0.0044 9.01 0.0019 10.01 0.0028
   11.01 0.0006 11.03 0.0001 ) constant vl-ds6

'( 1.00 0.1865 2.00 0.2083 2.99 0.0822 3.99 0.0298 4.99 0.0227
   6.00 0.0023 6.98 0.0049 7.99 0.0021 8.98 0.0022 9.98 0.0003
   9.99 0.0003 ) constant vl-e6

'( 1.01 0.0841 2.01 0.0654 3.02 0.1346 4.03 0.0041 5.04 0.0077
   6.05 0.0088 7.05 0.0016 8.06 0.0017 9.06 0.0012 9.08 0.0003
   9.10 0.0002 9.11 0.0001 ) constant vl-f6

'( 1.00 0.1693 2.02 0.0779 3.03 0.0411 4.03 0.0147 5.04 0.0085
   6.05 0.0080 7.06 0.0088 8.06 0.0032 9.06 0.0010 9.08 0.0007
   9.10 0.0004 ) constant vl-fs6

'( 1.01 0.2123 2.02 0.2854 3.03 0.0552 4.04 0.0246 5.05 0.0058
   6.06 0.0022 7.07 0.0017 8.09 0.0029 9.10 0.0001 ) constant vl-g6

'( 1.02 0.1270 2.03 0.0961 3.05 0.0347 4.06 0.0032 5.08 0.0083
   6.09 0.0050 7.11 0.0020 8.12 0.0013 8.14 0.0002 ) constant vl-gs6

'( 1.02 0.3359 2.03 0.1252 3.05 0.0238 4.07 0.0155 5.09 0.0053
   6.10 0.0051 7.12 0.0025 7.18 0.0001 ) constant vl-a6

'( 1.01 0.2037 2.03 0.0456 3.05 0.0029 4.06 0.0053 5.07 0.0041
   6.09 0.0043 7.11 0.0026 7.13 0.0006 7.14 0.0001 ) constant vl-as6

'( 1.02 0.4213 2.04 0.1379 3.06 0.0067 4.06 0.0041 4.08 0.0039
   5.09 0.0026 6.11 0.0027 7.13 0.0002 ) constant vl-b6

'( 1.01 0.1299 2.02 0.1571 3.03 0.0461 4.04 0.0033 5.05 0.0057
   6.06 0.0015 ) constant vl-c7

'( 1.01 0.1471 2.03 0.0526 3.05 0.0161 4.06 0.0037 5.08 0.0017
   6.09 0.0005 ) constant vl-cs7

'( 1.01 0.0321 2.02 0.0529 3.03 0.0046 4.03 0.0054 4.04 0.0021
   5.04 0.0010 ) constant vl-d7

'( 1.00 0.1220 2.00 0.0667 2.99 0.0319 4.00 0.0020 4.99 0.0052
   5.03 0.0002 ) constant vl-ds7

'( 1.01 0.1110 2.02 0.0588 3.03 0.0143 4.04 0.0068 5.05 0.0011 ) constant vl-e7

'( 1.01 0.0798 2.02 0.0111 3.03 0.0125 4.03 0.0036 4.50 0.0002
   5.04 0.0001 ) constant vl-f7

'( 1.02 0.1071 2.04 0.0117 3.06 0.0148 4.08 0.0092 4.11 0.0007
   4.13 0.0005 4.16 0.0003 4.23 0.0002 4.24 0.0002 4.28 0.0002
   4.34 0.0001 4.39 0.0001 ) constant vl-fs7

'( 1.02 0.2741 2.05 0.0256 3.07 0.0122 4.11 0.0002 4.14 0.0001 ) constant vl-g7

'( 1.02 0.1027 2.05 0.0192 3.07 0.0091 ) constant vl-gs7

'( 1.02 0.0796 2.04 0.0112 3.06 0.0030 ) constant vl-a7

'( 1.06 0.1256 ) constant vl-as7

'( 1.08 0.1494 3.24 0.0003 ) constant vl-b7

'( 1.07 0.0582 3.25 0.0004 ) constant vl-c8

'( 1.08 0.0889 ) constant vl-cs8

'( 1.07 0.0573 ) constant vl-d8

\ **********************************************************
\
\ **********************************************************

'( 1.01 0.0037 2.01 0.0482 3.01 0.0275 4.01 0.0182 5.03 0.0047
   6.03 0.0032 7.03 0.0005 8.03 0.0050 9.05 0.0044 10.02 0.0016
   11.06 0.0011 12.06 0.0004 13.06 0.0006 14.16 0.0001 15.12 0.0001
   16.12 0.0004 17.12 0.0004 19.08 0.0003 20.11 0.0004 23.11 0.0002
   24.14 0.0003 25.14 0.0003 27.12 0.0002 28.13 0.0001 30.17 0.0001 ) constant almf-c3

'( 1.01 0.0043 2.01 0.0357 3.02 0.0452 4.01 0.0156 5.02 0.0152
   6.04 0.0022 7.04 0.0039 8.06 0.0078 9.06 0.0049 10.09 0.0046
   11.24 0.0004 12.08 0.0016 13.09 0.0015 14.10 0.0021 15.12 0.0006
   16.12 0.0012 17.12 0.0002 18.16 0.0004 19.16 0.0006 20.15 0.0006
   21.15 0.0007 22.16 0.0005 23.17 0.0005 24.13 0.0004 25.48 0.0003
   26.19 0.0002 27.18 0.0002 28.20 0.0002 30.26 0.0001 31.25 0.0002
   34.23 0.0001 ) constant almf-cs3

'( 1.01 0.0052 2.03 0.0062 3.01 0.0292 4.05 0.0043 5.02 0.0149
   5.97 0.0018 7.02 0.0016 8.05 0.0029 9.04 0.0005 10.06 0.0012
   11.04 0.0006 12.12 0.0002 13.05 0.0005 14.10 0.0004 15.08 0.0004
   15.99 0.0001 17.18 0.0001 18.07 0.0004 19.06 0.0001 20.08 0.0003
   22.11 0.0003 24.13 0.0002 25.15 0.0001 26.12 0.0001 ) constant almf-d3

'( 1.01 0.0043 2.01 0.0532 3.01 0.0389 4.00 0.0094 5.01 0.0031
   6.00 0.0038 7.00 0.0219 8.00 0.0122 8.99 0.0129 10.00 0.0014
   11.00 0.0021 12.01 0.0037 13.01 0.0021 14.01 0.0017 15.02 0.0015
   16.01 0.0023 17.03 0.0024 18.00 0.0008 19.03 0.0011 20.04 0.0003
   21.04 0.0009 22.04 0.0003 23.00 0.0012 24.00 0.0011 25.01 0.0007
   27.02 0.0002 28.02 0.0004 29.03 0.0003 30.04 0.0002 31.04 0.0001
   46.55 0.0001 48.01 0.0001 ) constant almf-ds3

'( 1.00 0.0123 2.00 0.0733 2.99 0.0330 4.00 0.0098 5.00 0.0171
   6.00 0.0013 7.01 0.0117 7.99 0.0020 9.00 0.0044 10.01 0.0012
   11.01 0.0014 12.00 0.0021 13.02 0.0002 14.02 0.0016 15.03 0.0012
   16.03 0.0028 17.02 0.0007 18.02 0.0019 19.03 0.0008 20.04 0.0013
   21.03 0.0005 22.03 0.0005 23.03 0.0003 24.04 0.0003 26.03 0.0005
   27.04 0.0001 28.06 0.0001 29.04 0.0002 ) constant almf-e3

'( 1.00 0.0185 2.00 0.0813 3.00 0.0142 3.99 0.0132 5.00 0.0066
   5.99 0.0027 6.93 0.0009 8.01 0.0042 8.99 0.0018 9.97 0.0002
   10.97 0.0010 12.00 0.0008 13.00 0.0012 13.98 0.0003 14.96 0.0006
   16.00 0.0004 17.01 0.0005 18.00 0.0003 18.98 0.0005 19.99 0.0002
   20.99 0.0002 22.00 0.0002 ) constant almf-f3

'( 1.01 0.0480 2.01 0.0778 3.01 0.0124 4.01 0.0204 5.05 0.0008
   6.03 0.0068 7.05 0.0052 8.06 0.0017 9.07 0.0017 10.05 0.0008
   11.07 0.0010 12.08 0.0008 13.11 0.0002 14.08 0.0006 15.10 0.0002
   16.09 0.0013 17.12 0.0003 18.10 0.0003 19.11 0.0004 20.14 0.0001
   23.17 0.0001 ) constant almf-fs3

'( 1.00 0.0526 2.00 0.0242 2.99 0.0351 3.99 0.0076 4.98 0.0062
   5.99 0.0085 6.99 0.0061 8.04 0.0006 8.98 0.0005 10.01 0.0006
   10.97 0.0003 11.96 0.0004 13.07 0.0004 13.95 0.0003 14.99 0.0003
   15.20 0.0002 17.93 0.0002 18.02 0.0002 24.96 0.0001 ) constant almf-g3

'( 0.99 0.0523 1.99 0.0560 2.98 0.0166 3.98 0.0183 4.96 0.0005
   5.98 0.0066 6.99 0.0026 7.96 0.0011 8.95 0.0013 9.95 0.0026
   10.95 0.0019 11.96 0.0017 12.94 0.0005 13.92 0.0002 14.94 0.0006
   15.95 0.0007 16.94 0.0007 17.96 0.0002 18.92 0.0002 19.93 0.0002
   20.92 0.0002 21.94 0.0001 ) constant almf-gs3

'( 1.00 0.1590 2.00 0.0394 3.02 0.0076 3.99 0.0222 5.00 0.0063
   5.93 0.0008 6.97 0.0016 7.95 0.0002 8.94 0.0002 9.94 0.0003
   10.05 0.0002 10.15 0.0001 12.00 0.0005 12.12 0.0002 12.95 0.0001
   15.98 0.0002 ) constant almf-a3

'( 1.00 0.2533 2.00 0.0498 3.00 0.0178 3.99 0.0108 5.00 0.0245
   6.00 0.0112 6.99 0.0066 8.00 0.0010 8.98 0.0074 9.99 0.0042
   10.99 0.0025 12.00 0.0015 13.01 0.0006 14.00 0.0012 15.00 0.0004
   16.02 0.0004 17.00 0.0010 18.00 0.0005 18.99 0.0002 19.98 0.0002 ) constant almf-as3

'( 1.00 0.1639 2.00 0.0436 3.01 0.0584 4.01 0.0080 5.01 0.0117
   6.01 0.0208 7.02 0.0062 8.02 0.0035 9.03 0.0037 10.03 0.0022
   11.04 0.0023 12.04 0.0048 13.04 0.0022 14.04 0.0005 15.04 0.0007
   16.05 0.0012 17.05 0.0010 18.06 0.0005 19.05 0.0001 20.06 0.0005
   21.07 0.0002 24.07 0.0002 25.08 0.0002 27.08 0.0002 28.10 0.0001
   33.12 0.0001 ) constant almf-b3

'( 1.00 0.0931 2.00 0.0251 3.00 0.0077 4.00 0.0129 5.00 0.0115
   6.00 0.0055 7.00 0.0041 8.01 0.0046 9.00 0.0013 10.00 0.0067
   11.02 0.0011 12.02 0.0021 12.99 0.0002 14.01 0.0007 15.02 0.0008
   16.03 0.0007 17.02 0.0004 19.02 0.0003 20.05 0.0001 24.04 0.0001 ) constant almf-c4

'( 1.01 0.0587 2.01 0.0263 3.02 0.0299 4.03 0.0306 5.04 0.0172
   6.04 0.0097 7.05 0.0024 8.06 0.0034 9.06 0.0053 10.07 0.0065
   11.08 0.0025 12.09 0.0005 13.10 0.0016 14.11 0.0011 15.11 0.0009
   16.12 0.0004 17.13 0.0002 18.13 0.0003 21.15 0.0002 23.17 0.0001
   24.18 0.0001 25.19 0.0002 30.23 0.0001 32.25 0.0001 ) constant almf-cs4

'( 1.00 0.0619 2.00 0.0432 3.01 0.0479 4.01 0.0136 5.00 0.0220
   6.01 0.0064 7.02 0.0138 8.02 0.0033 9.02 0.0066 10.06 0.0006
   11.02 0.0019 12.01 0.0013 13.02 0.0008 14.01 0.0004 15.03 0.0007
   16.04 0.0003 17.03 0.0001 18.02 0.0001 21.04 0.0003 ) constant almf-d4

'( 1.00 0.0762 1.99 0.0071 2.99 0.0085 3.99 0.0120 4.98 0.0064
   5.98 0.0018 6.98 0.0039 7.99 0.0027 8.96 0.0017 9.95 0.0007
   10.98 0.0006 11.95 0.0003 12.98 0.0006 13.98 0.0007 15.97 0.0002
   19.96 0.0001 ) constant almf-ds4

'( 0.99 0.0726 1.99 0.0195 2.99 0.0147 3.98 0.0106 4.99 0.0069
   6.00 0.0026 6.99 0.0046 7.99 0.0105 8.97 0.0017 10.01 0.0007
   10.97 0.0022 11.99 0.0009 12.99 0.0011 13.98 0.0001 14.96 0.0002
   15.96 0.0001 16.99 0.0001 17.95 0.0002 18.98 0.0002 20.98 0.0001
   21.97 0.0001 ) constant almf-e4

'( 1.00 0.0772 2.00 0.0150 3.00 0.0166 4.01 0.0118 4.99 0.0024
   6.01 0.0067 7.03 0.0017 8.00 0.0012 9.02 0.0017 10.02 0.0011
   11.03 0.0008 12.04 0.0004 13.04 0.0007 14.03 0.0002 15.04 0.0002
   16.04 0.0001 ) constant almf-f4

'( 0.99 0.1309 1.99 0.0550 2.98 0.0321 3.98 0.0270 4.97 0.0070
   5.97 0.0099 6.96 0.0041 7.96 0.0033 8.95 0.0023 9.94 0.0017
   10.94 0.0023 11.93 0.0015 12.93 0.0006 13.95 0.0002 14.93 0.0002
   15.91 0.0002 16.91 0.0003 17.92 0.0001 18.90 0.0003 19.93 0.0001
   22.87 0.0001 23.88 0.0001 ) constant almf-fs4

'( 0.99 0.0515 2.00 0.0153 3.00 0.0281 4.00 0.0071 5.01 0.0020
   6.00 0.0045 7.02 0.0006 8.00 0.0054 8.99 0.0020 10.00 0.0031
   11.01 0.0023 12.02 0.0003 13.00 0.0004 14.01 0.0002 15.02 0.0003
   15.98 0.0002 16.02 0.0002 18.03 0.0002 19.01 0.0001 ) constant almf-g4

'( 1.00 0.0592 2.00 0.0287 3.00 0.0196 3.99 0.0175 4.99 0.0168
   6.00 0.0071 6.07 0.0008 7.00 0.0003 7.99 0.0019 8.98 0.0007
   9.98 0.0012 10.99 0.0012 11.98 0.0004 12.98 0.0003 13.99 0.0002
   14.96 0.0001 15.98 0.0001 16.97 0.0002 17.96 0.0002 ) constant almf-gs4

'( 1.01 0.0784 2.01 0.0480 3.02 0.0131 4.02 0.0074 5.03 0.0141
   6.03 0.0173 7.04 0.0070 8.04 0.0033 9.06 0.0154 9.12 0.0016
   10.07 0.0011 11.07 0.0013 12.07 0.0009 13.09 0.0008 14.07 0.0006
   15.09 0.0002 16.10 0.0005 17.10 0.0003 19.12 0.0001 23.14 0.0001 ) constant almf-a4

'( 1.00 0.0507 2.00 0.0304 3.00 0.0303 4.00 0.0084 5.00 0.0072
   6.00 0.0098 6.99 0.0058 8.01 0.0036 9.01 0.0023 10.00 0.0010
   11.00 0.0008 12.00 0.0007 12.97 0.0005 13.02 0.0004 14.00 0.0003
   14.99 0.0003 16.01 0.0001 17.01 0.0002 18.00 0.0001 20.01 0.0001 ) constant almf-as4

'( 1.00 0.0340 2.00 0.0113 3.01 0.0098 4.02 0.0033 5.03 0.0013
   6.05 0.0008 7.02 0.0007 8.07 0.0006 9.01 0.0001 ) constant almf-b4

'( 1.00 0.0384 2.00 0.0426 3.01 0.0092 4.02 0.0239 5.02 0.0184
   6.02 0.0031 7.03 0.0029 8.04 0.0016 8.10 0.0006 9.04 0.0005
   10.04 0.0003 11.05 0.0006 12.05 0.0007 13.06 0.0002 15.07 0.0002 ) constant almf-c5

'( 1.00 0.0159 2.00 0.0592 3.00 0.0390 4.00 0.0272 5.00 0.0121
   6.00 0.0032 7.01 0.0124 8.01 0.0055 9.00 0.0009 10.01 0.0016
   11.01 0.0007 12.01 0.0006 13.02 0.0020 14.02 0.0010 15.02 0.0007
   16.03 0.0004 17.03 0.0002 18.02 0.0001 19.03 0.0001 20.03 0.0003
   21.03 0.0002 22.03 0.0003 23.03 0.0002 ) constant almf-cs5

'( 1.01 0.0376 2.01 0.0409 3.02 0.0136 4.03 0.0016 5.05 0.0080
   6.05 0.0044 7.06 0.0036 8.07 0.0018 9.07 0.0007 10.08 0.0011
   11.09 0.0002 12.09 0.0004 13.12 0.0003 14.11 0.0001 16.15 0.0002
   17.16 0.0001 20.18 0.0001 ) constant almf-d5

'( 1.00 0.0391 2.01 0.0445 3.01 0.0188 4.02 0.0329 5.02 0.0185
   6.02 0.0311 7.03 0.0107 8.03 0.0032 9.03 0.0010 10.03 0.0009
   11.04 0.0019 12.04 0.0019 13.05 0.0005 14.06 0.0004 15.05 0.0007
   16.06 0.0002 17.07 0.0002 18.08 0.0002 19.07 0.0005 20.07 0.0003
   21.08 0.0001 ) constant almf-ds5

'( 1.00 0.0869 2.00 0.0181 3.01 0.0252 4.01 0.0520 5.01 0.0040
   6.02 0.0336 7.02 0.0108 8.03 0.0070 9.03 0.0023 10.03 0.0009
   11.03 0.0017 12.02 0.0004 13.04 0.0012 14.04 0.0006 15.05 0.0016
   16.06 0.0007 17.06 0.0003 18.06 0.0012 19.07 0.0001 20.06 0.0001 ) constant almf-e5

'( 1.01 0.0905 2.02 0.0649 3.02 0.0406 4.03 0.0295 5.04 0.0038
   6.05 0.0088 7.06 0.0009 8.07 0.0021 9.07 0.0037 10.09 0.0022
   11.09 0.0014 12.09 0.0018 13.11 0.0006 14.12 0.0009 15.13 0.0004
   16.12 0.0003 17.14 0.0006 18.15 0.0002 ) constant almf-f5

'( 0.99 0.0868 1.98 0.0447 2.98 0.0303 3.97 0.0092 4.96 0.0183
   5.95 0.0121 6.94 0.0033 7.95 0.0010 8.92 0.0022 9.92 0.0007
   10.91 0.0007 11.90 0.0007 12.89 0.0014 13.87 0.0004 14.88 0.0006
   14.91 0.0003 15.87 0.0002 16.85 0.0003 ) constant almf-fs5

'( 1.00 0.0467 2.00 0.0739 3.00 0.0255 4.00 0.0277 5.00 0.0349
   6.00 0.0119 7.00 0.0024 8.00 0.0085 9.00 0.0016 9.99 0.0012
   11.00 0.0004 11.99 0.0014 12.99 0.0024 13.99 0.0017 14.99 0.0007
   15.99 0.0004 16.98 0.0001 ) constant almf-g5

'( 0.99 0.0605 1.99 0.0384 2.98 0.0154 3.98 0.0036 4.97 0.0164
   5.96 0.0039 6.96 0.0036 7.95 0.0040 8.94 0.0012 9.94 0.0006
   10.93 0.0015 11.93 0.0012 12.93 0.0008 13.91 0.0010 14.90 0.0005
   15.91 0.0001 ) constant almf-gs5

'( 1.00 0.1051 2.01 0.0322 3.02 0.0393 4.03 0.0112 5.03 0.0099
   6.04 0.0074 7.05 0.0054 8.05 0.0030 9.06 0.0019 10.07 0.0006
   11.07 0.0023 12.08 0.0004 13.08 0.0005 14.09 0.0006 14.11 0.0001
   15.11 0.0001 ) constant almf-a5

'( 1.00 0.0284 2.01 0.0161 3.02 0.0248 4.03 0.0414 5.03 0.0135
   6.04 0.0028 7.05 0.0021 8.06 0.0006 9.07 0.0009 10.07 0.0010
   11.08 0.0012 12.10 0.0003 13.09 0.0010 14.10 0.0003 ) constant almf-as5

'( 0.99 0.0354 1.98 0.0173 2.97 0.0086 3.96 0.0204 3.99 0.0077
   4.03 0.0067 4.06 0.0037 4.95 0.0034 5.93 0.0030 5.96 0.0015
   5.98 0.0009 6.92 0.0007 7.92 0.0008 8.91 0.0017 9.90 0.0008
   9.93 0.0006 10.88 0.0003 11.91 0.0003 12.86 0.0004 12.90 0.0002 ) constant almf-b5

'( 1.01 0.0675 2.01 0.0578 3.02 0.0346 4.03 0.0170 5.03 0.0082
   6.04 0.0050 7.06 0.0032 8.03 0.0009 9.06 0.0009 10.07 0.0008
   11.09 0.0010 12.03 0.0002 ) constant almf-c6

'( 1.00 0.0896 1.99 0.0634 3.01 0.0037 3.98 0.0105 4.98 0.0030
   5.98 0.0019 6.97 0.0020 7.97 0.0014 8.00 0.0007 8.99 0.0005
   9.96 0.0005 10.95 0.0008 10.98 0.0005 11.00 0.0003 11.02 0.0003
   11.03 0.0002 11.06 0.0002 11.95 0.0001 11.98 0.0001 ) constant almf-cs6

'( 1.00 0.0593 2.00 0.0364 3.01 0.0142 4.01 0.0065 5.02 0.0063
   6.01 0.0024 7.02 0.0010 8.02 0.0019 9.02 0.0015 10.03 0.0007
   11.02 0.0002 ) constant almf-d6

'( 1.00 0.0410 1.99 0.0353 2.99 0.0291 3.99 0.0089 4.99 0.0066
   5.98 0.0023 6.99 0.0012 7.96 0.0011 7.99 0.0006 8.94 0.0004
   8.98 0.0003 9.95 0.0001 ) constant almf-ds6

'( 1.01 0.0254 2.01 0.0252 3.02 0.0365 4.03 0.0034 5.02 0.0013
   6.02 0.0010 7.08 0.0006 8.02 0.0010 9.03 0.0007 9.12 0.0004 ) constant almf-e6

'( 1.00 0.1896 2.00 0.0411 3.00 0.0216 4.00 0.0019 5.00 0.0032
   6.01 0.0012 7.02 0.0007 7.99 0.0026 9.00 0.0003 9.03 0.0002 ) constant almf-f6

'( 1.01 0.0285 2.01 0.0189 3.02 0.0213 4.02 0.0033 5.03 0.0024
   6.03 0.0010 7.04 0.0016 8.05 0.0015 9.05 0.0003 9.06 0.0002 ) constant almf-fs6

'( 1.00 0.1939 2.00 0.0339 3.00 0.0219 4.01 0.0079 5.01 0.0025
   6.01 0.0017 7.01 0.0014 7.95 0.0009 8.00 0.0006 8.02 0.0003 ) constant almf-g6

'( 1.00 0.1069 2.00 0.0146 3.00 0.0220 4.00 0.0046 5.00 0.0020
   6.00 0.0027 6.99 0.0011 8.00 0.0003 ) constant almf-gs6

'( 1.00 0.0952 1.99 0.0201 3.00 0.0015 3.99 0.0064 4.98 0.0021
   5.97 0.0009 6.98 0.0010 ) constant almf-a6

'( 1.00 0.0132 1.99 0.0635 2.99 0.0057 3.98 0.0054 3.99 0.0034
   4.99 0.0011 5.96 0.0012 5.98 0.0008 5.99 0.0007 6.96 0.0004
   6.98 0.0004 ) constant almf-as6

'( 1.00 0.0241 2.01 0.0417 3.02 0.0098 3.99 0.0016 4.02 0.0016
   5.03 0.0016 6.04 0.0012 ) constant almf-b6

\ spectr.fs ends here
