# rgb.rb -- Guile -> Ruby translation

# Translator/Author: Michael Scholz <scholz-micha@gmx.de>
# Last: Fri Mar 04 15:02:19 CET 2005

# X11 color names converted to Snd (Ruby) colors
# tan -> tawny 24-Aug-01

# e.g. set_colormap(Jet_colormap)
Black_and_white_colormap = 0
Gray_colormap = 1
Hot_colormap = 2
Cool_colormap = 3
Bone_colormap = 4
Copper_colormap = 5
Pink_colormap = 6
Jet_colormap = 7
Prism_colormap = 8
Autumn_colormap = 9
Winter_colormap = 10
Spring_colormap = 11
Summer_colormap = 12
Rainbow_colormap = 13
Flag_colormap = 14
Phases_colormap = 15
Last_colormap = 16

# rgb.scm
Snow = make_color(1.00, 0.98, 0.98)
Ghost_white = make_color(0.97, 0.97, 1.00)
White_smoke = make_color(0.96, 0.96, 0.96)
Gainsboro = make_color(0.86, 0.86, 0.86)
Floral_white = make_color(1.00, 0.98, 0.94)
Old_lace = make_color(0.99, 0.96, 0.90)
Linen = make_color(0.98, 0.94, 0.90)
Antique_white = make_color(0.98, 0.92, 0.84)
Papaya_whip = make_color(1.00, 0.93, 0.83)
Blanched_almond = make_color(1.00, 0.92, 0.80)
Bisque = make_color(1.00, 0.89, 0.77)
Peach_puff = make_color(1.00, 0.85, 0.72)
Navajo_white = make_color(1.00, 0.87, 0.68)
Moccasin = make_color(1.00, 0.89, 0.71)
Cornsilk = make_color(1.00, 0.97, 0.86)
Ivory = make_color(1.00, 1.00, 0.94)
Lemon_chiffon = make_color(1.00, 0.98, 0.80)
Seashell = make_color(1.00, 0.96, 0.93)
Honeydew = make_color(0.94, 1.00, 0.94)
Mint_cream = make_color(0.96, 1.00, 0.98)
Azure = make_color(0.94, 1.00, 1.00)
Alice_blue = make_color(0.94, 0.97, 1.00)
Lavender = make_color(0.90, 0.90, 0.98)
Lavender_blush = make_color(1.00, 0.94, 0.96)
Misty_rose = make_color(1.00, 0.89, 0.88)
White = make_color(1.00, 1.00, 1.00)
Black = make_color(0.00, 0.00, 0.00)
Dark_slate_gray = make_color(0.18, 0.31, 0.31)
Dark_slate_grey = make_color(0.18, 0.31, 0.31)
Dim_gray = make_color(0.41, 0.41, 0.41)
Dim_grey = make_color(0.41, 0.41, 0.41)
Slate_gray = make_color(0.44, 0.50, 0.56)
Slate_grey = make_color(0.44, 0.50, 0.56)
Light_slate_gray = make_color(0.46, 0.53, 0.60)
Light_slate_grey = make_color(0.46, 0.53, 0.60)
Gray = make_color(0.74, 0.74, 0.74)
Grey = make_color(0.74, 0.74, 0.74)
Light_grey = make_color(0.82, 0.82, 0.82)
Light_gray = make_color(0.82, 0.82, 0.82)
Midnight_blue = make_color(0.10, 0.10, 0.44)
Navy = make_color(0.00, 0.00, 0.50)
Navy_blue = make_color(0.00, 0.00, 0.50)
Cornflower_blue = make_color(0.39, 0.58, 0.93)
Dark_slate_blue = make_color(0.28, 0.24, 0.54)
Slate_blue = make_color(0.41, 0.35, 0.80)
Medium_slate_blue = make_color(0.48, 0.41, 0.93)
Light_slate_blue = make_color(0.52, 0.44, 1.00)
Medium_blue = make_color(0.00, 0.00, 0.80)
Royal_blue = make_color(0.25, 0.41, 0.88)
Blue = make_color(0.00, 0.00, 1.00)
Dodger_blue = make_color(0.12, 0.56, 1.00)
Deep_sky_blue = make_color(0.00, 0.75, 1.00)
Sky_blue = make_color(0.53, 0.80, 0.92)
Light_sky_blue = make_color(0.53, 0.80, 0.98)
Steel_blue = make_color(0.27, 0.51, 0.70)
Light_steel_blue = make_color(0.69, 0.77, 0.87)
Light_blue = make_color(0.68, 0.84, 0.90)
Powder_blue = make_color(0.69, 0.87, 0.90)
Pale_turquoise = make_color(0.68, 0.93, 0.93)
Dark_turquoise = make_color(0.00, 0.80, 0.82)
Medium_turquoise = make_color(0.28, 0.82, 0.80)
Turquoise = make_color(0.25, 0.87, 0.81)
Cyan = make_color(0.00, 1.00, 1.00)
Light_cyan = make_color(0.87, 1.00, 1.00)
Cadet_blue = make_color(0.37, 0.62, 0.62)
Medium_aquamarine = make_color(0.40, 0.80, 0.66)
Aquamarine = make_color(0.50, 1.00, 0.83)
Dark_green = make_color(0.00, 0.39, 0.00)
Dark_olive_green = make_color(0.33, 0.42, 0.18)
Dark_sea_green = make_color(0.56, 0.73, 0.56)
Sea_green = make_color(0.18, 0.54, 0.34)
Medium_sea_green = make_color(0.23, 0.70, 0.44)
Light_sea_green = make_color(0.12, 0.70, 0.66)
Pale_green = make_color(0.59, 0.98, 0.59)
Spring_green = make_color(0.00, 1.00, 0.50)
Lawn_green = make_color(0.48, 0.98, 0.00)
Green = make_color(0.00, 1.00, 0.00)
Chartreuse = make_color(0.50, 1.00, 0.00)
Medium_spring_green = make_color(0.00, 0.98, 0.60)
Green_yellow = make_color(0.68, 1.00, 0.18)
Lime_green = make_color(0.20, 0.80, 0.20)
Yellow_green = make_color(0.60, 0.80, 0.20)
Forest_green = make_color(0.13, 0.54, 0.13)
Olive_drab = make_color(0.42, 0.55, 0.14)
Dark_khaki = make_color(0.74, 0.71, 0.42)
Khaki = make_color(0.94, 0.90, 0.55)
Pale_goldenrod = make_color(0.93, 0.91, 0.66)
Light_goldenrod_yellow = make_color(0.98, 0.98, 0.82)
Light_yellow = make_color(1.00, 1.00, 0.87)
Yellow = make_color(1.00, 1.00, 0.00)
Gold = make_color(1.00, 0.84, 0.00)
Light_goldenrod = make_color(0.93, 0.86, 0.51)
Goldenrod = make_color(0.85, 0.64, 0.12)
Dark_goldenrod = make_color(0.72, 0.52, 0.04)
Rosy_brown = make_color(0.73, 0.56, 0.56)
Indian_red = make_color(0.80, 0.36, 0.36)
Saddle_brown = make_color(0.54, 0.27, 0.07)
Sienna = make_color(0.62, 0.32, 0.18)
Peru = make_color(0.80, 0.52, 0.25)
Burlywood = make_color(0.87, 0.72, 0.53)
Beige = make_color(0.96, 0.96, 0.86)
Wheat = make_color(0.96, 0.87, 0.70)
Sandy_brown = make_color(0.95, 0.64, 0.37)
# tan collides with Scheme built-in -- tawny suggested by Dave Phillips
Tawny = make_color(0.82, 0.70, 0.55)
Chocolate = make_color(0.82, 0.41, 0.12)
Firebrick = make_color(0.70, 0.13, 0.13)
Brown = make_color(0.64, 0.16, 0.16)
Dark_salmon = make_color(0.91, 0.59, 0.48)
Salmon = make_color(0.98, 0.50, 0.45)
Light_salmon = make_color(1.00, 0.62, 0.48)
Orange = make_color(1.00, 0.64, 0.00)
Dark_orange = make_color(1.00, 0.55, 0.00)
Coral = make_color(1.00, 0.50, 0.31)
Light_coral = make_color(0.94, 0.50, 0.50)
Tomato = make_color(1.00, 0.39, 0.28)
Orange_red = make_color(1.00, 0.27, 0.00)
Red = make_color(1.00, 0.00, 0.00)
Hot_pink = make_color(1.00, 0.41, 0.70)
Deep_pink = make_color(1.00, 0.08, 0.57)
Pink = make_color(1.00, 0.75, 0.79)
Light_pink = make_color(1.00, 0.71, 0.75)
Pale_violet_red = make_color(0.86, 0.44, 0.57)
Maroon = make_color(0.69, 0.19, 0.37)
Medium_violet_red = make_color(0.78, 0.08, 0.52)
Violet_red = make_color(0.81, 0.12, 0.56)
Magenta = make_color(1.00, 0.00, 1.00)
Violet = make_color(0.93, 0.51, 0.93)
Plum = make_color(0.86, 0.62, 0.86)
Orchid = make_color(0.85, 0.44, 0.84)
Medium_orchid = make_color(0.73, 0.33, 0.82)
Dark_orchid = make_color(0.60, 0.20, 0.80)
Dark_violet = make_color(0.58, 0.00, 0.82)
Blue_violet = make_color(0.54, 0.17, 0.88)
Purple = make_color(0.62, 0.12, 0.94)
Medium_purple = make_color(0.57, 0.44, 0.86)
Thistle = make_color(0.84, 0.75, 0.84)
Snow1 = make_color(1.00, 0.98, 0.98)
Snow2 = make_color(0.93, 0.91, 0.91)
Snow3 = make_color(0.80, 0.79, 0.79)
Snow4 = make_color(0.54, 0.54, 0.54)
Seashell1 = make_color(1.00, 0.96, 0.93)
Seashell2 = make_color(0.93, 0.89, 0.87)
Seashell3 = make_color(0.80, 0.77, 0.75)
Seashell4 = make_color(0.54, 0.52, 0.51)
Antiquewhite1 = make_color(1.00, 0.93, 0.86)
Antiquewhite2 = make_color(0.93, 0.87, 0.80)
Antiquewhite3 = make_color(0.80, 0.75, 0.69)
Antiquewhite4 = make_color(0.54, 0.51, 0.47)
Bisque1 = make_color(1.00, 0.89, 0.77)
Bisque2 = make_color(0.93, 0.83, 0.71)
Bisque3 = make_color(0.80, 0.71, 0.62)
Bisque4 = make_color(0.54, 0.49, 0.42)
Peachpuff1 = make_color(1.00, 0.85, 0.72)
Peachpuff2 = make_color(0.93, 0.79, 0.68)
Peachpuff3 = make_color(0.80, 0.68, 0.58)
Peachpuff4 = make_color(0.54, 0.46, 0.39)
Navajowhite1 = make_color(1.00, 0.87, 0.68)
Navajowhite2 = make_color(0.93, 0.81, 0.63)
Navajowhite3 = make_color(0.80, 0.70, 0.54)
Navajowhite4 = make_color(0.54, 0.47, 0.37)
Lemonchiffon1 = make_color(1.00, 0.98, 0.80)
Lemonchiffon2 = make_color(0.93, 0.91, 0.75)
Lemonchiffon3 = make_color(0.80, 0.79, 0.64)
Lemonchiffon4 = make_color(0.54, 0.54, 0.44)
Cornsilk1 = make_color(1.00, 0.97, 0.86)
Cornsilk2 = make_color(0.93, 0.91, 0.80)
Cornsilk3 = make_color(0.80, 0.78, 0.69)
Cornsilk4 = make_color(0.54, 0.53, 0.47)
Ivory1 = make_color(1.00, 1.00, 0.94)
Ivory2 = make_color(0.93, 0.93, 0.87)
Ivory3 = make_color(0.80, 0.80, 0.75)
Ivory4 = make_color(0.54, 0.54, 0.51)
Honeydew1 = make_color(0.94, 1.00, 0.94)
Honeydew2 = make_color(0.87, 0.93, 0.87)
Honeydew3 = make_color(0.75, 0.80, 0.75)
Honeydew4 = make_color(0.51, 0.54, 0.51)
Lavenderblush1 = make_color(1.00, 0.94, 0.96)
Lavenderblush2 = make_color(0.93, 0.87, 0.89)
Lavenderblush3 = make_color(0.80, 0.75, 0.77)
Lavenderblush4 = make_color(0.54, 0.51, 0.52)
Mistyrose1 = make_color(1.00, 0.89, 0.88)
Mistyrose2 = make_color(0.93, 0.83, 0.82)
Mistyrose3 = make_color(0.80, 0.71, 0.71)
Mistyrose4 = make_color(0.54, 0.49, 0.48)
Azure1 = make_color(0.94, 1.00, 1.00)
Azure2 = make_color(0.87, 0.93, 0.93)
Azure3 = make_color(0.75, 0.80, 0.80)
Azure4 = make_color(0.51, 0.54, 0.54)
Slateblue1 = make_color(0.51, 0.43, 1.00)
Slateblue2 = make_color(0.48, 0.40, 0.93)
Slateblue3 = make_color(0.41, 0.35, 0.80)
Slateblue4 = make_color(0.28, 0.23, 0.54)
Royalblue1 = make_color(0.28, 0.46, 1.00)
Royalblue2 = make_color(0.26, 0.43, 0.93)
Royalblue3 = make_color(0.23, 0.37, 0.80)
Royalblue4 = make_color(0.15, 0.25, 0.54)
Blue1 = make_color(0.00, 0.00, 1.00)
Blue2 = make_color(0.00, 0.00, 0.93)
Blue3 = make_color(0.00, 0.00, 0.80)
Blue4 = make_color(0.00, 0.00, 0.54)
Dodgerblue1 = make_color(0.12, 0.56, 1.00)
Dodgerblue2 = make_color(0.11, 0.52, 0.93)
Dodgerblue3 = make_color(0.09, 0.45, 0.80)
Dodgerblue4 = make_color(0.06, 0.30, 0.54)
Steelblue1 = make_color(0.39, 0.72, 1.00)
Steelblue2 = make_color(0.36, 0.67, 0.93)
Steelblue3 = make_color(0.31, 0.58, 0.80)
Steelblue4 = make_color(0.21, 0.39, 0.54)
Deepskyblue1 = make_color(0.00, 0.75, 1.00)
Deepskyblue2 = make_color(0.00, 0.70, 0.93)
Deepskyblue3 = make_color(0.00, 0.60, 0.80)
Deepskyblue4 = make_color(0.00, 0.41, 0.54)
Skyblue1 = make_color(0.53, 0.80, 1.00)
Skyblue2 = make_color(0.49, 0.75, 0.93)
Skyblue3 = make_color(0.42, 0.65, 0.80)
Skyblue4 = make_color(0.29, 0.44, 0.54)
Lightskyblue1 = make_color(0.69, 0.88, 1.00)
Lightskyblue2 = make_color(0.64, 0.82, 0.93)
Lightskyblue3 = make_color(0.55, 0.71, 0.80)
Lightskyblue4 = make_color(0.37, 0.48, 0.54)
Slategray1 = make_color(0.77, 0.88, 1.00)
Slategray2 = make_color(0.72, 0.82, 0.93)
Slategray3 = make_color(0.62, 0.71, 0.80)
Slategray4 = make_color(0.42, 0.48, 0.54)
Lightsteelblue1 = make_color(0.79, 0.88, 1.00)
Lightsteelblue2 = make_color(0.73, 0.82, 0.93)
Lightsteelblue3 = make_color(0.63, 0.71, 0.80)
Lightsteelblue4 = make_color(0.43, 0.48, 0.54)
Lightblue1 = make_color(0.75, 0.93, 1.00)
Lightblue2 = make_color(0.70, 0.87, 0.93)
Lightblue3 = make_color(0.60, 0.75, 0.80)
Lightblue4 = make_color(0.41, 0.51, 0.54)
Lightcyan1 = make_color(0.87, 1.00, 1.00)
Lightcyan2 = make_color(0.82, 0.93, 0.93)
Lightcyan3 = make_color(0.70, 0.80, 0.80)
Lightcyan4 = make_color(0.48, 0.54, 0.54)
Paleturquoise1 = make_color(0.73, 1.00, 1.00)
Paleturquoise2 = make_color(0.68, 0.93, 0.93)
Paleturquoise3 = make_color(0.59, 0.80, 0.80)
Paleturquoise4 = make_color(0.40, 0.54, 0.54)
Cadetblue1 = make_color(0.59, 0.96, 1.00)
Cadetblue2 = make_color(0.55, 0.89, 0.93)
Cadetblue3 = make_color(0.48, 0.77, 0.80)
Cadetblue4 = make_color(0.32, 0.52, 0.54)
Turquoise1 = make_color(0.00, 0.96, 1.00)
Turquoise2 = make_color(0.00, 0.89, 0.93)
Turquoise3 = make_color(0.00, 0.77, 0.80)
Turquoise4 = make_color(0.00, 0.52, 0.54)
Cyan1 = make_color(0.00, 1.00, 1.00)
Cyan2 = make_color(0.00, 0.93, 0.93)
Cyan3 = make_color(0.00, 0.80, 0.80)
Cyan4 = make_color(0.00, 0.54, 0.54)
Darkslategray1 = make_color(0.59, 1.00, 1.00)
Darkslategray2 = make_color(0.55, 0.93, 0.93)
Darkslategray3 = make_color(0.47, 0.80, 0.80)
Darkslategray4 = make_color(0.32, 0.54, 0.54)
Aquamarine1 = make_color(0.50, 1.00, 0.83)
Aquamarine2 = make_color(0.46, 0.93, 0.77)
Aquamarine3 = make_color(0.40, 0.80, 0.66)
Aquamarine4 = make_color(0.27, 0.54, 0.45)
Darkseagreen1 = make_color(0.75, 1.00, 0.75)
Darkseagreen2 = make_color(0.70, 0.93, 0.70)
Darkseagreen3 = make_color(0.61, 0.80, 0.61)
Darkseagreen4 = make_color(0.41, 0.54, 0.41)
Seagreen1 = make_color(0.33, 1.00, 0.62)
Seagreen2 = make_color(0.30, 0.93, 0.58)
Seagreen3 = make_color(0.26, 0.80, 0.50)
Seagreen4 = make_color(0.18, 0.54, 0.34)
Palegreen1 = make_color(0.60, 1.00, 0.60)
Palegreen2 = make_color(0.56, 0.93, 0.56)
Palegreen3 = make_color(0.48, 0.80, 0.48)
Palegreen4 = make_color(0.33, 0.54, 0.33)
Springgreen1 = make_color(0.00, 1.00, 0.50)
Springgreen2 = make_color(0.00, 0.93, 0.46)
Springgreen3 = make_color(0.00, 0.80, 0.40)
Springgreen4 = make_color(0.00, 0.54, 0.27)
Green1 = make_color(0.00, 1.00, 0.00)
Green2 = make_color(0.00, 0.93, 0.00)
Green3 = make_color(0.00, 0.80, 0.00)
Green4 = make_color(0.00, 0.54, 0.00)
Chartreuse1 = make_color(0.50, 1.00, 0.00)
Chartreuse2 = make_color(0.46, 0.93, 0.00)
Chartreuse3 = make_color(0.40, 0.80, 0.00)
Chartreuse4 = make_color(0.27, 0.54, 0.00)
Olivedrab1 = make_color(0.75, 1.00, 0.24)
Olivedrab2 = make_color(0.70, 0.93, 0.23)
Olivedrab3 = make_color(0.60, 0.80, 0.20)
Olivedrab4 = make_color(0.41, 0.54, 0.13)
Darkolivegreen1 = make_color(0.79, 1.00, 0.44)
Darkolivegreen2 = make_color(0.73, 0.93, 0.41)
Darkolivegreen3 = make_color(0.63, 0.80, 0.35)
Darkolivegreen4 = make_color(0.43, 0.54, 0.24)
Khaki1 = make_color(1.00, 0.96, 0.56)
Khaki2 = make_color(0.93, 0.90, 0.52)
Khaki3 = make_color(0.80, 0.77, 0.45)
Khaki4 = make_color(0.54, 0.52, 0.30)
Lightgoldenrod1 = make_color(1.00, 0.92, 0.54)
Lightgoldenrod2 = make_color(0.93, 0.86, 0.51)
Lightgoldenrod3 = make_color(0.80, 0.74, 0.44)
Lightgoldenrod4 = make_color(0.54, 0.50, 0.30)
Lightyellow1 = make_color(1.00, 1.00, 0.87)
Lightyellow2 = make_color(0.93, 0.93, 0.82)
Lightyellow3 = make_color(0.80, 0.80, 0.70)
Lightyellow4 = make_color(0.54, 0.54, 0.48)
Yellow1 = make_color(1.00, 1.00, 0.00)
Yellow2 = make_color(0.93, 0.93, 0.00)
Yellow3 = make_color(0.80, 0.80, 0.00)
Yellow4 = make_color(0.54, 0.54, 0.00)
Gold1 = make_color(1.00, 0.84, 0.00)
Gold2 = make_color(0.93, 0.79, 0.00)
Gold3 = make_color(0.80, 0.68, 0.00)
Gold4 = make_color(0.54, 0.46, 0.00)
Goldenrod1 = make_color(1.00, 0.75, 0.14)
Goldenrod2 = make_color(0.93, 0.70, 0.13)
Goldenrod3 = make_color(0.80, 0.61, 0.11)
Goldenrod4 = make_color(0.54, 0.41, 0.08)
Darkgoldenrod1 = make_color(1.00, 0.72, 0.06)
Darkgoldenrod2 = make_color(0.93, 0.68, 0.05)
Darkgoldenrod3 = make_color(0.80, 0.58, 0.05)
Darkgoldenrod4 = make_color(0.54, 0.39, 0.03)
Rosybrown1 = make_color(1.00, 0.75, 0.75)
Rosybrown2 = make_color(0.93, 0.70, 0.70)
Rosybrown3 = make_color(0.80, 0.61, 0.61)
Rosybrown4 = make_color(0.54, 0.41, 0.41)
Indianred1 = make_color(1.00, 0.41, 0.41)
Indianred2 = make_color(0.93, 0.39, 0.39)
Indianred3 = make_color(0.80, 0.33, 0.33)
Indianred4 = make_color(0.54, 0.23, 0.23)
Sienna1 = make_color(1.00, 0.51, 0.28)
Sienna2 = make_color(0.93, 0.47, 0.26)
Sienna3 = make_color(0.80, 0.41, 0.22)
Sienna4 = make_color(0.54, 0.28, 0.15)
Burlywood1 = make_color(1.00, 0.82, 0.61)
Burlywood2 = make_color(0.93, 0.77, 0.57)
Burlywood3 = make_color(0.80, 0.66, 0.49)
Burlywood4 = make_color(0.54, 0.45, 0.33)
Wheat1 = make_color(1.00, 0.90, 0.73)
Wheat2 = make_color(0.93, 0.84, 0.68)
Wheat3 = make_color(0.80, 0.73, 0.59)
Wheat4 = make_color(0.54, 0.49, 0.40)
Tan1 = make_color(1.00, 0.64, 0.31)
Tan2 = make_color(0.93, 0.60, 0.29)
Tan3 = make_color(0.80, 0.52, 0.25)
Tan4 = make_color(0.54, 0.35, 0.17)
Chocolate1 = make_color(1.00, 0.50, 0.14)
Chocolate2 = make_color(0.93, 0.46, 0.13)
Chocolate3 = make_color(0.80, 0.40, 0.11)
Chocolate4 = make_color(0.54, 0.27, 0.07)
Firebrick1 = make_color(1.00, 0.19, 0.19)
Firebrick2 = make_color(0.93, 0.17, 0.17)
Firebrick3 = make_color(0.80, 0.15, 0.15)
Firebrick4 = make_color(0.54, 0.10, 0.10)
Brown1 = make_color(1.00, 0.25, 0.25)
Brown2 = make_color(0.93, 0.23, 0.23)
Brown3 = make_color(0.80, 0.20, 0.20)
Brown4 = make_color(0.54, 0.14, 0.14)
Salmon1 = make_color(1.00, 0.55, 0.41)
Salmon2 = make_color(0.93, 0.51, 0.38)
Salmon3 = make_color(0.80, 0.44, 0.33)
Salmon4 = make_color(0.54, 0.30, 0.22)
Lightsalmon1 = make_color(1.00, 0.62, 0.48)
Lightsalmon2 = make_color(0.93, 0.58, 0.45)
Lightsalmon3 = make_color(0.80, 0.50, 0.38)
Lightsalmon4 = make_color(0.54, 0.34, 0.26)
Orange1 = make_color(1.00, 0.64, 0.00)
Orange2 = make_color(0.93, 0.60, 0.00)
Orange3 = make_color(0.80, 0.52, 0.00)
Orange4 = make_color(0.54, 0.35, 0.00)
Darkorange1 = make_color(1.00, 0.50, 0.00)
Darkorange2 = make_color(0.93, 0.46, 0.00)
Darkorange3 = make_color(0.80, 0.40, 0.00)
Darkorange4 = make_color(0.54, 0.27, 0.00)
Coral1 = make_color(1.00, 0.45, 0.34)
Coral2 = make_color(0.93, 0.41, 0.31)
Coral3 = make_color(0.80, 0.36, 0.27)
Coral4 = make_color(0.54, 0.24, 0.18)
Tomato1 = make_color(1.00, 0.39, 0.28)
Tomato2 = make_color(0.93, 0.36, 0.26)
Tomato3 = make_color(0.80, 0.31, 0.22)
Tomato4 = make_color(0.54, 0.21, 0.15)
Orangered1 = make_color(1.00, 0.27, 0.00)
Orangered2 = make_color(0.93, 0.25, 0.00)
Orangered3 = make_color(0.80, 0.21, 0.00)
Orangered4 = make_color(0.54, 0.14, 0.00)
Red1 = make_color(1.00, 0.00, 0.00)
Red2 = make_color(0.93, 0.00, 0.00)
Red3 = make_color(0.80, 0.00, 0.00)
Red4 = make_color(0.54, 0.00, 0.00)
Deeppink1 = make_color(1.00, 0.08, 0.57)
Deeppink2 = make_color(0.93, 0.07, 0.54)
Deeppink3 = make_color(0.80, 0.06, 0.46)
Deeppink4 = make_color(0.54, 0.04, 0.31)
Hotpink1 = make_color(1.00, 0.43, 0.70)
Hotpink2 = make_color(0.93, 0.41, 0.65)
Hotpink3 = make_color(0.80, 0.37, 0.56)
Hotpink4 = make_color(0.54, 0.23, 0.38)
Pink1 = make_color(1.00, 0.71, 0.77)
Pink2 = make_color(0.93, 0.66, 0.72)
Pink3 = make_color(0.80, 0.57, 0.62)
Pink4 = make_color(0.54, 0.39, 0.42)
Lightpink1 = make_color(1.00, 0.68, 0.72)
Lightpink2 = make_color(0.93, 0.63, 0.68)
Lightpink3 = make_color(0.80, 0.55, 0.58)
Lightpink4 = make_color(0.54, 0.37, 0.39)
Palevioletred1 = make_color(1.00, 0.51, 0.67)
Palevioletred2 = make_color(0.93, 0.47, 0.62)
Palevioletred3 = make_color(0.80, 0.41, 0.54)
Palevioletred4 = make_color(0.54, 0.28, 0.36)
Maroon1 = make_color(1.00, 0.20, 0.70)
Maroon2 = make_color(0.93, 0.19, 0.65)
Maroon3 = make_color(0.80, 0.16, 0.56)
Maroon4 = make_color(0.54, 0.11, 0.38)
Violetred1 = make_color(1.00, 0.24, 0.59)
Violetred2 = make_color(0.93, 0.23, 0.55)
Violetred3 = make_color(0.80, 0.20, 0.47)
Violetred4 = make_color(0.54, 0.13, 0.32)
Magenta1 = make_color(1.00, 0.00, 1.00)
Magenta2 = make_color(0.93, 0.00, 0.93)
Magenta3 = make_color(0.80, 0.00, 0.80)
Magenta4 = make_color(0.54, 0.00, 0.54)
Orchid1 = make_color(1.00, 0.51, 0.98)
Orchid2 = make_color(0.93, 0.48, 0.91)
Orchid3 = make_color(0.80, 0.41, 0.79)
Orchid4 = make_color(0.54, 0.28, 0.54)
Plum1 = make_color(1.00, 0.73, 1.00)
Plum2 = make_color(0.93, 0.68, 0.93)
Plum3 = make_color(0.80, 0.59, 0.80)
Plum4 = make_color(0.54, 0.40, 0.54)
Mediumorchid1 = make_color(0.87, 0.40, 1.00)
Mediumorchid2 = make_color(0.82, 0.37, 0.93)
Mediumorchid3 = make_color(0.70, 0.32, 0.80)
Mediumorchid4 = make_color(0.48, 0.21, 0.54)
Darkorchid1 = make_color(0.75, 0.24, 1.00)
Darkorchid2 = make_color(0.70, 0.23, 0.93)
Darkorchid3 = make_color(0.60, 0.20, 0.80)
Darkorchid4 = make_color(0.41, 0.13, 0.54)
Purple1 = make_color(0.61, 0.19, 1.00)
Purple2 = make_color(0.57, 0.17, 0.93)
Purple3 = make_color(0.49, 0.15, 0.80)
Purple4 = make_color(0.33, 0.10, 0.54)
Mediumpurple1 = make_color(0.67, 0.51, 1.00)
Mediumpurple2 = make_color(0.62, 0.47, 0.93)
Mediumpurple3 = make_color(0.54, 0.41, 0.80)
Mediumpurple4 = make_color(0.36, 0.28, 0.54)
Thistle1 = make_color(1.00, 0.88, 1.00)
Thistle2 = make_color(0.93, 0.82, 0.93)
Thistle3 = make_color(0.80, 0.71, 0.80)
Thistle4 = make_color(0.54, 0.48, 0.54)
Gray0 = make_color(0.00, 0.00, 0.00)
Grey0 = make_color(0.00, 0.00, 0.00)
Gray1 = make_color(0.01, 0.01, 0.01)
Grey1 = make_color(0.01, 0.01, 0.01)
Gray2 = make_color(0.02, 0.02, 0.02)
Grey2 = make_color(0.02, 0.02, 0.02)
Gray3 = make_color(0.03, 0.03, 0.03)
Grey3 = make_color(0.03, 0.03, 0.03)
Gray4 = make_color(0.04, 0.04, 0.04)
Grey4 = make_color(0.04, 0.04, 0.04)
Gray5 = make_color(0.05, 0.05, 0.05)
Grey5 = make_color(0.05, 0.05, 0.05)
Gray6 = make_color(0.06, 0.06, 0.06)
Grey6 = make_color(0.06, 0.06, 0.06)
Gray7 = make_color(0.07, 0.07, 0.07)
Grey7 = make_color(0.07, 0.07, 0.07)
Gray8 = make_color(0.08, 0.08, 0.08)
Grey8 = make_color(0.08, 0.08, 0.08)
Gray9 = make_color(0.09, 0.09, 0.09)
Grey9 = make_color(0.09, 0.09, 0.09)
Gray10 = make_color(0.10, 0.10, 0.10)
Grey10 = make_color(0.10, 0.10, 0.10)
Gray11 = make_color(0.11, 0.11, 0.11)
Grey11 = make_color(0.11, 0.11, 0.11)
Gray12 = make_color(0.12, 0.12, 0.12)
Grey12 = make_color(0.12, 0.12, 0.12)
Gray13 = make_color(0.13, 0.13, 0.13)
Grey13 = make_color(0.13, 0.13, 0.13)
Gray14 = make_color(0.14, 0.14, 0.14)
Grey14 = make_color(0.14, 0.14, 0.14)
Gray15 = make_color(0.15, 0.15, 0.15)
Grey15 = make_color(0.15, 0.15, 0.15)
Gray16 = make_color(0.16, 0.16, 0.16)
Grey16 = make_color(0.16, 0.16, 0.16)
Gray17 = make_color(0.17, 0.17, 0.17)
Grey17 = make_color(0.17, 0.17, 0.17)
Gray18 = make_color(0.18, 0.18, 0.18)
Grey18 = make_color(0.18, 0.18, 0.18)
Gray19 = make_color(0.19, 0.19, 0.19)
Grey19 = make_color(0.19, 0.19, 0.19)
Gray20 = make_color(0.20, 0.20, 0.20)
Grey20 = make_color(0.20, 0.20, 0.20)
Gray21 = make_color(0.21, 0.21, 0.21)
Grey21 = make_color(0.21, 0.21, 0.21)
Gray22 = make_color(0.22, 0.22, 0.22)
Grey22 = make_color(0.22, 0.22, 0.22)
Gray23 = make_color(0.23, 0.23, 0.23)
Grey23 = make_color(0.23, 0.23, 0.23)
Gray24 = make_color(0.24, 0.24, 0.24)
Grey24 = make_color(0.24, 0.24, 0.24)
Gray25 = make_color(0.25, 0.25, 0.25)
Grey25 = make_color(0.25, 0.25, 0.25)
Gray26 = make_color(0.26, 0.26, 0.26)
Grey26 = make_color(0.26, 0.26, 0.26)
Gray27 = make_color(0.27, 0.27, 0.27)
Grey27 = make_color(0.27, 0.27, 0.27)
Gray28 = make_color(0.28, 0.28, 0.28)
Grey28 = make_color(0.28, 0.28, 0.28)
Gray29 = make_color(0.29, 0.29, 0.29)
Grey29 = make_color(0.29, 0.29, 0.29)
Gray30 = make_color(0.30, 0.30, 0.30)
Grey30 = make_color(0.30, 0.30, 0.30)
Gray31 = make_color(0.31, 0.31, 0.31)
Grey31 = make_color(0.31, 0.31, 0.31)
Gray32 = make_color(0.32, 0.32, 0.32)
Grey32 = make_color(0.32, 0.32, 0.32)
Gray33 = make_color(0.33, 0.33, 0.33)
Grey33 = make_color(0.33, 0.33, 0.33)
Gray34 = make_color(0.34, 0.34, 0.34)
Grey34 = make_color(0.34, 0.34, 0.34)
Gray35 = make_color(0.35, 0.35, 0.35)
Grey35 = make_color(0.35, 0.35, 0.35)
Gray36 = make_color(0.36, 0.36, 0.36)
Grey36 = make_color(0.36, 0.36, 0.36)
Gray37 = make_color(0.37, 0.37, 0.37)
Grey37 = make_color(0.37, 0.37, 0.37)
Gray38 = make_color(0.38, 0.38, 0.38)
Grey38 = make_color(0.38, 0.38, 0.38)
Gray39 = make_color(0.39, 0.39, 0.39)
Grey39 = make_color(0.39, 0.39, 0.39)
Gray40 = make_color(0.40, 0.40, 0.40)
Grey40 = make_color(0.40, 0.40, 0.40)
Gray41 = make_color(0.41, 0.41, 0.41)
Grey41 = make_color(0.41, 0.41, 0.41)
Gray42 = make_color(0.42, 0.42, 0.42)
Grey42 = make_color(0.42, 0.42, 0.42)
Gray43 = make_color(0.43, 0.43, 0.43)
Grey43 = make_color(0.43, 0.43, 0.43)
Gray44 = make_color(0.44, 0.44, 0.44)
Grey44 = make_color(0.44, 0.44, 0.44)
Gray45 = make_color(0.45, 0.45, 0.45)
Grey45 = make_color(0.45, 0.45, 0.45)
Gray46 = make_color(0.46, 0.46, 0.46)
Grey46 = make_color(0.46, 0.46, 0.46)
Gray47 = make_color(0.47, 0.47, 0.47)
Grey47 = make_color(0.47, 0.47, 0.47)
Gray48 = make_color(0.48, 0.48, 0.48)
Grey48 = make_color(0.48, 0.48, 0.48)
Gray49 = make_color(0.49, 0.49, 0.49)
Grey49 = make_color(0.49, 0.49, 0.49)
Gray50 = make_color(0.50, 0.50, 0.50)
Grey50 = make_color(0.50, 0.50, 0.50)
Gray51 = make_color(0.51, 0.51, 0.51)
Grey51 = make_color(0.51, 0.51, 0.51)
Gray52 = make_color(0.52, 0.52, 0.52)
Grey52 = make_color(0.52, 0.52, 0.52)
Gray53 = make_color(0.53, 0.53, 0.53)
Grey53 = make_color(0.53, 0.53, 0.53)
Gray54 = make_color(0.54, 0.54, 0.54)
Grey54 = make_color(0.54, 0.54, 0.54)
Gray55 = make_color(0.55, 0.55, 0.55)
Grey55 = make_color(0.55, 0.55, 0.55)
Gray56 = make_color(0.56, 0.56, 0.56)
Grey56 = make_color(0.56, 0.56, 0.56)
Gray57 = make_color(0.57, 0.57, 0.57)
Grey57 = make_color(0.57, 0.57, 0.57)
Gray58 = make_color(0.58, 0.58, 0.58)
Grey58 = make_color(0.58, 0.58, 0.58)
Gray59 = make_color(0.59, 0.59, 0.59)
Grey59 = make_color(0.59, 0.59, 0.59)
Gray60 = make_color(0.60, 0.60, 0.60)
Grey60 = make_color(0.60, 0.60, 0.60)
Gray61 = make_color(0.61, 0.61, 0.61)
Grey61 = make_color(0.61, 0.61, 0.61)
Gray62 = make_color(0.62, 0.62, 0.62)
Grey62 = make_color(0.62, 0.62, 0.62)
Gray63 = make_color(0.63, 0.63, 0.63)
Grey63 = make_color(0.63, 0.63, 0.63)
Gray64 = make_color(0.64, 0.64, 0.64)
Grey64 = make_color(0.64, 0.64, 0.64)
Gray65 = make_color(0.65, 0.65, 0.65)
Grey65 = make_color(0.65, 0.65, 0.65)
Gray66 = make_color(0.66, 0.66, 0.66)
Grey66 = make_color(0.66, 0.66, 0.66)
Gray67 = make_color(0.67, 0.67, 0.67)
Grey67 = make_color(0.67, 0.67, 0.67)
Gray68 = make_color(0.68, 0.68, 0.68)
Grey68 = make_color(0.68, 0.68, 0.68)
Gray69 = make_color(0.69, 0.69, 0.69)
Grey69 = make_color(0.69, 0.69, 0.69)
Gray70 = make_color(0.70, 0.70, 0.70)
Grey70 = make_color(0.70, 0.70, 0.70)
Gray71 = make_color(0.71, 0.71, 0.71)
Grey71 = make_color(0.71, 0.71, 0.71)
Gray72 = make_color(0.72, 0.72, 0.72)
Grey72 = make_color(0.72, 0.72, 0.72)
Gray73 = make_color(0.73, 0.73, 0.73)
Grey73 = make_color(0.73, 0.73, 0.73)
Gray74 = make_color(0.74, 0.74, 0.74)
Grey74 = make_color(0.74, 0.74, 0.74)
Gray75 = make_color(0.75, 0.75, 0.75)
Grey75 = make_color(0.75, 0.75, 0.75)
Gray76 = make_color(0.76, 0.76, 0.76)
Grey76 = make_color(0.76, 0.76, 0.76)
Gray77 = make_color(0.77, 0.77, 0.77)
Grey77 = make_color(0.77, 0.77, 0.77)
Gray78 = make_color(0.78, 0.78, 0.78)
Grey78 = make_color(0.78, 0.78, 0.78)
Gray79 = make_color(0.79, 0.79, 0.79)
Grey79 = make_color(0.79, 0.79, 0.79)
Gray80 = make_color(0.80, 0.80, 0.80)
Grey80 = make_color(0.80, 0.80, 0.80)
Gray81 = make_color(0.81, 0.81, 0.81)
Grey81 = make_color(0.81, 0.81, 0.81)
Gray82 = make_color(0.82, 0.82, 0.82)
Grey82 = make_color(0.82, 0.82, 0.82)
Gray83 = make_color(0.83, 0.83, 0.83)
Grey83 = make_color(0.83, 0.83, 0.83)
Gray84 = make_color(0.84, 0.84, 0.84)
Grey84 = make_color(0.84, 0.84, 0.84)
Gray85 = make_color(0.85, 0.85, 0.85)
Grey85 = make_color(0.85, 0.85, 0.85)
Gray86 = make_color(0.86, 0.86, 0.86)
Grey86 = make_color(0.86, 0.86, 0.86)
Gray87 = make_color(0.87, 0.87, 0.87)
Grey87 = make_color(0.87, 0.87, 0.87)
Gray88 = make_color(0.87, 0.87, 0.87)
Grey88 = make_color(0.87, 0.87, 0.87)
Gray89 = make_color(0.89, 0.89, 0.89)
Grey89 = make_color(0.89, 0.89, 0.89)
Gray90 = make_color(0.89, 0.89, 0.89)
Grey90 = make_color(0.89, 0.89, 0.89)
Gray91 = make_color(0.91, 0.91, 0.91)
Grey91 = make_color(0.91, 0.91, 0.91)
Gray92 = make_color(0.92, 0.92, 0.92)
Grey92 = make_color(0.92, 0.92, 0.92)
Gray93 = make_color(0.93, 0.93, 0.93)
Grey93 = make_color(0.93, 0.93, 0.93)
Gray94 = make_color(0.94, 0.94, 0.94)
Grey94 = make_color(0.94, 0.94, 0.94)
Gray95 = make_color(0.95, 0.95, 0.95)
Grey95 = make_color(0.95, 0.95, 0.95)
Gray96 = make_color(0.96, 0.96, 0.96)
Grey96 = make_color(0.96, 0.96, 0.96)
Gray97 = make_color(0.96, 0.96, 0.96)
Grey97 = make_color(0.96, 0.96, 0.96)
Gray98 = make_color(0.98, 0.98, 0.98)
Grey98 = make_color(0.98, 0.98, 0.98)
Gray99 = make_color(0.98, 0.98, 0.98)
Grey99 = make_color(0.98, 0.98, 0.98)
Gray100 = make_color(1.00, 1.00, 1.00)
Grey100 = make_color(1.00, 1.00, 1.00)
Dark_grey = make_color(0.66, 0.66, 0.66)
Dark_gray = make_color(0.66, 0.66, 0.66)
Dark_blue = make_color(0.00, 0.00, 0.54)
Dark_cyan = make_color(0.00, 0.54, 0.54)
Dark_magenta = make_color(0.54, 0.00, 0.54)
Dark_red = make_color(0.54, 0.00, 0.00)
Light_green = make_color(0.56, 0.93, 0.56)

# rgb.rb ends here
