;;; Snd documentation index (generated by index.cl)

(provide 'snd-index.scm)

(define (html obj)
  "(html arg) where arg can be a string, symbol, or procedure looks for a corresponding url 
and if one is found, and the Snd documentation can be found, calls (html-program) with that url"
  (letrec ((find-close-paren
	    (lambda (str)
	      (let loop ((pos 0)) ;from slib/strsrch.scm
		(cond
		 ((>= pos (string-length str)) #f)
		 ((char=? #\) (string-ref str pos)) pos)
		 ((char=? #\space (string-ref str pos)) pos)
		 (else (loop (+ 1 pos)))))))
	   
	   (goto-html
	    (lambda (n)
	      ;; look for doc on current dir, then html dir, then global dir
	      ;; snd.html is what we'll search for
	      (let ((dir (if (file-exists? "snd.html") 
			     (getcwd)
			     (if (and (string? (html-dir))
				      (file-exists? (string-append (html-dir) "/snd.html")))
				 (html-dir)
				 (if (file-exists? "/usr/share/doc/snd-9/snd.html")
				     "/usr/share/doc/snd-9"
				     (if (file-exists? "/usr/local/share/doc/snd-9/snd.html")
					 "/usr/local/share/doc/snd-9"
					 (if (file-exists? "/usr/doc/snd-9/snd.html")
					     "/usr/doc/snd-9"
					     (if (file-exists? "/usr/share/doc/snd-8/snd.html")
						 "/usr/share/doc/snd-8"
						 (if (file-exists? "/usr/local/share/doc/snd-8/snd.html")
						     "/usr/local/share/doc/snd-8"
						     (if (file-exists? "/usr/doc/snd-8/snd.html")
							 "/usr/doc/snd-8"
							 #f))))))))))
		(if dir
		    (if (or (string=? (html-program) "netscape")
			    (string=? (html-program) "mozilla")
			    (string=? (html-program) "firefox"))
			(send-mozilla (string-append dir "/" n)) ; definition in snd-gxutils.c
			(system (string-append (html-program) " file:" dir "/" n))))))))
    
    (let ((name (if (string? obj) 
		    obj
		    (if (symbol? obj) 
			(symbol->string obj)
			(let ((doc (if (procedure? obj)
				       (or (procedure-property obj 'documentation)
					   (procedure-documentation obj)
					   (object-property obj 'documentation))
				       (object-property obj 'documentation))))
			  (if (and (string? doc)
				   (char=? (string-ref doc 0) #\())
			      (let ((pos (find-close-paren doc)))
				(if pos
				    (substring doc 1 pos)
				    #f))))))))
      (if (and name (string? name))
	  (let ((url (snd-url name)))
	    (if url 
		(goto-html url)
		(snd-print (format #f "no url for ~A?" name))))
	  (snd-print (format #f "no doc for ~A?" name))))))


(define (? obj)
  "(? obj) prints out any help it can find for obj, and tries to find obj in the docs via firefox, netscape or mozilla"
  (let ((hlp (snd-help obj)))
    (if (string? hlp)
	(snd-print hlp))
    (html obj)))
