%{
/*
 * Copyright (c) 2005 - 2008 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <string.h>

#ifdef __NetBSD__
#include "parse.h"
#else
#include "y.tab.h"
#endif

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

backend			{ return BACKEND; }
backend-path		{ return BACKEND_PATH; }
virus-strategy		{ return VIRUS_STRATEGY; }
error-strategy		{ return ERROR_STRATEGY; }
spam-strategy		{ return SPAM_STRATEGY; }
unwanted-strategy	{ return UNWANTED_STRATEGY; }
port			{ return PORT; }
tmpdir			{ return TMPDIR; }
recipient-notification	{ return RECIPIENT_NOTIFICATION; }
notify-only		{ return NOTIFY_ONLY; }
option			{ return OPTION; }
user			{ return USER; }
group			{ return GROUP; }
chroot			{ return CHROOT; }
tmpfiles		{ return TMPFILES; }
spam-subject-prefix	{ return SPAM_SUBJECT_PREFIX; }
logfile			{ return LOGFILE; }
config-file		{ return CFGFILE; }
statfile		{ return STATFILE; }
interval		{ return INTERVAL; }
header-options		{ return HEADER_OPTIONS; }
spam-header		{ return SPAMHDR; }

ldaphost		{ return LDAPHOST; }
ldapport		{ return LDAPPORT; }
ldapurl			{ return LDAPURL; }
searchbase		{ return SEARCHBASE; }
binddn			{ return BINDDN; }
bindpasswd		{ return BINDPASSWD; }
usetls			{ return USETLS; }
never			{ return NEVER; }
try			{ return TRY; }
always			{ return ALWAYS; }

discard			{ return DISCARD; }
mark			{ return MARK; }
notify-recipient	{ return NOTIFY_RECIPIENT; }
reject			{ return RJECT; }
tempfail		{ return TEMPFAIL; }
ignore			{ return IGNORE; }

markall			{ return MARKALL; }
logall			{ return LOGALL; }

logvirus		{ return LOGVIRUS; }
logspam			{ return LOGSPAM; }
logunwanted		{ return LOGUNWANTED; }
g\+r			{ return GRPRD; }
setgrp			{ return SETGRP; }

strategy		{ return STRATEGY; }
for			{ return FOR; }

react			{ return REACT; }
on			{ return ON; }
spam			{ return SPAM; }
virus			{ return VIRUS; }
unwanted-content	{ return UNWANTED_CONTENT; }
clean			{ return CLEAN; }
add			{ return ADD; }
to			{ return TO; }
table			{ return TABLE; }
delete			{ return DELETE; }
from			{ return FROM; }

[0-9]+			{
				vilterlval.string = strdup(viltertext);
				return NUMBER;
			}

#.*\n			/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+	{
				vilterlval.string = strdup(viltertext);
				return TEXT;
			}

\"([^"\n]*)["\n]	{
				viltertext[vilterleng - 1] = 0;
				vilterleng -= 2;
				vilterlval.string = strdup(viltertext + 1);
				return TEXT;
			}

=			{ return '='; }

\n			{ return '\n'; }
