%{
/*
 * Copyright (c) 2006 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <string.h>

#ifdef __NetBSD__
#include "parse.h"
#else
#include "y.tab.h"
#endif

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

case-sensitive		{ return CASE_SENSITIVE; }
unwanted-header		{ return UNWANTED_HEADER; }
unwanted-body		{ return UNWANTED_BODY; }

true			{ return TRUE; }
false			{ return FALSE; }

[0-9]+			{
				regexlval.string = strdup(regextext);
				return NUMBER;
			}

#.*\n			/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+	{
				regexlval.string = strdup(regextext);
				return TEXT;
			}

\"([^"\n]*)["\n]	{
				regextext[regexleng - 1] = 0;
				regexleng -= 2;
				regexlval.string = strdup(regextext + 1);
				return TEXT;
			}

=			{ return '='; }

\n			{ return '\n'; }
