;;; skk.el --- SKK (Simple Kana to Kanji conversion program)
;; Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Version: 9.6
;; Keywords: japanese
;; Last Modified: Fri Feb  7 22:42:40 1997

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:

;; Following people contributed modifications to skk.el (Alphabetical order):
;;      Chikanobu Toyofuku <unbound@papaya.juice.or.jp>
;;      FURUE Hideyuki <furue@kke.co.jp>
;;      GUNJI Takao <gunji@lisa.lang.osaka-u.ac.jp>
;;      Haru Mizuno <mizu@cs3.cs.oki.co.jp>
;;      Hisao Kuroda <kuroda@msi.co.jp>
;;      Hitoshi SUZUKI <h-suzuki@ael.fujitsu.co.jp>
;;      IIDA Yosiaki <iida@secom-sis.co.jp>
;;      Jun-ichi Nakamura <nakamura@pluto.ai.kyutech.ac.jp>
;;      Katuya Tomioka <tomioka@culle.l.chiba-u.ac.jp>
;;      Kazuo Hirokawa <hirokawa@rics.co.jp>
;;      Kazushi Marukawa <kazushi@kubota.co.jp>
;;      Kimura Chikahiro <kimura@oa1.kb.nec.co.jp>
;;      Kiyotaka Sakai <ksakai@netwk.ntt-at.co.jp>
;;      Koichi MORI <kmori@onsei2.rilp.m.u-tokyo.ac.jp>
;;      MINOURA Itsushi <minoura@uni.zool.s.u-tokyo.ac.jp>
;;      MIYOSHI Tsutomu <minkov@fuzzy.or.jp>
;;      Makoto MATSUSHITA <matusita@ics.es.osaka-u.ac.jp>
;;      Masahiko Suzuki <suzmasa@sm.sony.co.jp>
;;      Masahiro Doteguchi <xdote@rp.open.cs.fujitsu.co.jp>
;;      Masakazu Takahashi <masaka-t@ascii.co.jp>
;;      Mikio Nakajima <gy2m-nkjm@asahi-net.or.jp>
;;      Motohiko Mouri <mouri@jaist.ac.jp>
;;      Murata Shuuichirou <mrt@mickey.ai.kyutech.ac.jp>
;;      Ż  <hisashi@rst.fujixerox.co.jp>
;;      NAMBA Seiich <pi9s-nnb@asahi-net.or.jp>
;;      Naoki HAMADA <nao@mimo.jaist-east.ac.jp>
;;      Ryoichi Hashimoto <gnu@ipri.go.jp>
;;      Sekita Daigo <sekita@mri.co.jp>
;;      Shuji Ashizawa <ashizawa@zuken.co.jp>
;;      Takeshi OHTANI <ohtani@iias.flab.fujitsu.co.jp>
;;      Tomoyuki Hiro <hiro@momo.it.okayama-u.ac.jp>
;;      Tsugutomo Enami <enami@ptgd.sony.co.jp>
;;      Wataru Matsui <matsui@atr-rd.atr.co.jp>
;;      Yoshida Toyonobu <toyono-y@is.aist-nara.ac.jp>

;;; Change log:
;; version 9.6 released 1997.2.7
;; version 8.6 released 1995.5.17
;; version 7.18 released 1994.6.7
;; version 6.32 released 1993.4.24
;; version 5.30 released 1992.5.9
;; version 4.33 released 1991.5.9
;; version 3.47 released 1990.4.29
;; version 2.25 released 1989.4.15
;; version 1.13 released 1988.4.22

;;; Code:

;;;###autoload
(defun skk-version ()
  (interactive)
  (if (interactive-p)
      (message "SKK version %s of Feb 7, 1996" (skk-version))
    "9.6"))

;; Elib 1.0 is required
(require 'avltree)
(require 'queue-m)
(require 'string)

;;;; version specific matter.
(or (fboundp 'eval-and-compile)
    (fset 'eval-and-compile 'progn))
(eval-and-compile
  (if (or (and (boundp 'epoch::version) epoch::version)
          (and (string< (substring emacs-version 0 2) "18")
               (skk-message
                "Emacs ΥС󤬸ŤSKK ưʤǽޤ"
                "SKK may not work as Emacs version is too old" )
               (sit-for 2) )
          (string= (substring emacs-version 0 2) "18") )
      (require 'skk-e18)
    (require 'skk-e19) ))

;;;; variable declarations
;;; -- user variables

(skk-defvar skk-init-file (if (eq system-type 'ms-dos) "~/_skk" "~/.skk")
  "*SKK νե̾
skk.el 9.x  ~/.emacs ǤΥޥǽȤʤä" )

(skk-defvar skk-special-midashi-char-list '(?> ?< ??)
  "*ƬϤΤΥץեåեåΥꥹȡ")

(skk-defvar skk-mode-hook nil
  "*SKK ưȤΥեå
¾ˡskk-auto-fill-mode-hookskk-load-hook, skk-init-file Ǥ⥫
ޥǽ")

(skk-defvar skk-auto-fill-mode-hook nil
  "*skk-auto-fill-mode ưȤΥեå
¾ˡskk-mode-hook, skk-load-hook, skk-init-file Ǥ⥫ޥ
ǽ" )

(skk-defvar skk-load-hook nil
  "*skk.el ɤȤΥեå
¾ˡskk-mode-hook, skk-auto-fill-mode-hook, skk-init-file Ǥ⥫
ޥǽ" )

(skk-defvar skk-kakutei-jisyo nil
  "*ǽ˸뼭
Non-nil ǡ skk-search-prog-list ǤˤѿѤƤС
ꤵ줿򸡺ΤХåեɤ߹ߡԤʤ
ФϡȤƤʤФʤʤ
ƸФκǽΥȥꤷʤ (ʣΥȥ꤬äƤ 2 ܰʹߤ
ȥ̵뤵)
skk-search-prog-list ͤꤹ뤳Ȥˤꡢоݤμѹν
ѹǽ" )

(skk-defvar skk-initial-search-jisyo nil
  "*桼θ˸뼭
ФϡȤƤʤФʤʤ
Non-nil ǡ skk-search-prog-list ǤˤѿѤƤС
ꤵ줿򸡺ΤХåեɤ߹ߡԤʤ
skk-search-prog-list ͤꤹ뤳Ȥˤꡢоݤμѹν
ѹǽ")

(skk-defvar skk-large-jisyo nil
  "*桼θθ˸뼭
ФϡȤƤʤФʤʤ
Non-nil ǡ skk-search-prog-list ǤˤѿѤƤС
ꤵ줿򸡺ΤХåեɤ߹ߡԤʤ
skk-search-prog-list ͤꤹ뤳Ȥˤꡢоݤμѹν
ѹǽ" )

;;;###autoload
(skk-defvar skk-aux-large-jisyo nil
  "*SKK СǺǸ˸뼭
ФϡȤƤʤФʤʤ
Non-nil ǡ skk-search-prog-list ǤˤѿѤƤС
SKK СȤԤ
SKK С active ǤʤСꤵ줿Хåեɤ߹ࡣ
skk-search-prog-list ͤꤹ뤳Ȥˤꡢоݤμѹν
ѹǽ
ͤꤹ뤳Ȥˤꡢskk-server.el  autoload 롣" )

(skk-defvar skk-search-prog-list
  '((skk-search-kakutei-jisyo-file skk-kakutei-jisyo 10000 t)
    (skk-search-jisyo-file skk-initial-search-jisyo 10000 t)
    (skk-search-jisyo-file skk-jisyo 0 t)
    ;; skk-auto.el ɤȲǤץ饹롣
    ;; <(skk-auto.el/skk-adjust-search-prog-list-for-auto-okuri)>
    ;;(skk-okuri-search)
    (skk-search-jisyo-file skk-large-jisyo 10000)
    ;; skk-server.el ɤȲǤץ饹롣
    ;; <(skk-server.el/skk-adjust-search-prog-list-for-server-search)>
    ;; skk-server-host ⤷ skk-servers-list ꤹȡskk-server.el 
    ;;  autoload 롣<(skk.el/skk-mode:2)>
    ;;(skk-search-server skk-aux-large-jisyo 10000)
    )
  "*ؿоݤμꤹ뤿Υꥹȡ
Ѵ֤ S ꥹȤηɽΡ
skk-search ؿ skk-search-prog-list  car ؽ֤ S ɾ
ԤѴԤʤ"
  '((skk-search-jisyo-file skktut-tut-jisyo 0 t)) )

(skk-defvar skk-jisyo (if (eq system-type 'ms-dos) "~/_skk-jisyo" "~/.skk-jisyo")
  "*SKK Υ桼"
  "~/skk-tut-jisyo" )

(skk-defvar skk-backup-jisyo
  (if (eq system-type 'ms-dos) "~/_skk-jisyo.BAK" "~/.skk-jisyo.BAK")
  "*SKK Υ桼ΥХååץե롣" )

(skk-defvar skk-jisyo-code nil
  "*Non-nil ǤСͤǼХåեδɤꤹ롣
Mule Ǥϡ*euc-japan*, *sjis*, *junet*
Nemacs Ǥϡ0, 1, 2, 3
ޤ\"euc\", \"ujis\", \"sjis\", \"jis\" ʤɤʸˤäƤ꤬ǽ" )

(skk-defvar skk-keep-record t
  "*Non-nil ǤСѴ˴ؤ뵭Ͽ skk-record-file ˼롣"
  'false )

(skk-defvar skk-record-file
  (if (eq system-type 'ms-dos) "~/_skk-record" "~/.skk-record")
  "*桼פե롣
񥻡֤λñϿԤäΨΤθ
롣" )

(skk-defvar skk-kakutei-key "\C-j" "*ư (\"skk-kakutei\") Ԥ")

(skk-defvar skk-use-vip nil
  "*Non-nil ǤСVIP б롣" )

(skk-defvar skk-henkan-okuri-strictly nil
  "*Non-nil ǤСФ겾̾פȤȤƽϤ롣
㤨СΤ褦ʼ񥨥ȥ꤬skk-jisyo \(ץ饤١ȼ\) ˤä

  \"k //¿/[/¿/]/[//]/\"

\"*\" ѴȤ\"¿\" ΤߤϤ\"礯\" Ϥʤ

SKK-JISYO.[SML] 겾̾ȥϾ嵭ηˤʤäƤʤΤǡskk-jisyo 
ꤢμ񥨥ȥ꤬ηΤΤ򤢤ޤޤǤʤϡΥץ
 on ˤ뤳ȤǡñϿäƤޤΤդ뤳ȡ

skk-process-okuri-early ͤ nil ʤо嵭η skk-jisyo 񤬺
롣

Emacs 19 ١ Mule ʤСΥեɾ뤳ȤǡñϿ
ȤŪˤΥץ nil ˤ뤳ȤǤ롣

    \(add-hook 'minibuffer-setup-hook
              \(function
               \(lambda \(\)
                 \(if \(and \(boundp 'skk-henkan-okuri-strictly\)
                          skk-henkan-okuri-strictly
                          \(not \(eq last-command 'skk-purge-jisyo\)\) \)
                     \(progn
                       \(setq skk-henkan-okuri-strictly nil\)
                       \(put 'skk-henkan-okuri-strictly 'temporary-nil t\) \)\)\)\)\)

    \(add-hook 'minibuffer-exit-hook
              \(function
               \(lambda \(\)
                 \(if \(get 'skk-henkan-okuri-strictly 'temporary-nil\)
                     \(progn
                       \(put 'skk-henkan-okuri-strictly 'temporary-nil nil\)
                       \(setq skk-henkan-okuri-strictly t\) \)\)\)\)\)

Υץѻϡskk-process-okuri-early ͤ nil ǤʤФʤʤ
\(˥塼С ѤƥޥϼưŪĴ\)" )

(skk-defvar skk-auto-okuri-process nil
  "*Non-nil ǤС겾̾ʬưǧѴԤ
㤨С

    \"Uresii (\"UreSii\" ǤϤʤ) -> 򤷤\"

Τ褦Ѵ롣âskk-jisyo  \(ץ饤١ȼ\) 

    \"s //[//]/\"

Τ褦ʷˤʤäƤ뤳ȤɬפǤ \(SKK-JISYO.[SML] Ϥηб
ƤʤΤǡskk-jisyo ˤΥȥ꤬ʤФʤʤ\)

Υץѻϡskk-process-okuri-early ͤ nil ǤʤФʤʤ
\(˥塼С ѤƥޥϼưŪĴ\)" )

(skk-defvar skk-process-okuri-early nil
  "*Non-nil ǤС겾̾Υ޻ץեåϻѴ򳫻Ϥ롣
㤨С

    \"UgoK -> ưk\"

겾̾ʬʤޤѴƤ뤳ȤˤʤΤǡskk-jisyo 겾̾б
ĹʤĤޤ

    \"k /ư/\"

Τ褦ʷ֤ΤޤޤȤʤ롣

    \"k /ư/[/ư/]/[/ư/]/[/ư/]/[/ư/]/[/ư/]/\"

Τ褦ʥȥ꤬ skk-jisyo ˤС˲ʤ

nil ǤС겾̾ϤλѴϤ롣㤨С

    \"UgoK -> *k\", \"UgoKu -> ư\"

Υץ on ˤ skk-mode ưȡξΩǤʤץǤ
skk-kakutei-early, skk-auto-okuri-process, skk-henkan-okuri-strictly  nil 
åȤ롣" )

(skk-defvar skk-egg-like-newline nil
  "*Non-nil ǤС⡼ɤǲԤ򥿥פƤꤹΤߤǲԤʤ" )

(skk-defvar skk-kakutei-early t
  "*Non-nil Ǥ skk-kana-input ƤФ줿Ȥ˸ߤθꤹ롣
㤨С

    \"Ƥ ->  -> s -> ꤹ\"

Τ褦Ѵ塢֤פ prefix Ǥ \"s\" Ϥǳꤹ롣
nil ǤС㤨

    \"Ƥ ->  -> s -> ꤹ -> ꤹ롣\"

Τ褦 skk-kakutei ľܡܤ˥뤹ޤ \(Ϥꡢ
⡼ɤäꤹȴŪ skk-kakutei 򥳡뤹\) ϡꤷʤΤǡ
δ֤ϡѴӤʤȤʤɤǽ

Υץѻϡskk-process-okuri-early ͤ nil ǤʤФʤʤ
\(˥塼С ѤƥޥϼưŪĴ\)" )

(skk-defvar skk-delete-implies-kakutei t
  "*Non-nil ǤС⡼ɤ BS 򲡤ȡΰʸꤹ롣
nil ǤСθɽ롣")

(skk-defvar skk-allow-spaces-newlines-and-tabs t
  "*Non-nil ǤСskk-henkan-key ˥ڡ֡ԤäƤѴǽ
㤨СΤ褦 skk-henkan-key ˲ԤäƤƤѴǽǤ롣

     \"
  \"
   -> \"̾\"

ͤ nil ǤСǽΥڡ skk-henkan-key ڤͤƤޤ
ʹߤΥڡ֡Ԥ̵뤵롣
ͤϡskk-start-henkan, skk-ascii-henkan, skk-katakana-henkan,
skk-hiragana-henkan, skk-zenkaku-henkan ڤ skk-backward-and-set-henkan-point
ư˱ƶ롣")

(skk-defvar skk-convert-okurigana-into-katakana nil
  "*Non-nil ǤСʥ⡼ɤѴȤ겾̾⥫ʤѴ롣" )

(skk-defvar skk-delete-okuri-when-quit nil
  "*Non-nil ǤСꤢѴ \"C-g\" 򲡤겾̾ä⡼ɤ롣
㤨С

    \"* -> 㤯 -> \"C-g\" ->\"

nil ǤС겾̾ޤ᤿Ф򤽤Τޤ޻Ĥ⡼ɤ롣㤨С

    \"* -> 㤯 -> \"C-g\" -> ʤ\"" )

(skk-defvar skk-henkan-show-candidates-keys '(?a ?s ?d ?f ?j ?k ?l)
  "*˥塼Ǹ򤹤Ȥ򥭡Υꥹȡ
\"x\", \" \" ڤ \"C-g\" ʳ 7 ĤΥ (char type) ޤɬפ
롣\"x\", \" \" ڤ \"C-g\" ϸˤ줾̤ʻŻ˳
ƤƤΤǡΥꥹȤˤϴޤʤȡ")

(skk-defvar skk-mode-string "--SKK:"
  "*SKK  ascii ⡼ɤǤȤ˥⡼ɥ饤ɽʸ
⡼ɥ饤κǺʬɽ롣" )

(skk-defvar skk-hirakana-mode-string "--"
  "*Ҥ餬ʥ⡼ɤǤȤ˥⡼ɥ饤ɽʸ
⡼ɥ饤κǺʬɽ롣")

(skk-defvar skk-katakana-mode-string "--"
  "*ʥ⡼ɤǤȤ˥⡼ɥ饤ɽʸ
⡼ɥ饤κǺʬɽ롣")

(skk-defvar skk-zenei-mode-string "--"
  "*ѥ⡼ɤǤȤ˥⡼ɥ饤ɽʸ
⡼ɥ饤κǺʬɽ롣")

(skk-defvar skk-echo t
  "*Non-nil ǤС̾ʸΥץեåɽ롣" )

(skk-defvar skk-use-numeric-conversion t
  "*Non-nil ǤСѴԤ" )

(skk-defvar skk-char-type-vector
  [0 0 0 0 0 0 0 0
   5 0 0 0 0 0 0 0
   0 0 0 0 0 0 0 0
   0 0 0 0 0 0 0 0
   0 0 0 0 0 0 0 0
   0 0 0 0 0 0 0 0
   0 0 0 0 0 0 0 0
   0 0 0 0 0 0 0 0
   0 4 4 4 4 4 4 4
   4 4 4 4 0 4 4 4
   4 0 4 4 4 4 4 4
   0 4 4 0 0 0 0 0
   0 3 1 1 1 3 1 1
   1 3 1 1 0 1 2 3
   1 0 1 1 1 3 1 1
   2 1 1 0 0 0 0 5]
  "*skk-kana-input ǻȤ뤫ʸѴΤ char type ٥
Ǥοΰ̣ϲ̤ꡣ

0 ʸ꤫ʸؤѴߤ (ߤΤȤѤƤʤ)
1 ¥ΰʬȤʤҲ
2 嵭 1 ʳλҲ (n, x)
3 첻
4 skk-mode ǡskk-set-henkan-point ˳դƤʸ
5 ץեåõ" )

(skk-defvar skk-rom-kana-rule-list
  '(("nn" nil ("" . ""))
    ("n'" nil ("" . "")) )
  "*޻ѴΥȥޥȥξܵ§
ꥹȤγǤϡ(ߤξ@ ξ ) (â\"@\" Ϣ) ̣
롣" )

(skk-defvar skk-roma-kana-a
  '(("" . ("" . ""))
    ("b" . ("" . "")) ("by" . ("Ӥ" . "ӥ"))
    ("ch" . ("" . "")) ("cy" . ("" . ""))
    ("d" . ("" . "")) ("dh" . ("Ǥ" . "ǥ"))
    ("dy" . ("¤" . "¥"))
    ("f" . ("դ" . "ե")) ("fy" . ("դ" . "ե"))
    ("g" . ("" . "")) ("gy" . ("" . ""))
    ("h" . ("" . "")) ("hy" . ("Ҥ" . "ҥ"))
    ("j" . ("" . "")) ("jy" . ("" . ""))
    ("k" . ("" . "")) ("ky" . ("" . ""))
    ("m" . ("" . "")) ("my" . ("ߤ" . "ߥ"))
    ("n" . ("" . "")) ("ny" . ("ˤ" . "˥"))
    ("p" . ("" . "")) ("py" . ("Ԥ" . "ԥ"))
    ("r" . ("" . "")) ("ry" . ("" . ""))
    ("s" . ("" . "")) ("sh" . ("" . ""))
    ("sy" . ("" . ""))
    ("t" . ("" . "")) ("th" . ("Ƥ" . "ƥ"))
    ("ty" . ("" . ""))
    ("v" . ("" . "")) ("w" . ("" . ""))
    ("x" . ("" . "")) ("xk" . ("" . ""))
    ("xw" . ("" . "")) ("xy" . ("" . ""))
    ("y" . ("" . ""))
    ("z" . ("" . "")) ("zy" . ("" . "")))
  "*첻 \"\" ޤʸϢۥꥹȡskk-prefix " )

(skk-defvar skk-roma-kana-i
  '(("" . ("" . ""))
    ("b" . ("" . "")) ("by" . ("Ӥ" . "ӥ"))
    ("ch" . ("" . "")) ("cy" . ("" . ""))
    ("d" . ("" . "")) ("dh" . ("Ǥ" . "ǥ"))
    ("dy" . ("¤" . "¥"))
    ("f" . ("դ" . "ե")) ("fy" . ("դ" . "ե"))
    ("g" . ("" . "")) ("gy" . ("" . ""))
    ("h" . ("" . "")) ("hy" . ("Ҥ" . "ҥ"))
    ("j" . ("" . "")) ("jy" . ("" . ""))
    ("k" . ("" . "")) ("ky" . ("" . ""))
    ("m" . ("" . "")) ("my" . ("ߤ" . "ߥ"))
    ("n" . ("" . "")) ("ny" . ("ˤ" . "˥"))
    ("p" . ("" . "")) ("py" . ("Ԥ" . "ԥ"))
    ("r" . ("" . "")) ("ry" . ("ꤣ" . "ꥣ"))
    ("s" . ("" . "")) ("sh" . ("" . ""))
    ("sy" . ("" . ""))
    ("t" . ("" . "")) ("th" . ("Ƥ" . "ƥ"))
    ("ty" . ("" . ""))
    ("v" . ("" . "")) ("w" . ("" . ""))
    ("x" . ("" . "")) ("xw" . ("" . ""))
    ("z" . ("" . "")) ("zy" . ("" . "")))
  "*첻 \"\" ޤʸϢۥꥹȡskk-prefix " )

(skk-defvar skk-roma-kana-u
  '(("" . ("" . ""))
    ("b" . ("" . "")) ("by" . ("Ӥ" . "ӥ"))
    ("ch" . ("" . "")) ("cy" . ("" . ""))
    ("d" . ("" . "")) ("dh" . ("Ǥ" . "ǥ"))
    ("dy" . ("¤" . "¥"))
    ("f" . ("" . "")) ("fy" . ("դ" . "ե"))
    ("g" . ("" . "")) ("gy" . ("" . ""))
    ("h" . ("" . "")) ("hy" . ("Ҥ" . "ҥ"))
    ("j" . ("" . "")) ("jy" . ("" . ""))
    ("k" . ("" . "")) ("ky" . ("" . ""))
    ("m" . ("" . "")) ("my" . ("ߤ" . "ߥ"))
    ("n" . ("" . "")) ("ny" . ("ˤ" . "˥"))
    ("p" . ("" . "")) ("py" . ("Ԥ" . "ԥ"))
    ("r" . ("" . "")) ("ry" . ("" . ""))
    ("s" . ("" . "")) ("sh" . ("" . ""))
    ("sy" . ("" . ""))
    ("t" . ("" . "")) ("th" . ("Ƥ" . "ƥ"))
    ("ts" . ("" . "")) ("ty" . ("" . ""))
    ("v" . ("" . "")) ("w" . ("" . ""))
    ("x" . ("" . "")) ("xt" . ("" . ""))
    ("xts" . ("" . "")) ("xy" . ("" . ""))
    ("y" . ("" . ""))
    ("z" . ("" . "")) ("zy" . ("" . "")))
  "*첻 \"\" ޤʸϢۥꥹȡskk-prefix " )

(skk-defvar skk-roma-kana-e
  '(("" . ("" . ""))
    ("b" . ("" . "")) ("by" . ("Ӥ" . "ӥ"))
    ("ch" . ("" . "")) ("cy" . ("" . ""))
    ("d" . ("" . "")) ("dh" . ("Ǥ" . "ǥ"))
    ("dy" . ("¤" . "¥"))
    ("f" . ("դ" . "ե")) ("fy" . ("դ" . "ե"))
    ("g" . ("" . "")) ("gy" . ("" . ""))
    ("h" . ("" . "")) ("hy" . ("Ҥ" . "ҥ"))
    ("j" . ("" . "")) ("jy" . ("" . ""))
    ("k" . ("" . "")) ("ky" . ("" . ""))
    ("m" . ("" . "")) ("my" . ("ߤ" . "ߥ"))
    ("n" . ("" . "")) ("ny" . ("ˤ" . "˥"))
    ("p" . ("" . "")) ("py" . ("Ԥ" . "ԥ"))
    ("r" . ("" . "")) ("ry" . ("ꤧ" . "ꥧ"))
    ("s" . ("" . "")) ("sh" . ("" . ""))
    ("sy" . ("" . ""))
    ("t" . ("" . "")) ("th" . ("Ƥ" . "ƥ"))
    ("ty" . ("" . ""))
    ("v" . ("" . "")) ("w" . ("" . ""))
    ("x" . ("" . "")) ("xk" . ("" . ""))
    ("xw" . ("" . ""))
    ("y" . ("" . ""))
    ("z" . ("" . "")) ("zy" . ("" . "")))
  "*첻 \"\" ޤʸϢۥꥹȡskk-prefix " )

(skk-defvar skk-roma-kana-o
  '(("" . ("" . ""))
    ("b" . ("" . "")) ("by" . ("Ӥ" . "ӥ"))
    ("ch" . ("" . "")) ("cy" . ("" . ""))
    ("d" . ("" . "")) ("dh" . ("Ǥ" . "ǥ"))
    ("dy" . ("¤" . "¥"))
    ("f" . ("դ" . "ե")) ("fy" . ("դ" . "ե"))
    ("g" . ("" . "")) ("gy" . ("" . ""))
    ("h" . ("" . "")) ("hy" . ("Ҥ" . "ҥ"))
    ("j" . ("" . "")) ("jy" . ("" . ""))
    ("k" . ("" . "")) ("ky" . ("" . ""))
    ("m" . ("" . "")) ("my" . ("ߤ" . "ߥ"))
    ("n" . ("" . "")) ("ny" . ("ˤ" . "˥"))
    ("p" . ("" . "")) ("py" . ("Ԥ" . "ԥ"))
    ("r" . ("" . "")) ("ry" . ("" . ""))
    ("s" . ("" . "")) ("sh" . ("" . ""))
    ("sy" . ("" . ""))
    ("t" . ("" . "")) ("th" . ("Ƥ" . "ƥ"))
    ("ty" . ("" . ""))
    ("v" . ("" . "")) ("w" . ("" . ""))
    ("x" . ("" . "")) ("xy" . ("" . ""))
    ("y" . ("" . ""))
    ("z" . ("" . "")) ("zy" . ("" . "")))
  "*첻 \"\" ޤʸϢۥꥹȡskk-prefix " )

(skk-defvar skk-input-vector
  [nil  nil  nil  nil  nil  nil  nil  nil  ;7
   nil  nil  nil  nil  nil  nil  nil  nil  ;15
   nil  nil  nil  nil  nil  nil  nil  nil  ;23
   nil  nil  nil  nil  nil  nil  nil  nil  ;31
   nil  "" nil  nil  nil  nil  nil  nil  ;39
   nil  nil  nil  nil  "" "" "" nil  ;47
   nil  nil  nil  nil  nil  nil  nil  nil  ;55
   nil  nil  "" "" nil  nil  nil  "" ;63
   nil  nil  nil  nil  nil  nil  nil  nil  ;71
   nil  nil  nil  nil  nil  nil  nil  nil  ;79
   nil  nil  nil  nil  nil  nil  nil  nil  ;87
   nil  nil  nil  "" nil  "" nil  nil  ;95
   nil  nil  nil  nil  nil  nil  nil  nil  ;103
   nil  nil  nil  nil  nil  nil  nil  nil  ;111
   nil  nil  nil  nil  nil  nil  nil  nil  ;119
   nil  nil  nil  nil  nil  nil  nil  nil] ;127
  "*skk-self-insert ǻȤʸơ֥롣
б֤ʸ󤬤СҤ餬ʥ⡼ɤ⤷ϥʥ⡼ɤǡ
Υ򲡤Ȥǡбʸ롣
㤨С\"~\" бơ\"\" 褦ѹСskk.el 
Υɸ (⤷ skk-load-hook Ѥ)

  \(aset skk-input-vector 126 \"\"\)

Ȥ뤫⤷ϡskk-input-vector  126  (0 ֤) ͤ
\"\" Ȥ褦 skk-input-vector ľܽ񤭡setq  \(126 ϡ?
{ ɾȤ\)" )

(skk-defvar skk-zenkaku-vector
  [nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   ""  "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" nil]
  "*skk-zenkaku-insert ǻȤʸơ֥롣
б֤ʸ󤬤Сѥ⡼ɤǳΥ򲡤Ȥǡб
ʸ롣
ͤѹˡˤĤƤϡskk-input-vector 򻲾ȤΤȡ" )

(skk-defvar skk-use-face (and (string= "19" (substring emacs-version 0 2))
                              (fboundp 'make-face)
                              (fboundp 'make-overlay) )
  "*Non-nil ǤСEmacs 19  face εǽѤѴɽʤɤԤʤ" )

(skk-defvar skk-auto-insert-paren nil
  "*Non-nil ǤС2 ĤʸޤȤʸδ֤˥ư롣
㤨С\"\" ϤȤ \"\" ưŪξäδ֤
ư롣
ʸϡskk-auto-paren-string-alist ǻꤹ롣" )

(skk-defvar skk-auto-paren-string-alist
  '(("" . "") ("" . "") ("(" . ")") ("" . "")
    ("{" . "}")("" . "") ("" . "") ("" . "")
    ("[" . "]") ("" . "") ("" . "") ("" . "")
    ("\"" . "\"")("" . "")
    ;; skk-special-midashi-char-list ǤˤʤäƤʸϡ
    ;; skk-auto-paren-string-alist ˴ޤƤ롣
    ;;("<" . ">")
    )
  "*ưŪФˤʤʸϤ뤿Ϣۥꥹȡ
car ʸ줿Ȥ cdr ʸưŪ롣" )

(skk-defvar skk-japanese-message-and-error nil
  "*Non-nil ǤСSKK Υåȥ顼ܸɽ롣
nil ǤСѸɽ롣" )

(skk-defvar skk-insert-new-word-hook nil
  "*Ȥ˥뤵եå" )

(skk-defvar skk-map nil
  "*ʥ⡼ɤΥޥåס" )
(make-variable-buffer-local 'skk-map)

(skk-defvar skk-zenkaku-map nil
  "*ѥ⡼ɤΥޥåס" )
(make-variable-buffer-local 'skk-zenkaku-map)

(skk-defvar skk-abbrev-map nil
  "*SKK abbrev ⡼ɤΥޥåס" )
(make-variable-buffer-local 'skk-abbrev-map)

(skk-defvar skk-minibuff-map nil
  "*ߥ˥Хåեʸɤ߹ȤΥޥåס" )
(make-variable-buffer-local 'skk-minibuff-map)

(skk-defvar skk-jisyo-save-count 50
  "*ͤǤСβ񤬹줿Ȥ˼ưŪ˥֤롣
  nil ǤСΥȥ֤Ԥʤʤ" 
  'false )

(skk-defvar skk-setup-map-hook nil
  "*skk-setup-map ǥ뤵եå
skk-mode ˤ桼ȼΥϡΥեåѤƹԤʤȤ
ǽ" )

(skk-defvar skk-setup-minibuff-map-hook nil
  "*skk-setup-minibuff-map ǥ뤵եå
skk-minibuff-map ˤ桼ȼΥϡΥեåѤƹԤʤ
Ȥǽ" )

(skk-defvar skk-setup-zenkaku-map-hook nil
  "*skk-setup-zenkaku-map ǥ뤵եå
skk-zenkaku-map ˤ桼ȼΥϡΥեåѤƹԤʤ
Ȥǽ" )

(skk-defvar skk-setup-abbrev-map-hook nil
  "*skk-setup-abbrev-map ǥ뤵եå
skk-abbrev-map ˤ桼ȼΥϡΥեåѤƹԤʤ
Ȥǽ" )

(skk-defvar skk-byte-compile-init-file t
  "*Non-nil ǤСskk-mode ư skk-init-file Хȥѥ뤹롣
Τ˸ȡ

  (1)skk-init-file Хȥѥ뤷ե뤬ʤ
  (2)skk-init-file ȤΥХȥѥѥեӤơԤ
     Ȥ

 skk-init-file Хȥѥ뤹롣
nil ǤСskk-init-file ȤΥХȥѥѤߥեӤ 
skk-init-file ȤϡΥХȥѥѥեä" )

(skk-defvar skk-count-private-jisyo-candidates-exactly nil
  "*Non-nil ǤСEmacs λȤΤ˸Ŀͼθ롣
nil ǤС1 Ԥʣθ䤬äƤ 1 Ȥƿ롣
׻̤ϡskk-record-file ¸롣" )

(skk-defvar skk-compare-jisyo-size-when-saving t
  "*Non-nil ǤСskk-jisyo Υֻ˥ե륵ΥåԤʤ
󥻡֤ skk-jisyo Ⱥ󥻡֤褦Ȥ뼭ȤΥӤԤʤ
Ԥ礭Ȥ˥桼˥֤³뤫ɤγǧ롣"
  'false )

(skk-defvar skk-auto-start-henkan t
  "ñʸζڤ򼨤ʸǸˤ꼫ưŪѴ򳫻Ϥ롣
skk-auto-start-henkan-keyword-list ˤñʸζڤ򼨤ʸꤹ롣"
  'false )

(skk-defvar skk-auto-start-henkan-keyword-list
  '("" "" "" "" "" "" "" ""
    "" "" ")" ";" ":" "" "" "" ""
    "" "" "" "" "" "}" "]" "?" "."
    "," "!" )
;; ޤꥭɤ¿ʤȡ̾Ѵˤ롩
  "ưѴ򳫻Ϥ륭ɡ
ΥꥹȤǤʸȡSPC 򲡤ȤʤưŪѴ򳫻Ϥ롣" )

;;; -- internal variables
;; ---- global variables
;; buffer local variable Ȥ٤
(defvar skk-isearch-message nil
  "skk-isearch ؿ򥳡뤹뤿Υե饰
Non-nil ǤСskk-isearch-message ؿ򥳡뤹롣" )

(defvar skk-auto-start-henkan-keyword-tree nil
  "skk-auto-start-henkan-keyword-list  AVL ڤ˥ѥ뤷Ρ" )

(defconst skk-default-zenkaku-vector
  ;; note that skk-zenkaku-vector is a user variable.
  ;; skk.el  .emacs ʤɤǡskk-zenkaku-vector ̤ͤ桼
  ;; ľܽ񤤤ꡢskk.el ɸˤͤ aset ľܤäꤷʤ
  ;; default-value  skk-zenkaku-vector ˥뤳Ȥ
  ;; skk-default-zenkaku-vector ͤݻ뤳ȤǤ褦˾
  ;; ...
  [nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   ""  "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" nil]
  "skk-zenkaku-region ǻȤʸơ֥롣
\"ascii\" -> \"\" Τ褦ʸؤѴԤݤѤ롣" )

(defconst skk-kanji-len (length "")
  "ʸĹNEmacs Ǥ 2 ˡMule Ǥ 3 ˤʤ롣" )

(defconst skk-hankaku-alist
  '((161 . 32) ; ?\ 
    (170 . 33) ;?\!
    (201 . 34) ;?\"
    (244 . 35) ;?\#
    (240 . 36) ;?\$
    (243 . 37) ;?\%
    (245 . 38) ;?\&
    (199 . 39) ;?\'
    (202 . 40) ;?\(
    (203 . 41) ;?\)
    (246 . 42) ;?\*
    (220 . 43) ;?\+
    (164 . 44) ;?\,
    (221 . 45) ;?\-
    (165 . 46) ;?\.
    (191 . 47) ;?\/
    (167 . 58) ;?\:
    (168 . 59) ;?\;
    (227 . 60) ;?\<
    (225 . 61) ;?\=
    (228 . 62) ;?\>
    (169 . 63) ;?\?
    (247 . 64) ;?\@
    (206 . 91) ;?\[
    (239 . 92) ;?\\
    (207 . 93) ;?\]
    (176 . 94) ;?^ 
    (178 . 95) ;?\_
    (208 . 123) ;?\{
    (195 . 124) ;?\|
    (209 . 125) ;?\}
    (177 . 126) ;?\~
    (198 . 96)) ;?` 
  "ʸɤ 2 ܤΥХȤȤʸб ascii ʸ \(char\) ȤϢۥꥹȡ
skk-ascii-region ǻȤ롣Mule-2.3 źդ egg.el ꥳԡ" )

(defvar skk-prefix-tree nil
  "*skk-roma-kana-[aiue] γϢۥꥹȤΥǡ2 ʸʾΤΤ AVL ڡ
skk-kana-input ǡߤΥϤ skk-prefix ǤΤɤȽԤ
˻Ȥ롣" )
;; skk-roma-kana-[aiue]  buffer-local-variable ǤʤΤǡskk-prefix-tree 
;;  buffer-local-variable ˤɬפʤ
;;(make-variable-buffer-local 'skk-prefix-tree)

(defvar skk-mode-invoked nil
  "Non-nil ǤСEmacs ư skk-mode ưȤ򼨤" )

(defvar skk-kakutei-count 0
  "ѴꤷȤݻѿ
skk-record-file  \":\" ܤΥ󥿡" )

(defvar skk-touroku-count 0
  "ϿȤݻѿ
skk-record-file  \"Ͽ:\" ܤΥ󥿡" )

(defvar skk-mule (featurep 'mule)
  "Non-nil ǤСMule  SKK ѤƤ뤳Ȥ򼨤" )

(defvar skk-other-select-window-hook-func-list nil
  "SKK ư select-window-hook ͡ꥹȤȤݻ롣
 select-window-hook ѤƤˡͤ¸
skk-select-window-func ǰ˥뤹롣" )

(defvar skk-update-jisyo-count 0
  "򹹿
Υ󥿡ο skk-jisyo-save-count ʾȤʤäȤ˥桼Υ
ȥ֤Ԥʤ롣" )

;; ---- buffer local variables
;; <ե饰>
(defvar skk-mode nil
  "Non-nil ǤСȥХåեǸ skk-mode ưƤ뤳Ȥ򼨤" )
(make-variable-buffer-local 'skk-mode)

(defvar skk-j-mode nil
  "Non-nil ǤСSKK Ҥ餬ʤ뤤ϥʥ⡼ɤǤ뤳Ȥ򼨤" )
(make-variable-buffer-local 'skk-j-mode)

(defvar skk-katakana nil
  "Non-nil ǤХʥ⡼ɤǤ뤳Ȥ򼨤
\"(and (not skk-katakana) skk-j-mode))\"  t ǤСҤ餬ʥ⡼ɤǤ뤳
Ȥ򼨤" )
(make-variable-buffer-local 'skk-katakana)

(defvar skk-zenkaku nil
  "Non-nil ǤСѥ⡼ɤǤ뤳Ȥ򼨤" )
(make-variable-buffer-local 'skk-zenkaku)

(defvar skk-abbrev nil
  "Non-nil ǤСʸʤɤؤѴΤᡢascii ʸǤ뤳Ȥ򼨤" )
(make-variable-buffer-local 'skk-abbrev)

(defvar skk-okurigana nil
  "Non-nil ǤС겾̾ʬǤ뤳Ȥ򼨤" )
(make-variable-buffer-local 'skk-okurigana)

(defvar skk-henkan-on nil
  "Non-nil ǤС⡼ (ѴоݤʸΤΥ⡼) Ǥ뤳Ȥ򼨤" )
(make-variable-buffer-local 'skk-henkan-on)

(defvar skk-henkan-active nil
  "Non-nil ǤС⡼ (Ѵ) Ǥ뤳Ȥ򼨤" )
(make-variable-buffer-local 'skk-henkan-active)

(defvar skk-kakutei-flag nil
  "Non-nil ʤꤷɤ򸫤Ĥ֤Ǥ뤳Ȥؤ
skk-henkan, skk-search-kakutei-jisyo-file, skk-henkan-show-candidates,
skk-henkan-in-minibuff  skk-kakutei-save-and-init-variables ѹȤ
롣" )
(make-variable-buffer-local 'skk-kakutei-flag)

(defvar skk-exit-show-candidates nil
  "ߥ˥ХåեǸ򼡡ɽơ䤬ԤȤ non-nil Ȥʤ롣
ͤϥꥹȤǡcar  skk-henkan-show-candidate ؿ while 롼פ
򼨤ѿ loop ͤcdr ˺Ǹ˥ߥ˥Хåեɽ 1 
θ䷲κǸǤؤǥ롣
skk-henkan-show-candidates, skk-henkan-in-minibuff 
skk-kakutei-save-and-init-variables ѹȤ롣" )
(make-variable-buffer-local 'skk-exit-show-candidates)

;; <ޥå״Ϣ>
(defvar skk-org-mode-line-format nil
  "ȥХåե SKK ư mode-line-format
ͤ non-nil ǤСȥХåե skk-mode ˥뤵줿
Ȥ򼨤")
(make-variable-buffer-local 'skk-org-mode-line-format)

(defvar skk-current-local-map nil
  "ȥХåե SKK ư current-local-map")
(make-variable-buffer-local 'skk-current-local-map)

(defvar skk-emacs-local-map nil
  "SKK  ascii ⡼ɤǻѤ륭ޥåס
skk-kakutei-key  skk-kakutei դ¾ϡSKK ưΥޥåפ
Ʊ")
(make-variable-buffer-local 'skk-emacs-local-map)

;; <Ϣѿ>
(defvar skk-okuri-ari-min nil
  "SKK ͭꥨȥγ򼨤Хåեݥȡ")
(make-variable-buffer-local 'skk-okuri-ari-min)

(defvar skk-okuri-ari-max nil
  "SKK ͭꥨȥνλ򼨤Хåեݥȡ
skk-jisyo ΥХåեǤϼιɬפ뤿˥ޡ롣" )
(make-variable-buffer-local 'skk-okuri-ari-max)

(defvar skk-okuri-nasi-min nil
  "SKK ʤȥγ򼨤Хåեݥȡ
skk-jisyo ΥХåեǤϼιɬפ뤿˥ޡ롣" )
(make-variable-buffer-local 'skk-okuri-nasi-min)

;; <¾>
(defvar skk-mode-line nil
  "SKK Υ⡼ɤ򼨤⡼ɥ饤ʸ
skk-mode-string, skk-hirakana-mode-string, skk-katakana-mode-string
and skk-zenei-mode-string Τ줫롣" )
(make-variable-buffer-local 'skk-mode-line)

;; "" бȥ꤬ skk-roma-kana-[aiue] ˤ뤿ᡢ""  nil 
;; Ǥʤ
(defvar skk-prefix ""
  "Ϥ뤫ʤꤹ뤿Υץեå
Ϥ첻б skk-roma-kana-[aiue] ϢۥꥹȤǡ
skk-prefix 򥭡ˤϤ٤ʸꤵ롣
㤨С\"\" Τ褦 \"k\" ϤޤҲϤƤȤϡskk-prefix
ϡ\"k\" ǡμϤ줿첻 \"a\" б skk-roma-kana-a 
\"k\" 򥭡˻͡\"\" ⤷ \"\" Ϥ٤ʸȤʤ롣" )
(make-variable-buffer-local 'skk-prefix)

(defvar skk-henkan-start-point nil
  "ѴϥݥȤ򼨤ޡ" )
(make-variable-buffer-local 'skk-henkan-start-point)

(defvar skk-henkan-end-point nil
  "ѴλݥȤ򼨤ޡ" )
(make-variable-buffer-local 'skk-henkan-end-point)

(defvar skk-kana-start-point nil
  "ʸγϥݥȤ򼨤ޡ" )
(make-variable-buffer-local 'skk-kana-start-point)

(defvar skk-okurigana-start-point nil
  "겾̾γϥݥȤ򼨤ޡ" )
(make-variable-buffer-local 'skk-okurigana-start-point)

(defvar skk-henkan-key nil
  "Ѵ٤Ф졣
㤨С\"\" ѴСskk-henkan-key ˤ \"\" 롣
\"*\" Τ褦ꤢѴξˤϡ\"u\" Τ褦ˡʬ
ɤߤ + 겾̾κǽʸΥ޻Υץեå롣" )
(make-variable-buffer-local 'skk-henkan-key)

(defvar skk-okuri-char nil
  "Ѵ٤겾̾ʬΥץեå
㤨С\"*\" ѴȤϡskk-okuri-char  \"r\"
skk-okuri-char  non-nil ǤСꤢѴǤ뤳Ȥ򼨤" )
(make-variable-buffer-local 'skk-okuri-char)

(defvar skk-henkan-okurigana nil
  "ߤѴ겾̾ʬ
㤨С\"ޤ*\" ѴСskk-henkan-okurigana ˤ \"\" 
롣" )
(make-variable-buffer-local 'skk-henkan-okurigana)

(defvar skk-last-kakutei-henkan-key nil
  "꼭ˤǸ˳ꤷȤθФ졣
꼭ˤľ x 򲡤ȳ꤬ɥơξ֤
θФ줬ȥХåե롣" )
(make-variable-buffer-local 'skk-last-kakutei-henkan-key)

(defvar skk-henkan-list nil
  "Ѵ̤θΥꥹȡ
㤨С\"*\" ȤѴСskk-henkan-list 
(\"\" \"\" \"̵\" \"˴\") Τ褦ˤʤ롣" )
(make-variable-buffer-local 'skk-henkan-list)

(defvar skk-henkan-count -1
  "skk-henkan-list ΥꥹȤΥǥǸߤθ򺹤Ρ" )
(make-variable-buffer-local 'skk-henkan-count)

(defvar skk-self-insert-non-undo-count 1
  "skk-self-insert ʤɤϢ³Ϥʸɽ魯󥿡
Emacs ΥꥸʥưǤϡself-insert-command ˥Хɤ줿Ϥϡ
Ϣ³ 20 ޤǤ 1 ĤΥɥоݤȤʤ롣ư򥨥ߥ졼Ȥ뤿
󥿡
skk-self-insert ʳǤϡskk-abbrev-comma, skk-abbrev-period, skk-insert-a,
skk-insert-comma, skk-insert-e, skk-insert-i, skk-insert-period, skk-insert-u,
skk-kana-input, skk-set-henkan-point, skk-zenkaku-insert Τ줫Υޥ
Ϥ줿Ϣ³ϤȤư롣
Υ󥿡20 ʲǤȤϡϤΤӤ cancel-undo-boundary 
뤵롣" )
(make-variable-buffer-local 'skk-self-insert-non-undo-count)

(defvar skk-current-search-prog-list nil
  "skk-search-prog-list θߤͤ¸ꥹȡ
ǽѴ skk-search-prog-list ƤͤݻѴ򷫤֤Ӥ 1
ĤŤûʤäƤ椯" )
(make-variable-buffer-local 'skk-current-search-prog-list)

;; for skk-undo-kakutei
(defvar skk-last-henkan-key nil
  "skk-henkan-key κǸ͡skk-undo-kakutei ǻȤ롣" )
(make-variable-buffer-local 'skk-last-henkan-key)

(defvar skk-last-henkan-okurigana nil
  "skk-henkan-okurigana κǸ͡skk-undo-kakutei ǻȤ롣" )
(make-variable-buffer-local 'skk-last-henkan-okurigana)

(defvar skk-last-henkan-list nil
  "skk-henkan-list κǸ͡skk-undo-kakutei ǻȤ롣" )
(make-variable-buffer-local 'skk-last-henkan-list)

(defvar skk-last-okuri-char nil
  "skk-okuri-char κǸ͡skk-undo-kakutei ǻȤ롣" )
(make-variable-buffer-local 'skk-last-okuri-char)

;;;; macros
;; The followings were converted to macro to make them inline.
;; `defsubst' cannot be used for Emacs 18 compatibility (but it may be used by
;; special byte-compiler made by Jamie Zawinski).

(defmacro skk-change-mode-line (string)
  ;; ⡼ɥ饤 SKK ϥ⡼ɤɽ魯ʸ STRING ѹ롣
  (list 'progn (list 'setq 'skk-mode-line string)
        (list 'force-mode-line-update) ))

(defmacro skk-in-minibuffer-p ()
  ;; ȥХåեߥ˥Хåեɤå롣
  (if (fboundp 'window-minibuffer-p)
      (list 'window-minibuffer-p (list 'selected-window))
    (list 'eq (list 'selected-window) (list 'minibuffer-window)) ))

(defmacro skk-insert-prefix (&optional char)
  ;; skk-echo  non-nil ǤХȥХåե skk-prefix 롣
  (list 'if 'skk-echo
        ;; skk-prefix 򥢥ɥоݤȤʤץեåϡ
        ;; ʸƾõΤǡδ֡buffer-undo-list 
        ;; t ˤƥɥߤʤȤ꤬ʤ
        ;;
        ;; ǧϰϤǤϡEmacs 18.59  buffer-undo-list Ƥꡢ
        ;; Nemacs 3.3.2 Υ١Ȥʤä Emacs 18.53 ǤϡƤʤ
        ;; NEmacs for Macintosh Ǥϡ١ Emacs  18.59 ˤʤäƤ롣
        (list 'let (list (list 'buffer-undo-list t))
              (list 'insert (list 'or char 'skk-prefix)) )))

(defmacro skk-erase-prefix ()
  ;; skk-echo  non-nil ǤХȥХåե줿 skk-prefix 
  ;; 
  (list 'if 'skk-echo
        ;; skk-prefix ξõ򥢥ɥоݤȤʤ
        (list 'let (list (list 'buffer-undo-list t))
              (list 'delete-region 'skk-kana-start-point (list 'point) ))))

(defmacro skk-string<= (str1 str2)
  ;; str1  str2 Ӥơstring<  string= ǤСt ֤
  (list 'or (list 'string< str1 str2) (list 'string= str1 str2)) )

(defmacro skk-insert-o ()
  ;; skk-prefix 򥭡Ȥơskk-roma-kana-o  alist 椫Ŭڤʸ
  ;; 롣
  (list 'skk-insert 'skk-roma-kana-o) )

(defmacro skk-jis-char-p (char)
  ;; char  JIS ʸä t ֤
  (list '> char 127) )

(defmacro skk-alpha-char-p (char)
  ;; char  ascii ʸä t ֤
  (list '<= char 127) )

(defmacro skk-lower-case-p (char)
  ;; char ʸΥե٥åȤǤСt ֤
  (list 'and (list '<= ?a char)
        (list '>= ?z char) ))

(defmacro skk-message (japanese english &rest arg)
  ;; skk-japanese-message-and-error  non-nil ä JAPANESE  nil Ǥ
  ;;  ENGLISH 򥨥ꥢɽ롣
  ;; ARG  message ؿ裲ʹߤΰȤϤ롣
  (append (list 'message (list 'if 'skk-japanese-message-and-error
                               japanese english ))
          arg ))

(defmacro skk-error (japanese english &rest arg)
  ;; skk-japanese-message-and-error  non-nil ä JAPANESE  nil Ǥ
  ;;  ENGLISH 򥨥ꥢɽ顼ȯ롣
  ;; ARG  error ؿ裲ʹߤΰȤϤ롣
  (append (list 'error (list 'if 'skk-japanese-message-and-error
                               japanese english ))
          arg ))

(defmacro skk-yes-or-no-p (japanese english)
  ;; skk-japanese-message-and-error  non-nil ǤСjapanese  nil Ǥ
  ;;  english ץץȤȤ yes-or-no-p ¹Ԥ롣
  ;; yes-or-no-p ΰΥץץȤʣǤϤΥޥ
  ;; ꥪꥸʥ yes-or-no-p Ѥɤʣˤʤʤ礬
  ;; 롣
  (list 'yes-or-no-p (list 'if 'skk-japanese-message-and-error
                           japanese english )))

(defmacro skk-y-or-n-p (japanese english)
  ;; skk-japanese-message-and-error  non-nil ǤСjapanese  nil Ǥ
  ;;  english ץץȤȤ y-or-n-p ¹Ԥ롣
  (list 'y-or-n-p (list 'if 'skk-japanese-message-and-error
                        japanese english )))
;;;; mode setup

;;;###autoload
(defun skk-mode (&optional arg)
  "ܸϥ⡼ɡ
ޥʡ⡼ɤΰǡꥸʥΥ⡼ɤˤϱƶͿʤ
ΰͿ SKK ⡼ɤȴ롣"
  (interactive "P")
  (setq skk-mode
        (if skk-org-mode-line-format
            (cond ((null arg) (not skk-mode))
                  ;; -  -1 Ѵ롣
                  ((> (prefix-numeric-value arg) 0) t) )
          ;; if skk-mode has not been called in this buffer, always
          ;; enter skk-mode
          t ))
  (if (not skk-mode)
      ;; exit skk-mode
      (progn
        (let ((skk-mode t)) (skk-kakutei))
        (setq mode-line-format skk-org-mode-line-format)
        (setq skk-j-mode nil
              skk-abbrev nil
              skk-katakana nil
              skk-zenkaku nil )
        (skk-use-local-map skk-current-local-map)
        (force-mode-line-update) )
    ;; enter skk-mode
    (if (not skk-mode-invoked)
        ;; enter skk-mode for the first time in this session
        (progn
          (setq skk-mode-invoked t)
          (skk-setup-init-file)
          (load skk-init-file t)
          (if skk-keep-record
              (skk-create-file
               skk-record-file
               (if skk-japanese-message-and-error
                   "SKK εϿѥեޤ"
                 "I have created an SKK record file for you" )))
          (skk-create-file
           skk-jisyo (if skk-japanese-message-and-error
                         "SKK ζޤ"
                       "I have created an empty SKK Jisyo file for you" ))
          (skk-get-jisyo-buffer skk-jisyo 'nomsg)
          (if (not (boundp 'select-window-hook))
              ;; Nemacs Ǥϡselect-window-hook ƤʤΤǡ
              ;; skk-e18.el  skk-set-marker б롣
              nil
            (if (and select-window-hook
                     (not (eq select-window-hook 'skk-select-window-func) ))
                (setq skk-other-select-window-hook-func-list
                      ;;  select-window-hook ѤƤ顢ͤ
                      ;; ¸ skk-select-window-func ǰ˥뤹롣
                      (cons (symbol-value 'select-window-hook)
                            skk-other-select-window-hook-func-list )))
            (setq select-window-hook 'skk-select-window-func) )))
    ;;ʲ skk-mode 뤿Ӥ٥뤵륳ɡ
    ;;(if (boundp 'disable-undo)
    ;;    (make-local-variable 'disable-undo) )
    (if skk-use-vip (skk-vip-mode))
    (if (or (not skk-org-mode-line-format) (skk-in-minibuffer-p))
        ;; enter skk-mode for the first time in this buffer or the buffer
        ;; is the minibuffer
        (let ((map (if (skk-in-minibuffer-p) minibuffer-local-map
                     (current-local-map) )))
          ;; save current mode
          (setq skk-current-local-map (if map (copy-keymap map))
                skk-emacs-local-map (if map (copy-keymap map)
                                      (make-sparse-keymap) )
                skk-org-mode-line-format mode-line-format )
          (define-key skk-emacs-local-map skk-kakutei-key 'skk-kakutei)
          (skk-setup-map)
          (skk-setup-minibuff-map)
          ;; skk-mode ưƤȤɤʬʤޥåפϡȤȤ˥
          ;; ȥåפ롣
          ;;(skk-setup-zenkaku-map)
          ;;(skk-setup-abbrev-map)
          (skk-make-henkan-marker) ))
    (if (and (not (featurep 'skk-server))
             (or (and (boundp 'skk-server-host) skk-server-host)
                 (and (boundp 'skk-servers-list) skk-servers-list)
                 (getenv "SKKSERVER")
                 (getenv "SKKSERV") ))
        (require 'skk-server) )
    ;; 桼ѿ˴ؤΤϡ桼ġѿѹ뤫ͽ
    ;; ¬դʤΤǡskk-mode 뤿ӤꤷʤƤ롣
    (if (featurep 'skk-server)
        ;; skk-search-server ϥСƤȤΤǡʤ
        (skk-adjust-search-prog-list-for-server-search 'non-del) )
    (if skk-auto-okuri-process
        (skk-adjust-search-prog-list-for-auto-okuri) )
    (setq skk-prefix-tree (skk-compute-prefix-tree)
          skk-j-mode t
          skk-abbrev nil
          skk-katakana nil
          skk-zenkaku nil )
    (skk-setup-auto-start-henkan)
    (skk-setup-delete-selection-mode)
    (skk-setup-auto-paren)
    (skk-adjust-user-option)
    (if (skk-in-minibuffer-p)
        (skk-use-local-map skk-minibuff-map)
      (skk-use-local-map skk-map) )
    (define-key minibuffer-local-map
      (default-value 'skk-kakutei-key) 'skk-kakutei)
    (define-key minibuffer-local-map "\C-m" 'skk-newline)
    (define-key minibuffer-local-completion-map
      (default-value 'skk-kakutei-key) 'skk-kakutei)
    (define-key minibuffer-local-completion-map "\C-m" 'skk-newline)
    (define-key minibuffer-local-ns-map
      (default-value 'skk-kakutei-key) 'skk-kakutei)
    (define-key minibuffer-local-ns-map "\C-m" 'skk-newline)
    (setq mode-line-format
          (cons "" (cons 'skk-mode-line (cdr skk-org-mode-line-format))))
    (skk-change-mode-line skk-hirakana-mode-string)
    (run-hooks 'skk-mode-hook) ))

;;;###autoload
(defun skk-auto-fill-mode (&optional arg)
  "ܸϥ⡼ɡưޤ֤ǽդ
ޥʡ⡼ɤΰǡꥸʥΥ⡼ɤˤϱƶͿʤ
ΰͿȡŪ auto-fill-mode ڤ SKK ⡼ɤ롣
ΰͿ auto-fill-mode ڤ SKK ⡼ɤȴ롣"
  (interactive "P")
  (let ((auto-fill
         (cond ((null arg) (not auto-fill-function))
               ((> (prefix-numeric-value arg) 0) t) )))
    (auto-fill-mode (if auto-fill 1 -1))
    (skk-mode arg)
    (run-hooks 'skk-auto-fill-mode-hook) ))

(defun skk-setup-init-file ()
  ;; skk-byte-compile-init-file  non-nil ξǡskk-init-file Хȥ
  ;; ѥ뤷ե뤬¸ߤʤΥХȥѥѥե 
  ;; skk-init-file Ȥϡskk-init-file Хȥѥ뤹롣
  ;;
  ;; skk-byte-compile-init-file  nil ξǡskk-init-file Хȥ
  ;; 뤷ե skk-init-file ȤϡΥХȥѥ
  ;; ѥեä
  (save-match-data
    (let* ((init-file (expand-file-name skk-init-file))
           (elc (concat init-file 
                        (if (string-match "\\.el$" init-file)
                            "c"
                          ".elc" ))))
      (if skk-byte-compile-init-file
          (if (and (file-exists-p init-file)
                   (or (not (file-exists-p elc))
                       (file-newer-than-file-p init-file elc) ))
              (save-window-excursion ;; for keep window configuration.
                (skk-message "%s Хȥѥ뤷ޤ"
                             "Byte-compile %s"
                             skk-init-file )
                (sit-for 2)
                (byte-compile-file init-file) ))
        (if (and (file-exists-p init-file)
                 (file-exists-p elc)
                 (file-newer-than-file-p init-file elc) )
            (delete-file elc) )))))

(defun skk-setup-map ()
  ;; Ҥ餬/ʥ⡼ɤΥޥåפΥåȥåפԤʤ
  (setq skk-map (skk-convert-to-vector skk-emacs-local-map))
  (skk-define-map skk-map)
  (skk-setup-special-midashi-char skk-map)
  (run-hooks 'skk-setup-map-hook) )

(defun skk-setup-minibuff-map ()
  ;; ߥ˥ХåեΥޥåפΥåȥåפԤʤ
  (setq skk-minibuff-map (skk-convert-to-vector minibuffer-local-map))
  (skk-define-map skk-minibuff-map 'minibuffer)
  (skk-setup-special-midashi-char skk-minibuff-map)
  (run-hooks 'skk-setup-minibuff-map-hook) )

(defun skk-setup-zenkaku-map ()
  ;; ѱѻ⡼ɤΥޥåפΥåȥåפԤʤ
  (let ((minibuff (skk-in-minibuffer-p)))
    (setq skk-zenkaku-map (skk-convert-to-vector
                           (if minibuff minibuffer-local-map
                             skk-emacs-local-map )))
    (let ((i 0))
      (while (< i 128)
        (if (aref skk-zenkaku-vector i)
            (define-key skk-zenkaku-map (char-to-string i)
              'skk-zenkaku-insert ))
        (setq i (1+ i)) ))
    (or skk-use-vip
        (define-key skk-zenkaku-map "\M-Q" 'skk-backward-and-set-henkan-point) )
    (define-key skk-zenkaku-map "\C-q" 'skk-ascii-henkan)
    (run-hooks 'skk-setup-zenkaku-map-hook) ))

(defun skk-setup-abbrev-map ()
  ;; abbrev ⡼ɤΥޥåפΥåȥåפԤʤ
  (let ((minibuff (skk-in-minibuffer-p)))
    ;; skk-abbrev-map ˿륭ХɤϷ褷¿ʤ虜虜
    ;; vector  full keymap Ѵɬפʤ
    (setq skk-abbrev-map (copy-keymap (if minibuff minibuffer-local-map
                                        skk-emacs-local-map )))
    (define-key skk-abbrev-map "," 'skk-abbrev-comma)
    (define-key skk-abbrev-map "." 'skk-abbrev-period)
    (define-key skk-abbrev-map "\ " 'skk-start-henkan)
    (define-key skk-abbrev-map "\177" 'skk-delete-backward-char)
    (define-key skk-abbrev-map "\C-g" 'skk-keyboard-quit)
    (define-key skk-abbrev-map "\C-m" 'skk-newline)
    (define-key skk-abbrev-map "\C-q" 'skk-zenkaku-henkan)
    (or skk-use-vip
        (define-key skk-abbrev-map "\M-\ " 'skk-start-henkan-with-completion) )
    (define-key skk-abbrev-map "\t" 'skk-try-completion)
    (or minibuff (define-key skk-abbrev-map skk-kakutei-key 'skk-kakutei))
    (run-hooks 'skk-setup-abbrev-map-hook) ))

(defun skk-define-map (map &optional minibuff)
  ;; ޥå MAP ѤSKK ΥХɤΥåȥåפԤ
  ;; ץʥ MINIBUFF  non-nil ǤСߥ˥ХåեѤ
  ;; åȥåפԤ
  (define-key map "!" 'skk-self-insert)
  (define-key map "#" 'skk-self-insert)
  (define-key map "$" 'skk-display-code-for-char-at-point)
  (define-key map "%" 'skk-self-insert)
  (define-key map "&" 'skk-self-insert)
  (define-key map "'" 'skk-self-insert)
  (define-key map "*" 'skk-self-insert)
  (define-key map "+" 'skk-self-insert)
  (define-key map "," 'skk-insert-comma)
  (define-key map "-" 'skk-self-insert)
  (define-key map "." 'skk-insert-period)
  (define-key map "/" 'skk-abbrev-input)
  (define-key map "0" 'skk-self-insert)
  (define-key map "1" 'skk-self-insert)
  (define-key map "2" 'skk-self-insert)
  (define-key map "3" 'skk-self-insert)
  (define-key map "4" 'skk-self-insert)
  (define-key map "5" 'skk-self-insert)
  (define-key map "6" 'skk-self-insert)
  (define-key map "7" 'skk-self-insert)
  (define-key map "8" 'skk-self-insert)
  (define-key map "9" 'skk-self-insert)
  (define-key map ":" 'skk-self-insert)
  (define-key map ";" 'skk-self-insert)
  ;; "<", ">", "?"  3 ʸϡskk-special-midashi-char-list ͤǥե
  ;; ȤΤޤޤǤСskk-setup-special-midashi-char ˤ
  ;; skk-set-henkan-point ˺Ƴդ뤬ˤꤳʸꤷ
  ;; ʤϡskk-self-insert ȤưΤ˾ޤ
  (define-key map "<" 'skk-self-insert)
  (define-key map "=" 'skk-self-insert)
  (define-key map ">" 'skk-self-insert)
  (define-key map "?" 'skk-self-insert)
  (define-key map "@" 'skk-today)
  (define-key map "A" 'skk-set-henkan-point)
  (define-key map "B" 'skk-set-henkan-point)
  (define-key map "C" 'skk-set-henkan-point)
  (define-key map "D" 'skk-set-henkan-point)
  (define-key map "E" 'skk-set-henkan-point)
  (define-key map "F" 'skk-set-henkan-point)
  (define-key map "G" 'skk-set-henkan-point)
  (define-key map "H" 'skk-set-henkan-point)
  (define-key map "I" 'skk-set-henkan-point)
  (define-key map "J" 'skk-set-henkan-point)
  (define-key map "K" 'skk-set-henkan-point)
  (define-key map "L" 'skk-zenkaku-eiji)
  (define-key map "M" 'skk-set-henkan-point)
  (define-key map "N" 'skk-set-henkan-point)
  (define-key map "O" 'skk-set-henkan-point)
  (define-key map "P" 'skk-set-henkan-point)
  (define-key map "Q" 'skk-set-henkan-point-subr)
  (define-key map "R" 'skk-set-henkan-point)
  (define-key map "S" 'skk-set-henkan-point)
  (define-key map "T" 'skk-set-henkan-point)
  (define-key map "U" 'skk-set-henkan-point)
  (define-key map "V" 'skk-set-henkan-point)
  (define-key map "W" 'skk-set-henkan-point)
  (define-key map "X" 'skk-purge-from-jisyo)
  (define-key map "Y" 'skk-set-henkan-point)
  (define-key map "Z" 'skk-set-henkan-point)
  (define-key map "\ " 'skk-start-henkan)
  (define-key map "\"" 'skk-self-insert)
  (define-key map "\(" 'skk-self-insert)
  (define-key map "\)" 'skk-self-insert)
  (define-key map "\177" 'skk-delete-backward-char)
  ;; delsel.el ѻϡdelsel.el  minibuffer-keyboard-quit ؿ SKK 
  ;;  (skk-e19.el ǺٹƤ)
  (or (and minibuff (featurep 'delsel))
      (define-key map "\C-g" 'skk-keyboard-quit) )
  (define-key map "\C-m" 'skk-newline)
  (define-key map "\[" 'skk-self-insert)
  (define-key map "\\" 'skk-input-by-code-or-menu)
  (define-key map "\]" 'skk-self-insert)
  (or skk-use-vip
      (define-key map "\M-\ " 'skk-start-henkan-with-completion) )
  (or skk-use-vip
      (define-key map "\M-Q" 'skk-backward-and-set-henkan-point) )
  (define-key map "\t" 'skk-try-completion)
  (define-key map "\{" 'skk-self-insert)
  (define-key map "\}" 'skk-self-insert)
  (define-key map "^" 'skk-self-insert)
  (define-key map "_" 'skk-self-insert)
  (define-key map "`" 'skk-self-insert)
  (define-key map "a" 'skk-insert-a)
  (define-key map "b" 'skk-kana-input)
  (define-key map "c" 'skk-kana-input)
  (define-key map "d" 'skk-kana-input)
  (define-key map "e" 'skk-insert-e)
  (define-key map "f" 'skk-kana-input)
  (define-key map "g" 'skk-kana-input)
  (define-key map "h" 'skk-kana-input)
  (define-key map "i" 'skk-insert-i)
  (define-key map "j" 'skk-kana-input)
  (define-key map "k" 'skk-kana-input)
  (define-key map "l" (if minibuff 'skk-mode-off-in-minibuff 'skk-mode-off))
  (define-key map "m" 'skk-kana-input)
  (define-key map "n" 'skk-kana-input)
  (define-key map "o" 'skk-kana-input)
  (define-key map "p" 'skk-kana-input)
  (define-key map "q" 'skk-toggle-kana)
  (define-key map "r" 'skk-kana-input)
  (define-key map "s" 'skk-kana-input)
  (define-key map "t" 'skk-kana-input)
  (define-key map "u" 'skk-insert-u)
  (define-key map "v" 'skk-kana-input)
  (define-key map "w" 'skk-kana-input)
  (define-key map "x" 'skk-previous-candidate)
  (define-key map "y" 'skk-kana-input)
  (define-key map "z" 'skk-kana-input)
  (define-key map "|" 'skk-self-insert)
  (define-key map "~" 'skk-self-insert)
  (define-key map
    (if minibuff (default-value 'skk-kakutei-key) skk-kakutei-key)
    'skk-kakutei ))

(defun skk-emulate-original-map (arg)
  ;; ϤФơSKK Υ⡼ɤǤϤʤEmacs ΥꥸʥΥդ
  ;; ޥɤ¹Ԥ롣
  (let ((prefix-arg arg)
        (keys (skk-command-key-sequence (this-command-keys) this-command)) )
    (if (not keys)
        ;; no alternative commands.  may be invoked by M-x.
        nil
      (let (command local-map buf)
        (unwind-protect
            (progn
              (setq buf (current-buffer)
                    local-map (current-local-map) )
              (skk-use-local-map skk-emacs-local-map)
              (setq command (key-binding keys))
              (if (eq command this-command)
                  ;; avoid recursive calling of skk-emulate-original-map.
                  nil
                ;; if no bindings are found, call `undefined'.  it's
                ;; original behaviour.
                (skk-cancel-undo-boundary)
                (command-execute (or command (function undefined))) ))
          ;; restore skk keymap.
          (save-excursion
            (set-buffer buf)
            (skk-use-local-map local-map) ))))))

(defun skk-command-key-sequence (key command)
  ;; KEY  universal arguments COMMAND ¹Ԥ륭֤
  ;; `execute-extended-command' ˤäƥޥɤ¹Ԥ줿ϡnil ֤
  (while (not (or (zerop (length key))
                  (eq command (key-binding key))))
    (setq key (substring key 1)))
  (and (not (zerop (length key))) key))

(defun skk-setup-auto-start-henkan ()
  (if skk-auto-start-henkan
      (setq skk-auto-start-henkan-keyword-tree
            (skk-list-to-avltree skk-auto-start-henkan-keyword-list) )))

(defun skk-setup-special-midashi-char (map)
  ;; skk-special-midashi-char-list ˻ꤵ줿 char 򥭡ޥå MAP 
  ;; skk-set-henkan-point ˳դ롣skk-special-midashi-char-list ˻ꤵ
  ;; 줿 char ǡƬϤǽˤ뤿ν
  (let ((strlist (mapcar 'char-to-string skk-special-midashi-char-list))
        str )
    (while strlist
      (setq str (car strlist))
      (if (not (eq 'skk-set-henkan-point (lookup-key map str)))
          (define-key map str 'skk-set-henkan-point) )
      (setq strlist (cdr strlist)) )))

(defun skk-compute-prefix-tree ()
  ;; skk-roma-kana-[aiueo] γϢۥꥹȤΥ顢Ĺ 2 ʾΤΤ򽸤
  ;; uniq ֤
  (let ((KeysTree (skk-compute-prefix-tree-1
                   (avltree-create 'string<) skk-roma-kana-a )))
    (setq KeysTree (skk-compute-prefix-tree-1 KeysTree skk-roma-kana-i)
          KeysTree (skk-compute-prefix-tree-1 KeysTree skk-roma-kana-u)
          KeysTree (skk-compute-prefix-tree-1 KeysTree skk-roma-kana-e)
          KeysTree (skk-compute-prefix-tree-1 KeysTree skk-roma-kana-o) )
    KeysTree ))

(defun skk-compute-prefix-tree-1 (tree alist)
  ;; skk-compute-prefix-tree Υ֥롼ALIST γǤ car Ĺ 2
  ;; ʾʸǡĤޤ TREE ǤˤʤäƤʤΤ TREE ɲä 
  ;; TREE ֤
  (let (key)
    (while alist
      (setq key (car (car alist))
            alist (cdr alist) )
      (if (and (> (length key) 1)
               (not (avltree-member tree key)) )
          (avltree-enter tree key) ))
    tree ))

(defun skk-list-to-avltree (list)
  ;; ꥹȤ AVL ڤ˥ѥ뤷֤ꥹȤǤʸ˸¤롣
  (let ((tree (avltree-create 'string<)))
    (while list
      (avltree-enter tree (car list))
      (setq list (cdr list)) )
    tree ))

(defun skk-make-henkan-marker ()
  ;; ХåեͤǤ skk-henkan-start-point, skk-henkan-end-point,
  ;; skk-kana-start-point, skk-okurigana-start-point  nil ä顢줾
  ;; ޡä롣
  ;;
  ;; skk.el ΥХåեͤΰˤդ٤롣
  ;; 㤨СХåե Buffer A ǲΤ褦ʥեɾȤ롣
  ;; ---------- Buffer A ---------------+--------------- Buffer B ----------
  ;; (setq test (make-marker))          |
  ;;  -> #<marker in no buffer>         |
  ;;                                    |
  ;; (make-variable-buffer-local 'test) |
  ;;                                    |
  ;; test                               | test
  ;;  -> #<marker in no buffer>         |  -> #<marker in no buffer>
  ;;                                    |
  ;; (set-marker test (point))          |
  ;;                                    |
  ;; test                               | test
  ;;  -> #<marker at 122 in A>          |  -> #<marker at 122 in A>
  ;;
  ;; ХåեͤȤƤ򤹤 non-nil ͤ non-nil
  ;; ͤľܽѤ褦ʥեɾ Buffer B 鸫ǥե
  ;; ͤޤǽѤäƤޤ嵭ϥޡΤ褦˥ꥹȤФ
  ;; ˲ŪؿȤƱͤη̤Ȥʤ롣
  ;; ---------- Buffer A ---------------+--------------- Buffer B ----------
  ;; (setq test '(A B C))               |
  ;;  -> (A B C)                        |
  ;;                                    |
  ;; (make-variable-buffer-local 'test) |
  ;;                                    |
  ;; test                               | test
  ;;  -> (A B C)                        |  -> (A B C)
  ;;                                    |
  ;; (setcar test 'X)                   |
  ;;                                    |
  ;; test                               | test
  ;;  -> (X B C)                        |  -> (X B C)
  ;;
  ;; θݤǰֺΤϡϿʤɤǥߥ˥ХåեäȤ
  ;; (skk-henkan-show-candidate Τ褦ñˡ֥ꥢפѤؿǤ
  ;; طʤ) ˡȤΥХåեȥߥ˥ХåեȤǤϤ줾̤ѴԤʤ
  ;; Τ̤ǤΤǡ嵭Τ褦¾ΥХåեΥХåեͤޤǽ
  ;; ѤƤޤȡѴٻߤƤ¾ΥХåեѴǤʤʤ
  ;; 礬뤳ȤǤ롣
  ;;
  ;;  SKK Ǥϥꥫ֥ߥ˥ХåեѤǤΤǡ *Minibuf-0* 
  ;;  *Minibuf-1 δ (뤤Ϥäȿꥫ֥ߥ˥ХåեƱΤδ) ǥХ
  ;; եͤ˲ŪѤԤʤƤޤ̤Υߥ˥Хåե
  ;; ȤѴǤʤʤ礬롣
  ;;
  ;; ȤΤ褦˽ͤ nil ˤơХåեͤȤƤ塢
  ;; non-nil ͤСʸ夽ΥХåեͤ˲Ū򤷤Ƥ⤽
  ;; Хåե˸ͭͤѲʤ
  ;; ---------- Buffer A ---------------+--------------- Buffer B ----------
  ;; (setq test nil)                    |
  ;;                                    |
  ;; (make-variable-buffer-local 'test) |
  ;;                                    |
  ;; test                               | test
  ;;  -> nil                            |  -> nil
  ;;                                    |
  ;; (setq test (make-marker))          |
  ;;  -> #<marker in no buffer>         |
  ;;                                    |
  ;; (set-marker test (point))          |
  ;;                                    |
  ;; test                               | test
  ;;  -> #<marker at 122 in A>          |  -> nil
  ;;
  ;; skk.el 9.3 λǤϡskk-henkan-start-point, skk-henkan-end-point,
  ;; skk-kana-start-point ڤ skk-okurigana-start-point ν
  ;; (make-variable-buffer-local 뤵)  make-marker ֤
  ;; Ǥ #<marker in no buffer> ǤäΤǡꥫ֥ߥ˥Хåե
  ;; ѴȤ "" äʤʤɤΥȥ֥뤬äν
  ;; ͤ nil ˤ skk-mode ư줿Ȥ뤤ϥߥ˥Хåեä
  ;; ˡmake-marker ֤ͤ褦ˤ褷
  ;; 
  ;; δؿϡskk-mode (<(skk.el/skk-mode:3)>) ǥ뤵롣ʤߥ˥Х
  ;; եǤϡХåե skk-mode 뤵ʤȤ顢δؿ
  ;; ΰտޤƤȤåפƤޤбƤΤ
  ;; <(skk-e19.el/skk-set-marker,skk-select-window-func)> Ǥ롣
  (if (not skk-henkan-start-point)
      (setq skk-henkan-start-point (make-marker)) )
  (if (not skk-henkan-end-point)
      (setq skk-henkan-end-point (make-marker)) )
  (if (not skk-kana-start-point)
      (setq skk-kana-start-point (make-marker)) )
  (if (not skk-okurigana-start-point)
      (setq skk-okurigana-start-point (make-marker)) ))

(defun skk-setup-delete-selection-mode ()
  ;; Delete Selection ⡼ɤ SKK ȤäܸϤФƤⵡǽ褦
  ;; åȥåפ롣
  (if (and (featurep 'delsel)
           (not (get 'skk-delete-backward-char 'delete-selection)) )
      (progn
        (put 'skk-delete-backward-char 'delete-selection 'supersede)
        (mapcar (function (lambda (func) (put func 'delete-selection t)))
                '(skk-input-by-code-or-menu
                  skk-insert-a
                  skk-insert-comma
                  skk-insert-e
                  skk-insert-i
                  skk-insert-period
                  skk-insert-u
                  skk-kana-input
                  skk-newline
                  ;;skk-set-henkan-point-subr
                  skk-set-henkan-point
                  skk-self-insert
                  skk-today )))))

(defun skk-setup-auto-paren ()
  ;; skk-auto-paren-string-alist 椫顢skk-special-midashi-char-list
  ;; Ǥ˴ϢΤ
  ;; ޤskk-auto-paren-string-alist γǤ car ʸ ascii char Ǥ
  ;; ϡskk-input-vector γξ ( ascii char ɾ
  ;; ǥȤʤ) ˤʸ񤭹 ( ascii char 
  ;; skk-input-vector ˽ɬפʤskk-auto-paren-string-alist ˻ꤵ
  ;; 줿ФˤʤʸΤˤϡȤʤʸ񤤤Ƥɬפ)
  (if (null skk-auto-paren-string-alist)
      nil
    (let ((strlist (mapcar 'char-to-string skk-special-midashi-char-list))
          cell str alist )
      (while strlist
        (setq cell (assoc (car strlist) skk-auto-paren-string-alist))
        (if cell
            ;; assoc Ф cell ľܻꤷƤΤǡdelete ǤʤȤ
            ;; ס
            (setq skk-auto-paren-string-alist
                  (delq cell skk-auto-paren-string-alist) ))
        (setq strlist (cdr strlist)) )
      (setq alist skk-auto-paren-string-alist)
      (while alist
        (setq str (car (car alist)))
        (if (and (eq (length str) 1)
                 ;; ˥桼ꤷƤϡɤʸǤäƤ (
                 ;; ȤʤʸȤϰäƤƤ)⤷ʤ
                 (not (aref skk-input-vector (string-to-char str))) )
            (aset skk-input-vector (string-to-char str) str) )
        (setq alist (cdr alist)) ))))

(defun skk-adjust-user-option ()
  ;; ξΩǤʤץĴԤʤ
  (if skk-process-okuri-early
      ;; skk-process-okuri-early ͤ non-nil ǤȤ˲ͤ non-nil
      ;; ǤưʤΤǤѿ̤ͥ⤯
      (setq skk-kakutei-early nil
            skk-auto-okuri-process nil
            skk-henkan-okuri-strictly nil )))

(defun skk-keyboard-quit ()
  "⡼ɤǤСɽƢ⡼ɤ᤹ (ФϻĤ)
⡼ɤǤСФ롣
嵭ΤɤΥ⡼ɤǤʤ keyboard-quit Ʊư򤹤롣"
  (interactive)
  ;;(if (boundp 'disable-undo)
  ;;    (setq disable-undo nil) )
  (cond ((string= skk-henkan-key "") (skk-keyboard-quit-1))
        (skk-henkan-active
         (setq skk-henkan-count 0)
         (if (and skk-delete-okuri-when-quit skk-henkan-okurigana)
             (let ((count (/ (length skk-henkan-okurigana) skk-kanji-len)))
               (skk-previous-candidate)
               ;; Ǥ delete-backward-char Ϥʤ٥
               (delete-backward-char count) )
           (skk-previous-candidate) ))
        ((not skk-henkan-on) (skk-keyboard-quit-1))
        (t (if (> (point) skk-henkan-start-point)
               (delete-region (point) skk-henkan-start-point) )
           (skk-kakutei) )))

(defun skk-try-completion (arg)
  "⡼ɤǸФ䴰Ԥ
ʳΥ⡼ɤǤϡꥸʥΥդΥޥɤ򥨥ߥ졼Ȥ롣"
  (interactive "P")
  (if (and skk-henkan-on (not skk-henkan-active))
      (progn
        (setq this-command 'skk-completion)
        (skk-completion (not (eq last-command 'skk-completion))) )
    (skk-emulate-original-map arg) ))

(defun skk-mode-off ()
  "SKK Υ⡼ɤ ascii ⡼ɤѹ롣"
  (interactive)
  (skk-kakutei)
  (setq skk-j-mode nil
        skk-katakana nil
        skk-zenkaku nil )
  (skk-use-local-map skk-emacs-local-map)
  (skk-change-mode-line skk-mode-string) )

(defun skk-mode-off-in-minibuff ()
  "ߥ˥ХåեǡSKK Υ⡼ɤ ascii ⡼ɤѹ롣"
  (interactive)
  (skk-kakutei)
  (setq skk-j-mode nil
        skk-katakana nil
        skk-zenkaku nil )
  (skk-use-local-map minibuffer-local-map) )

(defun skk-zenkaku-eiji ()
  "SKK Υ⡼ɤѱѻϥ⡼ɤѹ롣"
  (interactive)
  (skk-kakutei)
  (setq skk-j-mode nil
        skk-katakana nil
        skk-zenkaku t )
  (skk-setup-zenkaku-map)
  (skk-use-local-map skk-zenkaku-map)
  (skk-change-mode-line skk-zenei-mode-string) )

(defun skk-abbrev-input ()
  "ascii ʸ򥭡ˤѴԤϥ⡼ɡ"
  (interactive "*")
  (if (and skk-henkan-on (not skk-henkan-active))
      (skk-error "ˢ⡼ɤäƤޤ" "Already in  mode") )
  (skk-kakutei)
  (skk-set-henkan-point-subr)
  (skk-setup-abbrev-map)
  (setq skk-abbrev t)
  (skk-use-local-map skk-abbrev-map) )

(defun skk-toggle-kana (arg)
  "Ҥ餬ʥ⡼ɤȥʥ⡼ɤȥڤؤ롣
ʥ⡼ɤѴԤʤȤˡ겾̾򥫥ʤѴʤȤϡ
μ ~/.emacs ˽񤯡

      \(put 'skk-convert-okurigana-into-katakana 'never-change t\)

⡼ɤǤϡskk-henkan-start-point (ľ) ȥδ֤ʸ

    Ҥ餬 <=> 
    ѱѿ <=> ascii

Τ褦Ѵ롣"
  (interactive "P")
  (cond ((and skk-henkan-on (not skk-henkan-active))
         (let (char)
           (save-excursion
             (goto-char skk-henkan-start-point)
             ;; "" Ǥʸ̤Ƚ̤ǤʤΤǡݥȤʤ롣
             (while (looking-at "")
               (skk-forward-char 1) )
             (setq char (skk-what-char-type)) )
           (cond ((eq char 'hirakana)
                  (skk-katakana-henkan arg) )
                 ((eq char 'katakana)
                  (skk-hiragana-henkan arg) )
                 ((eq char 'ascii)
                  (skk-zenkaku-henkan arg) )
                 ((eq char 'zenkaku)
                  (skk-ascii-henkan arg) ))))
        ((and (skk-in-minibuffer-p) (not skk-j-mode))
         ;; ߥ˥Хåեؤν
         (setq skk-mode t
               skk-j-mode t
               skk-katakana t
               skk-zenkaku nil ))
        (t (setq skk-katakana (not skk-katakana))) )
  (skk-kakutei) )

(defun skk-misc-for-picture ()
  ;; picture-mode äȤ SKK ưɬפʽԤʤ
  ;; edit-picture-hook  add-hook ƻѤ롣
  ;;
  ;; picture-mode  SKK ѤϤ򤷤ˡBS ʸäʤ
  ;; ΤϡSKK ԶǤϤʤpicture.el  (move-to-column-force ؿ
  ;; ǻѤƤ move-to-column ʸ̵뤷Ϳ
  ;; Ȥ˥ưǤʤ) Ǥ롣äʸ˥ݥȤ
  ;; C-c C-d ǰʸŤľäˡϤʤ
  (if skk-mode
      ;; SKK ưξ֤᤹
      (progn
        ;; picture-mode-old-local-map ˤϡskk-map äƤ롣
        (setq picture-mode-old-local-map skk-current-local-map)
        (skk-kill-local-variables) )))

(defun skk-kill-local-variables ()
  ;; SKK ϢΥХåեѿ̵ˤ롣
  ;; ¸ΥХåե picture mode ˤȤpicture-mode ؿ
  ;; kill-all-local-variables ؿƤФʤΤǡSKK ϢΥХåե
  ;; ѿΥХåեͤΤޤޤˤʤäƤޤǡpicture mode ä
  ;; Ȥ˥եåѤƤΥХåեѿ kill 롣
  ;; RMS  picture-mode  kill-all-local-variables ؿƤФʤΤϡХ
  ;; ǤϤʤȸäƤ
  (if (eq (nth 1 mode-line-format) 'skk-mode-line)
      (setq mode-line-format (delq 'skk-mode-line mode-line-format) ))
  (let ((lv (buffer-local-variables))
        v vstr )
    (while lv
      (setq v (car (car lv))
            lv (cdr lv)
            vstr (prin1-to-string v) )
      (if (and
           (> (length vstr) 3) (string= "skk-" (substring vstr 0 4)) )
          (kill-local-variable v) ))))

;;;; kana inputting functions

(defun skk-insert-a ()
  "\"\" ޤफʸϤԤ"
  (interactive "*")
  (skk-insert skk-roma-kana-a) )

(defun skk-insert-i ()
  "\"\" ޤफʸϤԤ"
  (interactive "*")
  (skk-insert skk-roma-kana-i) )

(defun skk-insert-u ()
  "\"\" ޤफʸϤԤ"
  (interactive "*")
  (skk-insert skk-roma-kana-u) )

(defun skk-insert-e ()
  "\"\" ޤफʸϤԤ"
  (interactive "*")
  (skk-insert skk-roma-kana-e) )

(defun skk-insert (table)
  ;; skk-prefix 򥭡ȤơϢۥꥹ TABLE ʸõϤ롣
  (let ((char (assoc skk-prefix table)))
    (if (null char)
        (progn
          ;; skk-prefix not found in the table
          (setq skk-prefix "")
          (skk-unread-event last-command-char) )
      (if (and skk-henkan-active skk-kakutei-early
               (not skk-process-okuri-early) )
          (skk-kakutei) )
      (skk-insert-str (if skk-katakana (nthcdr 2 char) (nth 1 char)))
      (if skk-okurigana
          (skk-set-okurigana)
        (setq skk-prefix "") )
      (if (not skk-henkan-on) (skk-do-auto-fill)) )))

(defun skk-insert-str (str)
  ;; skk-insert Υ֥롼STR 롣ɬפǤ
  ;; self-insert-after-hook 򥳡뤹롣overwrite-mode ǤСŬڤ˾
  ;; Ԥδؿϡskk-vip.el Ǿ񤭤 
  ;; (<(skk-vip.el/skk-insert-str)>)
  (skk-cancel-undo-boundary)
  (skk-insert-and-inherit str)
  (if (and skk-henkan-on (not skk-henkan-active))
      (if (and skk-auto-start-henkan (not skk-okurigana))
          (skk-auto-start-henkan str) )
    (if (and (boundp 'self-insert-after-hook) self-insert-after-hook)
        (funcall self-insert-after-hook (- (point) (length str)) (point)) )
    (if overwrite-mode
        (skk-del-char-with-pad (skk-ovwrt-len (string-width str))) )))

(defun skk-auto-start-henkan (str)
  ;; skk-auto-start-henkan-keyword-list ǤʸȤ˼ưŪ 
  ;; (ڡǸʤȤ) Ѵ򳫻Ϥ롣ߥեȼҤ MSDOS   
  ;; FEPWX2+ 
  (if (avltree-member skk-auto-start-henkan-keyword-tree str)
      (save-excursion
        (skk-backward-char 1)
        (if (> (point) skk-henkan-start-point)
            (let ((skk-prefix ""))
              (skk-start-henkan (prefix-numeric-value current-prefix-arg)) )))))

(defun skk-ovwrt-len (len)
  ;; 񤭤ɤĹ֤
  ;; δؿϡskk-vip.el Ǿ񤭤 (<(skk-vip.el/skk-ovwrt-len)>)
  (min (string-width
        (skk-buffer-substring (point) (save-excursion (end-of-line) (point))) )
       len ))

(defun skk-del-char-with-pad (length)
  ;; Ĺ LENGTH ʸõ롣ĴΤᡢɬפǤС˥ڡ
  ;; 롣
  (let ((p (point)) (len 0))
    (while (< len length)
      (forward-char 1)
      (setq len (string-width (skk-buffer-substring (point) p))))
    (delete-region p (point))
    (or (eq length len)
        (progn
          (insert " ")
          (backward-char 1)))))

(if (not (boundp 'buffer-undo-list))
    ;; buffer-undo-list Ƥʤ Emacs ѡEmacs 18.59  Emacs 
    ;; Ǥ buffer-undo-list Ƥʤ (NEmacs 3.3.2  simple.el  
    ;; undo ؿʤɤ򸫤Ƥ buffer-undo-list ƤˤϤʤäƤ
    ;; ʤ褦) 
    (progn
      ;; Dummy functions
      (defun cancel-undo-boundary ())
      (defun skk-cancel-undo-boundary ()) )

  ;; UNIX Ѥ NEmacs  Demacs 1.2.x Ǥϡ١Ȥʤ Emacs  18.55 ΤϤ
  ;; NEmacs for Macintosh ǤϡEmacs 18.59 ١ˤʤäƤꡢ
  ;; mule-util.el ǽƼ줿 cancel-undo-boundary ϼƤʤ
  ;; buffer-undo-list ϼƤꡢcancel-undo-boundary 뤳Ȥǡ
  ;; ɥޤξٹǽǤ롣
  ;; mule-19.33-gamma Ǥϡcancel-undo-boundary ʤ    
  ;; from mule-util.el
  (if (not (fboundp 'cancel-undo-boundary))
      (defun cancel-undo-boundary ()
        ;; buffer-undo-list  car  nil äundo ޥɤľΥХåե
        ;; ѹǻߤޤʤ褦ˤ롣buffer-undo-list ˤ nil ϡ
        ;; ѹζ򼨤ǥߥƯ򤷤Ƥ롣
        (if (and (consp buffer-undo-list)
                 ;; car  nil ä餽ä
                 (null (car buffer-undo-list)) )
            (setq buffer-undo-list (cdr buffer-undo-list)) )))

  (defun skk-cancel-undo-boundary ()
    ;; skk-insert-[aiue], skk-insert-comma, skk-insert-period, skk-kana-input,
    ;; skk-self-insert, skk-set-henkan-point, skk-zenkaku-insert Ϣ³
    ;; 줿 20 ʸ 1 ΥɥоݤȤ롣`20'  keyboard.c 
    ;; 줿ޥåʥСMule-2.3 źդ egg.el 򻲹ͤˤ
    (if (and (< skk-self-insert-non-undo-count 20)
             (memq last-command
                   '(
                     ;; SKK abbrev ⡼ɤǤϡʸϤ Emacs ꥸ
                     ;;  self-insert-command ˤԤʤƤΤǡ
                     ;; skk-self-insert-non-undo-count 򥤥󥯥Ȥ뤳
                     ;; ǤʤΤǡɥ򥨥ߥ졼ȤǤʤ
                     ;; ⡢ޤԥꥪɤǡ
                     ;; skk-abbrev-comma  skk-abbrev-period ȤȤˤʤ
                     ;; ǡꥸʥΥɥεǽ»ʤäƤޤ
                     ;; ȤƤϡSKK abbrev ⡼ɤϾάȤƤθФ
                     ;; 뤿Υ⡼ɤǤΤǡĹФ뤳
                     ;; Ϥޤʤ⾮ȹͤ롣
                     ;;skk-abbrev-comma
                     ;;skk-abbrev-period
                     skk-insert-a
                     skk-insert-comma
                     skk-insert-e
                     skk-insert-i
                     skk-insert-period
                     skk-insert-u
                     skk-kana-input
                     skk-self-insert
                     ;;skk-set-henkan-point
                     skk-zenkaku-insert )))
        (progn
          (cancel-undo-boundary)
          (setq skk-self-insert-non-undo-count
                (1+ skk-self-insert-non-undo-count) ))
      (setq skk-self-insert-non-undo-count 1) )))

(defun skk-kana-input-event-type (event)
  ;; "Return type of EVENT for `skk-kana-input'."
  (cond ((and (integerp event)
              (<= 0 event) (< event (length skk-char-type-vector)))
         ;; this is normal ascii keystroke event
         (aref skk-char-type-vector event))
        ;; if you want to perform delete by event other than ascii
        ;; keystroke event, following clause should be modified to
        ;; return type 5 when apropriciate.
        (t nil)))

(defun skk-kana-input ()
  "ʸϤԤ롼
\"o\" ʸϡ\"oh\" ̤ \"\" Ѵ뤿ˡδؿƤӽФ
\(skk-insert-* ؿ˥ХɤƤʤ\)"
  (interactive "*")
  (if (and skk-henkan-active
           skk-kakutei-early (not skk-process-okuri-early) )
      (skk-kakutei) )
  (let ((char (char-to-string last-command-char))
        ;; don't echo key strokes in the minibuffer.
        (echo-keystrokes 0)
        (cont t) )
    (if skk-isearch-message (skk-isearch-message))
    (if (and (eq last-command-char 111) ; ?o
             (null (if (and (boundp 'skk-rom-kana-rule-tree)
                            skk-rom-kana-rule-tree )
                       (skk-assoc-tree (concat skk-prefix char)
                                       skk-rom-kana-rule-tree )
                     (cdr (assoc (concat skk-prefix char)
                                 skk-rom-kana-rule-list )))))
        (progn
          (skk-insert-o)
          (if skk-isearch-message
              (progn
                (skk-isearch-message)
                (setq cont nil) )
            ;; thus you must type `oota' instead of `ohta' when inputting
            ;; isearch string
            (setq skk-prefix char)
            (skk-set-marker skk-kana-start-point (point))))
      (setq skk-prefix char)
      (skk-set-marker skk-kana-start-point (point))
      (skk-insert-prefix) )
    (condition-case nil
        (while cont
          (let* ((raw-event (skk-read-char))
                 ;; ascii equivallence of raw-event or nil.
                 (r-char (skk-ascify-event raw-event))
                 (input nil)
                 (prefix nil)
                 (next nil))
            (if (integerp r-char)
                (progn
                  (if (and skk-henkan-on (not skk-henkan-active)
                           ;; we must distinguish the two cases where
                           ;; SKK-ECHO is on and off
                           (= skk-henkan-start-point
                              (if skk-echo (1- (point)) (point)) )
                           (< 64 r-char) (< r-char 91) )
                      ;; this case takes care of the rare case where
                      ;; one types two characters in upper case
                      ;; consequtively.  For example, one sometimes
                      ;; types "TE" when one should type "Te"
                      (setq r-char (+ 32 r-char)
                            raw-event r-char ))
                  (setq input (char-to-string r-char)
                        prefix (concat skk-prefix input)
                        next (if (and (boundp 'skk-rom-kana-rule-tree)
                                      skk-rom-kana-rule-tree )
                                 (skk-assoc-tree prefix
                                                 skk-rom-kana-rule-tree )
                               (cdr (assoc prefix skk-rom-kana-rule-list)) ))))
            (if skk-isearch-message (skk-isearch-message))
            (if next
                (let ((newprefix (car next))
                      (output (nth 1 next)) )
                  (skk-erase-prefix)
                  (if output
                      (progn
                        (skk-insert-str
                         (if skk-katakana (car output) (cdr output)))
                        (if skk-okurigana (skk-set-okurigana))))
                  (if newprefix
                      (progn
                        (skk-set-marker skk-kana-start-point (point))
                        (skk-insert-prefix newprefix)
                        (setq skk-prefix newprefix))
                    (setq cont nil
                          skk-prefix "" )))
              (let ((type (skk-kana-input-event-type (or r-char raw-event))))
                (cond ((string= skk-prefix "n")
                       (cond ((eq type 3) ; 첻
                              (skk-erase-prefix)
                              (setq cont nil)
                              (skk-unread-event raw-event))
                             ((eq r-char 121) ;?y
                              (setq skk-prefix prefix)
                              (skk-insert-prefix ?y) )
                             ((and skk-okurigana (eq r-char 32))
                              (skk-unread-event ?n) )
                             (t
                              (skk-erase-prefix)
                              (skk-insert-str (if skk-katakana "" ""))
                              (skk-set-marker skk-kana-start-point (point))
                              (setq cont nil
                                    skk-prefix "")
                              (skk-unread-event raw-event))))
                      ((string= skk-prefix "o")
                       (if (eq r-char 104) ;?h
                           (progn
                             (setq skk-prefix prefix)
                             (skk-insert-prefix "h") )
                         (skk-erase-prefix)
                         (setq cont nil
                               skk-prefix "")
                         (skk-unread-event raw-event)))
                      ((string= skk-prefix "oh")
                       (if (eq type 3)  ; 첻
                           (progn
                             (skk-erase-prefix)
                             (setq cont nil
                                   skk-prefix "h")
                             (skk-unread-event raw-event))
                         (skk-erase-prefix)
                         (skk-insert-str (if skk-katakana "" ""))
                         (setq cont nil
                               skk-prefix "")
                         (skk-unread-event raw-event)))
                      ((and input (string= input skk-prefix) (eq type 1))
                       (skk-erase-prefix)
                       (skk-insert-str (if skk-katakana "" ""))
                       (skk-set-marker skk-kana-start-point (point))
                       (skk-insert-prefix r-char) )
                      ;; skk-roma-kana-[aiue] ¸ߤ륭ɤ
                      ((avltree-member skk-prefix-tree prefix)
                       ;; Ϥ첻ưꤵ롣
                       (setq skk-prefix prefix)
                       (skk-insert-prefix input) )
                      ((eq type 3)      ; 첻
                       (skk-erase-prefix)
                       (setq cont nil)
                       ;; skk-insert-[aiue] 
                       (skk-unread-event raw-event))
                      ((eq type 4)      ; skk-set-henkan-point
                       ;; we assume that we can set r-char to
                       ;; last-command-char since type is 4.
                       (let ((last-command-char r-char))
                         (skk-erase-prefix)
                         (skk-set-henkan-point) ))
                      ((eq type 5)      ; delete prefix
                       (setq cont nil)
                       (if skk-okurigana
                           (progn
                             (skk-delete-okuri-mark)
                             (skk-set-marker skk-kana-start-point
                                         skk-okurigana-start-point )))
                       (or (string= skk-prefix "")
                           (if skk-echo
                               (skk-erase-prefix)
                             (skk-message "ץեå \"%s\" äޤ"
                                          "Deleted prefix \"%s\""
                                          skk-prefix )))
                       (setq skk-prefix "") )
                      (t
                       (skk-erase-prefix)
                       (skk-set-marker skk-kana-start-point nil)
                       (setq cont nil
                             skk-prefix "")
                       (skk-unread-event raw-event) ))))))
      (quit
       (if (string= skk-prefix "o")
           (skk-keyboard-quit)
         (setq skk-prefix "")
         (skk-erase-prefix)
         (skk-set-marker skk-kana-start-point nil)
         (ding) )))))

(defun skk-set-okurigana ()
  ;; Ф줫 skk-henkan-okurigana, skk-henkan-key γͤ򥻥åȤ롣
  (if skk-katakana
      (skk-hiragana-region skk-henkan-start-point (point)) )
  (skk-set-marker skk-henkan-end-point skk-okurigana-start-point)
  ;; just in case
  (save-excursion
    (goto-char skk-okurigana-start-point)
    (if (not (eq (following-char) 42)) ;?*
        (insert "*") ))
  (setq skk-henkan-okurigana (skk-buffer-substring
                              (1+ skk-okurigana-start-point)
                              (point) )
        skk-henkan-key (concat (skk-buffer-substring skk-henkan-start-point
                                                     skk-henkan-end-point )
                               skk-okuri-char )
        skk-prefix "" )
  (delete-region skk-okurigana-start-point (1+ skk-okurigana-start-point))
  (setq skk-henkan-count 0)
  (skk-henkan)
  (setq skk-okurigana nil)
  (cancel-undo-boundary) )

;;;; other inputting functions

(defun skk-insert-period (count)
  "Ф䴰ԤäƤǤСθɽ롣
䴰ľǤʤС\".\" 롣
SKK abbrev ⡼ɤǤϡskk-abbrev-period ؿѤ뤳ȡ"
  (interactive "*P")
  (if (and (eq last-command 'skk-completion) (not skk-henkan-active))
      (progn
        (setq this-command 'skk-completion)
        (skk-completion nil) )
    (skk-self-insert count) ))

(defun skk-insert-comma (count)
  "Ф䴰ԤäƤǤСľθɽ롣
䴰ľǤʤС\",\" 롣
SKK abbrev ⡼ɤǤϡskk-abbrev-comma ؿѤ뤳ȡ"
  (interactive "*P")
  (if (and (eq last-command 'skk-completion) (not skk-henkan-active))
      (skk-previous-completion)
    (skk-self-insert count) ))

(defun skk-abbrev-period (arg)
  "SKK abbrev ⡼ɤǸФ䴰ԤäƤǤСθɽ롣
䴰ľǤʤСꥸʥΥդΥޥɤ򥨥ߥ졼Ȥ롣
SKK abbrev ⡼ɰʳǤϡskk-insert-period ؿѤ뤳ȡ"
  (interactive "*P")
  (if (eq last-command 'skk-completion)
      (progn
        (setq this-command 'skk-completion)
        (skk-completion nil) )
    (skk-emulate-original-map arg) ))

(defun skk-abbrev-comma (arg)
  "SKK abbrev ⡼ɤǸФ䴰ԤäƤǤСľθɽ롣
䴰ľǤʤСꥸʥΥդΥޥɤ򥨥ߥ졼Ȥ롣
SKK abbrev ⡼ɰʳǤϡskk-insert-comma ؿѤ뤳ȡ"
  (interactive "*P")
  (if (eq last-command 'skk-completion)
      (skk-previous-completion)
    (skk-emulate-original-map arg) ))

(defun skk-self-insert (arg)
  "Ҥ餬ʡʡ⤷ ascii ʸ򥫥ȥХåե롣
Ҥ餬ʥ⡼ɤ⤷ϥʥ⡼ɤǤϡskk-input-vector ơ֥Ȥơ
ǸϤ줿бʸ롣
ascii ⡼ɤǤϡϤ򤽤Τޤ롣
skk-auto-insert-paren ͤ non-nil ξǡskk-auto-paren-string-alist 
бʸ󤬤Ȥϡбʸ (ä) ưŪ롣"
  (interactive "*P")
  (let ((str (aref skk-input-vector last-command-char)))
    ;; Overlay ä˳ꤹ롣
    (if skk-henkan-active (skk-kakutei))
    (if (not str)
        (skk-emulate-original-map arg)
      (let* ((count (prefix-numeric-value arg))
             (count2 count)
             (pair-str
              (and skk-auto-insert-paren
                   (cdr (assoc str skk-auto-paren-string-alist)) ))
             (pair-str-inserted 0) )
        (while (> count 0)
          (skk-insert-str str)
          (setq count (1- count)) )
        (if (not pair-str)
            nil
          (while (> count2 0)
            (if (not (string= pair-str (char-to-string (following-char))))
                (progn
                  (setq pair-str-inserted (1+ pair-str-inserted))
                  (skk-insert-str pair-str) ))
            (setq count2 (1- count2)) )
          (if (not (eq pair-str-inserted 0))
              (backward-char pair-str-inserted) ))))))

(defun skk-zenkaku-insert (arg)
  "ʸ򥫥ȥХåե롣
skk-zenkaku-vector ơ֥ȤơǸϤ줿бʸ
롣
skk-auto-insert-paren ͤ non-nil ξǡskk-auto-paren-string-alist 
бʸ󤬤Ȥϡбʸ (ä) ưŪ롣"
  (interactive "*p")
  (let* ((str (aref skk-zenkaku-vector last-command-char))
         (arg2 arg)
         (pair-str
          (and skk-auto-insert-paren
               (cdr (assoc str skk-auto-paren-string-alist)) ))
         (pair-str-inserted 0) )
    (while (> arg 0)
      (skk-insert-str str)
      (setq arg (1- arg)) )
    (if (not pair-str)
        nil
      (while (> arg2 0)
        (if (not (string= pair-str (char-to-string (following-char))))
            (progn
              (setq pair-str-inserted (1+ pair-str-inserted))
              (skk-insert-str pair-str) ))
        (setq arg2 (1- arg2)) )
      (if (not (eq pair-str-inserted 0))
          (backward-char pair-str-inserted) ))))

(defun skk-newline (arg)
  "Ԥ롣 ARG ꤹȡοʬԤ롣"
  (interactive "*p")
  ;; skk-kakutei ¹Ԥ skk-henkan-on ̵ͤ nil ˤʤΤǡ
  ;; ¸Ƥɬפ롣
  (let ((no-newline (and skk-egg-like-newline skk-henkan-on)))
    (cond ((skk-in-minibuffer-p)
           (if skk-mode
               (skk-kakutei) )
           (if no-newline
               nil
             ;; skk-kakutei ȡskk-mode ưƤʤߥ˥Хåե
             ;; Ǥϡskk-mode ư졢skk-j-mode  t ˤʤ롣
             ;; Minibuffer ˺ƤȤϡkill-all-local-variables 
             ;; ΤǡǽʤȤ skk-j-mode  t Τޤ޻Ĥ
             ;; Ƥ뤳ȤϤʤ
             ;;(setq skk-j-mode nil)
             ;;(setq skk-katakana nil)
             (exit-minibuffer) ))
          (t
           (if (skk-kakutei)
               ;; skk-do-auto-fill ˤäƹԤޤ֤줿 arg  1 ĸ
               ;; 
               (setq arg (1- arg)) )
           (if no-newline
               nil
             ;; ְϤƤư  raw ְѴϤ
             ;; Ƥߤ褦
             (setq arg (cond ((eq arg 1) nil)
                             ((eq arg -1) '-)
                             (t (cons arg nil))))
             (skk-emulate-original-map arg) )))))

(defun skk-delete-backward-char (count) ;(count &optional killp)
  "ߤΥݥȤä COUNT ʸõ롣"
  ;; δؿϡskk-vip.el Ǿ񤭤 
  ;; (<(skk-vip.el/skk-delete-backward-char)>)
  ;; Ƥޤȡ⡼ɤ BS 򲡤ȲΤꤹ뤳Ȥʤ֢פ
  ;; Ƥޤ
  ;;(interactive "*p\nP")
  (interactive "*P")
  ;;(if skk-okurigana
  ;;    (skk-delete-okuri-mark) )
  (if (and skk-henkan-on (>= skk-henkan-start-point (point)))
      (progn
        (setq skk-henkan-count 0)
        (skk-kakutei) )
    (if skk-henkan-active
        (if (and (not skk-delete-implies-kakutei)
                 (= skk-henkan-end-point (point)) )
            (skk-previous-candidate)
          ;;(if skk-use-face (skk-henkan-face-off))
          ;; overwrite-mode ʸʸ˰Ϥޤ졢ľʸʸ
          ;; ǤݥȤ delete-backward-char ȤȡʸϾä
          ;; Ⱦʸʬ backward ˥ݥȤʤ (Emacs 19.31 
          ;; ˤƳǧ)ѴθФƤ delete-backward-char ɬ
          ;; ʸ 1 ʸʬ backward äɤ
          (if overwrite-mode
              (progn
                (backward-char (prefix-numeric-value count))
                (delete-char (prefix-numeric-value count)) )
            ;;(delete-backward-char count killp)
            (delete-backward-char (prefix-numeric-value count) count) )
          (if (>= skk-henkan-end-point (point))
              (skk-kakutei)
            ;; skk-kakutei-early  nil ä顢ؤäƤ롣
            ;;(if skk-use-face (skk-henkan-face-on))
            ))
      ;; θФФƤ delete-backward-char ɬʸ 1 ʸ
      ;; ʬ backward äɤ
      (if (and skk-henkan-on overwrite-mode)
          (progn
            (backward-char (prefix-numeric-value count))
            (delete-char (prefix-numeric-value count)) )
        (if (skk-in-minibuffer-p)
            ;;(delete-backward-char count killp)
            (delete-backward-char (prefix-numeric-value count) count)
          (skk-emulate-original-map count) )))))

;;;; henkan routines
(defun skk-henkan ()
  ;; ʤѴᥤ롼
  (let (mark new-word kakutei-henkan)
    (if (string= skk-henkan-key "")
        (skk-kakutei)
      (if (not (eobp))
          ;; we use mark to go back to the correct position after henkan
          (setq mark (save-excursion (forward-char 1) (point-marker))) )
      (if (not skk-henkan-active)
          (progn
            (skk-change-marker)
            (setq skk-current-search-prog-list skk-search-prog-list) ))
      ;; skk-henkan-1 椫饳뤵 skk-henkan-show-candidate  throw
      ;; 롣ǥåϡ?x ȥ꡼ᤵƤΤǡ
      ;; δؿФơskk-previous-candidates ؤ椯
      (catch 'unread
        (setq new-word (or (skk-henkan-1) (skk-henkan-in-minibuff))
              kakutei-henkan skk-kakutei-flag )
        (if new-word (skk-insert-new-word new-word)) )
      (if mark
          (progn
            (goto-char mark)
            ;; ȤƤʤޡϡGarbage Collection 뤵줿
            ;; ˲뤬ޤǤδ֡ƥȤΤɤؤƤȡ
            ;; ƥȤΥåץǡȤκݤˤΥޡͤ򹹿ɬפ
            ;; Τǡɤؤʤ褦ˤ롣
            (skk-set-marker mark nil)
            ;; overwite-mode ΤȤ˳ѴԤʤä backward-char ᤹
            ;; ɬפʤΡ
            (if (not (and overwrite-mode kakutei-henkan))
                (backward-char 1) ))
        (goto-char (point-max)) ))))

(defun skk-henkan-1 ()
  ;; skk-henkan Υ֥롼
  (let (new-word)
    (if (eq skk-henkan-count 0)
        (progn
          (if (and (eq last-command 'skk-undo-kakutei-henkan)
                   (eq (car (car skk-current-search-prog-list))
                       'skk-search-kakutei-jisyo-file ))
              ;; in this case, we should not search kakutei jisyo.
              (setq skk-current-search-prog-list
                    (cdr skk-current-search-prog-list) ))
          (setq skk-henkan-list (skk-search))
          (if (null skk-henkan-list)
              nil
            (if skk-use-numeric-conversion
                (setq skk-henkan-list (skk-numeric-convert skk-henkan-list)) )
            (setq new-word (car skk-henkan-list))
            (if skk-kakutei-flag
                ;; found the unique candidate in kakutei jisyo
                (setq this-command 'skk-kakutei-henkan
                      skk-last-kakutei-henkan-key skk-henkan-key ))))
      ;; Ѵ 1 ʾΤȤ
      (setq new-word (nth skk-henkan-count skk-henkan-list))
      (if (not new-word)
          ;; 򸫤Ĥ뤫skk-current-search-prog-list ˤ
          ;; ޤ skk-search Ϣ³ƥ뤹롣
          (while (and skk-current-search-prog-list (not new-word))
            ;; ǡskk-numeric-convert 򥳡뤹ɬפʤϤ
            ;; ꥢɥʤɡʤѴ 1 ˤ skk-henkan 
            ;; ؿ⤢Τǡǰΰ٥뤷Ƥ
            (setq skk-henkan-list (skk-nunion skk-henkan-list (skk-search)))
            (if skk-use-numeric-conversion
                (setq skk-henkan-list (skk-numeric-convert skk-henkan-list)) )
            (setq new-word (nth skk-henkan-count skk-henkan-list)) ))
      (if (and new-word (> skk-henkan-count 3))
          ;; show candidates in minibuffer
          (setq new-word (skk-henkan-show-candidates) )))
    new-word ))

(defun skk-henkan-show-candidates ()
  ;; ߥ˥ХåեѴ䷲ɽ롣
  (save-excursion
    (let* ((candidate-keys   ; ɽѤΥꥹ
            (mapcar (function (lambda (c) (char-to-string (upcase c))))
                    skk-henkan-show-candidates-keys ))
           key-num-alist   ; ѤϢۥꥹ
           (key-num-alist1 ; key-num-alist ȤΩƤ뤿κϢۥꥹȡ
            (let ((count 6))
              (mapcar (function (lambda (key) (prog1 (cons key count)
                                                (setq count (1- count)) )))
                      ;; դޤˤƤơɽοʤä
                      ;; ƬĤ롣
                      (reverse skk-henkan-show-candidates-keys) )))
           (loop 0)
           inhibit-quit
           henkan-list new-one str reverse n )
      ;; ǰΤᡣΤΤˤĤƤϡskk-previous-candidate 
      ;; ȡ
      (if skk-use-face (skk-henkan-face-off))
      (delete-region skk-henkan-start-point skk-henkan-end-point)
      (while loop
        (if str
            (let (message-log-max)
              (message str) )
          (cond (reverse
                 (setq loop (1- loop)
                       henkan-list (nthcdr (+ 4 (* loop 7)) skk-henkan-list)
                       reverse nil ))
                (skk-exit-show-candidates
                 ;; 䤬ԤƤޤäơskk-henkan-show-candidates ->
                 ;; skk-henkan-in-minibuff -> skk-henkan
                 ;; -> skk-henkan-show-candidates νǡƤӤδؿƤФ
                 ;; Ȥϡ henkan-list  loop ׻롣
                 (setq henkan-list (nthcdr skk-henkan-count skk-henkan-list)
                       loop (car skk-exit-show-candidates)
                       skk-exit-show-candidates nil ))
                (t
                 ;; skk-henkan-show-candidates-keys κǽΥб
                 ;; ФƤޤǥ³롣
                 (while (and skk-current-search-prog-list
                             (null (nthcdr (+ 11 (* loop 7))
                                           skk-henkan-list )))
                   (setq skk-henkan-list
                         (skk-nunion skk-henkan-list (skk-search)) ))
                 (setq henkan-list (nthcdr (+ 4 (* loop 7))
                                           skk-henkan-list ))))
          (setq n (skk-henkan-show-candidate-subr candidate-keys henkan-list)) )
        (if (> n 0)
            (condition-case nil
                (let ((char (skk-read-char))
                      num )
                  (if (not (integerp char))
                      (progn
                        (skk-message "\"%s\" ͭʥǤϤޤ"
                                     "\"%s\" is not valid here!"
                                     (prin1 char) ) ; Emacs 18 does not have `%S'. 
                        (sit-for 1) )
                    (setq key-num-alist (nthcdr (- 7 n) key-num-alist1))
                    (if (null key-num-alist)
                        nil
                      (setq num (cdr (or (assq char key-num-alist)
                                         (if (skk-lower-case-p char)
                                             (assq (upcase char) key-num-alist)
                                           (assq (downcase char) key-num-alist) )))))
                    (cond (num
                           (setq new-one (nth num henkan-list)
                                 skk-henkan-count (+ 4 (* loop 7) num)
                                 skk-kakutei-flag t
                                 loop nil
                                 str nil ))
                          ((eq char 32)
                           (if (or skk-current-search-prog-list
                                   (nthcdr 7 henkan-list) )
                               (setq loop (1+ loop)
                                     str nil )
                             ;; 䤬Ԥδؿȴ롣
                             (let ((last-showed-index (+ 4 (* loop 7))))
                               (setq skk-exit-show-candidates
                                     ;; cdr ϡϿ˺Ǹɽ
                                     ;; ䷲Ǻǽθؤǥ
                                     (cons loop last-showed-index) )
                               ;; Ͽ롣skk-henkan-count 
                               ;; skk-henkan-list κǸθμ (¸ߤʤ
                               ;; --- nil )ؤ
                               (setq skk-henkan-count (+ last-showed-index n)
                                     loop nil
                                     str nil ))))
                          ((eq char 120) ; ?x
                           (if (eq loop 0)
                               ;; skk-henkan-show-candidates Ƥξ֤
                               ;; 
                               (progn
                                 (setq skk-henkan-count 4)
                                 (skk-unread-event ?x)
                                 ;; skk-henkan ޤǰ쵤 throw 롣
                                 (throw 'unread nil) )
                             ;; θ䷲򥨥ꥢɽ롣
                             (setq reverse t
                                   str nil )))
                          (t (skk-message "\"%c\" ͭʥǤϤޤ"
                                          "\"%c\" is not valid here!"
                                          char )
                             (sit-for 1) ))))
              (quit
               ;; skk-previous-candidate 
               (setq skk-henkan-count 0)
               (skk-unread-event ?x)
               ;; skk-henkan ޤǰ쵤 throw 롣
               (throw 'unread nil) )))) ; end of while loop
      new-one )))

(defun skk-henkan-show-candidate-subr (keys candidates)
  ;; key  candidates Ȥ߹碌 7 İʲθ䷲ (­ʤä
  ;; Ǥڤ) ʸꡢߥ˥Хåեɽ롣
  (let ((n 0) str cand
        message-log-max )
    (if (not (car candidates))
        nil
      (setq n 1
            ;; ǽθ˶򤯤äĤʤ褦˺ǽθ˼
            ;; Ф
            str (concat (car keys) ":" (skk-%-to-%% (car candidates))) )
      ;; Ĥ 6 ĤФȸδ֤ǤĤʤ
      (while (and (< n 7) (setq cand (nth n candidates)))
        (setq cand (skk-%-to-%% cand)
              str (concat str "  " (nth n keys) ":" cand)
              n (1+ n) ))
      (message "%s  [Ĥ %d%s]"
               str (length (nthcdr n candidates))
               (make-string (length skk-current-search-prog-list) ?+) ))
    ;; ɽ֤
    n ))

(defun skk-%-to-%% (str)
  ;; STR  % ޤʸä顢%% ˤ message ǥ顼ˤʤʤ褦
  ;; ˤ롣
  (let ((tail str)
        temp beg end )
    (save-match-data
      (while (string-match "%+" tail)
        (setq beg (match-beginning 0)
              end (match-end 0)
              temp (concat temp (substring tail 0 beg)
                           (make-string (* 2 (- end beg)) ?%) )
              tail (substring tail end) ))
      (concat temp tail) )))

(defun skk-henkan-in-minibuff ()
  ;; ߥ˥ХåեǼϿ򤷡Ͽȥʸ֤
  (save-match-data
    (let ((enable-recursive-minibuffers t)
          ;; Ѵ isearch message Фʤ褦ˤ롣
          skk-isearch-message new-one )
      ;;(current-buffer) ; for debugging.
      (skk-setup-minibuff-map)
      (condition-case nil
          (setq new-one
                (read-from-minibuffer
                 (concat (or (if skk-use-numeric-conversion
                                 (skk-numeric-midasi-word) )
                             (if skk-okuri-char
                                 (skk-compute-henkan-key2)
                               skk-henkan-key ))
                         " " )
                 nil skk-minibuff-map ))
        (quit
         (setq new-one "") ))
      ;;(current-buffer) ; for debugging.
      (if (string= new-one "")
          (if skk-exit-show-candidates
              ;; ߥ˥Хåեɽ䤬ԤƼϿäʸ
              ;; Ͽ줿硣Ǹ˥ߥ˥Хåեɽ䷲ɽ
              ;; 롣
              (progn
                (setq skk-henkan-count (cdr skk-exit-show-candidates))
                (skk-henkan) )
            ;; skk-henkan-show-candidates ˸䤬Ԥ
            (setq skk-henkan-count (1- skk-henkan-count))
            (if (eq skk-henkan-count -1)
                (progn
                  ;; ꤢѴǼϿꡢʸϿ塢
                  ;; ޤ޺ʤȤѴ 
                  ;; skk-henkan-okurigana, skk-okuri-char ͤ nil ˤʤ
                  ;; С줾ͤ˸Ť겾̾äޤޤǸ˼
                  ;; 롣
                  (setq skk-henkan-okurigana nil
                        skk-okurigana nil
                        skk-okuri-char nil )
                  (skk-change-marker-to-white) )
              ;; skk-henkan-count  -1 ǤʤСȥХåեǤϺǸ
              ;; ɽޤޤʤΤ (ɽϢǤϲ⤷ʤƤ⡢⤦
              ;; ˾ߤξ֤ˤʤäƤ) ⤷ʤ
              ))
        ;; ߥ˥ХåեѴʸ󤬤 (ʸǤʤ) Ȥ
        ;; ζ
        (if (string-match "[ ]+$" new-one)
            (setq new-one (substring new-one 0 (match-beginning 0))) )
        (if skk-use-numeric-conversion
            (setq new-one (skk-adjust-henkan-data-for-numerals new-one))
          (setq skk-kakutei-flag t) )
        ;; θ䤬ˡκǸ˿äΤ
        ;; ä...
        (setq skk-henkan-list (nconc skk-henkan-list (list new-one))
              ;; ե饰򥪥ˤ롣
              skk-henkan-in-minibuff-flag t
              skk-touroku-count (1+ skk-touroku-count) ))
      ;; (nth skk-henkan-count skk-henkan-list)  nil 鼭Ͽ
      ;; äƤ롣skk-henkan-count 򥤥󥯥ȤɬפϤʤ
      ;; (setq skk-henkan-count (1+ skk-henkan-count))
      ;; new-one ʸä nil ֤
      (if (not (string= new-one "")) new-one) )))

(defun skk-compute-henkan-key2 ()
  ;; skk-henkan-okurigana  non-nil ʤ skk-henkan-key 顢Ĥ 
  ;; skk-henkan-key2 ȸƤФƤΤ롣
  ;; skk-henkan-key2 Ȥϡִʬɤ + "*" + 겾̾פηʸ
  ;; 
  (if skk-henkan-okurigana
      (save-match-data
        (if (string-match "[a-z]+$" skk-henkan-key)
            (concat (substring skk-henkan-key 0 (match-beginning 0))
                    "*" skk-henkan-okurigana )))))
              
(defun skk-previous-candidate ()
  "⡼ɤǤСθɽ롣
⡼ɰʳǤϥȥХåե \"x\" 롣
꼭ˤľ˸Ƥ֤ȳ꤬ɥơξ֤
skk-last-kakutei-henkan-key ȥХåե롣"
  (interactive)
  (if (not skk-henkan-active)
      (if (not (eq last-command 'skk-kakutei-henkan))
          (skk-kana-input)
        ;; restore the state just before the last kakutei henkan.
        (delete-region skk-henkan-start-point (point))
        (skk-set-henkan-point-subr)
        (if skk-use-numeric-conversion
            (setq skk-last-kakutei-henkan-key
                  (skk-compute-noconv-henkan-key
                   skk-last-kakutei-henkan-key )))
        (insert skk-last-kakutei-henkan-key)
        (setq this-command 'skk-undo-kakutei-henkan) )
    (if (string= skk-henkan-key "")
        nil
      ;; Ƥơ delete-backward-char ȤäƾäˡǤϡ
      ;; overwrite-mode ΤȤˤζäʤ skk-henkan ǹԤʤä
      ;; ˡƱΤȤ
      ;;(insert " ")
      (let ((mark
             (if (not (eobp))
                 (save-excursion (forward-char 1) (point-marker)) )))
        (save-excursion
          (if (eq skk-henkan-count 0)
              (progn
                (if skk-use-numeric-conversion
                    (setq skk-henkan-key (skk-compute-noconv-henkan-key
                                          skk-henkan-key )))
                (if skk-okuri-char
                    ;; roman prefix for okurigana should be removed.
                    (setq skk-henkan-key (substring skk-henkan-key 0 -1)) )
                (setq skk-henkan-count -1
                      skk-henkan-list nil
                      skk-henkan-okurigana nil
                      skk-okuri-char nil
                      skk-okurigana nil
                      skk-prefix "" )
                (if skk-auto-okuri-process
                    (skk-init-auto-okuri-variables) )
                (if skk-use-numeric-conversion
                    (skk-init-numeric-conversion-variables) )
                ;; Emacs 19.28 ȲΤ Overlay äƤʤȡ
                ;; insert  skk-henkan-key Overlay äƤޤ
                (if skk-use-face (skk-henkan-face-off))
                (delete-region skk-henkan-start-point skk-henkan-end-point)
                (goto-char skk-henkan-end-point)
                (insert skk-henkan-key)
                (skk-change-marker-to-white) )
            (setq skk-henkan-count (1- skk-henkan-count))
            (skk-insert-new-word (nth skk-henkan-count skk-henkan-list)) ))
        ;;(if (and (> (point) 1) (eq (char-after (1- (point))) 32))
        ;; delete-backward-char Ǥϡoverwrite-mode ΤȤľζä
        ;; ʤ
        ;;    (delete-backward-char 1) )
        (if mark
            (progn
              (goto-char mark)
              (skk-set-marker mark nil)
              (backward-char 1) )
          (goto-char (point-max)) )
        (if (and skk-abbrev (eq skk-henkan-count -1))
            (skk-use-local-map skk-abbrev-map) )))))

(defun skk-insert-new-word (word)
  ;; ФäξѴ̤ʸ롣
  (let (func)
    ;; ǰΤᡣΤΤˤĤƤϡskk-previous-candidate 򻲾
    (if skk-use-face (skk-henkan-face-off))
    (delete-region skk-henkan-start-point skk-henkan-end-point)
    (goto-char skk-henkan-start-point)
    ;; (^_^;) Τ褦ʸФФread-from-string Ƥ֤ȥ顼ˤʤ
    ;; ǡcondition-case ǤΥ顼ޤ롣
    (condition-case nil
        (setq func (car (read-from-string word)))
      (error (setq func word)))
    ;; symbolp  nil ֤褦ñsymbolp ǥå뤳̵
    ;; ʤ fboundp ǥåȡ顼ˤʤ롣
    ;; e.x. "(#0)"
    (condition-case nil
        (if (and (listp func) (symbolp (car func)) (fboundp (car func)))
            (insert (eval func))
          (insert word) )
      ;; ʸ֤ʤ Lisp ץɾƤ⥨顼ˤʤʤ
      (error nil) )
    (skk-set-marker skk-henkan-end-point (point))
    (if skk-kakutei-flag
        ;; ꤷƤɤ (꼭˸򸫤Ĥ硢ϿԤä硢
        ;; 뤤ϥߥ˥Хåե򤷤) Τʤ顢Overlay ˤ
        ;; ɽѹˤΤޤ޳ꡣ
        (skk-kakutei word)
      (if skk-use-face
          (skk-henkan-face-on) ))
    (run-hooks 'skk-insert-new-word-hook) ))

(defun skk-kakutei (&optional word)
  "ɽƤǳꤷιԤ
ץʥ WORD ϤȡɽƤȤ̵ط WORD ǳ
ꤹ롣"
  ;; read only ǥ顼ˤʤ褦ˤ read only Хåե SKK ưǤ
  ;; ʤʤ롣
  (interactive)
  (let ((inhibit-quit t)
        kakutei-word )
    ;;(point) ;; for debugging
    (if skk-mode
        (progn
          (skk-change-mode-line (if skk-katakana skk-katakana-mode-string
                                  skk-hirakana-mode-string))
          ;; פʤϤǰΤᡢȤȤʤĤ...
          (if (skk-in-minibuffer-p)
              (progn
                (skk-setup-minibuff-map)
                (skk-use-local-map skk-minibuff-map) )
            (skk-use-local-map skk-map) )
          (setq skk-j-mode t
                skk-zenkaku nil ))
      ;; ȥХåեǤޤ skk-mode 뤵Ƥʤä顢뤹
      ;; 롣
      (skk-mode 1) )
    (if (not skk-henkan-on)
        nil
      (if (not skk-henkan-active)
          nil
        (setq kakutei-word
              (cond 
               ;; 꼭θǳꤷȤϡˤθ񤭹ɬפ
               ;; ɬפʤȻפäƤ䴰ԤʤȤϡ
               ;; Ŀͼ򻲾Ȥ (꼭ϻȤʤ) Τǡ¿񸻤Ȼ
               ;; ̵֤̤ˤƤ⡢Ŀͼ˳꼭Υȥ񤭹ǹ
               ;; ⤷Ƥ
               ;; ǸѴѴǤ뤫ɤΥե饰ꡢѴ
               ;; ä skk-completion ˤơskk-completion-word  
               ;; skk-last-henkan-key ȥޥå뤫ɤåޥå
               ;; ȤϸĿͼ򸡺 c-word  skk-last-henkan-key
               ;; ˡͤ㤨С
               ;;
               ;;   ֹ忧פȤγѴ --> ¸פȤ
               ;;   Ѵ
               ;;;
               ;; Ȥ褦ư򤷤ˡ֤㤯礯礦
               ;; 䴰ˤȻפäƤ⡢¸פѴ̾ѴǤ
               ;; ˡǸѴѴǤ뤫ɤΥե饰˥
               ;; ˤƤޤäƤꡢ֤פǽθȤ䴰
               ;; skk-last-henkan-key 򻲾ȤĿͼ򸡺ˤ椯Τ (ֹ
               ;; 忧פĿͼ˽񤭹ޤƤʤСθ
               ;; Ǥʤ)䴰ư줬ʤʤΤǤޤ
               ;;((and skk-kakutei-flag (listp skk-kakutei-flag))
               ;;nil )
               ((and skk-use-numeric-conversion (boundp 'skk-num-list)
                     skk-num-list )
                ;; ѴξϡѴʸ ("#1" ʤ) Ǽ񹹿
                ;; ʤʤФʤʤΤǡѴϡХåե
                ;; ʸǤϤʤskk-noconv-henkan-list  kakutei-word 
                ;; Фɬפ롣
                ;; program Ѵ skk-num-list ѤΤ򼭽Ͽ뤿
                ;; ˤϰʲΤ褦ѹɬפ.
                (or (skk-noconv-kakutei-word) word) )
               (word)
               ;; (nth -1 '(A B C)) ϡA ֤ΤǡǤʤɤå
               ;; 롣
               ((> skk-henkan-count -1)
                (nth skk-henkan-count skk-henkan-list) )))
        (if kakutei-word
            (progn
              (skk-update-jisyo kakutei-word)
              (if skk-use-numeric-conversion
                  (skk-update-jisyo-for-numerals kakutei-word) ))))
      (skk-kakutei-cleanup-henkan-buffer) )
    (skk-kakutei-save-and-init-variables kakutei-word)
    (skk-do-auto-fill) ))

(defun skk-kakutei-cleanup-henkan-buffer ()
  ;; ľΥХåեԤʤ
  ;; δؿϡskk-vip.el Ǿ񤭤 
  ;; (<(skk-vip.el/skk-kakutei-cleanup-henkan-buffer)>)
  ;; (point) ;; for debugging.
  (if skk-okurigana
      (progn
        (skk-delete-okuri-mark)
        (if (and skk-katakana skk-convert-okurigana-into-katakana)
            (skk-katakana-region skk-henkan-end-point (point)) )))
  (skk-delete-henkan-markers)
  (if (and (boundp 'self-insert-after-hook) self-insert-after-hook)
      (funcall self-insert-after-hook skk-henkan-start-point (point)) )
  (if overwrite-mode
      (skk-del-char-with-pad
       (skk-ovwrt-len
        (string-width
         (skk-buffer-substring skk-henkan-start-point (point)) )))))

(defun skk-kakutei-save-and-init-variables (&optional kakutei-word)
  ;; ѿνȥɥΤѿ¸Ԥʤ
  (if (and kakutei-word (not (string= kakutei-word "")))
      (progn
        ;; skk-undo-kakutei Τ˺ǸѴΥǡ¸롣
        (setq skk-last-henkan-key skk-henkan-key
              ;; ꤷƬˤ skk-henkan-list ͤ¸롣
              skk-last-henkan-list (cons kakutei-word
                                         (delete kakutei-word
                                                 skk-henkan-list ))
              skk-last-henkan-okurigana skk-henkan-okurigana
              skk-last-okuri-char skk-okuri-char
              skk-kakutei-count (1+ skk-kakutei-count) )
        ;;(if (boundp 'disable-undo)
        ;;    (setq disable-undo nil)
        ))
  ;;(if (not isearch-mode)
  ;;    (setq skk-isearch-message nil) )
  (setq skk-abbrev nil
        skk-exit-show-candidates nil
        skk-henkan-active nil
        skk-henkan-count -1
        skk-henkan-key nil
        skk-henkan-list nil
        skk-henkan-okurigana nil
        skk-henkan-on nil
        skk-kakutei-flag nil
        skk-okuri-char nil
        skk-prefix "" )
  (if skk-auto-okuri-process
      (skk-init-auto-okuri-variables) )
  (if skk-use-numeric-conversion
      (skk-init-numeric-conversion-variables) ))

(defun skk-undo-kakutei ()
  "ֺǸγ򥢥ɥФФɽ롣
Ǹ˳ꤷȤθϥåפ롣
䤬¾ˤʤȤϡߥ˥ХåեǤμϿ롣"
  (interactive)
  (cond ((eq last-command 'skk-undo-kakutei)
         (skk-error "ꥢɥϢ³ѤǤޤ"
                    "Cannot undo kakutei repeatedly" ))
        (skk-henkan-active
         (skk-error "⡼ɤǤϳꥢɥǤޤ"
                    "Cannot undo kakutei in  mode" ))
        ((skk-in-minibuffer-p)
         (skk-error "ߥ˥ХåեǤϳꥢɥǤޤ"
                    "Cannot undo kakutei in minibuffer" ))
        ((or (not skk-last-henkan-key) (string= skk-last-henkan-key ""))
         ;; skk-last-henkan-key may be nil or "".
         (skk-error "ɥǡޤ" "Lost undo data") ))
  (condition-case nil
      (let ((end (if skk-last-henkan-okurigana
                     (+ (length skk-last-henkan-okurigana)
                        skk-henkan-end-point )
                   skk-henkan-end-point )))
        (setq skk-henkan-active t
              skk-henkan-key skk-last-henkan-key
              skk-henkan-list skk-last-henkan-list
              skk-henkan-on t
              skk-henkan-okurigana skk-last-henkan-okurigana
              skk-okuri-char skk-last-okuri-char
              skk-current-search-prog-list
              (if (eq (car (car skk-search-prog-list))
                      'skk-search-kakutei-jisyo-file )
                  ;; 꼭õƤ̵̣
                  (cdr skk-search-prog-list)
                skk-search-prog-list ))
        (if (>= (point-max) end)
            ;; ǸѴʬΥƥȤä겾̾İƤΤʤ 
            ;; (skk-process-okuri-early  non-nil ʤ겾̾İǤʤ)
            ;; 겾̾ޤ᤿ʬޤǤä
            (delete-region skk-henkan-start-point end) )
        (goto-char skk-henkan-start-point)
        (cancel-undo-boundary)
        (insert "")
        (undo-boundary)
        (skk-set-marker skk-henkan-start-point (point))
        (if skk-okuri-char
            ;; ꤢ
            (progn
              (insert (substring skk-henkan-key 0
                                 (1- (length skk-henkan-key)) ))
              (skk-set-marker skk-henkan-end-point (point))
              (if skk-henkan-okurigana (insert skk-henkan-okurigana)) )
          (insert skk-henkan-key)
          (skk-set-marker skk-henkan-end-point (point)) )
        ;; ޤ
        (skk-message "ꥢɥ" "Undo kakutei!")
        (setq skk-henkan-count 1)
        (skk-henkan) )
    ;; skk-kakutei-undo ȴϡƼե饰Ƥʤ
    ;; ȼư򤷤褦ȤȤ˥顼ˤʤ롣
    (error (skk-kakutei))
    (quit (skk-kakutei)) ))
     
(defun skk-set-henkan-point (&optional arg)
  "Ѵ򳫻ϤݥȤޡб skk-prefix 첻Ϥ롣"
  (interactive "*P")
  (let* ((normal (and (<= ?A last-command-char) (<= last-command-char ?Z)))
         (last-char (if normal (+ 32 last-command-char) last-command-char))
         (sokuon (and (string= skk-prefix (char-to-string last-char))
                      (/= last-char ?o)))
         (henkan-active skk-henkan-active))
    (cancel-undo-boundary)
    (if (or (not skk-henkan-on) skk-henkan-active)
        (if normal
            (skk-set-henkan-point-subr)
          (if skk-henkan-on
              (skk-set-henkan-point-subr) )
          (if henkan-active
              (skk-emulate-original-map arg)
            (skk-self-insert arg) ))
      (if (not normal)
          ;; process special char
          (progn
            (insert last-char)
            (skk-set-marker skk-henkan-end-point (point))
            (setq skk-henkan-count 0
                  skk-henkan-key (skk-buffer-substring
                                  skk-henkan-start-point (point) )
                  skk-prefix "" )
            (skk-henkan) )
        ;; prepare for the processing of okurigana if not skk-okurigana
        ;; and the preceding character is not a numeric character.
        ;; if the previous char is a special midashi char or a
        ;; numeric character, we assume that the user intended to type the
        ;; last-command-char in lower case.
        (if (and (not skk-okurigana)
                 (or (= skk-henkan-start-point (point))
                     (let ((p (char-after (1- (point)))))
                       (not
                        (or
                         ;; previous char is a special midashi char
                         (memq p skk-special-midashi-char-list)
                         ;; previous char is an ascii numeric char
                         (and (<= 48 p) ; ?0
                              (<= p 57) ) ; ?9
                         ;; previous char is a jis numeric char
                         (and (eq (char-after (- (point) 2)) 163)
                              (<= 176 p) (<= p 185) ))))))
            (if skk-process-okuri-early
                (progn
                  (skk-set-marker skk-henkan-end-point (point))
                  (setq skk-okuri-char (char-to-string last-char))
                  (if sokuon
                      (progn
                        (setq skk-henkan-key
                              (concat (skk-buffer-substring
                                       skk-henkan-start-point
                                       skk-kana-start-point )
                               (if skk-katakana "" "")
                               skk-henkan-okurigana ))
                        (skk-erase-prefix)
                        (insert (if skk-katakana " " " "))
                        (setq skk-prefix ""
                              skk-henkan-count 0 )
                        (skk-henkan)
                        ;;(if skk-use-face (skk-henkan-face-off))
                        (delete-backward-char 2)
                        ;;(if skk-use-face (skk-henkan-face-on))
                        )
                    (setq skk-henkan-key (concat
                                          (skk-buffer-substring
                                           skk-henkan-start-point
                                           (point) )
                                          skk-okuri-char ))
                    (insert " ")
                    (setq skk-prefix ""
                          skk-henkan-count 0 )
                    (skk-henkan)
                    ;;(if skk-use-face (skk-henkan-face-off))
                    (delete-backward-char 1)
                    ;;(if skk-use-face (skk-henkan-face-on))
                    )
                  ;; we set skk-kana-start-point here, since the marker may no
                  ;; longer point at the correct position after skk-henkan.
                  (skk-set-marker skk-kana-start-point (point)) )
              (if (= skk-henkan-start-point (point))
                  nil
                (if sokuon
                    (progn
                      (skk-erase-prefix)
                      (insert (if skk-katakana "" ""))
                      (setq skk-prefix "") ))
                (skk-set-marker skk-okurigana-start-point (point))
                (insert "*")
                (skk-set-marker skk-kana-start-point (point))
                (setq skk-okuri-char (char-to-string last-char)
                      skk-okurigana t ))))))
    (if normal (skk-unread-event last-char)) ))

(defun skk-start-henkan (arg)
  "⡼ɤǤѴ򳫻Ϥ롣⡼ɤǤϼθɽ롣
  ¾Υ⡼ɤǤϡꥸʥΥդΥޥɤ򥨥ߥ졼Ȥ롣"
  (interactive "*p")
  (save-match-data
    (if (not skk-henkan-on)
        (skk-self-insert arg)
      (if skk-henkan-active
          (progn (setq skk-henkan-count (1+ skk-henkan-count))
                 (skk-henkan) )
        (let ((pos (point)))
          (or (string= skk-prefix "")
              (skk-error "եåƤʤ skk-prefix ޤ"
                          "Have unfixed skk-prefix" ))
          (if (< pos skk-henkan-start-point)
              (skk-error
               "뤬Ѵˤޤ"
               "Henkan end point must be after henkan start point" ))
          ;; Ф줬ʤǤФҤ餬ʤѴ롣⤷ФѴ
          ;; ˤΤޤ skk-henkan ϤСC-u SPC (arg  4 ˤ
                                                                    ;; ) ȥפФ褤
          (if (and skk-katakana (eq arg 1))
              (skk-hiragana-region skk-henkan-start-point pos) )
          (setq skk-henkan-key (skk-buffer-substring
                                skk-henkan-start-point pos ))
          (if skk-allow-spaces-newlines-and-tabs
              ;; skk-henkan-key  "[ \n\t]+" ˼
                 (while (string-match "[ \n\t]+" skk-henkan-key)
                   (setq skk-henkan-key
                         (concat (substring skk-henkan-key 0 (match-beginning 0))
                                 (substring skk-henkan-key (match-end 0)) )))
                 (save-excursion
                   (beginning-of-line)
                   (if (> (point) skk-henkan-start-point)
                       (skk-error
                        "Ѵ˲ԤޤޤƤޤ"
                        "Henkan key may not contain a new line character" )))
                 ;; ǽΥڡ skk-henkan-key ڤ
                 (setq skk-henkan-key (substring skk-henkan-key 0
                                                 (string-match " "
                                                  skk-henkan-key ))))
          ;;(current-buffer) ;; for debugging
          (skk-set-marker skk-henkan-end-point pos)
          (if skk-use-numeric-conversion
              (setq skk-henkan-key (skk-compute-numeric-henkan-key
                                    skk-henkan-key )))
          (setq skk-henkan-count 0)
          (skk-henkan)
          (if (and skk-abbrev skk-henkan-active)
              (if (skk-in-minibuffer-p)
                  (progn
                    (skk-setup-minibuff-map)
                    (skk-use-local-map skk-minibuff-map) )
                (skk-use-local-map skk-map) ))))
      (cancel-undo-boundary) )))

(defun skk-backward-and-set-henkan-point (arg)
  "ݥȤľˤʸƬѴϥݥȤ򼨤 \"\" դ롣
ľˤʸ \(ڡʸʸĹɽ魯֡ ̵
˥åפ\)  skk-what-char-type ˤȽ̤ƱʸҤȤ
ȤƸإåפ롣
âҤ餫ʤξϡ֤פľǡʤξϡ֥פľǻߤޤ롣
C-u ARG  ARG ͿȡʸʬäƱưԤʤ"
  (interactive "*P")
  (if (not skk-mode)
      (skk-emulate-original-map arg)
    (catch 'exit1
      (save-excursion
        ;; Ȥꤢǽ SPC, TAB,  SPC פ롣
        (skip-chars-backward " \t")
        ;; ꡣ
        (if arg
            (if (not skk-allow-spaces-newlines-and-tabs)
                (skk-backward-char (prefix-numeric-value arg))
              (setq arg (prefix-numeric-value arg))
              (while (> arg 0)
                (skip-chars-backward " \t")
                (if (bolp)
                    ;; Ƭäιޤ뤬arg ϸ餵ʤ
                    (skk-backward-char 1)
                  (skk-backward-char 1)
                  (setq arg (1- arg)) )))
          ;; ʤ
          (let ((limit
                 (if (not skk-allow-spaces-newlines-and-tabs)
                     (save-excursion (beginning-of-line) (point))
                   (point-min) ))
                ;; 
                (unknown-chars-regexp
                 (if skk-allow-spaces-newlines-and-tabs
                     "[ \n\t]"
                   "[]" ))
                char p )
            (save-match-data
              (save-excursion
                (skk-backward-char 1)
                (while (and (> (point) limit)
                            ;; unknown-chars-regexp Ǥʸ̤Ƚ̤Ǥʤ
                            ;; ǡʸ³¤ݥȤХåեƬ
                            ;; ᤹
                            (looking-at unknown-chars-regexp) )
                  (skk-backward-char 1) )
                (setq char (skk-what-char-type))
                (if (eq char 'unknown)
                    (throw 'exit1 nil)
                  ;; (point)               ; for debugging
                  (skk-backward-and-set-henkan-point-1 char)
                  (setq p (point))
                  (if skk-allow-spaces-newlines-and-tabs
                      (while (and (> (point) limit) (bolp))
                        ;; 1 Ծιء
                        (skk-backward-char 1)
                        ;; ݥȤȽ̤Ǥʤʸ̤ξˤ֤ 
                        ;; backward إݥȤ᤹
                        ;;(while (and (> (point) limit)
                        ;;            (looking-at unknown-chars-regexp) )
                        ;;  (skk-backward-char 1) )
                        (if ;;(or
                            (> 0 (skk-backward-and-set-henkan-point-1 char))
                            ;;(eq (skk-what-char-type) char))
                            (setq p (point)) ))))))
            (goto-char p)
            (skip-chars-forward unknown-chars-regexp) ))
        (skk-set-henkan-point-subr) ))))

(defun skk-backward-and-set-henkan-point-1 (char)
  ;; skk-backward-and-set-henkan-point Υ֥롼CHAR μ˱ʸ
  ;; 򥹥åפƥХåեƬ롣
  (cond ((eq char 'hirakana)
         ;; skip-chars-backward ʸϤƤ NEmacs ǤϤư
         ;; "" ǻߤޤä
         (skip-chars-backward "-") )
        ((eq char 'katakana)
         ;; "" ǻߤޤä
         (skip-chars-backward "-") )
        ((eq char 'zenkaku)
         (skip-chars-backward "-") )
        ((eq char 'ascii)
         (skip-chars-backward " -~") )))

(defun skk-what-char-type ()
  ;; ߤΥݥȤˤʸɤʼफȽ̤롣
  (save-match-data
    (cond ((looking-at "[-]")
           'hirakana )
          ((looking-at "[-]")
           'katakana )
          ;; "" Ƥ (""  ""  "" δ֤äƤ)
          ((looking-at "[--]")
           'zenkaku )
          ((looking-at "[ -~]")
           'ascii )
          (t 'unknown) )))

(defun skk-set-henkan-point-subr ()
  "ʤϤǡݥȤѴϤΥޡ \(\) դ롣
Ϥδؿ skk-set-henkan-point ؿǤ롣"
  (interactive "*")
  (if skk-henkan-on (skk-kakutei))
  ;;(if (boundp 'disable-undo)
  ;;    (setq disable-undo t)
  (cancel-undo-boundary)
  ;;  )
  (if (string= skk-prefix "")
      (insert "")
    (skk-erase-prefix)
    (insert "")
    (skk-set-marker skk-kana-start-point (point))
    (skk-insert-prefix) )
  ;;(or (boundp 'disable-undo)
  (undo-boundary)
  ;;    )
  (setq skk-henkan-on t)
  (skk-set-marker skk-henkan-start-point (point)) )

(defun skk-change-marker ()
  ;; """"Ѥ롣skk-henkan-active ե饰 t ˤ롣
  (save-excursion
    (goto-char (- skk-henkan-start-point skk-kanji-len))
    (if (looking-at "")
        (progn
          (cancel-undo-boundary)
          (let ((buffer-undo-list t))
            (insert "")
            (delete-char 1)
            (setq skk-henkan-active t) )
          (undo-boundary)
          )
      (skk-kakutei)
      (skk-error "ޤ" "It seems that you have deleted ") )))

(defun skk-change-marker-to-white ()
  ;; """"Ѥ롣skk-henkan-active ե饰 nil ˤ롣
  (save-excursion
    (goto-char (- skk-henkan-start-point skk-kanji-len))
    (cancel-undo-boundary)
    (if (looking-at "")
        (let ((buffer-undo-list t))
          (insert "")
          (delete-char 1) )
      (goto-char skk-henkan-start-point)
      (insert "")
      ;;(or (boundp 'disable-undo)
      (undo-boundary)
      ;;    )
      (skk-set-marker skk-henkan-start-point (point))
      (skk-message "ޤ" "It seems that you have deleted ") )
    (setq skk-henkan-active nil) ))

(defun skk-delete-henkan-markers (&optional nomesg)
  ;; Ѵ˥ȥХåեɽ `', `' ޡä
  (if (not (marker-position skk-henkan-start-point))
      nil
    (save-excursion
      (save-match-data
        (goto-char (- skk-henkan-start-point skk-kanji-len))
        (if skk-henkan-active
            (progn
              (if skk-use-face (skk-henkan-face-off))
              (if (looking-at "")
                  (delete-char 1)
                (or nomesg
                    (skk-message "ޤ"
                                 "It seems that you have deleted " ))))
          (if (looking-at "")
              (delete-char 1)
            (or nomesg
                (skk-message "ޤ"
                             "It seems that you have deleted " ))))))))

(defun skk-delete-okuri-mark ()
  ;; 겾̾˥ȥХåեɽ `*' ޡä겾̾Ϣ
  ;; ե饰 nil ˥åȤ롣
  (if (not (marker-position skk-okurigana-start-point))
      nil
    (save-excursion
      (if (eq (char-after skk-okurigana-start-point) 42) ; ?*
          (delete-region skk-okurigana-start-point
                         (1+ skk-okurigana-start-point) ))
      (setq skk-okurigana nil
            skk-okuri-char nil
            skk-henkan-okurigana nil ))))
            
(defun skk-katakana-region (start end &optional vcontract)
  "꡼ΤҤ餬ʤ򥫥ʤѴ롣
ץʥ VCONTRACT  non-nil ǤС\"\"  \"\" Ѵ
롣
 START  END ϿǤޡǤɤ"
  (interactive "*r\nP")
  (let ((diff (if skk-mule (- ? ?)))
        ch )
    (save-excursion
      (save-match-data
        ;;(if (and skk-henkan-active skk-use-face) (skk-henkan-face-off))
        (goto-char start)
        (while (re-search-forward  "[-]" end 'noerror)
          (setq ch (preceding-char))
          ;; firstly insert a new char, secondly delete an old char to save
          ;; the cursor position.
          (if skk-mule
              (progn
                (backward-char 1)
                (cancel-undo-boundary)
                (insert (+ ch diff)) )
            (backward-char 2)
            (cancel-undo-boundary)
            (insert ?\245 ch) )
          (cancel-undo-boundary)
          (delete-region (+ (match-beginning 0) skk-kanji-len)
                         (+ (match-end 0) skk-kanji-len) ))
        (if vcontract
            (progn
              (goto-char start)
              (while (re-search-forward  "" end 'noerror)
                (if skk-mule
                    (backward-char 2)
                  (backward-char 3) )
                (cancel-undo-boundary)
                (insert "")
                (cancel-undo-boundary)
                (delete-region (+ (match-beginning 0) skk-kanji-len)
                               (+ (match-end 0) skk-kanji-len) ))))
        ;;(if (and skk-henkan-active skk-use-face) (skk-henkan-face-on))
        ))))

(defun skk-hiragana-region (start end &optional vexpand)
  "꡼ΥʤҤ餬ʤѴ롣
ץʥ VEXPAND  non-nil ǤС\"\"  \"\" Ѵ롣
 START  END ϿǤޡǤɤ
\"\"  \"\" ѹʤ 2 ĤʸбҤ餬ʤʤΤǡ
ʤȤƤϰʤ"
  (interactive "*r\nP")
  (let ((diff (if skk-mule (- ? ?)))
        ch )
    (save-excursion
      (save-match-data
        ;;(if (and skk-henkan-active skk-use-face) (skk-henkan-face-off))
        (goto-char start)
        (while (re-search-forward  "[-]" end 'noerror)
          (setq ch (preceding-char))
          ;; firstly insert a new char, secondly delete an old char to save
          ;; the cursor position.
          (if skk-mule
              (progn
                (backward-char 1)
                (cancel-undo-boundary)
                (insert (- ch diff)) )
            (backward-char 2)
            (cancel-undo-boundary)
            (insert ?\244 ch) )
          (cancel-undo-boundary)
          (delete-region (+ (match-beginning 0) skk-kanji-len)
                         (+ (match-end 0) skk-kanji-len) ))
        (if vexpand
            (progn
              (goto-char start)
              (while (re-search-forward "" end 'noerror)
                (backward-char 1)
                (cancel-undo-boundary)
                (insert "")
                (cancel-undo-boundary)
                (delete-region (+ (match-beginning 0) (* skk-kanji-len 2))
                               (+ (match-end 0) (* skk-kanji-len 2)) ))))
        ;;(if (and skk-henkan-active skk-use-face) (skk-henkan-face-on))
        ))))

(defun skk-zenkaku-region (start end)
  "꡼ ascii ʸбʸѴ롣"
  (interactive "*r")
  (save-excursion
    (save-match-data
      ;;(if (and skk-henkan-active skk-use-face) (skk-henkan-face-off))
      (goto-char end)
      (while (re-search-backward "[ -~]" start 'noerror)
        (cancel-undo-boundary)
        ;; firstly insert a new char, secondly delete an old char to save
        ;; the cursor position.
        (insert (aref skk-default-zenkaku-vector (following-char)))
        (cancel-undo-boundary)
        (delete-region (+ (match-beginning 0) skk-kanji-len)
                       (+ (match-end 0) skk-kanji-len) ))
      ;;(if (and skk-henkan-active skk-use-face) (skk-henkan-face-on))
      )))

(defun skk-ascii-region (start end)
  ;; ꡼ѱѿб ascii ʸѴ롣
  ;; egg.el 3.09  hankaku-region 򻲹ͤˤ
  (interactive "*r")
  (save-excursion
    (save-match-data
      (let (ch ch1 ch2 val)
        ;;(if (and skk-henkan-active skk-use-face) (skk-henkan-face-off))
        (goto-char end)
        (while (re-search-backward "\\cS\\|\\cA" start 'noerror)
          (setq ch (following-char)
                ch1 (char-component ch 1)
                ch2 (char-component ch 2) )
          (cond ((eq 161 ch1) ; ?\241
                 (setq val (cdr (assq ch2 skk-hankaku-alist)))
                 (if val
                     (progn
                       (insert val)
                       (delete-region (+ (match-beginning 0) 1)
                                      (+ (match-end 0) 1) ))))
                ((eq 163 ch1) ; ?\243
                 (insert (- ch2 128)) ; ?\200
                 (delete-region (+ (match-beginning 0) 1)
                                (+ (match-end 0) 1) ))))
        ;;(if (and skk-henkan-active skk-use-face) (skk-henkan-face-on))
        ))))

(defun skk-katakana-henkan (arg)
  "⡼ɤǤС꡼ΤҤ餬ʤ򥫥ʤѴ롣
⡼ɤǤϲ⤷ʤ
¾Υ⡼ɤǤϡꥸʥΥդǥХɤƤ륳ޥɤ¹
롣"
  (interactive "*P")
  (if skk-henkan-on
      (if (not skk-henkan-active)
          (skk-*-henkan-1 'skk-katakana-region skk-henkan-start-point
                          skk-henkan-end-point 'vcontract ))
    (skk-emulate-original-map arg) ))

(defun skk-hiragana-henkan (arg)
  "⡼ɤǤС꡼ΥʤҤ餬ʤѴ롣
⡼ɤǤϲ⤷ʤ
¾Υ⡼ɤǤϡꥸʥΥդǥХɤƤ륳ޥɤ¹
롣"
  (interactive "*P")
  (if skk-henkan-on
      (if (not skk-henkan-active)
          (skk-*-henkan-1 'skk-hiragana-region skk-henkan-start-point
                          skk-henkan-end-point 'vexpand ))
    (skk-emulate-original-map arg) ))

(defun skk-zenkaku-henkan (arg)
  "⡼ɤǤСascii ʸбʸѴ롣
⡼ɤǤϲ⤷ʤ
¾Υ⡼ɤǤϡꥸʥΥդǥХɤƤ륳ޥɤ¹
롣"
  (interactive "*P")
  (if skk-henkan-on
      (if (not skk-henkan-active)
          (skk-*-henkan-1 'skk-zenkaku-region skk-henkan-start-point
                          skk-henkan-end-point ))
    (skk-emulate-original-map arg) ))

(defun skk-ascii-henkan (arg)
  "⡼ɤǤСascii ʸбʸѴ롣
⡼ɤǤϲ⤷ʤ
¾Υ⡼ɤǤϡꥸʥΥդǥХɤƤ륳ޥɤ¹
롣
NEmacs ̤б"
  (interactive "*P")
  (if skk-henkan-on
      (if (not skk-henkan-active)
          (skk-*-henkan-1 'skk-ascii-region skk-henkan-start-point
                          skk-henkan-end-point ))
    (skk-emulate-original-map arg) ))

(defun skk-*-henkan-1 (func &rest args)
  ;; ѴǽɤΥå򤷤 ARGS Ȥ FUNC ŬѤ
  ;; skk-henkan-start-point  skk-henkan-end-point δ֤ʸѴ롣
  (let ((pos (point)))
    (cond ((not (string= skk-prefix ""))
           (skk-error "եåƤʤ skk-prefix ޤ"
                      "Have unfixed skk-prefix" ))
          ((< pos skk-henkan-start-point)
           (skk-error "뤬Ѵˤޤ"
                      "Henkan end point must be after henkan start point" ))
          ((and (not skk-allow-spaces-newlines-and-tabs)
                (save-excursion (beginning-of-line)
                                (> (point) skk-henkan-start-point) ))
           (skk-error "Ѵ˲ԤޤޤƤޤ"
                      "Henkan key may not contain a new line character" )))
    (skk-set-marker skk-henkan-end-point pos)
    (apply func args)
    (skk-kakutei) ))

;;;; jisyo related functions
(defun skk-purge-from-jisyo ()
  "⡼ɤǸߤθ򼭽Хåեõ롣"
  (interactive "*")
  (if (and skk-henkan-active (not (string= skk-henkan-key "")))
      (let ((purge-word (nth skk-henkan-count skk-henkan-list)))
        (if (not
             (yes-or-no-p (format
                           (if skk-japanese-message-and-error
                               "%s /%s/%s򼭽񤫤ޤɤǤ"
                             "Really purge \"%s /%s/%s\"?" )
                           skk-henkan-key purge-word
                           (if (and skk-henkan-okurigana
                                    skk-henkan-okuri-strictly )
                               (concat
                                (if skk-japanese-message-and-error
                                    " (겾̾: "
                                  "(okurigana: " )
                                skk-henkan-okurigana
                                ") " )
                             " " ))))
            nil
          ;; skk-henkan-start-point  point ޤǺƤޤ
          ;; Ƥ⡢Ѵľ (ưȤʤ) skk-purge-jisyo 
          ;; ٤ʤ뤬㤦ذưƤϡ
          ;; ǤʤΤޤǺƤޤǽ롣ǡ겾̾
          ;; ФĹޤ᤿ end ᡢѴ˴ϢĽ
          ;; Τڤ褦ˤ롣
          (let ((end (if skk-henkan-okurigana
                         (+ (length skk-henkan-okurigana)
                            skk-henkan-end-point )
                       skk-henkan-end-point )))
            (if skk-use-numeric-conversion
                (skk-update-jisyo-for-numerals purge-word 'purge) )
            (skk-update-jisyo purge-word 'purge)
            ;; ǰΤᡣΤΤˤĤƤϡ
            ;; skk-previous-candidate 򻲾ȡ 
            (if skk-use-face (skk-henkan-face-off))
            (delete-region skk-henkan-start-point end)
            (skk-change-marker-to-white)
            (skk-kakutei) )))))

(defun skk-save-jisyo (&optional quiet)
  "SKK μХåե򥻡֤롣
ץʥ QUIET  non-nil ǤС񥻡ֻΥåФ
"
  (interactive "P")
  (let* ((skk-jisyo (expand-file-name skk-jisyo))
         (jisyo-buffer (skk-get-jisyo-buffer skk-jisyo 'nomsg)) )
    (if (or (not jisyo-buffer) (not (buffer-modified-p jisyo-buffer)))
        (if (not quiet) 
            (progn
              (skk-message "SKK ¸ɬפϤޤ"
                           "No need to save SKK jisyo" )
              (sit-for 1) ))
      ;; Υ֤ߤȤ skk-check-jisyo-size 쵤 throw 
      ;; 롣
      (catch 'exit
        (save-excursion
          (set-buffer jisyo-buffer)
          (let ((inhibit-quit t)
                (tempo-file (skk-make-temp-jisyo)) )
            (if (not quiet)
                (skk-message "SKK ¸Ƥޤ..."
                             "Saving SKK jisyo..." ))
            (skk-save-jisyo-1 tempo-file)
            (skk-check-jisyo-size tempo-file)
            (if (not quiet)
                (progn
                  (skk-message "SKK ¸Ƥޤ...λ"
                               "Saving SKK jisyo...done" )
                  (sit-for 1) ))))
        (if (eq this-command 'save-buffers-kill-emacs)
            (skk-record-jisyo-data jisyo-buffer) )))))

(defun skk-save-jisyo-1 (file)
  (save-match-data
    (let (kanji-flag mc-flag enable-multibyte-characters buffer-read-only)
      (goto-char (point-min))
      (if (re-search-forward "^;; okuri-ari entries.$" nil 'noerror)
          nil
        (skk-error
         "ꤢꥨȥΥإåޤ SKK Υ֤ߤޤ"
         "Header line for okuri-ari entries is missing!  Stop saving SKK jisyo" ))
      ;; áȥե $" ǽʤ > hilit19.el
      (if (re-search-forward "^;; okuri-nasi entries.$" nil 'noerror)
          nil
        (skk-error
         "ʤȥΥإåޤ  SKK Υ֤ߤޤ"
         "Header line for okuri-nasi entries is missing!  Stop saving SKK jisyo" ))
      (write-region 1 (point-max) file nil 'nomsg)
      (set-buffer-modified-p nil) )))

(defun skk-check-jisyo-size (new-file)
  (let ((new-size (nth 7 (file-attributes new-file)))
        old-size )
    (if (eq new-size 0)
        (progn
          (delete-file new-file)
          (skk-error "SKK 񤬶ˤʤäƤޤ Υ֤ߤޤ"
                     "Null SKK jisyo!  Stop saving jisyo" )))
    (if (or (not skk-compare-jisyo-size-when-saving)
            ;; 켭ȤΥӤԤʤʤ
            (progn
              (setq old-size (nth 7 (file-attributes skk-jisyo)))
              (or (not old-size)
                  (>= new-size old-size) )))
        ;; (1)skk-jisyo ʤ
        ;; (2)new-file  skk-jisyo ƱΥ
        ;;    (skk-(aux-)large-jisyo 鿷ñɤ߹ޤʤäꡢñ
        ;;    ϿԤʤʤäϥƱ)
        ;; (3)new-file 礭
        ;;  (嵭 3 ̤ǤФ)
        (skk-make-new-jisyo new-file)
      ;; yes-or-no-p ˲newline ȡthis-command ѤäƤޤ
      (let (this-command this-command-char last-command last-command-char)
        (if (skk-yes-or-no-p
             (format
              "skk-jisyo  %dbytes ʤޤȤ⤫֤ɤǤ"
              (- old-size new-size) )
             (format
              "New %s will be %dbytes smaller.  Save anyway?"
              skk-jisyo (- old-size new-size) ))
            ;; Ȥˤ֡
            (skk-make-new-jisyo new-file)
          ;; ֤Ȥߤᡣ
          (delete-file new-file)
          (skk-message "SKK Υ֤ߤޤ"
                       "Stop saving SKK jisyo!" )
          (sit-for 2)
          ;; skk-save-jisyo ذ쵤 throw
          (throw 'exit nil) )))))

(defun skk-make-temp-jisyo ()
  ;; SKK Ŀͼ¸ΤκѤΥեꡢեΥ⡼ɤ
  ;; skk-jisyo ΤΤƱꤹ롣äѥե֤̾
  (let ((tempo-name (skk-make-temp-file "skkdic")))
    (skk-create-file tempo-name)
    (set-file-modes tempo-name  (file-modes skk-jisyo))
    tempo-name ))

(defun skk-make-temp-file (prefix)
  ;; from call-process-region of mule.el.  Welcome!
  (make-temp-name
   (if (null (memq system-type '(ms-dos windows-nt)))
       (concat "/tmp/" prefix)
     (let ((tem (or (getenv "TMP") (getenv "TEMP") "/")))
       (concat tem
               (if (memq (aref tem (1- (length tem))) '(47 92)) ;?/, ?\\
                   "" "/" )
               prefix )))))

(defun skk-make-new-jisyo (tempo-file)
  ;; TEMPO-FILE 򿷵 skk-jisyo ˤ롣skk-backup-jisyo  non-nil ä
  ;; Хåå׼롣
  (if skk-backup-jisyo
      (progn
        (if (file-exists-p skk-backup-jisyo)
            (delete-file skk-backup-jisyo) )
        (rename-file skk-jisyo skk-backup-jisyo) )
    (delete-file skk-jisyo) )
  (rename-file tempo-file skk-jisyo 'ok-if-already-exists) )

(defun skk-record-jisyo-data (jisyo-buffer)
  ;; ǡꡢEmacs νλκݤǤСΥǡ 
  ;; skk-record-file ¸ʳǤС򥨥롣
  (if (and skk-keep-record (> skk-kakutei-count 0))
      (save-excursion
        (let (min)
          (set-buffer (get-buffer-create " *skk-work*"))
          (erase-buffer)
          (insert-file-contents skk-record-file)
          (setq min (point-min))
          (goto-char min)
          (insert (format
                   "%s  Ͽ: %3d  : %4d  Ψ: %3d%%  :%6d\n"
                   (current-time-string)
                   skk-touroku-count skk-kakutei-count
                   (/ (* 100 (- skk-kakutei-count skk-touroku-count))
                      skk-kakutei-count )
                   (if skk-count-private-jisyo-candidates-exactly
                       (skk-count-jisyo-candidates (expand-file-name skk-jisyo))
                     (save-excursion
                       (set-buffer jisyo-buffer)
                       ;; 1  1 Ȥߤʤ
                       (- (count-lines min (point-max)) 2) ))))
          (write-region min (point-max) skk-record-file nil 'nomsg)
          (setq skk-touroku-count 0
                skk-kakutei-count 0 )))))

(defun skk-count-jisyo-candidates (file)
  "SKK θ롣
`['  `]' ˰Ϥޤ줿겾̾Υ֥åϿʤ"
  (interactive
   (list (read-file-name
          (format "Jisyo File: (default: %s) " skk-jisyo)
          "~/" skk-jisyo 'confirm )))
  ;; mule@emacs19.31 ȲΤ褦ˤ (`' Τ褦) Τ 
  ;; default-directory ˲Ԥդ
  ;; ̾ϵդʤrsz-mini.el Ȥä resize-minibuffer-mode  
  ;; non-nil ˤƤפ 2 ܤи롣
  ;; (interactive "fե: ")
  (save-excursion
    (save-match-data
      (set-buffer (find-file-noselect file))
      (let ((count 0)
            (min (point-min))
            (max (if (interactive-p) (point-max)))
            mc-flag enable-multibyte-characters kanji-flag )
        (goto-char min)
        (if (or
             ;;  save-excursion Ȥ鷺ݥȤư롣
             (not (re-search-forward "^;; okuri-ari entries.$" nil t nil))
             (not
              (save-excursion
                (re-search-forward "^;; okuri-nasi entries.$" nil t nil) )))
            (skk-error "Υե SKK μǤϤޤ"
                       "This file is not a SKK dictionary") )
        (while (search-forward "/" nil t)
          (cond ((looking-at "\\[")
                 (forward-line 1)
                 (beginning-of-line) )
                ((not (eolp))
                 (setq count (1+ count)) ))
          (if (interactive-p)
              (message "Counting jisyo candidates...%3d%% done"
                       (/ (* 100 (- (point) min)) max) )))
        (if (interactive-p)
            (message "%d entries" count)
          count )))))

(defun skk-create-file (file &optional message)
  ;; FILE ʤСFILE Ȥ̾ζե롣
  ;; ץʥ MESSAGE ꤹȡե夽Υå
  ;; ߥ˥Хåեɽ롣
  (let ((file (expand-file-name file)))
    (or (file-exists-p file)
        (progn
          (write-region 1 1 file nil 0)
          (if message
              (progn
                (message message)
                (sit-for 3) ))))))

(defun skk-get-jisyo-buffer (file &optional nomsg)
  ;; FILE 򳫤 SKK ХåեꡢХåե֤
  ;; ץʥ NOMSG ꤹȥեɤ߹ߤκݤΥå
  ;; ɽʤ
  (if file
      (let ((inhibit-quit t)
            ;; expand-file-name ƤǤʤȡȤäƤ OS 夢ꤨʤ
            ;; ե͡Ǥ⡢ΤޤϤƤޤ
            ;; () MSDOS ξ ~/_skk-jisyo μºݤΥե͡ϡOS 
            ;; ¤ ~/_skk-jis Ȥʤ롣expand-file-name ƤФʤȡ
            ;; " *_skk-jisyo*" ȤХåեǤƤޤskk-save-jisyo 
            ;; ¾δؿ˱ƶФ롣
            (file (expand-file-name file))
            (jisyo-buf (concat " *" (file-name-nondirectory file)
                               "*" )))
        ;; ХåեȤƥץ󤵤Ƥʤ顢⤷ʤ
        (or (get-buffer jisyo-buf)
            (save-excursion
              (setq jisyo-buf (get-buffer-create jisyo-buf))
              (set-buffer jisyo-buf)
              (buffer-disable-undo jisyo-buf)
              (auto-save-mode -1)
              ;; 󥰥ХåեΥ⡼ɥ饤ϥåץǡȤʤ
              ;;(make-local-variable 'line-number-mode)
              ;;(make-local-variable 'column-number-mode)
              (setq buffer-read-only nil
                    case-fold-search nil
                    ;; buffer-file-name  nil ˤȡХåե
                    ;;  C-x C-s Ȥ˥ե͡ҤͤƤ褦
                    ;; ʤ뤬M-x compile ʤ save-some-buffers 򥳡
                    ;; 뤷Ƥ륳ޥɤȤäȤǤ⥻֤뤫ɤ
                    ;; ҤͤƤʤʤ롣
                    ;;buffer-file-name file
                    ;;cache-long-line-scans nil
                    ;;column-number-mode nil
                    ;;line-number-mode nil
                    ;; dabbrev ΥȤʤХåեˤʤʤ褦¸ߤ
                    ;; ⡼̾ˤƤ³ΤѤϤʤϤ
                    major-mode 'skk-jisyo-mode
                    mode-name "SKK" )
              (or nomsg
                  (skk-message "SKK  %s Хåեɤ߹Ǥޤ..."
                               "Inserting contents of %s ..."
                               (file-name-nondirectory file) ))
              (insert-file-contents file)
              (skk-set-jisyo-code)
              (or nomsg
                  (skk-message
                   "SKK  %s Хåեɤ߹Ǥޤ...λ"
                   "Inserting contents of %s ...done"
                   (file-name-nondirectory file) ))
              (skk-setup-jisyo-buffer)
              (set-buffer-modified-p nil)
              jisyo-buf )))))

(defun skk-setup-jisyo-buffer ()
  ;; skk-jisyo μХåեǡ
  ;; (1)ХåեǤСإåꡢ
  ;; (2)񥨥ȥ꤬¸μХåեʤСإåɤ
  ;;    å롣
  ;;
  ;; skk-okuri-ari-min  skk-okuri-nasi-min ΰ֤ѹ
  ;;                         skk-okuri-ari-min
  ;;   ;; okuri-ari entries.
  ;;     skk-okuri-ari-min
  ;;
  ;;    skk-okuri-ari-max   skk-okuri-nasi-min
  ;;   ;; okuri-nasi entries.
  ;;     skk-okuri-nasi-min
  ;;
  ;;
  ;; ѹΰ֤ǤСΤ褦ʶξ硢
  ;;
  ;;   ;; okuri-ari entries.
  ;;   ;; okuri-nasi entries.
  ;;
  ;; skk-okuri-ari-min  skk-okuri-ari-max ΥޡŤʤäƤޤ
  ;; skk-okuri-ari-min ΰ֤ȥ꤬ skk-okuri-ari-max Υޡ
  ;; ˲ʤ
  ;;
  ;; δؿΥꥸʥ̾Τϡj-check-jisyo äskk-check-jisyo 
  ;; ̾ˤ skk-tools.el δؿ̾Ƚʣ롣
  ;; case-fold-search ϡХåեǤϾ nil
  (let (kanji-flag mc-flag enable-multibyte-characters)
    (save-match-data
      (if (eq (buffer-size) 0)
          ;; Хåեä顢إåΤ
          (insert ";; okuri-ari entries.\n" ";; okuri-nasi entries.\n") )
      (goto-char (point-min))
      (if (re-search-forward "^;; okuri-ari entries.$" nil 'noerror)
          ;; ݥȤʤΤǡ(point) ǽʬ
          (setq skk-okuri-ari-min (point))
        (skk-error "ꤢꥨȥΥإåޤ"
                   "Header line for okuri-ari entries is missing!" ))
      (if (re-search-forward "^;; okuri-nasi entries.$" nil 'noerror)
          (progn
            (beginning-of-line)
            ;; ͭʤݥȤǤɤΤХåեԽ
            ;; ʤäȤΤȤθƥޡˤƤ
            (setq skk-okuri-ari-max (point-marker))
            (forward-line 1)
            (backward-char 1)
            (setq skk-okuri-nasi-min (point-marker)) )
        (skk-error "ʤȥΥإåޤ"
                   "Header line for okuri-nasi entries is missing!" )))))

(defun skk-search ()
  ;; skk-current-search-prog-list ǤˤʤäƤץɾơ
  ;; skk-henkan-key򥭡ˤƸԤ
  (let (l)
    (while (and (null l) skk-current-search-prog-list)
      (setq l (eval (car skk-current-search-prog-list))
            skk-current-search-prog-list (cdr skk-current-search-prog-list) ))
    l ))

(defun skk-search-jisyo-file (file limit &optional nomsg)
  ;; SKK եޥåȤ FILE  skk-henkan-key 򥭡ˤƸԤ
  ;; ꡼ LIMIT ʲˤʤޤǥХʥꥵԤθ˥
  ;; Ԥ
  ;; LIMIT  0 ǤС˥ΤߤԤ
  ;; 񤬥ȤƤʤΤǤСLIMIT  0 ɬפ롣
  ;; ץʥ NOMSG  non-nil Ǥ skk-get-jisyo-buffer Υ
  ;; Ϥʤ褦ˤ롣
  (let ((jisyo-buffer (skk-get-jisyo-buffer file nomsg)))
    (if jisyo-buffer
        ;; skk-henkan-key  skk-henkan-okurigana ϥȥХåեΥ
        ;; ͡
        (let ((okurigana (or skk-henkan-okurigana skk-okuri-char))
              (midasi skk-henkan-key)
              entry-list )
          (save-excursion
            (set-buffer jisyo-buffer)
            (setq entry-list (skk-search-jisyo-file-1 midasi okurigana limit))
            (if entry-list
                (if (and okurigana skk-henkan-okuri-strictly)
                    ;; 겾̾ƱΥȥΤߤ֤
                    (nth 2 entry-list)
                  (car entry-list) )))))))

(defun skk-search-jisyo-file-1 (midasi okurigana limit &optional delete)
  ;; skk-search-jisyo-file Υ֥롼skk-compute-henkan-lists Ѥ
  ;; ФˤĤƤΥȥξ֤
  ;; DELETE  non-nil ǤСMIDASI ˥ޥå륨ȥ롣
  (let ((key (concat "\n" midasi " /"))
        min max size p )
    (save-match-data
      ;; skk-okuri-ari-min  skk-okuri-ari-max ϼХåեΥ͡
      (if okurigana
          (setq min skk-okuri-ari-min
                max skk-okuri-ari-max )
        (setq min skk-okuri-nasi-min
              max (point-max) ))
      (if (> limit 0)
          (while (progn (setq size (- max min)) (> size limit))
            (goto-char (+ min (/ size 2)))
            (beginning-of-line)
            (setq p (point))
            ;; ꤢʤսӤԤʤ
            (if (if okurigana
                    (string< (skk-buffer-substring
                              p (1- (progn (search-forward  " ") (point))) )
                             midasi )
                  (string< midasi
                           (skk-buffer-substring
                            p (1- (progn (search-forward " ") (point))) )))
                (setq max p)
              (setq min p) )))
      (goto-char min)
      ;; key ˤäǤ⸡ǽʤ褦˰ʸ롣key 
      ;; Ƭʬ "\n" ޤǤ뤳Ȥա
      (or (bobp) (backward-char 1))
      ;; Ψɤ褦 kanji-flag, mc-flag, enable-multibyte-characters 
      ;; nil ˤƤ
      ;; case-fold-search ϡХåեǤϾ nil
      (let (kanji-flag mc-flag enable-multibyte-characters)
        (if (search-forward key max 'noerror)
            (prog1
                (skk-compute-henkan-lists okurigana)
              (if delete
                  (progn
                    (beginning-of-line)
                    (delete-region (point)
                                   (progn (forward-line 1) (point)) )))))))))


(defun skk-compute-henkan-lists (okurigana)
  ;; 񥨥ȥ 4 ĤΥꥹȤʬ򤹤롣
  ;;
  ;; ʤ (㤨С񥨥ȥ "Ƥ󤵤 /ž/ŷ/ŷ/" ν)
  ;; entry1 := ("ž" "ŷ" "ŷ") == ȥ
  ;; entry2 := nil
  ;; entry3 := nil
  ;; entry4 := nil
  ;;
  ;; ꤢ (㤨Сֵ㤯פѴԤäΡ񥨥ȥ
  ;;           "k /˴/̵///[/̵///]/[/˴/]/" ν)
  ;; entry1 := ("˴" "̵" "" "")  == ʬȥ
  ;; entry2 := ("[")                == ¾겾̾Ȥȥ (
  ;;                                     ) + Ѵ겾̾ʬ
  ;; entry3 := ("̵" "" "")       == Ѵ겾̾Ȥǽ
  ;;                                     ȥ
  ;; entry4 := ("]" "[" "˴" "]")   == ¾겾̾Ȥȥ (
  ;;                                     ꡣ)
  ;;
  ;;   * "[" ľ³Ҥ餬ʤ겾̾˻ĴΥȥνޤɽ
  ;;     "]" ϡ겾̾롼פν򼨤
  ;;
  ;; δؿϡѴȡľμΥåץǡȻ 2 ٸƤФ
  ;; (Ѵ˸Ԥä񤬡skk-jisyo Ȥϸ¤ʤΤǡ2 ٷ׻
  ;; ʤ)
  ;;
  ;; Ѵϡskk-henkan-okuri-strictly  nil ǤС׻̤ entry1
  ;; non-nil Ǥ entry3 Ф
  (if (not okurigana)
      (list (string-split
             "/"
             (skk-buffer-substring (point)
                                   (progn (end-of-line) (1- (point))) ))
            nil nil nil )
    (save-match-data
      (let ((stage 1) (q1 (queue-create)) (q2 (queue-create))
            (q3 (queue-create)) (q4 (queue-create))
            (okuri-key (concat "\[" okurigana)) item headchar )
        (catch 'exit
          (while (not (eolp))
            (setq item (skk-buffer-substring (point)
                                             (1- (progn (search-forward "/")
                                                        (point) )))
                  headchar (if (string= item "") 0 (aref item 0)) )
            (cond ((and (eq headchar 91) ; ?\[
                        (<= stage 2) )
                   (if (string= item okuri-key)
                       (progn (queue-enqueue q2 item)
                              (setq stage 3) )
                     (setq stage 2)
                     (queue-enqueue q2 item) ))
                  ((eq stage 1)
                   (queue-enqueue q1 item) )
                  ((eq stage 2)
                   (queue-enqueue q2 item) )
                  ((eq stage 3)
                   (if (eq headchar 93) ; ?\]
                       (progn (setq stage 4)
                              (queue-enqueue q4 item) )
                     (queue-enqueue q3 item) ))
                  ((eq stage 4)
                   (queue-enqueue q4 item) ))))
        ;;        entry1          entry2        entry3          entry4
        (list (queue-all q1) (queue-all q2) (queue-all q3) (queue-all q4)) ))))

;; 塼ϢδؿλѤ˺ݤƤϡ֥ץι¤ȼ¹ԡ(H. ٥륽
;; G.J.ޥJ.ޥʸޥҥ)  Elib (the
;; GNU emacs lisp library version 1.0) 򻲹ͤˤ嵭ʸǲ⤵Ƥ
;; 륭塼ɽϡElib  queue-m.el ˤƼ¸ƤΤȤۤƱ
;; ȤʤäƤ롣
;;
;; ꥹȤǤΥ塼ɽϡŪˤ㤨 ((A B C D E F) F) Τ褦ʷˤʤ
;; Ƥꡢcar Υꥹ (A B C D E F) 塼Τɽ路塼 nth 1 
;; äȤ F 塼κǸɽ魯塼 cdr äȤ (F) 
;; ȤꥹȤϡ塼 car Ф nthcdr 5 äȤΥꥹ (F) Ʊ
;; ΤǤ롣cdr ΥꥹȤθ˿Ǥɲä뤳Ȥǡcar ɽ
;; 蘆륭塼˿Ǥɲä뤳ȤǤ롣
;; nconc  append ǤĤʤˤϡδؿ裱ΥꥹȤƤ
;; ǤͤФʤ餺O(n) λ֤ΤǡĹꥹȤĤʤȤ
;; ŪȤ롣
;;
;; ơ queue == (cons nil nil) Ф A ɲäˡ
;; 롣ޤ A ΤߤޤĹ 1 Υꥹ (A)  ( 
;; new-pair Ȥѿ˼)ˡ(setcar queue new-pair) ԤʤȤˤ
;; ꡢqueue  ((A)) Ȥʤ (setcar, setcdr ֤ͤϡnew-pair Ǥ뤳Ȥ
;; ) (setcdr queue new-pair)  ((A) A) ȤʤäȤ޼롣
;; front, rear ξΥݥ󥿤 (A) ؤ褦ˤ (塼Ǥ A 
;; ʤΤǡfront, rear ݥ󥿤ȤƱΤؤƤ)
;;         queue
;;   +-------+-------+
;;   | Front |  Rear |
;;   +---|---+---|---+
;;       |       +---> +---------------+
;;       +------------>|   o   |  nil  |
;;                     +---|---+-------+
;;                         |      +-------+
;;                         +----> |   A   |
;;                                +-------+
;;
;; 嵭 queue, ((A) A) Ф˿ B ɲä롣ˤ B Τ
;; ޤĹ 1 Υꥹ (B) ꡢѿ new-pair ˼롣
;; (setcdr (cdr queue) new-pair) ɾ (1)* θĽΥݥ
;; Ԥʤ롣塼κǸ˿ǤǤ B ɲä뤳Ȥˤʤ롣
;; queue  ((A B) A B) Ȥʤ롣
;;         queue
;;   +-------+-------+
;;   | Front |  Rear |
;;   +---|---+---|---+
;;       |       +---> +---------------+   *    +---------------+
;;       +------------>|   o   |   o --|------->|   o   |  nil  |
;;                     +---|---+-------+        +-------+-------+
;;                         |      +-------+         |      +-------+
;;                         +----> |   A   |         +----> |   B   |
;;                                +-------+                +-------+
;;
;;   1; ɲΥ塼Ǥ 1 ĤΤȤϡfront  rear ƱΤؤ
;;        ƤΤ (setcdr (car queue) new-pair) Ǥ塼
;;         2 İʾΤȤ (setcdr (cdr queue) new-pair) ǤʤȤޤ
;;
;; Ǹ (setcdr queue new-pair) ɾ뤳Ȥˤꡢrear ݥ󥿤ĥ
;;  (* θĽΥݥԤʤ)rear ݥ󥿤塼κǸ
;; Ǥؤ褦ˤ롣front ݥ󥿤ؤꥹȤϥ塼ƤǤɽ
;; 
;;         queue
;;   +-------+-------+           *
;;   | Front |  Rear |---------------------+
;;   +---|---+-------+                     |
;;       |             +---------------+   +--> +---------------+
;;       +------------>|   o   |   o --|------->|   o   |  nil  |
;;                     +---|---+-------+        +-------+-------+
;;                         |      +-------+         |      +-------+
;;                         +----> |   A   |         +----> |   B   |
;;                                +-------+                +-------+
;;
;; Τ褦˥塼κǸ˿Ǥɲä뤳 (ꥹȤκǸĹ 1
;; οꥹȤĤʤ뤳)  2 ΥݥǲǽȤʤΤǡɤΤ
;; ĹꥹȤǤäƤϢˤ륳Ȥϰ (O(1) δؿǤ) Ǥ롣
;; ʤǤϡʿѤư²˥ꥹȤκǸǤĤʤ롢ȤŪ
;; 塼ȤäƤ롣塼ŪǤϻѤƤʤΤǡ㤨С
;; Τ褦ʴؿϻѤƤʤ
;; queue-last, queue-first, queue-nth, queue-nthcdr, queue-dequeue

(defun skk-nunion (x y)
  ;; X  Y ½롣ɤӤϡequal ǹԤ롣X  Y
  ;; ˲ŪϢܤ롣
  (cond ((null x) y)
        ((null y) x)
        (t (let ((e x))
             (while e
               (setq y (delete (car e) y)
                     e (cdr e) ))
             (if y
                 ;; 嵭 while 롼פ delete Ȳ nconc Ȥ碌
                 ;; ơ X  2 Y  X Ȥˤʤ롣
                 ;; ȤƤʤƱΤ齸ʾ (ϥȤ
                 ;; Ϥʤʤ) ༡ˤʤΤǤϻߤʤ...
                 (nconc x y)
               x )))))

(defun skk-search-kakutei-jisyo-file (file limit &optional nomsg)
  ;; եõꥹȤ֤
  ;; 򸫤Ĥϡѿ skk-kakutei-flag  non-nil 롣
  ;; 䤬Ĥʤäϡnil ֤
  (setq skk-kakutei-flag (skk-search-jisyo-file file limit nomsg)) )

(defun skk-update-jisyo (word &optional purge)
  ;; WORD Ѵ˺ǽθˤʤ褦ˡץ饤١ȼ򹹿롣
  ;; PURGE  non-nil  WORD ͭˤ륨ȥʤ skk-ignore-dic-word
  ;; ؿǥȤȥץ饤١ȼ˺ꡢѴϤ
  ;; 褦ˤ롣
  ;; WORD ͭˤʤСץ饤١ȼμ񥨥ȥ꤫롣
  ;;
  ;; SKK 9.x ꡢץ饤١ȼΥȥˡѹ (9.3 Τ
  ;; 㳰)
  ;;
  ;; ѹ
  ;;         ;; okuri-ari entries.
  ;;     k //[//]/[//]/
  ;;  С   i //[//]/
  ;;     錄s //[//]/[//]/
  ;;     魯r /˺/[/˺/]/
  ;;     狼t /ʬ/Ƚ/[ä/ʬ/Ƚ/]/[ä/ʬ/]/
  ;;        .....
  ;;         i //[//]/
  ;;         ;; okuri-nasi entries.
  ;;  Ѥ   礦 //
  ;;     ˤ夦 //
  ;;      /̾/
  ;;       ...
  ;;         ...
  ;;
  ;; ѹ
  ;;         ;; okuri-ari entries.
  ;;  Ѥ   t //[//]/[//]/
  ;;     i //[//]/
  ;;     s //[//]/[//]/[//]/[//]/
  ;;       s //[//]/[//]/[//]/[//]/
  ;;         ...
  ;;         ...
  ;;         ʤs /Ĺ/ή/[/ή/]/[/Ĺ/]/[/ή/]/
  ;;         ;; okuri-nasi entries.
  ;;  Ѥ   礦 //
  ;;     ˤ夦 //
  ;;      /̾/
  ;;       ...
  ;;         ...
  ;;
  ;; skk-auto-okuri-process  non-nil ΤȤˡ(j-okuri-search )
  ;; skk-okuri-search ϸФĹ˸֤ɬפ롣
  ;; SKK 8.6 ޤǤϡskk-okuri-search  j-okuri-ari-min  j-okuri-ari-max
  ;; ޤǤõĤν˸֤˥ץ饤١ȼ񤬸Ф
  ;; 򥭡Ȥƹ߽˥ȤƤɬפä
  ;; SKK 9.x Ǥϡskk-okuri-search դ򸫽Ф򥭡Ȥƾ
  ;; ˥Ȥ֤ᡢץ饤١ȼΥȤɬפǤʤäơǸ
  ;; ѴΤ (j-okuri-ari-min ) skk-okuri-ari-min ΰ֤
  ;; 롣
  ;;
  (let ((jisyo-buffer (skk-get-jisyo-buffer skk-jisyo 'nomsg)))
    (if jisyo-buffer
        (let ((inhibit-quit t) buffer-read-only old-entry okurigana midasi)
          (if skk-auto-okuri-process
              (setq word (skk-remove-common word)) )
          (setq okurigana (or skk-henkan-okurigana skk-okuri-char)
                midasi skk-henkan-key )
          (save-excursion
            (set-buffer jisyo-buffer)
            ;; ¸ȥ򸡺õ롣٤ȥ꤬ entry1  1
            ;; Ĥʤword ƱʸǤäƤ⡢ääƤΥ
            ;;  min ݥȤ˰ưʤФʤʤ (ɤߤ䴰Ԥ
            ;; ϡmin ݥȤ鸫ФõᡢФۤɡmin
            ;; ݥȤ˶ᤤȤˤʤФʤʤ)
            (setq old-entry (skk-search-jisyo-file-1 midasi okurigana 0 'delete))
            (skk-update-jisyo-1 midasi okurigana word old-entry purge)
            ;; auto save.
            (if skk-jisyo-save-count
                (if (> skk-jisyo-save-count skk-update-jisyo-count)
                    (setq skk-update-jisyo-count (1+ skk-update-jisyo-count))
                  (setq skk-update-jisyo-count 0)
                  (skk-save-jisyo 'quiet) ))
            ;; Хåե򥪡ץ󤷤Ȥ auto-save-mode 򥪥դˤƤ
            ;; ٲΤ褦򤷤ʤƺѤࡣ
            ;;
            ;; ƤСХåեϥȥ֤ʤƺѤࡣ
            ;;(set-buffer-modified-p nil)
            )))))

(defun skk-update-jisyo-1 (midasi okurigana word old-entry-list purge)
  ;; ¸ȥ꤫׻ entry[1-4] ͤȡѴη word Ȥޡ
  ;; ơʥȥ׻롣
  (let ((entry1 (car old-entry-list)) (entry2 (nth 1 old-entry-list))
        (entry3 (nth 2 old-entry-list)) (entry4 (nth 3 old-entry-list)) )
    (if (not purge)
        ;; entry1 ƬΥȥ word ˤ롣
        (setq entry1 (cons word (delete word entry1)))
      ;; ʤ⤷ skk-henkan-okuri-strictly  nil ξ硣
      (if (or (not okurigana) (not skk-henkan-okuri-strictly))
          ;; entry1  purgeѼˤ륨ȥä顢
          ;; skk-ignore-dic-word ǥȤƼѴϤʤ褦ˤ
          ;; 롣Ѽˤʤʸ word ä
          (if (skk-public-jisyo-contains-p midasi okurigana word)
              (setq entry1 (skk-compose-ignore-entry entry1 word))
            (setq entry1 (delete word entry1)) )
        ;; ꤢ skk-henkan-okuri-strictly  non-nil ξǡ
        ;;  word ȥڥˤʤ겾̾ okurigana ʤȤ
        (if (and okurigana skk-henkan-okuri-strictly
                 (null (member word entry2)) (null (member word entry4)) )
            (setq entry1 (delete word entry1))
          ;; ¾ξϲ⤷ʤ
          )))
    (if (null entry1)
        ;; entry1  null ǤС⤦⤹뤳ȤϤʤ
        nil
      (goto-char (if okurigana skk-okuri-ari-min skk-okuri-nasi-min))
      (insert "\n" midasi " /")
      ;; entry1 -- ȥ (ʤξ) or ʬȥ (ꤢ
      ;; ξ)
      (insert (mapconcat 'skk-quote-char entry1 "/") "/")
      (if (not okurigana)
          nil
        ;; entry2 ʹߤΥȥΤϡꤢξΤߡ
        ;; ٤ȥ׻Ĵ롣
        (if entry3
            (if (not purge)
                (setq entry3 (cons word (delete word entry3)))
              (setq entry3 (delete word entry3))
              (if (null entry3)
                  ;; entry3 ȤΤʤС"/[/]/" Τ
                  ;; 겾̾ΤߤΥȥʤ褦ˤ (ɬפ
                  ;; Сentry2 κǸ) entry4 ƬΥȥ "]"
                  ;; 
                  (let ((last2 (nthcdr (- (length entry2) 2) entry2)))
                    ;; entry2 κǸϾ "[겾̾" Ȥϸ¤ʤ
                    (if (string= (nth 1 last2) (concat "[" okurigana))
                        (setcdr last2 nil) )
                    ;; entry4 ƬϾ "]"
                    (setq entry4 (cdr entry4)) )))
          ;; entry3  null Ǥ
          (if (or skk-process-okuri-early purge)
              ;; skk-process-okuri-early  non-nil ʤ겾̾ʬʤΤ
              ;; ⤷ʤ-- Ѥ겾̾狼ʤޤѴƤ
              ;; ΤǡƤΥȥ꤬ entry2 äƤ -- entry3,
              ;; entry4  null
              ;; entry3 ȤΤʤС⤷ʤ -- entry3
              ;;  purge  null ʤ顢entry2  "[" Ǥʤ
              ;; entry4  null  entry[234] ס
              nil
            (setq entry2 (nconc entry2 (list (concat "[" okurigana)))
                  entry3 (list word)
                  ;; purge  entry3  null äΤ entry4  null
                  entry4 (list "]") ))))
      (if entry2
          ;; entry2 -- Ѥʤä겾̾Ȥθ䷲ + "[" + 
          ;; Ѥ겾̾ (겾̾Τߡ겾̾Ѥθ
          ;; ䷲ϡentry3 ˴ޤޤ)
          (progn
            (insert (mapconcat 'skk-quote-char entry2 "/" ) "/")
            ;; entry2  null ʤ entry3  null
            (if entry3
                ;; entry3 -- Ѥ겾̾Ȥȥ
                (insert (mapconcat 'skk-quote-char entry3 "/") "/") )
            ;; purge  entry3  null ˤʤä entry4 ĤäƤȤ
            ;; 롣
            (if entry4
                ;; entry4 -- "]" + ¾겾̾Ȥȥ (entry2 
                ;; Ĥ)
                (insert (mapconcat 'skk-quote-char entry4 "/") "/") ))))))

(defun skk-quote-char (word)
  ;; ¤鼭񥨥ȥ˴ޤƤϤʤʤʸ WORD ˤС
  ;; ɾȤˤʸȤʤ褦 Lisp ɤ֤
  (save-match-data
    (if (and word
             (string-match "[/\n\r\"]" word)
             ;; we should not quote WORD if it is a symbolic expression
             (not (skk-lisp-prog-p word)) )
        (concat "(concat \""
                (mapconcat (function (lambda (c)
                                       (cond ((eq c 47) ; ?/
                                              "\\057" )
                                             ((eq c 10) ; ?\n
                                              "\\n" )
                                             ((eq c 13) ; ?\r
                                              "\\r" )
                                             ((eq c 34) ; ?\"
                                              "\\\"" )
                                             ((eq c 92) ; ?\\
                                              "\\\\" )
                                             (t (char-to-string c)))))
                           ;; ʸб char ΥꥹȤʬ򤹤롣
                           (append word nil) "")
                "\")")
      word )))

(defun skk-lisp-prog-p (word)
  ;; word  Lisp ץǤСt ֤
  (let ((l (length word)))
    (and (> l 2)
         (eq (aref word 0) 40) ; ?\(
         (< (aref word 1) 128)
         (eq (aref word (1- l)) 41) ))) ; ?\)

(defun skk-public-jisyo-contains-p (midasi okurigana word)
  ;; ͭ MIDASHI ڤӤб WORDS ȥäƤС
  ;; non-nil ֤ץ饤١ȼΥХåեǥ뤵롣
  (let (fn skk-henkan-okuri-strictly)
    (setq skk-henkan-key midasi)
    (if okurigana
        (setq skk-henkan-okurigana okurigana) )
    (if (and (not (featurep 'skk-server))
             (or (and (boundp 'skk-server-host) skk-server-host)
                 (and (boundp 'skk-servers-list) skk-servers-list)
                 (getenv "SKKSERVER")
                 (getenv "SKKSERV") ))
        (require 'skk-server) )
    (if (and (featurep 'skk-server)
             (or (and skk-server-host skk-server-prog)
                 skk-servers-list ))
        (setq fn (assq 'skk-search-server skk-search-prog-list)) )
    ;; skk-search-server ϤޤꥹȤʤСȤˤ礭
    ;; ˤƤ skk-search-jisyo-file ץõ
    (if (and (not fn) (or skk-aux-large-jisyo skk-large-jisyo))
        (let ((spl skk-search-prog-list)
              cell )
          (while (setq cell (car spl))
            (if (and (eq (car cell) 'skk-search-jisyo-file)
                     (member (nth 1 cell)
                             '(skk-aux-large-jisyo skk-large-jisyo) ))
                (setq fn cell
                      spl nil )
              (setq spl (cdr spl)) ))))
    (and fn (member word (eval fn))) ))

(defun skk-compose-ignore-entry (entry &optional add)
  ;; ENTRY  skk-ignore-dic-word ؿǥȤȥ꤬
  ;; СĤΥȥˤޤȤ롣
  ;; ץʥ ADD ꤵƤ顢ADD ޤ᤿
  ;; skk-ignore-dic-word ȥ롣
  ;;  skk-ignore-dic-word ȥ car ˡʳΥȥ cdr ˤ
  ;; ꥹȤ֤
  (let (l arg e)
    (if add (setq entry (delete add entry)))
    (setq l entry)
    (save-match-data
      (while l
        (setq e (car l)
              l (cdr l) )
        (if (string-match "(skk-ignore-dic-word +\\([^\)]+\\))" e)
            (setq arg (concat arg
                              (substring e (1+ (match-beginning 1))
                                         (1- (match-end 1)) )
                              "\" \"" )
                  entry (delq e entry) )))
      (if add
          (setq arg (if arg (concat arg add) add))
        ;;  " \"" ڤȤ
        (setq arg (substring arg 0 -2)) )
      (cons (concat "(skk-ignore-dic-word \"" arg "\")") entry) )))

;;; Autoload the other portions of the package.
(mapcar (function
	 (lambda (set)
	   (mapcar (function
		    (lambda (func)
		      (autoload func (car set) nil (nth 1 set) (nth 2 set)) ))
                   (nthcdr 3 set) )))
        '(("skk-auto" nil nil
           skk-init-auto-okuri-variables skk-okuri-search skk-remove-common
           skk-adjust-search-prog-list-for-auto-okuri )
          ("skk-comp" nil nil
           skk-completion skk-setup-dabbrev skk-start-henkan-with-completion )
          ("skk-gadget" nil nil
           skk-calc skk-convert-ad-to-gengo skk-convert-gengo-to-ad
           skk-ignore-dic-word skk-minus skk-plus skk-times )
          ("skk-gadget" t nil
           skk-clock skk-today )
          ("skk-kcode" t nil
           skk-display-code-for-char-at-point skk-input-by-code-or-menu )
          ("skk-num" nil nil
           skk-adjust-henkan-data-for-numerals skk-compute-noconv-henkan-key
           skk-compute-numeric-henkan-key skk-init-numeric-conversion-variables
           skk-noconv-kakutei-word skk-numeric-convert skk-numeric-midasi-word
           skk-update-jisyo-for-numerals )
          ;; non-interactive
          ("skk-server" nil nil skk-search-server)
          ;; interactive
          ("skk-server" t nil skk-server-version)
          ("skk-tree" nil nil skk-assoc-tree skk-compile-rule-list)
          ("skk-tut" t nil skk-tutorial)
          ("skk-vip" nil nil skk-vip-mode)
          ("skk-kakasi" t nil skk-gyakubiki-katakana-message
           skk-gyakubiki-katakana-region skk-gyakubiki-message skk-gyakubiki-region
           skk-hurigana-katakana-message skk-hurigana-katakana-region
           skk-hurigana-message skk-hurigana-region skk-romaji-message
           skk-romaji-region )
          ("skk-make" t nil skk-make) ))

;; for picture-mode
(add-hook 'edit-picture-hook 'skk-misc-for-picture 'append)

(run-hooks 'skk-load-hook)

(provide 'skk)
;;; skk.el ends here
