;;; skk-e19.el --- Emacs 19 ΤΥץ
;; Copyright (C) 1996, 1997 Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Version: 1.1.23
;; Keywords: japanese
;; Last Modified: Sat Jan 25 17:49:45 1997

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:
;;
;; Following people contributed modifications to skk.el (Alphabetical order):
;;      Kazuo Hirokawa <hirokawa@rics.co.jp>
;;      Kiyotaka Sakai <ksakai@netwk.ntt-at.co.jp>
;;      Masatake YAMATO <jet@airlab.cs.ritsumei.ac.jp>
;;      Mikio Nakajima <gy2m-nkjm@asahi-net.or.jp>
;;      Murata Shuuichirou <mrt@mickey.ai.kyutech.ac.jp>
;;      Sekita Daigo <sekita@mri.co.jp>
;;      ƣ͵ <shindo@super.ees.saitama-u.ac.jp>
;       ӿ  (ma-tsuge@kdd.co.jp)
;;
;; Masatake YAMATO <jet@airlab.cs.ritsumei.ac.jp> Τˤʤä
;; skk-cursor.el ߤޤץ򤪺ˤʤä Yamato 
;; ˴դޤ
;;
;;; Change log:
;; version 1.1.23 released 1997.1.25 (derived from the skk.el 8.6)

;;; Code:

;; skk-e19.el  skk.el  require Τǡְ㤨Ƥ (require 'skk) 
;; ƤϤʤ
(require 'advice)
(require 'queue-m)

;; necessary macro and functions to be declared before user variable declarations.
(defmacro skk-defvar (symbol initvalue docstring &optional tut-value)
  "\(defvar SYMBOL INITVALUE DOCSTRING\) ɾ塢SYMBOL  skktut-value
° INITVALUE Ϳ롣
ץʥ TUT-VALUE ꤹȡskktut-value ° INITVALUE 
 TUT-VALUE Ϳ롣
TUT-VALUE  nil ꤷϡ'false Ϥ"
  (list 'progn
    (list 'defvar symbol initvalue docstring)
    (list 'if (list 'eq
                    (list 'skk-get (list 'quote symbol) (list 'quote 'skktut-value)
                          (list 'quote 'false) )
                    (list 'quote 'false) )
          (list 'put (list 'quote symbol) (list 'quote 'skktut-value)
                (list 'cond (list (list 'not tut-value) initvalue)
                      (list (list 'eq tut-value (list 'quote 'false))
                            nil )
                      (list t tut-value) )))))
                ;;(cond ((not tut-value) initvalue)
                ;;      ((eq tut-value 'false)
                ;;            nil )
                ;;      (t tut-value) )))))

(put 'skk-defvar 'lisp-indent-function 'defun)

(defun skk-get (symbol property-name &optional default)
  ;; SYMBOL °ꥹȤ PROPERTY-NAME Ȥ°̾Ф°֤ͤ
  ;; ʤ DEFAULT ֤ (DEFAULT ꤵƤʤ NIL)°̾
  ;; Ӥϡeq ǹԤʤ
  (if default
      (let ((pl (memq property-name (symbol-plist symbol))))
        (if pl (nth 1 pl) default) )
    (get symbol property-name) ))

(defun skk-terminal-face-p ()
  (and (not window-system)
       (fboundp 'frame-face-alist) ;; ѿ̾ߤʴؿ...
       (fboundp 'selected-frame) ))

(defconst skk-background-mode
  ;; from font-lock-make-faces of font-lock.el  Welcome!
  (if (and window-system (x-display-color-p))
      (let ((bg-resource (x-get-resource ".backgroundMode"
                                         "BackgroundMode"))
            params )
        (if bg-resource
            (intern (downcase bg-resource))
          (setq params (frame-parameters))
          ;; Mule for Win32  Windows 95 ưƤȤϡsystem-type ϡ
          ;; -> windows-nt Ǥ -- Mikio (Ҥ Win 95  Mule for Win32 
          ;; 줿)
          (cond ((and (eq system-type 'windows-nt)
                      (fboundp 'win32-color-values) )
                 (< (apply '+ (win32-color-values
                               (cdr (assq 'background-color params)) ))
                    (/ (apply '+ (win32-color-values "white")) 3) )
                 'dark )
                ((and (memq system-type '(ms-dos windows-nt))
                      (fboundp 'x-color-values) )
                 (if (string-match "light"
                                   (cdr (assq 'background-color params)) )
                     'light
                   'dark ))
                ((< (apply '+ (x-color-values
                               (cdr (assq 'background-color params)) ))
                    (/ (apply '+ (x-color-values "white")) 3) )
                 'dark )
                (t 'light) )))
    'mono ))

;;;; variables declaration
;;; user variables
(skk-defvar skk-henkan-face
  (if (and (or window-system (skk-terminal-face-p))
           (assq 'highlight (frame-face-alist (selected-frame))) )
      'highlight )
  "*Ѵ face °skk-use-face  non-nil ΤȤΤͭ
Emacs ɸե default, modeline, region, secondary-selection,
highlight, underline, bold, italic, bold-italic ¾ face ꤹ
뤳Ȥǽ
 face ꤹˤ skk-make-face Ѥơ

      \(skk-make-face 'DimGray/PeachPuff1\)
      \(setq skk-henkan-face 'DimGray/PeachPuff1\)

Τ褦ˤΤڡforeground  background οǤʤŤä face
ϡskk-make-face ǤбǤʤΤǡEmacs  hilit19.el 
hilit-lookup-face-create ʤɤѤ롣դۿϡcanna.el 
canna:attribute-alist ɤ㤫⤷ʤ" )

(skk-defvar skk-use-color-cursor (and window-system
                                      (fboundp 'x-display-color-p)
                                      (x-display-color-p) )
  "*Non-nil ǤСSKK ⡼ɤϥ⡼ɤ˱ƥ˿դ롣")

(skk-defvar skk-default-cursor-color
  (cdr (assq 'cursor-color (frame-parameters (selected-frame))))
  "*SKK Υդ򼨤뿧" )

;; طʿˤƻѤƤǡɤۿФΤ餻
(skk-defvar skk-kana-cursor-color (if (eq skk-background-mode 'light)
                                      "coral4"
                                    "pink" )
  "*ʥ⡼ɤ򼨤뿧" )

(skk-defvar skk-katakana-cursor-color (if (eq skk-background-mode 'light)
                                          "forestgreen"
                                        "green" )
  "*ʥ⡼ɤ򼨤뿧" )

(skk-defvar skk-zenkaku-cursor-color "gold"
  "*ѱѻ⡼ɤ򼨤뿧" )

(skk-defvar skk-ascii-cursor-color (if (eq skk-background-mode 'light)
                                       "ivory4"
                                     "gray" )
  "*⡼ɤ򼨤뿧" )

;; My fovorite setting is `skk-zenkaku-cursor-color' == "gold",
;; `skk-katakana-cursor-color' == "green", `skk-kana-cursor-color' ==
;; "royalblue", `skk-ascii-cursor-color' == "red".  ɽϤ˳Ρȥޥ
;; ξ硢ȤäƤ줰餤Ū˥뿧Ѥʤʬˤ
;; -- Mikio

(skk-defvar skk-report-set-cursor-error t
  "*Non-nil ǤС顼ޥåڤ줬硢顼åɽ롣
nil ǤСɽʤ" )

(skk-defvar skk-e19-load-hook nil
  "*skk-e19 򥳡뤷˥뤵եå" )

;;; internal variables
(defvar skk-emacs19 t
  "Non-nil ǤСEmacs 19  SKK ѤƤ뤳Ȥ򼨤" )

(defvar skk-mule24 (and (featurep 'mule) (string< "2.4" mule-version))
  "Non-nil ǤСMule 2.4  SKK ѤƤ뤳Ȥ򼨤" )

(defvar skk-coding-system-alist
  (if skk-mule24
      '(("euc" . euc-japan)
        ("ujis" . euc-japan)
        ("sjis". sjis)
        ("jis" . junet) )
    '(("euc" . *euc-japan*)
      ("ujis" . *euc-japan*)
      ("sjis". *sjis*)
      ("jis" . *junet*) )))

(defvar skk-menu-annotation-buffer "*SKK Menu Annotation*"
  "SKK ˥塼ΤɽХåե" )

(defvar skk-menu-modified-user-option nil
  "SKK ˥塼ޥɤѹ줿桼ѿݻꥹȡ"  )

(defvar skk-henkan-overlay nil
  "ɽȤ˻Ѥ Overlay" )
(make-variable-buffer-local 'skk-henkan-overlay)

(defconst skk-ml-address "skk@kuis.kyoto-u.ac.jp")

;; version specific matter
(if (string< "19.29" emacs-version)
    ;; For emacs 19.29, 19.30...
    (progn
      (defalias 'skk-buffer-substring 'buffer-substring-no-properties)
      )
  ;; For emacs 19...19.28
  (defalias 'skk-buffer-substring 'buffer-substring)
  (or (fboundp 'rassoc)
      (defun rassoc (key alist)
        (cond ((null alist) nil)
              ((and (consp (car alist))
                    (equal key (cdr (car alist))) (car alist)))
              (t (rassoc key (cdr alist))) )))
  (or (fboundp 'add-to-list)
      (defun add-to-list (list-var element)
        "Add to the value of LIST-VAR the element ELEMENT if it isn't there yet.
        The test for presence of ELEMENT is done with `equal'.
        If you want to use `add-to-list' on a variable that is not defined
        until a certain package is loaded, you should put the call to `add-to-list'
        into a hook function that will be run only after loading the package.
        `eval-after-load' provides one way to do this.  In some cases
        other hooks, such as major mode hooks, can do the job."
        (or (member element (symbol-value list-var))
            (set list-var (cons element (symbol-value list-var))) ))))

;;;###autoload

(defun skk-submit-bug-report ()
  "᡼ SKK ΥХݡȤ롣
reporter-mailer ꤹ뤳Ȥˤ깥ߤΥ᡼륤󥿡եѤ뤳
Ǥ롣㤨СMew ѤϲΤ褦ꤹ롣

    \(setq reporter-mailer '\(mew-send reporter-mail\)\)

reporter.el 3.2 Ǥϡѿ reporter-mailer ʤʤäΥСǤϡ

    \(setq mail-user-agent 'mew-user-agent\)

Ȼꤹ롣"
  (interactive)
  (require 'reporter)
  (if (and (boundp 'mail-user-agent)
           (eq mail-user-agent 'mew-user-agent) )
      (define-mail-user-agent 'mew-user-agent
        'mew-send 'mew-draft-send-letter 'mew-draft-kill ))
  (and (y-or-n-p "Do you really want to submit a report on SKK? ")
       (reporter-submit-bug-report
        skk-ml-address
        (concat "skk.el " (skk-version)
                (if (or (and (boundp 'skk-server-host) skk-server-host)
                        (and (boundp 'skk-servers-list) skk-servers-list)
                        (getenv "SKKSERVER")
                        (getenv "SKKSERV") )
                    (progn
                      (require 'skk-server)
                      (concat ", skkserv; " (skk-server-version)
                              (if (getenv "SKKSERVER")
                                  (concat ",\nSKKSERVER; "
                                          (getenv "SKKSERVER") ))
                              (if (getenv "SKKSERV")
                                  (concat ", SKKSERV; "
                                          (getenv "SKKSERV") ))))))
        (let ((base (list 'window-system
                          'skk-auto-okuri-process
                          'skk-auto-start-henkan
                          'skk-egg-like-newline
                          'skk-henkan-okuri-strictly
                          'skk-kakutei-early
                          'skk-process-okuri-early
                          'skk-search-prog-list
                          'skk-use-face
                          'skk-use-vip )))
          (if (boundp 'skk-henkan-face)
              (nconc base '(skk-henkan-face)) )
          (if (boundp 'skk-server-host)
              (nconc base '(skk-server-host)) )
          (if (boundp 'skk-server-prog)
              (nconc base '(skk-server-prog)) )
          (if (boundp 'skk-servers-list)
              (nconc base '(skk-servers-list)) )
          base ))))

(eval-after-load "hilit19"
                 '(hilit-add-pattern "^\\s *(skk-defvar\\s +\\S +" ""
                                     (cond ((eq skk-background-mode 'mono)
                                            'bold )
                                           ((eq skk-background-mode 'light)
                                            'RoyalBlue )
                                           (t 'cyan) )
                                     'emacs-lisp-mode ))

(eval-after-load "font-lock"
                 '(add-to-list 'lisp-font-lock-keywords-2
                               '("^(\\(skk-defvar\\)[ \t'\(]*\\(\\sw+\\)?"
                                 (1 font-lock-keyword-face)
                                 (2 font-lock-variable-name-face) )))

(eval-and-compile
  (if (not (boundp 'select-window-hook))
      ;; ХåեͤǤ skk-henkan-start-point,
      ;; skk-henkan-end-point, skk-kana-start-point, skk-okurigana-start-point 
      ;; νͤϤ nil Ǥ롣ͳˤĤƤϡ
      ;; <(skk.el/skk-make-henkan-marker)> 򻲾ȤΤȡ
      ;; Хåե skk-mode 뤵줿ϡskk-mode  
      ;; skk-make-henkan-marker ¹ԤΤǡskk-henkan-start-point,
      ;; skk-henkan-end-point, skk-kana-start-point, skk-okurigana-start-point 
      ;; ˤ줾쿷ޡΤʤ
      ;; read-from-minibuffer ΰ skk-minibuffer-map Ϥ Minibuf 
      ;; ä (<(skk.el/skk-henkan-in-minibuff:3)> ʤ)뤤ϡƵŪ
      ;; ϿԤʤäƥꥫ֤ Minibuf äꤷϡMinibuf 
      ;;  skk-mode 뤵ʤΤǡ嵭ΥХåեͤ nil Τ
      ;; ޤˤʤäƤޤ skk-set-marker ޥ⤷ 
      ;; skk-select-window-func ϡ褷褦ȤΡ
      (defmacro skk-set-marker (marker position &optional buffer)
        (list 'progn
              (list 'if (list 'not marker)
                    (list 'setq marker (list 'make-marker)) )
              (list 'set-marker marker position buffer) ))
    (defalias 'skk-set-marker 'set-marker)
    (defun skk-select-window-func (old new)
      ;; select-window ؿ select-window-hook 򲼵Τ褦ˤƥ뤷
      ;; 뤳Ȥա
      ;;            call2 (Vselect_window_hook, oldwin, window);
      ;;
      ;; add-hook ȤäƤΥեå˴ؿɲä뤳ȤԲġޤ
      ;; ΥեåǤؿϡoldwin  window  2 Ĥ˻Ĵؿ
      ;; ΤߤǤ롣
      (save-excursion
        ;; skk.el  require ǤʤΤǡޥѤߤǤ뤳Ȥݾڤ
        ;; ʤ
        ;;(if (skk-in-minibuffer-p)
        (if (window-minibuffer-p (selected-window))
            (skk-make-henkan-marker) )
        (if skk-other-select-window-hook-func-list
            (mapcar (lambda (func) (funcall func old new))
                    skk-other-select-window-hook-func-list  ))))))

;;;; aliases
(defalias 'skk-backward-char 'backward-char)
(defalias 'skk-eventp 'eventp)
(defalias 'skk-forward-char 'forward-char)
(defalias 'skk-insert-and-inherit 'insert-and-inherit)
(defalias 'skk-read-char 'read-event)
(defalias 'skk-skip-chars-backward 'skip-chars-backward)

;;;; inline functions
;;(defsubst skk-delete-henkan-region (start end)
;;  ;; ηٹ˽start  end Υޡ򹹿˥Х쥤
;;  ;; 
;;  ;; ֥Х쥤ΥޡľѹƤޤȡۤνפʥǡ¤
;;  ;; Ԥ줺륪Х쥤Ф뤳Ȥˤʤ꤫ͤʤΤǡƤ
;;  ;; (Emacs Lisp Reference Manual edition 2.4 )
;;  (if skk-use-face (skk-henkan-face-off))
;;  (delete-region start end) )

(defsubst skk-do-auto-fill ()
  ;; auto-fill-function ͤƤСdo-auto-fill 򥳡뤹롣
  (and auto-fill-function (funcall auto-fill-function)) )

(defsubst skk-unread-event (event)
  ;; Unread single EVENT.
  (setq unread-command-events (cons event unread-command-events)) )

;;;; from dabbrev.el.  Welcome!
;; Ƚְ㤤Ȥ礢ꡣײɡ
(defsubst skk-minibuffer-origin ()
  (nth 1 (buffer-list)) )

;;;; defadvices.
;; defadvice ȡǥ桼εǽդƹ defadvice 
;; ư
(defadvice save-buffers-kill-emacs (before skk-ad activate)
  "SKK 򥻡֤ơEmacs λ롣
ָ塢skk-before-kill-emacs-hook ¹ԤƤ Emacs 򥭥뤹롣"
  ;; defadvice ݡ advice ؿȤϰ㤦ˡǰϤ򤷤ʳϡ
  ;; interactive + descripter פʤߤ
  ;;(interactive "P")
  (skk-save-jisyo)
  (run-hooks 'skk-before-kill-emacs-hook) )

(defadvice picture-mode-exit (before skk-ad activate)
  "SKK ΥХåեѿ̵ˤpicture-mode-exit 򥳡뤹롣
picture-mode ФȤˤΥХåե SKK ưν"
  (if (and (boundp 'skk-mode) skk-mode) (skk-kill-local-variables)) )

(defadvice undo (before skk-ad activate)
  "SKK ⡼ɤ on ʤ skk-self-insert-non-undo-count 롣"
  (if (and (boundp 'skk-mode) skk-mode)
      (setq skk-self-insert-non-undo-count 0) ))

;;; cover to functions available only in windows.
;;(defadvice kill-region (around skk-ad activate)
;;  "SKK ΢⡼ɤ⡼ɤä顢ꤷƤ꡼򥭥뤹롣
;;  ꤹ뤳Ȥǡ⡼ɤǤ disable-undo  t ˥åȤƤΤǡnil 
;;  åȤľθ塢꡼򥭥뤹롣"
;;  ;; skk-mode  nil ʤŻԤʤʤɤ
;;  ;;(if (and (boundp 'skk-mode) skk-mode skk-use-face skk-henkan-on)
;;  (if (and (boundp 'skk-mode) skk-mode skk-henkan-on)
;;      (let ((param0 (ad-get-arg 0))
;;            (param1 (ad-get-arg 1))
;;            (start (make-marker))
;;            (end (make-marker)) )
;;        ;; ꤹȡХåե΢䢧äΤǡkill-region ΰͤ
;;        ;; ֤ؤƤʤǡޡˤƤ
;;        ;;
;;        ;; (interactive "r") ǼϡͤѴ롩  ΰ
;;        ;; ޡǤϤʤΤˡmarkerp ǸФǤʤ
;;        (set-marker start param0)
;;        (set-marker end param1)
;;        (ad-set-arg 0 start)
;;        (ad-set-arg 1 end)
;;        (skk-kakutei)
;;        ad-do-it
;;        ;; ȤƤʤޡϡGarbage Collection 뤵줿Ȥ
;;        ;; 뤬ޤǤδ֡ƥȤΤɤؤƤȡƥ
;;        ;; ȤΥåץǡȤκݤˤΥޡͤ򹹿ɬפΤǡɤ
;;        ;; ؤʤ褦ˤ롣
;;        (set-marker start nil)
;;        (set-marker end nil) )
;;    ad-do-it ))

(defadvice kill-buffer (around skk-ad activate)
  "SKK ΢⡼ɤä顢ꤷƤХåե򥭥뤹롣
  ХåեΥ塢SKK Υ⡼ɤ˽οѤ롣"
  (if (and (boundp' skk-mode) skk-mode)
      ;;(and skk-use-face skk-henkan-active (skk-kakutei)) )
      (and skk-henkan-on (skk-kakutei)) )
  ad-do-it
  ;; ̤ΥХåե֥ޥɤ skk-mode  nil Ǥ⥫뿧Ĵɬ
  ;; 롣
  (if (and (boundp' skk-mode) (not (boundp 'select-window-hook)))
      (skk-set-cursor-color-properly) ))

(defadvice use-local-map (after skk-add activate)
  "¾ѥå local map 򤹤ؤˡSKK ⡼ɤǤ뤳Ȥ򼨤ĳä"
  (if (and skk-mode (not (window-minibuffer-p (selected-window))))
      ;; SKK ⡼ɤưƤƥȥɥߥ˥ХåեǤʤ
      (let (;; (command (prin1-to-string this-command))
            (map (ad-get-arg 0)) )
        ;; run-hooks ǸƤФ뤫⤷ʤΤǡΥåˡǤԽʬ
        ;;(if (and (> (length command) 3)
        ;;         (string= "skk" (substring command 0 3)) )
        ;;    nil
        ;; "skk-" ץեåդޥɰʳ use-local-map 
        ;; 뤵줿
        (if (or
             ;; ϥ⡼ɤȥޥåפ԰ס
             (and skk-j-mode
                  (not (where-is-internal 'skk-set-henkan-point map t))
                  (eq (nth 1 mode-line-format) 'skk-mode-line)
                  (or
                   (and skk-katakana
                        (not (string= skk-mode-line skk-katakana-mode-string)) )
                   (not (string= skk-mode-line skk-hirakana-mode-string)) ))
             (and skk-zenkaku
                  (not (where-is-internal 'skk-zenkaku-insert map t))
                  (eq (nth 1 mode-line-format) 'skk-mode-line)
                  (not (string= skk-mode-line skk-zenei-mode-string)) )
             (and skk-abbrev
                  (not (where-is-internal 'skk-abbrev-comma map t))
                  (eq (nth 1 mode-line-format) 'skk-mode-line)
                  (or
                   (and skk-katakana
                        (not (string= skk-mode-line skk-katakana-mode-string)) )
                   (not (string= skk-mode-line skk-hirakana-mode-string)) ))
             ;; SKK ⡼ (SKK abbrev ⡼ɰʳSKK abbrev ⡼ɤʤ
             ;; ϥ⡼ɤʤ) ޥåפ skk-kakutei 
             ;; γդʤ
             (and (not (or skk-j-mode skk-zenkaku skk-abbrev))
                  (not (where-is-internal 'skk-kakutei map t))
                  (eq (nth 1 mode-line-format) 'skk-mode-line)
                  (not (string= skk-mode-line skk-mode-string)) ))
            (progn
              (setq skk-mode nil
                    skk-j-mode nil
                    skk-zenkaku nil
                    skk-abbrev nil
                    ;;mode-line-format (cdr mode-line-format)
                    mode-line-format (delq 'skk-mode-line mode-line-format)
                    skk-org-mode-line-format nil )
              (force-mode-line-update) ))
        (and skk-okurigana (skk-delete-okuri-mark))
        (skk-delete-henkan-markers 'nomsg)
        ;;(skk-kakutei-cleanup-henkan-buffer)
        (skk-kakutei-save-and-init-variables) )))

;; cover to skk functions.
(defadvice skk-zenkaku-eiji (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color skk-zenkaku-cursor-color) )

(defadvice skk-toggle-kana (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣" 
  (skk-set-cursor-color (if skk-katakana
                            skk-katakana-cursor-color
                          skk-kana-cursor-color )))

(defadvice skk-mode-off (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color skk-ascii-cursor-color) )

(defadvice skk-mode-off-in-minibuff (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color skk-ascii-cursor-color) )

(defadvice skk-kakutei (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color (if skk-katakana
                            skk-katakana-cursor-color
                          skk-kana-cursor-color )))

(defadvice skk-mode (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color (if skk-mode
                            skk-kana-cursor-color
                          skk-default-cursor-color )))

(defadvice skk-auto-fill-mode (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color (if skk-mode
                            skk-kana-cursor-color
                          skk-default-cursor-color )))

(defadvice skk-ascii-region (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-katakana-region (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-hiragana-region (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-save-jisyo (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-zenkaku-region (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-gyakubiki-region (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-gyakubiki-message (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-gyakubiki-katakana-region (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-gyakubiki-katakana-message (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-hurigana-region (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-hurigana-message (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-hurigana-katakana-region (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-hurigana-katakana-message (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-romaji-region (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

(defadvice skk-romaji-message (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (skk-set-cursor-color-properly) )

;; cover to original functions.
(defadvice query-replace-regexp  (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) (skk-set-cursor-color-properly)) )

(defadvice query-replace (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) (skk-set-cursor-color-properly)) )

(defadvice goto-line (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) skk-mode (skk-set-cursor-color-properly)) )

(defadvice yank (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) skk-mode (skk-set-cursor-color-properly)) )

(defadvice yank-pop (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) skk-mode (skk-set-cursor-color-properly)) )

(defadvice recenter (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) skk-mode (skk-set-cursor-color-properly)) )

;; ̤ΥХåե֥ޥɤ skk-mode  nil Ǥ⥫뿧Ĵɬפ
;; 롣
(defadvice bury-buffer (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) (skk-set-cursor-color-properly)) )

(defadvice switch-to-buffer (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) (skk-set-cursor-color-properly)) )

;; cover to hilit19 functions.
;; forward advice  automatic advice activation ǽ뤫顢hilit19.el 
;; Υ defadvice Ƥס
;;(if (not (fboundp 'hilit-add-pattern))
;;    nil
(defadvice hilit-yank (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) skk-mode (skk-set-cursor-color-properly)) )

(defadvice hilit-yank-pop (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) skk-mode (skk-set-cursor-color-properly)) )

(defadvice hilit-recenter (after skk-ad activate)
  "SKK Υ⡼ɤ˽οѤ롣"
  (and (boundp 'skk-mode) skk-mode (skk-set-cursor-color-properly)) )

(if (boundp 'select-window-hook)
    (progn

      (add-hook
       'skk-e19-load-hook
       (function
        (lambda ()
          (setq select-window-hook 'skk-cursor-select-window-hook) )))

      (defun skk-cursor-select-window-hook (old new)
        ;; OLD  NEW ñ̵뤹롣NEW Υɥǥ뤵롣
        (skk-set-cursor-color-properly) ))

  ;; select-window-hook Фʤ defadvice ã
  (defadvice execute-extended-command (after skk-ad activate)
    "SKK Υ⡼ɤ˽οѤ롣"
    (and (boundp 'skk-mode) (skk-set-cursor-color-properly)) )

  (defadvice pop-to-buffer (after skk-ad activate)
    "SKK Υ⡼ɤ˽οѤ롣"
    (and (boundp 'skk-mode) (skk-set-cursor-color-properly)) )
    
  ;; abort-recursive-edit Ǥϡafter original command ذܹԤ˥ܡ
  ;; Ƥޤ
  ;;(defadvice abort-recursive-edit (after skk-ad activate)
  ;;  "SKK Υ⡼ɤ˽οѤ롣"
  ;;  (and (boundp 'skk-mode) (skk-set-cursor-color-properly)) )
  ;;
  (defadvice abort-recursive-edit (before skk-ad activate)
    "SKK Υ⡼ɤ˽οѤ롣"
    (if (boundp 'skk-mode) 
        (save-excursion
          ;; ʣ window 򳫤Ƥʤɤϡưβǽꡣ
          (set-buffer (skk-minibuffer-origin))
          (skk-set-cursor-color-properly) )))

  (defadvice other-window (after skk-ad activate)
    "SKK Υ⡼ɤ˽οѤ롣"
    (and (boundp 'skk-mode) (skk-set-cursor-color-properly)) ))

(add-hook 'after-make-frame-hook 'skk-set-cursor-color-properly)
(add-hook 'minibuffer-setup-hook 'skk-set-cursor-color-properly-in-minibuff)

;;;; functions
;;;###autoload
(defun skk-kill-emacs-without-saving-jisyo (&optional query)
  "SKK 򥻡֤ʤǡEmacs λ롣
skk-before-kill-emacs-hook ¹ԤƤ Emacs 򥭥뤹롣"
  (interactive "P")
  ;; format ˻ϡskk-yes-or-no-p ȤȤäƾĹˤʤ롣
  ;; ޤskk.el  require ǤʤΤǡޥѤߤǤ뤳Ȥݾڤ
  ;; ʤ
  ;; (if (skk-yes-or-no-p
  (if (yes-or-no-p
       (format (if skk-japanese-message-and-error
                   "¸򤻤 %s λޤɤǤ"
                 "Do you really wish to kill %s without saving Jisyo? " )
               (if skk-mule "Mule" "NEmacs") ))
      (let ((buff (skk-get-jisyo-buffer skk-jisyo 'nomsg)))
        (if buff
            (progn (set-buffer buff)
                   (set-buffer-modified-p nil)
                   (kill-buffer buff) ))
        (run-hooks 'skk-before-kill-emacs-hook)
        (ad-remove-advice 'save-buffers-kill-emacs 'before 'skk-ad)
        (save-buffers-kill-emacs query) )))

;; for delsel.el
;; defadvice ǤǤǤʤ...
;;;###autoload
(defun skk-minibuffer-keyboard-quit ()
  "ꥫ֥ǥåȤߤ롣
Delete Selection ⡼ɤǤϡޡƥ֤äǥƥ֤ˤ롣
2 ܤϥꥫ֥ǥåȤߤ롣"
  (interactive)
  (if (and delete-selection-mode transient-mark-mode mark-active)
      (setq deactivate-mark t)
    (if (and (boundp 'skk-mode) skk-mode)
        (skk-keyboard-quit)
      (abort-recursive-edit) )))

(add-hook 'minibuffer-setup-hook
          (function
           (lambda ()
             (if (and (boundp 'delete-selection-mode)
                      delete-selection-mode
                      (not (get 'minibuffer-keyboard-quit 'skk)) )
                 (progn
                   (put 'minibuffer-keyboard-quit
                        'old-definition
                        (symbol-function 'minibuffer-keyboard-quit) )
                   (put 'minibuffer-keyboard-quit 'skk t)
                   (defalias 'minibuffer-keyboard-quit
                     (symbol-function 'skk-minibuffer-keyboard-quit) ))))))

(defun skk-set-jisyo-code ()
  ;; ʸɤ CODE ˥åȤ롣
  (if (not skk-jisyo-code)
      nil
    (if (stringp skk-jisyo-code)
        (setq skk-jisyo-code (cdr
                              (assoc skk-jisyo-code skk-coding-system-alist) )))
    (if (fboundp 'set-buffer-file-coding-system)
        (set-buffer-file-coding-system skk-jisyo-code)
      (set-file-coding-system skk-jisyo-code) )))

(defun skk-ascify-event (event)
  ;; Return ascii equivallent of EVENT.
  (cond ((symbolp event)
	 ;; mask is (BASE-TYPE MODIFIER-BITS) or nil.
	 (let ((mask (get event 'event-symbol-element-mask)))
	   (if mask
	       (let ((base (get (car mask) 'ascii-character)))
		 (if base
		     (logior base (car (cdr mask))))))))
	((integerp event)
	 event)
	(t nil)))

(defun skk-convert-to-vector (map)
  ;; MAP ¤ʥޥå (sparse map) ä̩ʥޥå (full keymap) 
  ;; Ѵ롣MAP ̩ʥޥåפä顢MAP 򥳥ԡ롣ѴΥ
  ;; ޥåפ֤
  ;;
  ;; skk-map θˤʤΤ current-local-map  (sparse keymap) Ǥ롣
  ;; skk-define-map ǥХɤ륭 100 ĶƤꡢꥹȥ١
  ;;  sparse keymap ˥ХɤΤǤϡꥹȤĹʤꤹơ
  ;; ǤؤΥôȤʤΤǡcurrent-local-map ͤ full keymap Ǥ
  ;; ٥ѴȤɬפȤʤ롣
  ;; 
  ;; skk-mode Ǿ񤭤ǽΤ륭ޤƤȤˤƤ
  ;; current-local-map ΥХ (٥ȥפ) եޥåפ
  ;; Ƥޤ
  (if (vectorp (nth 1 map))
      (copy-keymap map)
    (let* ((l (if (keymapp map)
                  (cdr map)
                ;; skk.el  require ǤʤΤǡޥѤߤǤ뤳
                ;; ݾڤǤʤ
                ;;(skk-error
                (error (if skk-japanese-message-and-error
                           "%S ϥޥåפǤϤޤ"
                         "%S is not a keymap" ) map)))
           (new-map (make-keymap))
           (array (nth 1 new-map))
           event-bind-list menu-bar-bind-list )
      (while l
        (setq e (car l))
        (cond ((eq e 'keymap)
               ;; ޥåפηѾ򤷤硣
               (let ((n 0) table bind)
                 (cond ((vectorp (nth 1 l))
                        (setq table (nth 1 l))
                        (let ((max (length table))
                              (array-length (length array)) )
                          (if (> max array-length)
                              (progn
                                (setq array
                                      (vconcat
                                       array
                                       (make-vector (- max array-length) nil) ))
                                ;; vconcat Ǻ٥ȥϿ֥Ȥ
                                ;;  (nth 1 new-map) μΤ夨Ƥ
                                (setcar (nthcdr 1 new-map) array) ))
                          (while (> max n)
                            (setq bind (aref table n))
                            (if bind
                                (skk-convert-to-vector-subr array n bind) )
                            (setq n (1+ n)) )
                          ;; (nth 1 l) ϴ˽Τǡ1 ĥåפƤ
                          (setq l (cdr l)) ))
                       ((listp (cdr l))
                        (let ((rest (memq 'keymap (cdr l))) )
                          (setq table (cdr l))
                          (if rest
                              ;; ޤѾƤޥåפ롣
                              (setq table (skk-remove rest (cdr l))) )
                          (if (eq (car (car table)) 'menu-bar)
                              (setq menu-bar-bind-list (append
                                                        (nthcdr 2 (car table))
                                                        menu-bar-bind-list )
                                    ;; Τϥ˥塼Сޥåפ
                                    l (cdr l) )
                            (while (setq bind (nth n table))
                              (if (and (not (integerp (car bind)))
                                       (symbolp (car bind)) )
                                  (setq event-bind-list (cons bind
                                                              event-bind-list ))
                                (skk-convert-to-vector-subr
                                 array (car bind) (cdr bind) ))
                              (setq n (1+ n)) )
                            ;; Ĥ l  rest ʳƽѤߡ
                            ;; äȴʤdummy ˺Ȥädummy
                            ;;  while loop Ǽ롣
                            (setq l (cons 'dummy rest)) ))))))
              ;; ˥塼Сޥå
              ((eq (car e) 'menu-bar)
               (setq menu-bar-bind-list (append (nthcdr 2 e) menu-bar-bind-list)) )
              ;; ܡɥ٥ȰʳΥ٥ȥפΥХ
              ((and (not (integerp (car e))) (symbolp (car e)))
               (setq event-bind-list (cons e event-bind-list)) )
              ;; ¾
              (t
               (skk-convert-to-vector-subr array (car e) (cdr e)) ))
        (setq l (cdr l)) )
      (if menu-bar-bind-list
          ;; Ϣˡϡcurrent-global-map η򻲹ͤˤ
          (nconc new-map (list (nconc (list 'menu-bar 'keymap)
                                      menu-bar-bind-list ))))
      (if event-bind-list
          (nconc new-map event-bind-list) )
      new-map )))

(defun skk-convert-to-vector-subr (array bind def)
  ;; ARRAY  BIND ǥ DEF 롣
  (if (not (keymapp def))
      (if (not (aref array bind))
          ;; ˥ХɤƤΤƤäס
          (aset array bind def) )
    (let ((bound (aref array bind)))
      (if bound
          (if (keymapp bound)
              (aset array bind (nconc bound (list (cons bind def)))) )
        (aset array bind (copy-keymap def)) ))))

(defun skk-use-local-map (map)
  (let (skk-mode) ; dummy for advised use-local-map.
    (use-local-map map) ))

(defun skk-remove (e l)
  ;; remove E from L and returun newly created list.
  (let ((queue (queue-create)))
    (while l
      (if (not (equal e (car l)))
          (queue-enqueue queue (car l)) )
      (setq l (cdr l)) )
    (queue-all queue) ))

;; ä Lisp ϺƵʤEmacs 衢᤯ tail recursive ˤʤäƤ...
;;(defun remove (e l)
;;  (cond ((null l) nil)
;;        ((equal e (car l))
;;         (remove e (cdr l)) )
;;        (t (cons (car l) (remove e (cdr l)))) ))

(defun skk-henkan-face-on ()
  ;; skk-use-face  non-nil ξ硢skk-henkan-start-point 
  ;; skk-henkan-end-point δ֤ face ° skk-henkan-face ͤѹ롣
  ;;
  ;; SKK 9.4  Text Properties ѤΤߤơOverlays Ѥ
  ;; ˤ (egg.el, canna.el, wnn-egg.el 򻲹ͤˤ)
  ;; Overlays ϡƥȤΰǤϤʤΤǡХåեʸڤФƤ⥳
  ;; ԡоݤˤʤʤɥ̵뤵ΤǡѴ줿ɽ
  ;; Ūѹˤ Text Properties ⹥ԹǤ롣
  ;;
  ;; âOverlays  Text Properties 갷դ٤롣
  ;; Х쥤ΥޡľѹƤޤȡۤνפʥǡ¤ι
  ;; Ԥ줺륪Х쥤Ф뤳Ȥˤʤ꤫ͤʤ (Overlay 
  ;; BufferϰϤѹȤϡɬ move-overlay ѤʤФʤʤ)
  ;; ȤǤ롣skk-henkan-face-on Ѵ̤θ˴ؤ
  ;; skk-henkan-overlay 򿷵˺äƤ (뤤ϴ¸ Overlay Ľ
  ;; ˰ưƤ) skk-henkan-face-off ǾõޤǤδ֤
  ;; skk-henkan-start-point  skk-henkan-end-point ΥƥȤȡ
  ;; Ū move-overlay ѤΥޡͤ򹹿뤳Ȥˤʤä
  ;; ޤskk-henkan-start-point  skk-henkan-end-point δ֤ˤ
  ;; ȤѹäȤϡ skk-henkan-face-off ǰö
  ;; skk-henkan-overlay äɬפ (<(skk-e19.el/kill-region)>)
  ;;
  ;;From: enami tsugutomo <enami@ba2.so-net.or.jp>
  ;;Subject: overlay (was Re: SKK-9.4.15)
  ;;Date: 23 Oct 1996 16:35:53 +0900
  ;;Message-ID: <87n2xe5e06.fsf@plants-doll.enami.ba2.so-net.or.jp>
  ;;
  ;;enami> ؿ skk-henkan-face-on  comment 
  ;;enami> 
  ;;enami>   ;; âOverlays  Text Properties 갷դ٤롣
  ;;enami>   ;; Х쥤ΥޡľѹƤޤȡۤνפʥǡ¤ι
  ;;enami>   ;; Ԥ줺륪Х쥤Ф뤳Ȥˤʤ꤫ͤʤ
  ;;enami> 
  ;;enami>  (ڤӤʹ) ʬ˴ؤƤǤ, make-overlay ǰ֤λ˻Ȥ
  ;;enami>  marker Τޤ overlay ΰȤƻȤ, 򤷤Ƥޤ
  ;;enami> Ǥ礦?
  ;;enami> 
  ;;enami> ºݤˤ overlay ΰ٤ marker ľܰư뤳ȤϤǤޤ
  ;;enami> , text κɲäˤưˤн褷ƤޤʤȻפޤ.
  ;;enami> 
  ;;enami> # Ǥʤä overlay ä̵ȤŤ餤ΤˤʤäƤޤ
  ;;enami> # .
  ;;enami> ʤ
  (let ((inhibit-quit t)
        cbuf )
    (if (and skk-henkan-face
             (setq cbuf (current-buffer))
             (eq (marker-buffer skk-henkan-start-point) cbuf)
             (eq (marker-buffer skk-henkan-end-point) cbuf)
             (marker-position skk-henkan-start-point)
             (marker-position skk-henkan-end-point) )
        (progn
          (or skk-henkan-overlay
              (setq skk-henkan-overlay (make-overlay skk-henkan-start-point
                                                     skk-henkan-end-point
                                                     nil cbuf )))
          (move-overlay skk-henkan-overlay skk-henkan-start-point
                        skk-henkan-end-point cbuf )
          ;; evaporate °դ٤...ǤѴ򷫤֤Ȥϡ
          ;; Τ顢ष˺äƤɤ⡣
          (overlay-put skk-henkan-overlay 'face skk-henkan-face) ))))

(defun skk-henkan-face-off ()
  ;; skk-henkan-start-point  skk-henkan-end-point δ֤ɽѹƤ
  ;; skk-henkan-overlay ä
  (and skk-henkan-face
       ;; ꥫ֥ߥ˥ХåեäȤϡoverlayp ˤ븡ɬס
       (overlayp skk-henkan-overlay)
       (delete-overlay skk-henkan-overlay) ))

(defun skk-set-cursor-color (color)
  ;; ο COLOR ѹ롣
  (if skk-use-color-cursor
      (condition-case nil
	  (set-cursor-color color)
	(error
	 (set-cursor-color skk-default-cursor-color)
	 (if skk-report-set-cursor-error
	     (message
	      (if skk-japanese-message-and-error
		  "顼ޥåڤǤǥեȤΥ顼Ȥޤ"
		"Color map is exhausting, use default cursor color" )))))))

(defun skk-set-cursor-color-properly ()
  ;; ȥХåե SKK Υ⡼ɤ˽οѹ롣
  (if skk-use-color-cursor
      (if (not (and (boundp 'skk-mode) skk-mode))
	  (skk-set-cursor-color skk-default-cursor-color)
	(skk-set-cursor-color (cond (skk-zenkaku skk-zenkaku-cursor-color)
				    (skk-katakana skk-katakana-cursor-color)
				    (skk-j-mode skk-kana-cursor-color)
				    (t skk-ascii-cursor-color) )))))

(defun skk-set-cursor-color-properly-in-minibuff ()
  (if skk-use-color-cursor
      (set-cursor-color
       (cond 
        ;; Minibuf  skk-zenkaku  skk-katakana ʤ t ˤʤä
        ;; 뤳ȤϤʤ
        ;;((and (boundp 'skk-zenkaku) skk-zenkaku)
        ;; skk-zenkaku-cursor-color )
        ;;((and (boundp 'skk-katakana) skk-katakana)
        ;; skk-katakana-cursor-color )
        ((where-is-internal 'skk-set-henkan-point (current-local-map) 'firstonly)
         ;; read-from-minibuffer Ȥäƥߥ˥ХåեȤ
         ;; (<(skk.el/skk-henkan-in-minibuff:3)> ʤ) ϡskk-j-mode ʤɤΥХ
         ;; եѿǥեͤΤޤޤˤʤäƤ롣嵭 
         ;; skk-zenkaku  skk-katakana  2 Ĥѿ skk-zenkaku-eiji  
         ;; skk-toggle-kana Υޥɤ򥳡뤹뤳ȤˤꡢŪ˥åȤ
         ;; 롣
         (setq skk-mode t
               skk-j-mode t )
         skk-kana-cursor-color )
        (t skk-default-cursor-color) ))))

(defun skk-make-face (face)
  ;; hilit-lookup-face-create Υ֥åȡtutorial ǿդԤʤǤ
  ;; hilit19 ˰¸Ȥꤢ face Ǻ뤳ȤǤ褦ˡȤ
  ;; ŪǺäΤǡñʿդʤǤʤޤ긭Ϥʤʣ
  ;; face ꤿͤ hilit-lookup-face-create ȤäƲ
  (or (car (memq face (face-list)))
      (let ((face-name (symbol-name face))
            fore back )
        (setq face (make-face face))
        (save-match-data
          (if (not (string-match "/" face-name))
              (set-face-foreground face face-name)
            (set-face-foreground
             face
             (substring face-name 0 (match-beginning 0)) )
            (set-face-background
             face
             (substring face-name (1+ (match-beginning 0))) ))
          face ))))
                        
(defun skk-keyboard-quit-1 ()
  (cond ;;(isearch-mode
        ;; (setq skk-isearch-message nil)
        ;; (isearch-abort) )
        ;; skk.el  require ǤʤΤǡޥѤߤǤ뤳Ȥݾڤ
        ;; ʤ
        ;;((not (skk-in-minibuffer-p))
        ((not (window-minibuffer-p (selected-window)))
         ;; keyboard.el 줿 mule-keyboard-quit ȤʤФʤʤ
         ;; ȤϤʤ
         (keyboard-quit) )
        ((and (boundp 'delete-selection-mode) delete-selection-mode
              transient-mark-mode mark-active )
         (setq deactivate-mark t) )
        (t
         (save-excursion
           (set-buffer (skk-minibuffer-origin))
           (skk-set-cursor-color-properly) )
         ;; νϡskk-henkan-in-minibuff
         ;; (<(skk.el/skk-henkan-in-minibuff:2)>) ǹԤʤ
         ;; ;; Хåե겾̾Ϣե饰򥪥դˤ롣
         ;;  (set-buffer (skk-minibuffer-origin))
         ;;  (setq skk-okurigana nil
         ;;        skk-okuri-char nil
         ;;        skk-henkan-okurigana nil ))
         (abort-recursive-edit) )))

;;(defun skk-reinvoke ()
;;  (let ((original-status
;;         (cond (skk-katakana 'katakana)
;;               (skk-zenkaku 'zenkaku)
;;               (skk-j-mode 'hirakana)
;;               (skk-mode 'ascii)
;;               (t 'unkown) )))
;;    (skk-mode 1)
;;    (cond ((eq original-status 'katakana)
;;           (setq skk-katakana t) )
;;          ((eq original-status 'zenkaku)
;;           (setq skk-zenkaku t) )
;;          ((eq original-status 'ascii)
;;           (setq skk-j-mode nil) )
;;          ((eq original-status 'hirakana)) )
;;    (skk-kakutei) ))

;; SKK-10.x Ǥ easymenu.el Ȥäƥɤñˤ뤾
;; from yatex19.el
(defun skk-define-sub-menu (map vec &rest bindings)
  "Define sub-menu-item in MAP at vector VEC as BINDINGS.
BINDINGS is a form with optional length: (symbol title binding).
When you defined menu-bar keymap such like:
  (define-key foo-map [menu-bar foo] (make-sparse-keymap \"foo menu\"))
and you want to define sub menu for `foo menu' as followings.
  foo ->  menu1  (calling function `func1')
          menu2  (doing interactive call `(func2 ...)'
Call this function like this:
  (skk-define-sub-menu foo-map [menu-bar foo]
   '(m1 \"Function 1\" func1)
   '(m2 \"Function 2\" (lambda () (interactive) (func2 ...))))
where
  `m1' and `m2' are the keymap symbol for sub-menu of `[menu-bar foo].
  `Funtion 1' and `Function 2' are the title strings for sub-menu."
  (let* ((veclen (length vec))
         (vec2 (make-vector (1+ veclen) nil))
         (vec2len (length vec2))
         (i 0)
         bind )
    (while (< i veclen)
      (aset vec2 i (aref vec i))
      (setq i (1+ i)) )
    (setq bindings (reverse bindings))
    (while bindings
      (setq bind (car bindings)
            bindings (cdr bindings) )
      (aset vec2 (1- vec2len) (car bind)) ;set menu-symbol
      (define-key map vec2 (cons (car (cdr bind)) (car (cdr (cdr bind))))) )))

(defun skk-define-menu-bar-map ()
  ;; ˥塼СΥޥåפ롣
  (if (and (not (window-minibuffer-p (selected-window)))
           (or (not (boundp 'skktut-problem-count))
               (eq skktut-problem-count 0) ))
      (progn
        (skk-define-skk-menu-bar-map-1)
        (skk-define-sub-menu-convert-and-echo)
        (skk-define-sub-menu-convert-region)
        (skk-define-sub-menu-user-options) )))

(defun skk-define-skk-menu-bar-map-1 ()
  ;; SKK ˥塼Υȥåפ˽и륳ޥɤΥ˥塼ؤԤʤ
  (define-key skk-map [menu-bar skk] (cons "SKK" (make-sparse-keymap "SKK")))
  (define-key skk-map [menu-bar skk version] '("Version" . skk-version))
  (define-key skk-map [menu-bar skk user-options]
    (cons "User Options" (make-sparse-keymap "User Options")) )
  (define-key skk-map [menu-bar skk undo] '("Undo Kakutei" . skk-undo-kakutei))
  (define-key skk-map [menu-bar skk save] '("Save Jisyo" . skk-save-jisyo))
  (define-key skk-map [menu-bar skk count-jisyo-entries]
    '("Count Jisyo Candidates" . skk-count-jisyo-candidates) )
  (define-key skk-map [menu-bar skk convert-region]
    (cons "Convert Region and Replace"
          (make-sparse-keymap "Convert Region and Replace") ))
  (define-key skk-map [menu-bar skk convert-and-echo]
    (cons "Convert Region and Echo"
          (make-sparse-keymap "Convert Region And Echo") )))

(defun skk-define-sub-menu-convert-region ()
  (define-key skk-map [menu-bar skk convert-region zenkaku]
    '("Zenkaku" . skk-zenkaku-region) )
  (define-key skk-map [menu-bar skk convert-region romaji]
    '("Romaji" . skk-romaji-region) )
  (define-key skk-map [menu-bar skk convert-region katakana]
    '("Katakana" . skk-katakana-region) )
  (define-key skk-map [menu-bar skk convert-region hurigana]
    (cons "Hurigana" (make-sparse-keymap "Hurigana")) )
  (define-key skk-map [menu-bar skk convert-region hiragana]
    '("Hiragana" . skk-hiragana-region) )
  (define-key skk-map [menu-bar skk convert-region gyakubiki]
    (cons "Gyakubiki" (make-sparse-keymap "Gyakubiki")) )
  (define-key skk-map [menu-bar skk convert-region ascii]
    '("Ascii" . skk-ascii-region) )
  (skk-define-sub-menu
   skk-map [menu-bar skk convert-region gyakubiki]
   '(gyakubiki-1 "to Hirakana" skk-gyakubiki-region)
   '(gyakubiki-2 "to Hirakana, All Candidates"
                 (lambda (start end) (interactive "r")
                   (skk-gyakubiki-region start end 'all-candidates) ))
   '(gyakubiki-3 "to Katakana" skk-gyakubiki-katakana-region )
   '(gyakubiki-4 "to Katakana, All Candidates"
                 (lambda (start end) (interactive "r")
                   (skk-gyakubiki-katakana-region
                    start end 'all-candidates ) ))
  (skk-define-sub-menu
   skk-map [menu-bar skk convert-region hurigana]
   '(hurigana-1 "to Hirakana" skk-hurigana-region)
   '(hurigana-2 "to Hirakana, All Candidates"
                (lambda (start end) (interactive "r")
                  (skk-hurigana-region start end 'all-candidates) ))
   '(hurigana-3 "to Katakana" skk-hurigana-katakana-region)
   '(hurigana-4 "to Katakana, All Candidates"
                (lambda (start end) (interactive "r")
                  (skk-hurigana-katakana-region
                   start end 'all-candidates) )))))

(defun skk-define-sub-menu-convert-and-echo ()
  (define-key skk-map [menu-bar skk convert-and-echo hurigana]
    (cons "Hurigana" (make-sparse-keymap "Hurigana")) )
  (define-key skk-map [menu-bar skk convert-and-echo gyakubiki]
    (cons "Gyakubiki" (make-sparse-keymap "Gyakubiki")) )
  (skk-define-sub-menu
   skk-map [menu-bar skk convert-and-echo gyakubiki]
   '(gyakubiki-1 "to Hirakana" skk-gyakubiki-message )
   '(gyakubiki-2 "to Hirakana, All Candidates"
                 (lambda (start end) (interactive "r")
                   (skk-gyakubiki-message
                    start end 'all-candidates )))
   '(gyakubiki-3 "to Katakana" skk-gyakubiki-katakana-message )
   '(gyakubiki-4 "to Katakana, All Candidates"
                 (lambda (start end) (interactive "r")
                   (skk-gyakubiki-katakana-message
                    start end 'all-candidates ) )))
  (skk-define-sub-menu
   skk-map [menu-bar skk convert-and-echo hurigana]
   '(hurigana-1 "to Hirakana" skk-hurigana-message)
   '(hurigana-2 "to Hirakana, All Candidates"
                (lambda (start end) (interactive "r")
                  (skk-hurigana-message start end 'all-candidates) ))
   '(hurigana-3 "to Katakana" skk-hurigana-katakana-message)
   '(hurigana-4 "to Katakana, All Candidates"
                (lambda (start end) (interactive "r")
                  (skk-hurigana-katakana-message
                   start end 'all-candidates ) ))))

(defun skk-define-sub-menu-user-options ()
  ;; User Options ϢΥޥɤΥ˥塼ؤԤʤ
  ;; ABC ˾ʤ褦θ뤳ȡ
  (skk-define-sub-menu
   skk-map [menu-bar skk user-options]
   '(skk-allow-spaces-newlines-and-tabs "skk-allow-spaces-newlines-and-tabs"                                        skk-menu-allow-spaces-newlines-and-tabs )
   '(skk-auto-start-henkan "skk-auto-start-henkan" skk-menu-auto-henkan)
   '(skk-auto-insert-paren "skk-auto-insert-paren" skk-menu-auto-insert-paren)
   '(skk-auto-okuri-process "skk-auto-okuri-process"
                             (lambda ()
                               (interactive)
                               (skk-menu-auto-okuri-process)
                               (skk-adjust-search-prog-list-for-auto-okuri) ))
   ;;'(skk-byte-compile-init-file "skk-byte-compile-init-file"
   ;;                             skk-menu-byte-compile-init-file )
   '(skk-compare-jisyo-size-when-saving "skk-compare-jisyo-size-when-saving"
                                        skk-menu-compare-jisyo-size-when-saving )
   '(skk-convert-okurigana-into-katakana "skk-convert-okurigana-into-katakana"                                         skk-menu-convert-okurigana-into-katakana )
   '(skk-count-private-jisyo-candidates-exactly
     "skk-count-private-jisyo-candidates-exactly"
     skk-menu-count-private-jisyo-entries-exactly )
   '(skk-dabbrev-like-completion "skk-dabbrev-like-completion"
                                 skk-menu-dabbrev-like-completion )
   '(skk-date-ad "skk-date-ad" skk-menu-date-ad)
   '(skk-delete-implies-kakutei "skk-delete-implies-kakutei"
                                skk-menu-delete-implies-kakutei )
   '(skk-delete-okuri-when-quit "skk-delete-okuri-when-quit"
                                skk-menu-delete-okuri-when-quit )
   '(skk-echo "skk-echo" skk-menu-echo)
   '(skk-egg-like-newline "skk-egg-like-newline" skk-menu-egg-like-newline)
   '(skk-henkan-okuri-strictly "skk-henkan-okuri-strictly"
                               skk-menu-henkan-okuri-strictly )
   '(skk-japanese-message-and-error "skk-japanese-message-and-error"
                                    skk-menu-japanese-message-and-error )
   '(skk-kakutei-early "skk-kakutei-early" skk-menu-kakutei-early)
   '(skk-numeric-conversion-float-num "skk-numeric-conversion-float-num"
                                      skk-menu-numeric-conversion-float-num )
   '(skk-process-okuri-early "skk-process-okuri-early"
                             skk-menu-process-okuri-early )
   '(skk-report-server-response "skk-report-server-response"
                                skk-menu-report-server-response )
   '(skk-romaji-*-by-hepburn "skk-romaji-*-by-hepburn" skk-menu-romaji-*-by-hepburn)
   '(skk-server-debug "skk-server-debug" skk-menu-server-debug)
   '(skk-use-color-cursor "skk-use-color-cursor" skk-menu-use-color-cursor)
   '(skk-use-kakasi "skk-use-kakasi" skk-menu-use-kakasi)
   '(skk-use-numeric-conversion "skk-use-numeric-conversion"
                                skk-menu-use-numeric-conversion )
   '(skk-use-face "skk-use-face" skk-menu-use-overlay) ))

(defun skk-menu-setup-annotation-buffer (annotation)
  ;; skk-menu-annotation-buffer ꡢANNOTATION ɽ롣
  (if (and annotation (not (string= annotation "")))
      (save-excursion
        (delete-other-windows)
        (switch-to-buffer (get-buffer-create skk-menu-annotation-buffer))
        (delete-region (point-min) (point-max))
        (insert annotation)
        (goto-char (point-min)) )))

(defun skk-menu-change-user-option (var on-alist off-alist)
  ;; VAR ΥɥȤɽƥ桼λؼ˽ͤ non-nil/nil 
  ;; 롣
  ;; ON-ALIST ˤϡץ VAR ͤ non-nil ˤȤꤹѿ
  ;; OFF-ALIST  VAR ͤ nil ˤ
  ;;   '((ѿ̾0 . 0) (ѿ̾1 . 1) ... (ѿ̾n . n))
  ;; ηϢۥꥹȤǻꤹ롣ON-ALIST, OFF-ALIST ˤ VAR Ȥ
  ;; ɬפ롣
  (let (
        ;; ܥåե졼˽Ф annotation Хåեɤ
        ;; ʤΤǡܥåФʤ褦ˤ롣
        (last-nonmenu-event t)
        (on (symbol-value var))
        answer )
    (save-window-excursion
      (skk-menu-setup-annotation-buffer
       (concat (format "ߤ %s ͤϡ%s Ǥ\n\n"
                       (prin1-to-string var) (prin1-to-string on) )
               (documentation-property var 'variable-documentation) ))
      ;; y-or-n-p ǤɤΤy-or-n-p ϥߥ˥ХåեѤƤƥߥ˥Х
      ;; եȤäƤʤΤǡannotation buffer ˥ܤʸ
      ;; ԡǤʤʤäƤޤ
      (setq answer (yes-or-no-p (format
                                 (if skk-japanese-message-and-error
                                     "Υץ %s ˤޤ"
                                   "Turn %s this option?" )
                                 (if on "off" "on") )))
      (if answer
          (if on
              ;; turn off
              (skk-menu-change-user-option-1 off-alist)
            ;; turn on
            (skk-menu-change-user-option-1 on-alist) )))))

(defun skk-menu-change-user-option-1 (alist)
  ;; ALIST  skk-menu-modified-user-option κǸϢ뤷ALIST ͤ
  ;;  car  cdr ͤ롣
  (let ((n 0)
        cell modified )
    (while (setq cell (nth n alist))
      (setq n (1+ n)
            modified (assq (car cell) skk-menu-modified-user-option) )
      (if modified
          (setq skk-menu-modified-user-option
                ;; ƱѿǥեƤ顢ŤΤ롣
                (delq modified skk-menu-modified-user-option) ))
      (set (car cell) (cdr cell)) )
    (setq skk-menu-modified-user-option
          (nconc skk-menu-modified-user-option alist) )))

(defun skk-menu-save-modified-user-option ()
  ;; SKK Υ˥塼ѹ줿桼ץ skk-init-file ¸
  ;; 롣
  (if (and
       skk-menu-modified-user-option
       (yes-or-no-p
        (if skk-japanese-message-and-error
            "SKK ץ󤬵ưѹƤޤͤ¸ޤ"
          "Changed user options after SKK invoked.  Save the variables?" )))
      (progn
        (skk-menu-save-modified-user-option-1)
        (message
         (if skk-japanese-message-and-error
             "SKK Υץ %s ¸ޤ"
           "Save user options of SKK in %s" )
         skk-init-file )
        (sit-for 1) )))

(defun skk-menu-save-modified-user-option-1 ()
  ;; skk-menu-save-modified-user-option-1 Υ֥롼~/.skk 
  ;; skk-menu-modified-user-option ͤ񤭹߼ skk.el ư줿Ȥ
  ;; Ǥѹ줿ͤͭˤ롣
  ;; ˴ˤδؿˤ꼰񤭹ޤƤ顢ͤȤĴԤʤ
  (save-excursion
    (save-match-data
      (let (
            ;; ǥ졼ʤ
            (hilit-auto-highlight-maxout 0)
            (font-lock-maximum-size 0)
            (require-final-newline t)
            buffer-read-only
            start first-kiss cell )
        (set-buffer (find-file-noselect (expand-file-name skk-init-file)))
        (goto-char (point-min))
        (setq first-kiss
              (not
               (re-search-forward
                "^;; μ SKK ˤäƼưŪ˽񤭹ޤ줿ΤǤ$"
                nil t )))
        (if first-kiss
            (progn
              (setq start (goto-char (point-max)))
              (insert
               ";; μ SKK ˤäƼưŪ˽񤭹ޤ줿ΤǤ\n"
               ))
          (let ((alist skk-menu-modified-user-option)
                var)
            (setq start (point))
            (re-search-forward
             "^;; 嵭μ SKK ˤäƼưŪ˽񤭹ޤ줿ΤǤ$"
             nil )
            (while (setq var (car (car alist)))
              (save-excursion
                (and (re-search-backward (prin1-to-string var) start t)
                     (delete-region (progn (beginning-of-line) (point))
                                    (progn (forward-line 1) (point)) )))
              (setq alist (cdr alist)) )
            (beginning-of-line) ))
        ;; ơ϶̤νǤ
        (while skk-menu-modified-user-option
          (setq cell (car skk-menu-modified-user-option)
                skk-menu-modified-user-option
                (cdr skk-menu-modified-user-option) )
          (insert "(setq " (prin1-to-string (car cell)) " "
                  (prin1-to-string (cdr cell)) ")\n" ))
        ;;(delete-char -1)
        (if first-kiss
            (insert
             ";; 嵭μ SKK ˤäƼưŪ˽񤭹ޤ줿ΤǤ\n"
             ))
        (save-buffer)
        (kill-buffer (current-buffer)) ))))

;;;###autoload
(defun skk-menu-process-okuri-early ()
  "skk-process-okuri-early 򥹥å/դ롣
ξΩǤʤץͤĴ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-process-okuri-early
   ;; on-alist
   '((skk-process-okuri-early . t)
     (skk-auto-okuri-process . nil)
     (skk-henkan-okuri-strictly . nil)
     (skk-kakutei-early . nil) )
   ;; off-alist
   '((skk-process-okuri-early . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-henkan-okuri-strictly ()
  "skk-henkan-okuri-strictly 򥹥å/դ롣
ξΩǤʤץͤĴ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-henkan-okuri-strictly
   ;; on-alist
   '((skk-henkan-okuri-strictly . t)
     (skk-process-okuri-early . nil) )
   ;; off-alist
   '((skk-henkan-okuri-strictly . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-auto-okuri-process ()
  "skk-auto-okuri-process 򥹥å/դ롣
ξΩǤʤץͤĴ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-auto-okuri-process
   ;; on-alist
   '((skk-auto-okuri-process . t)
     (skk-process-okuri-early . nil) )
   ;; off-alist
   '((skk-auto-okuri-process . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-kakutei-early ()
  "skk-kakutei-early 򥹥å/դ롣
ξΩǤʤץͤĴ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-kakutei-early
   ;; on-alist
   '((skk-kakutei-early . t)
     (skk-process-okuri-early . nil) )
   ;; off-alist
   '((skk-kakutei-early . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-egg-like-newline ()
  "skk-egg-like-newline 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-egg-like-newline
   '((skk-egg-like-newline . t))
   '((skk-egg-like-newline . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-delete-implies-kakutei ()
  "skk-delete-implies-kakutei 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-delete-implies-kakutei
   '((skk-delete-implies-kakutei . t))
   '((skk-delete-implies-kakutei . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-allow-spaces-newlines-and-tabs ()
  "skk-allow-spaces-newlines-and-tabs 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-allow-spaces-newlines-and-tabs
   '((skk-allow-spaces-newlines-and-tabs . t))
   '((skk-allow-spaces-newlines-and-tabs . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-convert-okurigana-into-katakana ()
  "skk-convert-okurigana-into-katakana 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-convert-okurigana-into-katakana
   '((skk-convert-okurigana-into-katakana . t))
   '((skk-convert-okurigana-into-katakana . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-delete-okuri-when-quit ()
  "skk-delete-okuri-when-quit 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-delete-okuri-when-quit
   '((skk-delete-okuri-when-quit . t))
   '((skk-delete-okuri-when-quit . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-echo ()
  "skk-echo 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-echo
   '((skk-echo . t))
   '((skk-echo . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-use-numeric-conversion ()
  "skk-use-numeric-conversion 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-use-numeric-conversion
   '((skk-use-numeric-conversion . t))
   '((skk-use-numeric-conversion . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-use-overlay ()
  "skk-use-face 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-use-face
   '((skk-use-face . t))
   '((skk-use-face . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-auto-insert-paren ()
  "skk-auto-insert-paren 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-auto-insert-paren
   '((skk-auto-insert-paren . t))
   '((skk-auto-insert-paren . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-japanese-message-and-error ()
  "skk-japanese-message-and-error 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-japanese-message-and-error
   '((skk-japanese-message-and-error . t))
   '((skk-japanese-message-and-error . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
;;(defun skk-menu-byte-compile-init-file ()
;;  "skk-byte-compile-init-file 򥹥å/դ롣"
;;  (interactive)
;;  (skk-menu-change-user-option
;;   'skk-byte-compile-init-file
;;   '((skk-byte-compile-init-file . t))
;;   '((skk-byte-compile-init-file . nil)) )
;;  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-count-private-jisyo-entries-exactly ()
  "skk-count-private-jisyo-candidates-exactly 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-count-private-jisyo-candidates-exactly
   '((skk-count-private-jisyo-candidates-exactly . t))
   '((skk-count-private-jisyo-candidates-exactly . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-auto-henkan ()
  "skk-auto-start-henkan 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-auto-start-henkan
   '((skk-auto-start-henkan . t)
     (skk-auto-okuri-process . t) )
   '((skk-auto-start-henkan . nil)) )
  (skk-set-cursor-color-properly) )

;; for skk-comp.el
;;;###autoload
(defun skk-menu-dabbrev-like-completion ()
  "skk-dabbrev-like-completion 򥹥å/դ롣"
  (interactive)
  (require 'skk-comp)
  (skk-menu-change-user-option
   'skk-dabbrev-like-completion
   '((skk-dabbrev-like-completion . t))
   '((skk-dabbrev-like-completion . nil)) )
  (skk-set-cursor-color-properly) )

;; for skk-gadget.el
;;;###autoload
(defun skk-menu-date-ad ()
  "skk-date-ad 򥹥å/դ롣"
  (interactive)
  (require 'skk-gadget)
  (skk-menu-change-user-option
   'skk-date-ad
   '((skk-date-ad . t))
   '((skk-date-ad . nil)) )
  (skk-set-cursor-color-properly) )

;; for skk-kakasi.el
;;;###autoload
(defun skk-menu-romaji-*-by-hepburn ()
  "skk-romaji-*-by-hepburn 򥹥å/դ롣"
  (interactive)
  (require 'skk-kakasi)
  (skk-menu-change-user-option
   'skk-romaji-*-by-hepburn
   '((skk-romaji-*-by-hepburn . t))
   '((skk-romaji-*-by-hepburn . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-use-kakasi ()
  "skk-use-kakasi 򥹥å/դ롣"
  (interactive)
  (require 'skk-kakasi)
  (skk-menu-change-user-option
   'skk-use-kakasi
   '((skk-use-kakasi . t))
   '((skk-use-kakasi . nil)) )
  (skk-set-cursor-color-properly) )

;; for skk-num.el
;;;###autoload
(defun skk-menu-numeric-conversion-float-num ()
  "skk-numeric-conversion-float-num 򥹥å/դ롣"
  (interactive)
  (require 'skk-num)
  (skk-menu-change-user-option
   'skk-numeric-conversion-float-num
   '((skk-numeric-conversion-float-num . t))
   '((skk-numeric-conversion-float-num . nil)) )
  (skk-set-cursor-color-properly) )

;; for skk-server.el
;;;###autoload
(defun skk-menu-report-server-response ()
  "skk-report-server-response 򥹥å/դ롣"
  (interactive)
  (require 'skk-server)
  (skk-menu-change-user-option
   'skk-report-server-response
   '((skk-report-server-response . t))
   '((skk-report-server-response . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-server-debug ()
  "skk-server-debug 򥹥å/դ롣"
  (interactive)
  (require 'skk-server)
  (skk-menu-change-user-option
   'skk-server-debug
   '((skk-server-debug . t))
   '((skk-server-debug . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-compare-jisyo-size-when-saving ()
  "skk-compare-jisyo-size-when-saving 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-compare-jisyo-size-when-saving
   '((skk-compare-jisyo-size-when-saving . t))
   '((skk-compare-jisyo-size-when-saving . nil)) )
  (skk-set-cursor-color-properly) )

;;;###autoload
(defun skk-menu-use-color-cursor ()
  "skk-use-color-cursor 򥹥å/դ롣"
  (interactive)
  (skk-menu-change-user-option
   'skk-use-color-cursor
   '((skk-use-color-cursor . t))
   '((skk-use-color-cursor . nil)) )
  (skk-set-cursor-color-properly) )

;;(defun skk-menu- ()
;;  "skk- 򥹥å/դ롣"
;;  (interactive)
;;  (skk-menu-change-user-option
;;   'skk-
;;   '((skk- . t))
;;   '((skk- . nil)) ))


(add-hook 'skk-before-kill-emacs-hook 'skk-menu-save-modified-user-option)
(add-hook 'skk-setup-map-hook 'skk-define-menu-bar-map)
(add-hook 'skk-setup-zenkaku-map-hook 'skk-define-menu-bar-map)

(run-hooks 'skk-e19-load-hook)

(provide 'skk-e19)
;;; skk-e19.el ends here
