char *copyright = "UCS2 Table: Copyright (c) 1998-2005, S.Kaneko";
char *table_rev = "$Id: uni_table_gen.c,v 1.38 2009/03/18 14:35:49 seiji Exp $";
/* *******************************************************************
** Copyright (c) 1998-2009 Seiji Kaneko. All rights reserved.
** Everyone is permitted to use this program in source and binary
** form, with or without modification if and only if the following
** conditions are met:
** 1. Redistributions of source code must retain the above copyright
**   notice, copyright notice written in source code, additional list
**   of conditions and the following disclaimer.
** 2. Redistributions in machine readable form must reproduce the 
**   above copyright notice and the following disclaimer in the
**   documentation or other material provided with the distribution.
** 3. Neither the name of the copyright holders nor the names of its 
**   contributors may be used to endorse or promote products derived from 
**   this software without specific prior written permission.
** 4. Do not distribute uni_table.c generated from this source alone.
**   Redistributing uni_table.c with this source is permitted.
**********************************************************************
** Disclaimer: This software is provided and distributed AS iS, 
**	without any implicit or explicit warranties, and not
**	guaranteed to be error-free. In no event shall the author be
**	liable for any direct, indirect or incidental damages,
**	including, but not limited to, loss of data, use or profits
**	responsibility for any direct or indirect damages or results
**	arising by using whole or a part of this software.
**********************************************************************
   uni_table_gen.c: To and from ucs2 table generator
*/

#include <stdio.h>

#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#include <stdlib.h>
#include "skf.h"
#include "skf_fileio.h"
#include "convert.h"
#include "oconv.h"
/* --------------------------------------------------------------- */
static long uni_h_4e[256] = {
    1676,3590,9601,2823, 9602,9603,-1,4392,
    3070,2716,3069,1828, 9604,4152,4531,-1,
    4802,1715,9605,-1, 1978,4803,3204,5034,
    2154,4226,-1,-1, -1,-1,3071,9606,
    -1,4630,-1,9607, 9608,-1,4234,-1,
    9609,-1,4804,9610, -1,3570,9611,9612,
    9613,4805,2290,-1, -1,9614,4806,-1,
    2061,3516,-1,2871, 4807,-1,-1,4808,
/* 40-7f */
    9615,9616,4809,3921, 9617,2155,-1,9618,
    -1,-1,-1,3923, -1,3867,2435,4319,
    -1,9619,-1,-1, -1,7341,4810,3072,
    4811,1821,9620,-1, 9621,2269,2480,4473,
    -1,-1,5406,9622, -1,-1,-1,-1,
    9623,9624,-1,-1, -1,-1,-1,-1,
    -1,4580,-1,3893, 9625,9626,-1,-1,
    -1,9627,-1,-1, -1,-1,2005,9628,
/* 80-bf */
    2121,-1,4812,-1, -1,4813,4627,-1,
    4529,3372,4815,2786, 3883,9629,4818,-1,
    -1,1730,2463,-1, 2462,1670,9630,9631,
    4743,4742,-1,2619, 1601,9632,4819,4820,
    4821,4320,4822,-1, 2482,1671,4382,-1,
    2192,-1,-1,2193, 2194,3666,4628,9633,
    4823,-1,-1,4824, -1,-1,4825,-1,
    -1,9634,3145,-1, -1,-1,-1,-1,
/* c0-ff */
    2926,3146,4830,9635, 4828,-1,4829,2156,
    -1,-1,2603,1880, -1,4827,4826,4209,
    9636,-1,-1,-1, 2738,2737,3430,4831,
    4153,3271,9637,9638, -1,0124,4832,4834,
    9639,9640,9641,3469, 4665,1642,-1,-1,
    9642,-1,-1,-1, -1,4833,1830,9643,
    2236,9644,3571,9645, -1,9646,2379,4835,
    -1,-1,-1,3904, -1,9647,9648,9649
};

static long uni_h_4f[256] = {
    9650,2075,9651,9652, -1,-1,-1,-1,
    9653,4836,1643,9654, 9655,2464,2076,4190,
    4018,2157,9656,-1, -1,9657,9658,9659,
    -1,9660,1881,-1, 4871,3733,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,9661,3976,
    4838,9662,-1,9664, 4028,9665,4666,9666,
    3113,9667,2739,9668, 2787,1832,9669,-1,
/* 40-7f */
    9670,-1,9671,3649, -1,-1,3502,4842,
    9672,9673,-1,9674, 9675,1644,3667,2927,
    2620,4504,9676,3446, 9677,1831,9678,4841,
    9679,4530,4837,4839, 2678,4840,5304,9680,

    9663,-1,-1,9681, -1,-1,-1,-1,
    -1,4848,9682,-1, 9683,-1,9684,4851,
    4849,9685,-1,1834, -1,4227,4843,9686,
    9687,9688,9689,4847, 2483,9690,9691,2740,
/* 80-bf */
    -1,9692,9693,2006, 9694,9701,4852,-1,
    4844,9702,9703,4667, 9704,2788,9705,4845,
    9706,4850,9707,9708, 9709,-1,4853,9710,
    4846,9711,9712,2201, -1,1645,9713,9714,

    2202,1833,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,5305, -1,4389,4178,2484,
    -1,-1,9715,-1, -1,3115,4623,9716,
    -1,9717,-1,9718, 9719,9720,9721,4256,
/* c0-ff */
    9722,9723,2324,3405, 1868,9724,9725,-1,
    9726,9727,2951,9728, 9729,9730,4857,9731,
    4862,4860,9732,-1, 4855,-1,-1,3415,
    4858,-1,4861,4859, 9733,4261,-1,4856,

    9734,3114,9735,4383, 4863,4864,-1,-1,
    -1,-1,-1,-1, -1,-1,2904,4877,
    9736,-1,9737,3948, -1,4122,4872,-1,
    4280,-1,1822,-1, 9738,9739,4876,9740
};

static long uni_h_50[256] = {
    9741,9742,-1,-1, 9743,4870,4879,9744,
    -1,3350,9745,2436, 9746,3960,9747,6439,
    9748,4878,3761,9749, 4867,-1,2486,9750,
    9751,2485,4865,9752, 9753,9754,9755,2858,

    -1,4873,9756,4279, 3545,4869,2381,9757,
    4866,4874,4868,4649, 4875,4733,9758,-1,
    9759,-1,9760,9761, -1,9762,2270,-1,
    -1,2380,-1,9786, -1,-1,-1,-1,
/* 40-7f */
    9763,9764,9765,4880, -1,9766,9767,4881,
    4885,1646,9768,-1, 9769,-1,9770,4248,
    4884,9771,9772,9773, -1,4883,4887,9774,
    -1,9775,4886,-1, 3668,-1,-1,9776,

    9777,-1,9778,9779, -1,2382,9780,9781,
    -1,-1,9782,-1, 4888,9783,-1,-1,
    9784,9785,2837,-1, 3406,3669,2286,-1,
    4889,-1,-1,-1, -1,2122,-1,-1,
/* 80-bf */
    4890,9787,-1,9788, 9789,4892,9790,-1,
    -1,-1,9791,-1, -1,4321,9792,9793,
    9794,2370,9801,9802, 9803,-1,9804,-1,
    2717,4087,4891,9805, 9806,-1,9807,9808,

    9809,9810,9811,-1, -1,-1,-1,-1,
    -1,-1,9812,-1, 2637,4535,-1,9813,
    9814,-1,4894,4903, 4893,2636,-1,2993,
    -1,9815,9816,-1, -1,9817,2325,-1,
/* c0-ff */
    9818,-1,4904,9819, 9820,2247,-1,9821,
    -1,4901,4902,-1, 9822,3815,9823,3392,
    9824,2203,-1,9825, 9826,4345,4905,-1,
    9827,-1,4629,-1, 9828,9829,4906,9830,

    -1,-1,9831,4909, 9832,4907,9833,3346,
    9834,9835,-1,-1, -1,4908,4910,9836,
    -1,9837,9849,-1, -1,4912,9838,-1,
    -1,4911,9839,4240, -1,-1,9840,-1
};

static long uni_h_51[256] = {
    2123,4914,4915,9841, 1815,-1,9842,9843,
    9844,4913,-1,9845, 9846,9847,9848,-1,
    9850,-1,2884,-1, 4918,4917,4916,9851,
    4854,9852,4919,9853, 9854,9855,9856,2994,

    -1,4920,-1,9857, -1,-1,-1,9858,
    9859,-1,4505,-1, 9860,9861,-1,9862,
    -1,9863,4457,9864, 9865,9866,-1,4922,
    9867,9868,4921,4924, 4923,-1,-1,4925,
/* 40-7f */
    4926,1684,9869,2421, 2327,2928,3591,2204,
    3272,2487,9870,2578, 4928,4440,3738,9871,
    2789,-1,4927,9872, 4929,9873,-1,9874,
    9875,-1,3762,-1, 1985,-1,-1,9876,

    -1,-1,4930,-1, 9877,3894,9878,-1,
    3320,4932,4933,4012, 2488,4727,4934,-1,
    -1,2206,-1,-1, -1,4228,3422,2281,
    3721,-1,-1,-1, 2383,-1,9879,-1,
/* 80-bf */
    4935,-1,4936,9880, 9881,3866,1763,-1,
    -1,4939,2693,9882, 4938,2638,9883,4940,
    7078,4941,4333,4942, -1,4943,4944,3073,
    9884,2844,-1,-1, -1,9885,-1,-1,

    2007,9886,4947,9887, 4945,4429,4946,-1,
    4158,4948,4949,4950, 3763,9888,-1,-1,
    4954,4952,4953,4951, 2667,4955,4474,4668,
    9889,-1,9890,-1, 9891,4956,9892,9893,
/* c0-ff */
    -1,-1,9894,-1, 3208,4957,2958,-1,
    9901,4958,-1,3592, 4631,3764,-1,9902,
    -1,9903,9904,9905, -1,9906,5037,-1,
    9907,-1,-1,4959, 8405,2237,9908,-1,

    4960,4362,9909,-1, -1,9910,2972,3492,
    -1,4962,3868,-1, -1,4963,9911,-1,
    4964,1914,9912,9913, 9914,4965,2207,9915,
    3844,1790,2948,-1, -1,4001,4966,-1
};

static long uni_h_52[256] = {
    3765,9916,9917,3147, 4967,9918,4212,3258,
    2002,-1,2009,4968, -1,-1,4970,-1,
    -1,2326,9919,9920, 4969,9921,9922,4683,
    9923,-1,-1,-1, -1,2973,-1,-1,

    -1,-1,9924,-1, 4029,4244,-1,4971,
    9925,4588,4972,-1, -1,-1,4973,-1,
    3794,9926,9927,4974, -1,9928,3209,2694,
    2384,4975,2741,2579, 9929,-1,-1,-1,
/* 40-7f */
    -1,-1,-1,3670, 4977,9930,-1,3407,
    -1,9931,2679,4978, 4979,3316,-1,4976,
    -1,-1,-1,-1, 4981,9932,4322,9933,
    9934,-1,9935,2568, 9936,-1,4980,9937,

    9938,9939,-1,2385, 2662,3977,9940,-1,
    -1,4984,4982,-1, -1,-1,9941,4191,
    3074,4991,1968,4985, 4983,3347,-1,9942,
    9943,9944,-1,-1, -1,4987,-1,4986,
/* 80-bf */
    9945,-1,9946,1936, -1,9947,-1,2364,
    4992,4613,9948,-1, 9949,4988,-1,-1,
    -1,4993,4990,9950, 4989,9951,9952,9953,
    9954,-1,9955,4647, 9956,-1,-1,2489,

    1835,-1,-1,4684, 9957,9958,9959,9960,
    -1,2985,3756,2569, 5002,5003,-1,9961,
    9962,4669,-1,-1, 4711,5005,9963,9964,
    9965,2490,9966,9967, 5004,9968,1915,-1,
/* c0-ff */
    9969,5006,-1,4354, 9970,3628,-2,4506,
    9972,4257,-1,-1, 9973,5007,-1,9974,
    -1,9975,8053,-1, 9976,3816,9977,5008,
    2010,4419,-1,9978, 9979,3001,5009,4271,

    5013,9980,3210,5010, 2248,9981,5011,2011,
    9982,9983,9984,-1, 9985,-1,-1,-1,
    9986,9987,2314,5014, 9988,5015,9989,9990,
    5016,5017,2859,-1, -1,-1,2491,4462
};

static long uni_h_53[256] = {
    9991,4472,3887,9992, -1,4281,5018,-1,
    5019,-1,9993,9994, 10001,5021,-1,5023,
    5022,10002,-1,10003, -1,5024,1829,4344,
    10004,2692,5025,10005, 10006,3357,10007,10008,

    3002,2209,-1,5026, -1,10009,-1,10010,
    10011,10012,4059,10013, 10014,10015,-1,5027,
    10016,5028,10017,5029, -1,10018,-1,-1,
    5030,4104,2272,1669, 10019,10020,10021,3831,
/* 40-7f */
    5031,2929,10022,3273, -1,5033,5032,3003,
    2465,5035,4030,10024, 10023,5036,-1,-1,
    -1,4060,3420,3478, 2208,-1,-1,3878,
    3517,10025,3978,10026, 4346,-1,5038,-1,

    3274,10027,-1,10028, -1,10029,2321,-1,
    -1,5039,-1,-1, 10030,10031,5040,1712,
    1685,2077,10032,3408, 2149,4581,-1,5043,
    1823,10033,-1,5042, -1,-1,10034,2210,
/* 80-bf */
    -1,-1,5044,10035, 4481,-1,-1,10036,
    10037,-1,-1,-1, -1,-1,10038,-1,
    -1,-1,-1,10039, 10040,-1,5045,-1,
    4650,10041,2492,-1, -1,10042,-1,2422,

    5046,10043,-1,-1, 10044,5048,5047,-1,
    3163,1725,10045,10046, -1,1762,5049,10047,
    5050,-1,10048,2423, 10049,10050,5051,10051,
    10052,-1,10053,2178, -1,10054,-1,-1,
/* c0-ff */
    10055,-1,2718,5052, -1,10056,-1,-1,
    4384,2621,2158,4507, 3348,4031,2893,10057,
    -1,-1,10058,10059, 2939,10060,2872,2885,
    -1,2986,10061,4032, -1,10062,10063,5055,

    10064,1735,3349,2493, 2437,2271,10065,10066,
    5059,3501,3494,2211, 3004,5060,5058,1836,
    3470,2824,2743,1706, -1,10067,1980,2570,
    2742,-1,5061,-1, -1,-1,-1,-1
};

static long uni_h_54[256] = {
    -1,5062,10068,2141, 1938,-1,-1,-1,
    2571,2140,3663,1705, 3817,4430,2501,4589,
    3739,2494,-1,10069, -1,-1,-1,-1,
    -1,-1,10070,2315, -1,5071,-1,2267,

    4342,10071,-1,-1, -1,-1,4061,10072,
    10073,5070,10074,2062, 5065,5066,5068,10075,
    -1,10076,-1,-1, 10077,10078,5069,-1,
    2159,3165,-1,4213, 5067,5063,2467,-1,
/* 40-7f */
    5064,-1,4704,10079, 10080,-1,4282,10081,
    3672,2466,2580,-1, -1,10082,5072,10083,
    -1,3861,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,10084,5076,

    -1,-1,10085,-1, 10086,-1,10087,10088,
    2894,10089,2886,10090, -1,10091,10092,-1,
    5079,5077,-1,4403, 10093,5074,5083,5078,
    -1,-1,-1,5081, 2438,4431,-1,10094,
/* 80-bf */
    5082,10101,-1,10102, 5084,10103,5086,-1,
    10104,10105,-1,2680, 4734,10106,5075,5073,
    5085,10107,5080,-1, -1,10108,10109,-1,
    -1,-1,-1,-1, 10110,-1,-1,10111,

    -1,10112,5088,-1, 5103,5090,10113,10114,
    5094,10115,10116,5101, 5091,10117,10118,5130,
    -1,10119,2673,1917, -1,-1,-1,10120,
    5089,10121,10122,10123, 5105,1686,5104,10124,
/* c0-ff */
    1605,4142,5102,-1, 5092,-1,10125,5087,
    5093,2640,10126,-1, -1,10127,10128,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    5106,-1,-1,-1, -1,-1,-1,-1,

    10129,1687,5115,-1, -1,5107,5108,-1,
    3005,4373,10130,-1, 10131,5113,5112,10132,
    -1,-1,3715,-1, -1,-1,10133,-1,
    -1,-1,5114,-1, 10134,5111,10135,10136
};

static long uni_h_55[256] = {
    10137,10138,-1,-1, 1720,10139,2622,3116,
    10140,10141,-1,-1, 10142,10143,10144,5109,
    3766,-1,-1,-1, 5110,10145,1602,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,10146,10147, -1,-1,5120,4503,
    -1,3007,10148,5126, -1,10149,10150,-1,
    5125,5116,-1,10151, 10152,10153,3435,-1,
/* 40-7f */
    5117,10154,-1,-1, 3479,5122,3006,10155,
    -1,10156,10157,-1, 5119,10158,-1,4468,
    10159,10160,-1,2328, -1,-1,5123,5124,
    10161,-1,10162,10163, 5121,5127,10164,-1,

    10165,10166,-1,5118, 10167,-1,10168,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,5133, 5138,-1,5134,10169,
/* 80-bf */
    5129,10170,10171,5139, 3317,-1,10172,5141,
    10173,2502,5131,3593, -1,-1,10174,10175,
    -1,10176,10177,10178, 10179,-1,-1,10180,
    5135,5128,2013,-1, 2078,1969,5136,5132,

    -1,-1,-1,10181, 10182,-1,-1,2386,
    5142,5140,3351,2142, 2212,10183,5137,-1,
    2284,-1,10184,-1, -1,-1,1736,-1,
    -1,-1,-1,-1, -1,-1,-1,10185,
/* c0-ff */
    -1,10186,-1,10187, 5146,5144,10188,5207,
    -1,10189,-1,10190, 10191,-1,10192,-1,
    -1,10193,10194,10201, 5149,-1,-1,10202,
    10203,-1,5143,10204, 5147,-1,10205,5145,

    -1,-1,10206,2744, 5148,-1,-1,-1,
    -1,10207,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,10208,5151,
    -1,5156,-1,-1, -1,5154,5153,10209
};

static long uni_h_56[256] = {
    -1,-1,-1,-1, -1,10210,3518,-1,
    10211,1837,10212,-1, -1,10213,10214,10215,
    10216,10217,10218,-1, 5150,-1,5152,3008,
    1719,10219,-1,5155, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,1862,-1,-1, 10220,-1,-1,5166,
    10221,3092,5162,10222, 5160,10223,5161,10224,
    5163,10225,-1,10226, 10227,10228,-1,10229,
/* 40-7f */
    10230,10231,1729,10232, 10233,-1,10234,-1,
    -1,10235,-1,10236, 3325,10237,5157,10238,
    5158,-1,-1,-1, 10239,-1,-1,-1,
    -1,-1,-1,1990, -1,-1,10240,-1,

    10241,10242,10243,10244, 5165,-1,10245,-1,
    2079,10246,5168,5164, 5167,10247,-1,10248,
    -1,10249,10250,-1, 4214,10251,-1,-1,
    3853,-1,4024,-1, -1,-1,-1,-1,
/* 80-bf */
    5170,-1,-1,-1, 10252,10253,5169,1937,
    10254,-1,5171,10255, 10256,-1,-1,5174,
    -1,-1,-1,-1, 5173,10257,-1,-1,
    -1,10258,10259,-1, -1,10260,10261,10262,

    5172,-1,3925,-1, -1,5175,10263,10264,
    -2,-2,-1,-2, -2,-2,5176,-1,
    -1,10270,-1,-2, 5178,-1,5177,-2,
    -1,-1,-1,-1, 5180,-1,-2,-1,
/* c0-ff */
    5183,5181,5179,5182, -1,-2,-1,-1,
    5184,-2,-2,-2, 10280,-2,5185,10278,
    -2,5186,-1,5187, -1,-1,-1,5188,
    4937,10282,2892,2745, -2,-2,1883,-2,

    1688,-2,-1,3536, -2,-2,-2,10290,
    -2,-1,-1,10293, -1,-2,5189,-1,
    2604,10292,1647,3162, -1,-1,10301,-2,
    -1,5190,2439,-1, -1,2581,-1,5192
};

static long uni_h_57[256] = {
    5191,10303,-2,4264, 5193,-1,-1,-2,
    5201,5194,-2,5202, -2,5203,-1,2387,
    -1,-2,1764,5204, -1,-2,5206,-1,
    5205,-1,-2,-2, 5208,-2,-1,3758,

    10313,-1,-2,-2, -2,-2,5209,1621,
    2663,-2,-2,-1, -2,2329,-2,-2,
    3547,-1,-1,-2, -2,-1,-1,5210,
    5211,-1,-1,5213, -1,-2,-2,-2,
/* 40-7f */
    5214,-1,2668,-1, -1,-2,-2,2249,
    -1,-1,4323,-1, -2,-2,5212,5215,
    2633,2503,-2,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,5219,-2,-1, 2605,-2,3519,-2,
    -2,5216,3658,-2, -1,-2,-2,-2,
    -2,-2,-1,-2, -2,-2,-1,-2,
    -1,-2,-2,-2, -2,-1,-2,5220,
/* 80-bf */
    -1,-2,3166,-2, -1,-1,-1,-1,
    5218,5221,-1,2331, -2,-1,-1,-1,
    -1,-1,-1,5222, -2,10364,-1,10356,
    -1,-2,-2,-1, -2,-2,-2,-2,

    5223,-2,2504,1932, 5225,-1,-1,10365,
    -2,-2,5226,-1, -2,-1,-1,-1,
    5227,-1,-1,5224, -1,-1,-1,-1,
    -2,-1,-1,-1, -1,-2,-1,-1,
/* c0-ff */
    5217,-1,-1,5228, -1,-1,5229,-2,
    -2,-1,-1,4368, -2,-1,3075,-2,
    -1,-1,5231,5232, 5230,-2,5234,-1,
    -1,-1,-1,-1, 3924,-2,-2,1672,

    4154,10394,-1,5235, 10378,-1,-2,-2,
    -1,-2,-1,-1, -1,-2,-1,-1,
    -2,-1,-1,-1, 3093,-2,-2,2825,
    -2,3961,2080,-1, 2675,-2,-2,-2
};

static long uni_h_58[256] = {
    4357,-1,3818,10390, -2,2388,3447,-1,
    -2,-2,5233,5236, 10401,-2,-1,-1,
    -1,-1,-1,-1, -1,3436,-1,-1,
    -1,5237,-1,-2, -1,5238,-2,-2,

    -2,5240,-1,-1, 3673,-1,-2,-2,
    -1,-1,2014,-1, -1,-2,-1,8401,
    1765,4283,10410,-1, 3076,3740,-1,-1,
    -1,-2,2670,-1, -1,5246,-1,-2,
/* 40-7f */
    4229,4661,-1,-1, -1,-1,-1,-1,
    -1,-2,1884,5242, -2,-2,-1,-2,
    -2,3326,5245,-1, 3767,-2,-1,3741,
    3768,4025,3645,-1, -1,-1,2641,-2,

    -1,-2,5241,-1, -2,-1,-1,-2,
    -2,1786,-1,3722, -1,-1,-1,-1,
    5243,-1,5239,-1, -1,3148,-1,-1,
    10424,5247,-1,-1, -2,-1,2946,-2,
/* 80-bf */
    -2,-2,-1,2213, -1,5248,-1,-2,
    -2,-2,-2,-1, -2,-2,-1,-2,
    -2,-1,-1,4272, -2,-1,-2,3393,
    -1,-1,-1,-1, 3638,-2,-1,5250,

    -2,-2,-2,-1, -1,-1,-2,-1,
    4347,-2,-1,5251, -1,-1,5256,-1,
    -1,-2,-2,4215, -1,-1,-1,-1,
    5255,5249,5252,5254, 10448,-1,2606,-1,
/* c0-ff */
    -1,4241,-2,-1, 10447,5257,-1,3537,
    10450,-1,1885,-1, 3077,-2,-2,-1,
    -2,5259,-2,5258, -2,2572,-2,5260,
    5262,5261,-2,-1, 5264,-2,5253,5266,

    -1,-2,-2,-1, 5265,5263,-1,-1,
    -1,-2,-1,2746, 3149,-1,3352,5267,
    3228,1677,3968,-2, -1,-1,-1,3659,
    -1,5269,5268,5270, 5271,5272,-1,-1
};

static long uni_h_59[256] = {
    -1,-1,5273,-1, -1,10463,-2,-1,
    -1,4249,5274,-2, -2,-1,-1,1838,
    5275,-1,-2,-2, -2,4528,1916,-1,
    5041,2940,3431,5276, 4475,10471,-1,-1,

    -1,-2,4420,-2, -2,5278,-1,3471,
    -2,3723,3432,4155, 5279,5280,1791,-2,
    -2,2826,5281,-2, -1,-2,-2,1648,
    5282,-1,-1,-1, -1,-1,5283,10481,
/* 40-7f */
    -1,-1,-1,-2, 1766,-1,-2,2081,
    3864,4284,-1,-1, -1,-1,5287,3353,
    5286,2332,-2,-2, 4359,5285,-1,3769,
    5289,-2,5288,-2, -1,-2,-2,-2,

    5291,-2,5290,-2, -1,1792,-1,5292,
    3009,5294,3505,-2, 5293,-2,4219,10501,
    -1,-1,-2,2987, 3759,-2,-2,-1,
    5301,-2,-1,-2, -2,2505,-1,-1,
/* 80-bf */
    -1,5302,3901,4062, 4449,-1,-1,-1,
    -1,-1,3905,-2, -2,5311,-2,-1,
    -1,-1,-2,2124, -1,-2,4537,-2,
    -1,4415,-1,5412, -1,5303,-1,-2,

    -1,-1,-1,5306, -2,3437,-1,-2,
    4324,-1,-1,-1, 3742,-2,-2,-2,
    -2,-1,5307,-2, -1,-1,-1,-2,
    -1,4369,-2,2642, -2,-1,3010,-1,
/* c0-ff */
    -1,-2,-1,-2, -2,-1,5308,-1,
    -2,2748,-2,2747, -1,-2,-1,-1,
    1625,2440,-2,3211, 1649,-1,-1,-1,
    -1,5312,5313,-1, 5310,-2,-2,-2,

    -1,-1,-1,-2, -2,1724,2015,-2,
    5309,-1,4437,4117, -1,-1,-2,-2,
    -1,-2,-2,-1, -2,-1,1608,-2,
    -1,-1,-1,1689, -1,-1,-1,2749
};

static long uni_h_5a[256] = {
    -2,1650,-1,1603, -2,-1,-1,-1,
    -1,5318,-1,-1, -2,-2,-2,-1,
    -1,5316,-2,-2, -1,-1,-1,-1,
    4428,-1,5319,-1, 5317,-1,-2,5315,

    3117,-1,-1,-2, -2,5314,-1,-2,
    -2,4258,-2,-1, -1,-2,-1,2468,
    -2,-1,-1,-1, -1,5323,5324,-1,
    -1,-1,-1,-1, 3011,-1,-1,-1,
/* 40-7f */
    5320,4712,-1,-1, -2,-2,3944,-2,
    -2,5322,-1,-1, -2,-1,-1,-1,
    -2,-1,-1,-1, -1,-2,-1,-1,
    -1,-1,2607,-1, -1,-1,-2,-1,

    -1,-1,5325,-2, -1,-2,4156,-2,
    -1,-1,5326,-1, 5321,-2,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-2,
    -1,-1,-2,-2, -1,-1,-2,4427,
/* 80-bf */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-2, -1,-1,-1,-1,
    -2,-1,3962,-2, -1,-1,-2,-1,
    -1,-2,5327,4118, -2,-1,-2,-2,

    -2,-1,-2,-1, -1,-1,-1,-2,
    -1,-1,-1,-1, -2,-1,-1,-1,
    -1,-2,-2,-2, -1,-2,-1,-1,
    -2,-1,-2,-2, 5328,5332,5329,-2,
/* c0-ff */
    -1,1839,5331,-1, 10601,-1,-2,-1,
    -2,2827,-1,5330, 2389,-1,-1,-2,
    5344,-1,-1,-1, -1,-1,5337,5334,
    -1,-1,-2,-1, -2,-1,-1,-1,

    -2,3568,-1,5333, -1,-2,5335,-1,
    -1,5336,-2,-1, -1,-1,-2,-1,
    -1,-1,-1,-1, -1,-2,-2,-1,
    -1,-1,5338,5339, -1,-2,-1,-1
};

static long uni_h_5b[256] = {
    -2,-2,-1,-1, -1,-1,-1,-1,
    -2,2082,-1,5341, 5340,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,5342,-2,
    -1,10619,-1,-2, -1,-2,-1,-1,

    -1,-2,3078,-1, -1,-2,-1,-1,
    -1,-1,5345,-1, 3660,-2,-1,-1,
    1737,-1,5343,-1, 10618,-1,5346,-1,
    10625,-1,-1,-1, -1,-1,5347,-1,
/* 40-7f */
    5350,-2,-1,5348, -1,5349,-1,-1,
    -1,-1,-1,-2, -2,-1,-1,-1,
    2750,5351,-2,-1, 2506,5352,-2,2790,
    3424,-1,5353,5354, 2758,2507,-2,4450,

    -1,-1,-1,2108, 2441,5355,1956,-1,
    -2,5356,-1,3425, -1,-1,-2,-2,
    5357,5403,-1,5358, -1,5359,-1,-1,
    5360,-1,5362,-1, -2,-2,-2,-2,
/* 80-bf */
    5363,-2,-1,5364, -2,3480,-2,1707,
    2873,1634,-2,3355, 2016,2821,-2,2508,
    -2,-2,-1,-2, -2,3770,-2,2901,
    2017,3572,3674,1624, 2125,4285,-1,2834,

    -1,-1,2150,3275, 2828,4508,5365,-1,
    -2,-2,-1,-1, -2,-2,2160,-2,
    2643,-2,-2,1918, 1767,3012,1840,-2,
    5366,4538,-2,-1, -2,-1,-1,2941,
/* c0-ff */
    -2,-2,2868,5367, 2083,3850,4409,5368,
    -1,5369,-1,-1, 4157,-2,-1,-2,
    5371,-1,2008,2287, 5370,-1,-2,-2,
    -2,-2,-2,2018, -1,3118,5375,2701,

    -2,1841,5374,-1, 5372,5376,5373,3911,
    6045,3119,-1,5377, -1,-1,4632,-2,
    5378,-2,-1,5380, -2,3594,5379,-1,
    3203,-1,2791,-1, -1,-2,3448,2887
};

static long uni_h_5c[256] = {
    -1,4185,3276,-1, 2845,5381,3013,5382,
    5383,1651,3426,3150, -2,5384,3819,3014,
    -1,3015,-1,5385, -1,-1,3277,-2,
    -1,-1,3016,-1, -1,-1,-2,-2,

    5386,-1,5387,-2, 4464,-1,-2,-1,
    5388,-2,-1,-2, -2,2238,-2,-1,
    -2,2902,-2,-1, -1,-2,-2,-1,
    5389,5390,2860,3112, 3884,3152,4088,3902,
/* 40-7f */
    2241,5391,-1,-1, -1,2179,5392,-1,
    2294,-1,3847,1816, -1,2751,5393,5402,
    5401,2293,-1,5394, -1,3724,-1,-1,
    -1,-2,-2,-1, -2,-1,3416,-1,

    3743,2840,-2,-2, 3356,4590,-1,-2,
    -2,-2,-1,-1, 5404,10701,5405,3854,
    -2,2719,-1,-1, -2,-2,5407,-1,
    -1,5408,-2,-2, -2,-2,-1,-1,
/* 80-bf */
    -1,-1,-1,-1, -1,-1,-1,-2,
    -2,-1,-2,-1, 5409,-1,-1,-2,
    2084,5410,-2,-1, 5411,-1,-1,-1,
    -1,-1,-1,-1, -1,-2,-1,-2,

    -2,1812,-2,-2, -1,-1,-2,-1,
    3327,2068,-2,5413, 4408,-1,-1,-1,
    -1,3450,-2,1957, -2,-2,5415,5417,
    2063,-1,-2,5414, 5416,-1,5419,-1,
/* c0-ff */
    -1,-1,-1,-1, -1,5418,-1,5420,
    -1,-2,-1,-2, -1,-1,-1,-1,
    -1,-1,-2,-1, -1,-1,-1,10729,
    -1,5421,-1,-1, -1,10728,-1,-1,

    3829,2214,-1,-1, -1,-1,-1,-1,
    1869,5422,5427,-1, -1,5425,10730,4287,
    4286,-2,-2,-1, -2,-1,3771,-1,
    -1,-1,5424,2952, -1,5423,-1,-1
};

static long uni_h_5d[256] = {
    -1,-2,-1,-1, -1,-1,-2,3182,
    -1,-1,-1,5428, -1,-2,2674,-1,
    -1,5434,-2,-1, 5435,5429,1919,5430,
    5439,5438,5437,5433, -1,-1,-1,5432,

    -1,-1,5436,10739, -2,-1,-2,-2,
    -1,4288,-1,10738, -1,-1,-1,-1,
    -1,10743,-1,-1, -2,-1,-1,-1,
    -1,-2,-1,-1, -1,-2,-1,-2,
/* 40-7f */
    -1,-1,-2,-2, -1,-1,-2,-1,
    -2,-1,10755,5443, 5440,-1,5442,-1,
    4582,10753,5441,-1, -1,10752,-1,-1,
    -1,10754,-1,-1, 5431,-1,-1,10756,

    -2,-2,-2,-1, -2,-1,-1,-1,
    -1,3183,-2,-1, 5444,-2,-1,2623,
    -2,-1,-1,5445, -1,-1,5446,-1,
    -1,-2,-2,-1, -1,-1,-2,-2,
/* 80-bf */
    -1,-2,5449,-2, 5448,-1,-1,5447,
    -2,-1,-2,3772, 5426,-1,-1,-1,
    5455,-1,-2,-2, -2,-2,-1,-1,
    -1,-2,-1,-2, -1,5451,-1,-2,

    -2,-1,5450,-1, -1,-1,-1,-2,
    -1,-1,-1,-2, 5452,-1,5453,-1,
    -2,-1,15084,-1, 10783,-1,-1,5456,
    -2,-2,4670,-1, 5457,5454,-1,-1,
/* c0-ff */
    -1,-1,-1,-2, -1,-1,-1,-2,
    -1,5458,-1,-2, 2064,5459,10790,-1,
    10789,-1,5461,5460, -1,-1,5462,-1,
    10791,-2,-1,5463, -1,3278,2903,-1,

    -2,2968,-1,3367, -2,2509,2624,2510,
    2180,10801,-1,5464, -1,-1,2625,-1,
    -1,2442,5465,4406, 3935,5466,-1,2511,
    -2,-2,-1,2012, -1,3507,2250,-1
};

static long uni_h_5e[256] = {
    -2,-1,2752,4159, -1,-1,4033,-2,
    -1,-1,-1,5467, 2085,-2,-1,-1,
    -1,5470,-2,-1, -2,-2,3601,-1,
    -2,5469,5468,5471, -1,3675,-1,-2,

    -2,-1,-1,-1, -1,3167,-1,-1,
    10814,-1,-1,2753, -1,3242,10813,3451,
    2102,-1,10815,3602, -1,-2,5472,5473,
    3079,-1,-1,-1, -1,4325,-2,-1,
/* 40-7f */
    5476,-1,-1,5475, 5474,4193,-1,5483,
    -1,10820,-1,10818, 4358,-1,5477,-1,
    -2,10821,-1,-1, 5479,4375,-2,5478,
    -2,-1,-1,-2, -2,-1,-2,5480,

    -1,4008,5481,4230, 5482,-1,-1,-1,
    -2,-1,-2,-2, -2,-2,-2,-1,
    -2,-1,2019,4231, 3915,5484,5485,-1,
    2512,2020,5486,2424, 4536,4509,2086,5488,
/* 80-bf */
    -2,3603,-1,2513, 3017,-1,-1,4063,
    -1,-1,3018,-2, -1,-1,-2,2988,
    -1,-1,-1,-1, -1,3676,4289,3725,
    -1,-1,2514,-1, 4160,-1,-1,-1,

    5489,-1,-2,-1, -2,-2,3757,2634,
    -2,-1,-2,2443, -2,3677,-1,-1,
    -1,-2,-1,-2, -1,1635,2978,2515,
    4539,-1,-1,-1, -1,-2,-2,-2,
/* c0-ff */
    -1,5490,5491,3949, -1,-1,-2,-1,
    5492,4687,4713,10850, 10849,-1,10851,5494,
    5493,-2,-2,1939, -2,-2,5501,-1,
    -1,-1,5504,5505, -2,5503,-2,4132,

    3019,5507,5506,5502, -1,-2,-1,-1,
    5508,5509,-1,-2, 5510,-1,-1,-1,
    5513,5511,-1,5512, 5514,-1,1768,3678,
    5515,-1,2390,1886, 3922,-1,5516,3891
};

static long uni_h_5f[256] = {
    -1,4259,-2,5517, 4714,-1,-2,-2,
    -2,5518,4232,5521, 4801,4817,-2,2816,
    3885,5522,-1,2161, 3604,1690,5523,4206,
    2516,-2,-1,3548, -2,-2,-1,3679,

    -1,-2,-2,-2, -2,4479,2425,2444,
    -2,5524,-1,-2, -2,5525,-2,5531,
    -2,2869,-1,-1, -2,3605,-2,2215,
    5526,-1,-1,-2, 4111,-2,3538,-2,
/* 40-7f */
    -2,5527,-1,-1, -2,-2,-1,-2,
    5528,-1,2216,-1, 5529,-2,5530,-1,
    -2,5532,-1,3786, -2,-1,5533,5534,
    -2,5535,-1,-2, 5520,5519,-1,-1,

    -2,5536,2333,-2, -2,-1,4107,-2,
    -1,2644,4123,3606, 4143,5537,-1,10901,
    3020,1738,-2,5538, -2,-2,-1,5539,
    -2,4482,-2,-1, 4064,-2,-2,5542,
/* 80-bf */
    1793,3212,5541,5540, 2334,3452,-1,5546,
    5544,-2,5543,4607, 2469,-2,-1,-2,
    2989,5545,3744,2930, -1,-1,-2,3832,
    5549,5548,-1,-1, -2,-2,5547,-1,

    5550,2470,-2,-1, 10918,-1,-1,10916,
    5551,4192,2959,10917, 10919,5552,4089,-2,
    -2,-2,-1,3833, 3607,-1,-1,-1,
    -2,3716,-1,-1, 5553,2111,-1,-1,
/* c0-ff */
    -1,-1,-1,3120, -2,4112,-1,-2,
    -2,-2,-1,-2, 2087,3906,-1,-1,
    -2,-2,-2,-2, -2,-1,5554,2754,
    4326,4327,-1,-1, 1794,5559,-2,-1,

    3573,-2,-2,-1, 5556,-1,-1,-1,
    -2,-2,-2,1887, -2,-2,-2,-2,
    5613,5558,-2,-2, -1,3916,-2,-1,
    5557,-1,-2,5555, -2,2590,-1,5561
};

static long uni_h_60[256] = {
    -1,-1,-1,-1, -1,-1,-1,10949,
    -1,-1,-2,-1, -1,-2,5567,5573,
    5565,-1,3760,-2, -2,5570,4161,-2,
    -2,5564,-2,5569, 4671,2755,-1,-2,

    3453,5562,-1,-1, -2,2162,5572,3213,
    1769,5566,1888,5571, -1,-2,-1,2217,
    -1,5568,-1,-2, -1,-2,-1,-1,
    -1,-1,5574,-1, -1,-1,-1,-1,
/* 40-7f */
    -2,5576,5586,5584, -1,-1,5581,-2,
    -2,-2,5580,4688, -2,5582,-1,-1,
    2218,-2,2517,-1, -2,2990,-2,-2,
    -1,5589,5575,-1, -1,-2,-1,5579,

    5563,-2,1890,5583, 5585,3549,-1,-2,
    2608,1824,5577,5588, 5587,2219,-1,3409,
    1970,-2,-1,-1, -1,2335,-1,5578,
    -1,-1,-1,-1, -1,-1,-2,-2,
/* 80-bf */
    -1,5590,-2,5593, 5601,-1,-2,-1,
    -2,2829,-2,5607, 3680,5591,-2,-1,
    -1,-2,5605,-2, 1889,-2,5603,5604,
    -2,-1,5594,5602, -1,-2,-2,2471,

    4510,-1,-2,2021, -2,-2,1757,5606,
    -2,3926,1613,-1, -1,-1,-1,-1,
    -2,-2,4065,5560, 5612,5616,4469,-2,
    5609,-1,-1,11001, 3773,5614,-2,-1,
/* c0-ff */
    -1,-1,-2,-1, -2,3080,5615,3855,
    -2,-2,-2,-2, -1,-1,-2,-2,
    -1,4739,-1,5611, -2,-2,-1,-1,
    5617,-2,2591,-2, 3243,-2,-2,1652,

    5610,5608,-2,3358, -1,-2,-1,5592,
    2720,-1,-1,-1, -1,-1,-1,-1,
    3438,5629,-2,3359, 5624,-2,5621,5622,
    -2,2870,5625,5628, -2,-2,-1,-1
};

static long uni_h_61[256] = {
    5623,2905,-2,5626, -1,-1,5620,-2,
    4492,4491,-2,-1, -2,5630,5631,1653,
    -2,-2,-2,-2, -2,5619,-2,-2,
    -1,-2,2282,1606, -2,-1,-2,2022,

    -1,5627,-2,-1, -1,-1,-1,5635,
    5634,-1,-2,-2, 5639,-1,-1,-1,
    -2,-2,-1,-1, 5640,-2,-2,-2,
    -1,-2,-1,-1, 5638,5641,5633,5637,
/* 40-7f */
    -1,-2,5642,-1, 5643,-2,-2,5632,
    2792,-2,5636,3454, 2518,5618,3121,-1,
    -1,-1,-1,5656, -1,4273,-1,-1,
    5646,5647,5648,-1, -1,5655,-2,5654,

    -2,-1,4393,2023, -1,5652,-1,2337,
    1920,-1,-1,5649, -2,-1,4624,5651,
    1654,5653,-2,5644, 5650,5657,2336,5645,
    -2,-1,-1,-2, -2,-1,4561,-2,
/* 80-bf */
    -2,-2,4511,-2, -2,-1,-1,5660,
    -1,-1,5664,-2, -1,-2,3394,-1,
    4689,5665,-2,-2, 5662,-1,5659,-2,
    -2,5658,5663,-1, -2,-2,-1,-2,

    -2,-1,-1,-1, 4216,-2,-1,3820,
    -2,2338,-2,5666, 5661,-2,5667,-1,
    -1,-1,2391,-1, -1,-1,1817,-1,
    -2,-2,5675,-1, -2,-1,2024,-1,
/* c0-ff */
    -2,-2,-2,5673, -1,-1,5674,2609,
    5672,5670,5669,5676, 5668,5678,-2,-2,
    1891,-1,-1,-1, -1,-2,-1,-1,
    -1,-1,-1,-1, -2,-2,-2,-2,

    -1,-2,-2,5680, -1,11094,5679,11092,
    -1,-2,-1,-1, 11101,-2,-1,-2,
    -1,-1,3608,-1, 5683,-1,5681,5671,
    2392,-1,5682,-1, 5686,5685,5687,5684
};

static long uni_h_62[256] = {
    5688,-2,-1,-2, -2,-1,-1,-2,
    5689,5690,4274,-1, 5692,5691,2931,-1,
    3214,1870,1892,-2, 5693,-2,1631,-1,
    -1,-1,3244,5694, -2,7635,5701,2365,

    -2,5702,-2,-2, -1,-1,3279,-2,
    -1,-2,5703,-2, -1,-1,5704,2126,
    5705,-1,5706,5707, 3455,-1,-1,-1,
    2445,-2,-1,4465, -1,-2,-1,4328,
/* 40-7f */
    2974,5708,-2,-2, -2,-1,-2,3280,
    7829,4066,-1,2874, -2,2645,5709,-1,
    -2,-2,-2,3439, -2,4207,-2,-1,
    3481,-1,-2,5712, -2,-1,5710,-1,

    5713,-1,-1,5711, -2,-1,-1,-1,
    5714,-1,-1,-1, -1,-2,4217,-2,
    -1,1623,-1,-2, -1,-1,4162,-1,
    -1,4067,-2,-1, 5715,-2,5718,3021,
/* 80-bf */
    2127,-1,5716,5723, 3022,-1,-1,-1,
    -1,5717,3936,-1, -1,11137,-2,-2,
    -2,4562,5719,5720, 5724,3774,5721,2519,
    3262,-1,-1,5738, 4020,-1,3482,-1,

    -1,-1,-1,-1, -1,-1,-2,-1,
    -2,-1,-1,4068, 5813,-1,-1,-1,
    -1,4290,-1,-2, -1,3681,-2,-2,
    -1,4385,-2,5727, 1801,3574,-2,-2,
/* c0-ff */
    -1,-1,5736,-1, -2,3520,5730,5737,
    5732,5739,5735,-1, 5734,3979,-2,5728,
    1893,5726,2181,3483, 5722,-2,-2,5725,
    2520,3259,-2,3023, 5733,3950,-1,-1,

    2182,1940,-1,-1, -1,-1,-1,-1,
    -1,-1,-2,-1, 1971,3101,5741,5746,
    -1,5742,-2,2393, -2,5747,2702,2573,
    -1,-1,-1,-1, -2,-2,2906,5729
};

static long uni_h_63[256] = {
    -1,2793,5744,-2, -2,-1,-1,2756,
    5745,1636,-2,-2, 5740,-2,-1,-1,
    -2,3609,-1,-2, -1,-1,-2,-1,
    -2,2183,-1,-1, -1,-1,-1,2220,

    -1,-1,-1,-1, -1,-1,-1,5743,
    1607,-2,-2,2635, -1,-2,-1,3122,
    -1,-1,-1,-1, -1,-2,-2,-1,
    -1,-2,3682,-1, -2,4052,5749,3362,
/* 40-7f */
    -1,-2,-2,-2, -2,-1,-2,-1,
    -1,3410,-2,-2, 2711,5750,-2,5752,
    5748,-1,-2,-2, -2,4265,-1,3629,
    -2,-1,-1,-2, 3360,-1,-1,-1,

    -1,-1,-1,-1, -1,-2,-2,4291,
    2846,5764,-1,5763, -2,-2,3188,-1,
    -1,-2,2394,-1, -2,-2,5757,3025,
    11201,-1,3872,3917, -2,-2,-1,-2,
/* 80-bf */
    5755,-1,-2,3361, -2,-1,-1,-2,
    2888,5760,-2,-1, 3024,-1,5754,5759,
    -2,-1,3951,-1, -2,-2,5753,-1,
    2301,-2,-2,1961, -1,-1,-2,5761,

    4611,2646,3521,5758, -2,3260,-2,2521,
    3168,1770,3328,5756, 2137,-2,-2,-2,
    -1,-1,2339,-1, 3647,5762,-1,-1,
    -1,-1,-1,3363, -1,-2,5765,-1,
/* c0-ff */
    5767,-2,-1,3423, 5773,-2,5768,-1,
    -2,5770,-1,-1, -1,-1,-2,4133,
    3683,-2,5771,-2, -2,-2,4512,-1,
    -1,-1,4540,2025, -2,-1,-1,-1,

    -2,1614,-1,5769, -1,-2,-1,-1,
    -1,5766,-2,-1, -2,-1,2088,-1,
    -1,-1,-2,-2, 1771,-2,5772,-1,
    -2,-2,4541,-1, -1,-1,-1,-1
};

static long uni_h_64[256] = {
    -1,-1,-1,-1, -1,-1,5776,-1,
    -1,-2,-2,-1, -1,3427,-1,5783,
    -2,-1,-2,5777, -2,-1,5774,5781,
    -2,-1,-1,-1, 5751,-1,-2,-1,

    -2,-1,-2,-1, -2,-2,5778,-1,
    5782,11250,-2,-1, 4034,3775,-1,-2,
    -2,-1,-1,-1, 5775,-2,5779,-1,
    -1,-1,2340,-1, -1,-2,2681,-2,
/* 40-7f */
    -1,-1,3261,-1, -1,-1,-1,-1,
    -1,-1,-1,-2, -1,-1,5787,-2,
    -1,-2,-2,-2, -2,-1,-1,-1,
    3706,-1,-2,-2, -2,-2,-1,-2,

    -2,-2,-1,-2, -1,-1,-1,5784,
    -1,4364,-1,-1, -1,-2,-1,5785,
    -1,-1,-1,-2, -2,-1,5786,-1,
    4446,-1,3202,-2, -1,-2,-1,-1,
/* 80-bf */
    -1,-1,-1,2366, -1,-2,-1,-2,
    5793,-1,-1,-1, -1,-1,-1,-2,
    -2,-2,2721,5790, -1,5789,-1,-1,
    -2,-2,3918,-2, -1,-2,3821,-2,

    -1,-2,-1,-2, 3717,5791,-2,-1,
    -2,5792,-1,4179, -2,3937,2703,-1,
    3281,-1,4348,-2, -1,-1,-1,-1,
    -1,1941,-1,5805, 5794,-2,-2,-2,
/* c0-ff */
    -1,4542,5807,-1, 11301,5803,-1,5804,
    -1,-2,-2,-2, -2,3364,-2,-1,
    -2,-2,5802,-1, 5731,-2,-1,-2,
    5806,-1,5801,-1, -1,-1,-1,-1,

    5811,5812,3707,5814, -2,-2,2704,5809,
    -1,-2,-2,-1, 2128,-2,-1,5815,
    -2,5808,5819,-1, 5818,-2,5817,-2,
    -1,-1,5820,-2, -1,5822,3081,-2
};

static long uni_h_65[256] = {
    5821,11321,-1,-1, -2,5825,-1,-1,
    -2,-2,-2,-1, -1,-1,-1,-2,
    -1,-1,-1,-2, -2,-1,-2,-1,
    5823,-2,-1,-2, 5824,5780,-2,-2,

    -1,-1,-2,5827, 5826,-1,-2,-1,
    -1,-2,5788,5828, 5816,-1,-2,2757,
    -1,-2,-1,-1, 5829,5830,5832,5831,
    5833,1894,-2,2522, -2,-2,4292,3215,
/* 40-7f */
    -1,-1,-1,-2, -1,2446,-1,-2,
    5835,-2,-1,-1, -1,5838,-1,4150,
    -2,2163,-2,-1, -2,5837,5836,3952,
    5839,2221,-1,-1, -1,5841,5840,-2,

    -2,-1,2026,2722, -1,-1,3856,11350,
    -1,-1,-1,-2, 2341,-1,-1,-1,
    3184,-1,5842,-1, 3216,3708,-1,4163,
    5843,-1,-2,-1, -1,-2,-1,-1,
/* 80-bf */
    -1,-2,5844,5845, -1,-2,-1,4224,
    5361,3238,-2,-1, 4144,-1,2656,-1,
    4069,4035,-2,-1, -1,-2,-1,3745,
    -2,4633,-1,5847, 2848,-2,-1,5848,

    -2,1622,-1,-2, 2252,3245,-2,4164,
    -1,-1,-1,5849, 2734,3539,-2,2759,
    3123,-1,-2,-2, -2,-1,-1,5850,
    -1,4293,-1,-1, 1787,2760,-1,-2,
/* c0-ff */
    -1,5853,-2,5851, 5854,4625,5852,-1,
    -2,-2,-1,3291, 5855,-1,-2,3418,
    -2,-1,5856,-1, -2,-1,-2,2090,
    -2,5858,-1,5857, -1,-1,-1,-2,

    5859,5860,2091,-1, -1,3892,3522,2176,
    2761,3365,-1,-1, 2960,1616,-1,-1,
    -2,5861,-2,-1, -2,-2,-1,-1,
    -1,-2,1802,5865, -1,-1,-2,-2
};

static long uni_h_66[256] = {
    11385,-1,2523,5864, -2,-1,2611,3026,
    -2,-2,5863,-1, 3027,-2,4432,2610,
    -1,-2,-2,1655, 3246,-2,-2,-1,
    -1,-1,-1,-1, 5870,-2,11401,3217,

    1739,-2,-2,-2, -2,2953,-2,4370,
    2682,-2,-2,-2, -2,3028,-2,3207,
    -2,-2,-1,-2, 5869,5867,5868,11416,
    -1,11415,-1,-1, 3575,-1,-1,5906,
/* 40-7f */
    11417,5874,2794,2524, 5872,-2,-2,-1,
    -1,5873,-2,3124, -2,-1,11423,5871,
    -1,11422,2715,-1, -1,-1,-1,11424,
    -2,-2,-1,-2, -2,5876,5875,5880,

    -2,-2,5881,-1, 5877,-1,1902,5878,
    5879,4053,11432,-2, -2,-1,4165,2342,
    5882,-1,-1,11436, 3218,-2,3029,11439,
    -2,-2,3550,-2, 11444,-1,11435,11438,
/* 80-bf */
    11443,2239,-1,5883, 5887,-1,-1,1843,
    5884,5886,-1,11445, -2,-2,5885,-1,
    -2,2975,-2,-1, -1,-1,3540,1637,
    5888,-2,-2,-2, -2,5889,-1,-2,

    -2,-1,3610,-1, -2,-1,4681,-1,
    -1,-1,-1,2735, -1,-2,4275,-1,
    -1,-2,-2,-1, 4329,-2,-1,-1,
    5902,5891,-1,-2, 5894,-1,5893,-2,
/* c0-ff */
    11463,5890,-2,-2, 5901,-1,-1,3862,
    -2,5892,-1,-1, -2,-1,-2,-2,
    -1,-1,-1,-1, -2,-1,5903,-1,
    -1,2976,5904,-2, 4543,3988,-1,-2,

    5905,-1,-1,-1, -1,-1,5907,-1,
    -2,5908,-1,-2, -2,-1,-2,-1,
    5909,-1,2242,1740, 2525,5910,-1,5911,
    2981,3366,-2,11431, 5056,3330,3329,3456
};

static long uni_h_67[256] = {
    2639,-1,-1,4882, -1,11478,-1,-2,
    2378,4513,-1,4294, -1,4194,-2,5912,
    -1,-1,-1,-2, 2683,3631,5913,4715,
    -1,-2,-1,4330, -2,3611,5914,2092,

    -2,-1,-2,-1, -1,-1,5915,5916,
    4458,-1,4404,4386, 4360,2705,5918,-1,
    -1,2875,-1,-2, 4349,-1,5920,5923,
    5922,-1,2089,-1, -1,2164,-2,5919,
/* 40-7f */
    -1,5921,-1,-1, -1,-2,5924,-2,
    -2,3189,-1,-1, -2,-1,4591,1641,
    2664,3428,-1,2861, -2,-2,3083,-1,
    -1,5927,-1,-1, 3746,-2,5925,3411,

    5926,3082,4461,5928, 5929,4572,11501,-1,
    -1,-1,5934,-1, -2,2526,-2,3953,
    5931,3776,5862,5866, -2,2147,-2,3939,
    -1,-1,-1,-2, 5933,-1,3030,4036,
/* 80-bf */
    -1,-2,-1,-1, -2,5939,-1,4090,
    -1,5930,-1,5936, 5935,-1,-2,-2,
    3247,-2,-1,-2, -1,4377,-2,4651,
    -2,-2,4371,-2, 1844,2762,-1,-1,

    4740,5938,3185,-1, -1,-1,5937,-1,
    -1,5932,-1,-1, -1,-1,-1,2447,
    -2,-2,-2,5944, 5942,-2,1845,5940,
    5946,5952,-1,-2, -2,-2,-1,-1,
/* c0-ff */
    11525,3440,-2,-2, 4233,-2,5954,-1,
    -2,-2,4102,-1, -1,-1,5953,3980,
    4331,2027,-2,3287, 2932,-1,-1,-2,
    3651,-2,4514,-1, -2,5949,5948,-1,

    -1,-2,5950,-1, 5947,-1,-2,5955,
    -1,5945,-1,-1, 5943,-1,5951,5941,
    -2,3576,-2,4488, 2838,2684,-2,-2,
    -1,11524,-1,2626, -1,-1,4379,1933
};

static long uni_h_68[256] = {
    -1,-1,3646,3842, 1741,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,3282, 11542,-1,3220,2310,
    -1,-2,-1,-1, -1,-2,5957,-2,

    -1,2527,1992,-1, -1,-1,-1,11547,
    11546,5959,1984,5965, 11548,-2,-1,-2,
    -2,-2,5962,-2, 3283,-1,-1,-1,
    1943,2612,-1,-2, 1942,2647,-1,-2,
/* 40-7f */
    5960,2369,2343,3777, -2,-2,5958,-1,
    1638,-1,-2,-1, -2,5961,5963,-1,
    2245,2312,11541,2028, 2143,11560,-1,-2,
    -2,5966,-1,-2, 2689,4381,-1,2723,

    -1,-1,-1,5967, -1,-1,-1,4116,
    -1,-1,-1,-2, -1,-1,-2,-2,
    -2,-2,-2,-1, 5979,-2,1819,5968,
    -1,-2,-2,-2, -2,-1,5985,5969,
/* 80-bf */
    -1,4634,-2,5976, -2,3963,-2,-1,
    -2,-1,-1,-1, -1,5984,-1,5971,
    -1,-1,-1,1620, 5973,-1,-2,2528,
    -2,-1,-2,5975, -2,5974,-1,5970,

    5981,-2,3031,-2, -1,-2,5277,2472,
    4592,-2,-2,-1, -1,5972,-2,3684,
    1903,2613,-2,5964, -1,5980,1965,-1,
    -1,5978,5982,-2, 3778,-1,-1,-1,
/* c0-ff */
    -1,-1,-1,-1, 2094,-2,6018,-1,
    -2,4441,5987,2093, -2,5994,-1,-2,
    11601,-2,4332,-2, 6001,6003,-2,6007,
    5989,-2,3510,-1, -2,-2,-1,3779,

    6011,5992,-1,6008, -1,-2,-1,6002,
    -2,-1,-2,-2, -2,-2,3125,6012,
    -2,-2,3219,-1, -1,-2,-2,-1,
    -1,6010,2029,-2, -2,-2,-1,-1
};

static long uni_h_69[256] = {
    4748,5986,-1,-1, 6006,1656,11621,-1,
    5988,-2,-2,4426, 5993,3102,3639,5983,
    -2,-2,6005,-2, -1,-1,-2,-2,
    -1,3190,6015,1981, 2401,-1,-1,-1,

    -1,6017,5990,6016, -1,6009,5991,-1,
    6013,-1,6014,-1, -1,-1,-1,-1,
    6031,-2,-1,-2, 3846,-2,6004,-1,
    -2,6027,-1,-2, -1,6029,-1,3656,
/* 40-7f */
    -1,-1,-2,-1, -1,-2,-1,-1,
    -1,-2,4544,-1, -1,-1,-2,-1,
    -1,-1,-1,4186, 6024,3442,-1,-2,
    -1,6030,3331,-2, 6021,6034,6033,-1,

    3879,6032,3874,-2, -2,-2,-2,-1,
    -2,-2,6036,6023, -2,2240,6026,2961,
    -2,-2,-2,3964, 6028,2243,-1,6020,
    6022,6019,11650,-2, 4716,1958,6025,-2,
/* 80-bf */
    -2,6035,1921,-1, -1,-1,-1,-1,
    -1,-1,2671,-1, -1,-2,1761,-1,
    -1,6052,-2,-1, 4717,6055,-2,-1,
    -2,-1,-1,3126, 6054,-1,-1,-1,

    6053,-2,-1,-1, -1,-2,-2,6050,
    -2,-1,-1,-2, -1,-2,6038,-2,
    -1,6067,6037,-1, 6056,-1,-1,-2,
    -2,-1,-2,6048, -2,-1,6043,6040,
/* c0-ff */
    -1,6041,-1,6049, -1,-2,-1,8402,
    -2,-1,6046,2529, 3640,3368,6044,-1,
    6039,-2,-1,6042, -1,-1,-2,-2,
    4545,4374,-1,-1, -1,6047,6057,-1,

    -1,-1,-2,-1, -1,-2,-1,6065,
    6058,-1,-1,6071, -1,6069,-2,-2,
    -1,-2,6064,-2, -1,-2,-1,-1,
    -1,6063,-1,3648, -1,3369,-2,6061
};

static long uni_h_6a[256] = {
    11682,-2,6059,-2, -1,6066,-1,-1,
    -1,-1,6072,4085, 6078,-1,-1,-2,
    -1,-2,6073,6076, 6070,-2,-1,3584,
    -1,4124,-2,6060, -1,-2,6068,3032,

    -2,4447,6088,6075, -2,-1,-1,-1,
    -2,2402,1803,1963, -1,-1,6051,-1,
    -2,-1,-2,-1, 11701,3033,6080,-2,
    6087,2889,1982,-2, -1,3514,-2,-2,
/* 40-7f */
    -1,-1,-1,-1, 6077,-2,-2,6082,
    6086,-2,-2,2222, -1,-1,-2,-1,
    -2,-2,-2,-1, -1,-2,-2,-1,
    2144,6084,-1,-2, -1,-1,-1,2101,

    -1,3843,6083,-1, -2,-1,6085,-2,
    -1,-1,-2,-1, -1,-1,-1,-1,
    -1,-2,6079,-2, -1,-1,-1,-1,
    6081,-1,-1,-1, -1,-1,-2,1964,
/* 80-bf */
    3541,-2,-1,-2, 6092,-1,-2,-2,
    -1,-2,-1,-2, -1,6090,2473,-1,
    6089,-2,-1,-1, -1,-1,-1,6101,
    -1,-1,-1,-2, 5956,-2,-2,-2,

    6091,-1,6093,6094, -1,11734,-1,-1,
    -1,-1,6112,-2, 6108,-1,5977,-2,
    -2,-2,-1,6107, -2,-1,-1,-1,
    6106,-1,-1,6103, -1,-2,-2,-2,
/* c0-ff */
    -1,6074,6105,6104, -1,-1,-2,-1,
    11745,11744,-1,-1, 11746,-1,-1,-1,
    -2,6110,-1,4706, -2,-2,-2,-1,
    -1,-1,6113,2291, -2,-2,6109,6111,

    -1,-1,-1,-1, -2,-1,-1,-2,
    4007,-1,6114,-1, -2,-1,-1,-1,
    -2,-2,-2,-1, -1,-1,-1,-1,
    -1,-1,6118,6115, -2,-2,-1,-1
};

static long uni_h_6b[256] = {
    -1,-1,11761,-2, 4583,6116,-2,-2,
    -1,-2,6062,-1, -1,-1,-1,-2,
    -2,-2,6119,-1, -1,-1,6120,-2,
    -1,-1,-1,-2, -1,1721,-2,6122,

    2371,2801,-1,2253, -2,-1,-1,1804,
    -2,-1,-1,-2, -2,-1,-1,-2,
    -1,-1,4563,-1, -1,-2,-2,6124,
    6123,6126,2129,-2, -1,2254,2030,-2,
/* 40-7f */
    -1,-1,-1,6129, -1,-1,-2,6128,
    -1,6130,-2,-1, 1846,-2,3523,-1,
    6131,-1,-2,2031, 6133,-1,-2,-1,
    -2,6132,-1,6134, -1,-2,-1,6135,

    -2,6136,2763,3221, 2601,-1,4180,-2,
    -1,4266,4736,-2, -1,-1,-2,2785,
    -2,-1,-1,2648, 4682,-2,-1,-1,
    6137,6138,-1,2764, -1,-2,11801,6139,
/* 80-bf */
    6140,-1,-2,6142, 6141,-2,4356,-1,
    -1,2962,2876,2736, -1,6143,-1,-1,
    -1,-1,-1,-1, -1,6145,3103,-2,
    6144,-1,-1,-2, -1,-1,6146,-2,

    -2,-1,-2,-2, 6147,-1,-1,-1,
    -2,-2,6148,6149, -2,-2,-2,6150,
    -2,6152,6151,6153, 1805,3542,-1,6154,
    -2,-2,2706,1944, 6155,-2,-2,3734,
/* c0-ff */
    5244,-1,-1,-2, -2,2103,6156,-1,
    -1,-2,-1,6157, -2,4276,4372,-1,
    -1,-1,3839,6158, 4070,-1,-2,-1,
    4091,-1,-2,4451, -1,-1,-1,6159,

    -1,-2,-1,-2, -1,-1,-2,-2,
    -1,-1,-1,6161, 6160,-1,-2,6163,
    -1,-2,-1,6162, -1,-1,-1,-2,
    -1,-2,-1,-1, -1,-1,-1,-2
};

static long uni_h_6c[256] = {
    -1,-1,11835,-1, -2,-2,-1,-1,
    6165,-2,-1,-1, -1,-2,-2,2765,
    -2,4417,-2,6166, 6167,-1,-1,2104,
    -1,-2,-1,6168, -1,-1,-1,-2,

    -1,-1,-1,6170, 6169,-1,-2,-2,
    -2,-1,-1,-1, -2,-1,-2,-1,
    -1,-1,-1,-2, 3169,11851,-2,4125,
    1742,-1,-2,-2, -1,-1,4037,-2,
/* 40-7f */
    3685,2933,2165,-1, -1,-1,-1,-1,
    -1,-1,-2,-2, -1,-2,4038,-2,
    2814,-1,-2,-1, -2,6172,-1,2032,
    -1,-2,1788,-2, -2,3882,6171,2530,

    3551,-1,6173,-1, -1,-1,-1,11922,
    6181,-1,6174,11865, -1,-2,-1,-2,
    3433,-1,2166,6182, -2,-1,-2,-1,
    -2,-2,2372,-2, -1,2105,6180,-1,
/* 80-bf */
    -1,6178,6175,4564, -1,-2,-2,-2,
    3632,-2,-1,-1, 3857,6176,-1,-1,
    6184,-1,6183,2303, -2,-2,1813,-2,
    -2,2627,6177,6179, -2,-1,-1,-2,

    -1,4355,3484,-1, -1,-1,-1,-1,
    -1,-1,-1,4387, -1,-1,6192,-1,
    -2,6193,-2,1847, -2,-1,-1,-1,
    4208,4493,6201,2803, 3034,6188,6194,1772,
/* c0-ff */
    -1,2223,-2,-1, 6185,6190,-2,-1,
    -1,3284,3981,-1, 4071,-2,-1,-2,
    -2,-2,-2,6187, -2,4301,-2,6189,
    -1,6204,11901,6202, -2,6191,-1,-1,

    -2,4302,3940,2167, -1,3705,-1,-2,
    3577,-2,6205,-2, -2,-1,-2,6203,
    3457,6186,-2,1743, -2,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1
};

static long uni_h_6d[256] = {
    -1,-1,-1,-1, 11911,-1,-1,-2,
    -1,-1,-2,4546, 6216,-1,-2,-2,
    -1,-2,6215,-2, -1,-1,-1,3286,
    -1,6212,-2,4576, -1,-1,3822,6206,

    -1,-1,-1,-1, -1,3637,-2,-2,
    -2,1744,2531,6209, -1,-1,11923,-2,
    -1,-2,2907,6214, -1,6213,6208,-1,
    6211,-2,-1,1972, -2,6210,3941,-2,
/* 40-7f */
    -1,4614,-1,-1, 3084,3285,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-2,
    -1,6222,6220,-1, 4145,-1,-2,-2,

    -1,-2,-1,6217, 6219,-2,1726,-2,
    -1,2532,4718,-1, 1929,-1,4166,-2,
    -2,-1,-1,-1, 4565,-1,-1,1904,
    3127,6221,-1,-1, -2,-1,-1,-1,
/* 80-bf */
    -1,-1,-2,-1, -1,6226,-1,-2,
    3035,-1,-1,-1, 4516,-1,6223,-1,
    -1,-2,-2,6218, -2,6224,-2,-2,
    -2,4662,-1,3783, 3834,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-2,-1, -2,-1,-1,1922,
    -1,-1,1753,-1, -2,6230,-1,-2,
    6233,11950,-1,-1, 4635,-2,-1,-2,
/* c0-ff */
    4568,-1,-1,-1, -2,6240,6234,6231,
    -2,-1,-2,4652, 6237,-1,-2,-2,
    -1,2942,6239,-1, -1,6244,-2,-1,
    3781,6242,-1,-2, -1,-2,6236,-2,

    -2,3524,-2,-1, 6243,-2,6232,-1,
    6238,-2,6245,1692, 6235,-1,6246,-2,
    -2,3128,-1,2963, -2,4205,-2,2614,
    -1,6227,6241,3726, -2,-1,-1,-1
};

static long uni_h_6e[256] = {
    11971,-1,-1,-1, -2,3222,-1,1973,
    2649,3036,6229,2934, -1,-1,-1,-1,
    -1,-1,-1,2344, -1,6228,-1,-1,
    -1,6250,2977,2426, -1,6265,-2,6259,

    2184,3747,-2,6254, 6263,1615,1718,-2,
    -1,1825,-1,6256, 3412,6247,6249,2533,
    -1,-1,-2,-1, -1,-1,-2,-1,
    6266,-2,6261,-2, -2,-1,6253,-1,
/* 40-7f */
    -1,-1,-1,6260, -2,-2,-1,-1,
    -2,-2,4411,-2, -1,6258,6262,-2,
    -1,-2,-2,-2, -2,-1,2448,-2,
    3037,-1,-1,3525, -2,-2,-2,6252,

    -1,-1,12001,-2, -1,-1,-1,4515,
    -2,-1,-1,6255, -1,-1,6248,3782,
    -1,-1,6251,-2, -1,-1,6257,-1,
    -1,-1,-1,-2, -1,-2,4749,2830,
/* 80-bf */
    4394,-1,6267,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, 4014,-2,-1,6279,
    2427,-1,-1,-2, -1,-1,2964,-1,
    6269,-2,-1,-1, 4615,2534,-1,6282,

    -2,-1,1678,-1, -1,6280,-1,-2,
    -1,-1,6268,-1, -1,-2,-2,6274,
    -1,-2,6276,-2, -1,-1,4547,6271,
    -1,-1,3714,-2, -1,6273,-1,-2,
/* c0-ff */
    -2,-2,6281,-2, 6275,4439,-1,-2,
    -2,6270,-2,2802, 6294,-2,-2,-2,
    -1,1974,-1,6272, 6277,6278,-1,-1,
    -1,-1,-1,-1, -1,3476,3458,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-2, 6286,-2,-2,6292,
    -1,-1,6290,-1, 3709,-1,-1,6303,
    6287,-2,-1,-2, -1,-2,6288,6264
};

static long uni_h_6f[256] = {
    -1,2189,4126,-1, 12033,-1,2831,-1,
    -2,2587,-2,-1, -2,-2,-1,4719,
    -1,6284,-1,6302, 1773,3370,-2,-1,
    -2,-1,-2,-2, -1,-1,-1,-1,

    3989,-1,2033,4690, -1,-1,-2,-1,
    -1,-2,-2,4401, 3650,12051,-1,12045,
    -2,6291,6293,-2, -1,-1,-2,-1,
    3318,-1,-1,-2, -2,-1,6301,6289,
/* 40-7f */
    -1,6283,-1,-1, -1,2035,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,12052,
    -1,-2,-2,-2, 2373,-1,-1,-2,
    6315,-2,-2,6310, 3288,-2,-2,1967,

    -1,-2,-2,-1, 2965,-1,6319,-1,
    -2,-1,-1,-1, -2,6312,3612,6309,
    3657,-1,-1,-1, 6344,-1,-1,-1,
    6306,-1,6305,-1, 6314,-2,-2,-1,
/* 80-bf */
    6308,6307,6313,-2, 3201,-1,6304,-2,
    -2,-1,-1,-2, -2,-2,6316,-1,
    -2,6317,-2,-2, -2,-1,-2,2034,
    -1,-1,-2,-1, -1,-1,-1,-2,

    -2,6322,-1,6321, 6323,-2,-2,-2,
    -2,-1,6326,-1, -1,-1,-2,-2,
    -2,3735,-1,6320, -1,-2,-2,-1,
    -1,6324,-1,-1, -2,-1,-1,-1,
/* c0-ff */
    2367,3489,6318,3927, -1,-2,6325,-2,
    -2,-1,-2,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, 6330,6328,-1,-1,
    6331,-1,12101,6334, -1,-1,-2,6327,

    2574,3908,-1,-1, 6225,-1,-1,-1,
    -2,-2,-1,4584, 6329,-1,6333,3485,
    -2,6332,-1,6311, -1,-2,7973,-1,
    -1,-2,6337,-1, -2,-2,6341,-1
};

static long uni_h_70[256] = {
    12110,6339,-1,-1, -1,-2,-2,-2,
    -1,6335,-1,6336, -1,-2,-1,6340,
    -1,6338,-1,-1, -1,4146,-1,-2,
    6346,-1,6343,6342, -1,6345,3852,6347,

    -2,-1,-1,-2, -1,-1,3585,3477,
    -1,-1,-1,-1, 3205,-1,-1,-2,
    6348,-1,6350,-1, -2,-1,-1,-2,
    -1,-2,-1,-1, -2,-1,6349,-1,
/* 40-7f */
    -1,-1,-1,-2, -2,-1,-1,-1,
    -2,-2,-2,-2, 6285,-1,12133,-1,
    -1,6351,-1,-1, 12129,-2,-1,-1,
    3871,-1,-1,-1, -1,-2,-2,-1,

    -1,-1,-1,6352, 12134,-2,-1,-1,
    -1,-1,-1,1848, -2,-1,-2,3784,
    1905,-1,-1,-1, -1,-2,-2,-1,
    2168,-1,-1,-1, 2862,2650,-2,-1,
/* 80-bf */
    -1,-2,-1,-1, -1,-2,-2,-1,
    -1,4707,3170,-1, -1,-1,1774,-1,
    -1,-1,6354,-1, -2,-2,-2,-2,
    -2,6353,-1,-2, -1,-1,-1,-1,

    -1,-1,-1,-1, 12150,-1,-1,-1,
    -1,-1,-1,-2, 6357,3526,6360,6355,
    -2,-2,-1,6359, -2,-1,-1,-2,
    6358,3732,1657,-1, -1,-1,-1,-1,
/* c0-ff */
    -1,-1,-1,-1, -1,-1,-1,-1,
    4685,-1,-2,6362, -1,-1,-1,1708,
    -1,-2,-1,-2, -2,-2,-2,-1,
    -2,6364,-1,-1, -2,6363,-1,6361,

    -1,-1,-1,-1, -2,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,6356,-1,-1, -1,-1,-1,-1,
    -1,4303,-2,-1, -1,6366,-1,-1
};

static long uni_h_71[256] = {
    -1,-1,-1,12166, -2,-2,-2,-2,
    -1,6365,-1,-2, -2,-1,-1,-2,
    -1,-1,-1,-1, 1775,-1,-1,-1,
    -1,6368,4218,-1, 6367,-1,-2,-1,

    -2,4421,-1,-1, -1,-1,3039,-1,
    -1,-1,-1,-2, -1,-2,-1,-2,
    -2,-2,-1,-1, -1,-1,3319,-1,
    -2,-1,-1,-1, 3038,-1,-1,-1,
/* 40-7f */
    -1,-2,-1,-1, -1,-2,-2,-2,
    -1,4691,-2,-2, 6374,-1,3289,-1,
    -2,-1,-2,-1, -1,6370,6375,-2,
    -1,1776,-2,-1, -2,-1,-2,-1,

    -2,-1,6373,-1, 3965,6369,6372,3040,
    12201,4049,-1,-1, 6376,-1,2849,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-2,-1,-1, -1,3290,-1,-1,
/* 80-bf */
    -2,-1,-1,-1, 6379,-2,-1,-2,
    6371,-1,2307,-1, -2,-1,-1,6377,
    -1,-1,-2,-1, 4548,6380,-1,-1,
    -1,8406,-2,-2, -1,-1,-1,2947,

    -2,-1,-2,-1, -1,-1,-1,-1,
    6381,-1,-1,-1, 6382,-1,-1,-2,
    -2,3914,-2,-2, -1,-1,-1,-1,
    -1,6384,-2,-1, -1,-1,6385,-2,
/* c0-ff */
    -2,-2,-1,3919, -2,-1,-1,-1,
    3785,6387,-1,-2, -2,-1,6389,-1,
    4653,-1,6386,-2, 6388,1777,-2,6383,
    -1,-2,-2,-1, -2,-1,-1,5159,

    6390,-1,-1,-1, -1,3371,2724,6392,
    -1,-1,-1,-1, 6391,3104,5057,-1,
    -1,-1,-1,-1, -1,6393,-1,-1,
    -2,6401,-1,6378, 6394,-1,-2,6402
};

static long uni_h_72[256] = {
    12230,-1,-1,-1, -1,-1,3990,-2,
    -2,-2,-1,-1, -1,6403,-1,-1,
    6404,-1,-1,-2, -1,-1,-1,-2,
    -1,-1,-2,6405, -1,-2,-1,-2,

    -1,-1,-1,-1, -2,-1,-1,-1,
    6406,-1,3662,-2, 6408,6407,-1,-2,
    6409,-1,6410,-1, -2,2863,4167,-1,
    -2,-2,4476,6411, 6412,3354,2804,6413,
/* 40-7f */
    6414,-2,-2,-2, -1,-2,6415,4250,
    4039,-1,-1,6416, 3955,-1,-2,-2,
    -2,-1,3613,-2, -1,-2,-2,-1,
    6417,1871,12255,2177, -2,4438,-2,4422,

    -2,1820,4720,-2, -1,-1,-1,4350,
    -2,4210,-1,-2, -1,-1,-2,-2,
    -1,-2,3223,-1, 6418,-1,-1,-2,
    -2,3835,-1,-2, -2,2403,6419,-2,
/* 80-bf */
    2652,6421,6420,-1, -2,-1,-1,6422,
    -1,-2,-1,-1, -1,-2,-2,-1,
    -1,-1,6423,-2, -1,-1,6424,-1,
    -1,-1,-1,-2, -1,-1,-1,-1,

    2130,-1,6425,-1, -1,-1,-1,6426,
    -2,-1,-1,-1, 2404,-2,-2,4040,
    -1,-2,6428,-1, -2,-1,3085,-1,
    -1,6427,-1,-1, -1,-1,-2,-1,
/* c0-ff */
    -1,-2,2224,6429, 6431,-1,6430,-2,
    -1,-2,-1,-1, -2,-1,6432,-1,
    2449,-1,6433,-1, -1,-2,-2,2273,
    -2,3332,-1,2593, -1,-1,-1,-2,

    6435,6436,6434,-1, -1,-2,-1,-1,
    -1,2877,-1,-1, 3840,2225,-1,-1,
    -1,-1,-1,-2, -2,-1,-1,6438,
    3512,6437,-2,-2, 4721,3966,12301,-1
};

static long uni_h_73[256] = {
    -1,-1,-2,-1, -2,-2,-1,-2,
    -1,-1,6441,-2, -1,-2,-1,-1,
    -1,-1,-2,-2, -1,-1,6443,6440,
    -2,-2,-1,4452, 6442,6444,-2,4636,

    -1,-1,-2,-1, -2,6448,-1,-2,
    -2,6447,3586,3913, -2,-1,2405,6446,
    -1,-2,-2,-1, 6445,-2,4517,4518,
    -1,-1,-2,-2, -1,-2,6449,1778,
/* 40-7f */
    -1,-1,-1,-2, 2586,2766,-1,-1,
    -1,-1,-1,-1, -1,-2,6450,6451,
    -2,-1,-2,-1, -1,-1,-2,6453,
    -2,-1,-1,-1, -1,-2,-2,-2,

    12333,-1,-1,2935, -1,-1,-2,-2,
    6455,-2,6454,-2, -2,-1,-2,-2,
    6456,-2,1945,-1, -1,6458,-1,-2,
    6457,-2,6460,6459, -2,-1,-1,-1,
/* 80-bf */
    -2,-2,-1,-2, 2428,-2,-2,4608,
    -1,2244,-1,1806, -1,-1,-2,-1,
    12351,-1,-1,-2, -1,-2,2274,-2,
    -2,-1,-1,-1, -2,-1,-2,-2,

    -2,-1,-2,-1, -1,-2,-2,-1,
    -1,2065,-2,-2, -1,-2,-1,-1,
    -1,-1,4672,6462, -1,-2,-1,-2,
    -1,-2,-1,6464, -2,-2,-1,-2,
/* c0-ff */
    6465,-1,1849,-1, -1,-2,-2,-1,
    6461,-2,2725,-2, -2,3633,6463,-2,
    -1,-1,-2,-2, -1,-1,-2,-1,
    -1,-2,-1,-1, -1,-2,6468,-1,

    2878,-2,-1,-2, -1,6466,-2,-2,
    -1,-2,2330,-1, -1,4041,6467,-1,
    -1,6494,-1,-1, -2,-2,-1,-2,
    6473,-2,-2,-2, -1,-2,2429,12401
};

static long uni_h_74[256] = {
    -2,-2,-1,2169, -2,6470,4593,-2,
    -1,4616,-2,-1, -1,-1,-1,-1,
    -1,-2,-1,-1, -1,-1,-1,-1,
    -1,-1,-2,-2, -1,-1,-1,-1,

    -1,-1,3486,-1, -2,6472,-2,-1,
    -2,-2,-2,-2, -2,-2,-2,-2,
    -2,-2,6474,4654, 2255,4092,3942,-1,
    -1,-2,6475,-1, -1,-1,-1,6477,
/* 40-7f */
    -2,6480,-1,-2, -2,-1,-2,-2,
    -1,-1,-1,-2, -1,-2,-1,-1,
    -1,-2,-2,-1, -1,6476,-1,-2,
    -1,6479,2474,1745, 6481,-2,3180,6478,

    4660,-1,-2,6484, 8404,-1,-2,-2,
    -2,6482,6485,-2, -1,-2,-2,6471,
    6483,-2,-2,2628, -1,-1,6486,-1,
    -1,-1,-1,-1, -1,-1,6487,-1,
/* 80-bf */
    -2,-2,-1,4594, -1,-2,-2,-2,
    -1,-2,-1,6488, -1,-1,-1,-2,
    12450,-2,-2,-1, -1,-1,-1,-1,
    -2,-2,-2,-1, -2,-1,6489,-2,

    -2,-2,6469,-2, -1,-1,-2,6490,
    -2,-2,-2,-2, -1,-1,-2,-2,
    2036,-2,-2,-1, -1,-2,-1,-1,
    -1,-2,-1,-2, -1,2805,-1,-2,
/* c0-ff */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -2,-2,6491,-1, -2,-1,-1,6492,
    -2,-1,-1,-2, 6493,-1,-1,-1,
    -2,-1,-2,-2, 1727,-1,-2,-2,

    6501,-1,4127,6502, -2,-1,2004,6503,
    -2,6504,-2,-2, -1,-1,6505,-2,
    6507,6508,6506,-1, -2,-1,4151,6510,
    6509,-1,-2,-2, -2,-1,-1,-2
};

static long uni_h_75[256] = {
    -1,-1,-1,6512, 6511,6513,-2,-1,
    -1,-1,-1,-1, 6514,6516,6515,-1,
    -1,2589,12501,6518, -1,6517,-2,-2,
    2037,-1,3151,-1, 3728,-1,6519,3224,

    -2,-2,-1,2726, -2,1789,6520,-2,
    4549,-2,-2,4267, 6521,-1,-1,-2,
    3736,4519,2535,3129, -1,-1,-2,3543,
    5020,-2,3614,1872, 6522,-2,-2,-2,
/* 40-7f */
    -2,-1,-1,-2, 6523,-1,6528,-2,
    -2,6526,6525,5834, 1906,6524,-2,1658,
    -2,4010,-2,-1, 4042,-1,-1,-2,
    -1,4617,6529,6527, 3560,3206,-2,-2,

    4011,-2,4113,-1, 6531,4612,2345,6532,
    -1,6530,4054,6533, -1,6534,-1,-2,
    1659,-2,-1,3086, 6539,-1,6536,3877,
    6535,-2,-2,-2, -2,-2,-2,2106,
/* 80-bf */
    -1,-2,6542,-1, -1,-2,6537,6538,
    -1,6541,6540,4105, -1,-1,3334,3333,
    -2,2131,-2,-2, 6543,-2,-1,-1,
    -1,-2,6544,-1, -2,6545,-1,-1,

    -1,-1,-2,6547, -2,6546,-1,-1,
    -1,-1,-1,1754, -1,-1,-1,-1,
    -1,6555,4072,6549, -2,6551,-1,-1,
    6553,3130,-2,-1, 6554,6552,2832,-2,
/* c0-ff */
    -2,-2,6548,6550, -2,4134,-2,3041,
    -1,-1,6557,-1, 12552,6556,-2,-2,
    -1,-1,6558,-1, 2806,2615,-1,-2,
    3787,6559,-1,3643, -2,-1,6561,-2,

    -2,-2,4601,6560, -2,-1,-1,-2,
    -1,3373,-1,-1, -2,-1,-2,-2,
    6566,-2,6568,6569, 3552,-1,-1,-1,
    -1,-2,6567,-1, 6564,-1,6562,6563
};

static long uni_h_76[256] = {
    12567,6565,-2,-2, -2,-1,-1,-2,
    -2,6572,-2,6570, -2,6571,-1,-2,
    -1,-1,-2,-2, -1,-2,-2,-1,
    -1,-2,-1,-2, -2,-2,-2,6573,

    6575,6576,6577,-2, 6578,-2,-2,6574,
    -1,-2,-1,-1, -1,-2,-1,-1,
    6580,-1,-2,-2, 6579,-2,-1,-1,
    -2,-2,12601,6581, -2,-1,-1,-1,
/* 40-7f */
    12604,-2,4637,-2, -2,-2,6584,6582,
    6583,-2,12603,12610, 2066,-1,-1,-1,
    -1,-1,4494,-1, -1,-2,4242,-1,
    6586,-2,-1,-1, 6585,-1,-1,-2,

    -1,6587,6588,-1, -2,-2,-1,6592,
    6589,6590,6591,-1, 6593,-2,-2,-2,
    6594,-2,6601,-1, -2,-1,6602,-1,
    6603,-1,4015,3748, 6604,3982,4120,-1,
/* 80-bf */
    6605,-2,-1,6606, 3710,-2,1907,2536,
    6607,-1,-1,6608, -2,-2,6609,-1,
    2709,-1,-1,6611, -1,-2,6610,-1,
    -1,6612,6613,-2, -2,-2,-1,-2,

    -2,-1,-2,-2, -2,-2,-2,-2,
    -2,-1,-2,-1, -1,-2,4073,-1,
    6614,-1,-1,-1, 6615,-1,-1,8373,
    6616,6617,6618,-1, -1,-2,-1,2714,
/* c0-ff */
    -1,-2,6619,3954, -1,-2,4363,-1,
    1746,-2,1755,-2, -2,6620,-2,-1,
    -1,-1,6622,-1, -2,-1,6621,3780,
    -1,-2,-1,3225, 6125,-1,6623,4433,

    -2,6624,-1,2038, 4055,6625,-2,6626,
    -2,-1,6627,-1, -2,-1,4460,-1,
    12653,-2,4453,-1, 3630,-1,-2,-1,
    3374,-2,-1,6629, -2,-1,2966,-1
};

static long uni_h_77[256] = {
    12658,3042,-1,-1, 6632,-1,-2,6631,
    6630,4093,-2,2039, 2409,-1,-2,-1,
    -1,-1,-2,-1, -2,-2,-1,-2,
    -1,-2,-2,6638, -2,-1,6635,3131,

    4418,-1,-2,-1, 6634,6636,6637,-1,
    -2,6633,-1,-1, -1,-2,-2,-2,
    -1,-1,-1,-1, -2,-2,-2,6639,
    6640,-2,3615,-1, 2067,-2,-2,-1,
/* 40-7f */
    3569,-1,-2,-1, -1,-2,-2,6641,
    -1,-1,-2,-1, -1,-2,-2,-2,
    -1,-1,-2,-1, -1,-1,-2,-2,
    -1,-1,6642,6645, -2,-1,-2,-2,

    -2,3171,-2,3836, 12701,6646,4351,-2,
    6643,-1,-2,6644, -2,-1,-1,-1,
    -2,-1,-2,-2, -2,-1,-1,-1,
    -1,6649,-2,-1, -1,-2,6648,6647,
/* 80-bf */
    -2,-1,-1,-1, -2,-1,-1,-1,
    -1,-1,-1,6651, -2,-2,6650,-1,
    -1,6652,-1,-1, -2,-2,-2,-1,
    -1,-1,-2,-1, -1,-1,6654,-2,

    6653,-1,12720,-1, -1,4245,-1,-2,
    -1,-1,-2,-1, 2954,4638,-2,-2,
    6655,-2,-1,3823, -1,-2,6656,-1,
    -1,6657,-1,6661, 6659,6660,-2,6658,
/* c0-ff */
    -1,-1,-1,-2, -1,-1,-1,6662,
    -1,-2,-1,-1, -1,6663,-1,-1,
    -1,-2,-2,-1, -1,-2,-1,6664,
    -1,-2,6665,4423, 6666,-1,-2,-2,

    -2,-1,4480,6667, -2,3546,-2,3974,
    -1,2275,-2,-1, -2,3527,6668,2226,
    -2,-2,-1,3248, -2,-1,-1,-1,
    -2,-1,-1,-2, 6669,-1,-1,-1
};

static long uni_h_78[256] = {
    -1,-1,2629,-1, -1,12746,-2,-1,
    -1,-2,-1,-1, 6670,-2,-2,-1,
    -1,-2,6671,-1, 2406,2653,-1,-1,
    -1,-1,-1,-1, -1,-2,-1,-1,

    6673,-2,-2,-2, -1,3754,2654,2146,
    -1,-1,-1,-1, -1,-2,-2,-1,
    -2,-1,4304,-1, 3943,-2,-1,-2,
    -1,-1,3755,-1, -1,-1,-1,2560,
/* 40-7f */
    -1,-1,-1,-2, -2,6675,-1,-2,
    -2,-1,-1,-1, -2,-1,-2,-1,
    -1,-1,-2,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -2,3043,-2,-1,

    -2,-2,-1,-2, -2,-1,-1,-1,
    -2,-1,-2,4618, 2537,-1,-2,2407,
    -1,-1,4003,-1, 6677,-1,-1,-1,
    -1,-1,-2,-1, 6679,-1,-2,-1,
/* 80-bf */
    -1,2475,-1,-1, -1,-1,6678,3686,
    -1,-1,-2,-1, 6681,1923,6676,-2,
    -1,4074,-1,1716, -2,2676,-1,4750,
    -2,-1,6680,-1, -1,12784,-2,-2,

    -1,12783,-1,6682, 12787,-1,-1,4243,
    -2,3257,6684,-1, -2,-2,-1,6685,
    -2,-2,-2,-2, -1,6683,-1,-1,
    -1,-1,1946,12801, 6691,-2,6690,-2,
/* c0-ff */
    -1,2807,-1,-1, -1,6692,6687,-2,
    -2,-2,6693,6688, -2,-1,-2,-1,
    4056,6686,-2,-2, 6689,-2,-2,-1,
    -1,-1,6702,12814, -1,-1,-1,-2,

    -2,-2,-1,-1, 12813,-1,12818,6701,
    4365,-1,-2,-1, 6694,-1,-1,1675,
    -1,-1,-2,-2, 6704,-1,12823,-2,
    -1,-1,-2,-2, -1,6703,-1,-2
};

static long uni_h_79[256] = {
    12822,3044,-1,-1, -1,-1,12828,6705,
    -1,-1,-1,-1, -2,-1,3335,-1,
    -2,6707,6706,-1, -1,-1,-1,-1,
    -1,6708,-2,-1, -2,-1,-2,-2,

    -2,-1,-1,-1, -1,-2,6672,-2,
    -1,-2,6674,6710, 6709,-2,-1,-1,
    -1,-2,-1,-1, -2,-2,-1,-1,
    -1,-1,2808,-2, 4673,-2,2850,-2,
/* 40-7f */
    6711,2323,-1,-1, -2,-2,-2,2132,
    2107,2767,-2,12850, -1,-1,-1,-2,
    4520,-2,-1,6717, -2,6716,3336,6713,
    -2,-1,6715,-2, -2,2943,3132,6714,

    6712,-1,3910,-1, -1,3045,-1,-2,
    4128,-2,-1,-2, -1,2655,-1,-1,
    -1,-1,-2,-1, -1,-1,-1,3788,
    -1,-2,6718,-2, -2,-1,-2,6719,
/* 80-bf */
    6741,2256,-1,-1, 4729,3321,-1,-1,
    -1,-1,6720,-2, -2,1850,3687,4201,
    -1,-2,-1,-2, -2,-2,-2,-1,
    -2,-1,-1,-2, -2,6721,-1,-1,

    -1,-2,-1,-1, -1,-1,2190,6722,
    -2,-2,6724,-2, -1,-1,6725,-2,
    3909,-2,-1,6726, -2,-1,-1,-1,
    -2,6727,6728,-2, -1,2257,1851,3837,
/* c0-ff */
    2908,2768,-2,-1, -2,-1,-1,-2,
    -2,6729,-2,2909, -1,-1,-1,-2,
    -1,1842,4135,-1, -2,6730,-2,-1,
    4075,-1,-2,-1, -1,-2,-2,3337,

    12901,6733,-2,6734, 3973,-2,3133,6731,
    -1,3565,-2,-2, 6732,-2,-1,-1,
    3046,-2,-1,-1, -1,-1,-1,-1,
    -2,-1,-1,1660, -2,-1,-1,-1
};

static long uni_h_7a[256] = {
    2109,-1,12910,-2, -1,-1,-1,-2,
    6735,-2,-2,3688, -2,6736,3239,-1,
    -1,-2,-1,-1, 4413,-2,-1,4103,
    6737,6738,3553,-2, 4639,-1,-2,6740,

    6739,-2,-1,-1, -1,-1,-1,-2,
    -1,-1,-1,-2, -1,-2,2879,-2,
    -2,6742,1680,-1, -2,-2,-1,6745,
    -2,-2,-2,6743, 1852,2346,6744,2538,
/* 40-7f */
    2582,-1,4270,6746, -2,-2,4352,-2,
    -2,6748,-1,-1, -2,3249,1747,1826,
    1612,-1,-1,-1, -1,-2,-2,6747,
    -1,-2,-1,-1, -2,-2,-1,-2,

    -2,6749,6750,3087, -1,-2,-1,-2,
    -1,6751,-2,1947, -1,-2,-1,-1,
    6753,-1,-1,-1, 2374,-2,2170,-1,
    -2,6754,2285,-1, -1,6755,-2,3292,
/* 80-bf */
    12950,3845,-2,3264, 2685,-2,-2,-1,
    6756,-1,-2,-2, -1,-1,-1,-1,
    -2,-2,3566,3375, -2,6758,6760,6757,
    6759,-1,-1,-1, -1,-1,-2,2302,

    -2,-1,-1,-2, -1,-1,-1,-1,
    -1,6761,2306,-1, -2,-1,2171,4550,
    6763,-1,-1,-2, -1,-2,6764,-1,
    -1,-2,1714,-2, -2,-1,-1,6767,
/* c0-ff */
    -1,-1,-1,1986, 6766,6765,-2,6769,
    6762,-2,6770,4609, -2,6771,-2,6772,
    -1,-2,5284,6774, -1,6773,-1,-1,
    -1,6775,6776,-2, 4621,6777,-1,8079,

    3047,6778,6779,2955, -1,3824,6780,-1,
    -2,-2,3508,-2, -2,6781,-1,3528,
    6782,-2,-1,-1, -2,-1,2205,-1,
    4931,3561,2819,-2, -1,-2,-2,2040
};

static long uni_h_7b[256] = {
    -1,-1,6783,-1, 6802,-1,6786,12983,
    2172,-1,6785,6804, -1,-1,-1,6784,
    -1,3048,-1,-1, -2,-1,-1,-1,
    6788,6789,-1,3711, -1,-1,6790,-2,

    1962,-1,-1,-2, -1,3158,4168,-2,
    6792,-2,-2,-2, 3472,-2,-2,-2,
    -2,13001,-1,6787, -2,6791,6793,-1,
    -1,2691,-1,-1, -1,-2,-1,-2,
/* 40-7f */
    -2,-2,-1,-1, -1,6806,4114,-2,
    4006,3789,-1,2258, 6805,6803,-2,4021,
    6794,3562,3791,-1, 3790,-2,2686,-1,
    -1,-1,-1,-1, -1,6824,-1,-1,

    -2,-1,-1,-1, -2,6808,-2,6810,
    -1,-2,-2,-1, 6813,-2,6814,-2,
    6811,6812,-2,-2, 6809,6807,-1,-2,
    -1,-1,6801,-1, -1,-1,-1,-1,
/* 80-bf */
    -1,-1,-1,-1, -2,-1,4247,1853,
    -1,-2,-1,6821, -1,6818,-2,6823,
    -2,-2,6822,-1, 3983,4407,-2,2727,
    6816,6825,6820,-2, 6819,6815,-2,6817,

    -2,2041,-1,-1, -1,-2,-1,-1,
    -1,-1,3529,-1, -2,3293,-1,-2,
    -2,4002,-2,-1, 6830,-2,-2,-1,
    4004,-1,-2,-2, -2,-2,-1,-1,
/* c0-ff */
    3265,6827,-2,-1, 4047,-2,6831,4251,
    -2,3559,-2,6826, 6828,-1,-1,6829,
    -1,-1,-1,-1, -2,-1,-2,-2,
    -1,-2,-2,-2, -1,6832,-1,-1,

    2836,-1,-1,-1, 3838,6837,6836,-1,
    13050,6833,-2,-1, -1,4722,-1,-1,
    -1,-1,-2,6842, -2,-2,6846,6843,
    -2,-2,-2,-1, -2,-1,-2,-1
};

static long uni_h_7c[256] = {
    6839,13060,-2,-2, -2,-1,-2,6840,
    -1,-2,-1,-2, -2,6845,-2,-2,
    -1,6834,5053,6841, 6835,-1,-1,6844,
    -1,-2,-1,-2, -1,-1,-1,6850,

    -2,2042,-1,6847, -1,-2,-2,6848,
    -2,-1,6849,6852, -2,-1,-1,-1,
    -1,-2,-1,-2, -2,-1,-2,6851,
    4086,-2,-2,-1, -1,6853,4692,4277,
/* 40-7f */
    6858,-1,-1,6855, -1,-1,-2,-1,
    -1,-1,-2,-1, 6854,3250,-1,6857,
    6859,13086,-2,-2, 6856,13085,6863,-1,
    6860,13089,-2,-2, -2,-2,-2,6861,

    6838,13101,-1,-2, 6862,6864,-1,-2,
    -1,-2,-1,-1, 6865,-2,-2,-1,
    -2,-1,-2,4238, -1,6866,-1,-1,
    -1,-2,-1,-1, -2,-2,4466,-1,
/* 80-bf */
    -1,2246,2309,6867, -1,-1,-2,-2,
    -1,4220,-1,3172, -1,4416,-1,-2,
    6868,-1,4619,-1, -2,3984,-1,3338,
    3920,-1,-1,2945, -1,-1,-2,1632,

    -2,6873,6871,-1, 6869,2001,-2,3049,
    6874,-1,-1,6872, -1,6870,6878,-1,
    -2,6877,6876,6875, -1,-1,-2,-2,
    -1,6879,-2,-2, -2,6880,3226,-2,
/* c0-ff */
    6881,-1,6883,-1, -2,6882,-1,-2,
    -2,-2,2450,-1, -1,-2,3324,-2,
    -1,-1,6885,-2, -2,-2,3792,-2,
    6884,-2,-2,-1, 6886,-2,4221,3376,

    2539,-1,6887,-1, -1,-1,-2,4640,
    -1,-2,-1,-2, -1,-1,-1,6889,
    -1,-1,6890,-1, 6891,-2,6892,-1,
    2769,-1,6893,2347, -1,-1,2174,-1
};

static long uni_h_7d[256] = {
    2110,-1,6901,13143, 4483,2540,6894,-2,
    13145,-2,6904,4470, -1,3928,-1,-2,
    4119,-2,-2,-2, 2967,6903,-2,2851,
    2541,2770,2173,4222, 6902,-2,-2,-1,

    3339,4334,2687,-2, -1,-1,-2,-1,
    -1,-1,-2,2771, 3661,-2,6907,4663,
    2657,13158,6908,3134, -1,6910,-1,-1,
    -1,3050,2616,-1, -2,-2,-2,6909,
/* 40-7f */
    -2,-2,2910,2430, 3340,6905,6911,-2,
    -2,-1,-1,6906, 2348,-2,6914,6918,
    2375,-2,-1,-2, -1,-1,6913,-2,
    -1,-2,-2,6922, -2,-2,2542,-1,

    -1,4577,1628,6919, -1,-2,2175,-2,
    6916,-1,-2,-1, -1,-1,6917,-1,
    -2,3793,6915,6912, -1,1908,3268,-1,
    -2,2408,-2,-2, -1,6924,-1,-2,
/* 80-bf */
    -1,-2,-2,-2, -1,-2,-2,-1,
    -2,6921,-1,-2, -2,-2,-1,6923,
    -1,-2,-1,6920, -1,-1,-2,-2,
    -1,2349,3419,6925, 3378,-2,13201,6938,

    -1,-1,6934,6928, -1,-1,-2,-2,
    -1,-1,-2,6932, 2890,1661,6927,6935,
    6939,2543,4454,-2, 3654,6929,-2,-2,
    6937,-2,6926,3530, -1,6931,1629,4442,
/* c0-ff */
    -1,-1,-2,-2, -2,-2,-2,6930,
    -1,-1,2259,4076, -2,-2,-2,3377,
    -1,4648,2979,-1, -1,6978,-1,-2,
    6940,-2,3294,-1, 6936,6941,6943,-1,

    3689,6946,13220,-1, 6942,-2,-2,-1,
    4252,2043,-2,-2, 4443,-2,-1,1662,
    -1,-2,6945,-1, 4693,-2,-2,-1,
    -1,-2,-2,6944, -1,-1,-1,-1
};

static long uni_h_7e[256] = {
    13219,1779,-1,-1, 3876,6947,-1,-1,
    13231,6954,6948,6955, -1,-1,-1,-1,
    -2,-2,6951,-1, -1,-2,-1,-2,
    -1,-1,-1,3991, -2,-2,2842,6953,

    -2,6950,6956,6949, -1,-1,2936,-2,
    -2,-1,-1,4305, -2,-2,2944,-2,
    -1,6952,6964,-2, -1,6960,-2,6963,
    -1,6961,6965,6959, -1,6933,3251,-2,
/* 40-7f */
    -1,4043,-1,6962, -2,-2,6957,-2,
    -1,-1,3301,2350, -1,2911,13250,-1,
    -2,-1,-2,-1, 3105,3322,6968,-1,
    -2,6970,6971,-1, -1,6967,6969,-2,

    -1,-2,-2,-1, -1,-2,6958,6966,
    -1,6974,6973,-2, -1,4390,-2,-2,
    2311,-1,-1,-2, -1,-1,-1,-1,
    -2,6972,-1,6976, 6975,6979,-2,6981,
/* 80-bf */
    -1,-2,2728,6977, -1,-1,-2,-2,
    6982,6983,-2,-1, 6984,-2,6990,3727,
    6986,-2,6985,6987, 6988,-2,6989,-1,
    -2,-1,-2,6991, 6992,-2,-2,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* c0-ff */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1
};

static long uni_h_7f[256] = {
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,2044,-1,
    6993,-1,6994,13276, 13275,13277,-2,-2,
/* 40-7f */
    -1,-1,-1,-2, -2,7001,-1,-2,
    -1,-1,-1,-1, 7002,7003,7004,-2,
    7005,7006,-2,-2, 7008,7007,-1,-1,
    7009,-1,-1,-2, -2,-2,-1,7010,

    7011,-2,-1,-2, -2,-2,-2,7014,
    7012,7013,2665,2351, -1,-2,3554,-1,
    4019,13301,2980,-1, -1,3945,-1,4077,
    7015,5677,-1,-1, -1,-2,-2,-2,
/* 80-bf */
    -2,-1,7016,7018, -1,4569,7017,7020,
    7019,-1,4551,-2, 7021,-2,4094,-2,
    -2,-2,-1,-1, 7022,-1,-2,-2,
    -1,-1,7025,-1, -2,7024,7023,-1,

    -1,-2,-2,7026, 2318,-1,-2,-1,
    3302,2133,-2,-1, -1,-2,7030,7027,
    -1,-1,7028,-1, -2,-1,7031,-1,
    7032,7029,-1,-1, -2,1709,-1,-2,
/* c0-ff */
    -2,1807,-1,-2, -1,7034,7035,-1,
    -2,-1,7036,-1, 4566,-1,-2,-2,
    -1,-1,2912,-1, 7038,7037,-1,-1,
    -1,-1,-1,-2, -1,-1,-1,-2,

    3173,7039,-1,-2, -1,-2,7040,-1,
    -2,7041,-1,2069, -2,-1,-2,-2,
    2045,-1,13335,7042, -1,-1,-1,-1,
    -1,7043,-2,4361, 4567,-2,-2,-2
};

static long uni_h_80[256] = {
    4552,4723,-1,2545, 7046,2852,7045,13340,
    -2,-1,-2,7047, 2809,-2,-2,-2,
    3449,-2,7048,-2, -2,2544,-2,4455,
    7049,7050,-1,-1, 7051,-2,-2,-2,

    -2,7052,-1,-1, -2,-1,-2,-1,
    7053,-1,-1,-1, -2,-1,-2,-1,
    -2,-1,-1,2810, -2,-2,4477,-2,
    -1,-2,-2,7055, -2,3531,-2,7054,
/* 40-7f */
    -2,-1,-1,-1, -2,-1,7057,-1,
    -1,-1,7056,-1, -1,-1,-1,-1,
    -1,-1,7058,-1, -1,-1,3227,-1,
    7059,-1,7060,-1, -1,-1,4225,7061,

    -2,3379,7062,-1, -2,-1,-2,-1,
    7063,-1,-1,-1, -1,-2,-1,4694,
    7066,-2,7065,7064, 3616,-2,7067,3106,
    -1,7068,-1,-1, -1,7069,4724,7070,
/* 80-bf */
    -1,-2,-1,-1, 7071,7073,7072,4005,
    -2,3889,-1,4730, 4009,-1,-2,-1,
    -1,-1,-1,7075, -1,-1,3051,-1,
    4110,-1,7076,7074, -2,2046,-2,-1,

    -1,2452,2772,-1, -1,4078,-2,-2,
    -1,2410,4335,13381, 7079,7077,-1,2546,
    -1,2547,1673,-1, 2672,-1,-1,-1,
    -2,-2,3957,-1, -1,-1,-1,-1,
/* c0-ff */
    -1,-1,-1,1663, 7084,-1,3532,-1,
    -2,-1,-1,-1, 3956,-2,3459,-2,
    -1,-1,-2,-1, -2,-2,7086,-2,
    -2,7082,7085,7080, -1,7083,4306,-1,

    -2,2453,-1,-1, 1693,7081,-1,-1,
    -1,-1,-1,-1, -1,-2,-2,7088,
    13401,7089,-2,-2, 3825,-1,-2,-1,
    2227,-2,-2,-1, 7106,3929,-2,-1
};

static long uni_h_81[256] = {
    -1,-1,2773,13408, -1,2228,3240,4738,
    4414,7087,3252,-2, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-2,-2,
    -2,-1,2151,7090, -2,-1,-2,-1,

    -2,-1,-1,7092, -2,-1,-1,-2,
    -1,7091,-1,-1, -2,-1,-1,7093,
    -2,3506,-1,3930, -1,-2,-1,-1,
    -1,3617,-2,-1, -2,-1,7103,-1,
/* 40-7f */
    -1,-1,-1,-1, -1,-2,7102,-2,
    -1,-1,-2,7094, -2,-1,3153,-1,
    4169,7105,-2,7104, 2548,4751,-1,-2,
    -1,-1,-1,-1, -1,-1,-1,7121,

    -2,-2,-1,-1, -1,7109,7110,-2,
    -2,-2,-1,2880, -1,-2,7108,-2,
    2588,7107,-1,-1, 7111,-1,-1,-2,
    3618,4202,3303,-1, -1,-1,-1,3460,
/* 80-bf */
    7115,-2,7116,7112, 13439,-2,-2,-1,
    7113,-1,7114,-2, -1,-1,-2,2549,
    13438,-1,-1,7122, -1,7118,13444,-1,
    -2,-1,4170,-2, 4376,4108,-2,-1,

    7117,-1,-2,7120, 7119,-1,-1,-1,
    4336,7123,-1,-1, -1,-1,-2,-1,
    7124,-1,-2,3323, -2,7125,-1,-1,
    7127,-1,7131,-2, -1,7128,7126,3931,
/* c0-ff */
    7129,-1,7130,13454, -1,-2,1818,-1,
    7137,7132,-2,13453, -1,7133,13457,-2,
    -1,7134,-1,3401, -1,-2,-1,-2,
    7136,7135,7138,-2, -1,-2,-2,7139,

    7140,-2,-1,3135, -2,1873,-1,7141,
    4655,-1,2811,-2, -2,2913,-1,-1,
    13468,-2,-2,2774, 3555,-2,-2,-1,
    -2,-2,7142,7143, 1717,-2,7144,-2
};

static long uni_h_82[256] = {
    13477,7145,7146,-2, -1,7147,-1,7148,
    2229,5810,7149,-1, 3269,7150,2843,-2,
    7151,-1,4816,-2, -2,-1,7152,4262,
    2060,-2,-2,3304, 2956,-2,4181,2914,

    -1,-2,-2,-1, -1,-1,-1,-1,
    -2,7153,2550,7154, 4044,-1,7168,-1,
    -1,-1,-2,7156, -2,3441,3985,2431,
    7155,3305,-2,-1, -1,-1,-1,-1,
/* 40-7f */
    7157,-1,-1,-2, -2,-2,-2,3690,
    -1,-1,-1,13501, -1,-1,-2,-2,
    -1,-2,-1,-1, -1,-1,-2,-1,
    7159,7158,7161,-1, -2,7160,-1,7162,

    -2,-1,7164,-2, 7163,-1,2047,-2,
    7165,-1,7166,7167, -1,-2,2617,4641,
    -1,7169,3107,-1, -2,-1,1780,7170,
    7171,-1,-1,-2, -1,-2,7172,-2,
/* 80-bf */
    -2,-2,-1,-2, -2,-1,-1,-2,
    -1,-2,-2,1682, -1,7173,-2,-1,
    -1,-2,7174,-1, -2,-1,-2,-1,
    -2,4171,-2,-2, -1,2839,-1,7176,

    -2,-2,-1,-2, -2,1909,1618,-2,
    -2,-2,-2,7175, 7178,3946,-2,3136,
    -2,1854,-2,4307, -2,-1,-1,-2,
    2361,2260,-2,7177, -2,1874,-2,-2,
/* c0-ff */
    -1,-1,-1,-1, -1,2003,-2,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -2,1781,7182,4674, 3461,-2,-1,4136,
    -1,7194,-2,1855, 7192,-1,7190,7181,

    13550,7179,-2,7180, -2,2867,2276,3587,
    -2,-1,-2,3849, -1,-2,-1,-2,
    -1,1749,-1,7184, 7183,-1,-2,-2,
    -1,7189,7185,7188, -1,-2,-2,-1
};

static long uni_h_83[256] = {
    13561,-2,4448,7187, 1856,1993,7191,-2,
    -2,7193,-2,-2, -1,-1,2352,-1,
    -1,-1,-1,-1, -1,-1,7203,7212,
    7213,-1,-1,13568, 1611,-2,-2,-2,

    -1,-2,-2,7220, -1,-1,-1,-1,
    1681,-1,-1,7211, -2,-2,-2,7210,
    -2,7205,7204,-2, 7202,7201,3567,-2,
    3491,7207,-2,-1, -2,-2,-1,-1,
/* 40-7f */
    7206,-1,-2,-2, -2,7209,-1,-2,
    -1,3380,2353,-1, -1,-2,-2,1733,
    7208,-2,2551,13630, 13567,13590,-2,-2,
    3381,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -2,-1,-1,7226, -1,7227,-1,1857,
    -2,-1,-1,1814, 7224,13601,-1,-2,
/* 80-bf */
    -2,-1,-2,-1, -2,7214,-2,7222,
    -1,7229,7223,-1, -1,-2,7221,-1,
    -1,-1,-2,7186, -2,-2,7219,-1,
    -2,-2,7215,-2, -2,-2,2048,7217,

    7228,-1,7218,-1, -1,-1,-2,-2,
    7230,-2,7216,3992, -2,13644,-1,-1,
    -1,4573,-1,-1, -1,7225,-1,-1,
    -1,-1,-1,-1, -1,7247,13620,-2,
/* c0-ff */
    -2,7239,-1,-1, -1,3191,-1,-2,
    -1,-2,2138,-1, 2261,-1,7234,-2,
    -2,-2,-1,1859, -2,-1,3052,-1,
    7237,-1,-1,-1, 2658,-2,-1,3749,

    7242,-1,-1,-1, -1,-1,-1,-1,
    13631,4278,-2,7233, -1,-1,-1,1858,
    2454,4109,7243,-1, 7231,-1,-2,7240,
    -2,-2,-1,7250, -2,7235,-1,-1
};

static long uni_h_84[256] = {
    -1,13637,-1,7236, 3826,-1,-2,7241,
    -1,-1,-2,7238, 4308,7244,1664,-2,
    -1,-2,-1,7232, -1,13642,-1,-1,
    -1,-2,-1,-1, -1,-1,-1,-1,

    7246,-1,7245,-1, -1,-1,-1,-1,
    -1,3975,7252,-1, 7263,-1,-1,13645,
    -1,1994,-1,-1, -1,7266,-1,-1,
    7248,-2,-1,-1, 7253,4578,-1,-1,
/* 40-7f */
    -1,-1,-1,-1, -1,-2,7262,-2,
    -2,4553,13650,-1, -1,-2,4610,-2,
    -1,-2,-2,-1, -1,-1,-2,3588,
    -2,-2,-2,1975, -2,-1,-1,-1,

    -2,4182,7268,3801, -2,-2,1617,-2,
    -1,7261,-2,7257, 3382,7251,7259,7264,
    -2,3912,-1,-2, -2,1610,-2,7256,
    -2,7265,4188,-1, -2,-2,-1,-1,
/* 80-bf */
    -1,-2,7260,-1, 7255,-2,-1,-1,
    -1,-1,-1,3053, -1,-1,-1,-1,
    2915,-1,-2,-2, 2812,-2,-1,-1,
    -1,4456,-1,-1, 4139,-1,-2,7271,

    -1,7280,-1,-1, -1,-1,-2,-1,
    -2,-2,-2,-1, -1,7258,-1,-2,
    -1,-2,1987,-1, -2,-1,-1,-1,
    3088,7269,-2,7274, 3383,-2,-2,7270,
/* c0-ff */
    -2,7277,-2,-1, 3563,-1,7278,-2,
    -2,4554,7267,1924, -2,7273,-1,-2,
    7276,4412,-1,-2, -1,-1,7279,-1,
    -1,7272,7275,-1, 13701,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-2,
    -1,-1,-2,-1, 4309,-1,4701,-2,
    -2,-2,-2,-1, 7283,-1,-1,-2,
    -1,-1,13710,-2, 7290,-2,-1,7282
};

static long uni_h_85[256] = {
    2835,-1,13713,-2, -1,-1,7249,-2,
    -1,-1,-1,-1, -2,-1,-2,-1,
    -2,4246,-1,4402, 7289,7288,-1,7284,
    7285,-1,1722,-1, -2,-1,-2,7287,

    -1,7281,-2,-2, -2,-2,3653,-2,
    -1,-1,-2,-2, 7286,1694,-1,-2,
    -1,-1,13709,13729, -2,3402,-2,-1,
    -1,-1,-1,-1, -1,4235,-1,-2,
/* 40-7f */
    7291,7301,-1,4057, -1,-1,-2,-1,
    7294,3054,2841,7303, -1,-1,2230,-2,
    -2,-2,-2,-2, -1,7304,-2,4189,
    7293,-2,7254,-1, -2,-2,-2,-2,

    -2,-2,-2,7292, -2,-1,-1,-1,
    4747,3802,4183,-2, -1,7311,-1,13750,
    -1,-1,-1,-1, -1,-1,-1,7317,
    -1,-2,-2,-2, -1,-2,7318,-2,
/* 80-bf */
    7305,-2,-1,-1, 3986,-2,-2,7315,
    7307,-2,7309,-2, -2,-1,-1,-2,
    7319,7308,-1,-2, 7312,-1,-1,1782,
    -2,3869,-1,7313, 7316,-2,-1,-2,

    -2,-1,-2,-1, 7306,-2,3306,-2,
    7310,2707,3137,2316, 4484,13784,4489,2982,
    -1,-1,-1,-1, 13771,-1,-2,-2,
    -2,7323,7321,-1, -2,-2,-2,-2,
/* c0-ff */
    -1,4746,-2,-1, -1,-1,-1,-2,
    -1,7320,-2,-2, -1,4585,-2,7322,
    7324,-1,-1,-1, -1,7325,-1,-1,
    13785,-1,-2,-1, 7328,7326,-1,-2,

    -2,-1,-1,-1, 3803,7327,-2,-1,
    -2,4045,7314,-1, -1,-2,-1,-1,
    -1,-1,-1,-2, -1,-1,-2,2983,
    -1,7329,7334,3384, -2,-1,7333,13801
};

static long uni_h_86[256] = {
    13802,-1,7302,-1, -2,-2,7335,3341,
    -1,-1,7330,7332, -1,-2,-2,-1,
    -2,-2,-2,7331, -1,-1,6117,6102,
    -2,-2,7337,-2, -1,-1,-2,-1,

    -1,-2,7336,-1, -1,-1,-1,-2,
    -1,-2,-1,-1, -1,4586,-1,6628,
    7338,-1,-1,-1, -1,-1,-2,-1,
    -2,-1,-2,-1, -2,-2,-1,7339,
/* 40-7f */
    -2,10470,13823,-1, -1,-1,-2,-1,
    -1,-1,-1,-1, -1,7340,2455,-1,
    2152,-1,-2,-2, 7342,4961,-2,-2,
    -2,-2,2185,-1, 4626,-2,2283,7343,

    -2,-2,-2,-2, -2,-1,-1,7344,
    -1,-2,-1,3578, -2,-1,-1,-2,
    -1,7345,-1,-1, -1,-2,-2,-2,
    -1,3890,-2,1626, -1,-1,-1,-1,
/* 80-bf */
    -1,-1,-1,-1, -1,-1,-1,-1,
    13877,-1,1867,7350, 7351,13844,-1,-1,
    -1,-2,-1,7346, -1,2729,-2,-1,
    -2,-1,-2,-1, -2,-1,-1,-1,

    -1,-2,-1,7347, 3934,-1,-2,-2,
    -2,7348,7349,7359, -1,-2,-1,7353,
    7356,-2,-1,-2, -2,-2,7352,-2,
    -2,-2,-1,-1, -1,-1,-1,-2,
/* c0-ff */
    -2,-2,-1,-2, 7354,-2,7355,2856,
    -1,7357,-1,3533, -1,2354,1934,-1,
    -1,-2,-2,-1, 7360,-2,-1,-2,
    -1,1931,-2,7365, -2,-1,7361,7364,

    -2,-1,-1,-2, 4026,-2,-1,-2,
    -1,7362,-1,-1, 7363,4140,4058,7366,
    -1,-1,-1,-1, -1,-1,-1,-1,
    3493,7376,13878,7372, -2,-2,1875,-1
};

static long uni_h_87[256] = {
    7370,-1,4310,7371, 13881,-2,7368,-2,
    7369,7374,7377,-2, -1,7375,-2,-2,
    -2,7373,7367,-2, -2,-1,-1,-1,
    3556,-2,7384,-1, 4410,-1,-2,-2,

    -1,-2,-1,-2, -1,7382,-1,-1,
    13901,7383,-1,-1, -1,-1,-2,-2,
    -1,-2,-2,-1, 7378,-1,-1,7380,
    -1,-2,-2,7381, -2,-2,-2,7379,
/* 40-7f */
    -2,-1,-1,-2, -1,-2,-1,-1,
    -1,3270,-1,4725, 7388,-2,7389,-1,
    -1,-1,-1,7401, -1,3110,-1,7391,
    -2,7394,-1,-1, -1,-2,-1,7386,

    7385,-2,-1,7402, -2,-2,1860,-1,
    7392,-1,7403,-1, -1,-1,7393,-2,
    -1,-2,-2,-1, 7390,-1,3619,-1,
    7387,-1,-1,-2, -1,-1,-1,3972,
/* 80-bf */
    -1,-1,7407,-2, -2,-2,-2,-2,
    -2,-2,-1,-2, -2,4527,-1,-1,
    -2,-1,-1,-2, -1,-2,-1,-2,
    -2,-2,-1,-1, -1,-1,-2,7406,

    -2,-1,7405,-2, -1,-1,-1,-2,
    -1,-1,-1,7414, -2,-2,-2,7408,
    -1,-2,-1,7416, -1,-2,-1,-1,
    -1,-1,4570,7419, -1,7410,-2,-2,
/* c0-ff */
    7411,13950,-1,-1, 7415,-1,7418,7417,
    -2,-2,-2,7409, -1,-1,-2,-1,
    7412,-1,7429,-1, -1,-2,-2,-1,
    -1,-2,-2,-1, -2,-1,-1,-2,

    7422,-1,-2,-2, -2,-1,-1,-1,
    -1,-1,-2,-2, -1,-2,-1,7420,
    -1,-2,7421,-2, -1,-1,7426,7427,
    -2,1910,-2,2134, -1,-1,7425,-2
};

static long uni_h_88[256] = {
    -1,13972,-1,-2, -1,7404,-2,-1,
    -1,-2,-2,-2, -1,7424,7428,7423,
    -2,7430,13980,-2, -2,7432,7431,-1,
    -2,13979,13984,-2, -2,-1,-2,-2,

    -1,7434,7433,7358, -1,-1,-1,7438,
    -2,-1,-1,-1, -1,-2,-2,-1,
    -2,7435,-2,-1, -1,-2,7436,-1,
    -1,7437,14001,7439, -2,-1,-1,-1,
/* 40-7f */
    2376,-2,7441,-2, 7440,-2,2916,-1,
    -2,-2,-2,-2, 2552,6207,-2,-1,
    -1,-2,7442,2949, -1,-2,-2,1925,
    -2,7443,-2,1750, -2,3055,7444,-2,

    -2,2553,7445,1665, -2,-1,-1,-1,
    4129,-2,-1,7446, -1,-1,-1,-1,
    3174,-2,7453,-1, -1,7450,-1,3579,
    -1,-2,-1,-2, -1,7451,7448,2262,
/* 80-bf */
    -2,7447,7454,-1, -1,-1,-1,-1,
    2322,-1,-1,3462, -1,7460,-1,-1,
    -1,-1,7456,-1, -1,-1,3421,7455,
    -2,7458,-2,-2, -2,-1,7449,-2,

    -2,-1,7459,-1, 7461,-1,-1,-1,
    -2,-1,-2,4079, -1,-1,7457,-1,
    7462,7464,-1,-1, 2451,7452,-1,1633,
    -1,-1,-2,-1, -1,-2,-2,7463,
/* c0-ff */
    -2,2659,4686,7465, 7466,3385,-1,-1,
    -1,-1,-2,-2, -2,-2,-2,4602,
    -1,-2,-2,-2, 7467,4521,-1,-1,
    7468,7469,-1,-2, 4268,7470,-2,2632,

    -1,4603,-1,-1, -1,-1,-1,-2,
    7475,-1,-1,-1, -1,-1,-1,-2,
    -2,14050,7476,3056, 7474,-2,-1,-2,
    4571,7471,-1,-1, 7473,3229,3194,-1
};

static long uni_h_89[256] = {
    -1,-2,7472,-1, 7477,-1,-2,4203,
    -1,-1,7479,-1, 7478,-2,-2,-2,
    1976,-1,4311,7480, -1,-2,-2,-1,
    -2,-2,-2,-1, -2,7492,7482,-1,

    -2,-1,-1,-1, -1,7483,-2,-2,
    -2,-1,7484,7485, -1,-1,-1,-1,
    -2,-2,-2,-1, -1,-2,7489,-1,
    7490,-2,-2,7488, -1,-1,-2,-1,
/* 40-7f */
    -2,7486,-2,7481, 7487,-2,-2,-1,
    -1,-2,-1,-1, 7491,8023,-1,-2,
    -1,-1,-2,-1, -1,-1,1808,-2,
    -1,-1,-2,-2, -2,-1,7494,2263,

    7493,-2,-2,-2, 7502,-1,7501,-1,
    -1,-1,7504,-2, -1,7503,-2,7505,
    -2,-1,2917,-2, 7506,-2,-1,7507,
    -1,-1,-2,14101, -2,-2,7508,3230,
/* 80-bf */
    -1,4555,-1,7509, -1,-1,4204,3938,
    7510,-2,7511,2411, -1,-2,-1,2112,
    -2,-1,-1,7512, -2,-2,2775,3933,
    7513,-1,1948,-2, -2,-1,-1,-2,

    -2,7514,-1,-1, -1,-2,7516,4587,
    -1,7515,3138,-1, 7517,-1,-1,7518,
    -2,-1,7519,2049, -2,-2,-2,-2,
    -1,-1,7520,-1, -2,7521,-1,7522,
/* c0-ff */
    7523,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,1949,-1, -2,-2,-2,-2,
    -2,-1,7524,-1, 7525,7526,-1,-1,

    -1,-1,-1,1882, -1,-2,3108,7527,
    -1,-2,-1,-2, -1,-2,-1,-1,
    -1,-2,-1,-2, 7528,-1,-2,-1,
    7529,-2,-1,-1, -1,-2,-1,-2
};

static long uni_h_8a[256] = {
    2432,-1,3691,7530, 14135,-2,-1,-2,
    2355,-1,3154,-1, 7533,-1,3804,-2,
    7532,-2,-2,2317, -2,-2,7531,3487,
    2113,-1,-1,7534, -1,7535,-2,3057,

    -2,-1,-2,2377, -2,7536,-2,-1,
    -1,-1,4312,-2, -2,3263,-1,14150,
    -1,2186,-1,4485, 3342,-2,7537,-2,
    -1,-1,3139,3580, 3058,-2,-2,-1,
/* 40-7f */
    -2,7538,-1,-2, -1,-2,7541,-2,
    7542,-2,-1,-1, -1,-2,-2,-1,
    2630,3434,7540,-2, 3059,4130,-2,-2,
    -2,-1,-1,7539, -2,-2,2776,-1,

    1751,-2,7546,2356, -1,-2,2778,-2,
    -1,2777,-1,4745, 7545,7544,3307,-1,
    2145,4735,1926,3060, -1,-2,-2,-2,
    -1,-2,-2,-2, 7543,-1,-2,-2,
/* 80-bf */
    -2,-1,7548,-2, 7549,7547,-2,2456,
    -1,4532,-1,-2, 2779,3907,-1,-2,
    -2,7552,-2,3232, -1,3534,-2,-2,
    4522,-2,7555,-1, -1,-1,2476,-2,

    3231,7551,-1,7556, 2477,7553,7554,-2,
    7550,-2,-1,-1, 3266,3841,-2,-2,
    3515,-1,1861,-2, -1,-1,14201,-2,
    -1,4080,-1,-2, 2135,-1,-2,3620,
/* c0-ff */
    -1,-1,7559,-2, 7557,-1,-2,3544,
    -2,-2,-2,3233, 2050,7558,-1,3159,
    -1,-2,4642,-2, -2,-2,4732,-2,
    -1,-1,7560,7571, 3621,-2,7570,-2,

    7567,7575,7568,-1, 7564,-1,3692,7563,
    -1,-1,-1,7561, -2,4501,2780,-1,
    -2,7565,-1,7562, -2,-2,-2,7569,
    2984,-1,2433,-1, -2,-1,3490,-2
};

static long uni_h_8b[256] = {
    4337,1758,1666,-1, 3805,-2,-2,7573,
    -1,-1,14231,14226, 7572,-1,3870,-1,
    7577,-2,-1,-1, 7566,-1,7576,7578,
    -1,2412,7574,2554, -2,2853,-2,-2,

    7579,4556,-1,-1, -1,-1,7582,-1,
    7585,-1,-1,7583, 4121,14232,-1,-1,
    -2,-1,-1,7580, -1,-1,-1,-2,
    -1,2264,-1,-1, -2,-1,7584,-1,
/* 40-7f */
    -1,7586,-2,-2, -2,-2,-2,-1,
    -2,7590,-1,-1, 7587,14246,7589,7588,
    -1,-1,14242,-2, -2,-1,7591,-1,
    2817,-2,7593,7592, 4172,-1,14247,7601,

    -1,-1,-1,-2, -1,-1,2357,-1,
    -1,-1,-1,7594, 7602,-2,-1,7603,
    2136,7033,3089,-1, 7604,-1,-2,2478,
    -2,-2,-1,-1, -2,7605,-2,-1,
/* 80-bf */
    7606,-2,-1,2730, -2,-2,-1,-1,
    -1,-1,5846,-2, 7607,-2,7608,-2,
    2918,-1,7609,7610, -2,-2,7611,-1,
    -1,7612,7613,-1, -2,-1,-2,-2,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* c0-ff */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1
};

static long uni_h_8c[256] = {
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,3511,
    14266,-2,7614,-1, -1,-2,-2,7616,
/* 40-7f */
    -1,7615,-1,-1, -1,-2,3806,-2,
    7617,-2,4313,-2, 7618,-1,7619,-2,
    7620,-2,-1,-2, -2,7621,-1,-2,
    -2,14282,3858,14280, -1,-2,-1,-1,

    -1,3061,7622,14283, -2,-1,-2,-1,
    -2,-2,2575,4814, 7623,-2,-1,-1,
    -1,-1,-1,-2, -1,-2,-2,-1,
    7624,4131,7625,-2, 7633,-1,-2,-1,
/* 80-bf */
    -1,-1,7626,-1, -1,7628,-2,14301,
    -1,7627,7629,-2, 4338,7630,7631,-1,
    -2,-1,-2,-2, 7632,-1,-1,-1,
    7634,-2,-1,-2, -2,1913,3671,-1,

    4173,2666,2555,-1, -2,-1,-1,4147,
    1863,4046,7637,2051, 3253,7636,7641,3589,
    4467,-1,7639,7640, 2114,-1,7642,3967,
    3463,-2,-2,4081, 3729,7638,-1,4339,
/* c0-ff */
    1876,7644,4708,3634, 4737,-2,-2,2781,
    7643,-2,3417,-2, -1,7660,3308,-2,
    -1,3888,-1,4148, -1,14318,14317,-1,
    -1,14319,7647,2731, 2782,-2,3062,-1,

    3969,-2,2413,7646, 7645,-1,4174,-1,
    -2,-1,2833,-1, -2,3750,-1,-2,
    -2,-1,-2,-1, -1,-2,-1,-2,
    -2,-1,7649,7650, 2556,7648,-2,-2
};

static long uni_h_8d[256] = {
    -1,14332,-1,-2, 7651,7652,-1,7654,
    3403,-2,7653,2070, -1,7656,-1,7655,
    7657,-1,-2,7659, 7661,-1,7662,-2,
    -1,-1,-1,-2, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* 40-7f */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, 3254,-2,2847,7663,
    -1,-2,-1,1950, -2,7664,-2,-1,
    3386,7665,-1,7666, 4175,-1,-1,2115,
    -1,-1,-1,-1, -1,-1,-1,-2,
/* 80-bf */
    -1,7667,-2,-1, -2,3622,-1,-1,
    -2,-1,1759,-1, -1,-2,-1,-1,
    -2,-2,-1,-1, -1,-2,-1,-1,
    -1,7668,-1,-1, -1,-1,-2,-2,

    14352,-1,-1,2881, -1,-1,-2,-1,
    3186,-1,-1,-2, -2,-1,-1,-2,
    -1,-1,-2,3413, -1,-2,-1,-2,
    -1,-2,7671,-2, 14379,-1,7670,-1,
/* c0-ff */
    14362,-1,7669,-1, -1,-2,-2,-2,
    -2,-1,-2,7677, 7675,-1,-2,7672,
    -1,-2,-1,-1, -2,-2,7674,-2,
    -1,-2,7673,7676, -1,2187,-1,7680,

    -1,3255,-1,7681, -2,-2,-1,-2,
    2457,-1,7678,7679, -2,-1,-1,4709,
    -2,14380,-2,3623, -2,3309,-1,-1,
    -1,-1,-1,-1, 7682,-2,-1,7685
};

static long uni_h_8e[256] = {
    -1,14384,-1,-1, -2,-2,-2,-1,
    7683,7684,4557,-2, -1,-1,-1,3807,
    7688,-2,-1,-1, -2,-1,-2,-1,
    -1,-1,-1,-1, -1,7686,7687,7689,

    -2,-2,-2,14401, -1,-1,-2,-2,
    -1,-1,7709,-1, -1,-1,-1,-1,
    7692,-2,-1,-2, 7693,7691,-2,-2,
    -2,-2,-1,-1, -1,-2,-1,-1,
/* 40-7f */
    -2,-2,7690,-1, 3693,-1,-1,7701,
    7705,7702,7694,-2, 7703,-2,-2,-2,
    7704,-1,-1,-1, -2,7711,-1,-1,
    -1,7706,-1,-2, -2,-2,-2,3256,

    7708,-2,-2,7710, 7707,-1,-1,-1,
    -1,-2,-1,-1, -2,-2,-1,-2,
    -2,-2,7713,-1, 2919,-1,7712,-1,
    -1,-2,-2,-2, 7714,-1,-1,-1,
/* 80-bf */
    -1,7715,-2,-2, 7718,7717,-1,7716,
    -1,-2,7720,7719, -1,4486,-1,-1,
    -2,7722,-2,7721, 7723,-2,-1,-1,
    -1,7724,-2,-2, -1,-2,-2,-1,

    -1,7726,-2,-1, -1,-1,-1,-2,
    -1,-2,7725,3140, 7727,-2,-2,2277,
    7728,7730,-1,-2, -1,-2,-1,-1,
    -1,-1,-2,-2, -1,-1,7731,-1,
/* c0-ff */
    14452,-2,-1,-2, -2,7732,7729,-2,
    7733,-1,2854,7734, 2116,2319,-1,-2,
    -1,-2,2414,-1, -2,-1,-1,-1,
    -1,-1,-1,7735, -2,-1,-1,3880,

    -1,-1,3730,7736, -1,-1,-1,-1,
    -2,-1,-1,7739, -1,14468,14462,-1,
    -2,-2,-1,-1, -1,-1,-1,-2,
    2820,-2,-2,7738, 7737,2358,7740,-1
};

static long uni_h_8f[256] = {
    14469,-1,-2,1951, -1,7742,-1,-2,
    -2,2660,7741,-1, 7750,-1,-1,-2,
    -2,-1,7744,7746, 4269,7743,-2,-2,
    -2,7745,-1,7749, 7747,2117,-2,7748,

    -2,-2,-1,-2, -1,-2,7751,-2,
    -2,3958,4656,-1, -2,-2,-2,2920,
    -1,-1,-1,7752, -2,-2,-2,-2,
    4502,7754,-2,7753, -1,-1,7757,4533,
/* 40-7f */
    -2,-2,7756,14501, 1977,7755,7760,-2,
    -1,7759,-1,-1, 7758,3718,7761,-2,
    -1,-2,-2,-2, -2,-2,-1,7762,
    -2,-1,-1,-1, 7763,-2,-2,2576,

    -1,2305,7764,7765, 7766,-2,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* 80-bf */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,3141, 7767,-2,2813,7768,

    -2,-2,-1,7769, -2,-2,-2,5001,
    4994,-1,-1,-1, -1,7770,6980,7771,
    3504,3111,3932,-1, -1,-2,-2,7772,
    -2,-1,4253,3652, 2594,-1,-2,3509,
/* c0-ff */
    -2,-2,1710,-1, 4388,3155,-2,-1,
    -1,-1,-2,-2, -1,-2,2362,-1,
    -2,2265,-2,-2, 4254,-2,-1,-1,
    -1,-1,7773,-1, -1,-1,-1,-1,

    -2,-1,7775,-2, -2,7774,1864,-1,
    -2,3886,7776,3987, -1,3719,-2,7777,
    2950,-2,-1,-1, 7779,-2,-2,4434,
    7794,7781,7782,-2, -1,3641,-2,-1
};

static long uni_h_90[256] = {
    3464,3387,14543,3808, -2,7780,2153,-1,
    -2,-1,-1,7789, -2,7786,7805,3809,
    3564,7783,-1,3694, 3751,7784,7788,3164,
    -2,3971,3644,-2, -1,3234,7787,3414,

    3404,7785,1609,4702, -1,-1,-1,7790,
    -2,-2,14552,-1, -2,-2,3465,14551,
    -1,2921,3142,14555, -2,7792,7791,-2,
    1679,7793,-1,-1, 4115,-1,7807,-2,
/* 40-7f */
    -1,3859,3175,-2, -2,3557,-1,2288,
    -1,7806,4523,1731, -2,4255,1865,7801,
    7802,7803,7804,3827, 3503,1667,7808,-1,
    7809,8403,-1,-2, 3429,-2,7810,-1,

    1783,3344,-2,2415, -1,4558,-2,-2,
    7811,3712,-1,-1, -2,3388,2855,7812,
    -2,-1,7815,-1, -2,2969,7813,3311,
    3310,-2,1668,-1, 4643,7817,-1,4082,
/* 80-bf */
    7819,7818,7816,6768, 2052,-2,-1,7778,
    -2,7821,7820,-2, -2,-1,-2,7822,
    -2,4524,-1,-1, -1,-2,-1,-2,
    -2,-2,-1,-2, -1,-1,-1,-1,

    -2,-2,-2,3865, -1,-2,4314,-1,
    7823,-1,2857,-1, -1,-1,-1,7824,
    -2,7825,-2,-2, -2,7826,-2,-1,
    3701,-1,-1,-1, -1,-2,14593,-1,
/* c0-ff */
    -1,1674,-1,-2, 14601,-2,-1,-2,
    -2,-1,2557,-1, 14592,-1,4726,-1,
    -1,-1,14613,-1, -1,14605,-1,-2,
    -2,-2,-1,7830, -2,-2,-1,-2,

    -1,2320,7827,-1, 7828,-2,-1,-1,
    4184,-1,-1,14615, -1,1952,-1,-2,
    -2,-1,-1,-1, -2,4525,14614,2231,
    -1,-1,-1,-1, -1,3752,14619,-2
};

static long uni_h_91[256] = {
    -2,-1,7831,-1, -2,-2,-2,-1,
    -2,-1,-1,-1, -1,-2,-1,-1,
    -2,-1,7832,-1, -2,-1,-2,-2,
    -2,7833,-2,-1, -2,-1,-2,-1,

    -2,-1,14637,-2, -1,14636,-1,14639,
    -1,-2,-1,-1, -1,3702,-2,-2,
    7835,-2,7834,-1, -2,-1,-2,-2,
    -1,-2,-2,-1, -2,-2,-1,-1,
/* 40-7f */
    -1,-1,-1,-2, -1,-1,-1,-2,
    -2,3851,7836,2922, 2864,3959,3581,-2,
    -1,-1,2882,-2, 3176,-1,7837,-2,
    7838,-2,-2,-2, -1,-1,-1,-1,

    -1,-2,3161,7839, -2,7840,-1,-2,
    -1,7841,4579,-1, 2923,-2,-1,-1,
    -1,-1,7843,7842, -2,2558,-1,2583,
    2732,-2,-2,-2, -1,-1,-1,-1,
/* 80-bf */
    -1,-2,7846,-2, -1,-2,-2,2970,
    -1,7845,-2,7844, -1,3473,-2,-1,
    2479,-2,3235,-2, -2,-2,-1,4016,
    -2,-1,-1,-1, 2925,-1,-2,-1,

    -1,-2,7847,-1, 3063,-1,-2,-1,
    -2,-1,7850,7848, -2,-2,-2,7849,
    -2,-2,-2,-2, 7852,7851,-2,-1,
    3090,-1,7853,-2, -2,-2,-1,-2,
/* c0-ff */
    7854,7855,14701,-2, -1,-2,4048,2651,
    2865,7856,-1,7857, 4604,2937,4478,4644,
    7858,2266,-1,-2, -2,-1,7859,-2,
    3703,-2,-2,7862, 1988,3143,-2,7860,

    -1,7861,-1,3664, -2,-2,4353,2292,
    -1,-2,-2,-1, -2,-2,-2,-2,
    -2,-2,-1,-1, -1,7864,7865,-2,
    -1,-2,-1,-2, 7863,-2,-1,7867
};

static long uni_h_92[256] = {
    14724,-2,-1,-1, -2,-2,-2,-2,
    -1,-2,-2,-1, -2,3863,1935,-1,
    -2,7871,-2,-2, 7868,7870,-2,-1,
    -2,-1,-1,-1, -2,-2,7866,-1,

    -1,-1,-1,-2, -2,-2,-2,-1,
    -2,7947,-1,-1, 7869,-1,-2,-2,
    -2,-1,-1,-2, 4675,-2,-2,2458,
    -2,-2,-2,-1, -2,-1,-2,7879,
/* 40-7f */
    -2,-1,-2,-2, 3720,7874,-2,-2,
    7877,7875,-2,7880, -1,-2,-2,-2,
    7881,-2,-1,-1, -1,-1,-1,7873,
    -2,-2,7886,1784, -2,-2,7872,-1,

    -2,-2,4013,-1, 7876,-2,3064,-2,
    -2,-2,-1,-1, -1,-1,-2,-2,
    -2,2559,-1,-1, -1,-2,-2,-2,
    -2,-2,-1,-2, -2,-2,4340,-2,
/* 80-bf */
    2268,-1,-1,2938, -1,3828,-1,-1,
    -2,-2,-2,-1, -1,-2,-2,-1,
    -1,3313,-2,7884, -1,7878,7883,-2,
    4435,14801,3624,7885, 7882,-1,-1,-2,

    -2,-1,-1,-1, -2,-2,-1,-2,
    -2,-1,-1,-2, -1,3312,-1,-2,
    -1,-1,-2,-1, -1,-1,-2,7889,
    -2,7888,-2,-2, -2,-2,-1,-2,
/* c0-ff */
    -2,-2,-2,-2, -1,-2,-2,-2,
    -2,-1,-1,-2, -2,-2,-2,7887,
    -2,-1,4315,-2, -1,-2,-1,-2,
    -2,-2,-1,-1, -2,-2,-1,-2,

    -2,-2,-1,-2, 2991,-2,-1,-2,
    -2,7890,4263,-1, -2,1752,-2,-1,
    -2,-1,4138,3582, -1,-1,-1,-1,
    2188,-2,7892,-2, 2561,-1,-1,-2
};

static long uni_h_93[256] = {
    14851,-1,-2,-1, -1,-1,2712,-1,
    -2,-1,-1,-1, -1,-2,-1,7891,
    3177,-2,-1,-1, -2,-2,-1,-1,
    3178,7901,7903,-1, -2,-2,-2,-2,

    3091,-2,7902,7904, -2,-2,2251,-2,
    4137,-2,-2,2866, 4703,-1,7894,2688,
    -1,-1,4731,-2, -2,7906,-2,-2,
    -1,-1,7905,7907, -1,-1,-1,-1,
/* 40-7f */
    -1,-1,-1,-1, 7893,-1,-1,-2,
    -2,-2,-1,3873, -1,3753,-1,-1,
    -2,-2,-2,-1, 3655,-2,7912,-2,
    -2,-1,-2,3535, 7908,-1,-2,-1,

    7909,-1,-1,-1, -2,-2,-1,-2,
    -1,-2,-2,-1, 2313,-2,7911,-2,
    -2,-2,-1,-2, -2,2416,-2,-1,
    -1,-1,14901,-1, 7910,-2,3065,-2,
/* 80-bf */
    -2,-2,-2,-1, -1,-1,-1,-1,
    -2,-1,-2,-2, 1989,-2,-1,-2,
    -1,-1,-2,-1, 7916,-2,2631,3389,
    -2,-1,3642,-2, -1,-1,-2,-1,

    -1,-2,-1,-2, -2,-1,-2,1927,
    -2,14927,-1,14922, 7914,7915,3635,-1,
    7913,-1,-1,-1, -2,-2,-2,-1,
    -1,7917,-2,-1, -1,-1,-1,-1,
/* c0-ff */
    -1,14928,-1,7923, -2,-2,-2,-2,
    7926,-2,-2,-2, -2,-2,-1,-1,
    7925,3713,-1,-2, -1,-1,7918,7919,
    7922,-2,-1,-1, -2,7924,-2,-2,

    -1,2232,-2,-1, 7927,7921,-2,-2,
    7920,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,14947,
    -2,14946,14949,-2, -1,-2,-1,-1
};

static long uni_h_94[256] = {
    -1,14952,-2,7931, -2,-1,-1,7932,
    -2,-2,-1,-1, -1,-2,-2,-2,
    7933,-1,-1,7930, 7929,-2,-2,-2,
    3066,3810,7928,-1, -1,-1,-1,-2,

    -1,7937,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,7935, -1,-1,-2,-2,
    -1,-2,-2,-2, -2,7936,7934,-1,
    3488,-1,7938,-2, -1,14972,-1,14971,
/* 40-7f */
    -1,7939,-1,14973, 7941,-2,-1,-1,
    -2,-1,-2,-1, -2,-1,-1,-1,
    -1,2053,7940,4490, -1,-2,-1,-1,
    -1,-2,7952,7942, -2,-1,7945,-2,

    7943,-2,7944,-2, -1,-1,-1,-1,
    -2,-1,7946,-2, -1,-2,-2,-2,
    7948,-2,-2,-1, -1,7949,-1,7950,
    -1,-1,-1,-1, 7953,7951,7954,7956,
/* 80-bf */
    -1,7955,-1,14992, 14991,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* c0-ff */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1
};

static long uni_h_95[256] = {
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* 40-7f */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,3625,
    14993,-2,-1,-1, -1,-1,15001,-1,
/* 80-bf */
    4471,-1,7957,3314, -2,-1,-1,7958,
    -2,4236,7959,1911, -2,-2,-2,1728,
    -1,2055,-1,2054, 7960,-1,7961,-1,
    7962,7963,-1,-1, -1,-2,-2,-2,

    7964,-2,2056,1953, 2562,4022,-2,7966,
    7965,-2,-1,-2, -2,7967,-1,-1,
    -1,-1,1760,-1, -2,-1,-2,-1,
    -1,7970,-2,7969, 7968,-2,7971,-2,
/* c0-ff */
    -1,-1,-1,7974, -1,-1,-2,1639,
    -2,-2,7972,-2, 7976,7975,-1,-1,
    -2,-2,-2,-2, 7978,7977,7979,-1,
    3814,-2,-2,-1, 7980,-2,-2,-2,

    -2,7981,7983,-1, -2,7982,-2,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1
};

static long uni_h_96[256] = {
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, 4176,-2,-2,-1,

    -1,7984,-2,-1, -2,-2,-2,-1,
    7985,-1,2669,-1, -2,-1,7986,7987,
    -1,-2,4341,-2, -1,-1,-1,-2,
    -2,-2,-2,3343, -2,-2,-1,1604,
/* 40-7f */
    3443,-2,7988,-1, 4177,-1,-1,-1,
    -1,-1,-1,7991, 7989,2563,-1,7990,
    2434,-1,-2,-1, -2,-1,-2,-2,
    -2,-1,-1,4237, 7993,8001,7994,8002,

    -1,-2,1701,3156, 2992,2057,8003,-1,
    -1,-1,3970,-1, 8005,-1,-2,-1,
    1702,-1,8004,3636, -2,4645,3811,7992,
    4606,-1,2417,-2, -2,4559,-2,-2,
/* 80-bf */
    -1,-2,-2,-2, -2,2289,4620,-1,
    2308,-2,3466,7101, -1,8006,1912,3179,
    -1,-2,-1,-1, 1954,8008,-2,8009,
    8007,2368,-2,2661, 3067,-2,-1,-2,

    1703,-1,-1,4657, -2,-2,-2,8011,
    7814,-2,8010,-1, -1,-1,-2,-2,
    8014,8012,8013,-2, 8015,-1,8016,4676,
    8017,8018,-2,3241, 4027,-1,-1,-1,
/* c0-ff */
    3193,2071,-1,-1, 4526,1877,2924,2459,
    -1,8021,-2,8020, 2783,8022,8019,-1,
    -1,2708,-2,-1, -1,8026,7413,-1,
    15085,5054,-2,3187, 8024,-2,-2,-2,

    -1,-1,4605,3881, -1,-1,-1,-1,
    1711,-2,3267,2822, -1,-1,-1,-2,
    4223,-2,1732,-1, -1,-1,4677,4575,
    -1,8027,-2,3737, -1,-1,-1,-1
};

static long uni_h_97[256] = {
    2891,-1,-2,15101, 8028,-2,8029,3144,
    8030,-2,4678,-1, -1,8025,8032,8034,
    -1,8033,-1,8031, -1,-1,8035,-1,
    -1,8036,-2,-2, 3390,-2,1866,-1,

    -1,-2,-2,-2, 8037,-1,-1,4424,
    -2,-1,8038,-1, -1,-1,-1,-1,
    8039,-2,4710,-2, -1,-1,-1,-1,
    5917,8040,-1,-1, -1,8041,8042,-1,
/* 40-7f */
    -1,-2,8046,-2, 8043,-1,8044,-1,
    8045,8047,-2,-1, -1,-1,-2,-2,
    -1,-1,3236,-1, -1,-2,4487,-2,
    -2,3237,-2,-2, 8048,-1,4083,-1,

    8049,8351,4444,-2, 8050,-1,8051,-2,
    8052,1955,-2,8054, -1,3157,-2,-1,
    -1,8055,-1,-2, 2304,-1,-2,-2,
    -2,8056,8060,-2, 8058,-2,-1,-2,
/* 80-bf */
    -2,8059,-1,-1, 1983,8057,8061,-1,
    -1,-2,-1,8062, -1,1640,-1,8063,
    8064,-1,-1,-1, -1,-2,-2,-2,
    3068,-2,-2,-1, 8065,-1,-2,-2,

    2139,-1,-2,8068, -1,-1,8067,-1,
    8066,-1,-1,7581, -2,4260,-2,-1,
    -1,-2,-2,8069, 8070,-2,-2,-1,
    -2,-2,-2,-1, -2,-1,-2,-2,
/* c0-ff */
    -1,-2,-1,8071, -2,-2,8072,-2,
    8073,-2,-2,8074, -2,-2,-2,-1,
    -2,-2,-1,2058, -2,-1,-1,-2,
    -2,-2,-1,15174, 8075,15171,-2,-1,

    -2,15175,-1,-1, -2,-1,-1,-1,
    -1,-1,-1,-1, -1,8076,3903,-2,
    -1,-2,8078,1827, -2,8081,8080,-2,
    -2,-1,-2,1704, -1,-1,-1,2233
};

static long uni_h_98[256] = {
    -1,4239,3626,2602, -1,2564,2971,15183,
    3160,-1,-2,-1, 8083,15186,-2,8082,
    4534,2072,4050,3860, -2,-1,-2,3192,
    4646,15185,2359,-1, 15190,-1,-2,-1,

    -2,8086,-1,-2, 8085,15208,15194,-1,
    -1,-1,-1,15201, 4343,3812,-2,-2,
    -2,-1,-2,-2, 1748,-2,-1,8087,
    8084,-1,-1,4149, 4574,8088,15209,-1,
/* 40-7f */
    -1,-1,-1,-1, -2,-1,8089,-2,
    -1,-1,-2,8091, 3474,1959,1960,8090,
    -1,-2,-2,-2, 2073,2418,-2,-2,
    2074,-2,-2,3731, -1,-1,4664,-1,

    -1,-1,-2,-2, -1,-2,-2,2460,
    -1,-1,-2,8092, -2,-1,-1,8093,
    8094,8101,-1,8103, 8102,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* 80-bf */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    4187,-1,8104,-2, -1,-2,-2,8105,
    -2,8106,-1,-1, -2,-1,8107,-2,
    -2,-1,-2,-2, -1,-1,-1,-2,
/* c0-ff */
    -1,-1,-2,8109, 8108,-2,8110,-1,
    -2,-1,-1,-1, -2,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,4084, 7044,-1,-1,3109,

    -1,-2,2118,-2, -1,-2,-2,-2,
    -1,8111,-2,8112, -1,5012,6127,4051,
    -1,-1,1691,-2, 1627,-1,-2,-1,
    -1,-1,-1,-1, 2784,4316,3094,-1
};

static long uni_h_99[256] = {
    -1,-1,-2,8113, -1,4463,-1,-2,
    -2,8114,4560,-1, 1734,-1,-1,-1,
    2733,-2,8115,1878, 8116,-2,-2,-2,
    8117,-1,-2,-2, -2,8119,8120,-2,

    8122,8118,-2,-1, 8121,-1,-2,-2,
    2059,-1,-1,-2, 8123,-1,8124,-1,
    -1,-2,-2,-2, -2,-2,-1,-1,
    -1,-2,-2,-2, -2,8125,8126,-1,
/* 40-7f */
    -2,-2,8127,-1, -1,8129,-2,-2,
    -2,8128,-1,8131, 8134,-2,-2,-1,
    8130,8132,8133,-1, -2,8135,-1,2234,
    -2,-2,-1,-2, -2,-1,-2,-2,

    -2,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* 80-bf */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,2883,8136,
    8137,2565,-1,-2, -1,-2,-1,-2,

    -1,-1,-1,-1, -1,8138,-2,-1,
    1930,-1,-1,-1, 3947,8139,8140,-1,
    -2,-2,-2,3558, 3875,-2,-1,-1,
    -1,15301,-2,-1, 8141,-2,-1,-2,
/* c0-ff */
    -1,3993,-1,-2, 3444,1756,2278,-1,
    2279,-2,-1,-1, -1,-1,-1,-1,
    3583,8146,2280,-2, -2,1879,-1,-1,
    8145,-2,-2,8143, -2,8144,-2,8142,

    -1,-1,8156,-1, -1,-1,-1,-2,
    -1,-1,-2,-2, -2,8147,8148,-1,
    -2,8149,8150,-1, -2,-2,-1,-1,
    8152,-2,-1,8151, -1,-2,-2,2957
};

static long uni_h_9a[256] = {
    -1,8153,-2,-2, -2,8155,-1,-1,
    -1,-1,-1,-2, -2,-1,2119,8154,
    -2,-2,3391,2419, -1,-1,-2,-1,
    -1,8157,-1,-1, -1,-1,-2,-1,

    -2,-1,-2,-2, -2,-1,-1,-2,
    3445,-1,-1,8158, -1,-2,-2,-1,
    3813,-1,-1,-2, -1,-2,-2,8159,
    -2,-1,-1,-1, -1,-1,8164,-1,
/* 40-7f */
    8162,15344,8161,8163, -2,8160,-1,15343,
    -1,-1,15346,-2, -2,8166,-2,-1,
    -1,-2,-1,-1, -2,8165,-2,8168,
    -1,-1,2235,8167, -1,-2,-1,8169,

    -1,-1,8170,-1, 8172,8171,-1,-1,
    -1,8173,8175,8174, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* 80-bf */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    2592,-1,-2,-1, -2,8176,-2,-2,
    8177,-1,-2,-1, -2,-2,-2,-1,
    1928,-2,-1,-2, 8178,-1,-2,-2,
/* c0-ff */
    8179,-2,-1,-2, 3181,-1,-2,-1,
    -2,-1,-1,-1, -1,-1,-2,8180,
    -2,8181,-2,8182, 8183,-2,-2,-2,
    2566,-1,-1,-2, -2,-1,8184,8185,

    -2,-1,8186,8187, -2,-2,8188,-2,
    -1,-2,4017,8190, -2,4106,8191,8189,
    -1,8193,-2,-2, 8192,-2,-1,8194,
    -1,-2,-2,8201, -1,-2,-1,-2
};

static long uni_h_9b[256] = {
    -2,-2,-2,-2, 15401,-2,8202,-1,
    -2,-2,-1,-2, -2,-2,-2,-1,
    -2,-1,-2,-1, -1,-1,-2,-1,
    8203,-2,8204,-2, -2,-1,-1,8205,

    -2,-1,8206,8207, -1,8208,-2,8209,
    8210,8211,8212,-2, -1,-2,8213,8214,
    -1,6121,8215,-2, -2,-2,-1,-2,
    -1,-2,-2,6888, 2120,-2,-1,-1,
/* 40-7f */
    -1,1901,2618,8217, 8216,4405,-1,-1,
    -2,-1,-1,-2, -2,8219,8220,8218,
    -1,8221,-1,-1, 4366,-2,-2,-2,
    8222,-1,2191,-2, -1,-1,-2,-1,

    -1,-2,-1,-2, -1,-2,-2,-1,
    -2,-1,-2,-2, -2,-2,-2,4705,
    -1,-1,-1,-2, 8223,-2,-1,-2,
    -2,-2,-1,-1, -1,-1,-1,-2,
/* 80-bf */
    -2,-1,-1,8225, -2,-2,-2,-2,
    -1,-2,-2,-2, -1,-2,1630,-2,
    -2,8226,4211,8224, -2,-1,8227,8228,
    -1,-1,-2,-1, -1,-2,-2,8229,

    8230,-1,-1,-1, -1,-1,-2,-2,
    8231,-2,4378,2713, -2,2690,3315,-1,
    -2,-2,-2,-1, 8232,-1,-1,-2,
    -2,8235,-1,-2, -2,-1,-2,-2,
/* c0-ff */
    8233,-2,-1,-1, -1,-1,8236,-2,
    -2,2481,8234,-1, -1,-1,-2,8237,
    -2,8238,8239,-1, 8243,-1,2710,-2,
    -2,-1,-1,3468, -1,-2,-1,-2,

    -1,8244,8241,8240, 8242,-2,-1,-2,
    2363,-1,-2,-2, -1,-1,-1,-2,
    8248,8247,8246,-2, -1,1619,-1,-2,
    -2,15501,-2,-1, -1,-2,-1,-2
};

static long uni_h_9c[256] = {
    15505,-1,-2,-1, 8258,-1,8254,-1,
    8255,8251,8257,-2, 8253,1966,-1,-2,
    4744,-2,8256,8252, 8250,8249,-2,-1,
    -2,-2,-2,8260, -2,-1,-2,-1,

    -1,8263,-2,-2, 8262,8261,-2,-2,
    -2,-2,-2,-1, -1,4141,8259,1683,
    8264,-2,8266,-1, -1,-2,-2,-2,
    -1,1979,8245,1723, -1,-2,8268,-1,
/* 40-7f */
    -1,-2,-1,-2, -2,-2,8267,8265,
    3513,-2,-2,-1, -1,-1,-2,-2,
    -2,-1,4380,-2, -2,-1,-2,4658,
    -2,-1,8269,-2, 15548,15542,-2,-2,

    8270,-1,-1,-2, -1,-1,-1,8271,
    15550,15546,-2,15549, -1,-1,15551,-1,
    -2,-1,-2,-1, -1,-2,8272,-2,
    8273,-1,-1,-2, -1,-1,-1,-1,
/* 80-bf */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* c0-ff */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,3627,-2,8274,
    -1,4023,-1,8279, 8275,-1,-1,-1,
    8276,-1,-2,4317, 4436,-1,3848,-2,
    -1,-2,-1,-1, -1,-1,-1,-1
};

static long uni_h_9d[256] = {
    -1,-1,15562,8280, -1,-1,8281,3830,
    8278,8277,-1,15561, -1,-1,1810,-1,
    -1,15563,8289,-1, -1,8288,-1,-2,
    -2,-1,-1,1785, -2,-2,-2,8286,

    -1,-1,-1,8285, -1,-1,8283,-1,
    1991,-1,8282,2818, 1809,-1,-1,-2,
    -2,-1,-2,-2, -2,-1,-1,-1,
    -1,-1,-2,2567, -2,15577,8292,8291,
/* 40-7f */
    -1,8290,-2,-2, 8287,15576,8293,15580,
    8294,-1,-2,-1, -1,-1,-1,-1,
    8305,8304,-1,-2, -2,-1,-1,-1,
    -1,8306,-1,-1, 1713,8301,8302,-2,

    2584,4425,15586,15585, 8303,15587,-1,-1,
    -1,-2,-2,-2, 4318,-1,-1,8311,
    -2,-1,8307,-1, -1,-1,-2,-2,
    -1,-1,8312,-2, 15601,-1,-2,-1,
/* 80-bf */
    -1,-1,-1,-2, -2,-1,-2,8309,
    -1,8308,-2,-1, -1,-2,-2,2360,
    -1,-1,-2,-2, -1,-2,-2,-2,
    -2,-1,8313,-1, -1,-1,-1,-1,

    -1,-2,-1,-1, 8314,-1,-1,-1,
    -1,8315,-2,8310, -2,-1,-2,8284,
    -1,-2,8316,-1, 3665,-2,-1,-1,
    8320,-2,8321,8319, -2,-1,-1,-2,
/* c0-ff */
    -1,8318,8324,-2, 8317,-1,8322,-2,
    -1,-2,-2,-1, -1,-1,-1,8323,
    -1,-1,-1,8326, -2,-2,-2,-2,
    -1,8325,-2,-1, -1,-1,-2,-2,

    -2,-1,-1,-1, -1,-2,8328,-2,
    -1,-2,-1,-2, -1,8329,-2,8330,
    -2,-1,4741,-2, -2,-1,-1,-1,
    8327,3475,2677,-1, -1,8331,-2,-1
};

static long uni_h_9e[256] = {
    -1,-1,15646,-1, -1,-1,-1,15647,
    -1,-1,15645,-1, -1,-1,15648,-1,
    15649,15650,15651,-1, -1,15652,15653,-1,
    -1,15654,8332,8333, 15655,15656,8334,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* 40-7f */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,8335,-1,-1,
    2420,8336,15657,15658, 15659,8337,-1,2815,
/* 80-bf */
    15660,8338,15661,15662, 15663,15664,-1,15665,
    8339,-1,-1,8340, 8341,-1,15666,-2,
    -1,8344,8342,4728, -1,8343,15668,4679,
    15669,-1,-1,15670, -1,8345,15671,4659,

    -1,-1,-1,-1, 15672,8346,3994,-1,
    15673,8347,8349,-1, 15674,8350,15675,15676,
    15677,-1,-1,15678, 15679,15680,-1,-1,
    8348,2577,4445,4367, 5487,-1,6164,4391,
/* c0-ff */
    -1,-1,-1,-1, 1811,-1,15681,-1,
    15682,-1,-1,15683, 8352,2148,8353,8354,
    8355,-1,2585,-1, 8356,15684,-1,-1,
    6452,4459,-1,3467, 8357,8359,8358,15685,

    8360,-1,-1,-1, 15686,8361,-1,15687,
    8362,-1,-1,-1, 15688,15689,15690,8363,
    15691,15692,15693,-1, 8364,15694,8365,8366,
    15701,8367,-1,8368, 8369,8370,-1,15702
};

static long uni_h_9f[256] = {
    -1,-1,15703,15704, -1,-1,-1,8371,
    8372,15705,-1,-1, -1,-1,3704,15706,
    15707,15708,15709,2461, 15710,8374,15711,15712,
    -1,15713,15714,15715, -1,-1,-1,15716,

    3345,8375,15717,-1, -1,-1,15718,-1,
    -1,-1,15719,15720, 8376,-1,-1,15721,
    -1,15722,-2,-1, 15724,-1,-1,15725,
    -1,15726,15727,4101, 15728,15729,8377,15730,
/* 40-7f */
    -1,15731,-1,15732, 15733,15734,15735,15736,
    -1,-1,8378,6723, -1,-1,7658,8077,
    -1,-1,8379,15737, 8380,15738,15739,15740,
    15741,-1,15742,-1, -1,15743,15744,8382,

    8383,8384,4680,8381, -1,-1,8385,8386,
    15745,15746,8388,-1, 8387,-2,-2,-2,
    -2,15751,8390,15752, -1,15753,8391,8389,
    -1,-1,15754,-1, -1,15755,-1,-1,
/* 80-bf */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,4622,-1,15756,
    15757,15758,15759,-1, 15760,8392,15761,15762,
    -1,-1,-1,-1, 8393,6752,15763,-1,

    8394,15764,15765,15766, -1,15767,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
/* c0-ff */
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,

    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1
};

/* --------------------------------------------------------------- */
/* JIS x0208 21xx -> ucs2					   */
static long uni_j_k21[93] = {
    0x3001,0x3002,0xff0c,0xff0e,0x30fb,0xff1a,0xff1b,0xff1f,
    0xff01,0x309b,0x309c,0x00b4,0xff40,0x00a8,0xff3e,0xffe3,
    0xff3f,0x30fd,0x30fe,0x309d,0x309e,0x3003,0x4edd,0x3005,
    0x3006,0x3007,0x30fc,0x2015,0x2010,0xff0f,0xff3c,0x301c,
    0x2016,0xff5c,0x2026,0x2025,0x2018,0x2019,0x201c,0x201d,
    0xff08,0xff09,0x3014,0x3015,0xff3b,0xff3d,0xff5b,0xff5d,
    0x3008,0x3009,0x300a,0x300b,0x300c,0x300d,0x300e,0x300f,
    0x3010,0x3011,0xff0b,0x2212,0x00b1,0x00d7,0x00f7,0xff1d,
    0x2260,0xff1c,0xff1e,0x2266,0x2267,0x221e,0x2234,0x2642,
    0x2640,0x00b0,0x2032,0x2033,0x2103,0xffe5,0xff04,0x00a2,
    0x00a3,0xff05,0xff03,0xff06,0xff0a,0xff20,0x00a7,0x2606,
    0x2605,0x25cb,0x25cf,0x25ce,0x25c7
};

static long uni_j_k22[94] = {
           0x25c6,0x25a1,0x25a0,0x25b3,0x25b2,0x25bd,0x25bc,
    0x203b,0x3012,0x2192,0x2190,0x2191,0x2193,0x3013,0,
    0,0,0,0,0,0,0,0,
    0x0000,0x0000,0x2208,0x220b,0x2286,0x2287,0x2282,0x2283,
    0x222a,0x2229,0,0,0,0,0,0,
    0x0000,0x0000,0x2227,0x2228,0x00ac,0x21d2,0x21d4,0x2200,
    0x2203,0,0,0,0,0,0,0,
    0x0000,0x0000,0x0000,0x0000,0x2220,0x22a5,0x2312,0x2202,
    0x2207,0x2261,0x2252,0x226a,0x226b,0x221a,0x223d,0x221d,
    0x2235,0x222b,0x222c,0,0,0,0,0,
    0x0000,0x0000,0x212b,0x2030,0x266f,0x266d,0x266a,0x2020,
    0x2021,0x00b6,0x0000,0x0000,0x0000,0x0000,0x25ef
};

/* --------------------------------------------------------------- */
unsigned short uni_k_brac[31] = {
	0x2121,0x2122,0x2123,0x2137,0x2138,0x2139,0x213a,0x213b,
	0x2152,0x2153,0x2154,0x2155,0x2156,0x2157,0x2158,0x2159,
	0x215a,0x215b,0x2229,0x222e,0x214c,0x214d,0x215a,0x215b,
	0x214c,0x214d,0x2150,0x2151,0x2141,0x2148,0x2149
};

/* --------------------------------------------------------------- */
/*
   diacretical mark:
      convert into non-spacing diacretical mark(as X0208) because
      ucs2 does not have complete set of spacing diacritical
      marks.
*/

static long uni_h_dianm[11] = {
    0x06,0x0c,0x27,0x07,0x0b,0x04,0x28,0x0a,0x03,0x84,0x85
};

static long uni_h_dianmx[11] = {
    0x2d8,0x2c7,0x0b0,0x2d9,0x2dd,0x2c9,0x2db,0x2da,0x2dc,0x384,0x385 
};

/* X-0212 additional symbols */
static long uni_h_xsign[4] = {
    0xba,0xaa,0xa9,0xae
};

/* additional greek characters */
static long uni_h_xgreek[24] = {
    0x86,0x88,0x89,0x8a,0xaa,0xd2,0x8c,0xd3,0x8e,0xab,0xd4,0x8f,
    0xac,0xad,0xae,0xaf,0xca,0x90,0xcc,0xc2,0xcd,0xcb,0xb0,0xce
};

/* additional roman characters */
static long uni_h_xrom[32] = {
    0x00c6,0x0110,0x00d0,0x0126,0x0186,0x0132,0x0198,0x0141,
    0x013f,0x019c,0x014a,0x00d8,0x0152,0x0181,0x0166,0x00de,
    0x00e6,0x0111,0x00f0,0x0127,0x0131,0x0133,0x0138,0x0142,
    0x0140,0x0149,0x014b,0x00f8,0x0153,0x00df,0x0167,0x00fe
};

static long uni_h_xrcap[87] = {
    0x00c1,0x00c0,0x00c4,0x00c2,0x0102,0x01cd,0x0100,0x0104,
    0x00c5,0x00c3,0x0106,0x0108,0x010c,0x00c7,0x010a,0x010e,
    0x00c9,0x00c8,0x00cb,0x00ca,0x011a,0x0116,0x0112,0x0118,
    0x01f4,0x011c,0x011e,0x0122,0x0120,0x0124,0x00cd,0x00cc,
    0x00cf,0x00ce,0x01cf,0x0130,0x012a,0x012e,0x0128,0x0134,
    0x0136,0x0139,0x013d,0x013b,0x0143,0x0147,0x0145,0x00d1,
    0x00d3,0x00d2,0x00d6,0x00d4,0x01d1,0x0150,0x014c,0x00d5,
    0x0154,0x0158,0x0156,0x015a,0x015c,0x0160,0x015e,0x0164,
    0x0162,0x00da,0x00d9,0x00dc,0x00db,0x016c,0x01d3,0x0170,
    0x016a,0x0172,0x016e,0x0168,0x01d7,0x01db,0x01d9,0x01d5,
    0x0174,0x00dd,0x0178,0x0176,0x0179,0x017d,0x017b
};

/* --------------------------------------------------------------- */
/* charts and forms						   */
/* --------------------------------------------------------------- */
int uni_jt_chart[32] = {
    0x00,0x02,0x0c,0x10,0x18,0x14,0x1c,0x2c,
    0x24,0x34,0x3c,0x01,0x03,0x0f,0x13,0x1b,
    0x17,0x23,0x33,0x2b,0x3b,0x4b,0x20,0x2f,
    0x28,0x37,0x3f,0x1d,0x30,0x25,0x38,0x42
};

long uni_h_chart[128] = {
    0x2821,0x282c,0x2822,0x282d,0x2821,0x282c,0x2822,0x282d,
    0x2821,0x282c,0x2822,0x282d,0x2823,0x282e,0x282e,0x282e,
    0x2824,0x282f,0x282f,0x282f,0x2826,0x2831,0x2831,0x2831,
    0x2825,0x2830,0x2830,0x2830,0x2827,0x283c,0x2837,0x2837,

    0x2837,0x2832,0x2832,0x2832,0x2829,0x283e,0x2839,0x2839,
    0x2839,0x2834,0x2834,0x2834,0x2828,0x2838,0x2838,0x2838,
    0x283d,0x2833,0x2833,0x2833,0x282a,0x283a,0x283a,0x283a,
    0x283f,0x2835,0x2835,0x2835,0x282b,0x283b,0x283b,0x283b,

    0x2840,0x2840,0x2840,0x2836,0x2836,0x2836,0x2836,0x2836,
    0x2836,0x2836,0x2836,0x2836,0x2821,0x282c,0x2822,0x282d,
    0x2821,0x2822,0x2823,0x2823,0x2823,0x2824,0x2824,0x2824,
    0x2826,0x2826,0x2826,0x2825,0x2825,0x2825,0x283c,0x2837,

    0x2832,0x283e,0x2839,0x2834,0x2838,0x283d,0x2833,0x283a,
    0x283f,0x2835,0x283b,0x2840,0x2836,0x0000,0x0000,0x0000,
    0x0000,0x213f,0x2140,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

/* --------------------------------------------------------------- */
/* MS gaiji conversion tables					   */
/* --------------------------------------------------------------- */
long uni_j_msgaiji[94] = {
    0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,0x2467,
    0x2468,0x2469,0x246a,0x246b,0x246c,0x246d,0x246e,0x246f,
    0x2470,0x2471,0x2472,0x2473,0x2160,0x2161,0x2162,0x2163,
    0x2164,0x2165,0x2166,0x2167,0x2168,0x2169,0x0000,0x3349,
    0x3314,0x3322,0x334d,0x3318,0x3327,0x3303,0x3336,0x3351,
    0x3357,0x330d,0x3326,0x3323,0x332b,0x334a,0x333b,0x339c,
    0x339d,0x339e,0x338e,0x338f,0x33c4,0x33a1,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x337b,0x301d,
    0x301f,0x2116,0x33cd,0x2121,0x32a4,0x32a5,0x32a6,0x32a7,
    0x32a8,0x3231,0x3232,0x3239,0x337e,0x337d,0x337c,0x2252,
    0x2261,0x222b,0x222e,0x2211,0x221a,0x22a5,0x2220,0x221f,
    0x22bf,0x2235,0x2229,0x222a,0x0000,0x0000
};

/* --------------------------------------------------------------- */
long uni_j_necgaiji[376] = {
           0x7e8a,0x891c,0x9348,0x9288,0x84dc,0x4fc9,0x70bb,
    0x6631,0x68c8,0x92f9,0x66fb,0x5f45,0x4e28,0x4ee1,0x4efc,
    0x4f00,0x4f03,0x4f39,0x4f56,0x4f92,0x4f8a,0x4f9a,0x4f94,
    0x4fcd,0x5040,0x5022,0x4fff,0x501e,0x5046,0x5070,0x5042,
    0x5094,0x50f4,0x50d8,0x514a,0x5164,0x519d,0x51be,0x51ec,
    0x5215,0x529c,0x52a6,0x52c0,0x52db,0x5300,0x5307,0x5324,
    0x5372,0x5393,0x53b2,0x53dd,0xfa0e,0x549c,0x548a,0x54a9,
    0x54ff,0x5586,0x5759,0x5765,0x57ac,0x57c8,0x57c7,0xfa0f,
    0xfa10,0x589e,0x58b2,0x590b,0x5953,0x595b,0x595d,0x5963,
    0x59a4,0x59ba,0x5b56,0x5bc0,0x752f,0x5bd8,0x5bec,0x5c1e,
    0x5ca6,0x5cba,0x5cf5,0x5d27,0x5d53,0xfa11,0x5d42,0x5d6d,
    0x5db8,0x5db9,0x5dd0,0x5f21,0x5f34,0x5f67,0x5fb7,
	   0x5fde,0x605d,0x6085,0x608a,0x60de,0x60d5,0x6120,
    0x60f2,0x6111,0x6137,0x6130,0x6198,0x6213,0x62a6,0x63f5,
    0x6460,0x649d,0x64ce,0x654e,0x6600,0x6615,0x663b,0x6609,
    0x662e,0x661e,0x6624,0x6665,0x6657,0x6659,0xfa12,0x6673,
    0x6699,0x66a0,0x66b2,0x66bf,0x66fa,0x670e,0xf929,0x6766,
    0x67bb,0x6852,0x67c0,0x6801,0x6844,0x68cf,0xfa13,0x6968,
    0xfa14,0x6998,0x69e2,0x6a30,0x6a6b,0x6a46,0x6a73,0x6a7e,
    0x6ae2,0x6ae4,0x6bd6,0x6c3f,0x6c5c,0x6c86,0x6c6f,0x6cda,
    0x6d04,0x6d87,0x6d6f,0x6d96,0x6dac,0x6dcf,0x6df8,0x6df2,
    0x6dfc,0x6e39,0x6e5c,0x6e27,0x6e3c,0x6ebf,0x6f88,0x6fb5,
    0x6ff5,0x7005,0x7007,0x7028,0x7085,0x70ab,0x710f,0x7104,
    0x715c,0x7146,0x7147,0xfa15,0x71c1,0x71fe,0x72b1,
	   0x72be,0x7324,0xfa16,0x7377,0x73bd,0x73c9,0x73d6,
    0x73e3,0x73d2,0x7407,0x73f5,0x7426,0x742a,0x7429,0x742e,
    0x7462,0x7489,0x749f,0x7501,0x756f,0x7682,0x769c,0x769e,
    0x769b,0x76a6,0xfa17,0x7746,0x52af,0x7821,0x784e,0x7864,
    0x787a,0x7930,0xfa18,0xfa19,0xfa1a,0x7994,0xfa1b,0x799b,
    0x7ad1,0x7ae7,0xfa1c,0x7aeb,0x7b9e,0xfa1d,0x7d48,0x7d5c,
    0x7db7,0x7da0,0x7dd6,0x7e52,0x7f47,0x7fa1,0xfa1e,0x8301,
    0x8362,0x837f,0x83c7,0x83f6,0x8448,0x84b4,0x8553,0x8559,
    0x856b,0xfa1f,0x85b0,0xfa20,0xfa21,0x8807,0x88f5,0x8a12,
    0x8a37,0x8a79,0x8aa7,0x8abe,0x8adf,0xfa22,0x8af6,0x8b53,
    0x8b7f,0x8cf0,0x8cf4,0x8d12,0x8d76,0xfa23,0x8ecf,0xfa24,
    0xfa25,0x9067,0x90de,0xfa26,0x9115,0x9127,0x91da,
	   0x91d7,0x91de,0x91ed,0x91ee,0x91e4,0x91e5,0x9206,
    0x9210,0x920a,0x923a,0x9240,0x923c,0x924e,0x9259,0x9251,
    0x9239,0x9267,0x92a7,0x9277,0x9278,0x92e7,0x92d7,0x92d9,
    0x92d0,0xfa27,0x92d5,0x92e0,0x92d3,0x9325,0x9321,0x92fb,
    0xfa28,0x931e,0x92ff,0x931d,0x9302,0x9370,0x9357,0x93a4,
    0x93c6,0x93de,0x93f8,0x9431,0x9445,0x9448,0x9592,0xf9dc,
    0xfa29,0x969d,0x96af,0x9733,0x973b,0x9743,0x974d,0x974f,
    0x9751,0x9755,0x9857,0x9865,0xfa2a,0xfa2b,0x9927,0xfa2c,
    0x999e,0x9a4e,0x9ad9,0x9adc,0x9b75,0x9b72,0x9b8f,0x9bb1,
    0x9bbb,0x9c00,0x9d70,0x9d6b,0xfa2d,0x9e19,0x9ed1,0x0000,
    0x0000,0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,0x2176,
    0x2177,0x2178,0x2179,0xffe2,0xffe4,0xff07,0xff02
};

/* --------------------------------------------------------------- */
/* Unic*de 2010-204f						   */
/* --------------------------------------------------------------- */
unsigned short uni_k_punct[80] = {
    0x0020,0x0020,0x0020,0x0020, 0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020, 0x0000,0x0000,0x0000,0x0000,
    0x213e,0x213e,0x213d,0x213d, 0x213d,0x213d,0x2142,0x0000,
    0x2146,0x2147,0x2124,0x212e, 0x2148,0x2149,0x0000,0x2148,
    0x2277,0x2278,0x2126,0x0000, 0x2126,0x2145,0x2144,0x2126,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x2273,0x0000,0x216c,0x216d, 0x0000,0x212e,0x0000,0x0000,
    0x005e,0x2152,0x2153,0x2228, 0x0000,0x0000,0x2131,0x0000,
    0x225e,0x0000,0x0000,0x0000, 0x213f,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x2176,0x0000
};

/* --------------------------------------------------------------- */
/* Unic*de 2100-21ff						   */
/* --------------------------------------------------------------- */
unsigned short uni_f_l_21[256] = {
    0x0000, 0x0000, 0x0000, 0x216e, 0x0000, 0x0000, 0x0000, 0x0000,
    0x273f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa944,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa271, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xa26f, 0x0000, 0x0000, 0x0000, 0x2638, 0x0000,
    0x0000, 0x0000, 0x004b, 0x2272, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x222b, 0x222c, 0x222a, 0x222d, 0x224e, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x222b, 0x222c,
    0x222a, 0x222d, 0x222b, 0x222a, 0x222b, 0x222c, 0x222a, 0x222d,
    0x0000, 0x222b, 0x222a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x222b, 0x222b, 0x222c, 0x222c,

    0x222a, 0x222a, 0x222d, 0x222d, 0x224e, 0x0000, 0x224e, 0x0000,
    0x0000, 0x0000, 0x0000, 0x224e, 0x224e, 0x0000, 0x0000, 0x0000,
    0x222b, 0x222c, 0x224d, 0x222d, 0x224e, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x224d, 0x222b, 0x222a, 0x222c, 0x222d,
    0x222b, 0x222c, 0x222a, 0x222d, 0x0000, 0x0000, 0x222b, 0x222c,
    0x224d, 0x222d, 0x222c, 0x222c, 0x222c, 0x222c, 0x222c, 0x222d,
    0x224d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

/* --------------------------------------------------------------- */
/* Unic*de 2570-25ff						   */
/* --------------------------------------------------------------- */
unsigned short uni_f_l_25b[144] = {
    0x0000, 0x213f, 0x2140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x2223, 0x2222, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x2225, 0x2224, 0x2225, 0x2224, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x2227, 0x2226, 0x2227, 0x2226,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2221, 0x217e,
    0x0000, 0x0000, 0x0000, 0x217b, 0x0000, 0x0000, 0x217d, 0x217c,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x225e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x227e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x2222, 0x2223, 0x0000, 0x0000, 0x0000
};

/* --------------------------------------------------------------- */
/* Unic*de 2600-267f						   */
/* --------------------------------------------------------------- */
unsigned short uni_f_l_26[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x217a, 0x2179, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x2222, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x216a, 0x0000, 0x2169, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x2276, 0x0000, 0x0000, 0x2275, 0x0000, 0x2274,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};
/* --------------------------------------------------------------- */
/* Unic*de 2700-27bf						   */
/* --------------------------------------------------------------- */
unsigned short uni_f_l_27[192] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x215f, 0x215f, 0x215f,
    0x215f, 0x2836, 0x2836, 0x2836, 0x2836, 0x2836, 0x2836, 0x2836,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x2179, 0x217a, 0x2179, 0x217a, 0x217a, 0x2179, 0x2179,
    0x2179, 0x2176, 0x2176, 0x2176, 0x2176, 0x2176, 0x2176, 0x2176,
    0x2176, 0x2176, 0x2228, 0x2228, 0x2228, 0x2228, 0x2228, 0x2228,

    0x2228, 0x2228, 0x2228, 0x2228, 0x2228, 0x2228, 0x2228, 0x2228,
    0x2228, 0x2228, 0x2228, 0x2228, 0x0000, 0x217b, 0x0000, 0x2222,
    0x2222, 0x2222, 0x2222, 0x0000, 0x0000, 0x0000, 0x2221, 0x0000,
    0x0000, 0x0000, 0x2223, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x214a, 0x214b, 0x214a, 0x214b, 0x2152, 0x2153, 0x2154, 0x2155,
    0x2154, 0x2155, 0x214c, 0x214d, 0x2150, 0x2151, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x222a, 0x222a, 0x222a, 0x222a, 0x222a, 0x222a, 0x222a, 0x222a,

    0x222a, 0x222a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x224d, 0x224d, 0x224d, 0x224d, 0x224d, 0x224d, 0x224d,
    0x0000, 0x224d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x224d, 0x0000
};

/* --------------------------------------------------------------- */
/* Unic*de 2900-29ff						   */
/* --------------------------------------------------------------- */
unsigned short uni_f_arrow29[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x222b, 0x224d,
    0x0000, 0x0000, 0x0000, 0x0000, 0x222b, 0x222a, 0x222b, 0x222a,
    0x222a, 0x222a, 0x222c, 0x222d, 0x0000, 0x0000, 0x222a, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x215f, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x224e, 0x224e, 0x0000, 0x0000, 0x224e, 0x0000,
    0x224e, 0x0000, 0x222b, 0x222a, 0x222c, 0x222d, 0x222b, 0x222a,
    0x222c, 0x222d, 0x222b, 0x222a, 0x222c, 0x222d, 0x222b, 0x222a,

    0x222c, 0x222d, 0x222b, 0x222c, 0x224d, 0x222d, 0x224e, 0x224e,
    0x224e, 0x224e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x223f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

/* --------------------------------------------------------------- */
extern long uni_fix_table[];

/* --------------------------------------------------------------- */
/* Unic*de 02b0-02df						   */
/* --------------------------------------------------------------- */
unsigned short uni_f_l_02[48] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0027, 0x0022, 0x0060, 0x0027, 0x0000, 0x0000, 0x0000,

    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2130, 0xa230,
    0xa238, 0xa234, 0x212d, 0x212e, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0xa22f, 0xa232, 0xa236, 0xa235, 0xa237, 0xa233, 0x0000, 0x0000
};

/* --------------------------------------------------------------- */
/* ucs2 to jis, iso tables					   */
long	jis[32768],hoj[32768]; /* reverse generation table	   */
long	latin[LATIN_TABLE_LEN];
long	uni_kana[256];
long	uni_symbol[GLYPH_TABLE_LEN];

/* --------------------------------------------------------------- */
void output(f,num,table)
FILE *f;
long	num,*table;
{
    long	i,j,k,x212 = 0;
    fprintf(f,"unsigned short uni_f_%02lx[4096] = {\n",num);

    for (i=0;i<4096;i++) {
    	j = table[i]; 
    	if (j >= 9600) {
    	    x212 = j;
    	} else if (j == -2) {
    	    j = ++x212; 
	};

    	if (j == -1) fprintf(f,"0");
    	else {
    	    fprintf(f,"0x%02lx%02lx",
    	    	(j/100)+((j >= 9600) ? 0x50 : 0x20),(j%100) + 0x20);
    	    if (j >= 9600) {	/* X-0212			*/
    	    	k = ((j-8000)/100 << 7) + (j%100) -0x81;
    	    	if (hoj[k] == 0) hoj[k] = (num * 256)  + i;
    	    	else {
    	    	    fprintf(stderr,"Hojyokanji Table conflict detected! at %04lx\n",
    	    	    		(num*256)+i);
    	    	    fprintf(stderr,"Previous value %04lx at %04lx value %ld\n",
    	    	    		hoj[k],k,j);
		    exit(1);
    	    	};
	    } else {
    	    	k = ((j/100) << 7) + (j%100) -0x81;
    	    	if (k >= 0) {
    	    	  if (jis[k] == 0) jis[k] = (num *256) + i;
    	    	  else {
    	    	    fprintf(stderr,"JIS Table conflict detected! at %04lx\n",
    	    	    		(num*256)+i);
    	    	    fprintf(stderr,"Previous value %04lx at %04lx value %ld\n",
    	    	    		jis[k],k,j);
		    exit(1);
		  };
		};
	    };
	};
	if ((i&0x07) == 7) {
	    if (i == 4095) fprintf(f,"\n};\n");
	    else fprintf(f,",\n");
	} else fprintf(f,",");
    };
}

/* --------------------------------------------------------------- */
int main(argc,argv)
int	argc;
char	**argv;
{
    FILE	*f;
#ifdef SKFDEBUG
    FILE	*log;
#endif
    long i,j,k,x212 = 0;
    long table[20992];

/* --- initialize reverse conversion tables ---- */
    for (i=0;i<32768;i++) {
        jis[i] = 0; hoj[i] = 0;
    };
    latin[0] = 0x20;
    for (i=1;i<0x60;i++) latin[i] = 0;
    for (i=0x60;i<LATIN_TABLE_LEN;i++) latin[i] = 0;
    for (i=0;i<GLYPH_TABLE_LEN;i++) uni_symbol[i] = 0;
    for (i=0;i<256;i++) {
	uni_kana[i] = 0;
    };

/* --- output CJK conversion table --- */
    f = fopen("uni_table.c","w");
    fprintf(f,"char *skf_copyright=%c%s%c;\n",0x22,copyright,0x22);
    fprintf(f,"char *skf_table_rev=%c%s%c;\n",0x22,table_rev,0x22);
    fprintf(f,"/%c --- table --- %c/\n\n",'*','*');
    fprintf(f,"/%c --- Do not distribute this table alone --- %c/\n\n",'*','*');

/* 1st Table: From Ucs2 to JIS X-0208/0212			   */

/* 4e00 - 4fff */
    for (i=0;i<256;i++) table[i+0x000] = uni_h_4e[i];
    for (i=0;i<256;i++) table[i+0x100] = uni_h_4f[i];
/* 5000 - 5fff */
    for (i=0;i<256;i++) table[i+0x200] = uni_h_50[i];
    for (i=0;i<256;i++) table[i+0x300] = uni_h_51[i];
    for (i=0;i<256;i++) table[i+0x400] = uni_h_52[i];
    for (i=0;i<256;i++) table[i+0x500] = uni_h_53[i];
    for (i=0;i<256;i++) table[i+0x600] = uni_h_54[i];
    for (i=0;i<256;i++) table[i+0x700] = uni_h_55[i];
    for (i=0;i<256;i++) table[i+0x800] = uni_h_56[i];
    for (i=0;i<256;i++) table[i+0x900] = uni_h_57[i];
    for (i=0;i<256;i++) table[i+0xa00] = uni_h_58[i];
    for (i=0;i<256;i++) table[i+0xb00] = uni_h_59[i];
    for (i=0;i<256;i++) table[i+0xc00] = uni_h_5a[i];
    for (i=0;i<256;i++) table[i+0xd00] = uni_h_5b[i];
    for (i=0;i<256;i++) table[i+0xe00] = uni_h_5c[i];
    for (i=0;i<256;i++) table[i+0xf00] = uni_h_5d[i];
    for (i=0;i<256;i++) table[i+0x1000] = uni_h_5e[i];
    for (i=0;i<256;i++) table[i+0x1100] = uni_h_5f[i];

/* 6000 - 6fff */
    for (i=0;i<256;i++) table[i+0x1200] = uni_h_60[i];
    for (i=0;i<256;i++) table[i+0x1300] = uni_h_61[i];
    for (i=0;i<256;i++) table[i+0x1400] = uni_h_62[i];
    for (i=0;i<256;i++) table[i+0x1500] = uni_h_63[i];
    for (i=0;i<256;i++) table[i+0x1600] = uni_h_64[i];
    for (i=0;i<256;i++) table[i+0x1700] = uni_h_65[i];
    for (i=0;i<256;i++) table[i+0x1800] = uni_h_66[i];
    for (i=0;i<256;i++) table[i+0x1900] = uni_h_67[i];
    for (i=0;i<256;i++) table[i+0x1a00] = uni_h_68[i];
    for (i=0;i<256;i++) table[i+0x1b00] = uni_h_69[i];
    for (i=0;i<256;i++) table[i+0x1c00] = uni_h_6a[i];
    for (i=0;i<256;i++) table[i+0x1d00] = uni_h_6b[i];
    for (i=0;i<256;i++) table[i+0x1e00] = uni_h_6c[i];
    for (i=0;i<256;i++) table[i+0x1f00] = uni_h_6d[i];
    for (i=0;i<256;i++) table[i+0x2000] = uni_h_6e[i];
    for (i=0;i<256;i++) table[i+0x2100] = uni_h_6f[i];

/* 7000 - 7fff */
    for (i=0;i<256;i++) table[i+0x2200] = uni_h_70[i];
    for (i=0;i<256;i++) table[i+0x2300] = uni_h_71[i];
    for (i=0;i<256;i++) table[i+0x2400] = uni_h_72[i];
    for (i=0;i<256;i++) table[i+0x2500] = uni_h_73[i];
    for (i=0;i<256;i++) table[i+0x2600] = uni_h_74[i];
    for (i=0;i<256;i++) table[i+0x2700] = uni_h_75[i];
    for (i=0;i<256;i++) table[i+0x2800] = uni_h_76[i];
    for (i=0;i<256;i++) table[i+0x2900] = uni_h_77[i];
    for (i=0;i<256;i++) table[i+0x2a00] = uni_h_78[i];
    for (i=0;i<256;i++) table[i+0x2b00] = uni_h_79[i];
    for (i=0;i<256;i++) table[i+0x2c00] = uni_h_7a[i];
    for (i=0;i<256;i++) table[i+0x2d00] = uni_h_7b[i];
    for (i=0;i<256;i++) table[i+0x2e00] = uni_h_7c[i];
    for (i=0;i<256;i++) table[i+0x2f00] = uni_h_7d[i];
    for (i=0;i<256;i++) table[i+0x3000] = uni_h_7e[i];
    for (i=0;i<256;i++) table[i+0x3100] = uni_h_7f[i];

/* 8000 - 8fff */
    for (i=0;i<256;i++) table[i+0x3200] = uni_h_80[i];
    for (i=0;i<256;i++) table[i+0x3300] = uni_h_81[i];
    for (i=0;i<256;i++) table[i+0x3400] = uni_h_82[i];
    for (i=0;i<256;i++) table[i+0x3500] = uni_h_83[i];
    for (i=0;i<256;i++) table[i+0x3600] = uni_h_84[i];
    for (i=0;i<256;i++) table[i+0x3700] = uni_h_85[i];
    for (i=0;i<256;i++) table[i+0x3800] = uni_h_86[i];
    for (i=0;i<256;i++) table[i+0x3900] = uni_h_87[i];
    for (i=0;i<256;i++) table[i+0x3a00] = uni_h_88[i];
    for (i=0;i<256;i++) table[i+0x3b00] = uni_h_89[i];
    for (i=0;i<256;i++) table[i+0x3c00] = uni_h_8a[i];
    for (i=0;i<256;i++) table[i+0x3d00] = uni_h_8b[i];
    for (i=0;i<256;i++) table[i+0x3e00] = uni_h_8c[i];
    for (i=0;i<256;i++) table[i+0x3f00] = uni_h_8d[i];
    for (i=0;i<256;i++) table[i+0x4000] = uni_h_8e[i];
    for (i=0;i<256;i++) table[i+0x4100] = uni_h_8f[i];

/* 9000 - 9fff */
    for (i=0;i<256;i++) table[i+0x4200] = uni_h_90[i];
    for (i=0;i<256;i++) table[i+0x4300] = uni_h_91[i];
    for (i=0;i<256;i++) table[i+0x4400] = uni_h_92[i];
    for (i=0;i<256;i++) table[i+0x4500] = uni_h_93[i];
    for (i=0;i<256;i++) table[i+0x4600] = uni_h_94[i];
    for (i=0;i<256;i++) table[i+0x4700] = uni_h_95[i];
    for (i=0;i<256;i++) table[i+0x4800] = uni_h_96[i];
    for (i=0;i<256;i++) table[i+0x4900] = uni_h_97[i];
    for (i=0;i<256;i++) table[i+0x4a00] = uni_h_98[i];
    for (i=0;i<256;i++) table[i+0x4b00] = uni_h_99[i];
    for (i=0;i<256;i++) table[i+0x4c00] = uni_h_9a[i];
    for (i=0;i<256;i++) table[i+0x4d00] = uni_h_9b[i];
    for (i=0;i<256;i++) table[i+0x4e00] = uni_h_9c[i];
    for (i=0;i<256;i++) table[i+0x4f00] = uni_h_9d[i];
    for (i=0;i<256;i++) table[i+0x5000] = uni_h_9e[i];
    for (i=0;i<256;i++) table[i+0x5100] = uni_h_9f[i];
/* ---- */

    fprintf(f,"unsigned short uni_f_4e[20992] = {\n");
    for (i=0;i<20992;i++) {
	j = table[i]; if (j >= 9600) x212 = j;
    	if (j == -2) { j = ++x212; };
    	if (j == -1) fprintf(f,"0");
    	else {
	    if (i == 0xdd) {	/* we need this, but not sure why */
		fprintf(f,"0x2138");
	    } else
		fprintf(f,"0x%02lx%02lx",
    	    	(j/100)+((j >= 9600) ? 0x50 : 0x20),(j%100) + 0x20);
    	    if (j >= 9600) {	/* X-0212			*/
    	    	k = ((j-8000)/100 << 7) + (j%100) - 0x81;
    	    	if (hoj[k] == 0) hoj[k] = 0x4e00 + i;
    	    	else {
    	    	    fprintf(stderr,"Hojyokanji Table conflict detected! at %04lx\n",
    	    	    		0x4e00 + i);
    	    	    fprintf(stderr,"Previous value %04lx at %04lx\n",
    	    	    		hoj[k],k);
		    exit(1);
    	    	};
	    } else {
    	    	k = (j/100 << 7) + (j%100) - 0x81;
    	    	if (k >= 0) {
    	    	  if (jis[k] == 0) jis[k] = 0x4e00 + i;
    	    	  else {
    	    	    fprintf(stderr,"JIS Table conflict detected! at %04lx\n",
    	    	    		0x4e00 + i);
    	    	    fprintf(stderr,"Previous value %04lx at %04lx\n",
    	    	    		jis[k],k);
		    exit(1);
		  };
		};
	    };
	};
	if (i != 20991) {
	    if ((i&0x07) == 7) fprintf(f,",\n");
	    else fprintf(f,",");
	    if ((i & 0xfff) == 0x1ff) {
		fprintf(f,"%c* area %04lx *%c\n",'/',
		    ((i+1) & 0xff000)+0x5000,'/');
	    };
	} else {
	    fprintf(f,"\n};\n");
	};
    };
#ifdef SKFDEBUG
    /* dump reverse tables */
    log = fopen("logger","w");
    fprintf(log,"JIS Table\n");
    for (i=15;i<84;i++) {
        for (j=0;j<128;j++) {
            if (jis[(i*128)+j] != 0) putc('1',log);
            else fputc('.',log);
	};
	fprintf(log,"\n");
    };

    fprintf(log,"HojyoKanji Table\n");
    for (i=15;i<77;i++) {
        for (j=0;j<128;j++) {
            if (hoj[((i*128))+j] != 0) putc('1',log);
            else putc('.',log);
	};
	fprintf(log,"\n");
    };
    fclose(log);
#endif

/* --- generate greek & cyrillic parts for x0208 ------------------ */
/* I regard all diacretical mark in X0212 as non-spacing, for
  ucs2 does not have whole set of spacing diacretical and I
  want a consistent conversion. S.Kaneko */

    for (i=0;i<48;i++) {	/* hjo setup			   */
	latin[i+0x2b0-0xa0] = uni_f_l_02[i];
    };

    for (i=0;i<24;i++) {
    	k = uni_h_xgreek[i];
	hoj[0x2c0+i+((i>=12) ? 4:0)] = k+0x300; 
    	latin[k+0x260] = 0xa661 + i + ((i>=12) ? 4 : 0);
    };
    hoj[0x2c5] = 0; hoj[0x2c7] = 0; hoj[0x2ca] = 0;

    /* diacritical */
    for (i=0;i<11;i++) {
    	k = uni_h_dianm[i];
	hoj[0x8e +i] = uni_h_dianmx[i];
    	latin[k+0x260] = 0xa22f + i;
    };

    for (i=0;i<4;i++) {
    	k = uni_h_xsign[i];
	hoj[0xca+i] = k;
    	latin[k-0xa0] = 0xa26b + i;
    };
    hoj[0xca+4] = 0x2122;
    hoj[0xca+5] = 0x00a4;
    hoj[0xca+6] = 0x2116;

    for (i=0;i<11;i++) {
	latin[i+0x360+2] = 0xa742+i;
	latin[i+0x360+0x52] = 0xa772+i;
	hoj[0x321+i] = 0x402+i;
	hoj[0x351+i] = 0x452+i;
    };
    hoj[0x32c] = 0x40e; latin[0x360+0x0e] = 0xa74d;
    hoj[0x32d] = 0x40f; latin[0x360+0x0f] = 0xa74e;
    hoj[0x35c] = 0x45e; latin[0x360+0x5e] = 0xa77d;
    hoj[0x35d] = 0x45f; latin[0x360+0x5f] = 0xa77e;

    for (i=0;i<32;i++) {
    	k = uni_h_xrom[i];
	hoj[0x400+i+((i>=16) ? 16:0)] = k;
    	latin[k-0xa0] = 0xa921 + i + ((i>=16) ? 16 : 0);
    };
    /* hosei */
    hoj[0x400+2] = 0;
    hoj[0x400+4] = 0;
    hoj[0x400+6] = 0;
    hoj[0x400+9] = 0;
    hoj[0x400+13] = 0;

    for (i=0;i<87;i++) {
    	k = uni_h_xrcap[i];
	hoj[0x480+i] = k;
	hoj[0x500+i] = k + ((k < 0x100) ? 0x20 : 0x01);
    	latin[k-0xa0] = 0xaa21 + i;
    	if (k < 0x100) latin[k-0x80] = 0xab21 + i;
    	else latin[k-0x9f] = 0xab21 + i;
    };
    /* hosei */
    hoj[0x480+24] = 0;
    hoj[0x500+27] = 0;
    hoj[0x500+35] = 0;

    for (i=0;i<24;i++) {	/* fill greek in x-0208		  */
    	k = i + ((i>16) ? 1 : 0);
	jis[0x280+i] = 0x391 + k;
	jis[0x2a0+i] = 0x3b1 + k;
    	latin[0x260+0x91+k] = 0x2621 + i;
    	latin[0x260+0xb1+k] = 0x2641 + i;
    };

    for (i=0;i<32;i++) {	/* fill cyril			  */
	jis[0x300+i] = 0x410 + i + ((i>6) ? (-1) : 0);
	jis[0x330+i] = 0x430 + i + ((i>6) ? (-1) : 0);
	latin[0x360+0x10+i] = 0x2721 + i + ((i>5) ? 1 : 0);
	latin[0x360+0x30+i] = 0x2751 + i + ((i>5) ? 1 : 0);
    };
    jis[0x320] = 0x42f; jis[0x350] = 0x44f;
    jis[0x306] = 0x401; latin[0x361] = 0x2727;
    jis[0x336] = 0x451; latin[0x3b1] = 0x2757;

    /* additions */
    hoj[0x80+33] = 0xa1;
    hoj[0x80+34] = 0xa6;
    hoj[0x80+35] = 0xbf;

/* --- generate non CJK part for x0208 ---------------------------- */
/*    fprintf(f,"unsigned short uni_t_k21[93] = {\n"); */
    for (i=0;i<93;i++) {
    	k = uni_j_k21[i];
	jis[i+1] = k;
    	if ((k >= 0x00a0) && (k <= 0x01ff)) {
    	    latin[k-0xa0] = 0x2122 + i;
	} else if ((k >= 0x0300) && (k <= 0x036f)) {
	    latin[k-0x0300+0x260] = 0x2122 + i;
	} else if ((k >= 0x2200) && (k <= 0x22ff)) {
	    uni_symbol[k-0x2000] = 0x2122 + i;
	} else ;
    };
    jis[0] = 0x3000;

    for (i=0;i<94;i++) {
    	k = uni_j_k22[i];
	jis[i+0x80] = k;
    	if ((k >= 0x00a0) && (k <= 0x01ff)) {
    	    latin[k-0xa0] = 0x2221 + i;
	} else if ((k >= 0x0300) && (k <= 0x036f)) {
	    latin[k-0x0300+0x260] = 0x2221 + i;
	} else if ((k >= 0x2200) && (k <= 0x22ff)) {
	    uni_symbol[k-0x2000] = 0x2221 + i;
	} else ;
    };

/* fullwidth letters */
    for (i=0;i<10;i++) {
	jis[i+0x10f] = 0xff10 + i;
    };
    for (i=0;i<26;i++) {
	jis[i+0x120] = 0xff21 + i;
	jis[i+0x140] = 0xff41 + i;
    };
/* CJK kana */
    for (i=0;i<83;i++) {
	jis[i+0x180] = 0x3041 + i;
	jis[i+0x200] = 0x30a1 + i;
    };
    jis[0x200+83] = 0x30f4;
    jis[0x200+84] = 0x30f5;
    jis[0x200+85] = 0x30f6;

/* charts */
    for (i=0;i<32;i++) {
	jis[i+0x380] = uni_jt_chart[i] + 0x2500;
    };

    for (i=0;i<128;i++) {
	uni_symbol[0x500+i] = uni_h_chart[i];
    };

/* ms gaiji */
    for (i=0;i<94;i++) {
    	k = uni_j_msgaiji[i];
	jis[i+0x600] = k;
    };

/* --- nec gaiji fix */
    for (i=0;i < 4;i++) {
	for (j=0; j<94; j++) {
	    jis[0x2c00+(i << 7)+j] = uni_j_necgaiji[(i*94)+j];
	};
    };

/* --- symbol table injection -------- */
    for (i=0;i<0x50;i++) uni_symbol[i] = uni_k_punct[i];
    uni_symbol[0xdd] = 0x227e;
    for (i=0;i<256;i++) uni_symbol[i+0x100] = uni_f_l_21[i];
    for (i=0x70;i<0x100;i++) uni_symbol[i+0x500] = uni_f_l_25b[i-0x70];
    for (i=0;i<0x80;i++) uni_symbol[i+0x600] = uni_f_l_26[i];
    for (i=0;i<0xc0;i++) uni_symbol[i+0x700] = uni_f_l_27[i];
    for (i=0;i<0x80;i++) uni_symbol[i+0x900] = uni_f_arrow29[i];

/* static table fix --------------------------------------------- */
    i = 0;
    while (uni_fix_table[i] >= 0) {
	if ((uni_fix_table[i] >= 0xa0)
		&& (uni_fix_table[i] < 0x500)) {
	    latin[uni_fix_table[i] - 0xa0] = uni_fix_table[i+1];
	} else if ((uni_fix_table[i] >= 0x2200)
		&& (uni_fix_table[i] < 0x3000)) {
	    uni_symbol[uni_fix_table[i] - 0x2000] = uni_fix_table[i+1];
	};
	i += 2;
    };

/* --- output generated reverse table ------------------------- */
/* jis x0208/jis x0212 to ucs2					*/
    fprintf(f,"/%c --- JIS X0208 Table --- %c/\n",'*','*');
    fprintf(f,"unsigned short uni_t_x208[%d] = {\n",ISOMB_CODE_END+1);
    for (i=0;i<94;i++) {
	for (j=0;j<94;j++) {
	    fprintf(f,"0x%04lx",jis[(i*128)+j]);
	    if ((j & 0x07) == 0x07) fprintf(f,",\n");
            else fprintf(f,",");
	};
	fprintf(f,"\n");
    };
    fprintf(f,"0\n};\n\n");

    fprintf(f,"/%c --- JIS X0212 Table --- %c/\n",'*','*');
    fprintf(f,"unsigned short uni_t_x212[%d] = {\n",ISOMB_CODE_END+1);
    for (i=0;i<94;i++) {
	for (j=0;j<94;j++) {
	    fprintf(f,"0x%04lx",hoj[(i*128)+j]);
	    if ((j & 0x07) == 0x07) fprintf(f,",\n");
            else fprintf(f,",");
	};
	fprintf(f,"\n");
    };
    fprintf(f,"0\n};\n\n");

/* --- Latin alphabet part ----------------------------------- */
/* --- reversed romans -------- */
/* i.e. Ucs2 -> JIS, ISO */
    fprintf(f,"/%c --- JIS Latin and symbol reverse Table --- %c/\n",'*','*');
    fprintf(f,"unsigned short uni_f_latin[%d] = {\n",LATIN_TABLE_LEN);
    for (i=0;i<LATIN_TABLE_LEN;i++) {
    	k = latin[i];
    	if (i == (LATIN_TABLE_LEN - 1)) fprintf(f,"0x%04lx\n};\n",k);
    	else if ((i & 7) == 7) fprintf(f,"0x%04lx,\n",k);
    	else fprintf(f,"0x%04lx,",k);
    };

    fprintf(f,"unsigned short uni_f_symbol[%d] = {\n",GLYPH_TABLE_LEN);
    for (i=0;i<GLYPH_TABLE_LEN;i++) {
    	k = uni_symbol[i];
    	if (i == (GLYPH_TABLE_LEN - 1)) fprintf(f,"0x%04lx\n};\n",k);
    	else if ((i & 7) == 7) fprintf(f,"0x%04lx,\n",k);
    	else fprintf(f,"0x%04lx,",k);
    };

/* --- write end --- */
    fclose(f);
/* ---- */
    exit(0);
}
