#include "msg.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

void error(const char * f, ...)
{
	va_list m;
	va_start(m, f);
	vmsg(0, f, m);
	va_end(m);
}

void warn(const char * f, ...)
{
	va_list m;
	va_start(m, f);
	vmsg(1, f, m);
	va_end(m);
}

void info(const char * f, ...)
{
	va_list m;
	va_start(m, f);
	vmsg(2, f, m);
	va_end(m);
}

void trace(const char * f, ...)
{
	va_list m;
	va_start(m, f);
	vmsg(3, f, m);
	va_end(m);
}

void vmsg(int level, const char * f, va_list m)
{
	if (level > __verb)
		return;
	
	fprintf(stderr, "%s: ", __name);
	vfprintf(stderr, f, m);
	fprintf(stderr, "\n");
}

/*
 *
 */
const char * __name = "sign";
int          __verb = 0;

