.\"
.\" @(#)sdist.man,v 1.12 2011/09/02 00:38:13 kim Exp
.\"
.Dd September 1, 2011
.Dt SDIST 8
.Os
.Sh NAME
.Nm sdist
.Nd distribute files to a set of hosts
.Sh SYNOPSIS
.Nm
.Op Fl ARScgnqrsvyz
.Op Fl D Ar destdir
.Op Fl M Ar maxparallel
.Op Fl d Ar var=value
.Op Fl f Ar hostfile
.Op Fl h Ar host
.Op Fl l Ar logopts
.Op Fl o Ar longoptions
.Op Fl t Ar timeout
.Op Fl x Ar extra-rdist-clause
.Op Ar files or directories
.Sh DESCRIPTION
The
.Nm
command invokes 
.Xr rdist 1
in an intelligent manner.  Usually
.Nm
is invoked from the master distribution host.
.Pp
Invoking the command without any arguments will distribute the current 
working directory to all hosts in the netgroup for the platform you are
running
.Nm
on.  The name of the group is ``dist-os-rel-arch''
where
.Ar os , rel
and
.Ar arch
are derived from the output of
.Xr osname 1 .
.Pp
.Nm
will read
.Pa /etc/sdist.conf
for local default overrides if it exists.
.Pp
If files or directories are specified on the command line, those directories
will be distributed instead of the current directory.  Any file or directory
names are first converted to absolute pathnames on the local machine
before being distributed.
.Pp
The options are:
.Bl -tag -width MMM
.It Fl A
Distribute worldwide by first distributing to ``dist-os-rel-arch-masters''
and then running the same
.Nm
command on each of them.
.It Fl D
The following argument is used as the destination directory.
This causes relocation of the directory that's being distributed,
so care is advised when using this option.
.It Fl M
The following argument is the maximum number of parallel processes
spawned by
.Xr rdist 1 .
.It Fl R
Remove extraneous files.
.It Fl S
Use
.Xr srsh 1
to create connections to remote hosts.
.It Fl c
Leave out the
.Ar rel
component from the netgroup name. This can be used to distribute files
common to different releases of an operating system. See also
.Fl g .
.It Fl d
The following argument sets a variable.
.It Fl f
The following argument specifies a file listing the hosts or netgroups
to use in place of the default netgroup.
.It Fl g
Leave out the
.Ar arch
component from the netgroup name. This can be used to distribute files
common to different architectures of an operating system. See also
.Fl c .
.It Fl h
The following argument specifies a host or netgroup
to use in place of the default netgroup.
.It Fl n
Only check the distfile, do not run
.Xr rdist 1 .
.It Fl l
The following argument is the logging options described in
.Xr rdist 1 .
.It Fl o
The following argument sets various long options, see the
.Xr rdist 1
manual page.
.It Fl q
Run
.Xr rdist 1
in quiet mode.  Do not display the files being updated.
.It Fl r
Convenience alias for
.Fl R .
.It Fl s
Convenience alias for
.Fl S .
.It Fl t
The following argument is used as a timeout passed to
.Xr rdist 1
(which defaults to 900 seconds).  The default timeout in
.Nm
is 120 seconds.
.It Fl v
Dummy run -- do not really update or install the files, just print
what would happen.
.It Fl x
The following argument adds an additional clause to the generated
distfile, see the
.Xr rdist 1
manual page.
.It Fl y
Run
.Xr rdist 1
in younger mode.  Do not update remote copies that are
younger than the master copy, but issue a warning message instead.
.It Fl z
Use compression on the transferred data (good for slow links).
.El
.Sh FILES
.Bl -item -width SetcSrdistDconf
.It 
.Pa /etc/sdist.conf
.El
.Sh SEE ALSO
.Xr osname 1 ,
.Xr rdist 1 ,
.Xr ssync 1 ,
.Xr srsh 1 ,
.Xr uname 1
.Sh AUTHORS
David Siegel, Mark Moraes, Kimmo Suominen and Christos Zoulas.
