/* nbname.c - tool to find NetBIOS name via direct connects to port 137/udp

   Copyright (C) 2000  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define HEADERLEN 13

#define NEWUID	65534	/* someone other than root */

struct nmbhdr {
	unsigned short int id;

	unsigned char  R:1;
	unsigned char  opcode:4;
	unsigned char  AA:1;
	unsigned char  TC:1;
	unsigned char  RD:1;
	unsigned char  RA:1;
	unsigned char  unless:2;
	unsigned char  B:1;
	unsigned char  RCODE:4;

	unsigned short int qnum;
	unsigned short int rnum;
	unsigned short int num_rr;
	unsigned short int num_rrsup;
	unsigned char namelen;
};

struct ntypes {
	u_int	type;
	u_int	type2;
};

unsigned int resolve (char *host)
{
	struct	sockaddr_in	sin;
	struct	hostent		*he;

	he = gethostbyname (host);
	if (!he)
		return 0;

	bzero ((char *) &sin, sizeof(sin));
	bcopy (he->h_addr, (char *) &sin.sin_addr, he->h_length);

	return (sin.sin_addr.s_addr);
}

void display (char *ip, char *hn, char *wg)
{
	int	i;

	for (i = strlen(hn); i > 0; i--) {
		if (!isspace(hn[i-1])) {
			hn[i] = '\0';
			break;
		}
	}

	for (i = strlen(wg); i > 0; i--) {
		if (!isspace(wg[i-1])) {
			wg[i] = '\0';
			break;
		}
	}

	if (strlen(wg) > 2)
		printf ("NetBIOS name of %s is %s (in workgroup %s)\n",
		        ip, hn, wg);
	else
		printf ("NetBIOS name of %s is %s\n",
		        ip, hn);
}

void droproot(void)
{
	int	ret;

	/* first see if there's anything to do */
	if (getuid() != 0)
		return;

	ret = setuid(NEWUID);

	if (ret < 0) {
		perror("setuid");
		exit(0);
	}
}

int main(int argc, char **argv)
{
	struct	nmbhdr	*nmb;
	struct	ntypes	*ntype;

	fd_set	rfds;
	struct	timeval	tv;

	struct	sockaddr_in	local, server;
	char	*probe, buf[1024];
	int	ret, sfd, fromlen;

	if (argc < 2) {
	        printf("usage: %s <ip>\n", argv[0]);
	        exit(0);
        }

	probe = argv[1];

	bzero((char *) &local, sizeof(local));
	local.sin_family = AF_INET;
	local.sin_port = htons(137);

	sfd = socket(AF_INET, SOCK_DGRAM, 0);

	if (sfd < 0) {
		perror("socket");
		exit(1);
	}

	/* try binding to local port 137/udp while we might still have root */
	ret = bind(sfd, (struct sockaddr *) &local, sizeof(local));

	/* no longer needed */
	droproot();

	/* if that failed, we didn't have root anyway, so try a normal port */
	if ((ret < 0) && (errno == EACCES)) {
		bzero((char *) &local, sizeof(local));
		local.sin_family = AF_INET;
		local.sin_port = htons (INADDR_ANY);
		ret = bind(sfd, (struct sockaddr *) &local, sizeof(local));
	}

	if (ret < 0) {
		perror ("bind");
		exit (1);
	}

	bzero((char *) &server, sizeof(server));
	server.sin_family = AF_INET;
	server.sin_port = htons(137);
	server.sin_addr.s_addr = resolve(probe);

	memset (buf, '\0', sizeof(buf));
	memcpy (&buf[HEADERLEN], "CKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA\0", 33);

	nmb = (struct nmbhdr *) buf;
	nmb->id=0x003;
	nmb->R = 0;			/* 0 = question, 1 = response */
	nmb->opcode = 0;		/* 0 = query */
	nmb->qnum = htons(1);		/* 1 question */
	nmb->namelen=0x20;

	ntype = (struct ntypes *) (buf + HEADERLEN + 33);
	ntype->type = 0x2100;
	ntype->type2 = 0x1000;

	ret = sendto (sfd, buf, 50, 0, (struct sockaddr *) &server,
	              sizeof (struct sockaddr_in));

	FD_ZERO(&rfds);
	FD_SET(sfd, &rfds);

	tv.tv_sec = 1;
	tv.tv_usec = 0;

	ret = select(sfd + 1, &rfds, NULL, NULL, &tv);

	if (ret != 0) {
		if (FD_ISSET(sfd, &rfds)) {
			fromlen = sizeof(struct sockaddr);
			ret = recvfrom(sfd, buf, sizeof(buf), 0, 
			     (struct sockaddr *) &server, &fromlen);
		}
		else {
			fprintf(stderr, "select barfed\n");
			exit(1);
		}

		if (ret > 0) {
			buf[72] = '\0';
			buf[143] = '\0';
			display(probe, &buf[57], &buf[129]);
			return 0;
		}

		perror("recvfrom");
		exit(1);
	}

	if (ret == 0) {
		fprintf(stderr, "Request timed out\n");
		exit(1);
	}

	perror("select");
	exit(1);
}
