#ifndef _INCLUDE_MAIN_H_
#define _INCLUDE_MAIN_H_

/* System dependent */
#ifdef __linux__
#define _GNU_SOURCE
#endif
/* IO includes */
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <errno.h>
/* System includes */
#include <pwd.h>
#include <grp.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/param.h>
/* Bits & types */
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/resource.h>
/* Network */
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
/* Limits */
#include <limits.h>
#include <sys/param.h>
/* dlOpen */
#if DLOPEN
#include <dlfcn.h>
#endif
/* boolean emu */
#include "bool.h"
/* SSL */
#if USESSL
#include <openssl/ssl.h>
#include <openssl/err.h>
#endif
/* POLL */
#if POLL
#include <poll.h>
#endif

// Portable tips
#if defined(__SVR4) && defined (__sun)
#define __solaris__ 1
#endif

#define loop_t register int

extern char **environ;
extern char **av;

typedef enum 
{ _UID=0,   _EUID,   _GID,    _EGID,
  _PRIO,    _MAXTHR, _MAXCPU, _MAXMEM,
  _TIMEOUT, _EXECTIMEOUT, _HEADS,
  V_LASTONE } vint; /* variable: V */

enum 
{ _CHDIR=0, _CHROOT, _EXEC, _LOGFILE,
  _LOGSTR, _ERRFILE, 
#if USESSL
  _SSLKEY, _SSLCRT,
#endif
  S_LASTONE } ; /* variable: S */

enum /* Verbose Levels */
{
	V_NONE=0,
	V_MINI,
	V_LOAD,
	V_SHOW,
	V_EXEC,
	V_SSL,
	V_FULL
};

/* IO */
enum
{
	IO_DIRECT,
	IO_POLL,
	IO_BUFFER,
	IO_SELECT
};

/* Write Common struct */

struct Listen {
	vint  V[V_LASTONE], /* main thread */
	      V2[V_LASTONE]; /* each new conn */
	char *S[S_LASTONE];
	char *S2[S_LASTONE];
	char *name,*ip;
	int port, family, s;
	pid_t pid;
	int nenv; /* Number of envs */
	char **envkey,**envval;
#if USESSL
	bool usessl;
	SSL_CTX *ctx;
#endif
};

struct Svr {
   char v,          /* Verbose level */
	whitespace, /* whitespace char */
	backlog;    /* Default backlog */
   bool strict,    noupdir, noargs,  falsetimeout,
        notimeout, nolock, io,
	nologs, enc, resolv, signal;
   int httplen, usleep, keep;
   vint  V[V_LASTONE];
   char *S[S_LASTONE];
   int l;    /* number of listens */
   struct Listen *Lis;
   bool ok;
   int nenv;
   char **envkey,**envval;
};

extern int forks; /* Fork Counter : defined@Engine.c*/
extern struct Svr Svr;

#endif


